/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.connection.IIoHandlerCallback;
import org.xsocket.connection.IoChainableHandler;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.IoSocketHandler;

final class IoThrottledReadHandler
extends IoChainableHandler {
    private static final Logger LOG = Logger.getLogger(IoThrottledReadHandler.class.getName());
    private static final int CHECK_PERIOD_MILLIS = 500;
    private final IOEventHandler ioEventHandler = new IOEventHandler();
    private int readBytesPerSec = Integer.MAX_VALUE;
    private final AtomicInteger currentReceived = new AtomicInteger();
    private TimerTask readControlTask = new ReadControlTask(this);
    private boolean isSuspended = false;
    private int orgReadBufferSize = 0;

    IoThrottledReadHandler(IoChainableHandler successor) {
        super(successor);
        IoProvider.getTimer().schedule(this.readControlTask, 500L, 500L);
    }

    public void init(IIoHandlerCallback callbackHandler) throws IOException {
        this.setPreviousCallback(callbackHandler);
        this.getSuccessor().init(this.ioEventHandler);
        this.orgReadBufferSize = (Integer)this.getSuccessor().getOption("SOL_SOCKET.SO_RCVBUF");
        this.getSocketHandler().setRetryRead(false);
    }

    public boolean reset() {
        block3: {
            this.readBytesPerSec = Integer.MAX_VALUE;
            if (this.readControlTask != null) {
                this.readControlTask.cancel();
                this.readControlTask = null;
            }
            this.getSocketHandler().setRetryRead(true);
            try {
                this.getSuccessor().setOption("SOL_SOCKET.SO_RCVBUF", this.orgReadBufferSize);
                this.getSuccessor().resumeRead();
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.fine("Error occured by resuming read " + ioe.toString());
            }
        }
        return super.reset();
    }

    void setReadRateSec(int readRateSec) throws IOException {
        if (readRateSec < this.orgReadBufferSize) {
            this.getSuccessor().setOption("SOL_SOCKET.SO_RCVBUF", readRateSec);
        } else {
            this.getSuccessor().setOption("SOL_SOCKET.SO_RCVBUF", this.orgReadBufferSize);
        }
        this.readBytesPerSec = readRateSec;
    }

    public void close(boolean immediate) throws IOException {
        if (!immediate) {
            this.flushOutgoing();
        }
        this.getSuccessor().close(immediate);
    }

    public void write(ByteBuffer[] buffers) throws ClosedChannelException, IOException {
        this.getSuccessor().write(buffers);
    }

    public void flushOutgoing() throws IOException {
        this.getSuccessor().flushOutgoing();
    }

    public void setPreviousCallback(IIoHandlerCallback callbackHandler) {
        super.setPreviousCallback(callbackHandler);
        this.getSuccessor().setPreviousCallback(this.ioEventHandler);
    }

    private IoSocketHandler getSocketHandler() {
        IoChainableHandler successor = this;
        do {
            if ((successor = this.getSuccessor()) == null || !(successor instanceof IoSocketHandler)) continue;
            return (IoSocketHandler)successor;
        } while (successor != null);
        return null;
    }

    private final class IOEventHandler
    implements IIoHandlerCallback {
        private IOEventHandler() {
        }

        public void onData(ByteBuffer[] data) {
            int read = 0;
            for (ByteBuffer byteBuffer : data) {
                read += byteBuffer.remaining();
            }
            IoThrottledReadHandler.this.currentReceived.addAndGet(read);
            IoThrottledReadHandler.this.getPreviousCallback().onData(data);
        }

        public void onConnect() {
            IoThrottledReadHandler.this.getPreviousCallback().onConnect();
        }

        public void onWriteException(IOException ioException, ByteBuffer data) {
            IoThrottledReadHandler.this.getPreviousCallback().onWriteException(ioException, data);
        }

        public void onWritten(ByteBuffer data) {
            IoThrottledReadHandler.this.getPreviousCallback().onWritten(data);
        }

        public void onDisconnect() {
            IoThrottledReadHandler.this.getPreviousCallback().onDisconnect();
        }

        public void onConnectionAbnormalTerminated() {
            IoThrottledReadHandler.this.getPreviousCallback().onConnectionAbnormalTerminated();
        }
    }

    private static final class ReadControlTask
    extends TimerTask {
        private WeakReference<IoThrottledReadHandler> ioThrottledReadHandlerRef = null;
        private int outstanding = 0;

        public ReadControlTask(IoThrottledReadHandler ioThrottledReadHandler) {
            this.ioThrottledReadHandlerRef = new WeakReference<IoThrottledReadHandler>(ioThrottledReadHandler);
        }

        public void run() {
            block15: {
                IoThrottledReadHandler ioThrottledReadHandler = (IoThrottledReadHandler)this.ioThrottledReadHandlerRef.get();
                if (ioThrottledReadHandler == null) {
                    this.cancel();
                } else {
                    this.outstanding += ioThrottledReadHandler.currentReceived.getAndSet(0);
                    if (this.outstanding > 0) {
                        double periodSec = 0.5;
                        int delta = (int)((double)ioThrottledReadHandler.readBytesPerSec * periodSec);
                        this.outstanding -= delta;
                    }
                    if (this.outstanding < 0) {
                        this.outstanding = 0;
                    }
                    if (this.outstanding > 0) {
                        if (!ioThrottledReadHandler.isSuspended) {
                            try {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.fine("suspending read");
                                }
                                ioThrottledReadHandler.getSuccessor().suspendRead();
                                ioThrottledReadHandler.isSuspended = true;
                            }
                            catch (IOException ioe) {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.fine("Error occured by suspendig read " + ioe.toString());
                                }
                            }
                        }
                    } else if (ioThrottledReadHandler.isSuspended) {
                        try {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("resuming read");
                            }
                            ioThrottledReadHandler.getSuccessor().resumeRead();
                            ioThrottledReadHandler.isSuspended = false;
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block15;
                            LOG.fine("Error occured by resuming read " + ioe.toString());
                        }
                    }
                }
            }
        }
    }
}

