/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.ReadQueue;
import org.xsocket.connection.WriteQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNonBlockingStream
implements WritableByteChannel,
Closeable {
    private static Logger LOG = Logger.getLogger(AbstractNonBlockingStream.class.getName());
    private ReadQueue readQueue = new ReadQueue();
    private WriteQueue writeQueue = new WriteQueue();
    private String defaultEncoding = "UTF-8";
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private boolean autoflush = true;
    private IConnection.FlushMode flushmode = IConnection.DEFAULT_FLUSH_MODE;
    private Object attachment = null;

    @Override
    public void close() throws IOException {
        this.isOpen.set(false);
    }

    private void closeSilence() {
        block2: {
            try {
                this.close();
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by closing connection " + this + " " + ioe.toString());
            }
        }
    }

    public final void setAttachment(Object obj) {
        this.attachment = obj;
    }

    public final Object getAttachment() {
        return this.attachment;
    }

    public final void setEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public final String getEncoding() {
        return this.defaultEncoding;
    }

    public void setFlushmode(IConnection.FlushMode flushMode) {
        this.flushmode = flushMode;
    }

    public final IConnection.FlushMode getFlushmode() {
        return this.flushmode;
    }

    protected int getWriteTransferChunkeSize() {
        return 8196;
    }

    public final void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    public final boolean isAutoflush() {
        return this.autoflush;
    }

    protected abstract boolean isMoreInputDataExpected();

    protected abstract boolean isDataWriteable();

    public int indexOf(String str) throws IOException, ClosedChannelException {
        return this.indexOf(str, this.getEncoding());
    }

    public int indexOf(String str, String encoding) throws IOException, ClosedChannelException {
        this.ensureStreamIsOpen();
        return this.readQueue.retrieveIndexOf(str.getBytes(encoding), Integer.MAX_VALUE);
    }

    public int available() throws IOException {
        if (!this.isOpen.get()) {
            return -1;
        }
        int size = this.readQueue.getSize();
        if (size == 0) {
            if (this.isMoreInputDataExpected()) {
                return 0;
            }
            return -1;
        }
        return size;
    }

    protected int getReadQueueSize() {
        return this.readQueue.getSize();
    }

    public int getReadBufferVersion() {
        return this.readQueue.geVersion();
    }

    protected void onPostRead() throws IOException {
    }

    public byte readByte() throws IOException, BufferUnderflowException, ClosedChannelException {
        byte b = this.readSingleByteBuffer(1).get();
        this.onPostRead();
        return b;
    }

    public short readShort() throws IOException, BufferUnderflowException, ClosedChannelException {
        short s = this.readSingleByteBuffer(2).getShort();
        this.onPostRead();
        return s;
    }

    public int readInt() throws IOException, BufferUnderflowException, ClosedChannelException {
        int i = this.readSingleByteBuffer(4).getInt();
        this.onPostRead();
        return i;
    }

    public long readLong() throws IOException, BufferUnderflowException, ClosedChannelException {
        long l = this.readSingleByteBuffer(8).getLong();
        this.onPostRead();
        return l;
    }

    public double readDouble() throws IOException, BufferUnderflowException, ClosedChannelException {
        double d = this.readSingleByteBuffer(8).getDouble();
        this.onPostRead();
        return d;
    }

    public int read(ByteBuffer buffer) throws IOException, ClosedChannelException {
        this.ensureStreamIsOpen();
        int size = buffer.remaining();
        int available = this.available();
        if (available == 0 && !this.isMoreInputDataExpected()) {
            this.closeSilence();
            return -1;
        }
        if (available < size) {
            size = available;
        }
        if (size > 0) {
            this.copyBuffers(this.readByteBufferByLength(size), buffer);
        }
        if (size == -1) {
            this.closeSilence();
        }
        this.onPostRead();
        return size;
    }

    private void copyBuffers(ByteBuffer[] source, ByteBuffer target) {
        for (ByteBuffer buf : source) {
            if (!buf.hasRemaining()) continue;
            target.put(buf);
        }
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, BufferUnderflowException, ClosedChannelException {
        ByteBuffer[] buffers = this.readByteBufferByDelimiter(delimiter, this.getEncoding());
        this.onPostRead();
        return buffers;
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException, ClosedChannelException {
        ByteBuffer[] buffers = this.readByteBufferByDelimiter(delimiter, this.getEncoding(), maxLength);
        this.onPostRead();
        return buffers;
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException, ClosedChannelException {
        ByteBuffer[] buffers = this.readByteBufferByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
        this.onPostRead();
        return buffers;
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException, ClosedChannelException {
        this.ensureStreamIsOpen();
        try {
            ByteBuffer[] buffers = this.readQueue.readByteBufferByDelimiter(delimiter.getBytes(encoding), maxLength);
            this.onPostRead();
            return buffers;
        }
        catch (MaxReadSizeExceededException mre) {
            if (this.isMoreInputDataExpected()) {
                throw mre;
            }
            this.closeSilence();
            throw new ClosedChannelException();
        }
        catch (BufferUnderflowException bue) {
            if (this.isMoreInputDataExpected()) {
                throw bue;
            }
            this.closeSilence();
            throw new ClosedChannelException();
        }
    }

    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, BufferUnderflowException, ClosedChannelException {
        this.ensureStreamIsOpen();
        if (length <= 0) {
            if (!this.isMoreInputDataExpected()) {
                this.closeSilence();
                throw new ClosedChannelException();
            }
            this.onPostRead();
            return new ByteBuffer[0];
        }
        try {
            ByteBuffer[] buffers = this.readQueue.readByteBufferByLength(length);
            this.onPostRead();
            return buffers;
        }
        catch (BufferUnderflowException bue) {
            if (this.isMoreInputDataExpected()) {
                throw bue;
            }
            this.closeSilence();
            throw new ClosedChannelException();
        }
    }

    public byte[] readBytesByDelimiter(String delimiter) throws IOException, BufferUnderflowException, ClosedChannelException {
        byte[] bytes = this.readBytesByDelimiter(delimiter, this.getEncoding());
        this.onPostRead();
        return bytes;
    }

    public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException, ClosedChannelException {
        byte[] bytes = this.readBytesByDelimiter(delimiter, this.getEncoding(), maxLength);
        this.onPostRead();
        return bytes;
    }

    public byte[] readBytesByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException, ClosedChannelException {
        byte[] bytes = this.readBytesByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
        this.onPostRead();
        return bytes;
    }

    public byte[] readBytesByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException, ClosedChannelException {
        byte[] bytes = DataConverter.toBytes(this.readByteBufferByDelimiter(delimiter, encoding, maxLength));
        this.onPostRead();
        return bytes;
    }

    public byte[] readBytesByLength(int length) throws IOException, BufferUnderflowException, ClosedChannelException {
        byte[] bytes = DataConverter.toBytes(this.readByteBufferByLength(length));
        this.onPostRead();
        return bytes;
    }

    public String readStringByDelimiter(String delimiter) throws IOException, BufferUnderflowException, UnsupportedEncodingException, ClosedChannelException {
        String s = this.readStringByDelimiter(delimiter, Integer.MAX_VALUE);
        this.onPostRead();
        return s;
    }

    public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException, ClosedChannelException {
        String s = this.readStringByDelimiter(delimiter, this.getEncoding(), maxLength);
        this.onPostRead();
        return s;
    }

    public String readStringByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException, ClosedChannelException {
        String s = this.readStringByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
        this.onPostRead();
        return s;
    }

    public String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException, ClosedChannelException {
        String s = DataConverter.toString(this.readByteBufferByDelimiter(delimiter, encoding, maxLength), encoding);
        this.onPostRead();
        return s;
    }

    public String readStringByLength(int length) throws IOException, BufferUnderflowException, UnsupportedEncodingException, ClosedChannelException {
        String s = this.readStringByLength(length, this.getEncoding());
        this.onPostRead();
        return s;
    }

    public String readStringByLength(int length, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException, ClosedChannelException {
        String s = DataConverter.toString(this.readByteBufferByLength(length), encoding);
        this.onPostRead();
        return s;
    }

    public long transferTo(WritableByteChannel target, int length) throws IOException, ClosedChannelException, BufferUnderflowException, ClosedChannelException {
        if (length > 0) {
            ByteBuffer[] buffers;
            long written = 0L;
            for (ByteBuffer buffer : buffers = this.readByteBufferByLength(length)) {
                while (buffer.hasRemaining()) {
                    written += (long)target.write(buffer);
                }
            }
            this.onPostRead();
            return written;
        }
        this.onPostRead();
        return 0L;
    }

    protected ByteBuffer readSingleByteBuffer(int length) throws IOException, ClosedChannelException, BufferUnderflowException, ClosedChannelException {
        this.ensureStreamIsOpen();
        try {
            ByteBuffer buffer = this.readQueue.readSingleByteBuffer(length);
            this.onPostRead();
            return buffer;
        }
        catch (BufferUnderflowException bue) {
            if (this.isMoreInputDataExpected()) {
                throw bue;
            }
            this.closeSilence();
            throw new ClosedChannelException();
        }
    }

    public final int write(byte b) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        this.writeQueue.append(DataConverter.toByteBuffer(b));
        this.onWriteDataInserted();
        return 1;
    }

    public final int write(byte ... bytes) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        if (bytes.length > 0) {
            this.writeQueue.append(DataConverter.toByteBuffer(bytes));
            this.onWriteDataInserted();
            return bytes.length;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("warning length of byte array to send is 0");
        }
        return 0;
    }

    public final int write(byte[] bytes, int offset, int length) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        if (bytes.length > 0) {
            ByteBuffer buffer = DataConverter.toByteBuffer(bytes, offset, length);
            int written = buffer.remaining();
            this.writeQueue.append(buffer);
            this.onWriteDataInserted();
            return written;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("warning length of buffer array to send is 0");
        }
        return 0;
    }

    public final int write(short s) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        this.writeQueue.append(DataConverter.toByteBuffer(s));
        this.onWriteDataInserted();
        return 2;
    }

    public final int write(int i) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        this.writeQueue.append(DataConverter.toByteBuffer(i));
        this.onWriteDataInserted();
        return 4;
    }

    public final int write(long l) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        this.writeQueue.append(DataConverter.toByteBuffer(l));
        this.onWriteDataInserted();
        return 8;
    }

    public final int write(double d) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        this.writeQueue.append(DataConverter.toByteBuffer(d));
        this.onWriteDataInserted();
        return 8;
    }

    public final int write(String message) throws IOException, BufferOverflowException, ClosedChannelException {
        return this.write(message, this.getEncoding());
    }

    public final int write(String message, String encoding) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        ByteBuffer buffer = DataConverter.toByteBuffer(message, encoding);
        int written = buffer.remaining();
        this.writeQueue.append(buffer);
        this.onWriteDataInserted();
        return written;
    }

    public final long write(List<ByteBuffer> buffers) throws IOException, BufferOverflowException, ClosedChannelException {
        if (buffers == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("warning buffer list to send is null");
            }
            return 0L;
        }
        return this.write(buffers.toArray(new ByteBuffer[buffers.size()]));
    }

    public final long write(ByteBuffer[] srcs, int offset, int length) throws IOException, ClosedChannelException {
        if (srcs == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("warning buffer array to send is null");
            }
            return 0L;
        }
        return this.write(DataConverter.toByteBuffers(srcs, offset, length));
    }

    public final long write(ByteBuffer[] buffers) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        if (buffers == null || buffers.length == 0) {
            return 0L;
        }
        long written = 0L;
        for (ByteBuffer buffer : buffers) {
            int size = buffer.remaining();
            this.onPreWrite(size);
            this.writeQueue.append(buffer);
            written += (long)size;
            this.onWriteDataInserted();
        }
        return written;
    }

    @Override
    public final int write(ByteBuffer buffer) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        if (buffer == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("warning buffer is null");
            }
            return 0;
        }
        int size = buffer.remaining();
        this.onPreWrite(size);
        this.writeQueue.append(buffer);
        this.onWriteDataInserted();
        return size;
    }

    protected void onPreWrite(int size) throws BufferOverflowException {
    }

    public final long transferFrom(FileChannel fileChannel) throws ClosedChannelException, IOException, SocketTimeoutException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        if (this.getFlushmode() == IConnection.FlushMode.SYNC) {
            MappedByteBuffer buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
            return this.write(buffer);
        }
        return this.transferFrom((ReadableByteChannel)fileChannel);
    }

    public long transferFrom(ReadableByteChannel source) throws IOException, BufferOverflowException, ClosedChannelException {
        return this.transferFrom(source, this.getWriteTransferChunkeSize());
    }

    public final long transferFrom(ReadableByteChannel source, int chunkSize) throws IOException, BufferOverflowException, ClosedChannelException {
        return this.transfer(source, this, chunkSize);
    }

    private long transfer(ReadableByteChannel source, WritableByteChannel target, int chunkSize) throws IOException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        long transfered = 0L;
        int read = 0;
        do {
            ByteBuffer transferBuffer;
            if ((read = source.read(transferBuffer = ByteBuffer.allocate(chunkSize))) <= 0) continue;
            if (transferBuffer.remaining() == 0) {
                transferBuffer.flip();
                target.write(transferBuffer);
            } else {
                transferBuffer.flip();
                target.write(transferBuffer.slice());
            }
            transfered += (long)read;
        } while (read > 0);
        return transfered;
    }

    public final void markReadPosition() {
        this.readQueue.markReadPosition();
    }

    public final void markWritePosition() {
        if (this.isAutoflush()) {
            throw new UnsupportedOperationException("write mark is only supported for mode autoflush off");
        }
        this.writeQueue.markWritePosition();
    }

    public final boolean resetToWriteMark() {
        return this.writeQueue.resetToWriteMark();
    }

    public final boolean resetToReadMark() {
        return this.readQueue.resetToReadMark();
    }

    public final void removeReadMark() {
        this.readQueue.removeReadMark();
    }

    public final void removeWriteMark() {
        this.writeQueue.removeWriteMark();
    }

    protected boolean reset() {
        this.readQueue.reset();
        this.writeQueue.reset();
        this.defaultEncoding = "UTF-8";
        this.autoflush = true;
        this.flushmode = IConnection.DEFAULT_FLUSH_MODE;
        this.attachment = null;
        return true;
    }

    protected void onWriteDataInserted() throws IOException, ClosedChannelException {
    }

    protected final int getWriteBufferSize() {
        return this.writeQueue.getSize();
    }

    protected final boolean isWriteBufferEmpty() {
        return this.writeQueue.isEmpty();
    }

    protected ByteBuffer[] drainWriteQueue() {
        return this.writeQueue.drain();
    }

    protected final boolean isReadBufferEmpty() {
        return this.readQueue.isEmpty();
    }

    protected final void appendDataToReadBuffer(ByteBuffer[] data, int size) {
        this.readQueue.append(data, size);
        this.onPostAppend();
    }

    protected final void appendDataToReadBuffer(ByteBuffer[] data) {
        int size = 0;
        for (ByteBuffer byteBuffer : data) {
            size += byteBuffer.remaining();
        }
        this.appendDataToReadBuffer(data, size);
    }

    protected void onPostAppend() {
    }

    protected final String printReadBuffer(String encoding) {
        return this.readQueue.asString(encoding);
    }

    protected final String printWriteBuffer(String encoding) {
        return this.writeQueue.asString(encoding);
    }

    private void ensureStreamIsOpen() throws ClosedChannelException {
        if (!this.isOpen.get()) {
            throw new ClosedChannelException();
        }
    }

    private void ensureStreamIsOpenAndWritable() throws ClosedChannelException {
        if (!this.isOpen.get()) {
            throw new ClosedChannelException();
        }
        if (!this.isDataWriteable()) {
            this.closeSilence();
            throw new ClosedChannelException();
        }
    }
}

