/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.Resource;
import org.xsocket.connection.ConnectionPoolMBeanProxyFactory;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnectionPool;
import org.xsocket.connection.IConnectionScoped;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IServer;
import org.xsocket.connection.IServerListener;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.ServerMBeanProxyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionUtils {
    private static final Logger LOG = Logger.getLogger(ConnectionUtils.class.getName());
    public static final String DEFAULT_DOMAIN = "org.xsocket.connection";
    public static final String SERVER_TRHREAD_PREFIX = "xServer";
    private static final IoProvider IO_PROVIDER = new IoProvider();
    private static final Map<Class, HandlerInfo> handlerInfoCache = ConnectionUtils.newMapCache(25);
    private static String implementationVersion = null;
    private static String implementationDate = null;

    private ConnectionUtils() {
    }

    static IoProvider getIoProvider() {
        return IO_PROVIDER;
    }

    public static int validateSufficientDatasizeByIntLengthField(INonBlockingConnection connection) throws IOException, BufferUnderflowException {
        connection.resetToReadMark();
        connection.markReadPosition();
        int length = connection.readInt();
        if (connection.available() < length) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "]insufficient data. require " + length + " got " + connection.available());
            }
            throw new BufferUnderflowException();
        }
        connection.removeReadMark();
        return length;
    }

    public static int validateSufficientDatasizeByIntLengthField(INonBlockingConnection connection, boolean removeLengthField) throws IOException, BufferUnderflowException {
        connection.resetToReadMark();
        connection.markReadPosition();
        int length = connection.readInt();
        if (connection.available() < length) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "]insufficient data. require " + length + " got " + connection.available());
            }
            throw new BufferUnderflowException();
        }
        if (!removeLengthField) {
            connection.resetToReadMark();
        }
        connection.removeReadMark();
        return length;
    }

    public static void start(IServer server) throws SocketTimeoutException {
        ConnectionUtils.start(server, 60);
    }

    public static void start(IServer server, int timeoutSec) throws SocketTimeoutException {
        final CountDownLatch startedSignal = new CountDownLatch(1);
        IServerListener startupListener = new IServerListener(){

            public void onInit() {
                startedSignal.countDown();
            }

            public void onDestroy() {
            }
        };
        server.addListener(startupListener);
        Thread t = new Thread(server);
        t.setName(SERVER_TRHREAD_PREFIX);
        t.start();
        boolean isStarted = false;
        try {
            isStarted = startedSignal.await(timeoutSec, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("start signal doesn't occured. " + e.toString());
        }
        if (!isStarted) {
            throw new SocketTimeoutException("start timeout (" + DataConverter.toFormatedDuration((long)timeoutSec * 1000L) + ")");
        }
        t.setName("xServer:" + server.getLocalPort());
        server.removeListener(startupListener);
    }

    public static ObjectName registerMBean(IServer server) throws JMException {
        return ConnectionUtils.registerMBean(server, DEFAULT_DOMAIN);
    }

    public static ObjectName registerMBean(IServer server, String domain) throws JMException {
        return ConnectionUtils.registerMBean(server, domain, ManagementFactory.getPlatformMBeanServer());
    }

    public static ObjectName registerMBean(IServer server, String domain, MBeanServer mbeanServer) {
        try {
            return ServerMBeanProxyFactory.createAndRegister(server, domain, mbeanServer);
        }
        catch (Exception e) {
            throw new RuntimeException(DataConverter.toString(e));
        }
    }

    public static ObjectName registerMBean(IConnectionPool pool) throws JMException {
        return ConnectionUtils.registerMBean(pool, DEFAULT_DOMAIN);
    }

    public static ObjectName registerMBean(IConnectionPool pool, String domain) throws JMException {
        return ConnectionUtils.registerMBean(pool, domain, ManagementFactory.getPlatformMBeanServer());
    }

    public static ObjectName registerMBean(IConnectionPool pool, String domain, MBeanServer mbeanServer) throws JMException {
        return ConnectionPoolMBeanProxyFactory.createAndRegister(pool, domain, mbeanServer);
    }

    public static String getVersionInfo() {
        return ConnectionUtils.getImplementationVersion();
    }

    public static String getImplementationVersion() {
        if (implementationVersion == null) {
            ConnectionUtils.readVersionFile();
        }
        return implementationVersion;
    }

    public static String getImplementationDate() {
        if (implementationDate == null) {
            ConnectionUtils.readVersionFile();
        }
        return implementationDate;
    }

    private static void readVersionFile() {
        implementationVersion = "<unknown>";
        implementationDate = "<unknown>";
        try {
            InputStreamReader isr = new InputStreamReader(ConnectionUtils.class.getResourceAsStream("/org/xsocket/version.txt"));
            if (isr != null) {
                LineNumberReader lnr = new LineNumberReader(isr);
                String line = null;
                do {
                    if ((line = lnr.readLine()) == null) continue;
                    if (line.startsWith("Implementation-Version=")) {
                        implementationVersion = line.substring("Implementation-Version=".length(), line.length()).trim();
                        continue;
                    }
                    if (!line.startsWith("Implementation-Date=")) continue;
                    implementationDate = line.substring("Implementation-Date=".length(), line.length()).trim();
                } while (line != null);
                lnr.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T> Map<Class, T> newMapCache(int maxSize) {
        return Collections.synchronizedMap(new MapCache(maxSize));
    }

    static void injectServerField(IServer server, Object handler) {
        Field[] fields;
        for (Field field : fields = handler.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Resource.class)) continue;
            Resource res = field.getAnnotation(Resource.class);
            if (field.getType() != IServer.class && res.type() != IServer.class) continue;
            field.setAccessible(true);
            try {
                field.set(handler, server);
            }
            catch (IllegalAccessException iae) {
                LOG.warning("could not inject server for attribute " + field.getName() + ". Reason " + iae.toString());
            }
        }
    }

    static boolean isDispatcherThread() {
        return Thread.currentThread().getName().startsWith("xDispatcher");
    }

    static HandlerInfo getHandlerInfo(IHandler handler) {
        HandlerInfo handlerInfo = handlerInfoCache.get(handler.getClass());
        if (handlerInfo == null) {
            handlerInfo = new HandlerInfo(handler);
            handlerInfoCache.put(handler.getClass(), handlerInfo);
        }
        return handlerInfo;
    }

    private static boolean isMethodThreaded(Class clazz, String methodname, boolean dflt, Class ... paramClass) {
        try {
            Method meth = clazz.getMethod(methodname, paramClass);
            Execution execution = meth.getAnnotation(Execution.class);
            if (execution != null) {
                return execution.value() != 0;
            }
            return dflt;
        }
        catch (NoSuchMethodException nsme) {
            return dflt;
        }
    }

    private static boolean isHandlerMultithreaded(IHandler handler) {
        Execution execution = handler.getClass().getAnnotation(Execution.class);
        if (execution != null) {
            return execution.value() != 0;
        }
        return true;
    }

    static final class HandlerInfo {
        private boolean isConnectHandler = false;
        private boolean isDataHandler = false;
        private boolean isDisconnectHandler = false;
        private boolean isIdleTimeoutHandler = false;
        private boolean isConnectionTimeoutHandler = false;
        private boolean isLifeCycle = false;
        private boolean isConnectionScoped = false;
        private boolean isHandlerMultithreaded = false;
        private boolean isConnectHandlerMultithreaded = false;
        private boolean isDataHandlerMultithreaded = false;
        private boolean isDisconnectHandlerMultithreaded = false;
        private boolean isIdleTimeoutHandlerMultithreaded = false;
        private boolean isConnectionTimeoutHandlerMultithreaded = false;
        private boolean isNonThreaded = false;

        HandlerInfo(IHandler handler) {
            this.isConnectHandler = handler instanceof IConnectHandler;
            this.isDataHandler = handler instanceof IDataHandler;
            this.isDisconnectHandler = handler instanceof IDisconnectHandler;
            this.isIdleTimeoutHandler = handler instanceof IIdleTimeoutHandler;
            this.isConnectionTimeoutHandler = handler instanceof IConnectionTimeoutHandler;
            this.isLifeCycle = handler instanceof ILifeCycle;
            this.isConnectionScoped = handler instanceof IConnectionScoped;
            this.isHandlerMultithreaded = ConnectionUtils.isHandlerMultithreaded(handler);
            if (this.isConnectHandler) {
                this.isConnectHandlerMultithreaded = ConnectionUtils.isMethodThreaded(handler.getClass(), "onConnect", this.isHandlerMultithreaded, new Class[]{INonBlockingConnection.class});
            }
            if (this.isDataHandler) {
                this.isDataHandlerMultithreaded = ConnectionUtils.isMethodThreaded(handler.getClass(), "onData", this.isHandlerMultithreaded, new Class[]{INonBlockingConnection.class});
            }
            if (this.isDisconnectHandler) {
                this.isDisconnectHandlerMultithreaded = ConnectionUtils.isMethodThreaded(handler.getClass(), "onDisconnect", this.isHandlerMultithreaded, new Class[]{INonBlockingConnection.class});
            }
            if (this.isIdleTimeoutHandler) {
                this.isIdleTimeoutHandlerMultithreaded = ConnectionUtils.isMethodThreaded(handler.getClass(), "onIdleTimeout", this.isHandlerMultithreaded, new Class[]{INonBlockingConnection.class});
            }
            if (this.isConnectionTimeoutHandler) {
                this.isConnectionTimeoutHandlerMultithreaded = ConnectionUtils.isMethodThreaded(handler.getClass(), "onConnectionTimeout", this.isHandlerMultithreaded, new Class[]{INonBlockingConnection.class});
            }
            if (this.isConnectionTimeoutHandler) {
                this.isConnectHandlerMultithreaded = ConnectionUtils.isMethodThreaded(handler.getClass(), "onConnectionTimeout", this.isHandlerMultithreaded, new Class[]{INonBlockingConnection.class});
            }
            this.isNonThreaded = !this.isHandlerMultithreaded && !this.isConnectHandlerMultithreaded && !this.isDataHandlerMultithreaded && !this.isDisconnectHandlerMultithreaded && !this.isIdleTimeoutHandlerMultithreaded && !this.isConnectionTimeoutHandlerMultithreaded;
        }

        public boolean isConnectHandler() {
            return this.isConnectHandler;
        }

        public boolean isDataHandler() {
            return this.isDataHandler;
        }

        public boolean isDisconnectHandler() {
            return this.isDisconnectHandler;
        }

        public boolean isIdleTimeoutHandler() {
            return this.isIdleTimeoutHandler;
        }

        public boolean isConnectionTimeoutHandler() {
            return this.isConnectionTimeoutHandler;
        }

        public boolean isLifeCycle() {
            return this.isLifeCycle;
        }

        public boolean isConnectionScoped() {
            return this.isConnectionScoped;
        }

        public boolean isNonthreaded() {
            return this.isNonThreaded;
        }

        public boolean isHandlerMultithreaded() {
            return this.isHandlerMultithreaded;
        }

        public boolean isConnectHandlerMultithreaded() {
            return this.isConnectHandlerMultithreaded;
        }

        public boolean isDataHandlerMultithreaded() {
            return this.isDataHandlerMultithreaded;
        }

        public boolean isDisconnectHandlerMultithreaded() {
            return this.isDisconnectHandlerMultithreaded;
        }

        public boolean isIdleTimeoutHandlerMultithreaded() {
            return this.isIdleTimeoutHandlerMultithreaded;
        }

        public boolean isConnectionTimeoutHandlerMultithreaded() {
            return this.isConnectionTimeoutHandlerMultithreaded;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MapCache<T>
    extends LinkedHashMap<Class, T> {
        private static final long serialVersionUID = 4513864504007457500L;
        private int maxSize = 0;

        MapCache(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Class, T> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

