/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.NonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TimeoutManager {
    private static final Logger LOG = Logger.getLogger(TimeoutManager.class.getName());
    private final ArrayList<TimeoutMgmHandle> handles = new ArrayList();
    private static final long DEFAULT_WATCHDOG_PERIOD_MILLIS = 300000L;
    private long watchDogPeriod = 300000L;
    private TimerTask watchDogTask = null;
    private int countIdleTimeouts = 0;
    private int countConnectionTimeouts = 0;

    public TimeoutManager() {
        this.updateTimeoutCheckPeriod(300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeoutMgmHandle register(NonBlockingConnection connection) {
        TimeoutMgmHandle mgnCon = new TimeoutMgmHandle(this, connection);
        ArrayList<TimeoutMgmHandle> arrayList = this.handles;
        synchronized (arrayList) {
            this.handles.add(mgnCon);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("connection registered");
        }
        return mgnCon;
    }

    long getWatchDogPeriod() {
        return this.watchDogPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(TimeoutMgmHandle handle) {
        ArrayList<TimeoutMgmHandle> arrayList = this.handles;
        synchronized (arrayList) {
            this.handles.remove(handle);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("handle deregistered (connections size=" + this.handles.size() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<NonBlockingConnection> getConnections() {
        HashSet<NonBlockingConnection> cons = new HashSet<NonBlockingConnection>();
        ArrayList connectionsCopy = null;
        ArrayList<TimeoutMgmHandle> arrayList = this.handles;
        synchronized (arrayList) {
            connectionsCopy = (ArrayList)this.handles.clone();
        }
        for (TimeoutMgmHandle handle : connectionsCopy) {
            NonBlockingConnection con = handle.getConnection();
            if (con == null) continue;
            cons.add(con);
        }
        return cons;
    }

    void close() {
        if (this.watchDogTask != null) {
            this.watchDogTask.cancel();
        }
    }

    int getNumberOfIdleTimeouts() {
        return this.countIdleTimeouts;
    }

    int getNumberOfConnectionTimeouts() {
        return this.countConnectionTimeouts;
    }

    void updateTimeoutCheckPeriod(long requiredMinPeriod) {
        if (this.watchDogTask != null && this.watchDogPeriod <= requiredMinPeriod) {
            return;
        }
        this.watchDogPeriod = requiredMinPeriod;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("update watchdog period " + DataConverter.toFormatedDuration(this.watchDogPeriod));
        }
        if (this.watchDogTask != null) {
            this.watchDogTask.cancel();
        }
        this.watchDogTask = new TimerTask(){

            public void run() {
                TimeoutManager.this.checkTimeouts();
            }
        };
        IoProvider.getTimer().schedule(this.watchDogTask, this.watchDogPeriod, this.watchDogPeriod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkTimeouts() {
        block7: {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("checking timeouts");
            }
            try {
                long current = System.currentTimeMillis();
                ArrayList connectionsCopy = null;
                ArrayList<TimeoutMgmHandle> arrayList = this.handles;
                synchronized (arrayList) {
                    connectionsCopy = (ArrayList)this.handles.clone();
                }
                for (TimeoutMgmHandle handle : connectionsCopy) {
                    NonBlockingConnection con = handle.getConnection();
                    if (con == null) continue;
                    this.checkTimeout(con, current);
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.fine("error occured: " + e.toString());
            }
        }
    }

    private void checkTimeout(NonBlockingConnection connection, long current) {
        boolean timeoutOccured = connection.checkIdleTimeout(current);
        if (timeoutOccured) {
            ++this.countIdleTimeouts;
        }
        if (timeoutOccured = connection.checkConnectionTimeout(current)) {
            ++this.countConnectionTimeouts;
        }
    }

    static final class TimeoutMgmHandle {
        private TimeoutManager connectionManager;
        private NonBlockingConnection con;

        public TimeoutMgmHandle(TimeoutManager connectionManager, NonBlockingConnection connection) {
            this.connectionManager = connectionManager;
            this.con = connection;
        }

        void updateCheckPeriod(long period) {
            this.connectionManager.updateTimeoutCheckPeriod(period);
        }

        void destroy() {
            this.connectionManager.remove(this);
        }

        NonBlockingConnection getConnection() {
            if (!this.con.isOpen()) {
                this.destroy();
            }
            return this.con;
        }
    }
}

