/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.xsocket.connection.IIoHandlerCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class IoChainableHandler {
    private IoChainableHandler successor = null;
    private IoChainableHandler previous = null;
    private IIoHandlerCallback callback = null;
    private final ArrayList<ByteBuffer> outQueue = new ArrayList();

    public IoChainableHandler(IoChainableHandler successor) {
        this.setSuccessor(successor);
    }

    public abstract void init(IIoHandlerCallback var1) throws IOException;

    public abstract void close(boolean var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToWriteQueue(ByteBuffer[] buffers) {
        ArrayList<ByteBuffer> arrayList = this.outQueue;
        synchronized (arrayList) {
            this.outQueue.addAll(Arrays.asList(buffers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws ClosedChannelException, IOException {
        ArrayList<ByteBuffer> arrayList = this.outQueue;
        synchronized (arrayList) {
            this.write(this.outQueue.toArray(new ByteBuffer[this.outQueue.size()]));
            this.outQueue.clear();
        }
    }

    public abstract void write(ByteBuffer[] var1) throws ClosedChannelException, IOException;

    public abstract void flush() throws IOException;

    public final IoChainableHandler getSuccessor() {
        return this.successor;
    }

    protected final void setSuccessor(IoChainableHandler successor) {
        this.successor = successor;
        if (successor != null) {
            successor.setPrevious(this);
        }
    }

    protected final void setPrevious(IoChainableHandler previous) {
        this.previous = previous;
    }

    protected final IoChainableHandler getPrevious() {
        return this.previous;
    }

    public boolean reset() {
        IoChainableHandler successor = this.getSuccessor();
        if (successor != null) {
            return successor.reset();
        }
        return true;
    }

    public boolean isSecure() {
        IoChainableHandler successor = this.getSuccessor();
        if (successor != null) {
            return successor.isSecure();
        }
        return false;
    }

    public InetAddress getLocalAddress() {
        return this.getSuccessor().getLocalAddress();
    }

    public long getLastTimeReceivedMillis() {
        return this.getSuccessor().getLastTimeReceivedMillis();
    }

    public long getNumberOfReceivedBytes() {
        return this.getSuccessor().getNumberOfReceivedBytes();
    }

    public long getNumberOfSendBytes() {
        return this.getSuccessor().getNumberOfSendBytes();
    }

    public String getRegisteredOpsInfo() {
        return this.getSuccessor().getRegisteredOpsInfo();
    }

    public int getPendingWriteDataSize() {
        IoChainableHandler successor = this.getSuccessor();
        if (successor != null) {
            return successor.getPendingWriteDataSize();
        }
        return 0;
    }

    public boolean hasDataToSend() {
        IoChainableHandler successor = this.getSuccessor();
        if (successor != null) {
            return successor.hasDataToSend();
        }
        return false;
    }

    public void suspendRead() throws IOException {
        IoChainableHandler successor = this.getSuccessor();
        if (successor != null) {
            successor.suspendRead();
        }
    }

    public void resumeRead() throws IOException {
        IoChainableHandler successor = this.getSuccessor();
        if (successor != null) {
            successor.resumeRead();
        }
    }

    public boolean isReadSuspended() {
        IoChainableHandler successor = this.getSuccessor();
        return successor.isReadSuspended();
    }

    public void setRetryRead(boolean isRetryRead) {
        IoChainableHandler successor = this.getSuccessor();
        successor.setRetryRead(isRetryRead);
    }

    public String getId() {
        return this.getSuccessor().getId();
    }

    void setPreviousCallback(IIoHandlerCallback callback) {
        this.callback = callback;
    }

    IIoHandlerCallback getPreviousCallback() {
        return this.callback;
    }

    public int getLocalPort() {
        return this.getSuccessor().getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        return this.getSuccessor().getRemoteAddress();
    }

    public int getRemotePort() {
        return this.getSuccessor().getRemotePort();
    }

    public boolean isOpen() {
        return this.getSuccessor().isOpen();
    }

    public void setIdleTimeoutMillis(long timeout) {
        this.getSuccessor().setIdleTimeoutMillis(timeout);
    }

    public void setConnectionTimeoutMillis(long timeout) {
        this.getSuccessor().setConnectionTimeoutMillis(timeout);
    }

    public long getConnectionTimeoutMillis() {
        return this.getSuccessor().getConnectionTimeoutMillis();
    }

    public long getIdleTimeoutMillis() {
        return this.getSuccessor().getIdleTimeoutMillis();
    }

    public long getRemainingMillisToConnectionTimeout() {
        return this.getSuccessor().getRemainingMillisToConnectionTimeout();
    }

    public long getRemainingMillisToIdleTimeout() {
        return this.getSuccessor().getRemainingMillisToIdleTimeout();
    }

    public Object getOption(String name) throws IOException {
        return this.getSuccessor().getOption(name);
    }

    public Map<String, Class> getOptions() {
        return this.getSuccessor().getOptions();
    }

    public void setOption(String name, Object value) throws IOException {
        this.getSuccessor().setOption(name, value);
    }

    public abstract void hardFlush() throws IOException;

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "#" + this.hashCode());
        IoChainableHandler ioHandler = this;
        while (ioHandler.getPrevious() != null) {
            ioHandler = ioHandler.getPrevious();
        }
        String forwardChain = "";
        while (ioHandler != null) {
            forwardChain = forwardChain + ioHandler.getClass().getSimpleName() + " > ";
            ioHandler = ioHandler.getSuccessor();
        }
        forwardChain = forwardChain.trim();
        forwardChain = forwardChain.substring(0, forwardChain.length() - 1);
        sb.append(" (forward chain: " + forwardChain.trim() + ")");
        return sb.toString();
    }
}

