/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.connection.AbstractMemoryManager;
import org.xsocket.connection.IIoHandlerCallback;
import org.xsocket.connection.IoChainableHandler;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.IoQueue;
import org.xsocket.connection.IoSocketDispatcher;
import org.xsocket.connection.IoUnsynchronizedMemoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoSocketHandler
extends IoChainableHandler {
    private static final Logger LOG = Logger.getLogger(IoSocketHandler.class.getName());
    private static final SimpleDateFormat DF = new SimpleDateFormat("HH:mm:ss,S");
    private static final int MAXSIZE_LOG_READ = 2000;
    private static final Map<String, Class> SUPPORTED_OPTIONS = new HashMap<String, Class>();
    private boolean isConnected = false;
    private boolean isLogicalClosed = false;
    private boolean isDisconnect = false;
    private boolean isDetached = true;
    private SocketChannel channel = null;
    private IoSocketDispatcher dispatcher = null;
    private AbstractMemoryManager memoryManager = null;
    private final IoQueue sendQueue = new IoQueue();
    private int maxChunkSize = 0;
    private AbstractWriteTask writeTask = null;
    private String id = null;
    private boolean isRetryRead = true;
    private long openTime = -1L;
    private long lastTimeReceivedMillis = System.currentTimeMillis();
    private long receivedBytes = 0L;
    private long sendBytes = 0L;

    IoSocketHandler(SocketChannel channel, IoSocketDispatcher dispatcher, String connectionId) throws IOException {
        super(null);
        assert (channel != null);
        this.channel = channel;
        this.openTime = System.currentTimeMillis();
        channel.configureBlocking(false);
        this.dispatcher = dispatcher;
        this.id = connectionId;
        this.maxChunkSize = channel.socket().getSendBufferSize();
    }

    @Override
    public void init(IIoHandlerCallback callbackHandler) throws IOException, SocketTimeoutException {
        this.setPreviousCallback(callbackHandler);
        while (!this.getChannel().finishConnect()) {
            this.getChannel().configureBlocking(true);
            this.getChannel().finishConnect();
            this.getChannel().configureBlocking(false);
        }
        this.updateDispatcher(this.dispatcher);
    }

    private void updateDispatcher(IoSocketDispatcher dispatcher) throws IOException {
        this.dispatcher = dispatcher;
        dispatcher.register(this, 1);
    }

    @Override
    public void setRetryRead(boolean isRetryRead) {
        this.isRetryRead = isRetryRead;
    }

    @Override
    public boolean reset() {
        try {
            this.sendQueue.drain();
            this.resumeRead();
            return super.reset();
        }
        catch (Exception e) {
            return false;
        }
    }

    void setMemoryManager(AbstractMemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    boolean isDetached() {
        return this.isDetached;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getPendingWriteDataSize() {
        return this.sendQueue.getSize() + super.getPendingWriteDataSize();
    }

    @Override
    public boolean hasDataToSend() {
        return !this.sendQueue.isEmpty();
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public void setOption(String name, Object value) throws IOException {
        IoProvider.setOption(this.channel.socket(), name, value);
    }

    @Override
    public Object getOption(String name) throws IOException {
        return IoProvider.getOption(this.channel.socket(), name);
    }

    @Override
    public Map<String, Class> getOptions() {
        return Collections.unmodifiableMap(SUPPORTED_OPTIONS);
    }

    void checkConnection() {
        if (!this.channel.isOpen()) {
            this.getPreviousCallback().onConnectionAbnormalTerminated();
        }
    }

    void setDetached(boolean isDetached) {
        this.isDetached = isDetached;
    }

    void onRegisteredEvent() throws IOException {
        if (!this.isConnected) {
            this.isConnected = true;
            this.getPreviousCallback().onConnect();
        }
    }

    long onReadableEvent() throws IOException {
        assert (Thread.currentThread().getName().startsWith("xDispatcher")) : "receiveQueue can only be accessed by the dispatcher thread";
        long read = 0L;
        ByteBuffer[] received = this.readSocket();
        if (received != null) {
            int size = 0;
            for (ByteBuffer byteBuffer : received) {
                size += byteBuffer.remaining();
            }
            read += (long)size;
            this.getPreviousCallback().onData(received, size);
            this.getPreviousCallback().onPostData();
        }
        this.checkPreallocatedReadMemory();
        return read;
    }

    long onDirectUnregisteredWriteEvent() throws IOException {
        int sent = 0;
        sent = this.writeSocket();
        if (this.writeTask != null) {
            this.dispatcher.initializeWrite(this, false);
        }
        if (this.sendQueue.isEmpty()) {
            if (this.isLogicalClosed) {
                this.realClose();
            }
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.id + "] remaining data to send. initiate sending of the remaining (" + DataConverter.toFormatedBytesSize(this.sendQueue.getSize()) + ")");
            }
            this.dispatcher.initializeWrite(this, false);
        }
        return sent;
    }

    long onWriteableEvent() throws IOException {
        assert (Thread.currentThread().getName().startsWith("xDispatcher"));
        int sent = 0;
        sent = this.writeSocket();
        if (this.sendQueue.isEmpty() && this.writeTask == null) {
            this.dispatcher.unsetWriteSelectionKeyNow(this, true);
            if (this.isLogicalClosed) {
                this.realClose();
            }
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.id + "] remaining data to send. initiate sending of the remaining (" + DataConverter.toFormatedBytesSize(this.sendQueue.getSize()) + ")");
            }
            this.dispatcher.initializeWrite(this, false);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("[" + this.getId() + "] writeable event handled");
        }
        return sent;
    }

    @Override
    public void write(ByteBuffer[] buffers) throws ClosedChannelException, IOException {
        this.addToWriteQueue(buffers);
    }

    @Override
    public void flush() throws IOException {
        if (!this.sendQueue.isEmpty()) {
            this.dispatcher.initializeWrite(this, true);
        }
    }

    @Override
    public void addToWriteQueue(ByteBuffer[] buffers) {
        if (buffers != null) {
            this.sendQueue.append(buffers);
        }
    }

    @Override
    public void close(boolean immediate) throws IOException {
        if (immediate || this.sendQueue.isEmpty()) {
            this.realClose();
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("postpone close until remaning data to write (" + this.sendQueue.getSize() + ") has been written");
            }
            this.isLogicalClosed = true;
            this.dispatcher.initializeWrite(this, true);
        }
    }

    void closeSilence(boolean immediate) {
        block2: {
            try {
                this.close(immediate);
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by closing " + this.getId() + " " + DataConverter.toString(ioe));
            }
        }
    }

    private void realClose() {
        block7: {
            block6: {
                try {
                    this.dispatcher.deregister(this);
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block6;
                    LOG.fine("error occured by deregistering connection " + this.id + " on dispatcher. reason: " + e.toString());
                }
            }
            try {
                this.channel.close();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("connection " + this.id + " has been closed");
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.fine("error occured by closing connection " + this.id + " reason: " + e.toString());
            }
        }
        if (!this.isDisconnect) {
            this.isDisconnect = true;
            this.getPreviousCallback().onDisconnect();
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    @Override
    public void suspendRead() throws IOException {
        this.dispatcher.suspendRead(this);
    }

    @Override
    public void resumeRead() throws IOException {
        this.dispatcher.resumeRead(this);
    }

    @Override
    public boolean isReadSuspended() {
        return !this.dispatcher.isReadable(this);
    }

    private ByteBuffer[] readSocket() throws IOException {
        assert (Thread.currentThread().getName().startsWith("xDispatcher")) : "receiveQueue can only be accessed by the dispatcher thread";
        ByteBuffer[] received = null;
        int read = 0;
        this.lastTimeReceivedMillis = System.currentTimeMillis();
        if (this.isOpen()) {
            assert (this.memoryManager instanceof IoUnsynchronizedMemoryManager);
            ByteBuffer readBuffer = this.memoryManager.acquireMemoryStandardSizeOrPreallocated(8192);
            int pos = readBuffer.position();
            int limit = readBuffer.limit();
            try {
                read = this.channel.read(readBuffer);
            }
            catch (IOException ioe) {
                readBuffer.position(pos);
                readBuffer.limit(limit);
                this.memoryManager.recycleMemory(readBuffer);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.id + "] error occured while reading channel: " + ioe.toString());
                }
                throw ioe;
            }
            switch (read) {
                case -1: {
                    this.memoryManager.recycleMemory(readBuffer);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.id + "] channel has reached end-of-stream (maybe closed by peer)");
                    }
                    ClosedChannelException cce = new ClosedChannelException();
                    throw cce;
                }
                case 0: {
                    this.memoryManager.recycleMemory(readBuffer);
                    return null;
                }
            }
            int remainingFreeSize = readBuffer.remaining();
            ByteBuffer dataBuffer = this.memoryManager.extractAndRecycleMemory(readBuffer, read);
            if (received == null) {
                received = new ByteBuffer[]{dataBuffer};
            }
            this.receivedBytes += (long)read;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.id + "] received (" + (dataBuffer.limit() - dataBuffer.position()) + " bytes, total " + (this.receivedBytes + (long)read) + " bytes): " + DataConverter.toTextOrHexString(new ByteBuffer[]{dataBuffer.duplicate()}, "UTF-8", 2000));
            }
            if (remainingFreeSize == 0 && this.isRetryRead) {
                if (read < this.memoryManager.gettPreallocationBufferSize()) {
                    ByteBuffer[] repeatedReceived;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.id + "] complete read buffer has been used, initiating repeated read");
                    }
                    if ((repeatedReceived = this.readSocket()) != null) {
                        ByteBuffer[] newReceived = new ByteBuffer[received.length + 1];
                        newReceived[0] = dataBuffer;
                        System.arraycopy(repeatedReceived, 0, newReceived, 1, repeatedReceived.length);
                        received = newReceived;
                        return received;
                    }
                    return received;
                }
                return received;
            }
            return received;
        }
        return null;
    }

    private void checkPreallocatedReadMemory() throws IOException {
        assert (Thread.currentThread().getName().startsWith("xDispatcher"));
        this.memoryManager.preallocate();
    }

    private int writeSocket() throws IOException {
        int sent = 0;
        if (this.isOpen()) {
            if (this.writeTask == null) {
                this.writeTask = TaskFactory.newTask(this.sendQueue, this.maxChunkSize);
            }
            int written = this.writeTask.write(this);
            sent += written;
            this.sendBytes += (long)written;
            if (!this.writeTask.hasUnwrittenData()) {
                this.writeTask = null;
            }
        } else if (LOG.isLoggable(Level.FINEST)) {
            if (!this.isOpen()) {
                LOG.finest("[" + this.getId() + "] couldn't write send queue to socket because socket is already closed (sendQueuesize=" + DataConverter.toFormatedBytesSize(this.sendQueue.getSize()) + ")");
            }
            if (this.sendQueue.isEmpty()) {
                LOG.finest("[" + this.getId() + "] nothing to write, because send queue is empty ");
            }
        }
        return sent;
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.channel.socket().getLocalAddress();
    }

    @Override
    public final int getLocalPort() {
        return this.channel.socket().getLocalPort();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        InetAddress addr = this.channel.socket().getInetAddress();
        return addr;
    }

    @Override
    public final int getRemotePort() {
        return this.channel.socket().getPort();
    }

    @Override
    public long getLastTimeReceivedMillis() {
        return this.lastTimeReceivedMillis;
    }

    @Override
    public long getNumberOfReceivedBytes() {
        return this.receivedBytes;
    }

    @Override
    public long getNumberOfSendBytes() {
        return this.sendBytes;
    }

    @Override
    public String getRegisteredOpsInfo() {
        return this.dispatcher.getRegisteredOpsInfo(this);
    }

    @Override
    public void hardFlush() throws IOException {
        this.flush();
    }

    @Override
    public String toString() {
        try {
            return "(" + this.channel.socket().getInetAddress().toString() + ":" + this.channel.socket().getPort() + " -> " + this.channel.socket().getLocalAddress().toString() + ":" + this.channel.socket().getLocalPort() + ")" + " received=" + DataConverter.toFormatedBytesSize(this.receivedBytes) + ", sent=" + DataConverter.toFormatedBytesSize(this.sendBytes) + ", age=" + DataConverter.toFormatedDuration(System.currentTimeMillis() - this.openTime) + ", lastReceived=" + DF.format(new Date(this.lastTimeReceivedMillis)) + ", sendQueueSize=" + DataConverter.toFormatedBytesSize(this.sendQueue.getSize()) + " [" + this.id + "]";
        }
        catch (Throwable e) {
            return super.toString();
        }
    }

    static {
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_RCVBUF", Integer.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_SNDBUF", Integer.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_REUSEADDR", Boolean.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_KEEPALIVE", Boolean.class);
        SUPPORTED_OPTIONS.put("IPPROTO_TCP.TCP_NODELAY", Boolean.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_LINGER", Integer.class);
    }

    private static final class DirectWriteProcessor
    extends AbstractWriteTask {
        private boolean hasUnwrittenData = false;
        private ByteBuffer bufferToWrite = null;

        private DirectWriteProcessor() {
        }

        boolean addData(ByteBuffer bufferToWrite) {
            if (bufferToWrite.hasRemaining()) {
                this.bufferToWrite = bufferToWrite;
                return true;
            }
            return false;
        }

        boolean hasUnwrittenData() {
            return this.hasUnwrittenData;
        }

        int write(IoSocketHandler handler) throws IOException {
            int written = 0;
            try {
                written = handler.channel.write(this.bufferToWrite);
                if (!this.bufferToWrite.hasRemaining()) {
                    this.hasWritten(handler, this.bufferToWrite);
                    this.bufferToWrite = null;
                    this.hasUnwrittenData = false;
                } else {
                    this.hasUnwrittenData = true;
                    TaskFactory.detachDirectWriteProcessor();
                }
            }
            catch (IOException ioe) {
                this.bufferToWrite = null;
                this.hasUnwrittenData = false;
                this.writeErrorOccured(handler, ioe, this.bufferToWrite);
            }
            return written;
        }
    }

    private static final class MergingWriteProcessor
    extends AbstractWriteTask {
        private int writeBufferSize = 8192;
        private ByteBuffer writeBuffer = ByteBuffer.allocateDirect(this.writeBufferSize);
        private boolean hasUnwrittenData = false;
        private ByteBuffer[] buffersToWrite = null;

        private MergingWriteProcessor() {
        }

        boolean hasUnwrittenData() {
            return this.hasUnwrittenData;
        }

        boolean addData(ByteBuffer[] buffers, int maxChunkSize) {
            this.buffersToWrite = buffers;
            if (this.writeBufferSize < maxChunkSize) {
                this.writeBufferSize = maxChunkSize;
                this.writeBuffer = ByteBuffer.allocateDirect(this.writeBufferSize);
            }
            int countBuffers = this.buffersToWrite.length;
            for (int i = 0; i < countBuffers; ++i) {
                this.writeBuffer.put(this.buffersToWrite[i]);
            }
            if (this.writeBuffer.position() == 0) {
                return false;
            }
            this.writeBuffer.flip();
            return true;
        }

        int write(IoSocketHandler handler) throws IOException {
            int written = 0;
            try {
                written = handler.channel.write(this.writeBuffer);
                if (!this.writeBuffer.hasRemaining()) {
                    for (ByteBuffer buffer : this.buffersToWrite) {
                        this.hasWritten(handler, buffer);
                    }
                    this.buffersToWrite = null;
                    this.writeBuffer.clear();
                    this.hasUnwrittenData = false;
                } else {
                    this.hasUnwrittenData = true;
                    TaskFactory.detachMergingWriteProcessor();
                }
            }
            catch (IOException ioe) {
                this.writeBuffer.clear();
                this.hasUnwrittenData = false;
                for (ByteBuffer buffer : this.buffersToWrite) {
                    this.writeErrorOccured(handler, ioe, buffer);
                }
                this.buffersToWrite = null;
            }
            return written;
        }
    }

    private static final class EmptyWriteTask
    extends AbstractWriteTask {
        private EmptyWriteTask() {
        }

        boolean hasUnwrittenData() {
            return false;
        }

        int write(IoSocketHandler handler) throws IOException {
            return 0;
        }
    }

    private static abstract class AbstractWriteTask {
        private AbstractWriteTask() {
        }

        abstract boolean hasUnwrittenData();

        abstract int write(IoSocketHandler var1) throws IOException;

        final void hasWritten(IoSocketHandler handler, ByteBuffer buffer) {
            handler.getPreviousCallback().onWritten(buffer);
        }

        final void writeErrorOccured(IoSocketHandler handler, IOException ioe, ByteBuffer buffer) {
            block3: {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error " + ioe.toString() + " occured by writing " + ioe.toString());
                }
                try {
                    handler.getPreviousCallback().onWriteException(ioe, buffer);
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("error occured by notifying that write exception (" + e.toString() + ") has been occured " + e.toString());
                }
            }
        }
    }

    private static final class TaskFactory {
        private static ThreadLocal<EmptyWriteTask> emptyWriteTaskThreadLocal = new ThreadLocal();
        private static ThreadLocal<MergingWriteProcessor> mergingWriteTaskThreadLocal = new ThreadLocal();
        private static ThreadLocal<DirectWriteProcessor> directWriteTaskThreadLocal = new ThreadLocal();

        private TaskFactory() {
        }

        static EmptyWriteTask getEmptyWriteTask() {
            EmptyWriteTask emptyWriteTask = emptyWriteTaskThreadLocal.get();
            if (emptyWriteTask == null) {
                emptyWriteTask = new EmptyWriteTask();
                emptyWriteTaskThreadLocal.set(emptyWriteTask);
            }
            return emptyWriteTask;
        }

        static MergingWriteProcessor getMergingWriteProcessor() {
            MergingWriteProcessor meringWriteProcessor = mergingWriteTaskThreadLocal.get();
            if (meringWriteProcessor == null) {
                meringWriteProcessor = new MergingWriteProcessor();
                mergingWriteTaskThreadLocal.set(meringWriteProcessor);
            }
            return meringWriteProcessor;
        }

        static DirectWriteProcessor getDirectWriteProcessor() {
            DirectWriteProcessor directWriteProcessor = directWriteTaskThreadLocal.get();
            if (directWriteProcessor == null) {
                directWriteProcessor = new DirectWriteProcessor();
                directWriteTaskThreadLocal.set(directWriteProcessor);
            }
            return directWriteProcessor;
        }

        static void detachMergingWriteProcessor() {
            mergingWriteTaskThreadLocal.set(null);
        }

        static void detachDirectWriteProcessor() {
            directWriteTaskThreadLocal.set(null);
        }

        static AbstractWriteTask newTask(IoQueue sendQueue, int maxChunkSize) {
            ByteBuffer[] buffersToWrite = sendQueue.drain(maxChunkSize);
            if (buffersToWrite == null) {
                return TaskFactory.getEmptyWriteTask();
            }
            if (buffersToWrite.length > 1) {
                MergingWriteProcessor mergingWriteProcessor = TaskFactory.getMergingWriteProcessor();
                boolean dataToWrite = mergingWriteProcessor.addData(buffersToWrite, maxChunkSize);
                if (dataToWrite) {
                    return mergingWriteProcessor;
                }
                return TaskFactory.getEmptyWriteTask();
            }
            DirectWriteProcessor directWriteProcessor = TaskFactory.getDirectWriteProcessor();
            boolean dataToWrite = directWriteProcessor.addData(buffersToWrite[0]);
            if (dataToWrite) {
                return directWriteProcessor;
            }
            return TaskFactory.getEmptyWriteTask();
        }
    }
}

