/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.HandlerAdapter;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIoAcceptorCallback;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IServer;
import org.xsocket.connection.IServerListener;
import org.xsocket.connection.IoAcceptor;
import org.xsocket.connection.IoChainableHandler;
import org.xsocket.connection.NonBlockingConnection;
import org.xsocket.connection.TimeoutManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements IServer {
    private static final Logger LOG = Logger.getLogger(Server.class.getName());
    private static String implementationVersion = null;
    private static String implementationDate = null;
    private static final String WORKER_POOL_SIZE_KEY = "org.xsocket.connection.server.workerpoolSize";
    private static final int DEFAULT_SIZE_WORKER_POOL = 40;
    private static int workerpoolSize = 40;
    private IConnection.FlushMode flushMode = IConnection.DEFAULT_FLUSH_MODE;
    private boolean autoflush = true;
    private Integer writeRate = null;
    private boolean isOpen = false;
    private String name = "server";
    private boolean isSsslOn = false;
    private IoAcceptor acceptor = null;
    private ExecutorService defaultWorkerPool = Executors.newFixedThreadPool(workerpoolSize, new DefaultThreadFactory());
    private Executor workerpool = this.defaultWorkerPool;
    private final TimeoutManager timeoutManager = new TimeoutManager();
    private HandlerAdapter handlerAdapter = HandlerAdapter.newInstance(null);
    private long idleTimeoutMillis = Long.MAX_VALUE;
    private long connectionTimeoutMillis = Long.MAX_VALUE;
    private final ArrayList<IServerListener> listeners = new ArrayList();
    private String startUpLogMessage = null;

    public Server(IHandler handler) throws UnknownHostException, IOException {
        this(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 0), new HashMap<String, Object>(), handler, null, false, 0);
    }

    public Server(Map<String, Object> options, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName("0.0.0.0"), 0, options, handler, null, false, 0);
    }

    public Server(int port, IHandler handler) throws UnknownHostException, IOException {
        this(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), port), new HashMap<String, Object>(), handler, null, false, 0);
    }

    public Server(int port, IHandler handler, int backlog) throws UnknownHostException, IOException {
        this(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), port), new HashMap<String, Object>(), handler, null, false, backlog);
    }

    public Server(int port, Map<String, Object> options, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName("0.0.0.0"), port, options, handler, null, false, 0);
    }

    public Server(InetAddress address, int port, IHandler handler) throws UnknownHostException, IOException {
        this(address, port, new HashMap<String, Object>(), handler, null, false, 0);
    }

    public Server(String ipAddress, int port, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, new HashMap<String, Object>(), handler, null, false, 0);
    }

    public Server(String ipAddress, int port, Map<String, Object> options, IHandler handler) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, options, handler, null, false, 0);
    }

    public Server(int port, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(InetAddress.getByName("0.0.0.0"), port, new HashMap<String, Object>(), handler, sslContext, sslOn, 0);
    }

    public Server(int port, Map<String, Object> options, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(InetAddress.getByName("0.0.0.0"), port, options, handler, sslContext, sslOn, 0);
    }

    public Server(String ipAddress, int port, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, new HashMap<String, Object>(), handler, sslContext, sslOn, 0);
    }

    public Server(String ipAddress, int port, Map<String, Object> options, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(InetAddress.getByName(ipAddress), port, options, handler, sslContext, sslOn, 0);
    }

    public Server(InetAddress address, int port, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(address, port, new HashMap<String, Object>(), handler, sslContext, sslOn, 0);
    }

    public Server(InetAddress address, int port, Map<String, Object> options, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(new InetSocketAddress(address, port), options, handler, sslContext, sslOn, 0);
    }

    public Server(InetAddress address, int port, Map<String, Object> options, IHandler handler, SSLContext sslContext, boolean sslOn, int backlog) throws UnknownHostException, IOException {
        this(new InetSocketAddress(address, port), options, handler, sslContext, sslOn, backlog);
    }

    protected Server(InetSocketAddress address, Map<String, Object> options, IHandler handler, SSLContext sslContext, boolean sslOn, int backlog) throws UnknownHostException, IOException {
        if (sslContext != null) {
            this.isSsslOn = true;
            this.acceptor = ConnectionUtils.getIoProvider().createAcceptor(new LifeCycleHandler(), address, backlog, options, sslContext, sslOn);
        } else {
            this.isSsslOn = false;
            this.acceptor = ConnectionUtils.getIoProvider().createAcceptor(new LifeCycleHandler(), address, backlog, options);
        }
        this.setHandler(handler);
    }

    private void setHandler(IHandler handler) {
        if (this.isOpen) {
            this.destroyCurrentHandler();
        }
        this.handlerAdapter = HandlerAdapter.newInstance(handler);
        if (this.isOpen) {
            this.initCurrentHandler();
        }
    }

    private void initCurrentHandler() {
        ConnectionUtils.injectServerField(this, this.handlerAdapter.getHandler());
        this.handlerAdapter.onInit();
    }

    private void destroyCurrentHandler() {
        this.handlerAdapter.onDestroy();
    }

    public final void setServerName(String name) {
        this.name = name;
    }

    public final String getServerName() {
        return this.name;
    }

    @Override
    public String getStartUpLogMessage() {
        return this.startUpLogMessage;
    }

    @Override
    public void setStartUpLogMessage(String message) {
        this.startUpLogMessage = message;
    }

    @Override
    public void run() {
        try {
            if (this.getHandler() == null) {
                LOG.warning("no handler has been set. Call setHandler-method to assign a handler");
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    Server.this.close();
                }
            });
            this.acceptor.listen();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    @Override
    public void start() throws IOException {
        ConnectionUtils.start(this);
    }

    @Override
    public final Object getOption(String name) throws IOException {
        return this.acceptor.getOption(name);
    }

    @Override
    public IHandler getHandler() {
        return this.handlerAdapter.getHandler();
    }

    @Override
    public final Map<String, Class> getOptions() {
        return this.acceptor.getOptions();
    }

    @Override
    public final void close() {
        block7: {
            if (this.isOpen) {
                block6: {
                    this.isOpen = false;
                    for (NonBlockingConnection connection : this.timeoutManager.getConnections()) {
                        connection.closeSilence();
                    }
                    this.timeoutManager.close();
                    try {
                        this.acceptor.close();
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block6;
                        LOG.fine("error occured by closing acceptor " + DataConverter.toString(ioe));
                    }
                }
                try {
                    this.onClosed();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block7;
                    LOG.fine("error occured by performing onClosed method " + DataConverter.toString(ioe));
                }
            }
        }
    }

    protected void onClosed() throws IOException {
    }

    final IoAcceptor getAcceptor() {
        return this.acceptor;
    }

    final long getTimeoutWatchDogPeriod() {
        return this.timeoutManager.getWatchDogPeriod();
    }

    @Override
    public final void addListener(IServerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public final boolean removeListener(IServerListener listener) {
        boolean result = this.listeners.remove(listener);
        return result;
    }

    @Override
    public final Executor getWorkerpool() {
        return this.workerpool;
    }

    @Override
    public final void setWorkerpool(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor has to be set");
        }
        if (this.isOpen) {
            LOG.warning("server is already running");
        }
        this.workerpool = executor;
        if (this.defaultWorkerPool != null) {
            this.defaultWorkerPool.shutdown();
            this.defaultWorkerPool = null;
        }
    }

    @Override
    public final boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public final int getLocalPort() {
        return this.acceptor.getLocalPort();
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.acceptor.getLocalAddress();
    }

    final int getNumberOfOpenConnections() {
        return this.timeoutManager.getConnections().size();
    }

    public Set<INonBlockingConnection> getOpenConnections() {
        HashSet<INonBlockingConnection> result = new HashSet<INonBlockingConnection>();
        result.addAll(this.timeoutManager.getConnections());
        return result;
    }

    final List<String> getOpenConnectionInfos() {
        ArrayList<String> infos = new ArrayList<String>();
        for (NonBlockingConnection con : this.timeoutManager.getConnections()) {
            infos.add(con.toDetailedString());
        }
        return infos;
    }

    final int getNumberOfIdleTimeouts() {
        return this.timeoutManager.getNumberOfIdleTimeouts();
    }

    final int getNumberOfConnectionTimeouts() {
        return this.timeoutManager.getNumberOfConnectionTimeouts();
    }

    @Override
    public final IConnection.FlushMode getFlushMode() {
        return this.flushMode;
    }

    @Override
    public final void setFlushMode(IConnection.FlushMode flusmode) {
        this.flushMode = flusmode;
    }

    @Override
    public final void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    @Override
    public final boolean getAutoflush() {
        return this.autoflush;
    }

    @Override
    public final void setConnectionTimeoutMillis(long timeoutMillis) {
        this.connectionTimeoutMillis = timeoutMillis;
    }

    @Override
    public void setWriteTransferRate(int bytesPerSecond) throws IOException {
        if (bytesPerSecond != Integer.MAX_VALUE && this.flushMode != IConnection.FlushMode.ASYNC) {
            LOG.warning("setWriteTransferRate is only supported for FlushMode ASYNC. Ignore update of the transfer rate");
            return;
        }
        this.writeRate = bytesPerSecond;
    }

    @Override
    public void setIdleTimeoutMillis(long timeoutMillis) {
        this.idleTimeoutMillis = timeoutMillis;
    }

    @Override
    public final long getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    @Override
    public final long getIdleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    public final String getVersion() {
        return this.getImplementationVersion();
    }

    public final String getImplementationVersion() {
        if (implementationVersion == null) {
            implementationVersion = ConnectionUtils.getImplementationVersion();
        }
        return implementationVersion;
    }

    final String getImplementationDate() {
        if (implementationDate == null) {
            implementationDate = ConnectionUtils.getImplementationDate();
        }
        return implementationDate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getServerName() + " on " + this.getLocalAddress().toString() + " Port " + this.getLocalPort());
        sb.append("\r\nopen connections:");
        for (NonBlockingConnection con : this.timeoutManager.getConnections()) {
            sb.append("\r\n  " + con.toString());
        }
        return sb.toString();
    }

    static {
        String workerpoolSizeString = System.getProperty(WORKER_POOL_SIZE_KEY);
        if (workerpoolSizeString != null) {
            workerpoolSize = Integer.parseInt(workerpoolSizeString);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("default workerpool size set with " + workerpoolSize);
            }
        }
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "xServerPool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private final class LifeCycleHandler
    implements IIoAcceptorCallback {
        private LifeCycleHandler() {
        }

        public void onConnected() {
            Server.this.isOpen = true;
            if (Server.this.startUpLogMessage == null) {
                Server.this.startUpLogMessage = Server.this.getImplementationVersion();
                Server.this.startUpLogMessage = "xSocket " + Server.this.startUpLogMessage;
            }
            Server.this.initCurrentHandler();
            for (IServerListener listener : (ArrayList)Server.this.listeners.clone()) {
                listener.onInit();
            }
            if (Server.this.isSsslOn) {
                LOG.info(Server.this.name + " listening on " + Server.this.acceptor.getLocalAddress().getHostName() + ":" + Server.this.acceptor.getLocalPort() + " - SSL mode (" + Server.this.startUpLogMessage + ")");
            } else {
                LOG.info(Server.this.name + " listening on " + Server.this.acceptor.getLocalAddress().getHostName() + ":" + Server.this.acceptor.getLocalPort() + " (" + Server.this.startUpLogMessage + ")");
            }
        }

        public void onDisconnected() {
            Server.this.destroyCurrentHandler();
            for (IServerListener listener : (ArrayList)Server.this.listeners.clone()) {
                try {
                    listener.onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("exception occured by destroying " + listener + " " + ioe.toString());
                }
            }
            if (Server.this.defaultWorkerPool != null) {
                Thread t = new Thread("workerpoolCloser"){

                    public void run() {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Server.this.defaultWorkerPool.shutdownNow();
                    }
                };
                t.setDaemon(true);
                t.start();
            }
            LOG.info("server has been shutdown");
        }

        public void onConnectionAccepted(IoChainableHandler ioHandler) throws IOException {
            NonBlockingConnection connection = new NonBlockingConnection(Server.this.timeoutManager, Server.this.handlerAdapter.getConnectionInstance());
            connection.setAutoflush(Server.this.autoflush);
            connection.setFlushmode(Server.this.flushMode);
            connection.setWorkerpool(Server.this.workerpool);
            connection.init(ioHandler);
            connection.setIdleTimeoutMillis(Server.this.idleTimeoutMillis);
            connection.setConnectionTimeoutMillis(Server.this.connectionTimeoutMillis);
            if (Server.this.writeRate != null) {
                connection.setWriteTransferRate(Server.this.writeRate);
            }
        }
    }
}

