/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.Flushable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.Executor;
import org.xsocket.IDataSink;
import org.xsocket.IDataSource;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IHandler;

public interface INonBlockingConnection
extends IConnection,
IDataSource,
IDataSink,
GatheringByteChannel,
ReadableByteChannel,
WritableByteChannel,
Flushable {
    public static final int UNLIMITED = Integer.MAX_VALUE;

    public void setHandler(IHandler var1) throws IOException;

    public IHandler getHandler();

    public String getEncoding();

    public void setEncoding(String var1);

    public void setAutoflush(boolean var1);

    public boolean isAutoflush();

    public void flush() throws ClosedChannelException, IOException, SocketTimeoutException;

    public void setFlushmode(IConnection.FlushMode var1);

    public IConnection.FlushMode getFlushmode();

    public void activateSecuredMode() throws IOException;

    public boolean isSecure();

    public int getPendingWriteDataSize();

    public void suspendRead() throws IOException;

    public boolean isReadSuspended();

    public void resumeRead() throws IOException;

    public int write(String var1, String var2) throws IOException, BufferOverflowException;

    public ByteBuffer[] readByteBufferByDelimiter(String var1, String var2) throws IOException, BufferUnderflowException;

    public ByteBuffer[] readByteBufferByDelimiter(String var1, String var2, int var3) throws IOException, BufferUnderflowException, MaxReadSizeExceededException;

    public byte[] readBytesByDelimiter(String var1, String var2) throws IOException, BufferUnderflowException;

    public byte[] readBytesByDelimiter(String var1, String var2, int var3) throws IOException, BufferUnderflowException, MaxReadSizeExceededException;

    public String readStringByDelimiter(String var1, String var2) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException;

    public String readStringByDelimiter(String var1, String var2, int var3) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException;

    public String readStringByLength(int var1, String var2) throws IOException, BufferUnderflowException, UnsupportedEncodingException;

    public long transferFrom(FileChannel var1) throws IOException, BufferOverflowException;

    public int indexOf(String var1) throws IOException;

    public int indexOf(String var1, String var2) throws IOException;

    public void setWriteTransferRate(int var1) throws ClosedChannelException, IOException;

    public int getWriteTransferRate() throws ClosedChannelException, IOException;

    public int available() throws IOException;

    public int getReadBufferVersion() throws IOException;

    public boolean isOpen();

    public Executor getWorkerpool();

    public boolean resetToWriteMark();

    public boolean resetToReadMark();

    public void markWritePosition();

    public void markReadPosition();

    public void removeReadMark();

    public void removeWriteMark();

    public int getMaxReadBufferThreshold();

    public void setMaxReadBufferThreshold(int var1);
}

