/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.nio.ByteBuffer;

final class IoQueue {
    private ByteBuffer[] buffers = null;

    IoQueue() {
    }

    public synchronized boolean isEmpty() {
        if (this.buffers == null) {
            return true;
        }
        return this.getSize() == 0;
    }

    public synchronized int getSize() {
        int size = 0;
        if (this.buffers != null) {
            for (int i = 0; i < this.buffers.length; ++i) {
                if (this.buffers[i] == null) continue;
                size += this.buffers[i].remaining();
            }
        }
        return size;
    }

    public synchronized void append(ByteBuffer data) {
        if (data == null) {
            return;
        }
        if (this.buffers == null) {
            this.buffers = new ByteBuffer[1];
            this.buffers[0] = data;
        } else {
            ByteBuffer[] newBuffers = new ByteBuffer[this.buffers.length + 1];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            newBuffers[this.buffers.length] = data;
            this.buffers = newBuffers;
        }
    }

    public synchronized void append(ByteBuffer[] data) {
        if (data == null) {
            return;
        }
        if (this.buffers == null) {
            this.buffers = data;
        } else {
            ByteBuffer[] newBuffers = new ByteBuffer[this.buffers.length + data.length];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            System.arraycopy(data, 0, newBuffers, this.buffers.length, data.length);
            this.buffers = newBuffers;
        }
    }

    public synchronized void addFirst(ByteBuffer[] data) {
        if (data == null) {
            return;
        }
        if (this.buffers == null) {
            this.buffers = data;
        } else {
            ByteBuffer[] newBuffers = new ByteBuffer[this.buffers.length + data.length];
            System.arraycopy(data, 0, newBuffers, 0, data.length);
            System.arraycopy(this.buffers, 0, newBuffers, data.length, this.buffers.length);
            this.buffers = newBuffers;
        }
    }

    public synchronized ByteBuffer[] drain() {
        ByteBuffer[] result = this.buffers;
        this.buffers = null;
        return result;
    }
}

