/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.AbstractNonBlockingStream;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.HandlerAdapter;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.IIoHandlerCallback;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IoChainableHandler;
import org.xsocket.connection.TimeoutManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonBlockingConnection
extends AbstractNonBlockingStream
implements INonBlockingConnection {
    private static final Logger LOG = Logger.getLogger(NonBlockingConnection.class.getName());
    private static final SimpleDateFormat DF = new SimpleDateFormat("HH:mm:ss,S");
    public static final String SEND_TIMEOUT_KEY = "org.xsocket.stream.send_timeout_millis";
    public static final long DEFAULT_SEND_TIMEOUT_MILLIS = 60000L;
    private static Executor defaultWorkerPool = null;
    private static long sendTimeoutMillis = 60000L;
    private static final ExecutorService executor;
    private AtomicBoolean isOpen = new AtomicBoolean(true);
    private AtomicBoolean isConnected = new AtomicBoolean(false);
    private AtomicBoolean isSuspended = new AtomicBoolean(false);
    private static final TimeoutManager DEFAULT_CONNECTION_MANAGER;
    private TimeoutManager.TimeoutMgmHandle timeoutMgmHandle = null;
    private final IoHandlerCallback ioHandlerCallback = new IoHandlerCallback();
    private IoChainableHandler ioHandler = null;
    private final AtomicReference<IHandler> appHandler = new AtomicReference<Object>(null);
    private Executor workerpool = null;
    private final Object writeSynchronizer = new Object();
    private int bytesPerSecond = Integer.MAX_VALUE;
    private IOException writeException = null;
    private final List<ByteBuffer> pendingWriteConfirmations = new ArrayList<ByteBuffer>();
    private long idleTimeoutMillis = Long.MAX_VALUE;
    private long idleTimeoutDateMillis = Long.MAX_VALUE;
    private long connectionTimeoutMillis = Long.MAX_VALUE;
    private long connectionTimeoutDateMillis = Long.MAX_VALUE;
    private boolean idleTimeoutOccured = false;
    private boolean connectionTimeoutOccured = false;
    private boolean disconnectOccured = false;
    private boolean isSecured = false;
    private Integer cachedSoSndBuf = null;
    private Integer maxReadBufferSize = null;
    private Integer maxWriteBufferSize = null;

    public NonBlockingConnection(String hostname, int port) throws IOException {
        this(InetAddress.getByName(hostname), port);
    }

    public NonBlockingConnection(InetAddress address, int port) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetSocketAddress address) throws IOException {
        this(address, true, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, int connectTimeoutMillis) throws IOException {
        this(new InetSocketAddress(address, port), true, connectTimeoutMillis, new HashMap<String, Object>(), null, false, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, options, null, false, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, int connectTimeoutMillis, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(address, port), true, connectTimeoutMillis, options, null, false, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis) throws IOException {
        this(new InetSocketAddress(address, port), true, connectTimeoutMillis, new HashMap<String, Object>(), null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean waitForConnect, int connectTimeoutMillis) throws IOException {
        this(new InetSocketAddress(address, port), waitForConnect, connectTimeoutMillis, new HashMap<String, Object>(), null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), sslContext, sslOn, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), true, connectTimeoutMillis, new HashMap<String, Object>(), sslContext, sslOn, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean waitForConnect, int connectTimeoutMillis, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), waitForConnect, connectTimeoutMillis, new HashMap<String, Object>(), sslContext, sslOn, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, options, null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(address, port), true, connectTimeoutMillis, options, null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean waitForConnect, int connectTimeoutMillis, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(address, port), true, connectTimeoutMillis, options, null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(String hostname, int port, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(hostname, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(String hostname, int port, IHandler appHandler, Executor workerPool) throws IOException {
        this(new InetSocketAddress(hostname, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, appHandler, workerPool);
    }

    public NonBlockingConnection(String hostname, int port, IHandler appHandler, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(hostname, port), true, Integer.MAX_VALUE, options, null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), sslContext, sslOn, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, options, sslContext, sslOn, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(String hostname, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), sslContext, sslOn, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(String hostname, int port, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), true, Integer.MAX_VALUE, options, sslContext, sslOn, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, Executor workerPool) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, appHandler, workerPool);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis, Executor workerPool) throws IOException {
        this(new InetSocketAddress(address, port), true, connectTimeoutMillis, new HashMap<String, Object>(), null, false, appHandler, workerPool);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean waitForConnect, int connectTimeoutMillis, Executor workerPool) throws IOException {
        this(new InetSocketAddress(address, port), waitForConnect, connectTimeoutMillis, new HashMap<String, Object>(), null, false, appHandler, workerPool);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis, SSLContext sslContext, boolean sslOn, Executor workerPool) throws IOException {
        this(new InetSocketAddress(address, port), true, connectTimeoutMillis, new HashMap<String, Object>(), sslContext, sslOn, appHandler, workerPool);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean waitForConnect, int connectTimeoutMillis, SSLContext sslContext, boolean sslOn, Executor workerPool) throws IOException {
        this(new InetSocketAddress(address, port), waitForConnect, connectTimeoutMillis, new HashMap<String, Object>(), sslContext, sslOn, appHandler, workerPool);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean autoflush, IConnection.FlushMode flushmode) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool(), autoflush, flushmode);
    }

    NonBlockingConnection(InetSocketAddress remoteAddress, boolean waitForConnect, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean sslOn, IHandler appHandler, Executor workerpool) throws IOException {
        this(remoteAddress, waitForConnect, connectTimeoutMillis, options, sslContext, sslOn, appHandler, workerpool, true, DEFAULT_FLUSH_MODE);
    }

    private NonBlockingConnection(final InetSocketAddress remoteAddress, boolean waitForConnect, final int connectTimeoutMillis, final Map<String, Object> options, final SSLContext sslContext, final boolean isSecured, IHandler appHdl, Executor workerpool, boolean autoflush, IConnection.FlushMode flushmode) throws IOException {
        this.isSecured = isSecured;
        this.setFlushmode(flushmode);
        this.setAutoflush(autoflush);
        this.setWorkerpool(workerpool);
        this.appHandler.set(HandlerAdapter.newInstance(appHdl));
        if (waitForConnect) {
            this.connect(remoteAddress, connectTimeoutMillis, options, sslContext, isSecured);
        } else {
            Runnable connectTask = new Runnable(){

                public void run() {
                    try {
                        NonBlockingConnection.this.connect(remoteAddress, connectTimeoutMillis, options, sslContext, isSecured);
                    }
                    catch (IOException ioe) {
                        NonBlockingConnection.this.onDisconnect();
                    }
                }
            };
            executor.execute(connectTask);
        }
    }

    protected NonBlockingConnection(TimeoutManager connectionManager, IHandler handlerAdapter) throws IOException {
        this.appHandler.set(handlerAdapter);
        this.isConnected.set(true);
        this.timeoutMgmHandle = connectionManager.register(this);
    }

    private void connect(InetSocketAddress remoteAddress, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean isSecured) throws IOException, SocketTimeoutException {
        IoChainableHandler ioHandler = NonBlockingConnection.createClientIoHandler(remoteAddress, connectTimeoutMillis, options, sslContext, isSecured);
        this.timeoutMgmHandle = DEFAULT_CONNECTION_MANAGER.register(this);
        this.init(ioHandler);
        this.setIdleTimeoutMillis(this.idleTimeoutMillis);
        this.setConnectionTimeoutMillis(this.connectionTimeoutMillis);
    }

    long getLastTimeReceivedMillis() {
        return this.ioHandler.getLastTimeReceivedMillis();
    }

    @Override
    public int getMaxReadBufferThreshold() {
        if (this.maxReadBufferSize == null) {
            return Integer.MAX_VALUE;
        }
        return this.maxReadBufferSize;
    }

    @Override
    public void setMaxReadBufferThreshold(int size) {
        if (size == Integer.MAX_VALUE) {
            this.maxReadBufferSize = null;
            this.ioHandler.setRetryRead(true);
        } else {
            this.maxReadBufferSize = size;
            this.ioHandler.setRetryRead(false);
        }
    }

    void setMaxWriteBufferThreshold(int size) {
        this.maxWriteBufferSize = size == Integer.MAX_VALUE ? null : Integer.valueOf(size);
    }

    static synchronized Executor getDefaultWorkerpool() {
        if (defaultWorkerPool == null) {
            defaultWorkerPool = Executors.newCachedThreadPool(new DefaultThreadFactory());
        }
        return defaultWorkerPool;
    }

    @Override
    protected boolean isMoreInputDataExpected() {
        if (this.ioHandler != null) {
            return this.ioHandler.isOpen();
        }
        return false;
    }

    @Override
    protected boolean isDataWriteable() {
        return this.ioHandler.isOpen();
    }

    final void init(IoChainableHandler ioHandler) throws IOException, SocketTimeoutException {
        this.ioHandler = ioHandler;
        ioHandler.init(this.ioHandlerCallback);
        this.isConnected.set(true);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("connection " + this.getId() + " created. IoHandler: " + ioHandler.toString());
        }
    }

    @Override
    public final void setHandler(IHandler hdl) throws IOException {
        this.appHandler.set(HandlerAdapter.newInstance(hdl));
        if (this.getReadQueueSize() > 0) {
            this.ioHandlerCallback.onPostData();
        }
    }

    @Override
    public IHandler getHandler() {
        IHandler hdl = this.appHandler.get();
        if (hdl == null) {
            return null;
        }
        return ((HandlerAdapter)hdl).getHandler();
    }

    public void setWorkerpool(Executor workerpool) {
        this.workerpool = workerpool;
    }

    @Override
    public Executor getWorkerpool() {
        return this.workerpool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setFlushmode(IConnection.FlushMode flushMode) {
        if (flushMode == IConnection.FlushMode.ASYNC) {
            Object object = this.writeSynchronizer;
            synchronized (object) {
                if (!this.pendingWriteConfirmations.isEmpty()) {
                    LOG.warning("Updating flush mode to " + (Object)((Object)flushMode) + ". A sync flush write operation is currently running which will be updated to async mode");
                    this.pendingWriteConfirmations.clear();
                    this.ioHandlerCallback.onWritten(null);
                }
                super.setFlushmode(flushMode);
            }
        } else {
            super.setFlushmode(flushMode);
        }
    }

    @Override
    protected boolean reset() {
        try {
            if (!this.pendingWriteConfirmations.isEmpty()) {
                return false;
            }
            this.writeException = null;
            boolean isReset = this.ioHandler.reset();
            if (!isReset) {
                return false;
            }
            return super.reset();
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured by reseting connection " + this.getId() + " " + e.toString());
            }
            return false;
        }
    }

    @Override
    public final boolean isOpen() {
        return this.isOpen.get();
    }

    boolean isConnected() {
        return this.ioHandler.isOpen();
    }

    @Override
    protected void onPostAppend() {
        block4: {
            if (this.maxReadBufferSize != null && this.getReadQueueSize() >= this.maxReadBufferSize) {
                try {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("suspending read, because max read buffers size " + this.maxReadBufferSize + " is execced (" + this.getReadQueueSize() + ")");
                    }
                    this.ioHandler.suspendRead();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("error occured by suspending read (cause by max read queue size " + this.maxReadBufferSize + " " + ioe.toString());
                }
            }
        }
    }

    @Override
    protected void onPostRead() throws IOException {
        block5: {
            if (this.maxReadBufferSize != null && this.ioHandler.isReadSuspended() && this.getReadQueueSize() < this.maxReadBufferSize) {
                try {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("resuming read, because read buffer size is lower than max read buffers size " + this.maxReadBufferSize);
                    }
                    if (!this.isSuspended.get()) {
                        this.ioHandler.resumeRead();
                    }
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("error occured by suspending read (cause by max read queue size " + this.maxReadBufferSize + " " + ioe.toString());
                }
            }
        }
    }

    private void onData(ByteBuffer[] data) {
        if (data != null) {
            this.appendDataToReadBuffer(data);
        }
    }

    private void onPostData() {
        block2: {
            try {
                ((IDataHandler)this.appHandler.get()).onData(this);
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by performing onData callback on " + this.appHandler.get() + " " + ioe.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onWritten(ByteBuffer data) {
        if (this.getFlushmode() == IConnection.FlushMode.SYNC) {
            Object object = this.writeSynchronizer;
            synchronized (object) {
                if (data != null) {
                    this.pendingWriteConfirmations.remove(data);
                }
                if (this.pendingWriteConfirmations.isEmpty()) {
                    this.writeSynchronizer.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onWriteException(IOException ioException, ByteBuffer data) {
        this.isOpen.set(false);
        if (this.getFlushmode() == IConnection.FlushMode.SYNC) {
            Object object = this.writeSynchronizer;
            synchronized (object) {
                this.writeException = ioException;
                if (data != null) {
                    this.pendingWriteConfirmations.remove(data);
                }
                this.writeSynchronizer.notifyAll();
            }
        }
    }

    private void onConnect() {
        block2: {
            try {
                ((IConnectHandler)this.appHandler.get()).onConnect(this);
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by performing onConnect callback on " + this.appHandler.get() + " " + ioe.toString());
            }
        }
    }

    private void onConnectionAbnormalTerminated() {
        this.forceClose();
    }

    private void onDisconnect() {
        block7: {
            if (this.timeoutMgmHandle != null) {
                this.timeoutMgmHandle.destroy();
            }
            if (!this.disconnectOccured) {
                block6: {
                    this.disconnectOccured = true;
                    try {
                        ((IDataHandler)this.appHandler.get()).onData(this);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block6;
                        LOG.fine("error occured by performing onData callback on " + this.appHandler.get() + " " + ioe.toString());
                    }
                }
                try {
                    ((IDisconnectHandler)this.appHandler.get()).onDisconnect(this);
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block7;
                    LOG.fine("error occured by performing onDisconnect callback on " + this.appHandler.get() + " " + ioe.toString());
                }
            }
        }
    }

    boolean checkIdleTimeout(Long currentMillis) {
        if (this.getRemainingMillisToIdleTimeout(currentMillis) <= 0L) {
            this.onIdleTimeout();
            return true;
        }
        return false;
    }

    void onIdleTimeout() {
        if (!this.idleTimeoutOccured) {
            this.idleTimeoutOccured = true;
            try {
                ((IIdleTimeoutHandler)this.appHandler.get()).onIdleTimeout(this);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by performing onIdleTimeout callback on " + this.appHandler.get() + " " + ioe.toString());
                }
            }
        } else {
            this.setIdleTimeoutMillis(Long.MAX_VALUE);
        }
    }

    boolean checkConnectionTimeout(Long currentMillis) {
        if (this.getRemainingMillisToConnectionTimeout(currentMillis) <= 0L) {
            this.onConnectionTimeout();
            return true;
        }
        return false;
    }

    private void onConnectionTimeout() {
        if (!this.connectionTimeoutOccured) {
            this.connectionTimeoutOccured = true;
            try {
                ((IConnectionTimeoutHandler)this.appHandler.get()).onConnectionTimeout(this);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by performing onConnectionTimeout callback on " + this.appHandler.get() + " " + ioe.toString());
                }
            }
        } else {
            this.setConnectionTimeoutMillis(Long.MAX_VALUE);
        }
    }

    @Override
    public long getRemainingMillisToConnectionTimeout() {
        return this.getRemainingMillisToConnectionTimeout(System.currentTimeMillis());
    }

    @Override
    public long getRemainingMillisToIdleTimeout() {
        return this.getRemainingMillisToIdleTimeout(System.currentTimeMillis());
    }

    private long getRemainingMillisToConnectionTimeout(long currentMillis) {
        return this.connectionTimeoutDateMillis - currentMillis;
    }

    public long getNumberOfReceivedBytes() {
        return this.ioHandler.getNumberOfReceivedBytes();
    }

    public long getNumberOfSendBytes() {
        return this.ioHandler.getNumberOfSendBytes();
    }

    private long getRemainingMillisToIdleTimeout(long currentMillis) {
        long remaining = this.idleTimeoutDateMillis - currentMillis;
        if (remaining > 0L) {
            return remaining;
        }
        return this.getLastTimeReceivedMillis() + this.idleTimeoutMillis - currentMillis;
    }

    String getRegisteredOpsInfo() {
        return this.ioHandler.getRegisteredOpsInfo();
    }

    @Override
    public final void setWriteTransferRate(int bytesPerSecond) throws ClosedChannelException, IOException {
        if (bytesPerSecond != Integer.MAX_VALUE && this.getFlushmode() != IConnection.FlushMode.ASYNC) {
            LOG.warning("setWriteTransferRate is only supported for FlushMode ASYNC. Ignore update of the transfer rate");
            return;
        }
        if (this.bytesPerSecond == bytesPerSecond) {
            return;
        }
        this.bytesPerSecond = bytesPerSecond;
        this.ioHandler = ConnectionUtils.getIoProvider().setWriteTransferRate(this.ioHandler, bytesPerSecond);
    }

    @Override
    public int getWriteTransferRate() throws ClosedChannelException, IOException {
        return this.bytesPerSecond;
    }

    @Override
    public final void activateSecuredMode() throws IOException {
        boolean isPrestarted = ConnectionUtils.getIoProvider().preStartSecuredMode(this.ioHandler);
        if (isPrestarted) {
            IConnection.FlushMode currentFlushMode = this.getFlushmode();
            this.setFlushmode(IConnection.FlushMode.ASYNC);
            this.internalFlush();
            this.setFlushmode(currentFlushMode);
            ByteBuffer[] buffer = this.readByteBufferByLength(this.available());
            ConnectionUtils.getIoProvider().startSecuredMode(this.ioHandler, buffer);
            this.isSecured = true;
        }
    }

    @Override
    public boolean isSecure() {
        return this.isSecured;
    }

    @Override
    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        try {
            return super.readByteBufferByDelimiter(delimiter, encoding, maxLength);
        }
        catch (MaxReadSizeExceededException mre) {
            if (this.isOpen()) {
                throw mre;
            }
            throw new ClosedChannelException();
        }
        catch (BufferUnderflowException bue) {
            if (this.isOpen()) {
                throw bue;
            }
            throw new ClosedChannelException();
        }
    }

    @Override
    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, BufferUnderflowException {
        try {
            ByteBuffer[] buffers = super.readByteBufferByLength(length);
            return buffers;
        }
        catch (BufferUnderflowException bue) {
            if (this.isOpen()) {
                throw bue;
            }
            throw new ClosedChannelException();
        }
    }

    @Override
    protected ByteBuffer readSingleByteBuffer(int length) throws IOException, ClosedChannelException, BufferUnderflowException {
        try {
            return super.readSingleByteBuffer(length);
        }
        catch (BufferUnderflowException bue) {
            if (this.isOpen()) {
                throw bue;
            }
            throw new ClosedChannelException();
        }
    }

    @Override
    public final void setIdleTimeoutMillis(long timeoutMillis) {
        this.idleTimeoutOccured = false;
        if (timeoutMillis <= 0L) {
            LOG.warning("idle timeout " + timeoutMillis + " millis is invalid");
            return;
        }
        this.idleTimeoutMillis = timeoutMillis;
        this.idleTimeoutDateMillis = System.currentTimeMillis() + this.idleTimeoutMillis;
        if (this.idleTimeoutDateMillis < 0L) {
            this.idleTimeoutDateMillis = Long.MAX_VALUE;
        }
        if (this.isConnected.get()) {
            long period = this.idleTimeoutMillis;
            if (this.idleTimeoutMillis > 500L) {
                period = this.idleTimeoutMillis / 5L;
            }
            this.timeoutMgmHandle.updateCheckPeriod(period);
        }
    }

    @Override
    public final void setConnectionTimeoutMillis(long timeoutMillis) {
        this.connectionTimeoutOccured = false;
        if (timeoutMillis <= 0L) {
            LOG.warning("connection timeout " + timeoutMillis + " millis is invalid");
            return;
        }
        this.connectionTimeoutMillis = timeoutMillis;
        this.connectionTimeoutDateMillis = System.currentTimeMillis() + this.connectionTimeoutMillis;
        if (this.isConnected.get()) {
            long period = this.connectionTimeoutMillis;
            if (this.connectionTimeoutMillis > 500L) {
                period = this.connectionTimeoutMillis / 5L;
            }
            this.timeoutMgmHandle.updateCheckPeriod(period);
        }
    }

    @Override
    public final long getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    @Override
    public final long getIdleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.ioHandler.getLocalAddress();
    }

    @Override
    public final String getId() {
        return this.ioHandler.getId();
    }

    @Override
    public final int getLocalPort() {
        return this.ioHandler.getLocalPort();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        return this.ioHandler.getRemoteAddress();
    }

    @Override
    public final int getRemotePort() {
        return this.ioHandler.getRemotePort();
    }

    @Override
    public final int getPendingWriteDataSize() {
        return this.getWriteBufferSize() + this.ioHandler.getPendingWriteDataSize();
    }

    @Override
    public final void suspendRead() throws IOException {
        this.ioHandler.suspendRead();
        this.isSuspended.set(true);
    }

    @Override
    public boolean isReadSuspended() {
        return this.isSuspended.get();
    }

    @Override
    public final void resumeRead() throws IOException {
        this.ioHandler.resumeRead();
        this.isSuspended.set(false);
    }

    @Override
    public long transferFrom(ReadableByteChannel sourceChannel) throws ClosedChannelException, IOException {
        int chunkSize = this.getSoSndBufSize();
        return this.transferFrom(sourceChannel, chunkSize);
    }

    private int getSoSndBufSize() throws IOException {
        if (this.cachedSoSndBuf == null) {
            this.cachedSoSndBuf = (Integer)this.getOption("SOL_SOCKET.SO_SNDBUF");
        }
        return this.cachedSoSndBuf;
    }

    @Override
    protected void onWriteDataInserted() throws IOException, ClosedChannelException {
        if (this.isAutoflush()) {
            this.internalFlush();
        }
    }

    @Override
    public final Object getOption(String name) throws IOException {
        return this.ioHandler.getOption(name);
    }

    @Override
    public final Map<String, Class> getOptions() {
        return this.ioHandler.getOptions();
    }

    @Override
    public void setOption(String name, Object value) throws IOException {
        if (name.equalsIgnoreCase("SOL_SOCKET.SO_SNDBUF")) {
            this.cachedSoSndBuf = (Integer)value;
        }
        this.ioHandler.setOption(name, value);
    }

    @Override
    protected int getWriteTransferChunkeSize() {
        try {
            return this.getSoSndBufSize();
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured by retrieving SoSndBufSize " + ioe.toString());
            }
            return super.getWriteTransferChunkeSize();
        }
    }

    private void forceClose() {
        block3: {
            try {
                this.isOpen.set(false);
                if (this.ioHandler != null) {
                    this.ioHandler.close(true);
                }
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.fine("Error occured by closing " + ioe.toString());
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.isOpen.get()) {
            this.isOpen.set(false);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("closing connection -> flush all remaining data");
            }
            if (!this.isWriteBufferEmpty()) {
                ByteBuffer[] buffers = this.drainWriteQueue();
                this.ioHandler.write(buffers);
                this.ioHandler.flush();
            }
            this.ioHandler.close(false);
        }
    }

    void closeSilence() {
        block2: {
            try {
                this.close();
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by closing connection " + this.getId() + " " + DataConverter.toString(ioe));
            }
        }
    }

    @Override
    public final void flush() throws ClosedChannelException, IOException {
        this.internalFlush();
    }

    private void internalFlush() throws ClosedChannelException, IOException {
        if (!this.isOpen.get()) {
            throw new ClosedChannelException();
        }
        this.removeWriteMark();
        if (this.getFlushmode() == IConnection.FlushMode.SYNC) {
            this.syncFlush();
        } else if (!this.isWriteBufferEmpty()) {
            ByteBuffer[] buffers = this.drainWriteQueue();
            this.ioHandler.write(buffers);
            this.ioHandler.flush();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] flushed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFlush() throws ClosedChannelException, IOException {
        long start = System.currentTimeMillis();
        long remainingTime = sendTimeoutMillis;
        if (ConnectionUtils.isDispatcherThread()) {
            String msg = "synchronized flushing in NonThreaded mode could cause dead locks (hint: set flush mode to ASYNC)";
            LOG.warning("[" + this.getId() + "] " + msg);
        }
        Object object = this.writeSynchronizer;
        synchronized (object) {
            if (!this.isWriteBufferEmpty()) {
                try {
                    ByteBuffer[] buffers = this.drainWriteQueue();
                    this.pendingWriteConfirmations.addAll(Arrays.asList(buffers));
                    this.ioHandler.write(buffers);
                    this.ioHandler.flush();
                    do {
                        if (this.pendingWriteConfirmations.isEmpty()) {
                            return;
                        }
                        if (this.writeException != null) {
                            IOException ioe = this.writeException;
                            this.writeException = null;
                            throw ioe;
                        }
                        try {
                            this.writeSynchronizer.wait(remainingTime);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                    } while ((remainingTime = start + sendTimeoutMillis - System.currentTimeMillis()) > 0L);
                    throw new SocketTimeoutException("send timeout " + DataConverter.toFormatedDuration(sendTimeoutMillis) + " reached. returning from sync flushing");
                }
                finally {
                    this.pendingWriteConfirmations.clear();
                }
            }
        }
    }

    public String toString() {
        try {
            if (this.isOpen()) {
                String s = "id=" + this.getId() + ", remote=" + this.getRemoteAddress() + "(" + this.getRemoteAddress() + ":" + this.getRemotePort() + ")";
                return s;
            }
            String s = "id=" + this.getId() + " (closed)";
            return s;
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    String toDetailedString() {
        try {
            if (this.isOpen()) {
                return "id=" + this.getId() + ", remote=" + this.getRemoteAddress().getCanonicalHostName() + "(" + this.getRemoteAddress() + ":" + this.getRemotePort() + ") lastTimeReceived=" + DF.format(new Date(this.getLastTimeReceivedMillis())) + " reveived=" + this.getNumberOfReceivedBytes() + " send=" + this.getNumberOfSendBytes() + " ops={" + this.getRegisteredOpsInfo() + "}";
            }
            return "id=" + this.getId() + " (closed)";
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    private static IoChainableHandler createClientIoHandler(InetSocketAddress remoteAddress, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        IoChainableHandler ioHandler = null;
        ioHandler = sslContext != null ? ConnectionUtils.getIoProvider().createSSLClientIoHandler(remoteAddress, connectTimeoutMillis, options, sslContext, sslOn) : ConnectionUtils.getIoProvider().createClientIoHandler(remoteAddress, connectTimeoutMillis, options);
        return ioHandler;
    }

    static {
        try {
            sendTimeoutMillis = Long.valueOf(System.getProperty(SEND_TIMEOUT_KEY, Long.toString(60000L)));
        }
        catch (Exception e) {
            LOG.warning("invalid value for system property org.xsocket.stream.send_timeout_millis: " + System.getProperty(SEND_TIMEOUT_KEY) + " (valid is a int value)" + " using default");
            sendTimeoutMillis = 60000L;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("non blocking connection send time out set with " + DataConverter.toFormatedDuration(sendTimeoutMillis));
        }
        executor = Executors.newCachedThreadPool();
        DEFAULT_CONNECTION_MANAGER = new TimeoutManager();
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "xNbcPool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private final class IoHandlerCallback
    implements IIoHandlerCallback {
        private IoHandlerCallback() {
        }

        public void onWritten(ByteBuffer data) {
            NonBlockingConnection.this.onWritten(data);
        }

        public void onWriteException(IOException ioException, ByteBuffer data) {
            NonBlockingConnection.this.onWriteException(ioException, data);
        }

        public void onData(ByteBuffer[] data) {
            NonBlockingConnection.this.onData(data);
        }

        public void onPostData() {
            NonBlockingConnection.this.onPostData();
        }

        public void onConnectionAbnormalTerminated() {
            NonBlockingConnection.this.onConnectionAbnormalTerminated();
        }

        public void onConnect() {
            NonBlockingConnection.this.onConnect();
        }

        public void onDisconnect() {
            NonBlockingConnection.this.onDisconnect();
        }
    }
}

