/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.connection.IIoHandlerCallback;
import org.xsocket.connection.IoChainableHandler;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.IoQueue;

final class IoThrottledWriteHandler
extends IoChainableHandler {
    private static final Logger LOG = Logger.getLogger(IoThrottledWriteHandler.class.getName());
    private static final int PERIOD_MILLIS = 500;
    private final IoQueue writeQueue = new IoQueue();
    private final ArrayList<ByteBuffer> throttledSendQueue = new ArrayList(1);
    private int writeSize = Integer.MAX_VALUE;
    private TimerTask delayedDelivererTask = null;

    IoThrottledWriteHandler(IoChainableHandler successor) {
        super(successor);
    }

    public void init(IIoHandlerCallback callbackHandler) throws IOException {
        this.setPreviousCallback(callbackHandler);
        this.getSuccessor().init(callbackHandler);
    }

    public boolean reset() {
        this.throttledSendQueue.clear();
        this.writeSize = Integer.MAX_VALUE;
        if (this.delayedDelivererTask != null) {
            this.delayedDelivererTask.cancel();
            this.delayedDelivererTask = null;
        }
        return super.reset();
    }

    void setWriteRateSec(int writeRateSec) {
        this.writeSize = 500 * writeRateSec / 1000;
        if (this.writeSize <= 0) {
            this.writeSize = 1;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("write transfer rate set to " + writeRateSec);
        }
    }

    public int getPendingWriteDataSize() {
        return this.getSendQueueSize() + super.getPendingWriteDataSize();
    }

    public boolean hasDataToSend() {
        return this.getSendQueueSize() > 0 || super.hasDataToSend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSendQueueSize() {
        int size = 0;
        ArrayList copy = null;
        ArrayList<ByteBuffer> arrayList = this.throttledSendQueue;
        synchronized (arrayList) {
            copy = (ArrayList)this.throttledSendQueue.clone();
        }
        for (ByteBuffer buffer : copy) {
            size += buffer.remaining();
        }
        return size;
    }

    public void close(boolean immediate) throws IOException {
        if (!immediate) {
            this.hardFlush();
        }
        this.getSuccessor().close(immediate);
    }

    public void write(ByteBuffer[] buffers) throws ClosedChannelException, IOException {
        this.writeQueue.append(buffers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        IoQueue ioQueue = this.writeQueue;
        synchronized (ioQueue) {
            for (ByteBuffer buffer : this.writeQueue.drain()) {
                this.writeOutgoing(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutgoing(ByteBuffer buffer) {
        int size = buffer.remaining();
        if (size > 0) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] add buffer (" + buffer.remaining() + " bytes) to delay queue");
            }
            ArrayList<ByteBuffer> arrayList = this.throttledSendQueue;
            synchronized (arrayList) {
                this.throttledSendQueue.add(buffer);
            }
        }
        if (this.delayedDelivererTask == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] delay delivery task is null. Starting task (period=" + DataConverter.toFormatedDuration(500L) + ")");
            }
            this.delayedDelivererTask = new DeliveryTask(this);
            IoProvider.getTimer().schedule(this.delayedDelivererTask, 0L, 500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hardFlush() throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("flush all remaning data (" + this.getSendQueueSize() + ")");
        }
        this.write();
        ArrayList<ByteBuffer> arrayList = this.throttledSendQueue;
        synchronized (arrayList) {
            block9: {
                if (!this.throttledSendQueue.isEmpty()) {
                    ByteBuffer[] entries = this.throttledSendQueue.toArray(new ByteBuffer[this.throttledSendQueue.size()]);
                    this.throttledSendQueue.clear();
                    ByteBuffer[] buffers = new ByteBuffer[entries.length];
                    for (int i = 0; i < buffers.length; ++i) {
                        buffers[i] = entries[i];
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] flushing " + buffers.length + " buffers of delay queue");
                    }
                    try {
                        this.getSuccessor().write(buffers);
                        this.getSuccessor().flush();
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block9;
                        LOG.fine("[" + this.getId() + "] error occured while writing. Reason: " + e.toString());
                    }
                }
            }
        }
        this.getSuccessor().hardFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeChunk() {
        block8: {
            int sizeToWrite = this.writeSize;
            try {
                ArrayList<ByteBuffer> arrayList = this.throttledSendQueue;
                synchronized (arrayList) {
                    while (sizeToWrite > 0 && !this.throttledSendQueue.isEmpty()) {
                        ByteBuffer buffer = this.throttledSendQueue.remove(0);
                        if (buffer.remaining() > sizeToWrite) {
                            int saveLimit = buffer.limit();
                            buffer.limit(sizeToWrite);
                            ByteBuffer newBuffer = buffer.slice();
                            buffer.position(buffer.limit());
                            buffer.limit(saveLimit);
                            this.throttledSendQueue.add(0, buffer.slice());
                            buffer = newBuffer;
                        }
                        sizeToWrite -= buffer.remaining();
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + this.getId() + "] release " + buffer.remaining() + " bytes from delay queue (remaining size = " + this.getSendQueueSize() + ")");
                        }
                        this.getSuccessor().write(new ByteBuffer[]{buffer});
                        this.getSuccessor().flush();
                    }
                }
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block8;
                LOG.fine("[" + this.getId() + "] error occured by writing queue data " + DataConverter.toString(ioe));
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(pending delayQueueSize=" + DataConverter.toFormatedBytesSize(this.getPendingWriteDataSize()) + ") ->" + "\r\n" + this.getSuccessor().toString();
    }

    private static final class DeliveryTask
    extends TimerTask {
        private WeakReference<IoThrottledWriteHandler> ioThrottledWriteHandlerRef = null;

        public DeliveryTask(IoThrottledWriteHandler ioThrottledWriteHandler) {
            this.ioThrottledWriteHandlerRef = new WeakReference<IoThrottledWriteHandler>(ioThrottledWriteHandler);
        }

        public void run() {
            IoThrottledWriteHandler ioThrottledWriteHandler = (IoThrottledWriteHandler)this.ioThrottledWriteHandlerRef.get();
            if (ioThrottledWriteHandler == null) {
                this.cancel();
            } else {
                ioThrottledWriteHandler.writeChunk();
            }
        }
    }
}

