/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.MaxReadSizeExceededException;

final class ReadQueue {
    private static final Logger LOG = Logger.getLogger(ReadQueue.class.getName());
    private Queue queue = new Queue();
    private ByteBuffer[] readMarkBuffer = null;
    private boolean isReadMarked = false;
    private int readMarkVersion = -1;
    private int readMarkAppendVersion = -1;

    ReadQueue() {
    }

    public void reset() {
        this.readMarkBuffer = null;
        this.isReadMarked = false;
        this.queue.reset();
    }

    public boolean isEmpty() {
        return this.queue.getSize() == 0;
    }

    public int geVersion() {
        return this.queue.getVersion();
    }

    public void append(ByteBuffer[] bufs, int size) {
        assert (size == ReadQueue.computeSize(bufs));
        if (size > 0) {
            this.queue.append(bufs, size);
        }
    }

    private static int computeSize(ByteBuffer[] bufs) {
        int size = 0;
        for (ByteBuffer buf : bufs) {
            size += buf.remaining();
        }
        return size;
    }

    public int retrieveIndexOf(byte[] delimiter, int maxReadSize) throws IOException, MaxReadSizeExceededException {
        return this.queue.retrieveIndexOf(delimiter, maxReadSize);
    }

    public int getSize() {
        return this.queue.getSize();
    }

    public ByteBuffer[] readAvailable() {
        ByteBuffer[] buffers = this.queue.drain();
        this.onExtracted(buffers);
        return buffers;
    }

    public ByteBuffer[] copyAvailable() {
        ByteBuffer[] buffers = this.queue.copy();
        this.onExtracted(buffers);
        return buffers;
    }

    public ByteBuffer[] readByteBufferByDelimiter(byte[] delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        ByteBuffer[] buffers = this.queue.readByteBufferByDelimiter(delimiter, maxLength);
        this.onExtracted(buffers, delimiter);
        return buffers;
    }

    public ByteBuffer[] readByteBufferByLength(int length) throws BufferUnderflowException {
        ByteBuffer[] buffers = this.queue.readByteBufferByLength(length);
        this.onExtracted(buffers);
        return buffers;
    }

    public ByteBuffer readSingleByteBuffer(int length) throws BufferUnderflowException {
        if (this.getSize() < length) {
            throw new BufferUnderflowException();
        }
        ByteBuffer buffer = this.queue.readSingleByteBuffer(length);
        this.onExtracted(buffer);
        return buffer;
    }

    public long transferTo(WritableByteChannel target) throws ClosedChannelException, IOException, SocketTimeoutException {
        long written = 0L;
        ByteBuffer[] buffers = this.readAvailable();
        this.onExtracted(buffers);
        for (ByteBuffer buffer : buffers) {
            written += (long)target.write(buffer);
        }
        return written;
    }

    public long transferTo(WritableByteChannel target, int maxLength) throws ClosedChannelException, IOException, SocketTimeoutException {
        long written = 0L;
        int length = maxLength;
        int available = this.getSize();
        if (available < length) {
            length = available;
        }
        ByteBuffer[] buffers = this.queue.readByteBufferByLength(length);
        this.onExtracted(buffers);
        for (ByteBuffer buffer : buffers) {
            written += (long)target.write(buffer);
        }
        return written;
    }

    public void markReadPosition() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("mark read position");
        }
        this.removeReadMark();
        this.isReadMarked = true;
        this.readMarkVersion = this.queue.getVersion();
        this.readMarkAppendVersion = this.queue.getAppendVersion();
    }

    public boolean resetToReadMark() {
        if (this.isReadMarked) {
            if (this.readMarkBuffer != null) {
                this.queue.addFirst(this.readMarkBuffer);
                this.removeReadMark();
                this.queue.resetVersionIfAppendVersionMatch(this.readMarkVersion, this.readMarkAppendVersion);
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("reset read mark. nothing to return to read queue");
            }
            return true;
        }
        return false;
    }

    public void removeReadMark() {
        this.isReadMarked = false;
        this.readMarkBuffer = null;
    }

    private void onExtracted(ByteBuffer[] buffers) {
        if (this.isReadMarked) {
            for (ByteBuffer buffer : buffers) {
                this.onExtracted(buffer);
            }
        }
    }

    private void onExtracted(ByteBuffer[] buffers, byte[] delimiter) {
        if (this.isReadMarked) {
            if (buffers != null) {
                for (ByteBuffer buffer : buffers) {
                    this.onExtracted(buffer);
                }
            }
            this.onExtracted(ByteBuffer.wrap(delimiter));
        }
    }

    private void onExtracted(ByteBuffer buffer) {
        if (this.isReadMarked) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("add data (" + DataConverter.toFormatedBytesSize(buffer.remaining()) + ") to read mark buffer ");
            }
            if (this.readMarkBuffer == null) {
                this.readMarkBuffer = new ByteBuffer[1];
                this.readMarkBuffer[0] = buffer.duplicate();
            } else {
                ByteBuffer[] newReadMarkBuffer = new ByteBuffer[this.readMarkBuffer.length + 1];
                System.arraycopy(this.readMarkBuffer, 0, newReadMarkBuffer, 0, this.readMarkBuffer.length);
                newReadMarkBuffer[this.readMarkBuffer.length] = buffer.duplicate();
                this.readMarkBuffer = newReadMarkBuffer;
            }
        }
    }

    public String toString() {
        return this.queue.toString();
    }

    public String asString(String encoding) {
        return this.queue.asString(encoding);
    }

    private static final class Index
    implements Cloneable {
        public static final int NULL = -1;
        private boolean hasDelimiterFound = false;
        private byte[] delimiterBytes = null;
        private int delimiterLength = 0;
        private int delimiterPos = 0;
        private int readBytes = 0;
        ByteBuffer lastScannedBuffer = null;

        Index(byte[] delimiterBytes) {
            this.delimiterBytes = delimiterBytes;
            this.delimiterLength = delimiterBytes.length;
        }

        public boolean hasDelimiterFound() {
            return this.hasDelimiterFound;
        }

        int getContentLength() {
            if (this.hasDelimiterFound) {
                return this.readBytes - this.delimiterLength;
            }
            return -1;
        }

        public int getReadBytes() {
            return this.readBytes;
        }

        public boolean isDelimiterEquals(byte[] other) {
            if (other.length != this.delimiterLength) {
                return false;
            }
            for (int i = 0; i < this.delimiterLength; ++i) {
                if (other[i] == this.delimiterBytes[i]) continue;
                return false;
            }
            return true;
        }

        protected Object clone() throws CloneNotSupportedException {
            Index copy = (Index)super.clone();
            return copy;
        }

        public String toString() {
            return "found=" + this.hasDelimiterFound + " delimiterPos=" + this.delimiterPos + " delimiterLength=" + this.delimiterLength + " readBytes=" + this.readBytes;
        }
    }

    private static final class Queue {
        private static final int THRESHOLD_COMPACT_BUFFER_COUNT_TOTAL = 20;
        private static final int THRESHOLD_COMPACT_BUFFER_COUNT_EMPTY = 10;
        private ByteBuffer[] buffers = null;
        private Integer currentSize = null;
        private int version = 0;
        private int appendVersion = 0;
        private Index cachedIndex = null;

        private Queue() {
        }

        public synchronized void reset() {
            this.buffers = null;
            this.currentSize = null;
            this.cachedIndex = null;
        }

        public synchronized int getVersion() {
            return this.version;
        }

        synchronized int getAppendVersion() {
            return this.appendVersion;
        }

        synchronized void resetVersionIfAppendVersionMatch(int version, int appendVer) {
            if (appendVer == this.appendVersion) {
                this.version = version;
            }
        }

        public synchronized int getSize() {
            return this.size();
        }

        private int size() {
            if (this.currentSize != null) {
                return this.currentSize;
            }
            if (this.buffers == null) {
                return 0;
            }
            int size = 0;
            for (int i = 0; i < this.buffers.length; ++i) {
                if (this.buffers[i] == null) continue;
                size += this.buffers[i].remaining();
            }
            this.currentSize = size;
            return size;
        }

        public synchronized void append(ByteBuffer[] bufs, int size) {
            ++this.appendVersion;
            ++this.version;
            assert (!Queue.containsEmptyBuffer(bufs));
            if (this.buffers == null) {
                this.buffers = bufs;
                this.currentSize = size;
            } else {
                this.currentSize = null;
                ByteBuffer[] newBuffers = new ByteBuffer[this.buffers.length + bufs.length];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                System.arraycopy(bufs, 0, newBuffers, this.buffers.length, bufs.length);
                this.buffers = newBuffers;
            }
        }

        public synchronized void addFirst(ByteBuffer[] bufs) {
            ++this.version;
            this.currentSize = null;
            this.cachedIndex = null;
            assert (!Queue.containsEmptyBuffer(bufs));
            this.addFirstSilence(bufs);
        }

        private void addFirstSilence(ByteBuffer[] bufs) {
            this.currentSize = null;
            if (this.buffers == null) {
                this.buffers = bufs;
            } else {
                ByteBuffer[] newBuffers = new ByteBuffer[this.buffers.length + bufs.length];
                System.arraycopy(bufs, 0, newBuffers, 0, bufs.length);
                System.arraycopy(this.buffers, 0, newBuffers, bufs.length, this.buffers.length);
                this.buffers = newBuffers;
            }
        }

        private static boolean containsEmptyBuffer(ByteBuffer[] bufs) {
            boolean containsEmtpyBuffer = false;
            for (ByteBuffer buf : bufs) {
                if (buf != null) continue;
                containsEmtpyBuffer = true;
            }
            return containsEmtpyBuffer;
        }

        public synchronized ByteBuffer[] drain() {
            this.currentSize = null;
            this.cachedIndex = null;
            ByteBuffer[] result = this.buffers;
            this.buffers = null;
            if (result != null) {
                ++this.version;
            }
            return Queue.removeEmptyBuffers(result);
        }

        public synchronized ByteBuffer[] copy() {
            if (this.buffers == null) {
                return new ByteBuffer[0];
            }
            ByteBuffer[] result = new ByteBuffer[this.buffers.length];
            for (int i = 0; i < this.buffers.length; ++i) {
                result[i] = this.buffers[i].duplicate();
            }
            return Queue.removeEmptyBuffers(result);
        }

        public synchronized ByteBuffer readSingleByteBuffer(int length) throws BufferUnderflowException {
            if (this.buffers == null) {
                throw new BufferUnderflowException();
            }
            if (!this.isSizeEqualsOrLargerThan(length)) {
                throw new BufferUnderflowException();
            }
            if (length == 0) {
                return ByteBuffer.allocate(0);
            }
            ByteBuffer result = null;
            int countEmptyBuffer = 0;
            block0: for (int i = 0; i < this.buffers.length; ++i) {
                if (this.buffers[i] == null) {
                    ++countEmptyBuffer;
                    continue;
                }
                if (this.buffers[i].remaining() == length) {
                    result = this.buffers[i];
                    this.buffers[i] = null;
                    break;
                }
                if (this.buffers[i].remaining() > length) {
                    int savedLimit = this.buffers[i].limit();
                    int savedPos = this.buffers[i].position();
                    this.buffers[i].limit(this.buffers[i].position() + length);
                    result = this.buffers[i].slice();
                    this.buffers[i].position(savedPos + length);
                    this.buffers[i].limit(savedLimit);
                    this.buffers[i] = this.buffers[i].slice();
                    break;
                }
                result = ByteBuffer.allocate(length);
                int written = 0;
                for (int j = i; j < this.buffers.length; ++j) {
                    if (this.buffers[j] == null) {
                        ++countEmptyBuffer;
                        continue;
                    }
                    while (this.buffers[j].hasRemaining()) {
                        result.put(this.buffers[j].get());
                        if (++written != length) continue;
                        this.buffers[j] = this.buffers[j].position() < this.buffers[j].limit() ? this.buffers[j].slice() : null;
                        result.clear();
                        break block0;
                    }
                    this.buffers[j] = null;
                }
            }
            if (result == null) {
                throw new BufferUnderflowException();
            }
            if (countEmptyBuffer >= 10) {
                this.compact();
            }
            this.currentSize = null;
            this.cachedIndex = null;
            ++this.version;
            return result;
        }

        public ByteBuffer[] readByteBufferByLength(int length) throws BufferUnderflowException {
            if (length == 0) {
                return new ByteBuffer[0];
            }
            return this.extract(length, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuffer[] readByteBufferByDelimiter(byte[] delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            Queue queue = this;
            synchronized (queue) {
                if (this.buffers == null) {
                    throw new BufferUnderflowException();
                }
            }
            int index = this.retrieveIndexOf(delimiter, maxLength);
            if (index >= 0) {
                return this.extract(index, delimiter.length);
            }
            throw new BufferUnderflowException();
        }

        private synchronized ByteBuffer[] extract(int length, int countTailingBytesToRemove) throws BufferUnderflowException {
            ByteBuffer[] extracted = null;
            int size = this.size();
            if (length == size) {
                return this.drain();
            }
            if (size < length) {
                throw new BufferUnderflowException();
            }
            extracted = this.extractBuffers(length);
            if (countTailingBytesToRemove > 0) {
                this.extractBuffers(countTailingBytesToRemove);
            }
            this.compact();
            this.currentSize = null;
            this.cachedIndex = null;
            ++this.version;
            return extracted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int retrieveIndexOf(byte[] delimiter, int maxReadSize) throws IOException, MaxReadSizeExceededException {
            ByteBuffer[] bufs = null;
            Queue queue = this;
            synchronized (queue) {
                if (this.buffers == null) {
                    return -1;
                }
                bufs = this.buffers;
                this.buffers = null;
            }
            int index = this.retrieveIndexOf(delimiter, bufs, maxReadSize);
            Queue queue2 = this;
            synchronized (queue2) {
                this.addFirstSilence(bufs);
            }
            if (index == -2) {
                throw new MaxReadSizeExceededException();
            }
            return index;
        }

        private int retrieveIndexOf(byte[] delimiter, ByteBuffer[] buffers, int maxReadSize) {
            Integer length = null;
            if (buffers == null) {
                return -1;
            }
            Index index = this.scanByDelimiter(buffers, delimiter);
            length = index.hasDelimiterFound() ? (index.getReadBytes() <= maxReadSize ? Integer.valueOf(index.getReadBytes() - delimiter.length) : null) : null;
            this.cachedIndex = index;
            if (length == null) {
                if (index.getReadBytes() >= maxReadSize) {
                    return -2;
                }
                return -1;
            }
            return length;
        }

        private Index scanByDelimiter(ByteBuffer[] buffers, byte[] delimiter) {
            if (this.cachedIndex != null && this.cachedIndex.isDelimiterEquals(delimiter)) {
                if (this.cachedIndex.hasDelimiterFound()) {
                    return this.cachedIndex;
                }
                return this.find(buffers, this.cachedIndex);
            }
            return this.find(buffers, delimiter);
        }

        private boolean isSizeEqualsOrLargerThan(int requiredSize) {
            if (this.buffers == null) {
                return false;
            }
            int bufferSize = 0;
            for (int i = 0; i < this.buffers.length; ++i) {
                if (this.buffers[i] == null || (bufferSize += this.buffers[i].remaining()) < requiredSize) continue;
                return true;
            }
            return false;
        }

        private ByteBuffer[] extractBuffers(int length) {
            ByteBuffer[] extracted = null;
            int remainingToExtract = length;
            ByteBuffer buffer = null;
            for (int i = 0; i < this.buffers.length; ++i) {
                buffer = this.buffers[i];
                if (buffer == null) continue;
                int bufLength = buffer.limit() - buffer.position();
                if (remainingToExtract >= bufLength) {
                    extracted = Queue.appendBuffer(extracted, buffer);
                    remainingToExtract -= bufLength;
                    this.buffers[i] = null;
                } else {
                    ByteBuffer rightPart;
                    int savedLimit = buffer.limit();
                    buffer.limit(buffer.position() + remainingToExtract);
                    ByteBuffer leftPart = buffer.slice();
                    extracted = Queue.appendBuffer(extracted, leftPart);
                    buffer.position(buffer.limit());
                    buffer.limit(savedLimit);
                    this.buffers[i] = rightPart = buffer.slice();
                    remainingToExtract = 0;
                }
                if (remainingToExtract != 0) continue;
                return extracted;
            }
            return new ByteBuffer[0];
        }

        private static ByteBuffer[] appendBuffer(ByteBuffer[] buffers, ByteBuffer buffer) {
            if (buffers == null) {
                ByteBuffer[] result = new ByteBuffer[]{buffer};
                return result;
            }
            ByteBuffer[] result = new ByteBuffer[buffers.length + 1];
            System.arraycopy(buffers, 0, result, 0, buffers.length);
            result[buffers.length] = buffer;
            return result;
        }

        private void compact() {
            if (this.buffers != null && this.buffers.length > 20) {
                int emptyBuffers = 0;
                for (int i = 0; i < this.buffers.length; ++i) {
                    if (this.buffers[i] != null) continue;
                    ++emptyBuffers;
                }
                if (emptyBuffers > 10) {
                    if (emptyBuffers == this.buffers.length) {
                        this.buffers = null;
                    } else {
                        ByteBuffer[] newByteBuffer = new ByteBuffer[this.buffers.length - emptyBuffers];
                        int num = 0;
                        for (int i = 0; i < this.buffers.length; ++i) {
                            if (this.buffers[i] == null) continue;
                            newByteBuffer[num] = this.buffers[i];
                            ++num;
                        }
                        this.buffers = newByteBuffer;
                    }
                }
            }
        }

        private static ByteBuffer[] removeEmptyBuffers(ByteBuffer[] buffers) {
            if (buffers == null) {
                return buffers;
            }
            int countEmptyBuffers = 0;
            for (int i = 0; i < buffers.length; ++i) {
                if (buffers[i] != null) continue;
                ++countEmptyBuffers;
            }
            if (countEmptyBuffers > 0) {
                if (countEmptyBuffers == buffers.length) {
                    return new ByteBuffer[0];
                }
                ByteBuffer[] newBuffers = new ByteBuffer[buffers.length - countEmptyBuffers];
                int num = 0;
                for (int i = 0; i < buffers.length; ++i) {
                    if (buffers[i] == null) continue;
                    newBuffers[num] = buffers[i];
                    ++num;
                }
                return newBuffers;
            }
            return buffers;
        }

        public String toString() {
            try {
                ByteBuffer[] copy = (ByteBuffer[])this.buffers.clone();
                for (int i = 0; i < copy.length; ++i) {
                    if (copy[i] == null) continue;
                    copy[i] = copy[i].duplicate();
                }
                return DataConverter.toTextAndHexString(copy, "UTF-8", 300);
            }
            catch (NullPointerException npe) {
                return "";
            }
            catch (Exception e) {
                return e.toString();
            }
        }

        synchronized String asString(String encoding) {
            try {
                ByteBuffer[] copy = (ByteBuffer[])this.buffers.clone();
                for (int i = 0; i < copy.length; ++i) {
                    if (copy[i] == null) continue;
                    copy[i] = copy[i].duplicate();
                }
                return DataConverter.toString(copy, encoding);
            }
            catch (NullPointerException npe) {
                return "";
            }
            catch (Exception e) {
                return e.toString();
            }
        }

        private Index find(ByteBuffer[] bufferQueue, byte[] delimiter) {
            return this.find(bufferQueue, new Index(delimiter));
        }

        private Index find(ByteBuffer[] buffers, Index index) {
            for (int i = this.findFirstBufferToScan(buffers, index); i < buffers.length && !index.hasDelimiterFound; ++i) {
                ByteBuffer buffer = buffers[i];
                if (buffer == null) continue;
                int savedPos = buffer.position();
                int savedLimit = buffer.limit();
                this.findInBuffer(buffer, index);
                buffer.position(savedPos);
                buffer.limit(savedLimit);
            }
            return index;
        }

        private int findFirstBufferToScan(ByteBuffer[] buffers, Index index) {
            int i = 0;
            if (index.lastScannedBuffer != null) {
                for (int j = 0; j < buffers.length; ++j) {
                    if (buffers[j] != index.lastScannedBuffer) continue;
                    i = j;
                    break;
                }
                if (++i >= buffers.length) {
                    return i;
                }
                for (int k = i; k < buffers.length; ++k) {
                    if (buffers[k] == null) continue;
                    i = k;
                    break;
                }
                if (i >= buffers.length) {
                    return i;
                }
            }
            return i;
        }

        private void findInBuffer(ByteBuffer buffer, Index index) {
            index.lastScannedBuffer = buffer;
            int dataSize = buffer.remaining();
            byte[] delimiter = index.delimiterBytes;
            int delimiterLength = index.delimiterLength;
            int delimiterPosition = index.delimiterPos;
            byte nextDelimiterByte = delimiter[delimiterPosition];
            boolean delimiterPartsFound = delimiterPosition > 0;
            for (int i = 0; i < dataSize; ++i) {
                byte b = buffer.get();
                if (b == nextDelimiterByte) {
                    ++delimiterPosition;
                    if (delimiterLength == 1) {
                        index.hasDelimiterFound = true;
                        index.delimiterPos = delimiterPosition;
                        index.readBytes += i + 1;
                        return;
                    }
                    index.delimiterPos = delimiterPosition;
                    if (delimiterPosition == delimiterLength) {
                        index.hasDelimiterFound = true;
                        index.readBytes += i + 1;
                        return;
                    }
                    nextDelimiterByte = delimiter[delimiterPosition];
                    delimiterPartsFound = true;
                    continue;
                }
                if (!delimiterPartsFound) continue;
                delimiterPosition = 0;
                index.delimiterPos = 0;
                nextDelimiterByte = delimiter[delimiterPosition];
                delimiterPartsFound = false;
                if (delimiterLength <= 1 || b != nextDelimiterByte) continue;
                nextDelimiterByte = delimiter[++delimiterPosition];
                index.delimiterPos = delimiterPosition;
            }
            index.readBytes += dataSize;
        }
    }
}

