/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.connection.AbstractMemoryManager;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.IoSocketHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoSocketDispatcher
implements Runnable,
Closeable {
    private static final Logger LOG = Logger.getLogger(IoSocketDispatcher.class.getName());
    static final String DISPATCHER_PREFIX = "xDispatcher";
    private static final long TIMEOUT_SHUTDOWN_MILLIS = 5000L;
    private static final int MAX_DIRECT_CALLS = 10;
    private static final boolean IS_DETACH_HANDLE_ON_NO_OPS = IoProvider.getDetachHandleOnNoOps();
    private static boolean isBypassingWriteAllowed = IoProvider.isBypassingWriteAllowed();
    private final ConcurrentLinkedQueue<Runnable> registerQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<IoSocketHandler> deregisterQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Runnable> keyUpdateQueue = new ConcurrentLinkedQueue();
    private static int nextId = 1;
    private final String name;
    private final int id;
    private static final ThreadLocal<Integer> THREADBOUND_ID = new ThreadLocal();
    private static final ThreadLocal<Integer> DIRECT_CALL_COUNTER = new ThreadLocal();
    private volatile boolean isOpen = true;
    private Closer closer = new Closer();
    private final Selector selector;
    private boolean isSelectedKeysSetModified = false;
    private final AbstractMemoryManager memoryManager;
    private static final Integer MAX_HANDLES = IoProvider.getMaxHandles();
    private TimerTask sizeUpdateTask;
    private int registeredHandles = 0;
    private long statisticsStartTime = System.currentTimeMillis();
    private long countIdleTimeouts = 0L;
    private long countConnectionTimeouts = 0L;
    private long handledRegistractions = 0L;
    private long handledReads = 0L;
    private long handledWrites = 0L;
    private long lastRequestReceiveRate = System.currentTimeMillis();
    private long lastRequestSendRate = System.currentTimeMillis();
    private long receivedBytes = 0L;
    private long sentBytes = 0L;
    private long countUnregisteredWrite = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoSocketDispatcher(AbstractMemoryManager memoryManager, String name) {
        this.memoryManager = memoryManager;
        this.name = DISPATCHER_PREFIX + name;
        IoSocketDispatcher ioSocketDispatcher = this;
        synchronized (ioSocketDispatcher) {
            this.id = nextId++;
        }
        if (MAX_HANDLES != null) {
            this.sizeUpdateTask = new TimerTask(){

                public void run() {
                    int registered = IoSocketDispatcher.this.selector.keys().size();
                    if (registered < IoSocketDispatcher.this.registeredHandles) {
                        IoSocketDispatcher.this.registeredHandles--;
                    }
                }
            };
            IoProvider.getTimer().schedule(this.sizeUpdateTask, 2000L, 2000L);
        }
        try {
            this.selector = Selector.open();
        }
        catch (IOException ioe) {
            String text = "exception occured while opening selector. Reason: " + ioe.toString();
            LOG.severe(text);
            throw new RuntimeException(text, ioe);
        }
    }

    static void setBypassingWriteAllowed(boolean allowed) {
        isBypassingWriteAllowed = allowed;
    }

    String getName() {
        return this.name;
    }

    int getId() {
        return this.id;
    }

    private static Integer getThreadBoundId() {
        return THREADBOUND_ID.get();
    }

    private static Integer getDirectCallCounter() {
        return DIRECT_CALL_COUNTER.get();
    }

    private static void incDirectCallCounter() {
        int i = IoSocketDispatcher.getDirectCallCounter();
        DIRECT_CALL_COUNTER.set(++i);
    }

    private static void resetDirectCallCounter() {
        DIRECT_CALL_COUNTER.set(0);
    }

    long getCountUnregisteredWrite() {
        return this.countUnregisteredWrite;
    }

    Integer getHandlesMaxCount() {
        return MAX_HANDLES;
    }

    int getRegisteredHandles() {
        return this.registeredHandles;
    }

    boolean isDetachHandleOnNoOps() {
        return IS_DETACH_HANDLE_ON_NO_OPS;
    }

    boolean isBypassingWriteAllowed() {
        return isBypassingWriteAllowed;
    }

    @Override
    public void run() {
        block7: {
            Thread.currentThread().setName(this.name);
            THREADBOUND_ID.set(this.id);
            DIRECT_CALL_COUNTER.set(0);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("selector " + this.name + " listening ...");
            }
            int handledTasks = 0;
            while (this.isOpen) {
                try {
                    int eventCount = this.selector.select(1000L);
                    handledTasks = this.performRegisterHandlerTasks();
                    handledTasks += this.performKeyUpdateTasks();
                    if (eventCount > 0) {
                        this.handleReadWriteKeys();
                    }
                    handledTasks += this.performDeregisterHandlerTasks();
                }
                catch (Exception e) {
                    LOG.warning("[" + Thread.currentThread().getName() + "] exception occured while processing. Reason " + DataConverter.toString(e));
                }
            }
            try {
                this.selector.close();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.fine("error occured by close selector within tearDown " + DataConverter.toString(e));
            }
        }
    }

    private void handleReadWriteKeys() {
        Set<SelectionKey> selectedEventKeys = this.selector.selectedKeys();
        this.isSelectedKeysSetModified = false;
        Iterator<SelectionKey> it = selectedEventKeys.iterator();
        while (it.hasNext() && !this.isSelectedKeysSetModified) {
            try {
                SelectionKey eventKey = it.next();
                it.remove();
                IoSocketHandler socketHandler = (IoSocketHandler)eventKey.attachment();
                if (eventKey.isValid() && eventKey.isReadable()) {
                    this.onReadableEvent(socketHandler);
                }
                if (!eventKey.isValid() || !eventKey.isWritable()) continue;
                this.onWriteableEvent(socketHandler);
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("error occured by handling selection keys + " + e.toString());
            }
        }
    }

    private void onReadableEvent(IoSocketHandler socketHandler) {
        block3: {
            try {
                long read = socketHandler.onReadableEvent();
                this.receivedBytes += read;
                ++this.handledReads;
            }
            catch (ClosedChannelException ce) {
                socketHandler.closeSilence(false);
            }
            catch (Exception t) {
                socketHandler.closeSilence(false);
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.fine("[" + socketHandler.getId() + "] error occured by handling readable event. reason: " + t.toString());
            }
        }
    }

    private void onWriteableEvent(IoSocketHandler socketHandler) {
        block3: {
            try {
                this.onWriteableEventUnprotected(socketHandler);
            }
            catch (ClosedChannelException ce) {
                socketHandler.closeSilence(false);
            }
            catch (Exception t) {
                socketHandler.closeSilence(false);
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.fine("[" + socketHandler.getId() + "] error occured by handling readable event. reason: " + t.toString());
            }
        }
    }

    private void onWriteableEventUnprotected(IoSocketHandler socketHandler) throws IOException {
        socketHandler.onWriteableEvent();
        ++this.handledWrites;
    }

    void incSentBytes(int addSize) {
        this.sentBytes += (long)addSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean preRegister() {
        if (MAX_HANDLES == null) {
            return true;
        }
        IoSocketDispatcher ioSocketDispatcher = this;
        synchronized (ioSocketDispatcher) {
            if (this.registeredHandles < MAX_HANDLES) {
                ++this.registeredHandles;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(IoSocketHandler handler, int ops) throws IOException {
        assert (!handler.getChannel().isBlocking());
        IoSocketHandler ioSocketHandler = handler;
        synchronized (ioSocketHandler) {
            handler.setDetached(false);
        }
        handler.setMemoryManager(this.memoryManager);
        Integer tbid = IoSocketDispatcher.getThreadBoundId();
        if (tbid != null && tbid == this.id) {
            this.registerHandlerNow(handler, ops);
            return true;
        }
        this.addToRegisterQueue(handler, ops);
        return true;
    }

    private void addToRegisterQueue(final IoSocketHandler socketHandler, final int ops) {
        Runnable registerTask = new Runnable(){

            public void run() {
                block3: {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("registering handler " + socketHandler.getId());
                    }
                    try {
                        IoSocketDispatcher.this.registerHandlerNow(socketHandler, ops);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block3;
                        LOG.fine("error occured by registering handler " + socketHandler.getId() + " " + DataConverter.toString(ioe));
                    }
                }
            }
        };
        this.registerQueue.add(registerTask);
        this.wakeUp();
    }

    public void deregister(IoSocketHandler handler) {
        Integer tbid = IoSocketDispatcher.getThreadBoundId();
        if (tbid != null && tbid == this.id) {
            this.deregisterHandlerNow(handler);
            return;
        }
        this.addToDeregisterQueue(handler);
    }

    private void addToDeregisterQueue(IoSocketHandler handler) {
        this.deregisterQueue.add(handler);
        this.wakeUp();
    }

    void wakeUp() {
        this.selector.wakeup();
    }

    void suspendRead(final IoSocketHandler socketHandler) throws IOException {
        Integer tbid = IoSocketDispatcher.getThreadBoundId();
        if (tbid != null && tbid == this.id) {
            this.setReadSelectionKeyNow(socketHandler, false);
            return;
        }
        Runnable keyUpdateTask = new Runnable(){

            public void run() {
                block2: {
                    try {
                        IoSocketDispatcher.this.setReadSelectionKeyNow(socketHandler, false);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block2;
                        LOG.fine("error occured by set read key now for " + socketHandler.getId() + " " + DataConverter.toString(ioe));
                    }
                }
            }
        };
        this.addToKeyUpdateQueue(keyUpdateTask);
    }

    void resumeRead(final IoSocketHandler socketHandler) throws IOException {
        Integer tbid = IoSocketDispatcher.getThreadBoundId();
        if (tbid != null && tbid == this.id) {
            this.setReadSelectionKeyNow(socketHandler, true);
            return;
        }
        Runnable keyUpdateTask = new Runnable(){

            public void run() {
                block2: {
                    try {
                        IoSocketDispatcher.this.setReadSelectionKeyNow(socketHandler, true);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINER)) break block2;
                        LOG.finer("error occured by set read key now for " + socketHandler.getId() + " " + DataConverter.toString(ioe));
                    }
                }
            }
        };
        this.addToKeyUpdateQueue(keyUpdateTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeWrite(final IoSocketHandler socketHandler, final boolean unregisteredWriteAllowed, boolean isBypassingSelectorAllowed) throws IOException {
        if (isBypassingSelectorAllowed && this.isDispatcherThread()) {
            if (unregisteredWriteAllowed) {
                IoSocketHandler ioSocketHandler = socketHandler;
                synchronized (ioSocketHandler) {
                    if (socketHandler.isDetached()) {
                        socketHandler.onDirectUnregisteredWriteEvent();
                        ++this.countUnregisteredWrite;
                        return;
                    }
                }
            }
            this.setWriteSelectionKeyNow(socketHandler, unregisteredWriteAllowed);
            return;
        }
        Runnable keyUpdateTask = new Runnable(){

            public void run() {
                block2: {
                    try {
                        IoSocketDispatcher.this.setWriteSelectionKeyNow(socketHandler, unregisteredWriteAllowed);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block2;
                        LOG.fine("error occured by set write key now for " + socketHandler.getId() + " " + DataConverter.toString(ioe));
                    }
                }
            }
        };
        this.addToKeyUpdateQueue(keyUpdateTask);
    }

    private boolean isDispatcherThread() {
        Integer tbid = IoSocketDispatcher.getThreadBoundId();
        return tbid != null && tbid == this.id;
    }

    private void addToKeyUpdateQueue(Runnable keyUpdateTask) {
        this.keyUpdateQueue.add(keyUpdateTask);
        this.wakeUp();
    }

    private int performKeyUpdateTasks() {
        int handledTasks = 0;
        Runnable keyUpdateTask;
        while ((keyUpdateTask = this.keyUpdateQueue.poll()) != null) {
            keyUpdateTask.run();
            ++handledTasks;
        }
        return handledTasks;
    }

    void setReadSelectionKeyNow(IoSocketHandler socketHandler, boolean activate) throws IOException {
        assert (this.isDispatcherThread());
        if (activate) {
            this.updateInterestOps(socketHandler, 1, true, true);
        } else {
            this.updateInterestOps(socketHandler, 1, false, true);
        }
    }

    void setWriteSelectionKeyNow(IoSocketHandler socketHandler, boolean allowDirectCall) throws IOException {
        block2: {
            try {
                this.updateInterestOps(socketHandler, 4, true, allowDirectCall);
            }
            catch (NullPointerException npe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by updating interested ops");
            }
        }
    }

    void unsetWriteSelectionKeyNow(IoSocketHandler socketHandler, boolean allowDirectCall) throws IOException {
        this.updateInterestOps(socketHandler, 4, false, allowDirectCall);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateInterestOps(IoSocketHandler socketHandler, int ops, boolean isAdd, boolean allowDirectCall) throws IOException {
        assert (this.isDispatcherThread());
        SelectionKey key = socketHandler.getChannel().keyFor(this.selector);
        if (key != null && !key.isValid()) {
            this.selector.selectNow();
            this.isSelectedKeysSetModified = true;
            key = socketHandler.getChannel().keyFor(this.selector);
        }
        if (key == null) {
            Integer tbid;
            if (!socketHandler.isOpen()) throw new IOException("[" + socketHandler.getId() + "] invalid socket handler (socket is already closed)");
            if (!isAdd) return;
            if (allowDirectCall && ops == 4 && IoSocketDispatcher.getDirectCallCounter() < 10 && (tbid = IoSocketDispatcher.getThreadBoundId()) != null && tbid == this.id) {
                IoSocketDispatcher.incDirectCallCounter();
                this.onWriteableEvent(socketHandler);
                return;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + socketHandler.getId() + "] is not registered. register it now");
            }
            this.registerHandlerNow(socketHandler, ops);
            return;
        } else {
            if (!key.isValid()) {
                key.cancel();
                if (!LOG.isLoggable(Level.FINE)) return;
                LOG.fine("[" + socketHandler.getId() + " key for of handle is not valid. canceling key and ignore update task " + this.printSelectionKeyValue(ops));
                return;
            }
            if (isAdd) {
                Integer tbid;
                if (isBypassingWriteAllowed && allowDirectCall && ops == 4 && IoSocketDispatcher.getDirectCallCounter() < 10 && (tbid = IoSocketDispatcher.getThreadBoundId()) != null && tbid == this.id) {
                    IoSocketDispatcher.incDirectCallCounter();
                    try {
                        this.onWriteableEventUnprotected(socketHandler);
                        return;
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                try {
                    key.interestOps(key.interestOps() | ops);
                    IoSocketDispatcher.resetDirectCallCounter();
                    return;
                }
                catch (CancelledKeyException e) {
                    if (!LOG.isLoggable(Level.FINE)) return;
                    LOG.fine("couldn't update key with " + this.printSelectionKeyValue(ops) + " reason " + e.toString());
                }
                return;
            } else if (IS_DETACH_HANDLE_ON_NO_OPS && (key.interestOps() & ~ops) == 0) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + socketHandler.getId() + "] deregistering handle because no ops are set");
                }
                this.deregisterHandlerNow(socketHandler);
                return;
            } else {
                key.interestOps(key.interestOps() & ~ops);
                IoSocketDispatcher.resetDirectCallCounter();
            }
        }
    }

    String getRegisteredOpsInfo(IoSocketHandler socketHandler) {
        SelectionKey key = socketHandler.getChannel().keyFor(this.selector);
        if (key == null) {
            return "<not registered>";
        }
        return this.printSelectionKeyValue(key.interestOps());
    }

    boolean isReadable(IoSocketHandler socketHandler) {
        SelectionKey key = socketHandler.getChannel().keyFor(this.selector);
        return key != null && key.isValid() && (key.interestOps() & 1) == 1;
    }

    boolean isWriteable(IoSocketHandler socketHandler) {
        SelectionKey key = socketHandler.getChannel().keyFor(this.selector);
        return key != null && key.isValid() && (key.interestOps() & 4) == 4;
    }

    private int performRegisterHandlerTasks() throws IOException {
        int handledTasks = 0;
        Runnable registerTask;
        while ((registerTask = this.registerQueue.poll()) != null) {
            registerTask.run();
            ++handledTasks;
        }
        return handledTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerHandlerNow(IoSocketHandler socketHandler, int ops) throws IOException {
        if (socketHandler.isOpen()) {
            if (socketHandler.getChannel().keyFor(this.selector) != null) {
                this.updateInterestOps(socketHandler, ops, true, false);
            }
            IoSocketHandler ioSocketHandler = socketHandler;
            synchronized (ioSocketHandler) {
                socketHandler.setDetached(false);
                socketHandler.getChannel().register(this.selector, ops, socketHandler);
            }
            socketHandler.onRegisteredEvent();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(socketHandler.getId() + " registered (ops=" + this.printSelectionKeyValue(ops) + ")");
            }
            ++this.handledRegistractions;
        } else {
            socketHandler.onRegisteredFailedEvent(new IOException("could not register handler " + socketHandler.getId() + " because the channel is closed"));
        }
    }

    private int performDeregisterHandlerTasks() {
        int handledTasks = 0;
        IoSocketHandler socketHandler;
        while ((socketHandler = this.deregisterQueue.poll()) != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("deregistering handler " + socketHandler.getId());
            }
            this.deregisterHandlerNow(socketHandler);
            ++handledTasks;
        }
        return handledTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterHandlerNow(IoSocketHandler socketHandler) {
        SelectionKey key = socketHandler.getChannel().keyFor(this.selector);
        if (key != null && key.isValid()) {
            key.cancel();
        }
        IoSocketHandler ioSocketHandler = socketHandler;
        synchronized (ioSocketHandler) {
            socketHandler.setDetached(true);
        }
        ++this.handledRegistractions;
    }

    public Set<IoSocketHandler> getRegistered() {
        HashSet<IoSocketHandler> registered = new HashSet<IoSocketHandler>();
        Set<SelectionKey> keys = this.selector.keys();
        for (SelectionKey key : keys) {
            IoSocketHandler socketHandler = (IoSocketHandler)key.attachment();
            registered.add(socketHandler);
        }
        return registered;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public long getNumberOfHandledRegistrations() {
        return this.handledRegistractions;
    }

    public long getNumberOfHandledReads() {
        return this.handledReads;
    }

    public long getNumberOfHandledWrites() {
        return this.handledWrites;
    }

    long getReceiveRateBytesPerSec() {
        long rate = 0L;
        long elapsed = System.currentTimeMillis() - this.lastRequestReceiveRate;
        rate = this.receivedBytes == 0L ? 0L : (elapsed == 0L ? Long.MAX_VALUE : this.receivedBytes * 1000L / elapsed);
        this.lastRequestReceiveRate = System.currentTimeMillis();
        this.receivedBytes = 0L;
        return rate;
    }

    long getSendRateBytesPerSec() {
        long rate = 0L;
        long elapsed = System.currentTimeMillis() - this.lastRequestSendRate;
        rate = this.sentBytes == 0L ? 0L : (elapsed == 0L ? Long.MAX_VALUE : this.sentBytes * 1000L / elapsed);
        this.lastRequestSendRate = System.currentTimeMillis();
        this.sentBytes = 0L;
        return rate;
    }

    long getCountIdleTimeout() {
        return this.countIdleTimeouts;
    }

    long getCountConnectionTimeout() {
        return this.countConnectionTimeouts;
    }

    public int getPreallocatedReadMemorySize() {
        return this.memoryManager.getCurrentSizePreallocatedBuffer();
    }

    boolean getReceiveBufferPreallocationMode() {
        return this.memoryManager.isPreallocationMode();
    }

    void setReceiveBufferPreallocationMode(boolean mode) {
        this.memoryManager.setPreallocationMode(mode);
    }

    void setReceiveBufferPreallocatedMinSize(Integer minSize) {
        this.memoryManager.setPreallocatedMinBufferSize(minSize);
    }

    Integer getReceiveBufferPreallocatedMinSize() {
        if (this.memoryManager.isPreallocationMode()) {
            return this.memoryManager.getPreallocatedMinBufferSize();
        }
        return null;
    }

    Integer getReceiveBufferPreallocatedSize() {
        if (this.memoryManager.isPreallocationMode()) {
            return this.memoryManager.gettPreallocationBufferSize();
        }
        return null;
    }

    void setReceiveBufferPreallocatedSize(Integer size) {
        this.memoryManager.setPreallocationBufferSize(size);
    }

    boolean getReceiveBufferIsDirect() {
        return this.memoryManager.isDirect();
    }

    void setReceiveBufferIsDirect(boolean isDirect) {
        this.memoryManager.setDirect(isDirect);
    }

    public void resetStatistics() {
        this.statisticsStartTime = System.currentTimeMillis();
        this.handledRegistractions = 0L;
        this.handledReads = 0L;
        this.handledWrites = 0L;
    }

    public String toString() {
        return "open channels  " + this.getRegistered().size();
    }

    protected long getStatisticsStartTime() {
        return this.statisticsStartTime;
    }

    private String printSelectionKeyValue(int ops) {
        StringBuilder sb = new StringBuilder();
        if ((ops & 0x10) == 16) {
            sb.append("OP_ACCEPT, ");
        }
        if ((ops & 8) == 8) {
            sb.append("OP_CONNECT, ");
        }
        if ((ops & 4) == 4) {
            sb.append("OP_WRITE, ");
        }
        if ((ops & 1) == 1) {
            sb.append("OP_READ, ");
        }
        String txt = sb.toString();
        if ((txt = txt.trim()).length() > 0) {
            txt = txt.substring(0, txt.length() - 1);
        }
        return txt + " (" + ops + ")";
    }

    @Override
    public void close() throws IOException {
        if (this.selector != null) {
            if (this.sizeUpdateTask != null) {
                this.sizeUpdateTask.cancel();
            }
            if (this.closer != null) {
                new Thread(this.closer).start();
                this.closer = null;
            }
        }
    }

    private class Closer
    implements Runnable {
        private Closer() {
        }

        public void run() {
            Thread.currentThread().setName("xDispatcherCloser");
            long start = System.currentTimeMillis();
            while (IoSocketDispatcher.this.getRegistered().size() > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                if (System.currentTimeMillis() <= start + 5000L) continue;
                LOG.warning("shutdown timeout reached (" + DataConverter.toFormatedDuration(5000L) + "). kill pending connections");
                Set<SelectionKey> keys = IoSocketDispatcher.this.selector.keys();
                HashSet<SelectionKey> keysCopy = new HashSet<SelectionKey>();
                keysCopy.addAll(keys);
                for (SelectionKey sk : keysCopy) {
                    try {
                        sk.channel().close();
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("error occured by closing channel " + ioe.toString());
                    }
                }
            }
            IoSocketDispatcher.this.isOpen = false;
            IoSocketDispatcher.this.selector.wakeup();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("dispatcher " + this.hashCode() + " has been closed (shutdown time = " + DataConverter.toFormatedDuration(System.currentTimeMillis() - start) + ")");
            }
        }
    }
}

