/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.SerializedTaskQueue;
import org.xsocket.connection.AbstractNonBlockingStream;
import org.xsocket.connection.ConnectionManager;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.HandlerAdapter;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIoConnectorCallback;
import org.xsocket.connection.IIoHandlerCallback;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IUnsynchronized;
import org.xsocket.connection.IWriteCompletionHandler;
import org.xsocket.connection.IoChainableHandler;
import org.xsocket.connection.IoConnector;
import org.xsocket.connection.IoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonBlockingConnection
extends AbstractNonBlockingStream
implements INonBlockingConnection {
    private static final Logger LOG = Logger.getLogger(NonBlockingConnection.class.getName());
    public static final String SEND_TIMEOUT_KEY = "org.xsocket.connection.sendFlushTimeoutMillis";
    public static final long DEFAULT_SEND_TIMEOUT_MILLIS = 60000L;
    private static final boolean IS_SUPPRESS_SYNC_FLUSH_WARNING = IoProvider.getSuppressSncFlushWarning();
    private static Executor defaultWorkerPool;
    private static IoConnector defaultConnector;
    private static long sendTimeoutMillis;
    private final boolean isServerSide;
    private AtomicBoolean isOpen = new AtomicBoolean(true);
    private AtomicBoolean isConnected = new AtomicBoolean(false);
    private AtomicBoolean isSuspended = new AtomicBoolean(false);
    private static final ConnectionManager DEFAULT_CONNECTION_MANAGER;
    private ConnectionManager.TimeoutMgmHandle timeoutMgmHandle;
    private final IoHandlerCallback ioHandlerCallback = new IoHandlerCallback();
    private IoChainableHandler ioHandler;
    private final AtomicReference<HandlerAdapter> handlerAdapter = new AtomicReference<Object>(null);
    private Executor workerpool;
    private final SerializedTaskQueue taskQueue = new SerializedTaskQueue();
    private int bytesPerSecond = Integer.MAX_VALUE;
    private final WriteCompletionManager writeCompletionManager = new WriteCompletionManager();
    private final Object asyncWriteGuard = new Object();
    private final SyncWriter syncWritter = new SyncWriter();
    private long idleTimeoutMillis = Long.MAX_VALUE;
    private long idleTimeoutDateMillis = Long.MAX_VALUE;
    private long connectionTimeoutMillis = Long.MAX_VALUE;
    private long connectionTimeoutDateMillis = Long.MAX_VALUE;
    private boolean idleTimeoutOccured = false;
    private boolean connectionTimeoutOccured = false;
    private boolean connectExceptionOccured = false;
    private boolean disconnectOccured = false;
    private Integer cachedSoSndBuf;
    private final Object suspendGuard = new Object();
    private Integer maxReadBufferSize;

    public NonBlockingConnection(String hostname, int port) throws IOException {
        this(InetAddress.getByName(hostname), port);
    }

    public NonBlockingConnection(InetAddress address, int port) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetSocketAddress address) throws IOException {
        this(address, true, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, int connectTimeoutMillis) throws IOException {
        this(new InetSocketAddress(address, port), true, connectTimeoutMillis, new HashMap<String, Object>(), null, false, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, options, null, false, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, int connectTimeoutMillis, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(address, port), true, connectTimeoutMillis, options, null, false, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis) throws IOException {
        this(new InetSocketAddress(address, port), true, connectTimeoutMillis, new HashMap<String, Object>(), null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean waitForConnect, int connectTimeoutMillis) throws IOException {
        this(new InetSocketAddress(address, port), waitForConnect, connectTimeoutMillis, new HashMap<String, Object>(), null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), sslContext, sslOn, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), true, connectTimeoutMillis, new HashMap<String, Object>(), sslContext, sslOn, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean waitForConnect, int connectTimeoutMillis, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), waitForConnect, connectTimeoutMillis, new HashMap<String, Object>(), sslContext, sslOn, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, options, null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(address, port), true, connectTimeoutMillis, options, null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean waitForConnect, int connectTimeoutMillis, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(address, port), waitForConnect, connectTimeoutMillis, options, null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(String hostname, int port, IHandler appHandler) throws IOException {
        this(new InetSocketAddress(hostname, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(String hostname, int port, IHandler appHandler, Executor workerPool) throws IOException {
        this(new InetSocketAddress(hostname, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, appHandler, workerPool);
    }

    public NonBlockingConnection(String hostname, int port, IHandler appHandler, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(hostname, port), true, Integer.MAX_VALUE, options, null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), sslContext, sslOn, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, options, sslContext, sslOn, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(String hostname, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), sslContext, sslOn, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(String hostname, int port, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), true, Integer.MAX_VALUE, options, sslContext, sslOn, null, NonBlockingConnection.getDefaultWorkerpool());
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, Executor workerPool) throws IOException {
        this(new InetSocketAddress(address, port), true, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, appHandler, workerPool);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis, Executor workerPool) throws IOException {
        this(new InetSocketAddress(address, port), true, connectTimeoutMillis, new HashMap<String, Object>(), null, false, appHandler, workerPool);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean waitForConnect, int connectTimeoutMillis, Executor workerPool) throws IOException {
        this(new InetSocketAddress(address, port), waitForConnect, connectTimeoutMillis, new HashMap<String, Object>(), null, false, appHandler, workerPool);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis, SSLContext sslContext, boolean sslOn, Executor workerPool) throws IOException {
        this(new InetSocketAddress(address, port), true, connectTimeoutMillis, new HashMap<String, Object>(), sslContext, sslOn, appHandler, workerPool);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean waitForConnect, int connectTimeoutMillis, SSLContext sslContext, boolean sslOn, Executor workerPool) throws IOException {
        this(new InetSocketAddress(address, port), waitForConnect, connectTimeoutMillis, new HashMap<String, Object>(), sslContext, sslOn, appHandler, workerPool);
    }

    public NonBlockingConnection(InetSocketAddress remoteAddress, InetSocketAddress localAddress, IHandler appHandler, boolean waitForConnect, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(remoteAddress, localAddress, waitForConnect, connectTimeoutMillis, options, sslContext, sslOn, appHandler, NonBlockingConnection.getDefaultWorkerpool(), true, DEFAULT_FLUSH_MODE);
    }

    public NonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean autoflush, IConnection.FlushMode flushmode) throws IOException {
        this(new InetSocketAddress(address, port), null, true, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false, appHandler, NonBlockingConnection.getDefaultWorkerpool(), autoflush, flushmode);
    }

    NonBlockingConnection(InetSocketAddress remoteAddress, boolean waitForConnect, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean sslOn, IHandler appHandler, Executor workerpool) throws IOException {
        this(remoteAddress, null, waitForConnect, connectTimeoutMillis, options, sslContext, sslOn, appHandler, workerpool, true, DEFAULT_FLUSH_MODE);
    }

    private NonBlockingConnection(InetSocketAddress remoteAddress, InetSocketAddress localAddress, boolean waitForConnect, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean isSecured, IHandler appHdl, Executor workerpool, boolean autoflush, IConnection.FlushMode flushmode) throws IOException {
        this.setFlushmode(flushmode);
        this.setAutoflush(autoflush);
        this.setWorkerpool(workerpool);
        this.handlerAdapter.set(HandlerAdapter.newInstance(appHdl));
        this.isServerSide = false;
        SocketChannel channel = NonBlockingConnection.openSocket(localAddress, options);
        IoConnector connector = NonBlockingConnection.getDefaultConnector();
        if (waitForConnect) {
            SyncIoConnectorCallback callback = new SyncIoConnectorCallback(remoteAddress, channel, sslContext, isSecured, this.connectionTimeoutMillis);
            connector.connectAsync(channel, remoteAddress, connectTimeoutMillis, callback);
            callback.connect();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("connection " + this.getId() + " established");
            }
        } else {
            AsyncIoConnectorCallback callback = new AsyncIoConnectorCallback(remoteAddress, channel, sslContext, isSecured, this.connectionTimeoutMillis);
            connector.connectAsync(channel, remoteAddress, connectTimeoutMillis, callback);
        }
    }

    protected NonBlockingConnection(ConnectionManager connectionManager, HandlerAdapter hdlAdapter) throws IOException {
        this.handlerAdapter.set(hdlAdapter);
        this.isServerSide = true;
        this.isConnected.set(true);
        this.timeoutMgmHandle = connectionManager.register(this);
    }

    private void register(SocketChannel channel, SSLContext sslContext, boolean isSecured) throws IOException, SocketTimeoutException {
        IoChainableHandler ioHdl = NonBlockingConnection.createClientIoHandler(channel, sslContext, isSecured);
        this.timeoutMgmHandle = DEFAULT_CONNECTION_MANAGER.register(this);
        this.init(ioHdl);
        this.setIdleTimeoutMillis(this.idleTimeoutMillis);
        this.setConnectionTimeoutMillis(this.connectionTimeoutMillis);
    }

    SerializedTaskQueue getTaskQueue() {
        return this.taskQueue;
    }

    long getLastTimeReceivedMillis() {
        return this.ioHandler.getLastTimeReceivedMillis();
    }

    long getLastTimeSendMillis() {
        return this.ioHandler.getLastTimeSendMillis();
    }

    @Override
    public int getMaxReadBufferThreshold() {
        if (this.maxReadBufferSize == null) {
            return Integer.MAX_VALUE;
        }
        return this.maxReadBufferSize;
    }

    @Override
    public void setMaxReadBufferThreshold(int size) {
        if (size == Integer.MAX_VALUE) {
            this.maxReadBufferSize = null;
            this.ioHandler.setRetryRead(true);
        } else {
            this.maxReadBufferSize = size;
            this.ioHandler.setRetryRead(false);
        }
    }

    static synchronized Executor getDefaultWorkerpool() {
        if (defaultWorkerPool == null) {
            defaultWorkerPool = Executors.newCachedThreadPool(new DefaultThreadFactory());
        }
        return defaultWorkerPool;
    }

    private static synchronized IoConnector getDefaultConnector() {
        if (defaultConnector == null) {
            defaultConnector = new IoConnector("default");
            Thread t = new Thread(defaultConnector);
            t.setDaemon(true);
            t.start();
        }
        return defaultConnector;
    }

    @Override
    protected boolean isMoreInputDataExpected() {
        if (this.ioHandler != null) {
            return this.ioHandler.isOpen();
        }
        return false;
    }

    @Override
    protected boolean isDataWriteable() {
        return this.ioHandler.isOpen();
    }

    void init(IoChainableHandler ioHandler) throws IOException, SocketTimeoutException {
        this.ioHandler = ioHandler;
        ioHandler.init(this.ioHandlerCallback);
        this.isConnected.set(true);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("connection " + this.getId() + " created. IoHandler: " + ioHandler.toString());
        }
    }

    @Override
    public void setHandler(IHandler hdl) throws IOException {
        this.handlerAdapter.set(HandlerAdapter.newInstance(hdl));
        if (this.getReadQueueSize() > 0) {
            this.ioHandlerCallback.onPostData();
        }
    }

    @Override
    public IHandler getHandler() {
        HandlerAdapter hdlAdapter = this.handlerAdapter.get();
        if (hdlAdapter == null) {
            return null;
        }
        return hdlAdapter.getHandler();
    }

    @Override
    public void setWorkerpool(Executor workerpool) {
        this.workerpool = workerpool;
    }

    @Override
    public Executor getWorkerpool() {
        return this.workerpool;
    }

    @Override
    protected boolean reset() {
        try {
            if (!this.writeCompletionManager.reset()) {
                return false;
            }
            if (!this.syncWritter.reset()) {
                return false;
            }
            boolean isReset = this.ioHandler.reset();
            if (!isReset) {
                return false;
            }
            return super.reset();
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured by reseting connection " + this.getId() + " " + e.toString());
            }
            return false;
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen.get();
    }

    @Override
    public boolean isServerSide() {
        return this.isServerSide;
    }

    boolean isConnected() {
        return this.ioHandler.isOpen();
    }

    private void onData(ByteBuffer[] data, int size) {
        if (data != null) {
            this.appendDataToReadBuffer(data, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onPostAppend() {
        if (this.maxReadBufferSize != null) {
            Object object = this.suspendGuard;
            synchronized (object) {
                block8: {
                    if (this.getReadQueueSize() >= this.maxReadBufferSize) {
                        try {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("suspending read, because max read buffers size " + this.maxReadBufferSize + " is execced (" + this.getReadQueueSize() + ")");
                            }
                            this.ioHandler.suspendRead();
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block8;
                            LOG.fine("error occured by suspending read (cause by max read queue size " + this.maxReadBufferSize + " " + ioe.toString());
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuffer[] onRead(ByteBuffer[] readBufs) throws IOException {
        if (this.maxReadBufferSize != null) {
            Object object = this.suspendGuard;
            synchronized (object) {
                block9: {
                    if (this.ioHandler.isReadSuspended() && this.getReadQueueSize() < this.maxReadBufferSize) {
                        try {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("resuming read, because read buffer size is lower than max read buffers size " + this.maxReadBufferSize);
                            }
                            if (!this.isSuspended.get()) {
                                this.ioHandler.resumeRead();
                            }
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block9;
                            LOG.fine("error occured by suspending read (cause by max read queue size " + this.maxReadBufferSize + " " + ioe.toString());
                        }
                    }
                }
            }
        }
        return readBufs;
    }

    private void onPostData() {
        block2: {
            try {
                this.handlerAdapter.get().onData(this, this.taskQueue);
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by performing onData callback on " + this.handlerAdapter.get() + " " + ioe.toString());
            }
        }
    }

    private void onWritten(ByteBuffer data) {
        if (this.getFlushmode() == IConnection.FlushMode.SYNC) {
            this.syncWritter.onWritten(data);
        }
        this.writeCompletionManager.onWritten(data);
    }

    private void onWriteException(IOException ioException, ByteBuffer data) {
        this.isOpen.set(false);
        if (this.getFlushmode() == IConnection.FlushMode.SYNC) {
            this.syncWritter.onWriteException(ioException, data);
        }
        this.writeCompletionManager.onWriteException(ioException, data);
    }

    private void onConnect() {
        block2: {
            try {
                this.handlerAdapter.get().onConnect(this, this.taskQueue);
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by performing onConnect callback on " + this.handlerAdapter.get() + " " + ioe.toString());
            }
        }
    }

    private void onConnectionAbnormalTerminated() {
        this.forceClose();
    }

    private void onDisconnect() {
        block7: {
            if (this.timeoutMgmHandle != null) {
                this.timeoutMgmHandle.destroy();
            }
            if (!this.disconnectOccured) {
                block6: {
                    this.disconnectOccured = true;
                    try {
                        this.handlerAdapter.get().onData(this, this.taskQueue);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block6;
                        LOG.fine("error occured by performing onData callback on " + this.handlerAdapter.get() + " " + ioe.toString());
                    }
                }
                try {
                    this.handlerAdapter.get().onDisconnect(this, this.taskQueue);
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block7;
                    LOG.fine("error occured by performing onDisconnect callback on " + this.handlerAdapter.get() + " " + ioe.toString());
                }
            }
        }
    }

    private void onConnectException(IOException ioe) {
        block5: {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("connecting failed " + ioe.toString());
            }
            if (this.timeoutMgmHandle != null) {
                this.timeoutMgmHandle.destroy();
            }
            if (!this.connectExceptionOccured) {
                this.connectExceptionOccured = true;
                try {
                    this.handlerAdapter.get().onConnectException(this, this.taskQueue, ioe);
                }
                catch (IOException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.fine("error occured by performing onDisconnect callback on " + this.handlerAdapter.get() + " " + e.toString());
                }
            }
        }
    }

    boolean checkIdleTimeout(Long currentMillis) {
        if (this.getRemainingMillisToIdleTimeout(currentMillis) <= 0L) {
            this.onIdleTimeout();
            return true;
        }
        return false;
    }

    void onIdleTimeout() {
        if (!this.idleTimeoutOccured) {
            this.idleTimeoutOccured = true;
            try {
                this.handlerAdapter.get().onIdleTimeout(this, this.taskQueue);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by performing onIdleTimeout callback on " + this.handlerAdapter.get() + " " + ioe.toString());
                }
            }
        } else {
            this.setIdleTimeoutMillis(Long.MAX_VALUE);
        }
    }

    boolean checkConnectionTimeout(Long currentMillis) {
        if (this.getRemainingMillisToConnectionTimeout(currentMillis) <= 0L) {
            this.onConnectionTimeout();
            return true;
        }
        return false;
    }

    private void onConnectionTimeout() {
        if (!this.connectionTimeoutOccured) {
            this.connectionTimeoutOccured = true;
            try {
                this.handlerAdapter.get().onConnectionTimeout(this, this.taskQueue);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by performing onConnectionTimeout callback on " + this.handlerAdapter.get() + " " + ioe.toString());
                }
            }
        } else {
            this.setConnectionTimeoutMillis(Long.MAX_VALUE);
        }
    }

    @Override
    public long getRemainingMillisToConnectionTimeout() {
        return this.getRemainingMillisToConnectionTimeout(System.currentTimeMillis());
    }

    @Override
    public long getRemainingMillisToIdleTimeout() {
        return this.getRemainingMillisToIdleTimeout(System.currentTimeMillis());
    }

    private long getRemainingMillisToConnectionTimeout(long currentMillis) {
        return this.connectionTimeoutDateMillis - currentMillis;
    }

    public long getNumberOfReceivedBytes() {
        return this.ioHandler.getNumberOfReceivedBytes();
    }

    public long getNumberOfSendBytes() {
        return this.ioHandler.getNumberOfSendBytes();
    }

    private long getRemainingMillisToIdleTimeout(long currentMillis) {
        long remaining = this.idleTimeoutDateMillis - currentMillis;
        if (remaining > 0L) {
            return remaining;
        }
        return this.getLastTimeReceivedMillis() + this.idleTimeoutMillis - currentMillis;
    }

    String getRegisteredOpsInfo() {
        return this.ioHandler.getRegisteredOpsInfo();
    }

    @Override
    public void setWriteTransferRate(int bytesPerSecond) throws ClosedChannelException, IOException {
        if (bytesPerSecond != Integer.MAX_VALUE && this.getFlushmode() != IConnection.FlushMode.ASYNC) {
            LOG.warning("setWriteTransferRate is only supported for FlushMode ASYNC. Ignore update of the transfer rate");
            return;
        }
        if (this.bytesPerSecond == bytesPerSecond) {
            return;
        }
        this.bytesPerSecond = bytesPerSecond;
        this.ioHandler = ConnectionUtils.getIoProvider().setWriteTransferRate(this.ioHandler, bytesPerSecond);
    }

    @Override
    public int getWriteTransferRate() throws ClosedChannelException, IOException {
        return this.bytesPerSecond;
    }

    @Override
    public boolean isSecuredModeActivateable() {
        return ConnectionUtils.getIoProvider().isSecuredModeActivateable(this.ioHandler);
    }

    @Override
    public void activateSecuredMode() throws IOException {
        boolean isPrestarted = ConnectionUtils.getIoProvider().preStartSecuredMode(this.ioHandler);
        if (isPrestarted) {
            IConnection.FlushMode currentFlushMode = this.getFlushmode();
            this.setFlushmode(IConnection.FlushMode.ASYNC);
            this.internalFlush();
            this.setFlushmode(currentFlushMode);
            ByteBuffer[] buffer = this.readByteBufferByLength(this.available());
            ConnectionUtils.getIoProvider().startSecuredMode(this.ioHandler, buffer);
        }
    }

    @Override
    public boolean isSecure() {
        return this.ioHandler.isSecure();
    }

    @Override
    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        try {
            return super.readByteBufferByDelimiter(delimiter, encoding, maxLength);
        }
        catch (MaxReadSizeExceededException mre) {
            if (this.isOpen()) {
                throw mre;
            }
            throw new ClosedChannelException();
        }
        catch (BufferUnderflowException bue) {
            if (this.isOpen()) {
                throw bue;
            }
            throw new ClosedChannelException();
        }
    }

    @Override
    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, BufferUnderflowException {
        try {
            return super.readByteBufferByLength(length);
        }
        catch (BufferUnderflowException bue) {
            if (this.isOpen()) {
                throw bue;
            }
            throw new ClosedChannelException();
        }
    }

    @Override
    protected ByteBuffer readSingleByteBuffer(int length) throws IOException, ClosedChannelException, BufferUnderflowException {
        try {
            return super.readSingleByteBuffer(length);
        }
        catch (BufferUnderflowException bue) {
            if (this.isOpen()) {
                throw bue;
            }
            throw new ClosedChannelException();
        }
    }

    @Override
    public void setIdleTimeoutMillis(long timeoutMillis) {
        this.idleTimeoutOccured = false;
        if (timeoutMillis <= 0L) {
            LOG.warning("idle timeout " + timeoutMillis + " millis is invalid");
            return;
        }
        this.idleTimeoutMillis = timeoutMillis;
        this.idleTimeoutDateMillis = System.currentTimeMillis() + this.idleTimeoutMillis;
        if (this.idleTimeoutDateMillis < 0L) {
            this.idleTimeoutDateMillis = Long.MAX_VALUE;
        }
        if (this.isConnected.get()) {
            long period = this.idleTimeoutMillis;
            if (this.idleTimeoutMillis > 500L) {
                period = this.idleTimeoutMillis / 5L;
            }
            this.timeoutMgmHandle.updateCheckPeriod(period);
        }
    }

    @Override
    public void setConnectionTimeoutMillis(long timeoutMillis) {
        this.connectionTimeoutOccured = false;
        if (timeoutMillis <= 0L) {
            LOG.warning("connection timeout " + timeoutMillis + " millis is invalid");
            return;
        }
        this.connectionTimeoutMillis = timeoutMillis;
        this.connectionTimeoutDateMillis = System.currentTimeMillis() + this.connectionTimeoutMillis;
        if (this.isConnected.get()) {
            long period = this.connectionTimeoutMillis;
            if (this.connectionTimeoutMillis > 500L) {
                period = this.connectionTimeoutMillis / 5L;
            }
            this.timeoutMgmHandle.updateCheckPeriod(period);
        }
    }

    @Override
    public long getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    @Override
    public long getIdleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.ioHandler.getLocalAddress();
    }

    @Override
    public String getId() {
        return this.ioHandler.getId();
    }

    @Override
    public int getLocalPort() {
        return this.ioHandler.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.ioHandler.getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        return this.ioHandler.getRemotePort();
    }

    @Override
    public int getPendingWriteDataSize() {
        return this.getWriteBufferSize() + this.ioHandler.getPendingWriteDataSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspendReceiving() throws IOException {
        Object object = this.suspendGuard;
        synchronized (object) {
            this.ioHandler.suspendRead();
            this.isSuspended.set(true);
        }
    }

    @Override
    public void suspendRead() throws IOException {
        this.suspendReceiving();
    }

    @Override
    public boolean isReadSuspended() {
        return this.isReceivingSuspended();
    }

    @Override
    public boolean isReceivingSuspended() {
        return this.isSuspended.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeReceiving() throws IOException {
        Object object = this.suspendGuard;
        synchronized (object) {
            if (this.isReceivingSuspended()) {
                this.ioHandler.resumeRead();
                this.isSuspended.set(false);
                if (this.getReadQueueSize() > 0) {
                    this.ioHandlerCallback.onPostData();
                }
            }
        }
    }

    @Override
    public void resumeRead() throws IOException {
        this.resumeReceiving();
    }

    @Override
    public void write(String message, String encoding, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.write(DataConverter.toByteBuffer(message, encoding), writeCompletionHandler);
    }

    @Override
    public void write(byte[] bytes, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.write(ByteBuffer.wrap(bytes), writeCompletionHandler);
    }

    @Override
    public void write(byte[] bytes, int offset, int length, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.write(DataConverter.toByteBuffer(bytes, offset, length), writeCompletionHandler);
    }

    @Override
    public void write(ByteBuffer[] srcs, int offset, int length, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.write(DataConverter.toByteBuffers(srcs, offset, length), writeCompletionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBuffer buffer, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        Object object = this.asyncWriteGuard;
        synchronized (object) {
            boolean isSuppressReuseBuffer = this.isSuppressReuseBufferWarning();
            this.setSuppressReuseBufferWarning(true);
            this.writeCompletionManager.registerCompletionHandler(writeCompletionHandler, buffer);
            this.write(buffer);
            this.setSuppressReuseBufferWarning(isSuppressReuseBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBuffer[] buffers, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        Object object = this.asyncWriteGuard;
        synchronized (object) {
            boolean isSuppressReuseBuffer = this.isSuppressReuseBufferWarning();
            this.setSuppressReuseBufferWarning(true);
            this.writeCompletionManager.registerCompletionHandler(writeCompletionHandler, buffers);
            this.write(buffers);
            this.setSuppressReuseBufferWarning(isSuppressReuseBuffer);
        }
    }

    @Override
    public void write(List<ByteBuffer> buffers, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.write(buffers.toArray(new ByteBuffer[buffers.size()]), writeCompletionHandler);
    }

    @Override
    public long transferFrom(ReadableByteChannel source, int chunkSize) throws IOException, BufferOverflowException {
        if (this.getFlushmode() == IConnection.FlushMode.SYNC) {
            return this.transferFromSync(source);
        }
        return super.transferFrom(source, chunkSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long transferFromSync(ReadableByteChannel sourceChannel) throws ClosedChannelException, IOException, SocketTimeoutException, ClosedChannelException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("transfering data by using WriteCompletionHandler");
        }
        boolean isSuppressReuseBufferWarning = this.isSuppressReuseBufferWarning();
        try {
            this.setSuppressReuseBufferWarning(true);
            this.setFlushmode(IConnection.FlushMode.ASYNC);
            Object guard = new Object();
            ByteBuffer copyBuffer = ByteBuffer.allocate(this.getSoSndBufSize());
            SendTask sendTask = new SendTask(guard, sourceChannel, copyBuffer);
            sendTask.onWritten(0);
            Object object = guard;
            synchronized (object) {
                if (!sendTask.isComplete()) {
                    try {
                        guard.wait(sendTimeoutMillis);
                    }
                    catch (InterruptedException ie) {
                        this.closeSilence();
                        throw new SocketTimeoutException("timeout reached");
                    }
                }
            }
            if (sendTask.getException() != null) {
                throw sendTask.getException();
            }
            long l = sendTask.getWritten();
            return l;
        }
        finally {
            this.setSuppressReuseBufferWarning(isSuppressReuseBufferWarning);
            this.setFlushmode(IConnection.FlushMode.SYNC);
        }
    }

    private int getSoSndBufSize() throws IOException {
        if (this.cachedSoSndBuf == null) {
            this.cachedSoSndBuf = (Integer)this.getOption("SOL_SOCKET.SO_SNDBUF");
        }
        return this.cachedSoSndBuf;
    }

    @Override
    protected void onWriteDataInserted() throws IOException, ClosedChannelException {
        if (this.isAutoflush()) {
            this.internalFlush();
        }
    }

    @Override
    public Object getOption(String name) throws IOException {
        return this.ioHandler.getOption(name);
    }

    @Override
    public Map<String, Class> getOptions() {
        return this.ioHandler.getOptions();
    }

    @Override
    public void setOption(String name, Object value) throws IOException {
        if (name.equalsIgnoreCase("SOL_SOCKET.SO_SNDBUF")) {
            this.cachedSoSndBuf = (Integer)value;
        }
        this.ioHandler.setOption(name, value);
    }

    @Override
    protected int getWriteTransferChunkeSize() {
        try {
            return this.getSoSndBufSize();
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured by retrieving SoSndBufSize " + ioe.toString());
            }
            return super.getWriteTransferChunkeSize();
        }
    }

    private void forceClose() {
        block3: {
            try {
                this.isOpen.set(false);
                if (this.ioHandler != null) {
                    this.ioHandler.close(true);
                }
                this.syncWritter.close();
                this.writeCompletionManager.close();
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.fine("Error occured by closing " + ioe.toString());
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.isOpen.get()) {
            this.isOpen.set(false);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("closing connection -> flush all remaining data");
            }
            if (this.getWriteTransferRate() != Integer.MAX_VALUE) {
                this.setWriteTransferRate(Integer.MAX_VALUE);
            }
            if (!this.isWriteBufferEmpty()) {
                ByteBuffer[] buffers = this.drainWriteQueue();
                this.ioHandler.write(buffers);
                this.ioHandler.flush();
            }
            if (this.ioHandler != null) {
                this.ioHandler.close(false);
            }
            this.syncWritter.close();
            this.writeCompletionManager.close();
        }
    }

    void closeSilence() {
        block2: {
            try {
                this.close();
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by closing connection " + this.getId() + " " + DataConverter.toString(ioe));
            }
        }
    }

    @Override
    public void flush() throws ClosedChannelException, IOException {
        this.internalFlush();
    }

    private void internalFlush() throws ClosedChannelException, IOException {
        if (!this.isOpen.get()) {
            throw new ClosedChannelException();
        }
        this.removeWriteMark();
        if (!this.isWriteBufferEmpty()) {
            if (this.getFlushmode() == IConnection.FlushMode.SYNC) {
                this.syncWritter.flushAndWaitUntilWritten();
            } else {
                this.ioHandler.write(this.drainWriteQueue());
                this.ioHandler.flush();
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.getId() + "] flushed");
        }
    }

    public String toString() {
        if (this.isOpen()) {
            return "id=" + this.getId() + ", remote=" + this.getRemoteAddress() + "(" + this.getRemoteAddress() + ":" + this.getRemotePort() + ")";
        }
        return "id=" + this.getId() + " (closed)";
    }

    String toDetailedString() {
        if (this.isOpen()) {
            SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss,S");
            return "id=" + this.getId() + ", remote=" + this.getRemoteAddress().getCanonicalHostName() + "(" + this.getRemoteAddress() + ":" + this.getRemotePort() + ") lastTimeReceived=" + df.format(new Date(this.getLastTimeReceivedMillis())) + " reveived=" + this.getNumberOfReceivedBytes() + " lastTimeSent=" + df.format(new Date(this.getLastTimeSendMillis())) + " send=" + this.getNumberOfSendBytes() + " ops={" + this.getRegisteredOpsInfo() + "}";
        }
        return "id=" + this.getId() + " (closed)";
    }

    private static IoChainableHandler createClientIoHandler(SocketChannel channel, SSLContext sslContext, boolean sslOn) throws IOException {
        if (sslContext != null) {
            return ConnectionUtils.getIoProvider().createSSLClientIoHandler(channel, sslContext, sslOn);
        }
        return ConnectionUtils.getIoProvider().createClientIoHandler(channel);
    }

    private static SocketChannel openSocket(InetSocketAddress localAddress, Map<String, Object> options) throws IOException {
        SocketChannel channel = SocketChannel.open();
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            IoProvider.setOption(channel.socket(), entry.getKey(), entry.getValue());
        }
        if (localAddress != null) {
            channel.socket().bind(localAddress);
        }
        return channel;
    }

    static {
        sendTimeoutMillis = 60000L;
        try {
            sendTimeoutMillis = Long.valueOf(System.getProperty(SEND_TIMEOUT_KEY, Long.toString(60000L)));
        }
        catch (Exception e) {
            LOG.warning("invalid value for system property org.xsocket.connection.sendFlushTimeoutMillis: " + System.getProperty(SEND_TIMEOUT_KEY) + " (valid is a int value)" + " using default");
            sendTimeoutMillis = 60000L;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("non blocking connection send time out set with " + DataConverter.toFormatedDuration(sendTimeoutMillis));
        }
        DEFAULT_CONNECTION_MANAGER = new ConnectionManager(new ConnectionManager.ISizeListener(){

            public void sizeChanged() {
            }
        });
    }

    private final class WriteCompletionHolder
    implements Runnable {
        private final IWriteCompletionHandler handler;
        private final ConnectionUtils.CompletionHandlerInfo handlerInfo;
        private final int size;

        public WriteCompletionHolder(IWriteCompletionHandler handler, ByteBuffer[] bufs) {
            this.handler = handler;
            this.handlerInfo = ConnectionUtils.getCompletionHandlerInfo(handler);
            int l = 0;
            for (ByteBuffer byteBuffer : bufs) {
                l += byteBuffer.remaining();
            }
            this.size = l;
        }

        void performOnWritten() {
            if (this.handlerInfo.isUnsynchronized()) {
                this.callOnWritten();
            } else if (this.handlerInfo.isOnWrittenMultithreaded()) {
                NonBlockingConnection.this.taskQueue.performMultiThreaded(this, NonBlockingConnection.this.getWorkerpool());
            } else {
                NonBlockingConnection.this.taskQueue.performNonThreaded(this);
            }
        }

        public void run() {
            this.callOnWritten();
        }

        private void callOnWritten() {
            try {
                this.handler.onWritten(this.size);
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by calling onWritten " + e.toString() + " closing connection");
                }
                NonBlockingConnection.this.closeSilence();
            }
        }

        void performOnException(final IOException ioe) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.callOnException(ioe);
            } else if (this.handlerInfo.isOnExceptionMutlithreaded()) {
                Runnable task = new Runnable(){

                    public void run() {
                        WriteCompletionHolder.this.callOnException(ioe);
                    }
                };
                NonBlockingConnection.this.taskQueue.performMultiThreaded(task, NonBlockingConnection.this.getWorkerpool());
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        WriteCompletionHolder.this.callOnException(ioe);
                    }
                };
                NonBlockingConnection.this.taskQueue.performNonThreaded(task);
            }
        }

        private void callOnException(IOException ioe) {
            this.handler.onException(ioe);
        }
    }

    final class WriteCompletionManager {
        private final Map<WriteCompletionHolder, List<ByteBuffer>> pendingCompletionConfirmations = new HashMap<WriteCompletionHolder, List<ByteBuffer>>();
        private AtomicBoolean isWriteCompletionSupportActivated = new AtomicBoolean(false);

        WriteCompletionManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerCompletionHandler(IWriteCompletionHandler writeCompletionHandler, ByteBuffer ... buffersToWrite) {
            WriteCompletionHolder holder = new WriteCompletionHolder(writeCompletionHandler, buffersToWrite);
            WriteCompletionManager writeCompletionManager = this;
            synchronized (writeCompletionManager) {
                this.isWriteCompletionSupportActivated.set(true);
                this.pendingCompletionConfirmations.put(holder, new ArrayList<ByteBuffer>(Arrays.asList(buffersToWrite)));
            }
            if (LOG.isLoggable(Level.FINE)) {
                int size = 0;
                for (ByteBuffer byteBuffer : buffersToWrite) {
                    size += byteBuffer.remaining();
                }
                LOG.fine("[" + NonBlockingConnection.this.getId() + "] registering " + writeCompletionHandler.getClass().getSimpleName() + "#" + writeCompletionHandler.hashCode() + " waiting for " + size + " bytes");
            }
        }

        void onWritten(ByteBuffer[] data) {
            if (this.isWriteCompletionSupportActivated.get()) {
                for (ByteBuffer byteBuffer : data) {
                    this.onWritten(byteBuffer);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onWritten(ByteBuffer data) {
            WriteCompletionHolder holderToExecute = null;
            if (data != null) {
                WriteCompletionManager writeCompletionManager = this;
                synchronized (writeCompletionManager) {
                    for (Map.Entry<WriteCompletionHolder, List<ByteBuffer>> entry : this.pendingCompletionConfirmations.entrySet()) {
                        List<ByteBuffer> buffers = entry.getValue();
                        for (ByteBuffer buf : buffers) {
                            if (buf != data) continue;
                            buffers.remove(data);
                            break;
                        }
                        if (!buffers.isEmpty()) continue;
                        holderToExecute = entry.getKey();
                        this.pendingCompletionConfirmations.remove(holderToExecute);
                        break;
                    }
                }
            }
            if (holderToExecute != null) {
                holderToExecute.performOnWritten();
            }
        }

        void onWriteException(IOException ioException, ByteBuffer[] data) {
            if (this.isWriteCompletionSupportActivated.get()) {
                for (ByteBuffer byteBuffer : data) {
                    this.onWriteException(ioException, byteBuffer);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onWriteException(IOException ioException, ByteBuffer data) {
            WriteCompletionHolder holderToExecute = null;
            WriteCompletionManager writeCompletionManager = this;
            synchronized (writeCompletionManager) {
                if (data != null) {
                    block3: for (Map.Entry<WriteCompletionHolder, List<ByteBuffer>> entry : this.pendingCompletionConfirmations.entrySet()) {
                        List<ByteBuffer> buffers = entry.getValue();
                        for (ByteBuffer buf : buffers) {
                            if (buf != data) continue;
                            holderToExecute = entry.getKey();
                            this.pendingCompletionConfirmations.remove(holderToExecute);
                            break block3;
                        }
                    }
                }
            }
            if (holderToExecute != null) {
                holderToExecute.performOnException(ioException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean reset() {
            WriteCompletionManager writeCompletionManager = this;
            synchronized (writeCompletionManager) {
                if (!this.pendingCompletionConfirmations.isEmpty()) {
                    for (WriteCompletionHolder handler : this.pendingCompletionConfirmations.keySet()) {
                        handler.callOnException(new ClosedChannelException());
                    }
                    this.pendingCompletionConfirmations.clear();
                    return false;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            WriteCompletionManager writeCompletionManager = this;
            synchronized (writeCompletionManager) {
                for (WriteCompletionHolder holder : this.pendingCompletionConfirmations.keySet()) {
                    holder.performOnException(new ClosedChannelException());
                }
            }
        }
    }

    final class SyncWriter {
        private IOException writeException;
        private final List<ByteBuffer> pendingWriteConfirmations = new ArrayList<ByteBuffer>();

        SyncWriter() {
        }

        synchronized void flushAndWaitUntilWritten() throws IOException {
            long start = System.currentTimeMillis();
            long remainingTime = sendTimeoutMillis;
            if (IS_SUPPRESS_SYNC_FLUSH_WARNING && ConnectionUtils.isDispatcherThread()) {
                String msg = "synchronized flushing in NonThreaded mode could cause dead locks (hint: set flush mode to ASYNC)";
                LOG.warning("[" + NonBlockingConnection.this.getId() + "] " + msg);
            }
            try {
                ByteBuffer[] buffers = NonBlockingConnection.this.drainWriteQueue();
                this.pendingWriteConfirmations.addAll(Arrays.asList(buffers));
                NonBlockingConnection.this.ioHandler.write(buffers);
                NonBlockingConnection.this.ioHandler.flush();
                do {
                    if (this.pendingWriteConfirmations.isEmpty()) {
                        return;
                    }
                    if (this.writeException != null) {
                        IOException ioe = this.writeException;
                        this.writeException = null;
                        throw ioe;
                    }
                    try {
                        this.wait(remainingTime);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                } while ((remainingTime = start + sendTimeoutMillis - System.currentTimeMillis()) > 0L);
                throw new SocketTimeoutException("send timeout " + DataConverter.toFormatedDuration(sendTimeoutMillis) + " reached. returning from sync flushing");
            }
            finally {
                this.pendingWriteConfirmations.clear();
            }
        }

        synchronized void onWritten(ByteBuffer data) {
            if (data != null) {
                for (ByteBuffer buf : this.pendingWriteConfirmations) {
                    if (buf != data) continue;
                    this.pendingWriteConfirmations.remove(data);
                    break;
                }
            }
            if (this.pendingWriteConfirmations.isEmpty()) {
                this.notifyAll();
            }
        }

        synchronized void onWriteException(IOException ioException, ByteBuffer data) {
            this.writeException = ioException;
            for (ByteBuffer buf : this.pendingWriteConfirmations) {
                if (buf != data) continue;
                this.pendingWriteConfirmations.remove(data);
                break;
            }
            this.notifyAll();
        }

        synchronized void close() {
            if (this.writeException != null) {
                this.writeException = new ClosedChannelException();
            }
            this.notifyAll();
        }

        synchronized boolean reset() {
            return this.pendingWriteConfirmations.isEmpty();
        }
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix = "xNbcPool-" + POOL_NUMBER.getAndIncrement() + "-thread-";

        DefaultThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.namePrefix + this.threadNumber.getAndIncrement());
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private final class IoHandlerCallback
    implements IIoHandlerCallback {
        private IoHandlerCallback() {
        }

        public void onWritten(ByteBuffer data) {
            NonBlockingConnection.this.onWritten(data);
        }

        public void onWriteException(IOException ioException, ByteBuffer data) {
            NonBlockingConnection.this.onWriteException(ioException, data);
        }

        public void onData(ByteBuffer[] data, int size) {
            NonBlockingConnection.this.onData(data, size);
        }

        public void onPostData() {
            NonBlockingConnection.this.onPostData();
        }

        public void onConnectionAbnormalTerminated() {
            NonBlockingConnection.this.onConnectionAbnormalTerminated();
        }

        public void onConnect() {
            NonBlockingConnection.this.onConnect();
        }

        public void onConnectException(IOException ioe) {
            NonBlockingConnection.this.onConnectException(ioe);
        }

        public void onDisconnect() {
            NonBlockingConnection.this.onDisconnect();
        }
    }

    private final class SendTask
    implements IWriteCompletionHandler,
    IUnsynchronized {
        private final Object guard;
        private final ReadableByteChannel sourceChannel;
        private final ByteBuffer copyBuffer;
        private boolean isComplete = false;
        private long written = 0L;
        private IOException ioe;

        public SendTask(Object guard, ReadableByteChannel sourceChannel, ByteBuffer copyBuffer) {
            this.guard = guard;
            this.sourceChannel = sourceChannel;
            this.copyBuffer = copyBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWritten(int written) {
            block9: {
                if (this.isComplete) {
                    return;
                }
                try {
                    this.copyBuffer.clear();
                    int read = this.sourceChannel.read(this.copyBuffer);
                    if (read > 0) {
                        this.copyBuffer.flip();
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("writing next chunk (" + this.copyBuffer.remaining() + " bytes)");
                        }
                        NonBlockingConnection.this.write(this.copyBuffer, (IWriteCompletionHandler)this);
                        if (!NonBlockingConnection.this.isAutoflush()) {
                            NonBlockingConnection.this.flush();
                        }
                        break block9;
                    }
                    Object object = this.guard;
                    synchronized (object) {
                        this.isComplete = true;
                        this.guard.notifyAll();
                    }
                }
                catch (IOException ioe) {
                    this.onException(ioe);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(IOException ioe) {
            if (this.isComplete) {
                return;
            }
            this.ioe = ioe;
            Object object = this.guard;
            synchronized (object) {
                this.isComplete = true;
                this.guard.notifyAll();
            }
        }

        IOException getException() {
            return this.ioe;
        }

        boolean isComplete() {
            return this.isComplete;
        }

        long getWritten() {
            return this.written;
        }
    }

    private final class AsyncIoConnectorCallback
    implements IIoConnectorCallback {
        private final InetSocketAddress remoteAddress;
        private final SocketChannel channel;
        private final SSLContext sslContext;
        private final boolean isSecured;
        private final long connectTimeoutMillis;

        public AsyncIoConnectorCallback(InetSocketAddress remoteAddress, SocketChannel channel, SSLContext sslContext, boolean isSecured, long connectTimeoutMillis) {
            this.remoteAddress = remoteAddress;
            this.channel = channel;
            this.sslContext = sslContext;
            this.isSecured = isSecured;
            this.connectTimeoutMillis = connectTimeoutMillis;
        }

        public void onConnectionEstablished() throws IOException {
            NonBlockingConnection.this.register(this.channel, this.sslContext, this.isSecured);
        }

        public void onConnectError(IOException ioe) {
            NonBlockingConnection.this.onConnectException(ioe);
        }

        public void onConnectTimeout() {
            NonBlockingConnection.this.onConnectException(new SocketTimeoutException("connect timeout " + DataConverter.toFormatedDuration(this.connectTimeoutMillis) + " occured by connecting " + this.remoteAddress));
        }
    }

    private final class SyncIoConnectorCallback
    implements IIoConnectorCallback {
        private final InetSocketAddress remoteAddress;
        private final SocketChannel channel;
        private final SSLContext sslContext;
        private final boolean isSecured;
        private final long connectTimeoutMillis;
        private boolean isOperationClosed = false;
        private IOException ioe = null;

        public SyncIoConnectorCallback(InetSocketAddress remoteAddress, SocketChannel channel, SSLContext sslContext, boolean isSecured, long connectTimeoutMillis) {
            this.remoteAddress = remoteAddress;
            this.channel = channel;
            this.sslContext = sslContext;
            this.isSecured = isSecured;
            this.connectTimeoutMillis = connectTimeoutMillis;
        }

        public void onConnectionEstablished() throws IOException {
            NonBlockingConnection.this.register(this.channel, this.sslContext, this.isSecured);
            this.notifyWaiting();
        }

        public void onConnectError(IOException ioe) {
            this.ioe = ioe;
            NonBlockingConnection.this.onConnectException(ioe);
            this.notifyWaiting();
        }

        public void onConnectTimeout() {
            this.ioe = new SocketTimeoutException("connect timeout " + DataConverter.toFormatedDuration(this.connectTimeoutMillis) + " occured by connecting " + this.remoteAddress);
            NonBlockingConnection.this.onConnectException(this.ioe);
            this.notifyWaiting();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyWaiting() {
            SyncIoConnectorCallback syncIoConnectorCallback = this;
            synchronized (syncIoConnectorCallback) {
                this.isOperationClosed = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void connect() throws IOException {
            SyncIoConnectorCallback syncIoConnectorCallback = this;
            synchronized (syncIoConnectorCallback) {
                if (!this.isOperationClosed) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.ioe != null) {
                throw this.ioe;
            }
        }
    }
}

