/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.HandlerAdapter;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IConnectionPool;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IWriteCompletionHandler;
import org.xsocket.connection.NonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonBlockingConnectionPool
implements IConnectionPool {
    private static final Logger LOG = Logger.getLogger(NonBlockingConnectionPool.class.getName());
    private static final long WATCHDOG_PERIOD_MILLIS = 30000L;
    private static final Timer WATCHDOG_TIMER = new Timer("xResourcePoolTimer", true);
    private static final long MIN_REMAINING_MILLIS_TO_IDLE_TIMEOUT = 3000L;
    private static final long MIN_REMAINING_MILLIS_TO_CONNECTION_TIMEOUT = 3000L;
    private static final int MAX_TIMEOUT = Integer.MAX_VALUE;
    private boolean isOpen = true;
    private int maxActive = Integer.MAX_VALUE;
    private int maxIdle = Integer.MAX_VALUE;
    private long maxWaitMillis = Long.MAX_VALUE;
    private int idleTimeoutMillis = Integer.MAX_VALUE;
    private int lifeTimeoutMillis = Integer.MAX_VALUE;
    private final SSLContext sslContext;
    private Executor workerpool = NonBlockingConnection.getDefaultWorkerpool();
    private final Pool pool = new Pool();
    private final Object retrieveGuard = new Object();
    private final List<ILifeCycle> listeners = new ArrayList<ILifeCycle>();
    private final AtomicInteger countPendingGet = new AtomicInteger(0);
    private int countCreated;
    private int countDestroyed;
    private int countTimeoutPooledLifetime;
    private int countTimeoutPooledIdle;
    private int countTimeoutConnectionIdle;
    private int countTimeoutConnectionLifetime;
    private int countCreationError;
    private TimerTask watchDogTask = new TimerTask(){

        public void run() {
            long currentTimeSec = System.currentTimeMillis();
            for (PooledConnectionHolder pooledResource : NonBlockingConnectionPool.this.pool.getIdleConnections()) {
                boolean isValid = pooledResource.isValid(currentTimeSec);
                if (isValid || NonBlockingConnectionPool.this.pool.getIdleConnection(pooledResource) == null) continue;
                pooledResource.destroy();
            }
        }
    };

    public NonBlockingConnectionPool() {
        this(null);
    }

    public NonBlockingConnectionPool(SSLContext sslContext) {
        this.sslContext = sslContext;
        WATCHDOG_TIMER.schedule(this.watchDogTask, 30000L, 30000L);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), null, this.workerpool, Integer.MAX_VALUE, false);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), null, this.workerpool, Integer.MAX_VALUE, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, int connectTimeoutMillis) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), null, this.workerpool, connectTimeoutMillis, false);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), null, this.workerpool, connectTimeoutMillis, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, Integer.MAX_VALUE, false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, Integer.MAX_VALUE, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, int connectTimeoutMillis) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, connectTimeoutMillis, false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, connectTimeoutMillis, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, Integer.MAX_VALUE, false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, Integer.MAX_VALUE, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, IHandler appHandler) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), appHandler, this.workerpool, Integer.MAX_VALUE, false);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, IHandler appHandler, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), appHandler, this.workerpool, Integer.MAX_VALUE, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, connectTimeoutMillis, false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, connectTimeoutMillis, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, Executor workerPool, int connectTimeoutMillis) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, workerPool, connectTimeoutMillis, false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, Executor workerPool, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, workerPool, connectTimeoutMillis, isSSL);
    }

    private INonBlockingConnection getConnection(InetSocketAddress address, IHandler appHandler, Executor workerPool, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException {
        PooledConnectionHolder pooledConnectionHolder = this.getPooledConnection(address, workerPool, connectTimeoutMillis, isSSL);
        return new NonBlockingConnectionProxy(pooledConnectionHolder, appHandler);
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void addListener(ILifeCycle listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(ILifeCycle listener) {
        boolean result = this.listeners.remove(listener);
        return result;
    }

    public void setWorkerpool(Executor workerpool) {
        this.workerpool = workerpool;
    }

    public Executor getWorkerpool() {
        return this.workerpool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxActive() {
        NonBlockingConnectionPool nonBlockingConnectionPool = this;
        synchronized (nonBlockingConnectionPool) {
            return this.maxActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxActive(int maxActive) {
        NonBlockingConnectionPool nonBlockingConnectionPool = this;
        synchronized (nonBlockingConnectionPool) {
            this.maxActive = maxActive;
            this.notifyAll();
        }
    }

    @Override
    public long getCreationMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCreationMaxWaitMillis(long maxWaitMillis) {
        NonBlockingConnectionPool nonBlockingConnectionPool = this;
        synchronized (nonBlockingConnectionPool) {
            this.maxWaitMillis = maxWaitMillis;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxIdle() {
        NonBlockingConnectionPool nonBlockingConnectionPool = this;
        synchronized (nonBlockingConnectionPool) {
            return this.maxIdle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxIdle(int maxIdle) {
        NonBlockingConnectionPool nonBlockingConnectionPool = this;
        synchronized (nonBlockingConnectionPool) {
            this.maxIdle = maxIdle;
            this.notifyAll();
        }
    }

    @Override
    public int getNumActive() {
        return this.pool.getNumActive();
    }

    @Override
    public List<String> getActiveConnectionInfos() {
        return this.pool.getActiveConnectionInfos();
    }

    @Override
    public List<String> getIdleConnectionInfos() {
        return this.pool.getIdleConnectionInfos();
    }

    @Override
    public int getNumIdle() {
        return this.pool.getNumIdle();
    }

    @Override
    public int getNumCreated() {
        return this.countCreated;
    }

    public int getNumCreationError() {
        return this.countCreationError;
    }

    @Override
    public int getNumDestroyed() {
        return this.countDestroyed;
    }

    public int getNumTimeoutConnectionLifetime() {
        return this.countTimeoutConnectionLifetime;
    }

    public int getNumTimeoutConnectionIdle() {
        return this.countTimeoutConnectionIdle;
    }

    @Override
    public int getNumTimeoutPooledMaxIdleTime() {
        return this.countTimeoutPooledIdle;
    }

    @Override
    public int getNumTimeoutPooledMaxLifeTime() {
        return this.countTimeoutPooledLifetime;
    }

    @Override
    public int getPooledMaxIdleTimeMillis() {
        return this.idleTimeoutMillis;
    }

    @Override
    public void setPooledMaxIdleTimeMillis(int idleTimeoutMillis) {
        this.idleTimeoutMillis = idleTimeoutMillis;
    }

    @Override
    public int getPooledMaxLifeTimeMillis() {
        return this.lifeTimeoutMillis;
    }

    @Override
    public void setPooledMaxLifeTimeMillis(int lifeTimeoutMillis) {
        this.lifeTimeoutMillis = lifeTimeoutMillis;
    }

    public int getNumPendingGet() {
        return this.countPendingGet.get();
    }

    private PooledConnectionHolder getPooledConnection(InetSocketAddress address, Executor workerPool, int creationTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException {
        if (this.isOpen) {
            PooledConnectionHolder pooledConnectionHolder = this.retrievePooledConnection(address, workerPool, creationTimeoutMillis, isSSL);
            if (pooledConnectionHolder != null) {
                return pooledConnectionHolder;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("no free resources available waiting max " + DataConverter.toFormatedDuration(this.maxWaitMillis) + " for a free resource (" + this.pool.toString() + ", idleTimeoutMillis=" + this.getPooledMaxIdleTimeMillis() + ", lifeTimeout=" + this.getPooledMaxLifeTimeMillis() + ")");
            }
            return this.waitAndGetPooledConnection(address, workerPool, creationTimeoutMillis, isSSL);
        }
        throw new RuntimeException("pool is already closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledConnectionHolder waitAndGetPooledConnection(InetSocketAddress address, Executor workerPool, int creationTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException {
        PooledConnectionHolder pooledConnectionHolder = null;
        this.countPendingGet.incrementAndGet();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.maxWaitMillis) {
            long waitTime = this.maxWaitMillis - (System.currentTimeMillis() - start);
            if (waitTime > 0L) {
                Object object = this.retrieveGuard;
                synchronized (object) {
                    try {
                        this.retrieveGuard.wait(waitTime);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
            }
            if ((pooledConnectionHolder = this.retrievePooledConnection(address, workerPool, creationTimeoutMillis, isSSL)) == null) continue;
            if (!LOG.isLoggable(Level.FINE)) break;
            LOG.fine("now got a resource (waiting time " + DataConverter.toFormatedDuration(System.currentTimeMillis() - start) + ")");
            break;
        }
        this.countPendingGet.decrementAndGet();
        if (pooledConnectionHolder == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("wait timeout reached (" + DataConverter.toFormatedDuration(this.maxWaitMillis) + ")");
            }
            throw new SocketTimeoutException("wait timeout reached (" + DataConverter.toFormatedDuration(this.maxWaitMillis) + ")");
        }
        return pooledConnectionHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRetriever() {
        Object object = this.retrieveGuard;
        synchronized (object) {
            this.retrieveGuard.notifyAll();
        }
    }

    private synchronized PooledConnectionHolder retrievePooledConnection(InetSocketAddress address, Executor workerPool, int creationTimeoutMillis, boolean isSSL) throws IOException {
        PooledConnectionHolder pooledConnectionHolder = this.getConnectionFromPool(address, isSSL);
        if (pooledConnectionHolder != null) {
            return pooledConnectionHolder;
        }
        if (this.pool.getNumActive() < this.maxActive) {
            return this.newPooledConnection(address, workerPool, creationTimeoutMillis, isSSL);
        }
        return null;
    }

    private PooledConnectionHolder getConnectionFromPool(InetSocketAddress address, boolean isSSL) throws IOException {
        PooledConnectionHolder pooledConnectionHolder = this.pool.getIdleConnection(address, isSSL);
        if (pooledConnectionHolder != null) {
            boolean isValid = pooledConnectionHolder.reset();
            if (isValid) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("got connection from pool (" + this.pool.toString() + ", idleTimeoutMillis=" + this.getPooledMaxIdleTimeMillis() + ", lifeTimeout=" + this.getPooledMaxLifeTimeMillis() + "): " + pooledConnectionHolder.getConnection());
                }
                return pooledConnectionHolder;
            }
            return this.getConnectionFromPool(address, isSSL);
        }
        return null;
    }

    public static void destroy(INonBlockingConnection connection) throws IOException {
        if (connection == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("warning trying to destroy a <null> connection. destroy will be ignored");
            }
            return;
        }
        if (connection instanceof NonBlockingConnectionProxy) {
            ((NonBlockingConnectionProxy)connection).destroy();
        } else {
            connection.close();
        }
    }

    static boolean isDestroyed(INonBlockingConnection connection) {
        if (connection instanceof NonBlockingConnectionProxy) {
            return ((NonBlockingConnectionProxy)connection).isDestroyed();
        }
        return connection.isOpen();
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.watchDogTask.cancel();
            this.pool.close();
            for (ILifeCycle lifeCycle : this.listeners) {
                try {
                    lifeCycle.onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("exception occured by destroying " + lifeCycle + " " + ioe.toString());
                }
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " idling=" + this.getNumIdle() + ", active=" + this.getNumActive() + ", maxActive=" + this.getMaxActive() + ", idleTimeoutMillis=" + this.getPooledMaxIdleTimeMillis() + ", lifeTimeout=" + this.getPooledMaxLifeTimeMillis() + ")";
    }

    private PooledConnectionHolder newPooledConnection(Object address, Executor workerPool, int creationTimeoutMillis, boolean isSSL) throws IOException {
        int sleepTime = 3;
        long start = System.currentTimeMillis();
        while (true) {
            try {
                PooledConnectionHolder pooledConnectionHolder = new PooledConnectionHolder();
                NonBlockingConnection pooledConnection = new NonBlockingConnection((InetSocketAddress)address, true, creationTimeoutMillis, new HashMap<String, Object>(), this.sslContext, isSSL, pooledConnectionHolder, workerPool);
                pooledConnectionHolder.init(pooledConnection);
                ++this.countCreated;
                return pooledConnectionHolder;
            }
            catch (IOException ioe) {
                if (System.currentTimeMillis() > start + 500L) {
                    ++this.countCreationError;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("error occured by creating connection to " + address + ". creation timeout " + 500 + " reached.");
                    }
                    throw new IOException("could not connect to " + address);
                }
                sleepTime *= 3;
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ignore) {
                }
                continue;
            }
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NonBlockingConnectionProxy
    implements INonBlockingConnection {
        private PooledConnectionHolder pooledConnectionHolder = null;
        private String id = null;
        private boolean isProxyOpen = true;
        private HandlerAdapter handlerAdapter = null;
        private boolean idleTimeoutOccured = false;
        private boolean connectionTimeoutOccured = false;
        private boolean disconnectOccured = false;

        NonBlockingConnectionProxy(PooledConnectionHolder pooledConnectionHolder, IHandler appHandler) throws IOException {
            this.pooledConnectionHolder = pooledConnectionHolder;
            this.id = pooledConnectionHolder.getConnection().getId() + "I" + Integer.toHexString(pooledConnectionHolder.usage);
            this.setHandler(appHandler);
            pooledConnectionHolder.lease(this);
        }

        @Override
        public void setHandler(IHandler hdl) {
            this.handlerAdapter = HandlerAdapter.newInstance(hdl);
            if (!this.pooledConnectionHolder.getConnection().isReadBufferEmpty()) {
                this.onData();
            }
        }

        @Override
        public IHandler getHandler() {
            if (this.handlerAdapter == null) {
                return null;
            }
            return this.handlerAdapter.getHandler();
        }

        boolean isDestroyed() {
            return !this.pooledConnectionHolder.getConnection().isOpen();
        }

        @Override
        public boolean isOpen() {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().isOpen();
            }
            return false;
        }

        @Override
        public void close() throws IOException {
            if (!this.isProxyOpen) {
                this.destroy();
                return;
            }
            this.isProxyOpen = false;
            this.pooledConnectionHolder.release();
            NonBlockingConnectionPool.this.notifyRetriever();
        }

        void destroy() {
            block3: {
                if (this.isProxyOpen) {
                    this.isProxyOpen = false;
                    try {
                        this.onDisconnect();
                        this.pooledConnectionHolder.destroy();
                        NonBlockingConnectionPool.this.notifyRetriever();
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block3;
                        LOG.fine("error occured while destroying pooledConnectionHolder " + this.pooledConnectionHolder + " reason: " + e.toString());
                    }
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getId());
            if (!this.isOpen()) {
                sb.append(" closed");
            }
            sb.append(" (" + this.pooledConnectionHolder.getAddress() + ") ");
            sb.append(" (proxy ");
            if (!this.isProxyOpen) {
                sb.append("closed ");
            }
            sb.append("countUsage=" + this.pooledConnectionHolder.getUsage() + ", dateLastUsage=" + DataConverter.toFormatedDate(this.pooledConnectionHolder.getLastUsageTimeMillis()) + ", idledTimeBetweenUsage=" + this.pooledConnectionHolder.getIdledTimeBetweenUsage() + " millis)");
            return sb.toString();
        }

        @Override
        public String getId() {
            return this.id;
        }

        private boolean onConnect() {
            try {
                return this.handlerAdapter.onConnect(this, this.pooledConnectionHolder.connection.getTaskQueue());
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Error occured by perform onConnect callback on " + this.handlerAdapter + " " + ioe.toString());
                }
                return false;
            }
        }

        private boolean onDisconnect() {
            if (!this.disconnectOccured) {
                this.disconnectOccured = true;
                try {
                    return this.handlerAdapter.onDisconnect(this, this.pooledConnectionHolder.connection.getTaskQueue());
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Error occured by perform onDisconnect callback on " + this.handlerAdapter + " " + ioe.toString());
                    }
                    return false;
                }
            }
            return true;
        }

        private boolean onData() {
            try {
                return this.handlerAdapter.onData(this, this.pooledConnectionHolder.connection.getTaskQueue());
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Error occured by perform onData callback on " + this.handlerAdapter + " " + ioe.toString());
                }
                return false;
            }
        }

        private boolean onConnectionTimeout() {
            if (!this.connectionTimeoutOccured) {
                this.connectionTimeoutOccured = true;
                try {
                    return this.handlerAdapter.onConnectionTimeout(this, this.pooledConnectionHolder.connection.getTaskQueue());
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Error occured by perform onConnectTimeout callback on " + this.handlerAdapter + " " + ioe.toString());
                    }
                    return false;
                }
            }
            this.setConnectionTimeoutMillis(Long.MAX_VALUE);
            return true;
        }

        private boolean onIdleTimeout() {
            if (!this.idleTimeoutOccured) {
                this.idleTimeoutOccured = true;
                try {
                    return this.handlerAdapter.onIdleTimeout(this, this.pooledConnectionHolder.connection.getTaskQueue());
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Error occured by perform onIdleTimeout callback on " + this.handlerAdapter + " " + ioe.toString());
                    }
                    return false;
                }
            }
            this.setIdleTimeoutMillis(Long.MAX_VALUE);
            return true;
        }

        @Override
        public Executor getWorkerpool() {
            return this.pooledConnectionHolder.getConnection().getWorkerpool();
        }

        @Override
        public void setWorkerpool(Executor workerpool) {
            this.pooledConnectionHolder.getConnection().setWorkerpool(workerpool);
        }

        void setReusable(boolean isReusable) {
            this.pooledConnectionHolder.setReusable(isReusable);
        }

        @Override
        public void setAttachment(Object obj) {
            this.pooledConnectionHolder.getConnection().setAttachment(obj);
        }

        @Override
        public Object getAttachment() {
            return this.pooledConnectionHolder.getConnection().getAttachment();
        }

        @Override
        public void setAutoflush(boolean autoflush) {
            this.pooledConnectionHolder.getConnection().setAutoflush(autoflush);
        }

        @Override
        public boolean isAutoflush() {
            return this.pooledConnectionHolder.getConnection().isAutoflush();
        }

        @Override
        public boolean isServerSide() {
            return this.pooledConnectionHolder.getConnection().isServerSide();
        }

        @Override
        public void setEncoding(String defaultEncoding) {
            this.pooledConnectionHolder.getConnection().setEncoding(defaultEncoding);
        }

        @Override
        public String getEncoding() {
            return this.pooledConnectionHolder.getConnection().getEncoding();
        }

        @Override
        public void setFlushmode(IConnection.FlushMode flushMode) {
            this.pooledConnectionHolder.getConnection().setFlushmode(flushMode);
        }

        @Override
        public IConnection.FlushMode getFlushmode() {
            return this.pooledConnectionHolder.getConnection().getFlushmode();
        }

        @Override
        public void setOption(String name, Object value) throws IOException {
            if (this.isProxyOpen) {
                try {
                    this.pooledConnectionHolder.getConnection().setOption(name, value);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            } else {
                throw new ClosedChannelException();
            }
        }

        @Override
        public Object getOption(String name) throws IOException {
            try {
                return this.pooledConnectionHolder.getConnection().getOption(name);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public Map<String, Class> getOptions() {
            return this.pooledConnectionHolder.getConnection().getOptions();
        }

        @Override
        public void setWriteTransferRate(int bytesPerSecond) throws ClosedChannelException, IOException {
            if (this.isOpen()) {
                try {
                    this.pooledConnectionHolder.getConnection().setWriteTransferRate(bytesPerSecond);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            } else {
                throw new ClosedChannelException();
            }
        }

        @Override
        public int getWriteTransferRate() throws ClosedChannelException, IOException {
            return this.pooledConnectionHolder.getConnection().getWriteTransferRate();
        }

        @Override
        public int getMaxReadBufferThreshold() {
            return this.pooledConnectionHolder.getConnection().getMaxReadBufferThreshold();
        }

        @Override
        public void setMaxReadBufferThreshold(int size) {
            this.pooledConnectionHolder.getConnection().setMaxReadBufferThreshold(size);
        }

        @Override
        public void setConnectionTimeoutMillis(long timeoutMillis) {
            if (!this.isProxyOpen) {
                throw new RuntimeException("connection (proxy) " + this.getId() + " is closed");
            }
            this.pooledConnectionHolder.getConnection().setConnectionTimeoutMillis(timeoutMillis);
            this.connectionTimeoutOccured = false;
        }

        @Override
        public long getConnectionTimeoutMillis() {
            return this.pooledConnectionHolder.getConnection().getConnectionTimeoutMillis();
        }

        @Override
        public void setIdleTimeoutMillis(long timeoutInMillis) {
            if (!this.isProxyOpen) {
                throw new RuntimeException("connection (proxy) " + this.getId() + " is closed");
            }
            this.pooledConnectionHolder.getConnection().setIdleTimeoutMillis(timeoutInMillis);
            this.idleTimeoutOccured = false;
        }

        @Override
        public long getIdleTimeoutMillis() {
            return this.pooledConnectionHolder.getConnection().getIdleTimeoutMillis();
        }

        @Override
        public long getRemainingMillisToConnectionTimeout() {
            return this.pooledConnectionHolder.getConnection().getConnectionTimeoutMillis();
        }

        @Override
        public long getRemainingMillisToIdleTimeout() {
            return this.pooledConnectionHolder.getConnection().getRemainingMillisToIdleTimeout();
        }

        @Override
        public boolean isSecure() {
            return this.pooledConnectionHolder.getConnection().isSecure();
        }

        @Override
        public void activateSecuredMode() throws IOException {
            if (this.isProxyOpen) {
                try {
                    this.pooledConnectionHolder.getConnection().activateSecuredMode();
                    this.setReusable(false);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            } else {
                throw new ClosedChannelException();
            }
        }

        @Override
        public boolean isSecuredModeActivateable() {
            return this.pooledConnectionHolder.getConnection().isSecuredModeActivateable();
        }

        @Override
        public void suspendReceiving() throws IOException {
            if (this.isProxyOpen) {
                try {
                    this.pooledConnectionHolder.getConnection().suspendRead();
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            } else {
                throw new ClosedChannelException();
            }
        }

        @Override
        public void suspendRead() throws IOException {
            this.suspendReceiving();
        }

        @Override
        public boolean isReceivingSuspended() {
            return this.pooledConnectionHolder.getConnection().isReadSuspended();
        }

        @Override
        public boolean isReadSuspended() {
            return this.isReceivingSuspended();
        }

        @Override
        public void resumeReceiving() throws IOException {
            if (this.isProxyOpen) {
                try {
                    this.pooledConnectionHolder.getConnection().resumeRead();
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            } else {
                throw new ClosedChannelException();
            }
        }

        @Override
        public void resumeRead() throws IOException {
            this.resumeReceiving();
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.pooledConnectionHolder.getConnection().getLocalAddress();
        }

        @Override
        public int getLocalPort() {
            return this.pooledConnectionHolder.getConnection().getLocalPort();
        }

        @Override
        public InetAddress getRemoteAddress() {
            return this.pooledConnectionHolder.getConnection().getRemoteAddress();
        }

        @Override
        public int getRemotePort() {
            return this.pooledConnectionHolder.getConnection().getRemotePort();
        }

        @Override
        public int write(byte b) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                try {
                    return this.pooledConnectionHolder.getConnection().write(b);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public int write(byte ... bytes) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                try {
                    return this.pooledConnectionHolder.getConnection().write(bytes);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public void write(byte[] bytes, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            if (this.isProxyOpen) {
                try {
                    this.pooledConnectionHolder.getConnection().write(bytes, writeCompletionHandler);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            } else {
                throw new ClosedChannelException();
            }
        }

        @Override
        public int write(byte[] bytes, int offset, int length) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                try {
                    return this.pooledConnectionHolder.getConnection().write(bytes, offset, length);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public void write(byte[] bytes, int offset, int length, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            if (this.isProxyOpen) {
                try {
                    this.pooledConnectionHolder.getConnection().write(bytes, offset, length, writeCompletionHandler);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            } else {
                throw new ClosedChannelException();
            }
        }

        @Override
        public int write(ByteBuffer buffer) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                try {
                    return this.pooledConnectionHolder.getConnection().write(buffer);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public void write(ByteBuffer buffer, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            if (this.isProxyOpen) {
                try {
                    this.pooledConnectionHolder.getConnection().write(buffer, writeCompletionHandler);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            } else {
                throw new ClosedChannelException();
            }
        }

        @Override
        public void write(ByteBuffer[] buffers, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            if (this.isProxyOpen) {
                try {
                    this.pooledConnectionHolder.getConnection().write(buffers, writeCompletionHandler);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            } else {
                throw new ClosedChannelException();
            }
        }

        @Override
        public long write(ByteBuffer[] buffers) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                try {
                    return this.pooledConnectionHolder.getConnection().write(buffers);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            if (this.isProxyOpen) {
                try {
                    return this.pooledConnectionHolder.getConnection().write(srcs, offset, length);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public void write(ByteBuffer[] srcs, int offset, int length, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            if (this.isProxyOpen) {
                try {
                    this.pooledConnectionHolder.getConnection().write(srcs, offset, length, writeCompletionHandler);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            } else {
                throw new ClosedChannelException();
            }
        }

        @Override
        public int write(double d) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                try {
                    return this.pooledConnectionHolder.getConnection().write(d);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public int write(int i) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                try {
                    return this.pooledConnectionHolder.getConnection().write(i);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public long write(List<ByteBuffer> buffers) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                try {
                    return this.pooledConnectionHolder.getConnection().write(buffers);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public void write(List<ByteBuffer> buffers, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            if (this.isProxyOpen) {
                try {
                    this.pooledConnectionHolder.getConnection().write(buffers, writeCompletionHandler);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            } else {
                throw new ClosedChannelException();
            }
        }

        @Override
        public int write(long l) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                try {
                    return this.pooledConnectionHolder.getConnection().write(l);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public int write(short s) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                try {
                    return this.pooledConnectionHolder.getConnection().write(s);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public int write(String message) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                try {
                    return this.pooledConnectionHolder.getConnection().write(message);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public int write(String message, String encoding) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                try {
                    return this.pooledConnectionHolder.getConnection().write(message, encoding);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public void write(String message, String encoding, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            if (this.isProxyOpen) {
                try {
                    this.pooledConnectionHolder.getConnection().write(message, encoding, writeCompletionHandler);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            } else {
                throw new ClosedChannelException();
            }
        }

        @Override
        public void flush() throws ClosedChannelException, IOException, SocketTimeoutException {
            if (this.isProxyOpen) {
                try {
                    this.pooledConnectionHolder.getConnection().flush();
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            } else {
                throw new ClosedChannelException();
            }
        }

        @Override
        public long transferFrom(FileChannel source) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                try {
                    return this.pooledConnectionHolder.getConnection().transferFrom(source);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public long transferFrom(ReadableByteChannel source) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                try {
                    return this.pooledConnectionHolder.getConnection().transferFrom(source);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public long transferFrom(ReadableByteChannel source, int chunkSize) throws IOException, BufferOverflowException {
            if (this.isProxyOpen) {
                try {
                    return this.pooledConnectionHolder.getConnection().transferFrom(source, chunkSize);
                }
                catch (ClosedChannelException cce) {
                    NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                    throw cce;
                }
            }
            throw new ClosedChannelException();
        }

        @Override
        public int getPendingWriteDataSize() {
            return this.pooledConnectionHolder.getConnection().getPendingWriteDataSize();
        }

        @Override
        public void markWritePosition() {
            if (!this.isProxyOpen) {
                throw new RuntimeException("connection (proxy) " + this.getId() + " is closed");
            }
            this.pooledConnectionHolder.getConnection().markWritePosition();
        }

        @Override
        public void removeWriteMark() {
            if (!this.isProxyOpen) {
                throw new RuntimeException("connection (proxy) " + this.getId() + " is closed");
            }
            this.pooledConnectionHolder.getConnection().removeWriteMark();
        }

        @Override
        public boolean resetToWriteMark() {
            if (this.isProxyOpen) {
                return this.pooledConnectionHolder.getConnection().resetToWriteMark();
            }
            throw new RuntimeException("connection (proxy) " + this.getId() + " is closed");
        }

        @Override
        public void markReadPosition() {
            this.pooledConnectionHolder.getConnection().markReadPosition();
        }

        @Override
        public void removeReadMark() {
            this.pooledConnectionHolder.getConnection().removeReadMark();
        }

        @Override
        public boolean resetToReadMark() {
            return this.pooledConnectionHolder.getConnection().resetToReadMark();
        }

        @Override
        public int available() throws IOException {
            return this.pooledConnectionHolder.getConnection().available();
        }

        @Override
        public int getReadBufferVersion() throws IOException {
            return this.pooledConnectionHolder.getConnection().getReadBufferVersion();
        }

        @Override
        public int indexOf(String str) throws IOException {
            return this.pooledConnectionHolder.getConnection().indexOf(str);
        }

        @Override
        public int indexOf(String str, String encoding) throws IOException {
            return this.pooledConnectionHolder.getConnection().indexOf(str, encoding);
        }

        @Override
        public void unread(ByteBuffer[] buffers) throws IOException {
            try {
                this.pooledConnectionHolder.getConnection().unread(buffers);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public void unread(byte[] bytes) throws IOException {
            try {
                this.pooledConnectionHolder.getConnection().unread(bytes);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public void unread(ByteBuffer buffer) throws IOException {
            try {
                this.pooledConnectionHolder.getConnection().unread(buffer);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public void unread(String text) throws IOException {
            try {
                this.pooledConnectionHolder.getConnection().unread(text);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public int read(ByteBuffer buffer) throws IOException {
            try {
                return this.pooledConnectionHolder.getConnection().read(buffer);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public byte readByte() throws IOException, BufferUnderflowException {
            try {
                return this.pooledConnectionHolder.getConnection().readByte();
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, BufferUnderflowException {
            try {
                return this.pooledConnectionHolder.getConnection().readByteBufferByDelimiter(delimiter);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            try {
                return this.pooledConnectionHolder.getConnection().readByteBufferByDelimiter(delimiter, maxLength);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException {
            try {
                return this.pooledConnectionHolder.getConnection().readByteBufferByDelimiter(delimiter, encoding);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            try {
                return this.pooledConnectionHolder.getConnection().readByteBufferByDelimiter(delimiter, encoding, maxLength);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public ByteBuffer[] readByteBufferByLength(int length) throws IOException, BufferUnderflowException {
            try {
                return this.pooledConnectionHolder.getConnection().readByteBufferByLength(length);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter) throws IOException, BufferUnderflowException {
            try {
                return this.pooledConnectionHolder.getConnection().readBytesByDelimiter(delimiter);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            try {
                return this.pooledConnectionHolder.getConnection().readBytesByDelimiter(delimiter, maxLength);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException {
            try {
                return this.pooledConnectionHolder.getConnection().readBytesByDelimiter(delimiter, encoding);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            try {
                return this.pooledConnectionHolder.getConnection().readBytesByDelimiter(delimiter, encoding, maxLength);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public byte[] readBytesByLength(int length) throws IOException, BufferUnderflowException {
            try {
                return this.pooledConnectionHolder.getConnection().readBytesByLength(length);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public double readDouble() throws IOException, BufferUnderflowException {
            try {
                return this.pooledConnectionHolder.getConnection().readDouble();
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public int readInt() throws IOException, BufferUnderflowException {
            try {
                return this.pooledConnectionHolder.getConnection().readInt();
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public long readLong() throws IOException, BufferUnderflowException {
            try {
                return this.pooledConnectionHolder.getConnection().readLong();
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public short readShort() throws IOException, BufferUnderflowException {
            try {
                return this.pooledConnectionHolder.getConnection().readShort();
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public String readStringByDelimiter(String delimiter) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
            try {
                return this.pooledConnectionHolder.getConnection().readStringByDelimiter(delimiter);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
            try {
                return this.pooledConnectionHolder.getConnection().readStringByDelimiter(delimiter, maxLength);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public String readStringByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
            try {
                return this.pooledConnectionHolder.getConnection().readStringByDelimiter(delimiter, encoding);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
            try {
                return this.pooledConnectionHolder.getConnection().readStringByDelimiter(delimiter, encoding, maxLength);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public String readStringByLength(int length) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
            try {
                return this.pooledConnectionHolder.getConnection().readStringByLength(length);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public String readStringByLength(int length, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
            try {
                return this.pooledConnectionHolder.getConnection().readStringByLength(length, encoding);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }

        @Override
        public long transferTo(WritableByteChannel target, int length) throws IOException, BufferUnderflowException {
            try {
                return this.pooledConnectionHolder.getConnection().transferTo(target, length);
            }
            catch (ClosedChannelException cce) {
                NonBlockingConnectionPool.this.pool.removeAllIdleConnection(this.pooledConnectionHolder.getAddress());
                throw cce;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Pool {
        private final HashMap<InetSocketAddress, List<PooledConnectionHolder>> idlePool = new HashMap();
        private final HashSet<PooledConnectionHolder> managedPool = new HashSet();

        private Pool() {
        }

        public synchronized int getSize() {
            return this.managedPool.size();
        }

        public synchronized int getNumIdle() {
            int size = 0;
            for (List<PooledConnectionHolder> pooledResources : this.idlePool.values()) {
                size += pooledResources.size();
            }
            return size;
        }

        public synchronized int getNumActive() {
            return this.getSize() - this.getNumIdle();
        }

        public synchronized List<String> getActiveConnectionInfos() {
            ArrayList<String> result = new ArrayList<String>();
            HashSet managedPoolCopy = (HashSet)this.managedPool.clone();
            managedPoolCopy.removeAll(this.getIdleConnections());
            for (PooledConnectionHolder connectionHolder : managedPoolCopy) {
                result.add(connectionHolder.toString());
            }
            return result;
        }

        public synchronized List<String> getIdleConnectionInfos() {
            ArrayList<String> result = new ArrayList<String>();
            for (PooledConnectionHolder connectionHolder : this.getIdleConnections()) {
                result.add(connectionHolder.toString());
            }
            return result;
        }

        public synchronized Set<PooledConnectionHolder> getManagedConnection() {
            return (Set)this.managedPool.clone();
        }

        public synchronized Set<PooledConnectionHolder> getIdleConnections() {
            HashSet<PooledConnectionHolder> idleResources = new HashSet<PooledConnectionHolder>();
            for (List<PooledConnectionHolder> pooledResources : this.idlePool.values()) {
                for (PooledConnectionHolder pooledResource : pooledResources) {
                    idleResources.add(pooledResource);
                }
            }
            return idleResources;
        }

        public synchronized boolean remove(PooledConnectionHolder pooledResource) {
            boolean isRemoved = false;
            this.managedPool.remove(pooledResource);
            List<PooledConnectionHolder> pooledResources = this.idlePool.get(pooledResource.getAddress());
            if (pooledResources != null) {
                isRemoved = pooledResources.remove(pooledResource);
                if (pooledResources.isEmpty()) {
                    this.idlePool.remove(pooledResource.getAddress());
                }
            }
            return isRemoved;
        }

        public synchronized void register(PooledConnectionHolder pooledResource) {
            this.managedPool.add(pooledResource);
        }

        public synchronized PooledConnectionHolder getIdleConnection(InetSocketAddress address, boolean isSSL) {
            List<PooledConnectionHolder> pooledResources = this.idlePool.get(address);
            if (pooledResources == null) {
                return null;
            }
            PooledConnectionHolder result = null;
            for (PooledConnectionHolder pooledResource : pooledResources) {
                if (pooledResource.isSSL != isSSL) continue;
                result = pooledResource;
                break;
            }
            pooledResources.remove(result);
            if (pooledResources.isEmpty()) {
                this.idlePool.remove(address);
            }
            return result;
        }

        public synchronized void removeAllIdleConnection(InetSocketAddress address) {
            List<PooledConnectionHolder> pooledResources = this.idlePool.get(address);
            if (pooledResources == null) {
                return;
            }
            ArrayList<PooledConnectionHolder> found = new ArrayList<PooledConnectionHolder>();
            for (PooledConnectionHolder pooledResource : pooledResources) {
                found.add(pooledResource);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("removing all (" + found.size() + ") idle cons to " + address.toString());
            }
            for (PooledConnectionHolder pooledConnectionHolder : found) {
                this.remove(pooledConnectionHolder);
            }
        }

        public synchronized boolean containsIdleConnection(PooledConnectionHolder pooledResource) {
            List<PooledConnectionHolder> pooledResources = this.idlePool.get(pooledResource.getAddress());
            if (pooledResources != null) {
                return pooledResources.contains(pooledResource);
            }
            return false;
        }

        public synchronized PooledConnectionHolder getIdleConnection(PooledConnectionHolder pooledResource) {
            List<PooledConnectionHolder> pooledResources = this.idlePool.get(pooledResource.getAddress());
            if (pooledResources != null) {
                boolean isRemoved = pooledResources.remove(pooledResource);
                if (pooledResources.isEmpty()) {
                    this.idlePool.remove(pooledResource.getAddress());
                }
                if (isRemoved) {
                    return pooledResource;
                }
            }
            return null;
        }

        public synchronized void addIdleConnection(PooledConnectionHolder pooledResource) {
            this.managedPool.add(pooledResource);
            List<PooledConnectionHolder> pooledResources = this.idlePool.get(pooledResource.getAddress());
            if (pooledResources == null) {
                pooledResources = new ArrayList<PooledConnectionHolder>();
                this.idlePool.put(pooledResource.getAddress(), pooledResources);
            }
            pooledResources.add(pooledResource);
        }

        public synchronized void close() {
            List<PooledConnectionHolder> holders = this.getPooledConnectionHolders();
            for (PooledConnectionHolder holder : holders) {
                holder.destroy();
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("closing " + holders.size() + " idling conections; " + this.managedPool.size() + " connection(s) stay open");
            }
        }

        private List<PooledConnectionHolder> getPooledConnectionHolders() {
            ArrayList<PooledConnectionHolder> holders = new ArrayList<PooledConnectionHolder>();
            for (List<PooledConnectionHolder> hlds : this.idlePool.values()) {
                for (PooledConnectionHolder holder : hlds) {
                    holders.add(holder);
                }
            }
            return holders;
        }

        public String toString() {
            return "size=" + this.getSize() + ", active=" + this.getNumActive();
        }
    }

    @Execution(value=0)
    private final class PooledConnectionHolder
    implements IDataHandler,
    IDisconnectHandler,
    IConnectionTimeoutHandler,
    IIdleTimeoutHandler {
        private long creationTimeMillis = System.currentTimeMillis();
        private long lastUsageTimeMillis = System.currentTimeMillis();
        private long idledTimeMillis = 0L;
        private InetSocketAddress address = null;
        private boolean isReusable = true;
        private NonBlockingConnection connection = null;
        private boolean isSSL = false;
        private AtomicInteger destroyedConter = new AtomicInteger(0);
        private NonBlockingConnectionProxy proxy = null;
        private int usage = 0;

        private PooledConnectionHolder() {
        }

        void init(NonBlockingConnection connection) throws IOException {
            this.connection = connection;
            if (connection.isSecure()) {
                this.isSSL = true;
            }
            this.address = new InetSocketAddress(connection.getRemoteAddress(), connection.getRemotePort());
            NonBlockingConnectionPool.this.pool.register(this);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("pooled connection created (" + NonBlockingConnectionPool.this.pool.toString() + ", pooledIdleTimeoutMillis=" + NonBlockingConnectionPool.this.getPooledMaxIdleTimeMillis() + ", pooledLifeTimeout=" + NonBlockingConnectionPool.this.getPooledMaxLifeTimeMillis() + "): " + connection);
            }
        }

        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            if (this.proxy != null) {
                return this.proxy.onData();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            this.isReusable = false;
            try {
                if (this.proxy != null) {
                    boolean bl = this.proxy.onDisconnect();
                    return bl;
                }
                if (NonBlockingConnectionPool.this.pool.containsIdleConnection(this) && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] idle pooled connection (" + this.address.toString() + ") has been disconnected. removing it from pool (lifetime: " + DataConverter.toFormatedDuration(System.currentTimeMillis() - this.creationTimeMillis) + ")");
                }
                boolean bl = true;
                return bl;
            }
            finally {
                NonBlockingConnectionPool.this.pool.remove(this);
            }
        }

        public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
            this.isReusable = false;
            NonBlockingConnectionPool.this.countTimeoutConnectionLifetime++;
            if (this.proxy != null) {
                return this.proxy.onConnectionTimeout();
            }
            return true;
        }

        public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
            this.isReusable = false;
            NonBlockingConnectionPool.this.countTimeoutConnectionIdle++;
            if (this.proxy != null) {
                return this.proxy.onIdleTimeout();
            }
            return true;
        }

        void lease(NonBlockingConnectionProxy proxy) {
            this.proxy = proxy;
            if (proxy != null) {
                proxy.onConnect();
            }
            this.idledTimeMillis = System.currentTimeMillis() - this.lastUsageTimeMillis;
            ++this.usage;
        }

        int getUsage() {
            return this.usage;
        }

        long getIdledTimeBetweenUsage() {
            return this.idledTimeMillis;
        }

        long getCreationTimeMillis() {
            return this.creationTimeMillis;
        }

        long getLastUsageTimeMillis() {
            return this.lastUsageTimeMillis;
        }

        void setReusable(boolean isReusable) {
            this.isReusable = isReusable;
        }

        NonBlockingConnection getConnection() {
            return this.connection;
        }

        InetSocketAddress getAddress() {
            return this.address;
        }

        boolean isSecure() {
            return this.isSSL;
        }

        void release() {
            block11: {
                if (this.proxy != null) {
                    this.proxy.onDisconnect();
                    this.proxy = null;
                }
                try {
                    this.lastUsageTimeMillis = System.currentTimeMillis();
                    if (!(this.connection.isConnected() && this.connection.isOpen() && NonBlockingConnectionPool.this.isOpen())) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("do not return pooled connection (" + this.address.toString() + ") into to pool, because the connection or pool is closed");
                        }
                        this.destroy();
                        return;
                    }
                    boolean isValid = this.reset();
                    if (!isValid || !this.isReusable) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("do not return pooled connection (" + this.address.toString() + ") into to pool, because connection is not valid/reuseable");
                        }
                        this.destroy();
                        return;
                    }
                    if (NonBlockingConnectionPool.this.pool.getNumIdle() < NonBlockingConnectionPool.this.maxIdle) {
                        NonBlockingConnectionPool.this.pool.addIdleConnection(this);
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("connection (" + this.address.toString() + ") returned to pool (" + NonBlockingConnectionPool.this.pool.toString() + ", idleTimeoutMillis=" + NonBlockingConnectionPool.this.getPooledMaxIdleTimeMillis() + ", lifeTimeout=" + NonBlockingConnectionPool.this.getPooledMaxLifeTimeMillis() + "): " + this.connection);
                        }
                    } else {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("destroy idling connection (" + this.address.toString() + ") because max idle size " + NonBlockingConnectionPool.this.maxIdle + " reached: " + this);
                        }
                        this.destroy();
                    }
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block11;
                    LOG.fine("error occured by releasing a pooled connection (" + this.address.toString() + ") " + e.toString());
                }
            }
        }

        void destroy() {
            if (this.proxy != null) {
                this.proxy.onDisconnect();
                this.proxy = null;
            }
            NonBlockingConnectionPool.this.pool.remove(this);
            if (this.destroyedConter.incrementAndGet() == 1) {
                block5: {
                    NonBlockingConnectionPool.this.countDestroyed++;
                    try {
                        this.connection.close();
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block5;
                        LOG.fine("error occured by closing connection (" + this.address.toString() + ") " + this.connection + ": " + e.toString());
                    }
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("pooled connection (" + this.address.toString() + ") destroyed (" + NonBlockingConnectionPool.this.pool.toString() + ", idleTimeoutMillis=" + NonBlockingConnectionPool.this.getPooledMaxIdleTimeMillis() + ", lifeTimeout=" + NonBlockingConnectionPool.this.getPooledMaxLifeTimeMillis() + "): " + this.connection);
                }
            }
        }

        public boolean reset() {
            boolean isValid;
            boolean bl = isValid = this.connection.reset() && this.isValid(System.currentTimeMillis());
            if (isValid) {
                return true;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("pooled connection became invalid. destroying it, instead of returninh to pool");
            }
            this.destroy();
            return false;
        }

        boolean isValid(long currentTimeMillis) {
            if (!this.connection.isConnected() || !this.connection.isOpen()) {
                return false;
            }
            if (this.connection.getRemainingMillisToIdleTimeout() < 3000L) {
                return false;
            }
            if (this.connection.getRemainingMillisToConnectionTimeout() < 3000L) {
                return false;
            }
            if (NonBlockingConnectionPool.this.idleTimeoutMillis != Integer.MAX_VALUE && currentTimeMillis > this.lastUsageTimeMillis + (long)NonBlockingConnectionPool.this.idleTimeoutMillis) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.connection.getId() + "] connection (" + this.address + ") pool idle timeout reached (" + NonBlockingConnectionPool.this.idleTimeoutMillis + ")");
                }
                NonBlockingConnectionPool.this.countTimeoutPooledIdle++;
                return false;
            }
            if (NonBlockingConnectionPool.this.lifeTimeoutMillis != Integer.MAX_VALUE && currentTimeMillis > this.creationTimeMillis + (long)NonBlockingConnectionPool.this.lifeTimeoutMillis) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.connection.getId() + "] connection (" + this.address + ") pool life timeout reached (" + NonBlockingConnectionPool.this.lifeTimeoutMillis + ")");
                }
                NonBlockingConnectionPool.this.countTimeoutPooledLifetime++;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.connection.getLocalAddress().toString() + ":" + this.connection.getLocalPort() + " -> " + this.connection.getRemoteAddress().toString() + ":" + this.connection.getRemotePort() + " " + "[" + this.connection.getId() + "]");
            SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
            sb.append("creationTime=" + df.format(this.getCreationTimeMillis()) + ", lastUsageTime=" + df.format(this.getLastUsageTimeMillis()));
            return sb.toString();
        }
    }
}

