/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataConverter {
    private static final Map<String, CharsetEncoder> encoders = new HashMap<String, CharsetEncoder>();
    private static final Map<String, CharsetDecoder> decoders = new HashMap<String, CharsetDecoder>();

    public static String toFormatedBytesSize(long bytes) {
        if (bytes > 5000000L) {
            return bytes / 1000000L + " mb";
        }
        if (bytes > 10000L) {
            return bytes / 1000L + " kb";
        }
        return bytes + " bytes";
    }

    public static String toFormatedDate(long time) {
        return new SimpleDateFormat("MMM.dd HH:mm").format(new Date(time));
    }

    public static String toFormatedRFC822Date(long time) {
        return DataConverter.newRFC822DateFomat().format(time);
    }

    public static Date toDate(String rfc822DateString) {
        try {
            return DataConverter.newRFC822DateFomat().parse(rfc822DateString);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe.toString());
        }
    }

    private static SimpleDateFormat newRFC822DateFomat() {
        SimpleDateFormat df = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss z", Locale.US);
        df.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("GMT+0")));
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df;
    }

    public static String toFormatedDuration(long duration) {
        if (duration < 5000L) {
            return duration + " millis";
        }
        if (duration < 60000L) {
            return (int)(duration / 1000L) + " sec";
        }
        if (duration < 3600000L) {
            return (int)(duration / 60000L) + " min";
        }
        if (duration < 86400000L) {
            return (int)(duration / 3600000L) + " h";
        }
        return duration / 86400000L + " d";
    }

    public static ByteBuffer toByteBuffer(String s, String encoding) {
        try {
            return ByteBuffer.wrap(s.getBytes(encoding));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static String toString(ByteBuffer buffer) throws UnsupportedEncodingException {
        return DataConverter.toString(buffer, "UTF-8");
    }

    public static String toString(ByteBuffer[] buffer) throws UnsupportedEncodingException {
        return DataConverter.toString(buffer, "UTF-8");
    }

    public static String toString(ByteBuffer buffer, String encoding) throws UnsupportedEncodingException {
        try {
            CharsetDecoder decoder = decoders.get(encoding);
            if (decoder == null) {
                Charset charset = Charset.forName(encoding);
                decoder = charset.newDecoder();
                decoders.put(encoding, decoder);
                encoders.put(encoding, charset.newEncoder());
            }
            return decoder.decode(buffer).toString();
        }
        catch (CharacterCodingException cce) {
            RuntimeException re = new RuntimeException("coding exception for `" + encoding + "` occured: " + cce.toString(), cce);
            throw re;
        }
    }

    public static String toHexString(ByteBuffer buffer) {
        if (buffer == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (buffer.hasRemaining()) {
            String hex = Integer.toHexString(256 + (buffer.get() & 0xFF)).substring(1);
            sb.append((hex.length() < 2 ? "0" : "") + hex + " ");
        }
        return sb.toString();
    }

    public static String toString(List<ByteBuffer> buffers) throws UnsupportedEncodingException {
        return DataConverter.toString(buffers.toArray(new ByteBuffer[buffers.size()]), "UTF-8");
    }

    public static String toString(List<ByteBuffer> buffers, String encoding) throws UnsupportedEncodingException {
        return DataConverter.toString(buffers.toArray(new ByteBuffer[buffers.size()]), encoding);
    }

    public static String toString(ByteBuffer[] buffers, String encoding) throws UnsupportedEncodingException {
        return new String(DataConverter.toBytes(buffers), encoding);
    }

    public static String toString(ByteBuffer[] buffers, String encoding, int maxOutSize) throws UnsupportedEncodingException {
        String s = DataConverter.toString(buffers, encoding);
        if (s.length() > maxOutSize) {
            s = s.substring(0, maxOutSize) + " [output has been cut]";
        }
        return s;
    }

    public static ByteBuffer toByteBuffer(ByteBuffer[] buffers) {
        if (buffers.length == 0) {
            return ByteBuffer.allocate(0);
        }
        if (buffers.length == 1) {
            return buffers[0];
        }
        byte[] bytes = DataConverter.toBytes(buffers);
        return ByteBuffer.wrap(bytes);
    }

    public static ByteBuffer toByteBuffer(byte b) {
        ByteBuffer buffer = ByteBuffer.allocate(1).put(b);
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer toByteBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    public static ByteBuffer toByteBuffer(byte[] bytes, int offset, int length) {
        return ByteBuffer.wrap(bytes, offset, length);
    }

    public static ByteBuffer toByteBuffer(double d) {
        ByteBuffer buffer = ByteBuffer.allocate(8).putDouble(d);
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer toByteBuffer(long l) {
        ByteBuffer buffer = ByteBuffer.allocate(8).putLong(l);
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer toByteBuffer(short s) {
        ByteBuffer buffer = ByteBuffer.allocate(2).putShort(s);
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer toByteBuffer(int i) {
        ByteBuffer buffer = ByteBuffer.allocate(4).putInt(i);
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer[] toByteBuffers(ByteBuffer[] srcs, int offset, int length) {
        ByteBuffer[] bufs = new ByteBuffer[length];
        System.arraycopy(srcs, offset, bufs, 0, length);
        return bufs;
    }

    public static byte[] toBytes(List<ByteBuffer> buffers) {
        return DataConverter.toBytes(buffers.toArray(new ByteBuffer[buffers.size()]));
    }

    public static byte[] toBytes(ByteBuffer[] buffers) {
        if (buffers == null) {
            return new byte[0];
        }
        if (buffers.length == 0) {
            return new byte[0];
        }
        byte[][] bs = new byte[buffers.length][];
        int size = 0;
        for (int i = 0; i < buffers.length; ++i) {
            if (buffers[i] == null) continue;
            size += buffers[i].remaining();
            bs[i] = DataConverter.toBytes(buffers[i]);
        }
        byte[] result = new byte[size];
        int offset = 0;
        for (byte[] b : bs) {
            if (b == null) continue;
            System.arraycopy(b, 0, result, offset, b.length);
            offset += b.length;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(ByteBuffer buffer) {
        if (buffer == null) {
            return new byte[0];
        }
        int savedPos = buffer.position();
        int savedLimit = buffer.limit();
        try {
            byte[] array = new byte[buffer.limit() - buffer.position()];
            if (buffer.hasArray()) {
                int offset = buffer.arrayOffset() + savedPos;
                byte[] bufferArray = buffer.array();
                System.arraycopy(bufferArray, offset, array, 0, array.length);
                byte[] byArray = array;
                return byArray;
            }
            buffer.get(array);
            byte[] byArray = array;
            return byArray;
        }
        finally {
            buffer.position(savedPos);
            buffer.limit(savedLimit);
        }
    }

    public static String toHexString(byte[] buffers, int maxOutSize) {
        return DataConverter.toHexString(new ByteBuffer[]{ByteBuffer.wrap(buffers)}, maxOutSize);
    }

    public static String toHexString(List<ByteBuffer> buffers, int maxOutSize) {
        return DataConverter.toHexString(buffers.toArray(new ByteBuffer[buffers.size()]), maxOutSize);
    }

    public static String toHexString(ByteBuffer[] buffers, int maxOutSize) {
        String postfix = "";
        int size = 0;
        ArrayList<ByteBuffer> copies = new ArrayList<ByteBuffer>();
        for (ByteBuffer buffer : buffers) {
            if (buffer == null) continue;
            ByteBuffer copy = buffer.duplicate();
            if (size + copy.limit() > maxOutSize) {
                copy.limit(maxOutSize - size);
                copies.add(copy);
                postfix = " [...output has been cut]";
                break;
            }
            copies.add(copy);
        }
        StringBuilder result = new StringBuilder();
        for (ByteBuffer buffer : copies) {
            result.append(DataConverter.toHexString(buffer));
        }
        result.append(postfix);
        return result.toString();
    }

    public static String toTextOrHexString(ByteBuffer buffer, String encoding, int maxOutSize) {
        return DataConverter.toTextOrHexString(new ByteBuffer[]{buffer}, encoding, maxOutSize);
    }

    public static String toTextOrHexString(ByteBuffer[] buffers, String encoding, int maxOutSize) {
        boolean hasNonPrintableChars = false;
        for (ByteBuffer buffer : buffers) {
            ByteBuffer copy = buffer.duplicate();
            while (copy.hasRemaining()) {
                byte i = copy.get();
                if (i >= 10) continue;
                hasNonPrintableChars = true;
            }
        }
        if (hasNonPrintableChars) {
            return DataConverter.toHexString(buffers, maxOutSize);
        }
        try {
            return DataConverter.toString(buffers, encoding, maxOutSize);
        }
        catch (UnsupportedEncodingException use) {
            return DataConverter.toHexString(buffers, maxOutSize);
        }
    }

    public static String toTextAndHexString(ByteBuffer[] buffers, String encoding, int maxOutSize) {
        StringBuilder sb = new StringBuilder();
        sb.append(DataConverter.toHexString(buffers, 500));
        sb.append("\n");
        try {
            sb.append("[txt:] " + DataConverter.toString(buffers, "US-ASCII", 500));
        }
        catch (UnsupportedEncodingException ue) {
            sb.append("[txt:] ... content not printable ...");
        }
        return sb.toString();
    }

    public static String toString(Throwable t) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        t.printStackTrace(pw);
        pw.flush();
        return bos.toString();
    }
}

