/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.ExtendedClosedChannelException;
import org.xsocket.connection.HandlerAdapter;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IConnectionPool;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IWriteCompletionHandler;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.NonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonBlockingConnectionPool
implements IConnectionPool {
    private static final Logger LOG = Logger.getLogger(NonBlockingConnectionPool.class.getName());
    private static final long MIN_REMAINING_MILLIS_TO_IDLE_TIMEOUT = 3000L;
    private static final long MIN_REMAINING_MILLIS_TO_CONNECTION_TIMEOUT = 3000L;
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private final SSLContext sslContext;
    private final AtomicInteger maxActive = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger maxIdle = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicLong maxWaitMillis = new AtomicLong(Long.MAX_VALUE);
    private final AtomicInteger poolIdleTimeoutMillis = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger lifeTimeoutMillis = new AtomicInteger(Integer.MAX_VALUE);
    private final Pool pool = new Pool();
    private final Object retrieveGuard = new Object();
    private Executor workerpool = NonBlockingConnection.getDefaultWorkerpool();
    private int watchdogCheckPeriod = Integer.MAX_VALUE;
    private Watchog watchdog = null;
    private final List<ILifeCycle> listeners = new ArrayList<ILifeCycle>();
    private final AtomicInteger countPendingGet = new AtomicInteger(0);
    private final AtomicInteger countCreated = new AtomicInteger(0);
    private final AtomicInteger countDestroyed = new AtomicInteger(0);
    private final AtomicInteger countRemainingMillisToIdleTimeoutToSmall = new AtomicInteger(0);
    private final AtomicInteger countRemainingConnectionToIdleTimeoutToSmall = new AtomicInteger(0);
    private final AtomicInteger countCreationError = new AtomicInteger(0);
    private final AtomicInteger countIdleTimeout = new AtomicInteger(0);
    private final AtomicInteger countConnectionTimeout = new AtomicInteger(0);
    private final AtomicInteger countTimeoutPooledIdle = new AtomicInteger(0);
    private final AtomicInteger countTimeoutPooledLifetime = new AtomicInteger(0);

    public NonBlockingConnectionPool() {
        this(null);
    }

    public NonBlockingConnectionPool(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), null, this.workerpool, Integer.MAX_VALUE, this.maxWaitMillis.get(), false);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), null, this.workerpool, Integer.MAX_VALUE, this.maxWaitMillis.get(), isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, int connectTimeoutMillis) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), null, this.workerpool, connectTimeoutMillis, this.maxWaitMillis.get(), false);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), null, this.workerpool, connectTimeoutMillis, this.maxWaitMillis.get(), isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetSocketAddress address) throws IOException, SocketTimeoutException {
        return this.getConnection(address, null, this.workerpool, Integer.MAX_VALUE, this.maxWaitMillis.get(), false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, Integer.MAX_VALUE, this.maxWaitMillis.get(), false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, Integer.MAX_VALUE, this.maxWaitMillis.get(), isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, int connectTimeoutMillis) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, connectTimeoutMillis, this.maxWaitMillis.get(), false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, connectTimeoutMillis, this.maxWaitMillis.get(), isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, Integer.MAX_VALUE, this.maxWaitMillis.get(), false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, Integer.MAX_VALUE, this.maxWaitMillis.get(), isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, IHandler appHandler) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), appHandler, this.workerpool, Integer.MAX_VALUE, this.maxWaitMillis.get(), false);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, IHandler appHandler, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(host, port), appHandler, this.workerpool, Integer.MAX_VALUE, this.maxWaitMillis.get(), isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, connectTimeoutMillis, this.maxWaitMillis.get(), false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, connectTimeoutMillis, this.maxWaitMillis.get(), isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, Executor workerPool, int connectTimeoutMillis) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, workerPool, connectTimeoutMillis, this.maxWaitMillis.get(), false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, Executor workerPool, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, workerPool, connectTimeoutMillis, this.maxWaitMillis.get(), isSSL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private INonBlockingConnection getConnection(InetSocketAddress address, IHandler appHandler, Executor workerPool, int connectTimeoutMillis, long waitTimeMillis, boolean isSSL) throws IOException, SocketTimeoutException {
        if (this.isOpen.get()) {
            NativeConnectionHolder nativeConnectionHolder = this.pool.getAndRemoveIdleConnection(address, isSSL);
            if (nativeConnectionHolder != null) {
                boolean isValid = nativeConnectionHolder.isVaild(System.currentTimeMillis(), true);
                if (isValid && nativeConnectionHolder.getConnection().reset()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("got connection from pool (" + this.pool.toString() + ", idleTimeoutMillis=" + this.getPooledMaxIdleTimeMillis() + ", lifeTimeout=" + this.getPooledMaxLifeTimeMillis() + "): " + nativeConnectionHolder.getConnection());
                    }
                    return new NonBlockingConnectionProxy(nativeConnectionHolder, appHandler);
                }
                return this.getConnection(address, appHandler, workerPool, connectTimeoutMillis, waitTimeMillis, isSSL);
            }
            if (this.pool.getNumActive() < this.maxActive.get()) {
                nativeConnectionHolder = this.newNativeConnection(address, workerPool, connectTimeoutMillis, isSSL);
                return new NonBlockingConnectionProxy(nativeConnectionHolder, appHandler);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("no free resources available waiting max " + DataConverter.toFormatedDuration(this.maxWaitMillis.get()) + " for a free resource (" + this.pool.toString() + ", idleTimeoutMillis=" + this.getPooledMaxIdleTimeMillis() + ", lifeTimeout=" + this.getPooledMaxLifeTimeMillis() + ")");
            }
            long startTime = System.currentTimeMillis();
            Object object = this.retrieveGuard;
            synchronized (object) {
                try {
                    this.retrieveGuard.wait(waitTimeMillis);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            int elapsed = (int)(System.currentTimeMillis() - startTime);
            long remaining = waitTimeMillis - (long)elapsed;
            if (remaining > 0L) {
                return this.getConnection(address, appHandler, workerPool, connectTimeoutMillis, remaining, isSSL);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("wait timeout " + this.maxWaitMillis.get() + " reached");
            }
            throw new SocketTimeoutException("wait timeout reached");
        }
        throw new IOException("pool is already closed");
    }

    private void returnToIdlePool(NativeConnectionHolder nativeConnectionHolder) {
        this.pool.returnIdleConnection(nativeConnectionHolder);
        if (this.maxActive.get() < Integer.MAX_VALUE) {
            this.wakeupPendingRetrieve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeupPendingRetrieve() {
        Object object = this.retrieveGuard;
        synchronized (object) {
            this.retrieveGuard.notifyAll();
        }
    }

    private NativeConnectionHolder newNativeConnection(InetSocketAddress address, Executor workerPool, int creationTimeoutMillis, boolean isSSL) throws IOException {
        int trials = 0;
        int sleepTime = 3;
        long start = System.currentTimeMillis();
        while (true) {
            try {
                NativeConnectionHolder nativeConnectionHolder = new NativeConnectionHolder();
                NonBlockingConnection pooledConnection = new NonBlockingConnection(address, true, creationTimeoutMillis, new HashMap<String, Object>(), this.sslContext, isSSL, nativeConnectionHolder, workerPool);
                nativeConnectionHolder.init(pooledConnection);
                return nativeConnectionHolder;
            }
            catch (IOException ioe) {
                if (System.currentTimeMillis() > start + 500L) {
                    this.countCreationError.incrementAndGet();
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("error occured by creating connection to " + address + ". creation timeout " + 500 + " reached.");
                    }
                    throw new IOException("could not connect to " + address + " (" + trials + " trials) " + ioe.toString());
                }
                sleepTime *= 3;
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ignore) {
                }
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen.get();
    }

    @Override
    public void close() {
        if (this.isOpen.getAndSet(false)) {
            this.pool.close();
            this.stopWatchdog();
            for (ILifeCycle lifeCycle : this.listeners) {
                try {
                    lifeCycle.onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("exception occured by destroying " + lifeCycle + " " + ioe.toString());
                }
            }
            this.listeners.clear();
            this.workerpool = null;
        }
    }

    public void destroy() {
        if (this.isOpen.getAndSet(false)) {
            this.pool.destroy();
            this.stopWatchdog();
            for (ILifeCycle lifeCycle : this.listeners) {
                try {
                    lifeCycle.onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("exception occured by destroying " + lifeCycle + " " + ioe.toString());
                }
            }
            this.listeners.clear();
            this.workerpool = null;
        }
    }

    @Override
    public void addListener(ILifeCycle listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(ILifeCycle listener) {
        boolean result = this.listeners.remove(listener);
        return result;
    }

    public void setWorkerpool(Executor workerpool) {
        this.workerpool = workerpool;
    }

    public Executor getWorkerpool() {
        return this.workerpool;
    }

    @Override
    public int getMaxActive() {
        return this.maxActive.get();
    }

    @Override
    public void setMaxActive(int maxActive) {
        this.maxActive.set(maxActive);
        this.wakeupPendingRetrieve();
    }

    @Override
    public long getCreationMaxWaitMillis() {
        return this.maxWaitMillis.get();
    }

    @Override
    public void setCreationMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis.set(maxWaitMillis);
    }

    @Override
    public int getMaxIdle() {
        return this.maxIdle.get();
    }

    @Override
    public void setMaxIdle(int maxIdle) {
        this.maxIdle.set(maxIdle);
    }

    @Override
    public int getNumActive() {
        return this.pool.getNumActive();
    }

    @Override
    public List<String> getActiveConnectionInfos() {
        ArrayList<String> result = new ArrayList<String>();
        List<NativeConnectionHolder> connectionHolders = this.pool.newManagedPoolCopy();
        connectionHolders.removeAll(this.pool.newIdleCopySet());
        for (NativeConnectionHolder connectionHolder : connectionHolders) {
            result.add(connectionHolder.toString());
        }
        return result;
    }

    @Override
    public List<String> getIdleConnectionInfos() {
        ArrayList<String> result = new ArrayList<String>();
        for (NativeConnectionHolder nativeConnectionHolder : this.pool.newIdleCopySet()) {
            result.add(nativeConnectionHolder.toString());
        }
        return result;
    }

    @Override
    public int getNumIdle() {
        return this.pool.getNumIdle();
    }

    @Override
    public int getNumCreated() {
        return this.countCreated.get();
    }

    public int getNumCreationError() {
        return this.countCreationError.get();
    }

    @Override
    public int getNumDestroyed() {
        return this.countDestroyed.get();
    }

    int getNumIdleTimeout() {
        return this.countIdleTimeout.get();
    }

    int getNumConnectionTimeout() {
        return this.countConnectionTimeout.get();
    }

    int getNumPoolIdleTimeout() {
        return this.countTimeoutPooledIdle.get();
    }

    int getNumPoolLifetimeTimeout() {
        return this.countTimeoutPooledLifetime.get();
    }

    @Override
    public int getNumTimeoutPooledMaxIdleTime() {
        return this.countTimeoutPooledIdle.get();
    }

    @Override
    public int getNumTimeoutPooledMaxLifeTime() {
        return this.countTimeoutPooledLifetime.get();
    }

    @Override
    public int getPooledMaxIdleTimeMillis() {
        return this.poolIdleTimeoutMillis.get();
    }

    @Override
    public void setPooledMaxIdleTimeMillis(int idleTimeoutMillis) {
        this.poolIdleTimeoutMillis.set(idleTimeoutMillis);
        this.updateWatchdog(idleTimeoutMillis);
    }

    @Override
    public int getPooledMaxLifeTimeMillis() {
        return this.lifeTimeoutMillis.get();
    }

    @Override
    public void setPooledMaxLifeTimeMillis(int lifeTimeoutMillis) {
        this.lifeTimeoutMillis.set(lifeTimeoutMillis);
        this.updateWatchdog(lifeTimeoutMillis);
    }

    private synchronized void updateWatchdog(int requiredTimeMillis) {
        if (this.isOpen.get() && requiredTimeMillis < this.watchdogCheckPeriod * 5) {
            if (this.watchdog != null) {
                this.watchdog.cancel();
            }
            this.watchdogCheckPeriod = requiredTimeMillis / 5;
            if (this.watchdogCheckPeriod < 500) {
                this.watchdogCheckPeriod = 500;
            }
            this.watchdog = new Watchog();
            IoProvider.getTimer().schedule((TimerTask)this.watchdog, this.watchdogCheckPeriod, (long)this.watchdogCheckPeriod);
        }
    }

    private synchronized void stopWatchdog() {
        if (this.watchdog != null) {
            this.watchdog.cancel();
        }
    }

    public int getNumPendingGet() {
        return this.countPendingGet.get();
    }

    public static void destroy(INonBlockingConnection connection) throws IOException {
        if (connection == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("warning trying to destroy a <null> connection. destroy will be ignored");
            }
            return;
        }
        if (connection instanceof NonBlockingConnectionProxy) {
            ((NonBlockingConnectionProxy)connection).destroy();
        } else {
            connection.close();
        }
    }

    static boolean isDestroyed(INonBlockingConnection connection) {
        if (connection instanceof NonBlockingConnectionProxy) {
            return ((NonBlockingConnectionProxy)connection).isDestroyed();
        }
        return connection.isOpen();
    }

    private void checkIdleConnections() {
        long currentMillis = System.currentTimeMillis();
        for (NativeConnectionHolder nativeConnectionHolder : this.pool.newIdleCopySet()) {
            boolean isRemoved;
            if (nativeConnectionHolder.isVaild(currentMillis, false) || !(isRemoved = this.pool.removeIdleConnection(nativeConnectionHolder))) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + nativeConnectionHolder.getId() + "] closing connection because it is invalid");
            }
            nativeConnectionHolder.isVaild(currentMillis, true);
            nativeConnectionHolder.close();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("active=" + this.getNumActive() + ", idle=" + this.getNumIdle() + " ");
        sb.append("created=" + this.countCreated + ", destroyed=" + this.countDestroyed + " (");
        sb.append("maxActive=" + this.maxActive + ", maxIdle=" + this.maxIdle + ", maxWaitTimeMillis=" + this.maxWaitMillis + ", ");
        sb.append("poolIdleTimeout=" + this.poolIdleTimeoutMillis + ", poollifetimeTimeout=" + this.lifeTimeoutMillis + ")");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NonBlockingConnectionProxy
    implements INonBlockingConnection {
        private volatile boolean isOpen = true;
        private volatile boolean isDetached = false;
        private NativeConnectionHolder nativeConnectionHolder = null;
        private final String id;
        private HandlerAdapter handlerAdapter = null;
        private Object attachment = null;
        private final AtomicBoolean idleTimeoutOccured = new AtomicBoolean(false);
        private final AtomicBoolean connectionTimeoutOccured = new AtomicBoolean(false);
        private final AtomicBoolean disconnectOccured = new AtomicBoolean(false);

        NonBlockingConnectionProxy(NativeConnectionHolder holder, IHandler appHandler) throws IOException {
            this.nativeConnectionHolder = holder;
            this.id = holder.getConnection().getId() + "I" + Integer.toHexString(holder.usage);
            this.handlerAdapter = HandlerAdapter.newInstance(appHandler);
            holder.lease(this);
        }

        private void ensureOpen() {
            if (!this.isOpen) {
                throw new RuntimeException("channel " + this.getId() + " is closed");
            }
        }

        void dettach() {
            this.isDetached = true;
            this.nativeConnectionHolder = null;
        }

        @Override
        public void setHandler(IHandler hdl) throws IOException {
            this.ensureOpen();
            if (this.isDetached) {
                return;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                this.handlerAdapter = HandlerAdapter.newInstance(hdl);
                if (!holder.getConnection().isReadBufferEmpty()) {
                    this.onData();
                }
            }
        }

        @Override
        public IHandler getHandler() {
            this.ensureOpen();
            if (this.isDetached) {
                return null;
            }
            if (this.handlerAdapter == null) {
                return null;
            }
            return this.handlerAdapter.getHandler();
        }

        boolean isDestroyed() {
            if (this.isDetached) {
                return true;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return !holder.getConnection().isConnected();
            }
            return true;
        }

        @Override
        public boolean isOpen() {
            if (!this.isOpen) {
                return false;
            }
            if (this.isDetached) {
                return false;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().isOpen();
            }
            return false;
        }

        @Override
        public void close() throws IOException {
            NativeConnectionHolder holder;
            if (this.isOpen() && (holder = this.nativeConnectionHolder) != null) {
                holder.release();
            }
        }

        void destroy() {
            block4: {
                if (this.isDetached) {
                    return;
                }
                NativeConnectionHolder holder = this.nativeConnectionHolder;
                if (holder != null) {
                    try {
                        holder.close();
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block4;
                        LOG.fine("[" + this.getId() + "] error occured while destroying pooledConnectionHolder " + this.nativeConnectionHolder + " reason: " + e.toString());
                    }
                }
            }
        }

        public String toString() {
            NativeConnectionHolder holder;
            StringBuilder sb = new StringBuilder();
            sb.append(this.getId());
            if (!this.isOpen()) {
                sb.append(" closed");
            }
            if ((holder = this.nativeConnectionHolder) != null) {
                sb.append(" (" + holder.getAddress() + ") ");
            }
            sb.append(" (proxy ");
            if (holder == null) {
                sb.append("closed ");
            } else {
                sb.append("countUsage=" + holder.getUsage() + ", dateLastUsage=" + DataConverter.toFormatedDate(holder.getLastUsageTimeMillis()));
            }
            return sb.toString();
        }

        @Override
        public String getId() {
            return this.id;
        }

        private boolean onConnect() {
            if (this.isDetached) {
                return false;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                try {
                    return this.handlerAdapter.onConnect(this, holder.connection.getTaskQueue());
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] Error occured by perform onConnect callback on " + this.handlerAdapter + " " + ioe.toString());
                    }
                    return false;
                }
            }
            return false;
        }

        private boolean onDisconnect() {
            block5: {
                if (!this.disconnectOccured.getAndSet(true)) {
                    if (this.isDetached) {
                        return false;
                    }
                    NativeConnectionHolder holder = this.nativeConnectionHolder;
                    if (holder != null) {
                        try {
                            return this.handlerAdapter.onDisconnect(this, holder.connection.getTaskQueue());
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block5;
                            LOG.fine("[" + this.getId() + "] Error occured by perform onDisconnect callback on " + this.handlerAdapter + " " + ioe.toString());
                        }
                    }
                }
            }
            return false;
        }

        private boolean onData() throws IOException, MaxReadSizeExceededException {
            if (this.isDetached) {
                return true;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return this.handlerAdapter.onData(this, holder.connection.getTaskQueue(), false);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] onData called even though proxy is closed");
            }
            return true;
        }

        private boolean onConnectionTimeout() throws IOException {
            if (this.isDetached) {
                return true;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                if (!this.connectionTimeoutOccured.getAndSet(true)) {
                    return this.handlerAdapter.onConnectionTimeout(this, holder.connection.getTaskQueue());
                }
                return true;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] onConnectionTimeout called even though proxy is closed");
            }
            return true;
        }

        private boolean onIdleTimeout() throws IOException {
            if (this.isDetached) {
                return true;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                if (!this.idleTimeoutOccured.getAndSet(true)) {
                    return this.handlerAdapter.onIdleTimeout(this, holder.connection.getTaskQueue());
                }
                return true;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] onIdletimeout called even though proxy is closed");
            }
            return true;
        }

        void setReusable(boolean isReusable) {
            if (this.isDetached) {
                return;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                holder.setReusable(isReusable);
            }
        }

        @Override
        public boolean isServerSide() {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().isServerSide();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public Executor getWorkerpool() {
            if (this.isDetached) {
                return NonBlockingConnection.getDefaultWorkerpool();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().getWorkerpool();
            }
            return NonBlockingConnection.getDefaultWorkerpool();
        }

        @Override
        public void setWorkerpool(Executor workerpool) {
            if (this.isDetached) {
                return;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                holder.getConnection().setWorkerpool(workerpool);
            }
        }

        @Override
        public void setAttachment(Object obj) {
            this.attachment = obj;
        }

        @Override
        public Object getAttachment() {
            return this.attachment;
        }

        @Override
        public void setAutoflush(boolean autoflush) {
            if (this.isDetached) {
                return;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                holder.getConnection().setAutoflush(autoflush);
            }
        }

        @Override
        public boolean isAutoflush() {
            if (this.isDetached) {
                return true;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().isAutoflush();
            }
            return true;
        }

        @Override
        public void setEncoding(String defaultEncoding) {
            if (this.isDetached) {
                return;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                holder.getConnection().setEncoding(defaultEncoding);
            }
        }

        @Override
        public String getEncoding() {
            if (this.isDetached) {
                return "UTF-8";
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().getEncoding();
            }
            return "UTF-8";
        }

        @Override
        public void setFlushmode(IConnection.FlushMode flushMode) {
            if (this.isDetached) {
                return;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                holder.getConnection().setFlushmode(flushMode);
            }
        }

        @Override
        public IConnection.FlushMode getFlushmode() {
            if (this.isDetached) {
                return IConnection.DEFAULT_FLUSH_MODE;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().getFlushmode();
            }
            return IConnection.DEFAULT_FLUSH_MODE;
        }

        @Override
        public void setOption(String name, Object value) throws IOException {
            if (this.isDetached) {
                return;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                holder.getConnection().setOption(name, value);
            }
        }

        @Override
        public Object getOption(String name) throws IOException {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().getOption(name);
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public Map<String, Class> getOptions() {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().getOptions();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public void setWriteTransferRate(int bytesPerSecond) throws ClosedChannelException, IOException {
            if (this.isDetached) {
                return;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                holder.getConnection().setWriteTransferRate(bytesPerSecond);
            }
        }

        @Override
        public int getWriteTransferRate() throws ClosedChannelException, IOException {
            if (this.isDetached) {
                return Integer.MAX_VALUE;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().getWriteTransferRate();
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int getMaxReadBufferThreshold() {
            if (this.isDetached) {
                return Integer.MAX_VALUE;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().getMaxReadBufferThreshold();
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public void setMaxReadBufferThreshold(int size) {
            if (this.isDetached) {
                return;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                holder.getConnection().setMaxReadBufferThreshold(size);
            }
        }

        @Override
        public void setConnectionTimeoutMillis(long timeoutMillis) {
            if (this.isDetached) {
                return;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                holder.getConnection().setConnectionTimeoutMillis(timeoutMillis);
            }
        }

        @Override
        public long getConnectionTimeoutMillis() {
            if (this.isDetached) {
                return Long.MAX_VALUE;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().getConnectionTimeoutMillis();
            }
            return Long.MAX_VALUE;
        }

        @Override
        public void setIdleTimeoutMillis(long timeoutInMillis) {
            if (this.isDetached) {
                return;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelRuntimeException();
            }
            holder.getConnection().setIdleTimeoutMillis(timeoutInMillis);
            this.idleTimeoutOccured.set(false);
        }

        @Override
        public long getIdleTimeoutMillis() {
            if (this.isDetached) {
                return Long.MAX_VALUE;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().getIdleTimeoutMillis();
            }
            return Long.MAX_VALUE;
        }

        @Override
        public long getRemainingMillisToConnectionTimeout() {
            if (this.isDetached) {
                return Long.MAX_VALUE;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().getConnectionTimeoutMillis();
            }
            return Long.MAX_VALUE;
        }

        @Override
        public long getRemainingMillisToIdleTimeout() {
            if (this.isDetached) {
                return Long.MAX_VALUE;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().getRemainingMillisToIdleTimeout();
            }
            return Long.MAX_VALUE;
        }

        @Override
        public boolean isSecure() {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().isSecure();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public void activateSecuredMode() throws IOException {
            if (this.isDetached) {
                return;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                holder.getConnection().activateSecuredMode();
            }
        }

        @Override
        public boolean isSecuredModeActivateable() {
            if (this.isDetached) {
                return false;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().isSecuredModeActivateable();
            }
            return false;
        }

        @Override
        public void suspendReceiving() throws IOException {
            if (this.isDetached) {
                return;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                holder.getConnection().suspendRead();
            }
        }

        @Override
        public void suspendRead() throws IOException {
            this.suspendReceiving();
        }

        @Override
        public boolean isReceivingSuspended() {
            if (this.isDetached) {
                return false;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().isReadSuspended();
            }
            return false;
        }

        @Override
        public boolean isReadSuspended() {
            return this.isReceivingSuspended();
        }

        @Override
        public void resumeReceiving() throws IOException {
            if (this.isDetached) {
                return;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                holder.getConnection().resumeRead();
            }
        }

        @Override
        public void resumeRead() throws IOException {
            this.resumeReceiving();
        }

        @Override
        public InetAddress getLocalAddress() {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().getLocalAddress();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public int getLocalPort() {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().getLocalPort();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public InetAddress getRemoteAddress() {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().getRemoteAddress();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public int getRemotePort() {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().getRemotePort();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public int write(byte b) throws IOException, BufferOverflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().write(b);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public int write(byte ... bytes) throws IOException, BufferOverflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().write(bytes);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public void write(byte[] bytes, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelException();
            }
            holder.getConnection().write(bytes, writeCompletionHandler);
        }

        @Override
        public int write(byte[] bytes, int offset, int length) throws IOException, BufferOverflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().write(bytes, offset, length);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public void write(byte[] bytes, int offset, int length, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelException();
            }
            holder.getConnection().write(bytes, offset, length, writeCompletionHandler);
        }

        @Override
        public int write(ByteBuffer buffer) throws IOException, BufferOverflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().write(buffer);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public void write(ByteBuffer buffer, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelException();
            }
            holder.getConnection().write(buffer, writeCompletionHandler);
        }

        @Override
        public void write(ByteBuffer[] buffers, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelException();
            }
            holder.getConnection().write(buffers, writeCompletionHandler);
        }

        @Override
        public long write(ByteBuffer[] buffers) throws IOException, BufferOverflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().write(buffers);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().write(srcs, offset, length);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public void write(ByteBuffer[] srcs, int offset, int length, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelException();
            }
            holder.getConnection().write(srcs, offset, length, writeCompletionHandler);
        }

        @Override
        public int write(double d) throws IOException, BufferOverflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().write(d);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public int write(int i) throws IOException, BufferOverflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().write(i);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public long write(List<ByteBuffer> buffers) throws IOException, BufferOverflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().write(buffers);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public void write(List<ByteBuffer> buffers, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelException();
            }
            holder.getConnection().write(buffers, writeCompletionHandler);
        }

        @Override
        public int write(long l) throws IOException, BufferOverflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().write(l);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public int write(short s) throws IOException, BufferOverflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().write(s);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public int write(String message) throws IOException, BufferOverflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().write(message);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public int write(String message, String encoding) throws IOException, BufferOverflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().write(message, encoding);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public void write(String message, String encoding, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelException();
            }
            holder.getConnection().write(message, encoding, writeCompletionHandler);
        }

        @Override
        public void flush() throws ClosedChannelException, IOException, SocketTimeoutException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelException();
            }
            holder.getConnection().flush();
        }

        @Override
        public long transferFrom(FileChannel source) throws IOException, BufferOverflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().transferFrom(source);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public long transferFrom(ReadableByteChannel source) throws IOException, BufferOverflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().transferFrom(source);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public long transferFrom(ReadableByteChannel source, int chunkSize) throws IOException, BufferOverflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().transferFrom(source, chunkSize);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public int getPendingWriteDataSize() {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().getPendingWriteDataSize();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public void markWritePosition() {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelRuntimeException();
            }
            holder.getConnection().markWritePosition();
        }

        @Override
        public void removeWriteMark() {
            if (this.isDetached) {
                return;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                holder.getConnection().removeWriteMark();
            }
        }

        @Override
        public boolean resetToWriteMark() {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().resetToWriteMark();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public void markReadPosition() {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelRuntimeException();
            }
            holder.getConnection().markReadPosition();
        }

        @Override
        public void removeReadMark() {
            if (this.isDetached) {
                return;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                holder.getConnection().removeReadMark();
            }
        }

        @Override
        public boolean resetToReadMark() {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (this.isOpen && holder != null) {
                return holder.getConnection().resetToReadMark();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public int available() throws IOException {
            if (this.isDetached) {
                return -1;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().available();
            }
            return -1;
        }

        @Override
        public int getReadBufferVersion() throws IOException {
            if (this.isDetached) {
                return -1;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().getReadBufferVersion();
            }
            return -1;
        }

        @Override
        public int indexOf(String str) throws IOException {
            if (this.isDetached) {
                return -1;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().indexOf(str);
            }
            return -1;
        }

        @Override
        public int indexOf(String str, String encoding) throws IOException {
            if (this.isDetached) {
                return -1;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().indexOf(str, encoding);
            }
            return -1;
        }

        @Override
        public void unread(ByteBuffer[] buffers) throws IOException {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelRuntimeException();
            }
            holder.getConnection().unread(buffers);
        }

        @Override
        public void unread(byte[] bytes) throws IOException {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelRuntimeException();
            }
            holder.getConnection().unread(bytes);
        }

        @Override
        public void unread(ByteBuffer buffer) throws IOException {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelRuntimeException();
            }
            holder.getConnection().unread(buffer);
        }

        @Override
        public void unread(String text) throws IOException {
            if (this.isDetached) {
                throw this.newClosedChannelRuntimeException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelRuntimeException();
            }
            holder.getConnection().unread(text);
        }

        @Override
        public int read(ByteBuffer buffer) throws IOException {
            if (this.isDetached) {
                return -1;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().read(buffer);
            }
            return -1;
        }

        @Override
        public byte readByte() throws IOException, BufferUnderflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readByte();
            }
            throw this.newClosedChannelException();
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, BufferUnderflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readByteBufferByDelimiter(delimiter);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readByteBufferByDelimiter(delimiter, maxLength);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readByteBufferByDelimiter(delimiter, encoding);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readByteBufferByDelimiter(delimiter, encoding, maxLength);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public ByteBuffer[] readByteBufferByLength(int length) throws IOException, BufferUnderflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readByteBufferByLength(length);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter) throws IOException, BufferUnderflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readBytesByDelimiter(delimiter);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readBytesByDelimiter(delimiter, maxLength);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readBytesByDelimiter(delimiter, encoding);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readBytesByDelimiter(delimiter, encoding, maxLength);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public byte[] readBytesByLength(int length) throws IOException, BufferUnderflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readBytesByLength(length);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public double readDouble() throws IOException, BufferUnderflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readDouble();
            }
            throw this.newClosedChannelException();
        }

        @Override
        public int readInt() throws IOException, BufferUnderflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readInt();
            }
            throw this.newClosedChannelException();
        }

        @Override
        public long readLong() throws IOException, BufferUnderflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readLong();
            }
            throw this.newClosedChannelException();
        }

        @Override
        public short readShort() throws IOException, BufferUnderflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readShort();
            }
            throw this.newClosedChannelException();
        }

        @Override
        public String readStringByDelimiter(String delimiter) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readStringByDelimiter(delimiter);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readStringByDelimiter(delimiter, maxLength);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public String readStringByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readStringByDelimiter(delimiter, encoding);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readStringByDelimiter(delimiter, encoding, maxLength);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public String readStringByLength(int length) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readStringByLength(length);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public String readStringByLength(int length, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().readStringByLength(length, encoding);
            }
            throw this.newClosedChannelException();
        }

        @Override
        public long transferTo(WritableByteChannel target, int length) throws IOException, BufferUnderflowException {
            if (this.isDetached) {
                throw this.newClosedChannelException();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolder;
            if (holder != null) {
                return holder.getConnection().transferTo(target, length);
            }
            throw this.newClosedChannelException();
        }

        private ExtendedClosedChannelException newClosedChannelException() {
            return new ExtendedClosedChannelException("channel " + this.getId() + " is already closed");
        }

        private RuntimeException newClosedChannelRuntimeException() {
            return new RuntimeException("channel " + this.getId() + " is already closed");
        }
    }

    @Execution(value=0)
    private final class NativeConnectionHolder
    implements IDataHandler,
    IDisconnectHandler,
    IConnectionTimeoutHandler,
    IIdleTimeoutHandler {
        private final AtomicBoolean isClosed = new AtomicBoolean(false);
        private final AtomicBoolean isReusable = new AtomicBoolean(true);
        private final AtomicReference<NonBlockingConnectionProxy> connectionProxy = new AtomicReference<Object>(null);
        private NonBlockingConnection connection;
        private InetSocketAddress address;
        private boolean isSSL;
        private int usage = 0;
        private long creationTimeMillis = System.currentTimeMillis();
        private long lastUsageTimeMillis = System.currentTimeMillis();

        private NativeConnectionHolder() {
        }

        public void init(NonBlockingConnection connection) {
            this.connection = connection;
            this.isSSL = connection.isSecure();
            this.address = new InetSocketAddress(connection.getRemoteAddress(), connection.getRemotePort());
            NonBlockingConnectionPool.this.pool.register(this);
            NonBlockingConnectionPool.this.countCreated.incrementAndGet();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("pooled connection created (" + NonBlockingConnectionPool.this.pool.toString() + ", pooledIdleTimeoutMillis=" + NonBlockingConnectionPool.this.getPooledMaxIdleTimeMillis() + ", pooledLifeTimeout=" + NonBlockingConnectionPool.this.getPooledMaxLifeTimeMillis() + "): " + connection);
            }
        }

        String getId() {
            return this.connection.getId();
        }

        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            NonBlockingConnectionProxy cp = this.connectionProxy.get();
            if (cp != null) {
                try {
                    return cp.onData();
                }
                catch (MaxReadSizeExceededException mre) {
                    this.isReusable.set(false);
                    throw mre;
                }
                catch (IOException ioe) {
                    this.isReusable.set(false);
                    throw ioe;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            block5: {
                boolean bl;
                this.isReusable.set(false);
                try {
                    NonBlockingConnectionProxy cp = this.connectionProxy.get();
                    if (cp == null) break block5;
                    bl = cp.onDisconnect();
                    Object var5_5 = null;
                    NonBlockingConnectionPool.this.countDestroyed.incrementAndGet();
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var5_7 = null;
                        NonBlockingConnectionPool.this.countDestroyed.incrementAndGet();
                        NonBlockingConnectionPool.this.pool.remove(this);
                        if (!LOG.isLoggable(Level.FINE)) break block6;
                        LOG.fine("pooled connection (" + this.address.toString() + ") destroyed (" + NonBlockingConnectionPool.this.pool.toString() + ", idleTimeoutMillis=" + NonBlockingConnectionPool.this.getPooledMaxIdleTimeMillis() + ", lifeTimeout=" + NonBlockingConnectionPool.this.getPooledMaxLifeTimeMillis() + "): " + connection);
                    }
                    throw throwable;
                }
                NonBlockingConnectionPool.this.pool.remove(this);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("pooled connection (" + this.address.toString() + ") destroyed (" + NonBlockingConnectionPool.this.pool.toString() + ", idleTimeoutMillis=" + NonBlockingConnectionPool.this.getPooledMaxIdleTimeMillis() + ", lifeTimeout=" + NonBlockingConnectionPool.this.getPooledMaxLifeTimeMillis() + "): " + connection);
                }
                return bl;
            }
            boolean bl = true;
            Object var5_6 = null;
            NonBlockingConnectionPool.this.countDestroyed.incrementAndGet();
            NonBlockingConnectionPool.this.pool.remove(this);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("pooled connection (" + this.address.toString() + ") destroyed (" + NonBlockingConnectionPool.this.pool.toString() + ", idleTimeoutMillis=" + NonBlockingConnectionPool.this.getPooledMaxIdleTimeMillis() + ", lifeTimeout=" + NonBlockingConnectionPool.this.getPooledMaxLifeTimeMillis() + "): " + connection);
            }
            return bl;
        }

        public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
            NonBlockingConnectionProxy cp;
            this.isReusable.set(false);
            NonBlockingConnectionPool.this.countConnectionTimeout.incrementAndGet();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] connection timeout occured");
            }
            if ((cp = this.connectionProxy.get()) != null) {
                return cp.onConnectionTimeout();
            }
            return false;
        }

        public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
            NonBlockingConnectionProxy cp;
            this.isReusable.set(false);
            NonBlockingConnectionPool.this.countIdleTimeout.incrementAndGet();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] idle timeout (" + DataConverter.toFormatedDuration(this.getConnection().getIdleTimeoutMillis()) + ") occured");
            }
            if ((cp = this.connectionProxy.get()) != null) {
                return cp.onIdleTimeout();
            }
            return false;
        }

        int getUsage() {
            return this.usage;
        }

        long getCreationTimeMillis() {
            return this.creationTimeMillis;
        }

        long getLastUsageTimeMillis() {
            return this.lastUsageTimeMillis;
        }

        void setReusable(boolean reusable) {
            this.isReusable.set(reusable);
        }

        NonBlockingConnection getConnection() {
            return this.connection;
        }

        InetSocketAddress getAddress() {
            return this.address;
        }

        boolean isSecure() {
            return this.isSSL;
        }

        void lease(NonBlockingConnectionProxy proxy) {
            ++this.usage;
            this.lastUsageTimeMillis = System.currentTimeMillis();
            this.connectionProxy.set(proxy);
            if (proxy != null) {
                proxy.onConnect();
            }
        }

        void release() {
            NonBlockingConnectionProxy cp = this.connectionProxy.get();
            if (cp != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] connection will be released. calling onDisconnect");
                }
                cp.onDisconnect();
            }
            try {
                this.connection.getTaskQueue().performNonThreaded(new ReleaseTask(), NonBlockingConnectionPool.this.workerpool);
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] could not perform destroy task for " + this.connection.getId() + " Reason " + e.toString());
                }
                this.close();
            }
        }

        private void performRelease() {
            block10: {
                try {
                    this.lastUsageTimeMillis = System.currentTimeMillis();
                    if (!(this.connection.isConnected() && this.connection.isOpen() && NonBlockingConnectionPool.this.isOpen())) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + this.getId() + "] do not return pooled connection (" + this.address.toString() + ") into to pool, because the connection or pool is closed");
                        }
                        this.close();
                        return;
                    }
                    boolean isValid = this.isVaild(System.currentTimeMillis(), true);
                    if (isValid) {
                        if (NonBlockingConnectionPool.this.maxIdle.get() != Integer.MAX_VALUE || NonBlockingConnectionPool.this.pool.getNumIdle() >= NonBlockingConnectionPool.this.maxIdle.get()) {
                            return;
                        }
                        boolean isReset = this.connection.reset();
                        if (isReset) {
                            NonBlockingConnectionProxy cp = this.connectionProxy.get();
                            if (cp != null) {
                                cp.dettach();
                            }
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("[" + this.connection.getId() + "] releasing connection (for reuse)");
                            }
                            NonBlockingConnectionPool.this.returnToIdlePool(this);
                        } else {
                            this.close();
                        }
                    }
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block10;
                    LOG.fine("error occured by releasing a pooled connection (" + this.address.toString() + ") " + e.toString());
                }
            }
        }

        private boolean isVaild(long currentTimeMillis, boolean closeIfInvalid) {
            if (this.isClosed.get()) {
                return false;
            }
            if (!this.isReusable.get()) {
                if (closeIfInvalid) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] closing connection because it is marked as non reuseable");
                    }
                    this.close();
                }
                return false;
            }
            if (!this.connection.isConnected() || !this.connection.isOpen()) {
                if (closeIfInvalid) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] closing connection because it is disconnected or closed");
                    }
                    this.close();
                }
                return false;
            }
            if (this.connection.getRemainingMillisToIdleTimeout() < 3000L) {
                if (closeIfInvalid) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] closing connection because remaining time to idle timeout (" + this.connection.getRemainingMillisToIdleTimeout() + " millis) is to small");
                    }
                    NonBlockingConnectionPool.this.countRemainingMillisToIdleTimeoutToSmall.incrementAndGet();
                    this.close();
                }
                return false;
            }
            if (this.connection.getRemainingMillisToConnectionTimeout() < 3000L) {
                if (closeIfInvalid) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] closing connection because remaining time to connection timeout (" + this.connection.getRemainingMillisToConnectionTimeout() + " millis)  is to small");
                    }
                    NonBlockingConnectionPool.this.countRemainingConnectionToIdleTimeoutToSmall.incrementAndGet();
                    this.close();
                }
                return false;
            }
            if (NonBlockingConnectionPool.this.poolIdleTimeoutMillis.get() != Integer.MAX_VALUE && currentTimeMillis > this.lastUsageTimeMillis + (long)NonBlockingConnectionPool.this.poolIdleTimeoutMillis.get()) {
                if (closeIfInvalid) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.connection.getId() + "] connection (" + this.address + ") pool idle timeout reached (" + NonBlockingConnectionPool.this.poolIdleTimeoutMillis + ")");
                    }
                    NonBlockingConnectionPool.this.countTimeoutPooledIdle.incrementAndGet();
                    this.close();
                }
                return false;
            }
            if (NonBlockingConnectionPool.this.lifeTimeoutMillis.get() != Integer.MAX_VALUE && currentTimeMillis > this.creationTimeMillis + (long)NonBlockingConnectionPool.this.lifeTimeoutMillis.get()) {
                if (closeIfInvalid) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] connection (" + this.address + ") pool life timeout reached (" + NonBlockingConnectionPool.this.lifeTimeoutMillis + ")");
                    }
                    NonBlockingConnectionPool.this.countTimeoutPooledLifetime.incrementAndGet();
                    this.close();
                }
                return false;
            }
            return true;
        }

        void close() {
            block4: {
                if (!this.isClosed.getAndSet(true)) {
                    NonBlockingConnectionProxy cp = this.connectionProxy.get();
                    if (cp != null) {
                        cp.onDisconnect();
                    }
                    NonBlockingConnectionPool.this.pool.remove(this);
                    NonBlockingConnectionPool.this.wakeupPendingRetrieve();
                    try {
                        this.connection.close();
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block4;
                        LOG.fine("[" + this.getId() + "] error occured by closing connection (" + this.address.toString() + ") " + this.connection + ": " + e.toString());
                    }
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.connection.isReceivingSuspended()) {
                sb.append("[suspended] ");
            }
            sb.append(this.connection.getLocalAddress() + ":" + this.connection.getLocalPort() + " -> " + this.connection.getRemoteAddress() + ":" + this.connection.getRemotePort() + " " + "[" + this.connection.getId() + "]");
            SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
            sb.append(" creationTime=" + df.format(this.getCreationTimeMillis()) + ", lastUsageTime=" + df.format(this.getLastUsageTimeMillis()) + ", countUsage=" + this.getUsage() + ", isReusable=" + this.isReusable.get());
            return sb.toString();
        }

        private final class ReleaseTask
        implements Runnable {
            private ReleaseTask() {
            }

            public void run() {
                NativeConnectionHolder.this.performRelease();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Pool {
        private final ArrayList<NativeConnectionHolder> managedPool = new ArrayList();
        private final HashMap<InetSocketAddress, List<NativeConnectionHolder>> idlePool = new HashMap();
        private int numIdle = 0;
        private boolean isOpen = true;

        private Pool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(NativeConnectionHolder nativeConnectionHolder) {
            Pool pool = this;
            synchronized (pool) {
                if (this.isOpen) {
                    this.managedPool.add(nativeConnectionHolder);
                } else if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("ignore registering connection " + nativeConnectionHolder.toString() + " because pool is already closed");
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + nativeConnectionHolder.getId() + "] added to managed pool (active=" + this.getNumActive() + ", idle=" + this.getNumIdle() + ")");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(NativeConnectionHolder nativeConnectionHolder) {
            boolean isRemoved = false;
            Pool pool = this;
            synchronized (pool) {
                isRemoved = this.managedPool.remove(nativeConnectionHolder);
            }
            if (LOG.isLoggable(Level.FINE)) {
                if (isRemoved) {
                    LOG.fine("[" + nativeConnectionHolder.getId() + "] connection removed from managed pool (active=" + this.getNumActive() + ", idle=" + this.getNumIdle() + ")");
                } else {
                    LOG.fine("[" + nativeConnectionHolder.getId() + "] could not removed connection from managed pool. Connection already removed? (active=" + this.getNumActive() + ", idle=" + this.getNumIdle() + ")");
                }
            }
            return isRemoved;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeIdleConnection(NativeConnectionHolder connectionHolder) {
            Pool pool = this;
            synchronized (pool) {
                List<NativeConnectionHolder> idleList = this.idlePool.get(connectionHolder.getAddress());
                if (idleList != null) {
                    for (NativeConnectionHolder nativeConnectionHolder : idleList) {
                        if (nativeConnectionHolder != connectionHolder) continue;
                        boolean isRemoved = idleList.remove(nativeConnectionHolder);
                        if (idleList.isEmpty()) {
                            this.idlePool.remove(connectionHolder.getAddress());
                        }
                        if (isRemoved) {
                            --this.numIdle;
                            assert (this.numIdle == this.computeNumIdle()) : "numIdle delta occured";
                        }
                        return isRemoved;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NativeConnectionHolder getAndRemoveIdleConnection(InetSocketAddress address, boolean isSSL) {
            Pool pool = this;
            synchronized (pool) {
                List<NativeConnectionHolder> idleList = this.idlePool.get(address);
                if (idleList != null) {
                    for (NativeConnectionHolder nativeConnectionHolder : idleList) {
                        if (nativeConnectionHolder.isSSL != isSSL) continue;
                        idleList.remove(nativeConnectionHolder);
                        if (idleList.isEmpty()) {
                            this.idlePool.remove(address);
                        }
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + nativeConnectionHolder.getId() + "] got from idle pool (active=" + this.getNumActive() + ", idle=" + this.getNumIdle() + ")");
                        }
                        --this.numIdle;
                        assert (this.numIdle == this.computeNumIdle()) : "numIdle delta occured";
                        return nativeConnectionHolder;
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void returnIdleConnection(NativeConnectionHolder nativeConnectionHolder) {
            InetSocketAddress address = nativeConnectionHolder.getAddress();
            Pool pool = this;
            synchronized (pool) {
                List<NativeConnectionHolder> idleList = this.idlePool.get(address);
                if (idleList == null) {
                    idleList = new ArrayList<NativeConnectionHolder>();
                    this.idlePool.put(address, idleList);
                }
                idleList.add(nativeConnectionHolder);
                ++this.numIdle;
                assert (this.numIdle == this.computeNumIdle()) : "numIdle delta";
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + nativeConnectionHolder.getId() + "] added to idle pool (active=" + this.getNumActive() + ", idle=" + this.getNumIdle() + ")");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Pool pool = this;
            synchronized (pool) {
                if (!this.isOpen) {
                    return;
                }
                this.isOpen = false;
            }
            List<NativeConnectionHolder> idleSet = this.newIdleCopySet();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("closing " + idleSet.size() + " idle conection(s); " + this.managedPool.size() + " connection(s) stay open unmanaged");
            }
            for (NativeConnectionHolder nativeConnectionHolder : idleSet) {
                nativeConnectionHolder.close();
            }
            this.idlePool.clear();
            this.managedPool.clear();
            this.numIdle = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            Pool pool = this;
            synchronized (pool) {
                if (!this.isOpen) {
                    return;
                }
                this.isOpen = false;
            }
            List<NativeConnectionHolder> connections = this.newManagedPoolCopy();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("closing " + connections.size() + " managed connections");
            }
            for (NativeConnectionHolder nativeConnectionHolder : connections) {
                nativeConnectionHolder.close();
            }
            Pool pool2 = this;
            synchronized (pool2) {
                this.idlePool.clear();
                this.managedPool.clear();
                this.numIdle = 0;
            }
        }

        private List<NativeConnectionHolder> newIdleCopySet() {
            ArrayList<NativeConnectionHolder> idleList = new ArrayList<NativeConnectionHolder>();
            for (List<NativeConnectionHolder> nativeConnectionHolderList : this.newIdlePoolCopy().values()) {
                idleList.addAll(nativeConnectionHolderList);
            }
            return idleList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<NativeConnectionHolder> newManagedPoolCopy() {
            List managedPoolCopy = null;
            Pool pool = this;
            synchronized (pool) {
                managedPoolCopy = (List)this.managedPool.clone();
            }
            return managedPoolCopy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HashMap<InetSocketAddress, List<NativeConnectionHolder>> newIdlePoolCopy() {
            HashMap idlePoolCopy = null;
            Pool pool = this;
            synchronized (pool) {
                idlePoolCopy = (HashMap)this.idlePool.clone();
            }
            return idlePoolCopy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSize() {
            Pool pool = this;
            synchronized (pool) {
                return this.managedPool.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumIdle() {
            Pool pool = this;
            synchronized (pool) {
                return this.numIdle;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumActive() {
            Pool pool = this;
            synchronized (pool) {
                return this.managedPool.size() - this.numIdle;
            }
        }

        private int computeNumIdle() {
            int size = 0;
            for (List<NativeConnectionHolder> nativeConnectionHolderList : this.idlePool.values()) {
                size += nativeConnectionHolderList.size();
            }
            return size;
        }

        public String toString() {
            return "size=" + this.getSize() + ", active=" + this.getNumActive();
        }
    }

    private final class Watchog
    extends TimerTask {
        private Watchog() {
        }

        public void run() {
            block2: {
                try {
                    NonBlockingConnectionPool.this.checkIdleConnections();
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by checking connections " + t.toString());
                }
            }
        }
    }
}

