/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.connection.AbstractMemoryManager;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.IoSocketHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoSocketDispatcher
implements Runnable,
Closeable {
    private static final Logger LOG = Logger.getLogger(IoSocketDispatcher.class.getName());
    static final String DISPATCHER_PREFIX = "xDispatcher";
    private static final long TIMEOUT_SHUTDOWN_MILLIS = 5000L;
    private final ConcurrentLinkedQueue<Runnable> registerQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<IoSocketHandler> deregisterQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Runnable> keyUpdateQueue = new ConcurrentLinkedQueue();
    private static int nextId = 1;
    private final String name;
    private final int id;
    private static final ThreadLocal<Integer> THREADBOUND_ID = new ThreadLocal();
    private static final ThreadLocal<Integer> DIRECT_CALL_COUNTER = new ThreadLocal();
    private volatile boolean isOpen = true;
    private boolean isIdle = true;
    private Closer closer = new Closer();
    private final Selector selector;
    private final AbstractMemoryManager memoryManager;
    private static final Integer MAX_HANDLES = IoProvider.getMaxHandles();
    private TimerTask sizeUpdateTask;
    private int registeredHandles = 0;
    private long statisticsStartTime = System.currentTimeMillis();
    private long countIdleTimeouts = 0L;
    private long countConnectionTimeouts = 0L;
    private long handledRegistractions = 0L;
    private long handledReads = 0L;
    private long handledWrites = 0L;
    private long lastRequestReceiveRate = System.currentTimeMillis();
    private long lastRequestSendRate = System.currentTimeMillis();
    private long receivedBytes = 0L;
    private long sentBytes = 0L;
    private long countUnregisteredWrite = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoSocketDispatcher(AbstractMemoryManager memoryManager, String name) {
        this.memoryManager = memoryManager;
        this.name = DISPATCHER_PREFIX + name;
        IoSocketDispatcher ioSocketDispatcher = this;
        synchronized (ioSocketDispatcher) {
            this.id = nextId++;
        }
        if (MAX_HANDLES != null) {
            this.sizeUpdateTask = new TimerTask(){

                public void run() {
                    int registered = IoSocketDispatcher.this.selector.keys().size();
                    if (registered < IoSocketDispatcher.this.registeredHandles) {
                        IoSocketDispatcher.this.registeredHandles--;
                    }
                }
            };
            IoProvider.getTimer().schedule(this.sizeUpdateTask, 2000L, 2000L);
        }
        try {
            this.selector = Selector.open();
        }
        catch (IOException ioe) {
            String text = "exception occured while opening selector. Reason: " + ioe.toString();
            LOG.severe(text);
            throw new RuntimeException(text, ioe);
        }
    }

    String getName() {
        return this.name;
    }

    int getId() {
        return this.id;
    }

    boolean isIdling() {
        return this.isIdle;
    }

    private static Integer getThreadBoundId() {
        return THREADBOUND_ID.get();
    }

    long getCountUnregisteredWrite() {
        return this.countUnregisteredWrite;
    }

    Integer getHandlesMaxCount() {
        return MAX_HANDLES;
    }

    int getRegisteredHandles() {
        return this.registeredHandles;
    }

    @Override
    public void run() {
        block7: {
            Thread.currentThread().setName(this.name);
            THREADBOUND_ID.set(this.id);
            DIRECT_CALL_COUNTER.set(0);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("selector " + this.name + " listening ...");
            }
            int handledTasks = 0;
            while (this.isOpen) {
                try {
                    this.isIdle = true;
                    int eventCount = this.selector.select(1000L);
                    this.isIdle = false;
                    handledTasks = this.performRegisterHandlerTasks();
                    handledTasks += this.performKeyUpdateTasks();
                    if (eventCount > 0) {
                        this.handleReadWriteKeys();
                    }
                    handledTasks += this.performDeregisterHandlerTasks();
                }
                catch (Throwable e) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("[" + Thread.currentThread().getName() + "] exception occured while processing. Reason " + DataConverter.toString(e));
                }
            }
            try {
                this.selector.close();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.fine("error occured by close selector within tearDown " + DataConverter.toString(e));
            }
        }
    }

    private void handleReadWriteKeys() {
        Set<SelectionKey> selectedEventKeys = this.selector.selectedKeys();
        Iterator<SelectionKey> it = selectedEventKeys.iterator();
        while (it.hasNext()) {
            try {
                SelectionKey eventKey = it.next();
                it.remove();
                IoSocketHandler socketHandler = (IoSocketHandler)eventKey.attachment();
                try {
                    if (eventKey.isValid() && eventKey.isReadable()) {
                        this.onReadableEvent(socketHandler);
                    }
                    if (!eventKey.isValid() || !eventKey.isWritable()) continue;
                    this.onWriteableEvent(socketHandler);
                }
                catch (Exception e) {
                    socketHandler.close(e);
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("error occured by handling selection keys + " + e.toString());
            }
        }
    }

    private void onReadableEvent(IoSocketHandler socketHandler) {
        block3: {
            try {
                long read = socketHandler.onReadableEvent();
                this.receivedBytes += read;
                ++this.handledReads;
            }
            catch (ClosedChannelException ce) {
                socketHandler.closeSilence(false);
            }
            catch (Exception t) {
                socketHandler.closeSilence(false);
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.fine("[" + socketHandler.getId() + "] error occured by handling readable event. reason: " + t.toString());
            }
        }
    }

    private void onWriteableEvent(IoSocketHandler socketHandler) {
        try {
            socketHandler.onWriteableEvent();
            ++this.handledWrites;
        }
        catch (ClosedChannelException ce) {
            IOException ioe = ConnectionUtils.toIOException("error occured by handling readable event. reason closed channel exception " + ce.toString(), ce);
            socketHandler.close(ioe);
        }
        catch (Exception e2) {
            IOException e2 = ConnectionUtils.toIOException("error occured by handling readable event. reason " + e2.toString(), e2);
            socketHandler.close(e2);
        }
    }

    private void wakeUp() {
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean preRegister() {
        if (MAX_HANDLES == null) {
            return true;
        }
        IoSocketDispatcher ioSocketDispatcher = this;
        synchronized (ioSocketDispatcher) {
            if (this.registeredHandles < MAX_HANDLES) {
                ++this.registeredHandles;
                return true;
            }
        }
        return false;
    }

    public boolean register(IoSocketHandler socketHandler, int ops) throws IOException {
        assert (!socketHandler.getChannel().isBlocking());
        socketHandler.setMemoryManager(this.memoryManager);
        if (this.isDispatcherThread()) {
            this.registerHandlerNow(socketHandler, ops);
        } else {
            this.registerQueue.add(new RegisterTask(socketHandler, ops));
            this.wakeUp();
        }
        return true;
    }

    public void deregister(IoSocketHandler handler) {
        this.deregisterQueue.add(handler);
        this.wakeUp();
    }

    public void addKeyUpdateTask(Runnable task) {
        this.keyUpdateQueue.add(task);
        this.wakeUp();
    }

    public void flushKeyUpdate() {
        this.wakeUp();
    }

    public void suspendRead(IoSocketHandler socketHandler) throws IOException {
        this.addKeyUpdateTask(new UpdateReadSelectionKeyTask(socketHandler, false));
    }

    public void resumeRead(IoSocketHandler socketHandler) throws IOException {
        this.addKeyUpdateTask(new UpdateReadSelectionKeyTask(socketHandler, true));
    }

    private int performKeyUpdateTasks() {
        int handledTasks = 0;
        Runnable keyUpdateTask;
        while ((keyUpdateTask = this.keyUpdateQueue.poll()) != null) {
            keyUpdateTask.run();
            ++handledTasks;
        }
        return handledTasks;
    }

    public boolean isDispatcherThread() {
        Integer tbid = IoSocketDispatcher.getThreadBoundId();
        return tbid != null && tbid == this.id;
    }

    private SelectionKey getSelectionKey(IoSocketHandler socketHandler) {
        SelectionKey key = socketHandler.getChannel().keyFor(this.selector);
        if (LOG.isLoggable(Level.FINE)) {
            if (key == null) {
                LOG.info("[" + socketHandler.getId() + "] key is null");
            } else if (!key.isValid()) {
                LOG.info("[" + socketHandler.getId() + "] key is not valid");
            }
        }
        return key;
    }

    public boolean setWriteSelectionKeyNow(IoSocketHandler socketHandler) throws IOException {
        SelectionKey key;
        assert (this.isDispatcherThread());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + socketHandler.getId() + "] set write selecdtion key");
        }
        if (!this.isWriteable(key = this.getSelectionKey(socketHandler))) {
            key.interestOps(key.interestOps() | 4);
            return true;
        }
        return false;
    }

    public boolean unsetWriteSelectionKeyNow(IoSocketHandler socketHandler) throws IOException {
        assert (this.isDispatcherThread());
        SelectionKey key = this.getSelectionKey(socketHandler);
        if (this.isWriteable(key)) {
            key.interestOps(key.interestOps() & 0xFFFFFFFB);
            return true;
        }
        return false;
    }

    public boolean setReadSelectionKeyNow(IoSocketHandler socketHandler) throws IOException {
        assert (this.isDispatcherThread());
        SelectionKey key = this.getSelectionKey(socketHandler);
        if (!this.isReadable(key)) {
            key.interestOps(key.interestOps() | 1);
            return true;
        }
        return false;
    }

    private void unsetReadSelectionKeyNow(IoSocketHandler socketHandler) throws IOException {
        assert (this.isDispatcherThread());
        SelectionKey key = this.getSelectionKey(socketHandler);
        if (this.isReadable(key)) {
            key.interestOps(key.interestOps() & 0xFFFFFFFE);
        }
    }

    String getRegisteredOpsInfo(IoSocketHandler socketHandler) {
        SelectionKey key = this.getSelectionKey(socketHandler);
        if (key == null) {
            return "<not registered>";
        }
        return IoSocketDispatcher.printSelectionKeyValue(key.interestOps());
    }

    private int performRegisterHandlerTasks() throws IOException {
        int handledTasks = 0;
        Runnable registerTask;
        while ((registerTask = this.registerQueue.poll()) != null) {
            registerTask.run();
            ++handledTasks;
        }
        return handledTasks;
    }

    private void registerHandlerNow(IoSocketHandler socketHandler, int ops) throws IOException {
        if (socketHandler.isOpen()) {
            try {
                socketHandler.getChannel().register(this.selector, ops, socketHandler);
                socketHandler.onRegisteredEvent();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(socketHandler.getId() + " registered (ops=" + IoSocketDispatcher.printSelectionKeyValue(ops) + ")");
                }
                ++this.handledRegistractions;
            }
            catch (Exception e) {
                socketHandler.close(e);
            }
        } else {
            socketHandler.onRegisteredFailedEvent(new IOException("could not register handler " + socketHandler.getId() + " because the channel is closed"));
        }
    }

    private int performDeregisterHandlerTasks() {
        int handledTasks = 0;
        IoSocketHandler socketHandler;
        while ((socketHandler = this.deregisterQueue.poll()) != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("deregistering handler " + socketHandler.getId());
            }
            this.deregisterHandlerNow(socketHandler);
            ++handledTasks;
        }
        return handledTasks;
    }

    private void deregisterHandlerNow(IoSocketHandler socketHandler) {
        block3: {
            try {
                SelectionKey key = socketHandler.getChannel().keyFor(this.selector);
                if (key != null && key.isValid()) {
                    key.cancel();
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.fine("error occured by deregistering socket handler " + e.toString());
            }
        }
    }

    public Set<IoSocketHandler> getRegistered() {
        HashSet<IoSocketHandler> registered = new HashSet<IoSocketHandler>();
        Set<SelectionKey> keys = this.selector.keys();
        for (SelectionKey key : keys) {
            IoSocketHandler socketHandler = (IoSocketHandler)key.attachment();
            registered.add(socketHandler);
        }
        return registered;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    boolean isReadable(IoSocketHandler socketHandler) {
        SelectionKey key = this.getSelectionKey(socketHandler);
        return key != null && (key.interestOps() & 1) == 1;
    }

    private boolean isReadable(SelectionKey key) {
        return key != null && (key.interestOps() & 1) == 1;
    }

    private boolean isWriteable(SelectionKey key) {
        return key != null && (key.interestOps() & 4) == 4;
    }

    public long getNumberOfHandledRegistrations() {
        return this.handledRegistractions;
    }

    public long getNumberOfHandledReads() {
        return this.handledReads;
    }

    public long getNumberOfHandledWrites() {
        return this.handledWrites;
    }

    long getReceiveRateBytesPerSec() {
        long rate = 0L;
        long elapsed = System.currentTimeMillis() - this.lastRequestReceiveRate;
        rate = this.receivedBytes == 0L ? 0L : (elapsed == 0L ? Long.MAX_VALUE : this.receivedBytes * 1000L / elapsed);
        this.lastRequestReceiveRate = System.currentTimeMillis();
        this.receivedBytes = 0L;
        return rate;
    }

    long getSendRateBytesPerSec() {
        long rate = 0L;
        long elapsed = System.currentTimeMillis() - this.lastRequestSendRate;
        rate = this.sentBytes == 0L ? 0L : (elapsed == 0L ? Long.MAX_VALUE : this.sentBytes * 1000L / elapsed);
        this.lastRequestSendRate = System.currentTimeMillis();
        this.sentBytes = 0L;
        return rate;
    }

    long getCountIdleTimeout() {
        return this.countIdleTimeouts;
    }

    long getCountConnectionTimeout() {
        return this.countConnectionTimeouts;
    }

    public int getPreallocatedReadMemorySize() {
        return this.memoryManager.getCurrentSizePreallocatedBuffer();
    }

    boolean getReceiveBufferPreallocationMode() {
        return this.memoryManager.isPreallocationMode();
    }

    void setReceiveBufferPreallocationMode(boolean mode) {
        this.memoryManager.setPreallocationMode(mode);
    }

    void setReceiveBufferPreallocatedMinSize(Integer minSize) {
        this.memoryManager.setPreallocatedMinBufferSize(minSize);
    }

    Integer getReceiveBufferPreallocatedMinSize() {
        if (this.memoryManager.isPreallocationMode()) {
            return this.memoryManager.getPreallocatedMinBufferSize();
        }
        return null;
    }

    Integer getReceiveBufferPreallocatedSize() {
        if (this.memoryManager.isPreallocationMode()) {
            return this.memoryManager.getPreallocationBufferSize();
        }
        return null;
    }

    void setReceiveBufferPreallocatedSize(Integer size) {
        this.memoryManager.setPreallocationBufferSize(size);
    }

    boolean getReceiveBufferIsDirect() {
        return this.memoryManager.isDirect();
    }

    void setReceiveBufferIsDirect(boolean isDirect) {
        this.memoryManager.setDirect(isDirect);
    }

    public void resetStatistics() {
        this.statisticsStartTime = System.currentTimeMillis();
        this.handledRegistractions = 0L;
        this.handledReads = 0L;
        this.handledWrites = 0L;
    }

    public String toString() {
        return "open channels  " + this.getRegistered().size();
    }

    protected long getStatisticsStartTime() {
        return this.statisticsStartTime;
    }

    String printSelectionKey(IoSocketHandler socketHandler) {
        SelectionKey key = socketHandler.getChannel().keyFor(this.selector);
        if (key != null) {
            try {
                int i = key.interestOps();
                return IoSocketDispatcher.printSelectionKeyValue(i) + " isValid=" + key.isValid();
            }
            catch (CancelledKeyException cke) {
                return "canceled";
            }
        }
        return "<null>";
    }

    static String printSelectionKeyValue(int ops) {
        StringBuilder sb = new StringBuilder();
        if ((ops & 0x10) == 16) {
            sb.append("OP_ACCEPT, ");
        }
        if ((ops & 8) == 8) {
            sb.append("OP_CONNECT, ");
        }
        if ((ops & 4) == 4) {
            sb.append("OP_WRITE, ");
        }
        if ((ops & 1) == 1) {
            sb.append("OP_READ, ");
        }
        String txt = sb.toString();
        if ((txt = txt.trim()).length() > 0) {
            txt = txt.substring(0, txt.length() - 1);
        }
        return txt + " (" + ops + ")";
    }

    @Override
    public void close() throws IOException {
        if (this.selector != null) {
            if (this.sizeUpdateTask != null) {
                this.sizeUpdateTask.cancel();
            }
            if (this.closer != null) {
                new Thread(this.closer).start();
                this.closer = null;
            }
        }
    }

    private class Closer
    implements Runnable {
        private Closer() {
        }

        public void run() {
            Thread.currentThread().setName("xDispatcherCloser");
            long start = System.currentTimeMillis();
            while (IoSocketDispatcher.this.getRegistered().size() > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                if (System.currentTimeMillis() <= start + 5000L) continue;
                LOG.warning("shutdown timeout reached (" + DataConverter.toFormatedDuration(5000L) + "). kill pending connections");
                Set<SelectionKey> keys = IoSocketDispatcher.this.selector.keys();
                HashSet<SelectionKey> keysCopy = new HashSet<SelectionKey>();
                keysCopy.addAll(keys);
                for (SelectionKey sk : keysCopy) {
                    try {
                        sk.channel().close();
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("error occured by closing channel " + ioe.toString());
                    }
                }
            }
            IoSocketDispatcher.this.isOpen = false;
            IoSocketDispatcher.this.selector.wakeup();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("dispatcher " + this.hashCode() + " has been closed (shutdown time = " + DataConverter.toFormatedDuration(System.currentTimeMillis() - start) + ")");
            }
        }
    }

    private final class UpdateReadSelectionKeyTask
    implements Runnable {
        private final IoSocketHandler socketHandler;
        private final boolean isSet;

        public UpdateReadSelectionKeyTask(IoSocketHandler socketHandler, boolean isSet) {
            this.socketHandler = socketHandler;
            this.isSet = isSet;
        }

        public void run() {
            assert (IoSocketDispatcher.this.isDispatcherThread());
            try {
                if (this.isSet) {
                    IoSocketDispatcher.this.setReadSelectionKeyNow(this.socketHandler);
                } else {
                    IoSocketDispatcher.this.unsetReadSelectionKeyNow(this.socketHandler);
                }
            }
            catch (Exception e2) {
                IOException e2 = ConnectionUtils.toIOException("Error by set read selection key now " + e2.toString(), e2);
                this.socketHandler.close(e2);
            }
        }

        public String toString() {
            return "setReadSelectionKeyTask#" + super.toString();
        }
    }

    private final class RegisterTask
    implements Runnable {
        private final IoSocketHandler socketHandler;
        private final int ops;

        public RegisterTask(IoSocketHandler socketHandler, int ops) {
            this.socketHandler = socketHandler;
            this.ops = ops;
        }

        public void run() {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("registering handler " + this.socketHandler.getId());
            }
            try {
                IoSocketDispatcher.this.registerHandlerNow(this.socketHandler, this.ops);
            }
            catch (IOException ioe) {
                ioe = ConnectionUtils.toIOException("error occured by registering handler " + this.socketHandler.getId() + " " + ioe.toString(), ioe);
                this.socketHandler.close(ioe);
            }
        }
    }
}

