/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.SerializedTaskQueue;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IConnectExceptionHandler;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnectionScoped;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;

class HandlerAdapter {
    private static final Logger LOG = Logger.getLogger(HandlerAdapter.class.getName());
    private static final IHandler NULL_HANDLER = new NullHandler();
    private static final ConnectionUtils.HandlerInfo NULL_HANDLER_INFO = ConnectionUtils.getHandlerInfo(NULL_HANDLER);
    private final IHandler handler;
    private final ConnectionUtils.HandlerInfo handlerInfo;

    HandlerAdapter(IHandler handler, ConnectionUtils.HandlerInfo handlerInfo) {
        this.handler = handler;
        this.handlerInfo = handlerInfo;
    }

    static HandlerAdapter newInstance(IHandler handler) {
        if (handler == null) {
            return new HandlerAdapter(NULL_HANDLER, NULL_HANDLER_INFO);
        }
        ConnectionUtils.HandlerInfo handlerInfo = ConnectionUtils.getHandlerInfo(handler);
        return new HandlerAdapter(handler, handlerInfo);
    }

    final IHandler getHandler() {
        return this.handler;
    }

    final ConnectionUtils.HandlerInfo getHandlerInfo() {
        return this.handlerInfo;
    }

    public boolean onConnect(final INonBlockingConnection connection, final SerializedTaskQueue taskQueue) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.handlerInfo.isConnectHandler()) {
            if (this.handlerInfo.isHandlerUnsynchronized()) {
                this.performOnConnect(connection, taskQueue);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                HandlerAdapter.this.performOnConnect(connection, taskQueue);
                            }
                            catch (IOException ioe) {
                                if (!LOG.isLoggable(Level.FINE)) break block2;
                                LOG.fine("error occured while performing onConnect multithreaded " + HandlerAdapter.this.getHandler() + " " + ioe.toString());
                            }
                        }
                    }
                };
                if (this.getHandlerInfo().isConnectHandlerMultithreaded()) {
                    taskQueue.performMultiThreaded(task, connection.getWorkerpool());
                } else {
                    taskQueue.performNonThreaded(task, connection.getWorkerpool());
                }
            }
        }
        return true;
    }

    private boolean performOnConnect(INonBlockingConnection connection, SerializedTaskQueue taskQueue) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        try {
            ((IConnectHandler)this.handler).onConnect(connection);
        }
        catch (MaxReadSizeExceededException mee) {
            this.closeSilence(connection);
        }
        catch (BufferUnderflowException bue) {
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnect by appHandler. " + this.handler + " Reason: " + re.toString());
            }
            this.closeSilence(connection);
            throw re;
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnect by appHandler. " + this.handler + " Reason: " + ioe.toString());
            }
            this.closeSilence(connection);
            throw ioe;
        }
        return false;
    }

    public boolean onData(final INonBlockingConnection connection, final SerializedTaskQueue taskQueue) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.handlerInfo.isDataHandler()) {
            if (this.handlerInfo.isHandlerUnsynchronized()) {
                this.performOnData(connection, taskQueue);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                HandlerAdapter.this.performOnData(connection, taskQueue);
                            }
                            catch (IOException ioe) {
                                if (!LOG.isLoggable(Level.FINE)) break block2;
                                LOG.fine("error occured while performing onData multithreaded " + HandlerAdapter.this.getHandler() + " " + ioe.toString());
                            }
                        }
                    }
                };
                if (this.getHandlerInfo().isDataHandlerMultithreaded()) {
                    taskQueue.performMultiThreaded(task, connection.getWorkerpool());
                } else {
                    taskQueue.performNonThreaded(task, connection.getWorkerpool());
                }
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("assigned handler " + this.handler.getClass().getName() + " is not a data handler");
        }
        return true;
    }

    private boolean performOnData(INonBlockingConnection connection, SerializedTaskQueue taskQueue) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        while (connection.available() != 0 && !connection.isReceivingSuspended()) {
            if (connection.getHandler() != this.handler) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("handler " + this.handler.getClass().getName() + " replaced by " + connection.getHandler().getClass().getName() + ". stop handling data for old handler");
                }
                return true;
            }
            int version = connection.getReadBufferVersion();
            try {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.fine("calling onData method of handler " + this.handler);
                }
                ((IDataHandler)this.handler).onData(connection);
                if (version != connection.getReadBufferVersion()) continue;
                return true;
            }
            catch (MaxReadSizeExceededException mee) {
                this.closeSilence(connection);
                return true;
            }
            catch (BufferUnderflowException bue) {
                return true;
            }
            catch (RuntimeException re) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling data by appHandler. " + this.handler + " Reason: " + re.toString());
                }
                this.closeSilence(connection);
                throw re;
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling data by appHandler. " + this.handler + " Reason: " + ioe.toString());
                }
                this.closeSilence(connection);
                throw ioe;
            }
        }
        return false;
    }

    public boolean onDisconnect(final INonBlockingConnection connection, final SerializedTaskQueue taskQueue) throws IOException {
        if (this.handlerInfo.isDisconnectHandler()) {
            if (this.handlerInfo.isHandlerUnsynchronized()) {
                this.performOnDisconnect(connection, taskQueue);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                HandlerAdapter.this.performOnDisconnect(connection, taskQueue);
                            }
                            catch (IOException ioe) {
                                if (!LOG.isLoggable(Level.FINE)) break block2;
                                LOG.fine("error occured while performing onDisconnect multithreaded " + HandlerAdapter.this.getHandler() + " " + ioe.toString());
                            }
                        }
                    }
                };
                if (this.getHandlerInfo().isDisconnectHandlerMultithreaded()) {
                    taskQueue.performMultiThreaded(task, connection.getWorkerpool());
                } else {
                    taskQueue.performNonThreaded(task, connection.getWorkerpool());
                }
            }
        }
        return true;
    }

    private boolean performOnDisconnect(INonBlockingConnection connection, SerializedTaskQueue taskQueue) throws IOException {
        try {
            return ((IDisconnectHandler)this.handler).onDisconnect(connection);
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onDisconnect by appHandler. " + this.handler + " Reason: " + re.toString());
            }
            this.closeSilence(connection);
            throw re;
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onDisconnect by appHandler. " + this.handler + " Reason: " + ioe.toString());
            }
            this.closeSilence(connection);
            throw ioe;
        }
    }

    public boolean onConnectException(final INonBlockingConnection connection, final SerializedTaskQueue taskQueue, final IOException ioe) throws IOException {
        if (this.handlerInfo.isConnectExceptionHandler()) {
            if (this.handlerInfo.isHandlerUnsynchronized()) {
                this.performOnConnectException(connection, taskQueue, ioe);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                HandlerAdapter.this.performOnConnectException(connection, taskQueue, ioe);
                            }
                            catch (IOException e) {
                                if (!LOG.isLoggable(Level.FINE)) break block2;
                                LOG.fine("error occured while performing onDisconnect multithreaded " + HandlerAdapter.this.getHandler() + " " + e.toString());
                            }
                        }
                    }
                };
                if (this.getHandlerInfo().isConnectExceptionHandlerMultithreaded()) {
                    taskQueue.performMultiThreaded(task, connection.getWorkerpool());
                } else {
                    taskQueue.performNonThreaded(task, connection.getWorkerpool());
                }
            }
        }
        return true;
    }

    private boolean performOnConnectException(INonBlockingConnection connection, SerializedTaskQueue taskQueue, IOException ioe) throws IOException {
        try {
            return ((IConnectExceptionHandler)this.handler).onConnectException(connection, ioe);
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onDisconnect by appHandler. " + this.handler + " Reason: " + re.toString());
            }
            this.closeSilence(connection);
            throw re;
        }
        catch (IOException e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onDisconnect by appHandler. " + this.handler + " Reason: " + ioe.toString());
            }
            this.closeSilence(connection);
            throw ioe;
        }
    }

    public boolean onIdleTimeout(final INonBlockingConnection connection, final SerializedTaskQueue taskQueue) throws IOException {
        if (this.handlerInfo.isIdleTimeoutHandler()) {
            if (this.handlerInfo.isHandlerUnsynchronized()) {
                this.performOnIdleTimeout(connection, taskQueue);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                HandlerAdapter.this.performOnIdleTimeout(connection, taskQueue);
                            }
                            catch (IOException ioe) {
                                if (!LOG.isLoggable(Level.FINE)) break block2;
                                LOG.fine("error occured while performing onIdleTimeout multithreaded " + HandlerAdapter.this.getHandler() + " " + ioe.toString());
                            }
                        }
                    }
                };
                if (this.getHandlerInfo().isIdleTimeoutHandlerMultithreaded()) {
                    taskQueue.performMultiThreaded(task, connection.getWorkerpool());
                } else {
                    taskQueue.performNonThreaded(task, connection.getWorkerpool());
                }
            }
        } else {
            this.closeSilence(connection);
        }
        return true;
    }

    private boolean performOnIdleTimeout(INonBlockingConnection connection, SerializedTaskQueue taskQueue) throws IOException {
        try {
            boolean isHandled = ((IIdleTimeoutHandler)this.handler).onIdleTimeout(connection);
            if (!isHandled) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because idle timeout has been occured and timeout handler returns true)");
                }
                this.closeSilence(connection);
            }
            return isHandled;
        }
        catch (MaxReadSizeExceededException mee) {
            this.closeSilence(connection);
        }
        catch (BufferUnderflowException bue) {
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onIdleTimeout by appHandler. " + this.handler + " Reason: " + re.toString());
            }
            this.closeSilence(connection);
            throw re;
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onIdleTimeout by appHandler. " + this.handler + " Reason: " + ioe.toString());
            }
            this.closeSilence(connection);
            throw ioe;
        }
        return true;
    }

    public boolean onConnectionTimeout(final INonBlockingConnection connection, final SerializedTaskQueue taskQueue) throws IOException {
        if (this.handlerInfo.isConnectionTimeoutHandler()) {
            if (this.handlerInfo.isHandlerUnsynchronized()) {
                this.performOnConnectionTimeout(connection, taskQueue);
            } else {
                Runnable task = new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                HandlerAdapter.this.performOnConnectionTimeout(connection, taskQueue);
                            }
                            catch (IOException ioe) {
                                if (!LOG.isLoggable(Level.FINE)) break block2;
                                LOG.fine("error occured while performing onConnectionTimeout multithreaded " + HandlerAdapter.this.getHandler() + " " + ioe.toString());
                            }
                        }
                    }
                };
                if (this.getHandlerInfo().isConnectionTimeoutHandlerMultithreaded()) {
                    taskQueue.performMultiThreaded(task, connection.getWorkerpool());
                } else {
                    taskQueue.performNonThreaded(task, connection.getWorkerpool());
                }
            }
        } else {
            this.closeSilence(connection);
        }
        return true;
    }

    private boolean performOnConnectionTimeout(INonBlockingConnection connection, SerializedTaskQueue taskQueue) throws IOException {
        try {
            boolean isHandled = ((IConnectionTimeoutHandler)this.handler).onConnectionTimeout(connection);
            if (!isHandled) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because connection timeout has been occured and timeout handler returns true)");
                }
                this.closeSilence(connection);
            }
        }
        catch (MaxReadSizeExceededException mee) {
            this.closeSilence(connection);
        }
        catch (BufferUnderflowException bue) {
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnectionTimeout by appHandler. " + this.handler + " Reason: " + re.toString());
            }
            this.closeSilence(connection);
            throw re;
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnectionTimeout by appHandler. " + this.handler + " Reason: " + ioe.toString());
            }
            this.closeSilence(connection);
            throw ioe;
        }
        return true;
    }

    public final void onInit() {
        if (this.handlerInfo.isLifeCycle()) {
            ((ILifeCycle)((Object)this.handler)).onInit();
        }
    }

    public final void onDestroy() {
        block3: {
            if (this.handlerInfo.isLifeCycle()) {
                try {
                    ((ILifeCycle)((Object)this.handler)).onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("exception occured by destroying " + this.handler + " " + ioe.toString());
                }
            }
        }
    }

    HandlerAdapter getConnectionInstance() {
        if (this.handlerInfo.isConnectionScoped()) {
            try {
                IHandler hdlCopy = (IHandler)((IConnectionScoped)((Object)this.handler)).clone();
                return new HandlerAdapter(hdlCopy, this.handlerInfo);
            }
            catch (CloneNotSupportedException cnse) {
                throw new RuntimeException(cnse.toString());
            }
        }
        return this;
    }

    private void closeSilence(INonBlockingConnection connection) {
        block2: {
            try {
                connection.close();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by closing connection " + connection + " " + e.toString());
            }
        }
    }

    @Execution(value=0)
    private static final class NullHandler
    implements IHandler {
        private NullHandler() {
        }
    }
}

