/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IIoAcceptorCallback;
import org.xsocket.connection.IoChainableHandler;
import org.xsocket.connection.IoSocketDispatcher;
import org.xsocket.connection.IoSocketDispatcherPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoAcceptor {
    private static final Logger LOG = Logger.getLogger(IoAcceptor.class.getName());
    private static final String SO_RCVBUF = "SOL_SOCKET.SO_RCVBUF";
    private static final String SO_REUSEADDR = "SOL_SOCKET.SO_REUSEADDR";
    private static final Map<String, Class> SUPPORTED_OPTIONS = new HashMap<String, Class>();
    private IIoAcceptorCallback callback;
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private final ServerSocketChannel serverChannel;
    private final boolean sslOn;
    private final SSLContext sslContext;
    private final IoSocketDispatcherPool disptacherPool;
    private final AtomicBoolean isAccepting = new AtomicBoolean(true);
    private long acceptedConnections;
    private long lastRequestAccpetedRate = System.currentTimeMillis();

    public IoAcceptor(IIoAcceptorCallback callback, InetSocketAddress address, int backlog) throws IOException {
        this(callback, address, backlog, null, false);
    }

    public IoAcceptor(IIoAcceptorCallback callback, InetSocketAddress address, int backlog, SSLContext sslContext, boolean sslOn) throws IOException {
        this.callback = callback;
        this.sslContext = sslContext;
        this.sslOn = sslOn;
        LOG.fine("try to bind server on " + address);
        this.serverChannel = ServerSocketChannel.open();
        assert (this.serverChannel != null);
        this.serverChannel.configureBlocking(true);
        this.serverChannel.socket().setSoTimeout(0);
        this.serverChannel.socket().setReuseAddress(true);
        try {
            this.serverChannel.socket().bind(address, backlog);
            this.disptacherPool = new IoSocketDispatcherPool("Srv" + this.getLocalPort());
        }
        catch (BindException be) {
            this.serverChannel.close();
            LOG.info("could not bind server to " + address + ". Reason: " + be.toString());
            throw be;
        }
    }

    void setOption(String name, Object value) throws IOException {
        if (name.equals(SO_RCVBUF)) {
            this.serverChannel.socket().setReceiveBufferSize((Integer)value);
        } else if (name.equals(SO_REUSEADDR)) {
            this.serverChannel.socket().setReuseAddress((Boolean)value);
        } else {
            LOG.warning("option " + name + " is not supproted for " + this.getClass().getName());
        }
    }

    public Object getOption(String name) throws IOException {
        if (name.equals(SO_RCVBUF)) {
            return this.serverChannel.socket().getReceiveBufferSize();
        }
        if (name.equals(SO_REUSEADDR)) {
            return this.serverChannel.socket().getReuseAddress();
        }
        LOG.warning("option " + name + " is not supproted for " + this.getClass().getName());
        return null;
    }

    public Map<String, Class> getOptions() {
        return Collections.unmodifiableMap(SUPPORTED_OPTIONS);
    }

    IoSocketDispatcherPool getDispatcherPool() {
        return this.disptacherPool;
    }

    public InetAddress getLocalAddress() {
        return this.serverChannel.socket().getInetAddress();
    }

    public int getLocalPort() {
        return this.serverChannel.socket().getLocalPort();
    }

    public void listen() throws IOException {
        this.callback.onConnected();
        this.accept();
    }

    private void accept() {
        while (this.isOpen.get()) {
            block6: {
                try {
                    SocketChannel channel = this.serverChannel.accept();
                    IoSocketDispatcher dispatcher = this.disptacherPool.nextDispatcher(0);
                    IoChainableHandler ioHandler = ConnectionUtils.getIoProvider().createIoHandler(false, dispatcher, channel, this.sslContext, this.sslOn);
                    this.callback.onConnectionAccepted(ioHandler);
                    ++this.acceptedConnections;
                }
                catch (Exception e) {
                    if (!this.serverChannel.isOpen()) break block6;
                    LOG.warning("error occured while accepting connection: " + e.toString());
                }
            }
            while (!this.isAccepting.get()) {
                if (!this.isOpen.get()) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void close() throws IOException {
        if (this.isOpen.get()) {
            block4: {
                this.isOpen.set(false);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("closing acceptor");
                }
                try {
                    this.serverChannel.close();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block4;
                    LOG.fine("error occured by closing " + e.toString());
                }
            }
            this.disptacherPool.close();
            this.callback.onDisconnected();
            this.callback = null;
        }
    }

    void setDispatcherSize(int size) {
        this.disptacherPool.setDispatcherSize(size);
    }

    int getDispatcherSize() {
        return this.disptacherPool.getDispatcherSize();
    }

    boolean getReceiveBufferIsDirect() {
        return this.disptacherPool.getReceiveBufferIsDirect();
    }

    void setReceiveBufferIsDirect(boolean isDirect) {
        this.disptacherPool.setReceiveBufferIsDirect(isDirect);
    }

    boolean isReceiveBufferPreallocationMode() {
        return this.disptacherPool.isReceiveBufferPreallocationMode();
    }

    void setReceiveBufferPreallocationMode(boolean mode) {
        this.disptacherPool.setReceiveBufferPreallocationMode(mode);
    }

    void setReceiveBufferPreallocatedMinSize(Integer minSize) {
        this.disptacherPool.setReceiveBufferPreallocatedMinSize(minSize);
    }

    Integer getReceiveBufferPreallocatedMinSize() {
        return this.disptacherPool.getReceiveBufferPreallocatedMinSize();
    }

    Integer getReceiveBufferPreallocationSize() {
        return this.disptacherPool.getReceiveBufferPreallocationSize();
    }

    void setReceiveBufferPreallocationSize(int size) {
        this.disptacherPool.setReceiveBufferPreallocationSize(size);
    }

    void setAccepting(boolean b) {
        this.isAccepting.set(b);
    }

    double getAcceptedRateCountPerSec() {
        double rate = 0.0;
        long elapsed = System.currentTimeMillis() - this.lastRequestAccpetedRate;
        rate = this.acceptedConnections == 0L ? 0.0 : (elapsed == 0L ? 2.147483647E9 : (double)(this.acceptedConnections * 1000L) / (double)elapsed);
        this.lastRequestAccpetedRate = System.currentTimeMillis();
        this.acceptedConnections = 0L;
        return rate;
    }

    long getSendRateBytesPerSec() {
        return this.disptacherPool.getSendRateBytesPerSec();
    }

    long getReceiveRateBytesPerSec() {
        return this.disptacherPool.getReceiveRateBytesPerSec();
    }

    static {
        SUPPORTED_OPTIONS.put(SO_RCVBUF, Integer.class);
        SUPPORTED_OPTIONS.put(SO_REUSEADDR, Boolean.class);
    }
}

