/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.SerializedTaskQueue;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IConnectExceptionHandler;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnectionScoped;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IHandlerInfo;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.NonBlockingConnection;

class HandlerAdapter {
    private static final Logger LOG = Logger.getLogger(HandlerAdapter.class.getName());
    private static final IHandler NULL_HANDLER = new NullHandler();
    private static final HandlerAdapter NULL_HANDLER_ADAPTER = new HandlerAdapter(NULL_HANDLER, ConnectionUtils.getHandlerInfo(NULL_HANDLER));
    private final IHandler handler;
    private final IHandlerInfo handlerInfo;

    HandlerAdapter(IHandler handler, IHandlerInfo handlerInfo) {
        this.handler = handler;
        this.handlerInfo = handlerInfo;
    }

    static HandlerAdapter newInstance(IHandler handler) {
        if (handler == null) {
            return NULL_HANDLER_ADAPTER;
        }
        IHandlerInfo handlerInfo = ConnectionUtils.getHandlerInfo(handler);
        return new HandlerAdapter(handler, handlerInfo);
    }

    final IHandler getHandler() {
        return this.handler;
    }

    final IHandlerInfo getHandlerInfo() {
        return this.handlerInfo;
    }

    private String printHandler() {
        return this.handler.getClass().getName() + "#" + this.handler.hashCode();
    }

    public boolean onConnect(INonBlockingConnection connection, SerializedTaskQueue taskQueue) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.handlerInfo.isConnectHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnConnect(connection, taskQueue);
            } else if (this.getHandlerInfo().isConnectHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnConnectTask(connection, taskQueue), connection.getWorkerpool());
            } else {
                taskQueue.performNonThreaded(new PerformOnConnectTask(connection, taskQueue), connection.getWorkerpool());
            }
        }
        return true;
    }

    private boolean performOnConnect(INonBlockingConnection connection, SerializedTaskQueue taskQueue) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        try {
            ((IConnectHandler)this.handler).onConnect(connection);
        }
        catch (MaxReadSizeExceededException mee) {
            this.closeSilence(connection);
        }
        catch (BufferUnderflowException bue) {
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnect by appHandler. " + this.printHandler() + " Reason: " + re.toString());
            }
            this.closeSilence(connection);
            throw re;
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnect by appHandler. " + this.printHandler() + " Reason: " + ioe.toString());
            }
            this.closeSilence(connection);
            throw ioe;
        }
        return false;
    }

    public boolean onData(INonBlockingConnection connection, SerializedTaskQueue taskQueue, boolean ignoreException, boolean isUnsynchronized) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.handlerInfo.isDataHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnData(connection, taskQueue, ignoreException);
            } else if (this.getHandlerInfo().isDataHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnDataTask(connection, taskQueue, ignoreException), connection.getWorkerpool());
            } else if (isUnsynchronized) {
                this.performOnData(connection, taskQueue, ignoreException);
            } else {
                taskQueue.performNonThreaded(new PerformOnDataTask(connection, taskQueue, ignoreException), connection.getWorkerpool());
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + connection.getId() + "] assigned handler " + this.printHandler() + " is not a data handler");
        }
        return true;
    }

    private boolean performOnData(INonBlockingConnection connection, SerializedTaskQueue taskQueue, boolean ignoreException) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        while (connection.available() != 0 && !connection.isReceivingSuspended()) {
            if (connection.getHandler() != this.handler) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] handler " + " replaced by " + connection.getHandler() + ". stop handling data for old handler");
                }
                return true;
            }
            int version = connection.getReadBufferVersion();
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] calling onData method of handler " + this.printHandler());
                }
                ((IDataHandler)this.handler).onData(connection);
                if (version != connection.getReadBufferVersion()) continue;
                return true;
            }
            catch (MaxReadSizeExceededException mee) {
                if (!ignoreException) {
                    this.closeSilence(connection);
                }
                return true;
            }
            catch (BufferUnderflowException bue) {
                return true;
            }
            catch (RuntimeException re) {
                if (!ignoreException) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + connection.getId() + "] ERROR closing connection because an error has been occured by handling data by appHandler. " + this.printHandler() + " Reason: " + DataConverter.toString(re));
                    }
                    this.closeSilence(connection);
                }
                throw re;
            }
            catch (IOException ioe) {
                if (!ignoreException) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling data by appHandler. " + this.printHandler() + " Reason: " + DataConverter.toString(ioe));
                    }
                    this.closeSilence(connection);
                }
                throw ioe;
            }
        }
        return false;
    }

    public boolean onDisconnect(INonBlockingConnection connection, SerializedTaskQueue taskQueue, boolean isUnsynchronized) throws IOException {
        if (this.handlerInfo.isDisconnectHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnDisconnect(connection, taskQueue);
            } else if (this.getHandlerInfo().isDisconnectHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnDisconnectTask(connection, taskQueue), connection.getWorkerpool());
            } else if (isUnsynchronized) {
                this.performOnDisconnect(connection, taskQueue);
            } else {
                taskQueue.performNonThreaded(new PerformOnDisconnectTask(connection, taskQueue), connection.getWorkerpool());
            }
        }
        return true;
    }

    private boolean performOnDisconnect(INonBlockingConnection connection, SerializedTaskQueue taskQueue) throws IOException {
        try {
            return ((IDisconnectHandler)this.handler).onDisconnect(connection);
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onDisconnect by appHandler. " + this.printHandler() + " Reason: " + re.toString());
            }
            this.closeSilence(connection);
            throw re;
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onDisconnect by appHandler. " + this.printHandler() + " Reason: " + ioe.toString());
            }
            this.closeSilence(connection);
            throw ioe;
        }
    }

    public boolean onConnectException(INonBlockingConnection connection, SerializedTaskQueue taskQueue, IOException ioe) throws IOException {
        if (this.handlerInfo.isConnectExceptionHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnConnectException(connection, taskQueue, ioe);
            } else if (this.getHandlerInfo().isConnectExceptionHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnConnectExceptionTask(connection, taskQueue, ioe), connection.getWorkerpool());
            } else {
                taskQueue.performNonThreaded(new PerformOnConnectExceptionTask(connection, taskQueue, ioe), connection.getWorkerpool());
            }
        }
        return true;
    }

    private boolean performOnConnectException(INonBlockingConnection connection, SerializedTaskQueue taskQueue, IOException ioe) throws IOException {
        try {
            return ((IConnectExceptionHandler)this.handler).onConnectException(connection, ioe);
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onDisconnect by appHandler. " + this.printHandler() + " Reason: " + re.toString());
            }
            this.closeSilence(connection);
            throw re;
        }
        catch (IOException e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onDisconnect by appHandler. " + this.printHandler() + " Reason: " + ioe.toString());
            }
            this.closeSilence(connection);
            throw ioe;
        }
    }

    public boolean onIdleTimeout(INonBlockingConnection connection, SerializedTaskQueue taskQueue) throws IOException {
        if (this.handlerInfo.isIdleTimeoutHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnIdleTimeout(connection, taskQueue);
            } else if (this.getHandlerInfo().isIdleTimeoutHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnIdleTimeoutTask(connection, taskQueue), connection.getWorkerpool());
            } else {
                taskQueue.performNonThreaded(new PerformOnIdleTimeoutTask(connection, taskQueue), connection.getWorkerpool());
            }
        } else {
            this.closeSilence(connection);
        }
        return true;
    }

    private boolean performOnIdleTimeout(INonBlockingConnection connection, SerializedTaskQueue taskQueue) throws IOException {
        try {
            boolean isHandled = ((IIdleTimeoutHandler)this.handler).onIdleTimeout(connection);
            if (!isHandled) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because idle timeout has been occured and timeout handler returns true)");
                }
                this.closeSilence(connection);
            }
            return isHandled;
        }
        catch (MaxReadSizeExceededException mee) {
            this.closeSilence(connection);
        }
        catch (BufferUnderflowException bue) {
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onIdleTimeout by appHandler. " + this.printHandler() + " Reason: " + re.toString());
            }
            this.closeSilence(connection);
            throw re;
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onIdleTimeout by appHandler. " + this.handler + " Reason: " + ioe.toString());
            }
            this.closeSilence(connection);
            throw ioe;
        }
        return true;
    }

    public boolean onConnectionTimeout(INonBlockingConnection connection, SerializedTaskQueue taskQueue) throws IOException {
        if (this.handlerInfo.isConnectionTimeoutHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                this.performOnConnectionTimeout(connection, taskQueue);
            } else if (this.getHandlerInfo().isConnectionTimeoutHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnConnectionTimeoutTask(connection, taskQueue), connection.getWorkerpool());
            } else {
                taskQueue.performNonThreaded(new PerformOnConnectionTimeoutTask(connection, taskQueue), connection.getWorkerpool());
            }
        } else {
            this.closeSilence(connection);
        }
        return true;
    }

    private boolean performOnConnectionTimeout(INonBlockingConnection connection, SerializedTaskQueue taskQueue) throws IOException {
        try {
            boolean isHandled = ((IConnectionTimeoutHandler)this.handler).onConnectionTimeout(connection);
            if (!isHandled) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because connection timeout has been occured and timeout handler returns true)");
                }
                this.closeSilence(connection);
            }
        }
        catch (MaxReadSizeExceededException mee) {
            this.closeSilence(connection);
        }
        catch (BufferUnderflowException bue) {
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnectionTimeout by appHandler. " + this.printHandler() + " Reason: " + re.toString());
            }
            this.closeSilence(connection);
            throw re;
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnectionTimeout by appHandler. " + this.handler + " Reason: " + ioe.toString());
            }
            this.closeSilence(connection);
            throw ioe;
        }
        return true;
    }

    public final void onInit() {
        if (this.handlerInfo.isLifeCycle()) {
            ((ILifeCycle)((Object)this.handler)).onInit();
        }
    }

    public final void onDestroy() {
        block3: {
            if (this.handlerInfo.isLifeCycle()) {
                try {
                    ((ILifeCycle)((Object)this.handler)).onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("exception occured by destroying " + this.printHandler() + " " + ioe.toString());
                }
            }
        }
    }

    HandlerAdapter getConnectionInstance() {
        if (this.handlerInfo.isConnectionScoped()) {
            try {
                IHandler hdlCopy = (IHandler)((IConnectionScoped)((Object)this.handler)).clone();
                return new HandlerAdapter(hdlCopy, this.handlerInfo);
            }
            catch (CloneNotSupportedException cnse) {
                throw new RuntimeException(cnse.toString());
            }
        }
        return this;
    }

    private void closeSilence(INonBlockingConnection connection) {
        block2: {
            try {
                connection.close();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by closing connection " + connection + " " + e.toString());
            }
        }
    }

    @Execution(value=0)
    private static final class NullHandler
    implements IHandler {
        private NullHandler() {
        }
    }

    private final class PerformOnConnectionTimeoutTask
    implements Runnable {
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;

        public PerformOnConnectionTimeoutTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue) {
            this.connection = connection;
            this.taskQueue = taskQueue;
        }

        public void run() {
            try {
                HandlerAdapter.this.performOnConnectionTimeout(this.connection, this.taskQueue);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.connection.getId() + "] closing connection. An IO exception occured while performing onConnectionTimeout multithreaded " + HandlerAdapter.this.printHandler() + " " + ioe.toString());
                }
                HandlerAdapter.this.closeSilence(this.connection);
            }
            catch (RuntimeException rt) {
                LOG.warning("[" + this.connection.getId() + "] runtime exception occured while performing onConnectionTimeout multithreaded " + HandlerAdapter.this.printHandler() + " " + rt.toString());
            }
            catch (Error t) {
                LOG.warning("[" + this.connection.getId() + "] closing connection. Error occured by performing onConnectionTimeout of " + HandlerAdapter.this.printHandler() + " " + t.toString());
                NonBlockingConnection.closeSilence(this.connection);
            }
        }
    }

    private final class PerformOnIdleTimeoutTask
    implements Runnable {
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;

        public PerformOnIdleTimeoutTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue) {
            this.connection = connection;
            this.taskQueue = taskQueue;
        }

        public void run() {
            try {
                HandlerAdapter.this.performOnIdleTimeout(this.connection, this.taskQueue);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.connection.getId() + "] closing connection. An IO exception occured while performing onIdleTimeout multithreaded " + HandlerAdapter.this.printHandler() + " " + ioe.toString());
                }
                HandlerAdapter.this.closeSilence(this.connection);
            }
            catch (RuntimeException rt) {
                LOG.warning("[" + this.connection.getId() + "] runtime exception occured while performing onIdletimeout multithreaded " + HandlerAdapter.this.printHandler() + " " + rt.toString());
            }
            catch (Error t) {
                LOG.warning("[" + this.connection.getId() + "] closing connection. Error occured by performing onIdleTimeout of " + HandlerAdapter.this.printHandler() + " " + t.toString());
                NonBlockingConnection.closeSilence(this.connection);
            }
        }
    }

    private final class PerformOnConnectExceptionTask
    implements Runnable {
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;
        private final IOException ioe;

        public PerformOnConnectExceptionTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue, IOException ioe) {
            this.connection = connection;
            this.taskQueue = taskQueue;
            this.ioe = ioe;
        }

        public void run() {
            try {
                HandlerAdapter.this.performOnConnectException(this.connection, this.taskQueue, this.ioe);
            }
            catch (IOException e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.connection.getId() + "] io exception occured while performing onConnectException multithreaded " + HandlerAdapter.this.printHandler() + " " + e.toString());
                }
            }
            catch (RuntimeException rt) {
                LOG.warning("[" + this.connection.getId() + "] runtime exception occured while performing onConnectException multithreaded " + HandlerAdapter.this.printHandler() + " " + rt.toString());
            }
            catch (Error t) {
                LOG.warning("[" + this.connection.getId() + "] closing connection. Error occured by performing onConnectionException of " + HandlerAdapter.this.printHandler() + " " + t.toString());
                NonBlockingConnection.closeSilence(this.connection);
            }
        }
    }

    private final class PerformOnDisconnectTask
    implements Runnable {
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;

        public PerformOnDisconnectTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue) {
            this.connection = connection;
            this.taskQueue = taskQueue;
        }

        public void run() {
            try {
                HandlerAdapter.this.performOnDisconnect(this.connection, this.taskQueue);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.connection.getId() + "] io exception occured while performing onDisconnect multithreaded " + HandlerAdapter.this.printHandler() + " " + ioe.toString());
                }
            }
            catch (RuntimeException rt) {
                LOG.warning("[" + this.connection.getId() + "] runtime exception occured while performing onDisconnect multithreaded " + HandlerAdapter.this.printHandler() + " " + rt.toString());
            }
            catch (Error t) {
                LOG.warning("[" + this.connection.getId() + "] Error occured by performing onDisconnect off " + HandlerAdapter.this.printHandler() + " " + t.toString());
            }
        }

        public String toString() {
            return "PerformOnDisconnectTask#" + this.hashCode() + " " + this.connection.getId();
        }
    }

    private final class PerformOnDataTask
    implements Runnable {
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;
        private final boolean ignoreException;

        public PerformOnDataTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue, boolean ignoreException) {
            this.connection = connection;
            this.taskQueue = taskQueue;
            this.ignoreException = ignoreException;
        }

        public void run() {
            try {
                HandlerAdapter.this.performOnData(this.connection, this.taskQueue, this.ignoreException);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.connection.getId() + "] closing connection. An IO exception occured while performing onData multithreaded " + HandlerAdapter.this.printHandler() + " " + ioe.toString());
                }
                NonBlockingConnection.closeSilence(this.connection);
            }
            catch (RuntimeException rt) {
                LOG.warning("[" + this.connection.getId() + "] runtime exception occured while performing onData multithreaded " + HandlerAdapter.this.printHandler() + " " + rt.toString());
            }
            catch (Error t) {
                LOG.warning("[" + this.connection.getId() + "] closing connection. Error occured by performing onData of " + HandlerAdapter.this.printHandler() + " " + t.toString());
                NonBlockingConnection.closeSilence(this.connection);
            }
        }

        public String toString() {
            return "PerformOnDataTask#" + this.hashCode() + " " + this.connection.getId();
        }
    }

    private final class PerformOnConnectTask
    implements Runnable {
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;

        public PerformOnConnectTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue) {
            this.connection = connection;
            this.taskQueue = taskQueue;
        }

        public void run() {
            try {
                HandlerAdapter.this.performOnConnect(this.connection, this.taskQueue);
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.connection.getId() + "] closing connection. An IO exception error occured while performing onConnect multithreaded " + HandlerAdapter.this.printHandler() + " " + ioe.toString());
                }
                HandlerAdapter.this.closeSilence(this.connection);
            }
            catch (RuntimeException rt) {
                LOG.warning("[" + this.connection.getId() + "] runtime exception occured while performing onConnectt multithreaded " + HandlerAdapter.this.printHandler() + " " + rt.toString());
            }
            catch (Error t) {
                LOG.warning("[" + this.connection.getId() + "] closing connection. Error occured by performing onConnect of " + HandlerAdapter.this.printHandler() + " " + t.toString());
                NonBlockingConnection.closeSilence(this.connection);
            }
        }
    }
}

