/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.Resource;
import org.xsocket.connection.ConnectionPoolMBeanProxyFactory;
import org.xsocket.connection.HandlerChain;
import org.xsocket.connection.IBlockingConnection;
import org.xsocket.connection.IConnectExceptionHandler;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnectionPool;
import org.xsocket.connection.IConnectionScoped;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IHandlerInfo;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IServer;
import org.xsocket.connection.IServerListener;
import org.xsocket.connection.IWriteCompletionHandler;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.Server;
import org.xsocket.connection.ServerMBeanProxyFactory;
import org.xsocket.connection.SynchronizedBlockingConnection;
import org.xsocket.connection.SynchronizedNonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionUtils {
    private static final Logger LOG = Logger.getLogger(ConnectionUtils.class.getName());
    public static final String DEFAULT_DOMAIN = "org.xsocket.connection";
    public static final String SERVER_TRHREAD_PREFIX = "xServer";
    private static final IoProvider IO_PROVIDER = new IoProvider();
    private static final Map<Class, HandlerInfo> handlerInfoCache = ConnectionUtils.newMapCache(25);
    private static final Map<Class, CompletionHandlerInfo> completionHandlerInfoCache = ConnectionUtils.newMapCache(25);
    private static String implementationVersion;
    private static String implementationDate;

    private ConnectionUtils() {
    }

    static IoProvider getIoProvider() {
        return IO_PROVIDER;
    }

    public static int validateSufficientDatasizeByIntLengthField(INonBlockingConnection connection) throws IOException, BufferUnderflowException {
        connection.resetToReadMark();
        connection.markReadPosition();
        int length = connection.readInt();
        if (connection.available() < length) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "]insufficient data. require " + length + " got " + connection.available());
            }
            throw new BufferUnderflowException();
        }
        connection.removeReadMark();
        return length;
    }

    public static int validateSufficientDatasizeByIntLengthField(INonBlockingConnection connection, boolean removeLengthField) throws IOException, BufferUnderflowException {
        connection.resetToReadMark();
        connection.markReadPosition();
        int length = connection.readInt();
        if (connection.available() < length) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "]insufficient data. require " + length + " got " + connection.available());
            }
            throw new BufferUnderflowException();
        }
        if (!removeLengthField) {
            connection.resetToReadMark();
        }
        connection.removeReadMark();
        return length;
    }

    public static void start(IServer server) throws SocketTimeoutException {
        ConnectionUtils.start(server, 60);
    }

    public static void start(IServer server, int timeoutSec) throws SocketTimeoutException {
        final CountDownLatch startedSignal = new CountDownLatch(1);
        IServerListener startupListener = new IServerListener(){

            public void onInit() {
                startedSignal.countDown();
            }

            public void onDestroy() {
            }
        };
        server.addListener(startupListener);
        Thread t = new Thread(server);
        t.setName(SERVER_TRHREAD_PREFIX);
        t.start();
        boolean isStarted = false;
        try {
            isStarted = startedSignal.await(timeoutSec, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("start signal doesn't occured. " + e.toString());
        }
        if (!isStarted) {
            throw new SocketTimeoutException("start timeout (" + DataConverter.toFormatedDuration((long)timeoutSec * 1000L) + ")");
        }
        t.setName("xServer:" + server.getLocalPort());
        server.removeListener(startupListener);
    }

    public static ByteBuffer[] copy(ByteBuffer[] buffers) {
        if (buffers == null) {
            return null;
        }
        ByteBuffer[] copy = new ByteBuffer[buffers.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = ConnectionUtils.copy(buffers[i]);
        }
        return copy;
    }

    public static INonBlockingConnection synchronizedConnection(INonBlockingConnection con) {
        if (con instanceof SynchronizedNonBlockingConnection) {
            return con;
        }
        return new SynchronizedNonBlockingConnection(con);
    }

    public static IBlockingConnection synchronizedConnection(IBlockingConnection con) {
        if (con instanceof SynchronizedBlockingConnection) {
            return con;
        }
        return new SynchronizedBlockingConnection(con);
    }

    static ByteBuffer[] duplicate(ByteBuffer[] buffers) {
        if (buffers == null) {
            return null;
        }
        ByteBuffer[] copy = new ByteBuffer[buffers.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = ConnectionUtils.duplicate(buffers[i]);
        }
        return copy;
    }

    static ByteBuffer duplicate(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return buffer.duplicate();
    }

    static ByteBuffer copy(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return ByteBuffer.wrap(DataConverter.toBytes(buffer));
    }

    public static ObjectName registerMBean(IServer server) throws JMException {
        return ConnectionUtils.registerMBean(server, DEFAULT_DOMAIN);
    }

    public static ObjectName registerMBean(IServer server, String domain) throws JMException {
        return ConnectionUtils.registerMBean(server, domain, ManagementFactory.getPlatformMBeanServer());
    }

    public static ObjectName registerMBean(IServer server, String domain, MBeanServer mbeanServer) {
        try {
            return ServerMBeanProxyFactory.createAndRegister(server, domain, mbeanServer);
        }
        catch (Exception e) {
            throw new RuntimeException(DataConverter.toString(e));
        }
    }

    public static ObjectName registerMBean(IConnectionPool pool) throws JMException {
        return ConnectionUtils.registerMBean(pool, DEFAULT_DOMAIN);
    }

    public static ObjectName registerMBean(IConnectionPool pool, String domain) throws JMException {
        return ConnectionUtils.registerMBean(pool, domain, ManagementFactory.getPlatformMBeanServer());
    }

    public static ObjectName registerMBean(IConnectionPool pool, String domain, MBeanServer mbeanServer) throws JMException {
        return ConnectionPoolMBeanProxyFactory.createAndRegister(pool, domain, mbeanServer);
    }

    public static boolean matchVersion(String currentVersion, String requiredVersion) {
        try {
            requiredVersion = requiredVersion.trim();
            currentVersion = currentVersion.split("-")[0].trim();
            if (requiredVersion.indexOf(",") == -1) {
                requiredVersion = requiredVersion.split("-")[0].trim();
                return currentVersion.equalsIgnoreCase(requiredVersion);
            }
            String[] range = requiredVersion.split(",");
            for (int i = 0; i < range.length; ++i) {
                range[i] = range[i].trim();
            }
            if (range.length < 2) {
                return false;
            }
            String requiredMinVersion = range[0].substring(1, range[0].length()).trim();
            requiredMinVersion = requiredMinVersion.split("-")[0];
            String requiredMaxVersion = range[1].substring(0, range[1].length() - 1).trim();
            requiredMaxVersion = requiredMaxVersion.split("-")[0];
            if (range[0].startsWith("[") && !currentVersion.equalsIgnoreCase(requiredMinVersion) && !ConnectionUtils.isGreater(currentVersion, requiredMinVersion)) {
                return false;
            }
            if (range[1].endsWith(")")) {
                return ConnectionUtils.isSmaller(currentVersion, requiredMaxVersion);
            }
            if (range[1].endsWith("]")) {
                return currentVersion.equalsIgnoreCase(requiredMaxVersion) || ConnectionUtils.isSmaller(currentVersion, requiredMaxVersion);
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isGreater(String version, String required) {
        String[] numsVersion = version.split("\\.");
        String[] numsRequired = required.split("\\.");
        for (int i = 0; i < numsVersion.length; ++i) {
            int numVersion = Integer.parseInt(numsVersion[i]);
            if (numsRequired.length <= i) {
                return true;
            }
            int numRequired = Integer.parseInt(numsRequired[i]);
            if (numVersion <= numRequired) continue;
            return true;
        }
        return false;
    }

    private static boolean isSmaller(String version, String required) {
        String[] numsVersion = version.split("\\.");
        String[] numsRequired = required.split("\\.");
        for (int i = 0; i < numsVersion.length; ++i) {
            int numVersion = Integer.parseInt(numsVersion[i]);
            if (numsRequired.length < i) {
                return true;
            }
            int numRequired = Integer.parseInt(numsRequired[i]);
            if (numVersion >= numRequired) continue;
            return true;
        }
        return false;
    }

    public static String getVersionInfo() {
        return ConnectionUtils.getImplementationVersion();
    }

    static IOException toIOException(Throwable t) {
        return ConnectionUtils.toIOException(t.getMessage(), t);
    }

    static IOException toIOException(String text, Throwable t) {
        IOException ioe = new IOException(text);
        ioe.setStackTrace(t.getStackTrace());
        return ioe;
    }

    public static String getImplementationVersion() {
        if (implementationVersion == null) {
            ConnectionUtils.readVersionFile();
        }
        return implementationVersion;
    }

    public static String getImplementationDate() {
        if (implementationDate == null) {
            ConnectionUtils.readVersionFile();
        }
        return implementationDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readVersionFile() {
        implementationVersion = "<unknown>";
        implementationDate = "<unknown>";
        InputStreamReader isr = null;
        BufferedReader lnr = null;
        try {
            isr = new InputStreamReader(ConnectionUtils.class.getResourceAsStream("/org/xsocket/version.txt"));
            if (isr != null) {
                lnr = new LineNumberReader(isr);
                String line = null;
                do {
                    if ((line = ((LineNumberReader)lnr).readLine()) == null) continue;
                    if (line.startsWith("Implementation-Version=")) {
                        implementationVersion = line.substring("Implementation-Version=".length(), line.length()).trim();
                        continue;
                    }
                    if (!line.startsWith("Implementation-Date=")) continue;
                    implementationDate = line.substring("Implementation-Date=".length(), line.length()).trim();
                } while (line != null);
                lnr.close();
            }
        }
        catch (IOException ioe) {
            implementationVersion = "<unknown>";
            implementationDate = "<unknown>";
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("could not read version file. reason: " + ioe.toString());
            }
        }
        finally {
            block18: {
                try {
                    if (lnr != null) {
                        lnr.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block18;
                    LOG.fine("exception occured by closing version.txt file stream " + ioe.toString());
                }
            }
        }
    }

    static long computeSize(ByteBuffer[] buffers) {
        long size = 0L;
        for (ByteBuffer byteBuffer : buffers) {
            size += (long)byteBuffer.remaining();
        }
        return size;
    }

    public static <T> Map<Class, T> newMapCache(int maxSize) {
        return Collections.synchronizedMap(new MapCache(maxSize));
    }

    static void injectServerField(Server server, Object handler) {
        Field[] fields;
        for (Field field : fields = handler.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Resource.class)) continue;
            Resource res = field.getAnnotation(Resource.class);
            if (field.getType() != IServer.class && res.type() != IServer.class && field.getType() != Server.class && res.type() != Server.class) continue;
            try {
                field.setAccessible(true);
                field.set(handler, server);
            }
            catch (IllegalAccessException iae) {
                LOG.warning("could not inject server for attribute " + field.getName() + ". Reason " + iae.toString());
            }
        }
    }

    public static boolean isDispatcherThread() {
        return Thread.currentThread().getName().startsWith("xDispatcher");
    }

    static boolean isConnectorThread() {
        return Thread.currentThread().getName().startsWith("xConnector");
    }

    static String printSelectionKey(SelectionKey key) {
        if (key != null) {
            try {
                int i = key.interestOps();
                return ConnectionUtils.printSelectionKeyValue(i) + " isValid=" + key.isValid();
            }
            catch (CancelledKeyException cke) {
                return "canceled";
            }
        }
        return "<null>";
    }

    static String printSelectionKeyValue(int ops) {
        StringBuilder sb = new StringBuilder();
        if ((ops & 0x10) == 16) {
            sb.append("OP_ACCEPT, ");
        }
        if ((ops & 8) == 8) {
            sb.append("OP_CONNECT, ");
        }
        if ((ops & 4) == 4) {
            sb.append("OP_WRITE, ");
        }
        if ((ops & 1) == 1) {
            sb.append("OP_READ, ");
        }
        String txt = sb.toString();
        if ((txt = txt.trim()).length() > 0) {
            txt = txt.substring(0, txt.length() - 1);
        }
        return txt + " (" + ops + ")";
    }

    static IHandlerInfo getHandlerInfo(IHandler handler) {
        if (handler instanceof HandlerChain) {
            return ((HandlerChain)handler).getHandlerInfo();
        }
        HandlerInfo handlerInfo = handlerInfoCache.get(handler.getClass());
        if (handlerInfo == null) {
            handlerInfo = new HandlerInfo(handler);
            handlerInfoCache.put(handler.getClass(), handlerInfo);
        }
        return handlerInfo;
    }

    static CompletionHandlerInfo getCompletionHandlerInfo(IWriteCompletionHandler handler) {
        CompletionHandlerInfo completionHandlerInfo = completionHandlerInfoCache.get(handler.getClass());
        if (completionHandlerInfo == null) {
            completionHandlerInfo = new CompletionHandlerInfo(handler);
            completionHandlerInfoCache.put(handler.getClass(), completionHandlerInfo);
        }
        return completionHandlerInfo;
    }

    private static boolean isMethodThreaded(Class clazz, String methodname, boolean dflt, Class ... paramClass) {
        try {
            Method meth = clazz.getMethod(methodname, paramClass);
            Execution execution = meth.getAnnotation(Execution.class);
            if (execution != null) {
                return execution.value() != 0;
            }
            return dflt;
        }
        catch (NoSuchMethodException nsme) {
            return dflt;
        }
    }

    private static boolean isHandlerMultithreaded(Object handler) {
        Execution execution = handler.getClass().getAnnotation(Execution.class);
        if (execution != null) {
            return execution.value() != 0;
        }
        return true;
    }

    static final class CompletionHandlerInfo {
        private boolean isOnWrittenMultithreaded = false;
        private boolean isOnExceptionMultithreaded = false;

        public CompletionHandlerInfo(IWriteCompletionHandler handler) {
            boolean isHandlerMultithreaded = ConnectionUtils.isHandlerMultithreaded(handler);
            this.isOnWrittenMultithreaded = ConnectionUtils.isMethodThreaded(handler.getClass(), "onWritten", isHandlerMultithreaded, new Class[]{Integer.TYPE});
            this.isOnExceptionMultithreaded = ConnectionUtils.isMethodThreaded(handler.getClass(), "onException", isHandlerMultithreaded, new Class[]{IOException.class});
        }

        public boolean isOnWrittenMultithreaded() {
            return this.isOnWrittenMultithreaded;
        }

        public boolean isOnExceptionMutlithreaded() {
            return this.isOnExceptionMultithreaded;
        }
    }

    private static final class HandlerInfo
    implements IHandlerInfo {
        private boolean isConnectHandler = false;
        private boolean isDataHandler = false;
        private boolean isDisconnectHandler = false;
        private boolean isIdleTimeoutHandler = false;
        private boolean isConnectionTimeoutHandler = false;
        private boolean isConnectExceptionHandler = false;
        private boolean isLifeCycle = false;
        private boolean isConnectionScoped = false;
        private boolean isHandlerMultithreaded = false;
        private boolean isConnectHandlerMultithreaded = false;
        private boolean isDataHandlerMultithreaded = false;
        private boolean isDisconnectHandlerMultithreaded = false;
        private boolean isIdleTimeoutHandlerMultithreaded = false;
        private boolean isConnectionTimeoutHandlerMultithreaded = false;
        private boolean isConnectExceptionHandlerMultithreaded = false;
        private boolean isUnsynchrnoized = false;

        HandlerInfo(IHandler handler) {
            this.isConnectHandler = handler instanceof IConnectHandler;
            this.isDataHandler = handler instanceof IDataHandler;
            this.isDisconnectHandler = handler instanceof IDisconnectHandler;
            this.isIdleTimeoutHandler = handler instanceof IIdleTimeoutHandler;
            this.isConnectionTimeoutHandler = handler instanceof IConnectionTimeoutHandler;
            this.isConnectExceptionHandler = handler instanceof IConnectExceptionHandler;
            this.isLifeCycle = handler instanceof ILifeCycle;
            this.isConnectionScoped = handler instanceof IConnectionScoped;
            this.isHandlerMultithreaded = ConnectionUtils.isHandlerMultithreaded(handler);
            if (this.isConnectHandler) {
                this.isConnectHandlerMultithreaded = ConnectionUtils.isMethodThreaded(handler.getClass(), "onConnect", this.isHandlerMultithreaded, new Class[]{INonBlockingConnection.class});
            }
            if (this.isDataHandler) {
                this.isDataHandlerMultithreaded = ConnectionUtils.isMethodThreaded(handler.getClass(), "onData", this.isHandlerMultithreaded, new Class[]{INonBlockingConnection.class});
            }
            if (this.isDisconnectHandler) {
                this.isDisconnectHandlerMultithreaded = ConnectionUtils.isMethodThreaded(handler.getClass(), "onDisconnect", this.isHandlerMultithreaded, new Class[]{INonBlockingConnection.class});
            }
            if (this.isIdleTimeoutHandler) {
                this.isIdleTimeoutHandlerMultithreaded = ConnectionUtils.isMethodThreaded(handler.getClass(), "onIdleTimeout", this.isHandlerMultithreaded, new Class[]{INonBlockingConnection.class});
            }
            if (this.isConnectionTimeoutHandler) {
                this.isConnectionTimeoutHandlerMultithreaded = ConnectionUtils.isMethodThreaded(handler.getClass(), "onConnectionTimeout", this.isHandlerMultithreaded, new Class[]{INonBlockingConnection.class});
            }
            if (this.isConnectionTimeoutHandler) {
                this.isConnectHandlerMultithreaded = ConnectionUtils.isMethodThreaded(handler.getClass(), "onConnectionTimeout", this.isHandlerMultithreaded, new Class[]{INonBlockingConnection.class});
            }
            if (this.isConnectExceptionHandler) {
                this.isConnectExceptionHandlerMultithreaded = ConnectionUtils.isMethodThreaded(handler.getClass(), "onConnectException", this.isHandlerMultithreaded, new Class[]{INonBlockingConnection.class, IOException.class});
            }
            this.isUnsynchrnoized = !this.isHandlerMultithreaded && !this.isConnectHandlerMultithreaded && !this.isDataHandlerMultithreaded && !this.isDisconnectHandlerMultithreaded && !this.isIdleTimeoutHandlerMultithreaded && !this.isConnectionTimeoutHandlerMultithreaded && !this.isConnectExceptionHandlerMultithreaded;
        }

        public boolean isConnectHandler() {
            return this.isConnectHandler;
        }

        public boolean isDataHandler() {
            return this.isDataHandler;
        }

        public boolean isDisconnectHandler() {
            return this.isDisconnectHandler;
        }

        public boolean isIdleTimeoutHandler() {
            return this.isIdleTimeoutHandler;
        }

        public boolean isConnectionTimeoutHandler() {
            return this.isConnectionTimeoutHandler;
        }

        public boolean isLifeCycle() {
            return this.isLifeCycle;
        }

        public boolean isConnectionScoped() {
            return this.isConnectionScoped;
        }

        public boolean isUnsynchronized() {
            return this.isUnsynchrnoized;
        }

        public boolean isConnectExceptionHandler() {
            return this.isConnectExceptionHandler;
        }

        public boolean isConnectExceptionHandlerMultithreaded() {
            return this.isConnectExceptionHandlerMultithreaded;
        }

        public boolean isConnectHandlerMultithreaded() {
            return this.isConnectHandlerMultithreaded;
        }

        public boolean isDataHandlerMultithreaded() {
            return this.isDataHandlerMultithreaded;
        }

        public boolean isDisconnectHandlerMultithreaded() {
            return this.isDisconnectHandlerMultithreaded;
        }

        public boolean isIdleTimeoutHandlerMultithreaded() {
            return this.isIdleTimeoutHandlerMultithreaded;
        }

        public boolean isConnectionTimeoutHandlerMultithreaded() {
            return this.isConnectionTimeoutHandlerMultithreaded;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MapCache<T>
    extends LinkedHashMap<Class, T> {
        private static final long serialVersionUID = 4513864504007457500L;
        private int maxSize = 0;

        MapCache(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Class, T> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

