/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.util.logging.Logger;

abstract class MonitoredSelector {
    private static final Logger LOG = Logger.getLogger(MonitoredSelector.class.getName());
    private static final boolean IS_LOOPING_CHECK_ACTIVATED = Boolean.parseBoolean(System.getProperty("org.xsocket.connection.selector.loopingcheckactivated", "true"));
    private static final long LOG_PERIOD_MILLIS = 5000L;
    private static final int LOOPING_DETECTED_WAIT_TIME_MILLIS = 10;
    private static final int ZERO_COUNT_THRESHOLD = 100;
    private static final int ZERO_COUNT_TIME_THRESHOLD_MILLIS = 10;
    private int countEventCountIsZero = 0;
    private long lastTimeEventCountIsZero = 0L;
    private long lastTimeSpinningLog = 0L;

    MonitoredSelector() {
    }

    protected final void checkForLooping(int eventCount) {
        if (IS_LOOPING_CHECK_ACTIVATED) {
            if (eventCount == 0) {
                ++this.countEventCountIsZero;
                if (this.countEventCountIsZero == 1) {
                    this.lastTimeEventCountIsZero = System.currentTimeMillis();
                    ++this.countEventCountIsZero;
                    return;
                }
                if (this.countEventCountIsZero > 100) {
                    long current = System.currentTimeMillis();
                    if (current < this.lastTimeEventCountIsZero + 10L) {
                        if (current > this.lastTimeSpinningLog + 5000L) {
                            this.lastTimeSpinningLog = current;
                            LOG.warning("Selector is looping\r\n" + this.printRegistered());
                        }
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                    }
                    this.countEventCountIsZero = 0;
                }
            } else {
                this.countEventCountIsZero = 0;
            }
        }
    }

    abstract String printRegistered();
}

