/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.ILifeCycle;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.Resource;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IHandlerInfo;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HandlerChain
implements IHandler,
IConnectHandler,
IDataHandler,
IDisconnectHandler,
IConnectionTimeoutHandler,
IIdleTimeoutHandler,
ILifeCycle {
    private static final Logger LOG = Logger.getLogger(HandlerChain.class.getName());
    @Resource
    private Server server = null;
    private final List<WeakReference<HandlerChain>> enclosingChains = new ArrayList<WeakReference<HandlerChain>>();
    private final HandlerInfo handlerInfo = new HandlerInfo();
    private final List<IHandler> handlers = new ArrayList<IHandler>();
    private boolean isUnsynchronized = false;
    private final List<ILifeCycle> lifeCycleChain = new ArrayList<ILifeCycle>();
    private boolean isOnConnectPathMultithreaded = false;
    private final List<IConnectHandler> connectHandlerChain = new ArrayList<IConnectHandler>();
    private boolean isOnDataPathMultithreaded = false;
    private final List<IDataHandler> dataHandlerChain = new ArrayList<IDataHandler>();
    private boolean isOnDisconnectPathMultithreaded = false;
    private final List<IDisconnectHandler> disconnectHandlerChain = new ArrayList<IDisconnectHandler>();
    private boolean isOnIdleTimeoutPathMultithreaded = false;
    private final List<IIdleTimeoutHandler> idleTimeoutHandlerChain = new ArrayList<IIdleTimeoutHandler>();
    private boolean isOnConnectionTimeoutPathMultithreaded = false;
    private final List<IConnectionTimeoutHandler> connectionTimeoutHandlerChain = new ArrayList<IConnectionTimeoutHandler>();

    public HandlerChain() {
    }

    IHandlerInfo getHandlerInfo() {
        return this.handlerInfo;
    }

    public HandlerChain(List<IHandler> handlers) {
        for (IHandler hdl : handlers) {
            this.addLast(hdl);
        }
    }

    @Override
    public void onInit() {
        for (IHandler handler : this.handlers) {
            ConnectionUtils.injectServerField(this.server, handler);
        }
        for (ILifeCycle lifeCycle : this.lifeCycleChain) {
            lifeCycle.onInit();
        }
    }

    @Override
    public void onDestroy() throws IOException {
        for (ILifeCycle lifeCycle : this.lifeCycleChain) {
            lifeCycle.onDestroy();
        }
    }

    public void addLast(IHandler handler) {
        if (handler instanceof HandlerChain) {
            ((HandlerChain)handler).registerChildChain(this);
        }
        this.handlers.add(handler);
        this.computePath();
    }

    private void registerChildChain(HandlerChain handlerChain) {
        this.enclosingChains.add(new WeakReference<HandlerChain>(handlerChain));
    }

    private void computePath() {
        this.lifeCycleChain.clear();
        this.connectHandlerChain.clear();
        this.isOnConnectPathMultithreaded = false;
        this.dataHandlerChain.clear();
        this.isOnDataPathMultithreaded = false;
        this.disconnectHandlerChain.clear();
        this.isOnDisconnectPathMultithreaded = false;
        this.idleTimeoutHandlerChain.clear();
        this.isOnIdleTimeoutPathMultithreaded = false;
        this.connectionTimeoutHandlerChain.clear();
        this.isOnConnectionTimeoutPathMultithreaded = false;
        this.isUnsynchronized = true;
        for (IHandler iHandler : this.handlers) {
            IHandlerInfo handlerInfo = ConnectionUtils.getHandlerInfo(iHandler);
            boolean bl = this.isUnsynchronized = this.isUnsynchronized && handlerInfo.isUnsynchronized();
            if (handlerInfo.isLifeCycle()) {
                this.lifeCycleChain.add((ILifeCycle)((Object)iHandler));
            }
            if (iHandler instanceof HandlerChain) {
                IHandlerInfo nestedInfo = ((HandlerChain)iHandler).getHandlerInfo();
                this.isOnConnectPathMultithreaded = this.isOnConnectPathMultithreaded || nestedInfo.isConnectHandlerMultithreaded();
                this.isOnDataPathMultithreaded = this.isOnDataPathMultithreaded || nestedInfo.isDataHandlerMultithreaded();
                this.isOnDisconnectPathMultithreaded = this.isOnDisconnectPathMultithreaded || nestedInfo.isDisconnectHandlerMultithreaded();
                this.isOnIdleTimeoutPathMultithreaded = this.isOnIdleTimeoutPathMultithreaded || nestedInfo.isIdleTimeoutHandlerMultithreaded();
                this.isOnConnectionTimeoutPathMultithreaded = this.isOnConnectionTimeoutPathMultithreaded || nestedInfo.isConnectionTimeoutHandlerMultithreaded();
                this.dataHandlerChain.add((IDataHandler)iHandler);
                this.disconnectHandlerChain.add((IDisconnectHandler)iHandler);
                this.idleTimeoutHandlerChain.add((IIdleTimeoutHandler)iHandler);
                this.connectionTimeoutHandlerChain.add((IConnectionTimeoutHandler)iHandler);
                continue;
            }
            if (handlerInfo.isConnectHandler()) {
                this.connectHandlerChain.add((IConnectHandler)iHandler);
                boolean bl2 = this.isOnConnectPathMultithreaded = this.isOnConnectPathMultithreaded || handlerInfo.isConnectHandlerMultithreaded();
            }
            if (handlerInfo.isDataHandler()) {
                this.dataHandlerChain.add((IDataHandler)iHandler);
                boolean bl3 = this.isOnDataPathMultithreaded = this.isOnDataPathMultithreaded || handlerInfo.isDataHandlerMultithreaded();
            }
            if (handlerInfo.isDisconnectHandler()) {
                this.disconnectHandlerChain.add((IDisconnectHandler)iHandler);
                boolean bl4 = this.isOnDisconnectPathMultithreaded = this.isOnDisconnectPathMultithreaded || handlerInfo.isDisconnectHandlerMultithreaded();
            }
            if (handlerInfo.isIdleTimeoutHandler()) {
                this.idleTimeoutHandlerChain.add((IIdleTimeoutHandler)iHandler);
                boolean bl5 = this.isOnIdleTimeoutPathMultithreaded = this.isOnIdleTimeoutPathMultithreaded || handlerInfo.isIdleTimeoutHandlerMultithreaded();
            }
            if (!handlerInfo.isConnectionTimeoutHandler()) continue;
            this.connectionTimeoutHandlerChain.add((IConnectionTimeoutHandler)iHandler);
            this.isOnConnectionTimeoutPathMultithreaded = this.isOnConnectionTimeoutPathMultithreaded || handlerInfo.isConnectionTimeoutHandlerMultithreaded();
        }
        for (WeakReference weakReference : this.enclosingChains) {
            HandlerChain handlerChain = (HandlerChain)weakReference.get();
            if (handlerChain == null) continue;
            handlerChain.computePath();
        }
    }

    @Override
    public boolean onConnect(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.connectHandlerChain.isEmpty()) {
            return false;
        }
        for (IConnectHandler connectHandler : this.connectHandlerChain) {
            boolean result = connectHandler.onConnect(connection);
            if (!result) continue;
            return true;
        }
        return true;
    }

    @Override
    public boolean onData(INonBlockingConnection connection) throws IOException {
        if (this.dataHandlerChain.isEmpty()) {
            return false;
        }
        for (IDataHandler dataHandler : this.dataHandlerChain) {
            boolean result = dataHandler.onData(connection);
            if (!result) continue;
            return true;
        }
        return true;
    }

    @Override
    public boolean onDisconnect(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.disconnectHandlerChain.isEmpty()) {
            return false;
        }
        for (IDisconnectHandler disconnectHandler : this.disconnectHandlerChain) {
            boolean result = disconnectHandler.onDisconnect(connection);
            if (!result) continue;
            return true;
        }
        return true;
    }

    @Override
    public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.idleTimeoutHandlerChain.isEmpty()) {
            return false;
        }
        for (IIdleTimeoutHandler idleTimeoutHandler : this.idleTimeoutHandlerChain) {
            boolean result = idleTimeoutHandler.onIdleTimeout(connection);
            if (!result) continue;
            return true;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + connection.getId() + "] closing connection because idle timeout has been occured and timeout handler returns true)");
        }
        connection.close();
        return true;
    }

    @Override
    public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.connectionTimeoutHandlerChain.isEmpty()) {
            return false;
        }
        for (IConnectionTimeoutHandler connectionTimeoutHandler : this.connectionTimeoutHandlerChain) {
            boolean result = connectionTimeoutHandler.onConnectionTimeout(connection);
            if (!result) continue;
            return true;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + connection.getId() + "] closing connection because coonection timeout has been occured and timeout handler returns true)");
        }
        connection.close();
        return true;
    }

    private class HandlerInfo
    implements IHandlerInfo {
        private HandlerInfo() {
        }

        public boolean isConnectionScoped() {
            return false;
        }

        public boolean isConnectExceptionHandler() {
            return false;
        }

        public boolean isConnectExceptionHandlerMultithreaded() {
            return false;
        }

        public boolean isConnectHandler() {
            return true;
        }

        public boolean isConnectHandlerMultithreaded() {
            return HandlerChain.this.isOnConnectionTimeoutPathMultithreaded;
        }

        public boolean isConnectionTimeoutHandler() {
            return true;
        }

        public boolean isConnectionTimeoutHandlerMultithreaded() {
            return HandlerChain.this.isOnConnectionTimeoutPathMultithreaded;
        }

        public boolean isDataHandler() {
            return true;
        }

        public boolean isDataHandlerMultithreaded() {
            return HandlerChain.this.isOnDataPathMultithreaded;
        }

        public boolean isDisconnectHandler() {
            return true;
        }

        public boolean isDisconnectHandlerMultithreaded() {
            return HandlerChain.this.isOnDisconnectPathMultithreaded;
        }

        public boolean isIdleTimeoutHandler() {
            return true;
        }

        public boolean isIdleTimeoutHandlerMultithreaded() {
            return HandlerChain.this.isOnIdleTimeoutPathMultithreaded;
        }

        public boolean isLifeCycle() {
            return true;
        }

        public boolean isUnsynchronized() {
            return HandlerChain.this.isUnsynchronized;
        }
    }
}

