/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.xsocket.ILifeCycle;
import org.xsocket.IntrospectionBasedDynamicMBean;
import org.xsocket.connection.DispatcherPoolMBeanProxyFactory;
import org.xsocket.connection.IConnectionPool;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.IoSocketDispatcherPool;

final class ConnectionPoolMBeanProxyFactory {
    ConnectionPoolMBeanProxyFactory() {
    }

    public static ObjectName createAndRegister(IConnectionPool pool, String domain, MBeanServer mbeanServer) throws JMException {
        ObjectName objectName = new ObjectName(domain + ".client:type=" + pool.getClass().getSimpleName() + ",name=" + pool.hashCode());
        mbeanServer.registerMBean(new IntrospectionBasedDynamicMBean(pool), objectName);
        new ResourcePoolListener(pool, domain, mbeanServer);
        ConnectionPoolMBeanProxyFactory.registerGlobalDispatcherPool(domain, mbeanServer);
        return objectName;
    }

    private static void registerGlobalDispatcherPool(String domain, MBeanServer mbeanServer) throws JMException {
        IoSocketDispatcherPool dispatcherPool = IoProvider.getGlobalClientDisptacherPool();
        DispatcherPoolMBeanProxyFactory.createAndRegister(dispatcherPool, domain + ".client", mbeanServer);
    }

    private static void unregister(IConnectionPool pool, String domain, MBeanServer mbeanServer) throws JMException {
        ObjectName objectName = new ObjectName(domain + ".client:type=" + pool.getClass().getSimpleName() + ",name=" + pool.hashCode());
        mbeanServer.unregisterMBean(objectName);
    }

    private static final class ResourcePoolListener
    implements ILifeCycle {
        private static final Logger LOG = Logger.getLogger(ResourcePoolListener.class.getName());
        private final IConnectionPool pool;
        private final String domain;
        private final MBeanServer mbeanServer;

        ResourcePoolListener(IConnectionPool pool, String domain, MBeanServer mbeanServer) {
            this.pool = pool;
            this.domain = domain;
            this.mbeanServer = mbeanServer;
            pool.addListener(this);
        }

        public void onInit() {
        }

        public void onDestroy() {
            block2: {
                try {
                    ConnectionPoolMBeanProxyFactory.unregister(this.pool, this.domain, this.mbeanServer);
                }
                catch (Exception ex) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by deregistering the pool (domain=" + this.domain + "). reason: " + ex.toString());
                }
            }
        }
    }
}

