/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.SerializedTaskQueue;
import org.xsocket.connection.AbstractNonBlockingStream;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.ExtendedClosedChannelException;
import org.xsocket.connection.HandlerAdapter;
import org.xsocket.connection.IConnectExceptionHandler;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IConnectionPool;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IHandlerChangeListener;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IWriteCompletionHandler;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.MaxConnectionsExceededException;
import org.xsocket.connection.NonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonBlockingConnectionPool
implements IConnectionPool {
    private static final Logger LOG = Logger.getLogger(NonBlockingConnectionPool.class.getName());
    private static final long MIN_REMAINING_MILLIS_TO_IDLE_TIMEOUT = 3000L;
    private static final long MIN_REMAINING_MILLIS_TO_CONNECTION_TIMEOUT = 3000L;
    private static final int CONNECT_MAX_TRIALS = Integer.parseInt(System.getProperty("org.xsocket.connection.connectionpool.maxtrials", "3"));
    private static final int CONNECT_RETRY_WAIT_TIME_MILLIS = Integer.parseInt(System.getProperty("org.xsocket.connection.connectionpool.retrywaittimemillis", "50"));
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private final SSLContext sslContext;
    private final AtomicInteger maxActive = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger maxActivePerServer = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger maxIdle = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger poolIdleTimeoutMillis = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger lifeTimeoutMillis = new AtomicInteger(Integer.MAX_VALUE);
    private final Object limitGuard = new Object();
    private int numInitializingConnections = 0;
    private final Map<InetAddress, Integer> initializingConnectionMap = new HashMap<InetAddress, Integer>();
    private final Pool pool = new Pool();
    private final Object retrieveGuard = new Object();
    private Integer acquireTimeoutMillis = null;
    private Executor workerpool = NonBlockingConnection.getDefaultWorkerpool();
    private static final int DEFAULT_WATCHDOG_CHECK_PERIOD = 30000;
    private final Watchog watchdog;
    private final List<ILifeCycle> listeners = new ArrayList<ILifeCycle>();
    private final AtomicInteger countRejectedConnections = new AtomicInteger(0);
    private final AtomicInteger countUndetectedDisconnect = new AtomicInteger(0);
    private final AtomicInteger countPendingGet = new AtomicInteger(0);
    private final AtomicInteger countCreated = new AtomicInteger(0);
    private final AtomicInteger countDestroyed = new AtomicInteger(0);
    private final AtomicInteger countRemainingMillisToIdleTimeoutToSmall = new AtomicInteger(0);
    private final AtomicInteger countRemainingConnectionToIdleTimeoutToSmall = new AtomicInteger(0);
    private final AtomicInteger countCreationError = new AtomicInteger(0);
    private final AtomicInteger countIdleTimeout = new AtomicInteger(0);
    private final AtomicInteger countConnectionTimeout = new AtomicInteger(0);
    private final AtomicInteger countTimeoutPooledIdle = new AtomicInteger(0);
    private final AtomicInteger countTimeoutPooledLifetime = new AtomicInteger(0);

    public NonBlockingConnectionPool() {
        this(null);
    }

    public NonBlockingConnectionPool(SSLContext sslContext) {
        this(sslContext, 30000);
    }

    NonBlockingConnectionPool(SSLContext sslCtx, int watchdogCheckPeriod) {
        if (sslCtx == null) {
            try {
                Method m = SSLContext.class.getMethod("getDefault", new Class[0]);
                sslCtx = (SSLContext)m.invoke(SSLContext.class, new Object[0]);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("default SSLContext -> SSLContext.getDefault() is loaded automatically");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sslContext = sslCtx;
        this.watchdog = new Watchog();
        IoProvider.getTimer().schedule((TimerTask)this.watchdog, watchdogCheckPeriod, (long)watchdogCheckPeriod);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(host, port), null, this.workerpool, true, this.toInt(Long.MAX_VALUE), false);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, boolean isSSL) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(host, port), null, this.workerpool, true, this.toInt(Long.MAX_VALUE), isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, int connectTimeoutMillis) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(host, port), null, this.workerpool, true, connectTimeoutMillis, false);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(host, port), null, this.workerpool, true, connectTimeoutMillis, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetSocketAddress address) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(address, null, this.workerpool, true, this.toInt(Long.MAX_VALUE), false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, true, this.toInt(Long.MAX_VALUE), false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, boolean isSSL) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, true, this.toInt(Long.MAX_VALUE), isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, int connectTimeoutMillis) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, true, connectTimeoutMillis, false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, true, connectTimeoutMillis, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, boolean waitForConnect, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(address, port), null, this.workerpool, waitForConnect, connectTimeoutMillis, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, true, this.toInt(Long.MAX_VALUE), false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean isSSL) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, true, this.toInt(Long.MAX_VALUE), isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, IHandler appHandler) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(host, port), appHandler, this.workerpool, true, this.toInt(Long.MAX_VALUE), false);
    }

    public INonBlockingConnection getNonBlockingConnection(String host, int port, IHandler appHandler, boolean isSSL) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(host, port), appHandler, this.workerpool, true, this.toInt(Long.MAX_VALUE), isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, true, connectTimeoutMillis, false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean waitForConnect, int connectTimeoutMillis) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, waitForConnect, connectTimeoutMillis, false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, true, connectTimeoutMillis, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, boolean waitForConnect, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, this.workerpool, waitForConnect, connectTimeoutMillis, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, Executor workerPool, int connectTimeoutMillis) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, workerPool, true, connectTimeoutMillis, false);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, Executor workerPool, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, workerPool, true, connectTimeoutMillis, isSSL);
    }

    public INonBlockingConnection getNonBlockingConnection(InetAddress address, int port, IHandler appHandler, Executor workerPool, boolean waitForConnect, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException, MaxConnectionsExceededException {
        return this.getConnection(new InetSocketAddress(address, port), appHandler, workerPool, waitForConnect, connectTimeoutMillis, isSSL);
    }

    private int toInt(long l) {
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    private INonBlockingConnection getConnection(InetSocketAddress address, IHandler appHandler, Executor workerPool, boolean waitForConnect, int connectTimeoutMillis, boolean isSSL) throws IOException, SocketTimeoutException, MaxConnectionsExceededException, MaxConnectionsExceededException {
        NonBlockingConnectionProxy proxy = new NonBlockingConnectionProxy(address);
        Connector connector = waitForConnect ? new SyncConnector(proxy, appHandler, isSSL, CONNECT_MAX_TRIALS, connectTimeoutMillis, CONNECT_RETRY_WAIT_TIME_MILLIS) : new Connector(proxy, appHandler, isSSL, CONNECT_MAX_TRIALS, connectTimeoutMillis, CONNECT_RETRY_WAIT_TIME_MILLIS);
        try {
            if (isSSL && this.sslContext == null) {
                throw new IOException("could not create a SSL connection to " + address.toString() + ". SSLContext is not set");
            }
            if (this.isOpen.get()) {
                connector.connect();
                return proxy;
            }
            throw new IOException("pool is already closed");
        }
        catch (IOException ioe) {
            connector.onConnectFailed(ioe);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLimit(InetAddress addr) throws MaxConnectionsExceededException {
        Object object = this.limitGuard;
        synchronized (object) {
            if (this.pool.getNumActive() + this.numInitializingConnections > this.maxActive.get()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("max active connections " + this.maxActive.get() + "  exceeded");
                }
                this.countRejectedConnections.incrementAndGet();
                throw new MaxConnectionsExceededException("max active connections " + this.maxActive.get() + "  exceeded");
            }
            if (this.maxActivePerServer.get() != Integer.MAX_VALUE) {
                Integer connectionAddr = this.initializingConnectionMap.get(addr);
                if (connectionAddr == null) {
                    connectionAddr = 0;
                }
                if (this.pool.isActiveExceeded(addr, this.maxActivePerServer.get() - connectionAddr)) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("max active connections " + this.maxActivePerServer.get() + " (initializing: " + connectionAddr + ") to " + addr + " exceeded");
                    }
                    this.countRejectedConnections.incrementAndGet();
                    throw new MaxConnectionsExceededException("max active connections " + this.maxActivePerServer.get() + " (initializing: " + connectionAddr + ") to " + addr + " exceeded");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incCountInitializingConnections(InetAddress addr) {
        Object object = this.limitGuard;
        synchronized (object) {
            ++this.numInitializingConnections;
            Integer connectionAddr = this.initializingConnectionMap.get(addr);
            if (connectionAddr == null) {
                connectionAddr = 0;
            }
            Integer n = connectionAddr;
            Integer n2 = connectionAddr = Integer.valueOf(connectionAddr + 1);
            this.initializingConnectionMap.put(addr, connectionAddr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decCountInitializingConnections(InetAddress addr) {
        Object object = this.limitGuard;
        synchronized (object) {
            Integer connectionAddr;
            --this.numInitializingConnections;
            if (this.numInitializingConnections < 0) {
                this.numInitializingConnections = 0;
            }
            if ((connectionAddr = this.initializingConnectionMap.get(addr)) != null) {
                Integer n = connectionAddr;
                Integer n2 = connectionAddr = Integer.valueOf(connectionAddr - 1);
                if (connectionAddr <= 0) {
                    this.initializingConnectionMap.remove(addr);
                } else {
                    this.initializingConnectionMap.put(addr, connectionAddr);
                }
            }
        }
    }

    private void newConnection(Connector connector) {
        try {
            NativeConnectionHolder nativeConnectionHolder;
            do {
                if ((nativeConnectionHolder = this.pool.getAndRemoveIdleConnection(connector.getAddress(), connector.isSSL())) == null) continue;
                boolean isValid = nativeConnectionHolder.isVaild(System.currentTimeMillis(), true);
                if (isValid && nativeConnectionHolder.getConnection().reset()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("got connection from pool (" + this.pool.toString() + ", idleTimeoutMillis=" + this.getPooledMaxIdleTimeMillis() + ", lifeTimeout=" + this.getPooledMaxLifeTimeMillis() + "): " + nativeConnectionHolder.getConnection());
                    }
                    connector.onConnected(nativeConnectionHolder);
                    return;
                }
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("get a invalid connection try another one");
            } while (nativeConnectionHolder != null);
            nativeConnectionHolder = this.newNativeConnection(connector, connector.getConnectTimeoutMillis(), CONNECT_MAX_TRIALS, CONNECT_RETRY_WAIT_TIME_MILLIS, connector.isSSL());
        }
        catch (IOException ioe) {
            connector.onConnectError(ioe);
        }
    }

    private void returnToIdlePool(NativeConnectionHolder nativeConnectionHolder) {
        this.pool.returnIdleConnection(nativeConnectionHolder);
        if (this.maxActive.get() < Integer.MAX_VALUE) {
            this.wakeupPendingRetrieve();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeupPendingRetrieve() {
        Object object = this.retrieveGuard;
        synchronized (object) {
            this.retrieveGuard.notifyAll();
        }
    }

    private NativeConnectionHolder newNativeConnection(Connector connector, int creationTimeoutMillis, int maxTrials, int retryWaittimeMillis, boolean isSSL) throws IOException {
        long start = System.currentTimeMillis();
        int remainingTimeMillis = creationTimeoutMillis;
        int trials = 0;
        while (true) {
            ++trials;
            try {
                NativeConnectionHolder nativeConnectionHolder = new NativeConnectionHolder(connector);
                new NonBlockingConnection(connector.getAddress(), false, remainingTimeMillis, new HashMap<String, Object>(), this.sslContext, isSSL, nativeConnectionHolder, connector.getWorkerpool(), null);
                return nativeConnectionHolder;
            }
            catch (IOException ioe) {
                this.countCreationError.incrementAndGet();
                remainingTimeMillis = creationTimeoutMillis - (int)(System.currentTimeMillis() - start);
                if (remainingTimeMillis <= 0) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("error occured by creating connection to " + connector.getAddress() + ". creation timeout " + DataConverter.toFormatedDuration(creationTimeoutMillis) + " reached (trials: " + trials + " maxTrials: " + maxTrials + ")");
                    }
                    throw new SocketTimeoutException("creation timeout " + creationTimeoutMillis + " millis reached (trials: " + trials + " maxTrials: " + maxTrials + "). Could not connect to " + connector.getAddress() + " " + ioe.toString());
                }
                if (trials >= maxTrials) {
                    throw new SocketTimeoutException("creation failed. Max trials " + maxTrials + " reached. Elapsed time " + DataConverter.toFormatedDuration(System.currentTimeMillis() - start) + " (creation timeout " + DataConverter.toFormatedDuration(creationTimeoutMillis) + "). Could not connect to " + connector.getAddress() + " " + ioe.toString());
                }
                if (remainingTimeMillis > retryWaittimeMillis) {
                    try {
                        Thread.sleep(retryWaittimeMillis);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    retryWaittimeMillis += retryWaittimeMillis;
                    continue;
                }
                throw new SocketTimeoutException("creation timeout " + creationTimeoutMillis + " millis reached (trials: " + trials + " maxTrials: " + maxTrials + "). Could not connect to " + connector.getAddress() + " " + ioe.toString());
            }
            break;
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen.get();
    }

    @Override
    public void close() {
        if (this.isOpen.getAndSet(false)) {
            this.pool.close();
            this.watchdog.cancel();
            for (ILifeCycle lifeCycle : this.listeners) {
                try {
                    lifeCycle.onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("exception occured by destroying " + lifeCycle + " " + ioe.toString());
                }
            }
            this.listeners.clear();
            this.workerpool = null;
        }
    }

    public void destroy() {
        if (this.isOpen.getAndSet(false)) {
            this.pool.destroy();
            this.watchdog.cancel();
            for (ILifeCycle lifeCycle : this.listeners) {
                try {
                    lifeCycle.onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("exception occured by destroying " + lifeCycle + " " + ioe.toString());
                }
            }
            this.listeners.clear();
            this.workerpool = null;
        }
    }

    @Override
    public void addListener(ILifeCycle listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(ILifeCycle listener) {
        boolean result = this.listeners.remove(listener);
        return result;
    }

    public void setWorkerpool(Executor workerpool) {
        this.workerpool = workerpool;
    }

    public Executor getWorkerpool() {
        return this.workerpool;
    }

    @Override
    public int getMaxActive() {
        return this.maxActive.get();
    }

    public int getNumRejectedConnections() {
        return this.countRejectedConnections.get();
    }

    @Override
    public void setMaxActive(int maxActive) {
        if (maxActive < 0) {
            maxActive = 0;
        }
        this.maxActive.set(maxActive);
        this.wakeupPendingRetrieve();
    }

    @Override
    public void setMaxActivePerServer(int maxActivePerServer) {
        if (maxActivePerServer < 0) {
            maxActivePerServer = 0;
        }
        this.maxActivePerServer.set(maxActivePerServer);
        this.wakeupPendingRetrieve();
    }

    @Override
    public int getMaxActivePerServer() {
        return this.maxActivePerServer.get();
    }

    @Override
    public int getMaxIdle() {
        return this.maxIdle.get();
    }

    @Override
    public void setMaxIdle(int maxIdle) {
        this.maxIdle.set(maxIdle);
    }

    @Override
    public int getNumActive() {
        return this.pool.getNumActive();
    }

    public Integer getAcquireTimeoutMillis() {
        return this.acquireTimeoutMillis;
    }

    public void setAcquireTimeoutMillis(Integer aquireTimeoutMillis) {
        this.acquireTimeoutMillis = aquireTimeoutMillis;
    }

    @Override
    public List<String> getActiveConnectionInfos() {
        ArrayList<String> result = new ArrayList<String>();
        List<NativeConnectionHolder> connectionHolders = this.pool.newManagedPoolCopy();
        connectionHolders.removeAll(this.pool.newIdleCopySet());
        for (NativeConnectionHolder connectionHolder : connectionHolders) {
            result.add(connectionHolder.toString());
        }
        return result;
    }

    @Override
    public List<String> getIdleConnectionInfos() {
        ArrayList<String> result = new ArrayList<String>();
        for (NativeConnectionHolder nativeConnectionHolder : this.pool.newIdleCopySet()) {
            result.add(nativeConnectionHolder.toString());
        }
        return result;
    }

    @Override
    public int getNumIdle() {
        return this.pool.getNumIdle();
    }

    @Override
    public int getNumCreated() {
        return this.countCreated.get();
    }

    public int getNumCreationError() {
        return this.countCreationError.get();
    }

    @Override
    public int getNumDestroyed() {
        return this.countDestroyed.get();
    }

    int getNumIdleTimeout() {
        return this.countIdleTimeout.get();
    }

    int getNumConnectionTimeout() {
        return this.countConnectionTimeout.get();
    }

    int getNumPoolIdleTimeout() {
        return this.countTimeoutPooledIdle.get();
    }

    int getNumPoolLifetimeTimeout() {
        return this.countTimeoutPooledLifetime.get();
    }

    @Override
    public int getNumTimeoutPooledMaxIdleTime() {
        return this.countTimeoutPooledIdle.get();
    }

    @Override
    public int getNumTimeoutPooledMaxLifeTime() {
        return this.countTimeoutPooledLifetime.get();
    }

    int getNumUndetectedDisconnect() {
        return this.countUndetectedDisconnect.get();
    }

    @Override
    public int getPooledMaxIdleTimeMillis() {
        return this.poolIdleTimeoutMillis.get();
    }

    @Override
    public void setPooledMaxIdleTimeMillis(int idleTimeoutMillis) {
        this.poolIdleTimeoutMillis.set(idleTimeoutMillis);
    }

    @Override
    public int getPooledMaxLifeTimeMillis() {
        return this.lifeTimeoutMillis.get();
    }

    @Override
    public void setPooledMaxLifeTimeMillis(int lifeTimeoutMillis) {
        this.lifeTimeoutMillis.set(lifeTimeoutMillis);
    }

    public int getNumPendingGet() {
        return this.countPendingGet.get();
    }

    public static void destroy(INonBlockingConnection connection) throws IOException {
        if (connection == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("warning trying to destroy a <null> connection. destroy will be ignored");
            }
            return;
        }
        if (connection instanceof NonBlockingConnectionProxy) {
            ((NonBlockingConnectionProxy)connection).destroy();
        } else {
            connection.close();
        }
    }

    static boolean isDestroyed(INonBlockingConnection connection) {
        if (connection instanceof NonBlockingConnectionProxy) {
            return ((NonBlockingConnectionProxy)connection).isDestroyed();
        }
        return connection.isOpen();
    }

    private void checkIdleConnections() {
        long currentMillis = System.currentTimeMillis();
        for (NativeConnectionHolder nativeConnectionHolder : this.pool.newIdleCopySet()) {
            boolean isRemoved;
            if (nativeConnectionHolder.isVaild(currentMillis, false) || !(isRemoved = this.pool.removeIdleConnection(nativeConnectionHolder))) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + nativeConnectionHolder.getId() + "] closing connection because it is invalid (e.g. idle timeout, connection timeout reached)");
            }
            nativeConnectionHolder.isVaild(currentMillis, true);
            nativeConnectionHolder.close();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("active=" + this.getNumActive() + ", idle=" + this.getNumIdle() + " ");
            sb.append("created=" + this.countCreated + ", destroyed=" + this.countDestroyed + " ");
            sb.append("connectionTimeout=" + this.countConnectionTimeout + ", idleTimeout=" + this.countIdleTimeout + " (");
            sb.append("maxActive=" + this.maxActive + ", maxIdle=" + this.maxIdle + ", ");
            sb.append("poolIdleTimeout=" + this.poolIdleTimeoutMillis + ", poollifetimeTimeout=" + this.lifeTimeoutMillis + ")");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NonBlockingConnectionProxy
    implements INonBlockingConnection {
        private volatile boolean isOpen = false;
        private final AtomicReference<NativeConnectionHolder> nativeConnectionHolderRef = new AtomicReference<Object>(null);
        private String id;
        private final AtomicReference<HandlerAdapter> handlerAdapterRef = new AtomicReference<Object>(null);
        private final AtomicReference<IHandlerChangeListener> handlerReplaceListenerRef = new AtomicReference();
        private Object attachment = null;
        private boolean isAutoflush = true;
        private final InetSocketAddress address;
        private int countReuse;
        private long initialSendBytes;
        private long initialReceivedBytes;
        private long creationTime;
        private long elapsedLastUsage;
        private final AtomicBoolean isIdleTimeoutOccured = new AtomicBoolean(false);
        private final AtomicBoolean isConnectionTimeoutOccured = new AtomicBoolean(false);
        private final Object disconnectedGuard = false;
        private boolean isDisconnected = false;

        public NonBlockingConnectionProxy(InetSocketAddress address) {
            this.address = address;
        }

        InetSocketAddress getAddress() {
            return this.address;
        }

        void onConnected(NativeConnectionHolder holder, IHandler handler) throws IOException {
            this.isOpen = true;
            this.nativeConnectionHolderRef.set(holder);
            holder.getConnection().setAutoflush(false);
            this.creationTime = System.currentTimeMillis();
            this.elapsedLastUsage = holder.lastUsageTimeMillis;
            this.countReuse = holder.usage;
            this.id = holder.getConnection().getId() + "I" + Integer.toHexString(this.countReuse);
            this.initialReceivedBytes = holder.getConnection().getNumberOfReceivedBytes();
            this.initialSendBytes = holder.getConnection().getNumberOfSendBytes();
            this.setHandler(handler);
            holder.registerProxy(this);
            this.onConnect(ConnectionUtils.isDispatcherThread());
        }

        private boolean onConnect(boolean isUnsynchronized) {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            HandlerAdapter handlerAdapter = this.handlerAdapterRef.get();
            if (holder != null && handlerAdapter != null) {
                try {
                    return handlerAdapter.onConnect(this, holder.connection.getTaskQueue(), holder.connection.getExecutor(), isUnsynchronized);
                }
                catch (IOException ioe) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] Error occured by perform onConnect callback on " + handlerAdapter + " " + ioe.toString());
                    }
                    return false;
                }
            }
            return false;
        }

        void onConnectFailed(Executor workerpool, IOException ioe, IHandler appHandler) {
            block2: {
                HandlerAdapter handlerAdapter = HandlerAdapter.newInstance(appHandler);
                try {
                    handlerAdapter.onConnectException(this, new SerializedTaskQueue(), workerpool, ioe);
                }
                catch (IOException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("[" + this.getId() + "] Error occured by perform onConnect callback on " + handlerAdapter + " " + e.toString());
                }
            }
        }

        private void ensureOpen() {
            if (!this.isOpen) {
                throw new RuntimeException("channel " + this.getId() + " is closed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setHandler(IHandler hdl) throws IOException {
            this.ensureOpen();
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                HandlerAdapter oldHandlerAdapter = this.handlerAdapterRef.get();
                IHandlerChangeListener changeListener = this.handlerReplaceListenerRef.get();
                if (changeListener != null && oldHandlerAdapter != null) {
                    IHandler oldHandler = oldHandlerAdapter.getHandler();
                    changeListener.onHanderReplaced(oldHandler, hdl);
                }
                boolean isChangeListener = false;
                if (hdl != null) {
                    isChangeListener = hdl instanceof IHandlerChangeListener;
                }
                HandlerAdapter adapter = HandlerAdapter.newInstance(hdl);
                if (hdl instanceof IHandlerChangeListener) {
                    this.handlerReplaceListenerRef.set((IHandlerChangeListener)((Object)hdl));
                }
                boolean callDisconnect = false;
                Object object = this.disconnectedGuard;
                synchronized (object) {
                    this.handlerAdapterRef.set(adapter);
                    if (isChangeListener) {
                        this.handlerReplaceListenerRef.set((IHandlerChangeListener)((Object)hdl));
                    }
                    if (this.isDisconnected) {
                        callDisconnect = true;
                    }
                }
                if (ConnectionUtils.isDispatcherThread()) {
                    this.onData(true);
                } else {
                    this.onData(false);
                }
                if (callDisconnect) {
                    adapter.onDisconnect(this, holder.connection.getTaskQueue(), holder.connection.getExecutor(), false);
                }
            }
        }

        @Override
        public IHandler getHandler() {
            this.ensureOpen();
            if (this.nativeConnectionHolderRef.get() == null) {
                return null;
            }
            HandlerAdapter handlerAdapter = this.handlerAdapterRef.get();
            if (handlerAdapter == null) {
                return null;
            }
            return handlerAdapter.getHandler();
        }

        boolean isDestroyed() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                return !holder.getConnection().isConnected();
            }
            return true;
        }

        @Override
        public boolean isOpen() {
            if (!this.isOpen) {
                return false;
            }
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                return holder.getConnection().isOpen();
            }
            return false;
        }

        @Override
        public void close() throws IOException {
            this.initiateOnDisconnect();
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.getAndSet(null);
            if (holder != null) {
                holder.unregister();
            }
        }

        void destroy() {
            block3: {
                this.initiateOnDisconnect();
                NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
                if (holder != null) {
                    try {
                        holder.close();
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block3;
                        LOG.fine("[" + this.getId() + "] error occured while destroying pooledConnectionHolder " + this.nativeConnectionHolderRef.get() + " reason: " + e.toString());
                    }
                }
            }
        }

        private void initiateOnDisconnect() {
            boolean isDispatcherThread = ConnectionUtils.isDispatcherThread();
            try {
                this.onData(isDispatcherThread);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.onDisconnect(isDispatcherThread);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            try {
                NativeConnectionHolder holder;
                sb.append(this.getId());
                if (!this.isOpen()) {
                    sb.append(" closed");
                }
                if ((holder = this.nativeConnectionHolderRef.get()) != null) {
                    sb.append(" (" + holder.getAddress() + ") ");
                }
                sb.append(" (proxy ");
                if (holder == null) {
                    sb.append("closed , countReuse=" + this.countReuse + ", ageProxyMillis=" + (System.currentTimeMillis() - this.creationTime) + ", elapsedLastUsageMillis=" + (System.currentTimeMillis() - this.elapsedLastUsage));
                } else {
                    sb.append("received=" + this.getNumberOfReceivedBytes() + ", sent=" + this.getNumberOfSendBytes() + ", countReuse=" + this.countReuse + ", agePhysicalMillis=" + (System.currentTimeMillis() - holder.creationTimeMillis) + ", pooledLifeTimeout=" + holder.getPooledMaxLifeTimeMillis() + ", pooledIdleTimeout=" + holder.getPooledMaxIdleTimeMillis() + ", ageProxyMillis=" + (System.currentTimeMillis() - this.creationTime) + ", elapsedLastUsageMillis=" + (System.currentTimeMillis() - this.elapsedLastUsage) + ", elapsedTimeLastSent=" + (System.currentTimeMillis() - holder.getConnection().getLastTimeSendMillis()) + ", elapsedTimeLastReceived=" + (System.currentTimeMillis() - holder.getConnection().getLastTimeReceivedMillis()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return sb.toString();
        }

        @Override
        public String getId() {
            return this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean onDisconnect(boolean isUnsynchronized) {
            HandlerAdapter adapter = null;
            Object object = this.disconnectedGuard;
            synchronized (object) {
                if (this.isDisconnected) {
                    return true;
                }
                this.isDisconnected = true;
                adapter = this.handlerAdapterRef.get();
            }
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null && adapter != null) {
                adapter.onDisconnect(this, holder.connection.getTaskQueue(), holder.connection.getExecutor(), isUnsynchronized);
            }
            return true;
        }

        private boolean onData(boolean isUnsynchroized) throws IOException, MaxReadSizeExceededException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            HandlerAdapter handlerAdapter = this.handlerAdapterRef.get();
            if (holder != null && handlerAdapter != null) {
                return handlerAdapter.onData(this, holder.connection.getTaskQueue(), holder.connection.getExecutor(), false, isUnsynchroized);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] onData called even though proxy is closed");
            }
            return true;
        }

        private boolean onConnectionTimeout() throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            HandlerAdapter handlerAdapter = this.handlerAdapterRef.get();
            if (holder != null && handlerAdapter != null) {
                if (!this.isConnectionTimeoutOccured.getAndSet(true)) {
                    return handlerAdapter.onConnectionTimeout(this, holder.connection.getTaskQueue(), holder.connection.getExecutor());
                }
                return true;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] onConnectionTimeout called even though proxy is closed");
            }
            return true;
        }

        private boolean onIdleTimeout() throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            HandlerAdapter handlerAdapter = this.handlerAdapterRef.get();
            if (holder != null && handlerAdapter != null) {
                if (!this.isIdleTimeoutOccured.getAndSet(true)) {
                    return handlerAdapter.onIdleTimeout(this, holder.connection.getTaskQueue(), holder.connection.getExecutor());
                }
                return true;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] onIdletimeout called even though proxy is closed");
            }
            return true;
        }

        @Override
        public boolean isServerSide() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                return holder.getConnection().isServerSide();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public Executor getWorkerpool() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                return holder.getConnection().getWorkerpool();
            }
            return NonBlockingConnection.getDefaultWorkerpool();
        }

        @Override
        public void setWorkerpool(Executor workerpool) {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                holder.getConnection().setWorkerpool(workerpool);
            }
        }

        @Override
        public void setAttachment(Object obj) {
            this.attachment = obj;
        }

        @Override
        public Object getAttachment() {
            return this.attachment;
        }

        @Override
        public void setAutoflush(boolean autoflush) {
            this.isAutoflush = autoflush;
        }

        @Override
        public boolean isAutoflush() {
            return this.isAutoflush;
        }

        @Override
        public void setEncoding(String defaultEncoding) {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                holder.getConnection().setEncoding(defaultEncoding);
            }
        }

        @Override
        public String getEncoding() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                return holder.getConnection().getEncoding();
            }
            return "UTF-8";
        }

        @Override
        public void setFlushmode(IConnection.FlushMode flushMode) {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                holder.getConnection().setFlushmode(flushMode);
            }
        }

        @Override
        public IConnection.FlushMode getFlushmode() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                return holder.getConnection().getFlushmode();
            }
            return IConnection.DEFAULT_FLUSH_MODE;
        }

        @Override
        public void setOption(String name, Object value) throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                holder.getConnection().setOption(name, value);
            }
        }

        @Override
        public Object getOption(String name) throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                try {
                    return holder.getConnection().getOption(name);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelRuntimeException();
        }

        public long getNumberOfReceivedBytes() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                return holder.getConnection().getNumberOfReceivedBytes() - this.initialReceivedBytes;
            }
            throw this.newClosedChannelRuntimeException();
        }

        public long getNumberOfSendBytes() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                return holder.getConnection().getNumberOfSendBytes() - this.initialSendBytes;
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public Map<String, Class> getOptions() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                return holder.getConnection().getOptions();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public void setWriteTransferRate(int bytesPerSecond) throws ClosedChannelException, IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                try {
                    holder.getConnection().setWriteTransferRate(bytesPerSecond);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
        }

        @Override
        public int getWriteTransferRate() throws ClosedChannelException, IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                try {
                    return holder.getConnection().getWriteTransferRate();
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int getMaxReadBufferThreshold() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                return holder.getConnection().getMaxReadBufferThreshold();
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public void setMaxReadBufferThreshold(int size) {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                holder.getConnection().setMaxReadBufferThreshold(size);
            }
        }

        @Override
        public void setConnectionTimeoutMillis(long timeoutMillis) {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                holder.getConnection().setConnectionTimeoutMillis(timeoutMillis);
            }
        }

        @Override
        public long getConnectionTimeoutMillis() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                return holder.getConnection().getConnectionTimeoutMillis();
            }
            return Long.MAX_VALUE;
        }

        @Override
        public void setIdleTimeoutMillis(long timeoutInMillis) {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelRuntimeException();
            }
            holder.getConnection().setIdleTimeoutMillis(timeoutInMillis);
            this.isIdleTimeoutOccured.set(false);
        }

        @Override
        public long getIdleTimeoutMillis() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                return holder.getConnection().getIdleTimeoutMillis();
            }
            return Long.MAX_VALUE;
        }

        @Override
        public long getRemainingMillisToConnectionTimeout() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                return holder.getConnection().getConnectionTimeoutMillis();
            }
            return Long.MAX_VALUE;
        }

        @Override
        public long getRemainingMillisToIdleTimeout() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                return holder.getConnection().getRemainingMillisToIdleTimeout();
            }
            return Long.MAX_VALUE;
        }

        @Override
        public boolean isSecure() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                return holder.getConnection().isSecure();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public void activateSecuredMode() throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                try {
                    holder.getConnection().activateSecuredMode();
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
        }

        @Override
        public void deactivateSecuredMode() throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                try {
                    holder.getConnection().deactivateSecuredMode();
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
        }

        @Override
        public boolean isSecuredModeActivateable() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                return holder.getConnection().isSecuredModeActivateable();
            }
            return false;
        }

        @Override
        public void suspendReceiving() throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                try {
                    holder.getConnection().suspendReceiving();
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
        }

        @Override
        public boolean isReceivingSuspended() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                return holder.getConnection().isReceivingSuspended();
            }
            return false;
        }

        @Override
        public void resumeReceiving() throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                try {
                    holder.getConnection().resumeReceiving();
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
        }

        @Override
        public InetAddress getLocalAddress() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                return holder.getConnection().getLocalAddress();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public int getLocalPort() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                return holder.getConnection().getLocalPort();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public InetAddress getRemoteAddress() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                return holder.getConnection().getRemoteAddress();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public int getRemotePort() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                return holder.getConnection().getRemotePort();
            }
            throw this.newClosedChannelRuntimeException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void write(ByteBuffer[] buffers, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (!this.isOpen || holder == null) throw this.newClosedChannelException();
            try {
                holder.getConnection().write(buffers, writeCompletionHandler);
                if (!this.isAutoflush) return;
                this.flush();
                return;
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by writing " + DataConverter.toString(buffers) + " deregistering ");
                }
                this.destroy();
                throw ioe;
            }
        }

        @Override
        public long write(ByteBuffer[] buffers) throws IOException, BufferOverflowException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                try {
                    long written = holder.getConnection().write(buffers);
                    if (this.isAutoflush) {
                        this.flush();
                    }
                    return written;
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public int write(ByteBuffer buffer) throws IOException, BufferOverflowException {
            return (int)this.write(new ByteBuffer[]{buffer});
        }

        @Override
        public void write(ByteBuffer buffer, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            this.write(new ByteBuffer[]{buffer}, writeCompletionHandler);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.write(DataConverter.toByteBuffers(srcs, offset, length));
        }

        @Override
        public void write(ByteBuffer[] srcs, int offset, int length, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            this.write(DataConverter.toByteBuffers(srcs, offset, length), writeCompletionHandler);
        }

        @Override
        public long write(List<ByteBuffer> buffers) throws IOException, BufferOverflowException {
            return this.write(buffers.toArray(new ByteBuffer[buffers.size()]));
        }

        @Override
        public void write(List<ByteBuffer> buffers, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            this.write(buffers.toArray(new ByteBuffer[buffers.size()]), writeCompletionHandler);
        }

        @Override
        public void write(byte[] bytes, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            this.write(DataConverter.toByteBuffer(bytes), writeCompletionHandler);
        }

        @Override
        public int write(byte[] bytes, int offset, int length) throws IOException, BufferOverflowException {
            return this.write(DataConverter.toByteBuffer(bytes, offset, length));
        }

        @Override
        public void write(byte[] bytes, int offset, int length, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            this.write(DataConverter.toByteBuffer(bytes, offset, length), writeCompletionHandler);
        }

        @Override
        public int write(byte b) throws IOException, BufferOverflowException {
            return this.write(DataConverter.toByteBuffer(b));
        }

        @Override
        public int write(byte ... bytes) throws IOException, BufferOverflowException {
            return this.write(DataConverter.toByteBuffer(bytes));
        }

        @Override
        public int write(long l) throws IOException, BufferOverflowException {
            return this.write(DataConverter.toByteBuffer(l));
        }

        @Override
        public int write(double d) throws IOException, BufferOverflowException {
            return this.write(DataConverter.toByteBuffer(d));
        }

        @Override
        public int write(int i) throws IOException, BufferOverflowException {
            return this.write(DataConverter.toByteBuffer(i));
        }

        @Override
        public int write(short s) throws IOException, BufferOverflowException {
            return this.write(DataConverter.toByteBuffer(s));
        }

        @Override
        public int write(String message) throws IOException, BufferOverflowException {
            return this.write(DataConverter.toByteBuffer(message, this.getEncoding()));
        }

        @Override
        public int write(String message, String encoding) throws IOException, BufferOverflowException {
            return this.write(DataConverter.toByteBuffer(message, encoding));
        }

        @Override
        public void write(String message, String encoding, IWriteCompletionHandler writeCompletionHandler) throws IOException {
            this.write(DataConverter.toByteBuffer(message, encoding), writeCompletionHandler);
        }

        @Override
        public void flush() throws ClosedChannelException, IOException, SocketTimeoutException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                try {
                    holder.getConnection().flush();
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            } else {
                throw this.newClosedChannelException();
            }
        }

        @Override
        public long transferFrom(FileChannel fileChannel) throws IOException, BufferOverflowException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                try {
                    if (this.getFlushmode() == IConnection.FlushMode.SYNC) {
                        long written;
                        long size;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("tranfering file by using MappedByteBuffer (MAX_MAP_SIZE=" + AbstractNonBlockingStream.TRANSFER_BYTE_BUFFER_MAX_MAP_SIZE + ")");
                        }
                        long remaining = size = fileChannel.size();
                        long offset = 0L;
                        long length = 0L;
                        do {
                            length = remaining > (long)AbstractNonBlockingStream.TRANSFER_BYTE_BUFFER_MAX_MAP_SIZE ? (long)AbstractNonBlockingStream.TRANSFER_BYTE_BUFFER_MAX_MAP_SIZE : remaining;
                            MappedByteBuffer buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, offset, length);
                            written = this.write(buffer);
                            offset += written;
                        } while ((remaining -= written) > 0L);
                        return size;
                    }
                    return this.transferFrom((ReadableByteChannel)fileChannel);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public long transferFrom(ReadableByteChannel source) throws IOException, BufferOverflowException {
            return this.transferFrom(source, AbstractNonBlockingStream.TRANSFER_BYTE_BUFFER_MAX_MAP_SIZE);
        }

        @Override
        public long transferFrom(ReadableByteChannel source, int chunkSize) throws IOException, BufferOverflowException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                try {
                    long transfered = 0L;
                    int read = 0;
                    do {
                        ByteBuffer transferBuffer;
                        if ((read = source.read(transferBuffer = ByteBuffer.allocate(chunkSize))) <= 0) continue;
                        if (transferBuffer.remaining() == 0) {
                            transferBuffer.flip();
                            this.write(transferBuffer);
                        } else {
                            transferBuffer.flip();
                            this.write(transferBuffer.slice());
                        }
                        transfered += (long)read;
                    } while (read > 0);
                    return transfered;
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public int getPendingWriteDataSize() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                return holder.getConnection().getPendingWriteDataSize();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public void markWritePosition() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelRuntimeException();
            }
            holder.getConnection().markWritePosition();
        }

        @Override
        public void removeWriteMark() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                holder.getConnection().removeWriteMark();
            }
        }

        @Override
        public boolean resetToWriteMark() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                return holder.getConnection().resetToWriteMark();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public void markReadPosition() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (!this.isOpen || holder == null) {
                throw this.newClosedChannelRuntimeException();
            }
            holder.getConnection().markReadPosition();
        }

        @Override
        public void removeReadMark() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                holder.getConnection().removeReadMark();
            }
        }

        @Override
        public boolean resetToReadMark() {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                return holder.getConnection().resetToReadMark();
            }
            throw this.newClosedChannelRuntimeException();
        }

        @Override
        public int available() throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                return holder.getConnection().available();
            }
            return -1;
        }

        @Override
        public int getReadBufferVersion() throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                return holder.getConnection().getReadBufferVersion();
            }
            return -1;
        }

        @Override
        public int indexOf(String str) throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().indexOf(str);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            return -1;
        }

        @Override
        public int indexOf(String str, String encoding) throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().indexOf(str, encoding);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            return -1;
        }

        @Override
        public void unread(ByteBuffer[] buffers) throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                try {
                    holder.getConnection().unread(buffers);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            } else {
                throw this.newClosedChannelRuntimeException();
            }
        }

        @Override
        public void unread(byte[] bytes) throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                try {
                    holder.getConnection().unread(bytes);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            } else {
                throw this.newClosedChannelRuntimeException();
            }
        }

        @Override
        public void unread(ByteBuffer buffer) throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                try {
                    holder.getConnection().unread(buffer);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            } else {
                throw this.newClosedChannelRuntimeException();
            }
        }

        @Override
        public void unread(String text) throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (this.isOpen && holder != null) {
                try {
                    holder.getConnection().unread(text);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            } else {
                throw this.newClosedChannelRuntimeException();
            }
        }

        @Override
        public int read(ByteBuffer buffer) throws IOException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().read(buffer);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            return -1;
        }

        @Override
        public byte readByte() throws IOException, BufferUnderflowException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readByte();
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, BufferUnderflowException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readByteBufferByDelimiter(delimiter);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readByteBufferByDelimiter(delimiter, maxLength);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readByteBufferByDelimiter(delimiter, encoding);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readByteBufferByDelimiter(delimiter, encoding, maxLength);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public ByteBuffer[] readByteBufferByLength(int length) throws IOException, BufferUnderflowException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readByteBufferByLength(length);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter) throws IOException, BufferUnderflowException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readBytesByDelimiter(delimiter);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readBytesByDelimiter(delimiter, maxLength);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readBytesByDelimiter(delimiter, encoding);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public byte[] readBytesByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readBytesByDelimiter(delimiter, encoding, maxLength);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public byte[] readBytesByLength(int length) throws IOException, BufferUnderflowException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readBytesByLength(length);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public double readDouble() throws IOException, BufferUnderflowException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readDouble();
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public int readInt() throws IOException, BufferUnderflowException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readInt();
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public long readLong() throws IOException, BufferUnderflowException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readLong();
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public short readShort() throws IOException, BufferUnderflowException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readShort();
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public String readStringByDelimiter(String delimiter) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readStringByDelimiter(delimiter);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readStringByDelimiter(delimiter, maxLength);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public String readStringByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readStringByDelimiter(delimiter, encoding);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readStringByDelimiter(delimiter, encoding, maxLength);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public String readStringByLength(int length) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readStringByLength(length);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public String readStringByLength(int length, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().readStringByLength(length, encoding);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        @Override
        public long transferTo(WritableByteChannel target, int length) throws IOException, BufferUnderflowException {
            NativeConnectionHolder holder = this.nativeConnectionHolderRef.get();
            if (holder != null) {
                try {
                    return holder.getConnection().transferTo(target, length);
                }
                catch (IOException ioe) {
                    this.destroy();
                    throw ioe;
                }
            }
            throw this.newClosedChannelException();
        }

        private ExtendedClosedChannelException newClosedChannelException() {
            return new ExtendedClosedChannelException("channel " + this.getId() + " is already closed");
        }

        private RuntimeException newClosedChannelRuntimeException() {
            return new RuntimeException("channel " + this.getId() + " is already closed");
        }
    }

    @Execution(value=0)
    private final class NativeConnectionHolder
    implements IConnectHandler,
    IConnectExceptionHandler,
    IDataHandler,
    IDisconnectHandler,
    IConnectionTimeoutHandler,
    IIdleTimeoutHandler {
        private final AtomicBoolean isClosed = new AtomicBoolean(false);
        private final AtomicBoolean isReusable = new AtomicBoolean(true);
        private final AtomicReference<NonBlockingConnectionProxy> proxyRef = new AtomicReference<Object>(null);
        private Connector connector;
        private NonBlockingConnection connection;
        private InetSocketAddress address;
        private boolean isSSL;
        private int usage = 0;
        private long creationTimeMillis = System.currentTimeMillis();
        private long lastUsageTimeMillis = System.currentTimeMillis();

        public NativeConnectionHolder(Connector connector) {
            this.connector = connector;
        }

        public boolean onConnect(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            this.address = new InetSocketAddress(connection.getRemoteAddress(), connection.getRemotePort());
            this.connection = (NonBlockingConnection)connection;
            this.isSSL = connection.isSecure();
            NonBlockingConnectionPool.this.pool.register(this);
            NonBlockingConnectionPool.this.countCreated.incrementAndGet();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] pooled connection created (" + NonBlockingConnectionPool.this.pool.toString() + ", pooledIdleTimeoutMillis=" + this.getPooledMaxIdleTimeMillis() + ", pooledLifeTimeout=" + this.getPooledMaxLifeTimeMillis() + "): " + connection);
            }
            this.connector.onConnected(this);
            return true;
        }

        public boolean onConnectException(INonBlockingConnection connection, IOException ioe) throws IOException {
            this.connector.onConnectError(ioe);
            return true;
        }

        String getId() {
            return this.connection.getId();
        }

        int getPooledMaxLifeTimeMillis() {
            return NonBlockingConnectionPool.this.lifeTimeoutMillis.get();
        }

        int getPooledMaxIdleTimeMillis() {
            return NonBlockingConnectionPool.this.poolIdleTimeoutMillis.get();
        }

        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            NonBlockingConnectionProxy cp = this.proxyRef.get();
            if (cp != null) {
                try {
                    return cp.onData(ConnectionUtils.isDispatcherThread());
                }
                catch (MaxReadSizeExceededException mre) {
                    this.isReusable.set(false);
                    throw mre;
                }
                catch (IOException ioe) {
                    this.isReusable.set(false);
                    throw ioe;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            this.isReusable.set(false);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("onDisconnect occured. Removing connection from pool (" + this.address.toString() + ")  (" + NonBlockingConnectionPool.this.pool.toString() + ", idleTimeoutMillis=" + this.getPooledMaxIdleTimeMillis() + ", lifeTimeout=" + this.getPooledMaxLifeTimeMillis() + "): " + connection);
            }
            NonBlockingConnectionPool.this.pool.remove(this);
            try {
                NonBlockingConnectionProxy cp = this.proxyRef.get();
                if (cp != null) {
                    boolean bl = cp.onDisconnect(ConnectionUtils.isDispatcherThread());
                    return bl;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("could not call onDisconnect on proxy (proxy already dregistered?)");
                }
                boolean bl = true;
                return bl;
            }
            finally {
                NonBlockingConnectionPool.this.countDestroyed.incrementAndGet();
            }
        }

        public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
            NonBlockingConnectionProxy cp;
            this.isReusable.set(false);
            NonBlockingConnectionPool.this.countConnectionTimeout.incrementAndGet();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] connection timeout occured");
            }
            if ((cp = this.proxyRef.get()) != null) {
                return cp.onConnectionTimeout();
            }
            return false;
        }

        public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
            NonBlockingConnectionProxy cp;
            this.isReusable.set(false);
            NonBlockingConnectionPool.this.countIdleTimeout.incrementAndGet();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] idle timeout (" + DataConverter.toFormatedDuration(this.getConnection().getIdleTimeoutMillis()) + ") occured");
            }
            if ((cp = this.proxyRef.get()) != null) {
                return cp.onIdleTimeout();
            }
            return false;
        }

        int getUsage() {
            return this.usage;
        }

        long getCreationTimeMillis() {
            return this.creationTimeMillis;
        }

        NonBlockingConnection getConnection() {
            return this.connection;
        }

        InetSocketAddress getAddress() {
            return this.address;
        }

        void registerProxy(NonBlockingConnectionProxy proxy) {
            assert (this.proxyRef.get() == null);
            ++this.usage;
            this.lastUsageTimeMillis = System.currentTimeMillis();
            this.proxyRef.set(proxy);
        }

        void unregister() {
            block7: {
                this.proxyRef.set(null);
                this.lastUsageTimeMillis = System.currentTimeMillis();
                try {
                    if (this.connection.isConnected()) {
                        boolean isValid;
                        if (this.connection.isOpen() && NonBlockingConnectionPool.this.isOpen() && this.connection.available() == 0 && (isValid = this.isVaild(System.currentTimeMillis(), true))) {
                            if (NonBlockingConnectionPool.this.maxIdle.get() != Integer.MAX_VALUE || NonBlockingConnectionPool.this.pool.getNumIdle() >= NonBlockingConnectionPool.this.maxIdle.get()) {
                                return;
                            }
                            boolean isReset = this.connection.reset();
                            if (isReset) {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.fine("[" + this.connection.getId() + "] releasing connection (for reuse)");
                                }
                                NonBlockingConnectionPool.this.returnToIdlePool(this);
                                return;
                            }
                        }
                        this.close();
                    }
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block7;
                    LOG.fine("error occured by releasing a pooled connection (" + this.address.toString() + ") " + e.toString());
                }
            }
        }

        private boolean isVaild(long currentTimeMillis, boolean closeIfInvalid) {
            if (this.isClosed.get()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] is invalid (closed)");
                }
                return false;
            }
            if (!this.isReusable.get()) {
                if (closeIfInvalid) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] closing connection because it is marked as non reuseable");
                    }
                    this.close();
                }
                return false;
            }
            if (!this.connection.isConnected() || !this.connection.isOpen()) {
                if (closeIfInvalid) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] closing connection because it is disconnected or closed");
                    }
                    this.close();
                }
                return false;
            }
            if (this.connection.getRemainingMillisToIdleTimeout() < 3000L) {
                if (closeIfInvalid) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] closing connection because remaining time to idle timeout (" + this.connection.getRemainingMillisToIdleTimeout() + " millis) is to small");
                    }
                    NonBlockingConnectionPool.this.countRemainingMillisToIdleTimeoutToSmall.incrementAndGet();
                    this.close();
                }
                return false;
            }
            if (this.connection.getRemainingMillisToConnectionTimeout() < 3000L) {
                if (closeIfInvalid) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] closing connection because remaining time to connection timeout (" + this.connection.getRemainingMillisToConnectionTimeout() + " millis)  is to small");
                    }
                    NonBlockingConnectionPool.this.countRemainingConnectionToIdleTimeoutToSmall.incrementAndGet();
                    this.close();
                }
                return false;
            }
            if (NonBlockingConnectionPool.this.poolIdleTimeoutMillis.get() != Integer.MAX_VALUE && currentTimeMillis > this.lastUsageTimeMillis + (long)NonBlockingConnectionPool.this.poolIdleTimeoutMillis.get()) {
                if (closeIfInvalid) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.connection.getId() + "] connection (" + this.address + ") pool idle timeout reached (" + NonBlockingConnectionPool.this.poolIdleTimeoutMillis + ")");
                    }
                    NonBlockingConnectionPool.this.countTimeoutPooledIdle.incrementAndGet();
                    this.close();
                }
                return false;
            }
            if (NonBlockingConnectionPool.this.lifeTimeoutMillis.get() != Integer.MAX_VALUE && currentTimeMillis > this.creationTimeMillis + (long)NonBlockingConnectionPool.this.lifeTimeoutMillis.get()) {
                if (closeIfInvalid) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + this.getId() + "] connection (" + this.address + ") pool life timeout reached (" + NonBlockingConnectionPool.this.lifeTimeoutMillis + ")");
                    }
                    NonBlockingConnectionPool.this.countTimeoutPooledLifetime.incrementAndGet();
                    this.close();
                }
                return false;
            }
            return true;
        }

        void close() {
            if (!this.isClosed.getAndSet(true)) {
                NonBlockingConnectionPool.this.pool.remove(this);
                NonBlockingConnection.closeQuietly(this.connection);
                NonBlockingConnectionPool.this.wakeupPendingRetrieve();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            try {
                if (this.connection.isReceivingSuspended()) {
                    sb.append("[suspended] ");
                }
                sb.append(this.connection.getLocalAddress() + ":" + this.connection.getLocalPort() + " -> " + this.connection.getRemoteAddress() + ":" + this.connection.getRemotePort() + " " + "[" + this.connection.getId() + "]");
                SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
                sb.append(" creationTime=" + df.format(this.getCreationTimeMillis()) + ", ageMillis=" + (System.currentTimeMillis() - this.creationTimeMillis) + ", elapsedLastUsageMillis=" + (System.currentTimeMillis() - this.lastUsageTimeMillis) + ", countUsage=" + this.getUsage() + ", isReusable=" + this.isReusable.get());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Pool {
        private final ArrayList<NativeConnectionHolder> managedPool = new ArrayList();
        private final HashMap<InetSocketAddress, List<NativeConnectionHolder>> idlePool = new HashMap();
        private boolean isOpen = true;

        private Pool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(NativeConnectionHolder nativeConnectionHolder) {
            if (this.isOpen) {
                Pool pool = this;
                synchronized (pool) {
                    this.managedPool.add(nativeConnectionHolder);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + nativeConnectionHolder.getId() + "] added to managed pool (active=" + this.getNumActive() + ", idle=" + this.getNumIdle() + ")");
                }
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("ignore registering connection " + nativeConnectionHolder.toString() + " because pool is already closed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(NativeConnectionHolder nativeConnectionHolder) {
            boolean isRemoved = false;
            if (this.isOpen) {
                this.removeIdleConnection(nativeConnectionHolder);
                Pool pool = this;
                synchronized (pool) {
                    isRemoved = this.managedPool.remove(nativeConnectionHolder);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    if (isRemoved) {
                        LOG.fine("[" + nativeConnectionHolder.getId() + "] connection removed from managed pool (active=" + this.getNumActive() + ", idle=" + this.getNumIdle() + ")");
                    } else {
                        LOG.fine("[" + nativeConnectionHolder.getId() + "] could not removed connection from managed pool. Connection already removed? (active=" + this.getNumActive() + ", idle=" + this.getNumIdle() + ")");
                    }
                }
            }
            return isRemoved;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeIdleConnection(NativeConnectionHolder connectionHolder) {
            if (this.isOpen) {
                Pool pool = this;
                synchronized (pool) {
                    List<NativeConnectionHolder> idleList = this.idlePool.get(connectionHolder.getAddress());
                    if (idleList != null) {
                        for (NativeConnectionHolder nativeConnectionHolder : idleList) {
                            if (nativeConnectionHolder != connectionHolder) continue;
                            boolean isRemoved = idleList.remove(nativeConnectionHolder);
                            if (idleList.isEmpty()) {
                                this.idlePool.remove(connectionHolder.getAddress());
                            }
                            return isRemoved;
                        }
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NativeConnectionHolder getAndRemoveIdleConnection(InetSocketAddress address, boolean isSSL) {
            if (this.isOpen) {
                Pool pool = this;
                synchronized (pool) {
                    List<NativeConnectionHolder> idleList = this.idlePool.get(address);
                    if (idleList != null) {
                        for (NativeConnectionHolder nativeConnectionHolder : idleList) {
                            if (nativeConnectionHolder.isSSL != isSSL) continue;
                            idleList.remove(nativeConnectionHolder);
                            if (idleList.isEmpty()) {
                                this.idlePool.remove(address);
                            }
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("[" + nativeConnectionHolder.getId() + "] got from idle pool (active=" + this.getNumActive() + ", idle=" + this.getNumIdle() + ")");
                            }
                            return nativeConnectionHolder;
                        }
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void returnIdleConnection(NativeConnectionHolder nativeConnectionHolder) {
            if (this.isOpen) {
                InetSocketAddress address = nativeConnectionHolder.getAddress();
                Pool pool = this;
                synchronized (pool) {
                    List<NativeConnectionHolder> idleList = this.idlePool.get(address);
                    if (idleList == null) {
                        idleList = new ArrayList<NativeConnectionHolder>();
                        this.idlePool.put(address, idleList);
                    }
                    if (!idleList.contains(nativeConnectionHolder)) {
                        idleList.add(nativeConnectionHolder);
                    } else if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + nativeConnectionHolder.getId() + "] will not be returned to pool  because it already exits (active=" + this.getNumActive() + ", idle=" + this.getNumIdle() + ")");
                    }
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + nativeConnectionHolder.getId() + "] added to idle pool (active=" + this.getNumActive() + ", idle=" + this.getNumIdle() + ")");
                }
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + nativeConnectionHolder.getId() + "] will not be returned to pool, because pool is already closed. destroying connection");
                }
                nativeConnectionHolder.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Pool pool = this;
            synchronized (pool) {
                if (!this.isOpen) {
                    return;
                }
                this.isOpen = false;
            }
            List<NativeConnectionHolder> idleSet = this.newIdleCopySet();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("closing " + idleSet.size() + " idle conection(s); " + this.managedPool.size() + " connection(s) stay open unmanaged");
            }
            for (NativeConnectionHolder nativeConnectionHolder : idleSet) {
                nativeConnectionHolder.close();
            }
            this.idlePool.clear();
            this.managedPool.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            Pool pool = this;
            synchronized (pool) {
                if (!this.isOpen) {
                    return;
                }
                this.isOpen = false;
            }
            List<NativeConnectionHolder> connections = this.newManagedPoolCopy();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("closing " + connections.size() + " managed connections");
            }
            for (NativeConnectionHolder nativeConnectionHolder : connections) {
                nativeConnectionHolder.close();
            }
            Pool pool2 = this;
            synchronized (pool2) {
                this.idlePool.clear();
                this.managedPool.clear();
            }
        }

        private List<NativeConnectionHolder> newIdleCopySet() {
            ArrayList<NativeConnectionHolder> idleList = new ArrayList<NativeConnectionHolder>();
            for (List<NativeConnectionHolder> nativeConnectionHolderList : this.newIdlePoolCopy().values()) {
                idleList.addAll(nativeConnectionHolderList);
            }
            return idleList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<NativeConnectionHolder> newManagedPoolCopy() {
            List managedPoolCopy = null;
            Pool pool = this;
            synchronized (pool) {
                managedPoolCopy = (List)this.managedPool.clone();
            }
            return managedPoolCopy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isActiveExceeded(InetAddress address, int maxSize) {
            HashMap idlePoolCopy;
            Object holder2;
            List managedPoolCopy;
            Pool pool = this;
            synchronized (pool) {
                managedPoolCopy = (List)this.managedPool.clone();
            }
            if (managedPoolCopy.size() <= maxSize) {
                return false;
            }
            int managedMatched = 0;
            for (Object holder2 : managedPoolCopy) {
                if (!((NativeConnectionHolder)holder2).getAddress().getAddress().equals(address)) continue;
                ++managedMatched;
            }
            if (managedMatched <= maxSize) {
                return false;
            }
            holder2 = this;
            synchronized (holder2) {
                idlePoolCopy = (HashMap)this.idlePool.clone();
            }
            for (Map.Entry entry : idlePoolCopy.entrySet()) {
                if (!((InetSocketAddress)entry.getKey()).getAddress().equals(address) || (managedMatched -= ((List)entry.getValue()).size()) > maxSize) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HashMap<InetSocketAddress, List<NativeConnectionHolder>> newIdlePoolCopy() {
            HashMap idlePoolCopy = null;
            Pool pool = this;
            synchronized (pool) {
                idlePoolCopy = (HashMap)this.idlePool.clone();
            }
            return idlePoolCopy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSize() {
            Pool pool = this;
            synchronized (pool) {
                return this.managedPool.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumIdle() {
            Pool pool = this;
            synchronized (pool) {
                return this.computeNumIdle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumActive() {
            Pool pool = this;
            synchronized (pool) {
                return this.managedPool.size() - this.computeNumIdle();
            }
        }

        private int computeNumIdle() {
            int size = 0;
            for (List<NativeConnectionHolder> nativeConnectionHolderList : this.idlePool.values()) {
                size += nativeConnectionHolderList.size();
            }
            return size;
        }

        public String toString() {
            return "size=" + this.getSize() + ", active=" + this.getNumActive();
        }
    }

    private final class Watchog
    extends TimerTask {
        private Watchog() {
        }

        public void run() {
            block2: {
                try {
                    NonBlockingConnectionPool.this.checkIdleConnections();
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by checking connections " + t.toString());
                }
            }
        }
    }

    private final class SyncConnector
    extends Connector {
        private boolean isConnected;
        private IOException ioe;

        public SyncConnector(NonBlockingConnectionProxy proxy, IHandler appHandler, boolean isSSL, int maxTrials, int connectTimeoutMillis, long retryWaittimeMillis) {
            super(proxy, appHandler, isSSL, maxTrials, connectTimeoutMillis, retryWaittimeMillis);
            this.isConnected = false;
            this.ioe = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void connect() throws IOException {
            SyncConnector syncConnector = this;
            synchronized (syncConnector) {
                super.connect();
                while (!this.isConnected) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.ioe != null) {
                    throw this.ioe;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onConnectionEstablished() {
            super.onConnectionEstablished();
            SyncConnector syncConnector = this;
            synchronized (syncConnector) {
                this.ioe = null;
                this.isConnected = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onConnectFailed(IOException ioe) {
            super.onConnectFailed(ioe);
            SyncConnector syncConnector = this;
            synchronized (syncConnector) {
                this.ioe = ioe;
                this.isConnected = true;
                this.notifyAll();
            }
        }
    }

    private class Connector {
        private final NonBlockingConnectionProxy proxy;
        private final IHandler appHandler;
        private final boolean isSSL;
        private boolean isConnectionLimited;
        private final long startMillis;
        private final int connectTimeoutMillis;
        private final long retryWaittimeMillis;
        private final int maxTrials;
        private int trials = 0;

        public Connector(NonBlockingConnectionProxy proxy, IHandler appHandler, boolean isSSL, int maxTrials, int connectTimeoutMillis, long retryWaittimeMillis) {
            this.proxy = proxy;
            this.appHandler = appHandler;
            this.isSSL = isSSL;
            this.maxTrials = maxTrials;
            this.connectTimeoutMillis = connectTimeoutMillis;
            this.retryWaittimeMillis = retryWaittimeMillis;
            this.startMillis = System.currentTimeMillis();
            this.isConnectionLimited = NonBlockingConnectionPool.this.maxActive.get() != Integer.MAX_VALUE || NonBlockingConnectionPool.this.maxActivePerServer.get() != Integer.MAX_VALUE;
        }

        boolean isSSL() {
            return this.isSSL;
        }

        Executor getWorkerpool() {
            return NonBlockingConnectionPool.this.workerpool;
        }

        int getConnectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        InetSocketAddress getAddress() {
            return this.proxy.getAddress();
        }

        void connect() throws IOException {
            if (this.isConnectionLimited) {
                NonBlockingConnectionPool.this.incCountInitializingConnections(this.proxy.getAddress().getAddress());
            }
            this.performConnect();
        }

        final void performConnect() {
            ++this.trials;
            if (this.isConnectionLimited) {
                try {
                    NonBlockingConnectionPool.this.checkLimit(this.proxy.getAddress().getAddress());
                }
                catch (MaxConnectionsExceededException mcr) {
                    this.onConnectError(mcr);
                    return;
                }
            }
            NonBlockingConnectionPool.this.newConnection(this);
        }

        final void onConnected(NativeConnectionHolder holder) throws IOException {
            this.proxy.onConnected(holder, this.appHandler);
            this.onConnectionEstablished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void onConnectError(IOException ioe) {
            NonBlockingConnectionPool.this.countCreationError.incrementAndGet();
            long remainingTimeMillis = this.connectTimeoutMillis - (int)(System.currentTimeMillis() - this.startMillis);
            if (remainingTimeMillis <= 0L) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by creating connection to " + this.proxy.getAddress() + ". connect timeout " + DataConverter.toFormatedDuration(this.connectTimeoutMillis) + " reached (trials: " + this.trials + " maxTrials: " + this.maxTrials + ")");
                }
                this.onConnectFailed(new SocketTimeoutException("connect timeout " + this.connectTimeoutMillis + " millis reached (trials: " + this.trials + " maxTrials: " + this.maxTrials + "). Could not connect to " + this.proxy.getAddress() + " " + ioe.toString()));
            }
            if (ioe instanceof MaxConnectionsExceededException) {
                if (NonBlockingConnectionPool.this.acquireTimeoutMillis == null || NonBlockingConnectionPool.this.acquireTimeoutMillis <= 0) {
                    this.onConnectFailed((MaxConnectionsExceededException)ioe);
                } else {
                    long remaining = this.startMillis + (long)NonBlockingConnectionPool.this.acquireTimeoutMillis.intValue() - System.currentTimeMillis();
                    if (remaining > 0L) {
                        Object object = NonBlockingConnectionPool.this.retrieveGuard;
                        synchronized (object) {
                            try {
                                NonBlockingConnectionPool.this.retrieveGuard.wait(remaining);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        this.performConnect();
                    } else {
                        this.onConnectFailed((MaxConnectionsExceededException)ioe);
                    }
                }
            } else if (this.trials >= this.maxTrials) {
                this.onConnectFailed(new SocketTimeoutException("creation failed. Max trials " + this.maxTrials + " reached. Elapsed time " + DataConverter.toFormatedDuration(System.currentTimeMillis() - this.startMillis) + " (connection timeout " + DataConverter.toFormatedDuration(this.connectTimeoutMillis) + "). Could not connect to " + this.proxy.getAddress() + " " + ioe.toString()));
            } else if (remainingTimeMillis > this.retryWaittimeMillis) {
                TimerTask tt = new TimerTask(){

                    public void run() {
                        Connector.this.performConnect();
                    }
                };
                IoProvider.getTimer().schedule(tt, this.retryWaittimeMillis);
            } else {
                this.onConnectFailed(new SocketTimeoutException("connect timeout " + this.connectTimeoutMillis + " millis reached (trials: " + this.trials + " maxTrials: " + this.maxTrials + "). Could not connect to " + this.proxy.getAddress() + " " + ioe.toString()));
            }
        }

        void onConnectionEstablished() {
            if (this.isConnectionLimited) {
                NonBlockingConnectionPool.this.decCountInitializingConnections(this.proxy.getAddress().getAddress());
            }
        }

        void onConnectFailed(IOException ioe) {
            if (this.isConnectionLimited) {
                NonBlockingConnectionPool.this.decCountInitializingConnections(this.proxy.getAddress().getAddress());
            }
            this.proxy.onConnectFailed(NonBlockingConnectionPool.this.workerpool, ioe, this.appHandler);
        }
    }
}

