/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;

final class IoQueue {
    private ByteBuffer[] buffers = null;
    private ByteBuffer[] leased = null;

    IoQueue() {
    }

    public synchronized boolean isEmpty() {
        if (this.buffers == null && this.leased == null) {
            return true;
        }
        return this.getSize() == 0;
    }

    public synchronized int getSize() {
        int i;
        int size = 0;
        if (this.buffers != null) {
            for (i = 0; i < this.buffers.length; ++i) {
                if (this.buffers[i] == null) continue;
                size += this.buffers[i].remaining();
            }
        }
        if (this.leased != null) {
            for (i = 0; i < this.leased.length; ++i) {
                if (this.leased[i] == null) continue;
                size += this.leased[i].remaining();
            }
        }
        return size;
    }

    public synchronized void append(ByteBuffer data) {
        if (data == null || data.remaining() == 0) {
            return;
        }
        if (this.buffers == null) {
            this.buffers = new ByteBuffer[1];
            this.buffers[0] = data;
        } else {
            ByteBuffer[] newBuffers = new ByteBuffer[this.buffers.length + 1];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            newBuffers[this.buffers.length] = data;
            this.buffers = newBuffers;
        }
    }

    public synchronized void append(ByteBuffer[] data) {
        if (data == null) {
            return;
        }
        if (this.buffers == null) {
            this.buffers = data;
        } else {
            ByteBuffer[] newBuffers = new ByteBuffer[this.buffers.length + data.length];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            System.arraycopy(data, 0, newBuffers, this.buffers.length, data.length);
            this.buffers = newBuffers;
        }
    }

    public synchronized void addFirst(ByteBuffer[] data) {
        if (data == null) {
            return;
        }
        if (this.buffers == null) {
            this.buffers = data;
        } else {
            ByteBuffer[] newBuffers = new ByteBuffer[this.buffers.length + data.length];
            System.arraycopy(data, 0, newBuffers, 0, data.length);
            System.arraycopy(this.buffers, 0, newBuffers, data.length, this.buffers.length);
            this.buffers = newBuffers;
        }
    }

    private void addFirst(ByteBuffer data) {
        if (data == null) {
            return;
        }
        if (this.buffers == null) {
            this.buffers = new ByteBuffer[]{data};
        } else {
            ByteBuffer[] newBuffers = new ByteBuffer[this.buffers.length + 1];
            newBuffers[0] = data;
            System.arraycopy(this.buffers, 0, newBuffers, 1, this.buffers.length);
            this.buffers = newBuffers;
        }
    }

    public synchronized ByteBuffer[] drain() {
        ByteBuffer[] result = this.buffers;
        this.buffers = null;
        return result;
    }

    public synchronized ByteBuffer[] lease(int maxSize) {
        if (this.buffers != null && this.buffers.length == 1) {
            ByteBuffer[] data = this.drain();
            this.leased = data;
            return data;
        }
        if (this.getSize() <= maxSize) {
            ByteBuffer[] data = this.drain();
            this.leased = data;
            return data;
        }
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        int remaining = maxSize;
        for (int i = 0; i < this.buffers.length; ++i) {
            int size = this.buffers[i].remaining();
            if (size <= 0) continue;
            if (size <= remaining) {
                result.add(this.buffers[i]);
                if ((remaining -= size) != 0) continue;
                this.removeBuffersFromHead(i + 1);
                break;
            }
            int savedPos = this.buffers[i].position();
            int savedLimit = this.buffers[i].limit();
            this.buffers[i].limit(savedPos + remaining);
            ByteBuffer buffer = this.buffers[i].slice();
            result.add(buffer);
            this.buffers[i].limit(savedLimit);
            this.buffers[i].position(savedPos + remaining);
            this.addFirst(this.buffers[i]);
            this.removeBuffersFromHead(i + 1);
            break;
        }
        ByteBuffer[] data = result.toArray(new ByteBuffer[result.size()]);
        this.leased = data;
        return data;
    }

    public synchronized void removeLeased() {
        this.leased = null;
    }

    private void removeBuffersFromHead(int count) {
        int newSize = this.buffers.length - count;
        if (newSize == 0) {
            this.buffers = null;
        } else {
            ByteBuffer[] newBuffers = new ByteBuffer[newSize];
            System.arraycopy(this.buffers, count, newBuffers, 0, newBuffers.length);
            this.buffers = newBuffers;
        }
    }
}

