/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.WorkerPool;
import org.xsocket.connection.ConnectionManager;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.HandlerAdapter;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IHandlerChangeListener;
import org.xsocket.connection.IIoAcceptorCallback;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IServer;
import org.xsocket.connection.IServerListener;
import org.xsocket.connection.IoAcceptor;
import org.xsocket.connection.IoChainableHandler;
import org.xsocket.connection.NonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements IServer {
    private static final Logger LOG = Logger.getLogger(Server.class.getName());
    private static String implementationVersion = ConnectionUtils.getImplementationVersion();
    private static String implementationDate;
    protected static final int SIZE_WORKER_POOL;
    protected static final int MIN_SIZE_WORKER_POOL;
    protected static final int TASK_QUEUE_SIZE;
    private IConnection.FlushMode flushMode = IConnection.DEFAULT_FLUSH_MODE;
    private boolean autoflush = true;
    private Integer writeRate;
    private boolean isOpen = false;
    private String name = "server";
    private IoAcceptor acceptor;
    private ExecutorService defaultWorkerPool;
    private Executor workerpool;
    private ConnectionManager connectionManager = new ConnectionManager(new SizeHandler());
    private int maxConcurrentConnections = Integer.MAX_VALUE;
    private final AtomicReference<IHandlerChangeListener> handlerReplaceListenerRef = new AtomicReference();
    private HandlerAdapter handlerAdapter = HandlerAdapter.newInstance(null);
    private Integer maxReadBufferThreshold = null;
    private long idleTimeoutMillis = Long.MAX_VALUE;
    private long connectionTimeoutMillis = Long.MAX_VALUE;
    private final ArrayList<IServerListener> listeners = new ArrayList();
    private String localHostname = "";
    private int localPort = -1;
    private String startUpLogMessage = "xSocket " + implementationVersion;
    private long startUpTime = 0L;

    public Server(IHandler handler) throws UnknownHostException, IOException {
        this(new InetSocketAddress(0), new HashMap<String, Object>(), handler, null, false, 0, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL, TASK_QUEUE_SIZE);
    }

    public Server(Map<String, Object> options, IHandler handler) throws UnknownHostException, IOException {
        this(new InetSocketAddress(0), options, handler, null, false, 0, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL, TASK_QUEUE_SIZE);
    }

    public Server(int port, IHandler handler) throws UnknownHostException, IOException {
        this(new InetSocketAddress(port), new HashMap<String, Object>(), handler, null, false, 0, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL, TASK_QUEUE_SIZE);
    }

    public Server(int port, IHandler handler, int minPoolsize, int maxPoolsize) throws UnknownHostException, IOException {
        this(new InetSocketAddress(port), new HashMap<String, Object>(), handler, null, false, 0, minPoolsize, maxPoolsize, maxPoolsize);
    }

    public Server(int port, IHandler handler, int backlog) throws UnknownHostException, IOException {
        this(new InetSocketAddress(port), new HashMap<String, Object>(), handler, null, false, backlog, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL, TASK_QUEUE_SIZE);
    }

    public Server(int port, Map<String, Object> options, IHandler handler) throws UnknownHostException, IOException {
        this(new InetSocketAddress(port), options, handler, null, false, 0, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL, TASK_QUEUE_SIZE);
    }

    public Server(InetAddress address, int port, IHandler handler) throws UnknownHostException, IOException {
        this(address, port, new HashMap<String, Object>(), handler, null, false, 0);
    }

    public Server(String ipAddress, int port, IHandler handler) throws UnknownHostException, IOException {
        this(new InetSocketAddress(ipAddress, port), new HashMap<String, Object>(), handler, null, false, 0, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL, TASK_QUEUE_SIZE);
    }

    public Server(String ipAddress, int port, Map<String, Object> options, IHandler handler) throws UnknownHostException, IOException {
        this(new InetSocketAddress(ipAddress, port), options, handler, null, false, 0, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL, TASK_QUEUE_SIZE);
    }

    public Server(int port, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(new InetSocketAddress(port), new HashMap<String, Object>(), handler, sslContext, sslOn, 0, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL, TASK_QUEUE_SIZE);
    }

    public Server(int port, IHandler handler, SSLContext sslContext, boolean sslOn, int minPoolsize, int maxPoolsize) throws UnknownHostException, IOException {
        this(new InetSocketAddress(port), new HashMap<String, Object>(), handler, sslContext, sslOn, 0, minPoolsize, maxPoolsize, maxPoolsize);
    }

    public Server(int port, Map<String, Object> options, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(new InetSocketAddress(port), options, handler, sslContext, sslOn, 0, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL, TASK_QUEUE_SIZE);
    }

    public Server(String ipAddress, int port, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(new InetSocketAddress(ipAddress, port), new HashMap<String, Object>(), handler, sslContext, sslOn, 0, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL, TASK_QUEUE_SIZE);
    }

    public Server(String ipAddress, int port, Map<String, Object> options, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(new InetSocketAddress(ipAddress, port), options, handler, sslContext, sslOn, 0, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL, TASK_QUEUE_SIZE);
    }

    public Server(InetAddress address, int port, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(new InetSocketAddress(address, port), new HashMap<String, Object>(), handler, sslContext, sslOn, 0, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL, TASK_QUEUE_SIZE);
    }

    public Server(InetAddress address, int port, Map<String, Object> options, IHandler handler, SSLContext sslContext, boolean sslOn) throws UnknownHostException, IOException {
        this(new InetSocketAddress(address, port), options, handler, sslContext, sslOn, 0, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL, TASK_QUEUE_SIZE);
    }

    public Server(InetAddress address, int port, Map<String, Object> options, IHandler handler, SSLContext sslContext, boolean sslOn, int backlog) throws UnknownHostException, IOException {
        this(new InetSocketAddress(address, port), options, handler, sslContext, sslOn, backlog, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL, TASK_QUEUE_SIZE);
    }

    public Server(InetAddress address, int port, Map<String, Object> options, IHandler handler, SSLContext sslContext, boolean sslOn, int backlog, int minPoolsize, int maxPoolsize) throws UnknownHostException, IOException {
        this(new InetSocketAddress(address, port), options, handler, sslContext, sslOn, backlog, minPoolsize, maxPoolsize, maxPoolsize);
    }

    protected Server(InetSocketAddress address, Map<String, Object> options, IHandler handler, SSLContext sslContext, boolean sslOn, int backlog) throws UnknownHostException, IOException {
        this(address, options, handler, sslContext, sslOn, backlog, MIN_SIZE_WORKER_POOL, SIZE_WORKER_POOL, TASK_QUEUE_SIZE);
    }

    protected Server(InetSocketAddress address, Map<String, Object> options, IHandler handler, SSLContext sslContext, boolean sslOn, int backlog, int minPoolsize, int maxPoolsize) throws UnknownHostException, IOException {
        this(address, options, handler, sslContext, sslOn, backlog, minPoolsize, maxPoolsize, maxPoolsize);
    }

    protected Server(InetSocketAddress address, Map<String, Object> options, IHandler handler, SSLContext sslContext, boolean sslOn, int backlog, int minPoolsize, int maxPoolsize, int taskqueueSize) throws UnknownHostException, IOException {
        this.defaultWorkerPool = new WorkerPool(minPoolsize, maxPoolsize, taskqueueSize);
        this.workerpool = this.defaultWorkerPool;
        this.acceptor = sslContext != null ? ConnectionUtils.getIoProvider().createAcceptor(new LifeCycleHandler(), address, backlog, options, sslContext, sslOn) : ConnectionUtils.getIoProvider().createAcceptor(new LifeCycleHandler(), address, backlog, options);
        this.localHostname = this.acceptor.getLocalAddress().getHostName();
        this.localPort = this.acceptor.getLocalPort();
        this.setHandler(handler);
    }

    public void setHandler(IHandler handler) {
        IHandlerChangeListener changeListener;
        if (this.isOpen) {
            this.callCurrentHandlerOnDestroy();
        }
        if ((changeListener = this.handlerReplaceListenerRef.get()) != null) {
            IHandler oldHandler = this.handlerAdapter.getHandler();
            changeListener.onHanderReplaced(oldHandler, handler);
        }
        this.handlerAdapter = HandlerAdapter.newInstance(handler);
        this.initCurrentHandler();
    }

    private void initCurrentHandler() {
        ConnectionUtils.injectServerField(this, this.handlerAdapter.getHandler());
        this.handlerAdapter.onInit();
    }

    private void callCurrentHandlerOnDestroy() {
        this.handlerAdapter.onDestroy();
    }

    public final void setServerName(String name) {
        this.name = name;
    }

    public final String getServerName() {
        return this.name;
    }

    @Override
    public String getStartUpLogMessage() {
        return this.startUpLogMessage;
    }

    @Override
    public void setStartUpLogMessage(String message) {
        this.startUpLogMessage = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.getHandler() == null) {
                LOG.warning("no handler has been set. Call setHandler-method to assign a handler");
            }
            this.startUpTime = System.currentTimeMillis();
            ShutdownHookHandler shutdownHookHandler = new ShutdownHookHandler(this);
            try {
                shutdownHookHandler.register();
                this.acceptor.listen();
            }
            finally {
                shutdownHookHandler.deregister();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void start() throws IOException {
        ConnectionUtils.start(this);
    }

    @Override
    public final Object getOption(String name) throws IOException {
        return this.acceptor.getOption(name);
    }

    @Override
    public IHandler getHandler() {
        return this.handlerAdapter.getHandler();
    }

    @Override
    public final Map<String, Class> getOptions() {
        return this.acceptor.getOptions();
    }

    @Override
    public final void close() {
        if (this.isOpen) {
            block9: {
                block8: {
                    block7: {
                        this.isOpen = false;
                        try {
                            this.connectionManager.close();
                        }
                        catch (Throwable e) {
                            if (!LOG.isLoggable(Level.FINE)) break block7;
                            LOG.fine("error occured by closing acceptor " + DataConverter.toString(e));
                        }
                    }
                    this.connectionManager = null;
                    try {
                        this.acceptor.close();
                    }
                    catch (Throwable e) {
                        if (!LOG.isLoggable(Level.FINE)) break block8;
                        LOG.fine("error occured by closing acceptor " + DataConverter.toString(e));
                    }
                }
                this.acceptor = null;
                try {
                    this.onClosed();
                }
                catch (Throwable e) {
                    if (!LOG.isLoggable(Level.FINE)) break block9;
                    LOG.fine("error occured by performing onClosed method " + DataConverter.toString(e));
                }
            }
            this.handlerAdapter = null;
        }
    }

    protected void onClosed() throws IOException {
    }

    final IoAcceptor getAcceptor() {
        return this.acceptor;
    }

    final long getConnectionManagerWatchDogPeriodMillis() {
        return this.connectionManager.getWatchDogPeriodMillis();
    }

    final int getConnectionManagerWatchDogRuns() {
        return this.connectionManager.getWatchDogRuns();
    }

    @Override
    public final void addListener(IServerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public final boolean removeListener(IServerListener listener) {
        boolean result = this.listeners.remove(listener);
        return result;
    }

    @Override
    public final Executor getWorkerpool() {
        return this.workerpool;
    }

    @Override
    public final void setWorkerpool(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor has to be set");
        }
        if (this.isOpen) {
            LOG.warning("server is already running");
        }
        this.workerpool = executor;
        if (this.defaultWorkerPool != null) {
            this.defaultWorkerPool.shutdown();
            this.defaultWorkerPool = null;
        }
    }

    @Override
    public final boolean isOpen() {
        return this.isOpen;
    }

    public final void setMaxConcurrentConnections(int maxConcurrentConnections) {
        this.maxConcurrentConnections = maxConcurrentConnections;
        this.checkMaxSize();
    }

    public void setMaxReadBufferThreshold(int maxSize) {
        this.maxReadBufferThreshold = maxSize;
    }

    private void checkMaxSize() {
        if (this.maxConcurrentConnections != Integer.MAX_VALUE) {
            if (this.connectionManager.getSize() >= this.maxConcurrentConnections) {
                this.acceptor.setAccepting(false);
            } else {
                this.acceptor.setAccepting(true);
            }
        }
    }

    int getMaxConcurrentConnections() {
        return this.maxConcurrentConnections;
    }

    @Override
    public final int getLocalPort() {
        return this.acceptor.getLocalPort();
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.acceptor.getLocalAddress();
    }

    final int getNumberOfOpenConnections() {
        return this.connectionManager.getSize();
    }

    final int getDispatcherPoolSize() {
        return this.acceptor.getDispatcherSize();
    }

    final void setDispatcherPoolSize(int size) {
        this.acceptor.setDispatcherSize(size);
    }

    final boolean getReceiveBufferIsDirect() {
        return this.acceptor.getReceiveBufferIsDirect();
    }

    final void setReceiveBufferIsDirect(boolean isDirect) {
        this.acceptor.setReceiveBufferIsDirect(isDirect);
    }

    final Integer getReceiveBufferPreallocatedMinSize() {
        if (this.acceptor.isReceiveBufferPreallocationMode()) {
            return this.acceptor.getReceiveBufferPreallocatedMinSize();
        }
        return null;
    }

    public Set<INonBlockingConnection> getOpenConnections() {
        HashSet<INonBlockingConnection> cons = new HashSet<INonBlockingConnection>();
        if (this.connectionManager != null) {
            for (NonBlockingConnection con : this.connectionManager.getConnections()) {
                if (!con.isOpen()) continue;
                cons.add(con);
            }
        }
        return cons;
    }

    final List<String> getOpenConnectionInfos() {
        ArrayList<String> infos = new ArrayList<String>();
        for (NonBlockingConnection con : this.connectionManager.getConnections()) {
            infos.add(con.toDetailedString());
        }
        return infos;
    }

    final int getNumberOfIdleTimeouts() {
        return this.connectionManager.getNumberOfIdleTimeouts();
    }

    final int getNumberOfConnectionTimeouts() {
        return this.connectionManager.getNumberOfConnectionTimeouts();
    }

    final Date getStartUPDate() {
        return new Date(this.startUpTime);
    }

    @Override
    public final IConnection.FlushMode getFlushmode() {
        return this.flushMode;
    }

    @Override
    public final void setFlushmode(IConnection.FlushMode flusmode) {
        this.flushMode = flusmode;
    }

    @Override
    public final void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    @Override
    public final boolean getAutoflush() {
        return this.autoflush;
    }

    @Override
    public final void setConnectionTimeoutMillis(long timeoutMillis) {
        this.connectionTimeoutMillis = timeoutMillis;
    }

    @Override
    public void setWriteTransferRate(int bytesPerSecond) throws IOException {
        if (bytesPerSecond != Integer.MAX_VALUE && this.flushMode != IConnection.FlushMode.ASYNC) {
            LOG.warning("setWriteTransferRate is only supported for FlushMode ASYNC. Ignore update of the transfer rate");
            return;
        }
        this.writeRate = bytesPerSecond;
    }

    @Override
    public void setIdleTimeoutMillis(long timeoutMillis) {
        this.idleTimeoutMillis = timeoutMillis;
    }

    @Override
    public final long getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    @Override
    public final long getIdleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    public String getImplementationVersion() {
        return implementationVersion;
    }

    public String getImplementationDate() {
        if (implementationDate == null) {
            implementationDate = ConnectionUtils.getImplementationDate();
        }
        return implementationDate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getServerName() + " on " + this.getLocalAddress().toString() + " Port " + this.getLocalPort());
        sb.append("\r\nopen connections:");
        for (NonBlockingConnection con : this.connectionManager.getConnections()) {
            sb.append("\r\n  " + con.toString());
        }
        return sb.toString();
    }

    static {
        SIZE_WORKER_POOL = Integer.parseInt(System.getProperty("org.xsocket.connection.server.workerpoolSize", "100"));
        MIN_SIZE_WORKER_POOL = Integer.parseInt(System.getProperty("org.xsocket.connection.server.workerpoolMinSize", "4"));
        TASK_QUEUE_SIZE = Integer.parseInt(System.getProperty("org.xsocket.connection.server.taskqueuesize", Integer.toString(SIZE_WORKER_POOL)));
    }

    private static final class WorkerpoolCloser
    extends Thread {
        private Server server;

        public WorkerpoolCloser(Server server) {
            super("workerpoolCloser");
            this.setDaemon(true);
            this.server = server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            try {
                this.server.defaultWorkerPool.shutdownNow();
            }
            finally {
                this.server.defaultWorkerPool = null;
                this.server = null;
            }
        }
    }

    private final class LifeCycleHandler
    implements IIoAcceptorCallback {
        private LifeCycleHandler() {
        }

        public void onConnected() {
            Server.this.isOpen = true;
            for (IServerListener listener : (ArrayList)Server.this.listeners.clone()) {
                listener.onInit();
            }
            if (Server.this.acceptor.isSSLSupported()) {
                if (Server.this.acceptor.isSSLOn()) {
                    LOG.info(Server.this.name + " listening on " + Server.this.localHostname + ":" + Server.this.localPort + " - SSL (" + Server.this.startUpLogMessage + ")");
                } else {
                    LOG.info(Server.this.name + " listening on " + Server.this.localHostname + ":" + Server.this.localPort + " - activatable SSL (" + Server.this.startUpLogMessage + ")");
                }
            } else {
                LOG.info(Server.this.name + " listening on " + Server.this.localHostname + ":" + Server.this.localPort + " (" + Server.this.startUpLogMessage + ")");
            }
        }

        public void onDisconnected() {
            Server.this.callCurrentHandlerOnDestroy();
            for (IServerListener listener : (ArrayList)Server.this.listeners.clone()) {
                try {
                    listener.onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("exception occured by destroying " + listener + " " + ioe.toString());
                }
            }
            Server.this.listeners.clear();
            if (Server.this.defaultWorkerPool != null) {
                WorkerpoolCloser workerpoolCloser = new WorkerpoolCloser(Server.this);
                workerpoolCloser.start();
            }
            Server.this.workerpool = null;
            LOG.info("server (" + Server.this.localHostname + ":" + Server.this.localPort + ") has been shutdown");
        }

        public void onConnectionAccepted(IoChainableHandler ioHandler) throws IOException {
            NonBlockingConnection connection = new NonBlockingConnection(Server.this.connectionManager, Server.this.handlerAdapter.getConnectionInstance());
            connection.setAutoflush(Server.this.autoflush);
            connection.setFlushmode(Server.this.flushMode);
            connection.setWorkerpool(Server.this.workerpool);
            connection.init(ioHandler);
            connection.setIdleTimeoutMillis(Server.this.idleTimeoutMillis);
            connection.setConnectionTimeoutMillis(Server.this.connectionTimeoutMillis);
            if (Server.this.writeRate != null) {
                connection.setWriteTransferRate(Server.this.writeRate);
            }
            if (Server.this.maxReadBufferThreshold != null) {
                connection.setMaxReadBufferThreshold(Server.this.maxReadBufferThreshold);
            }
        }
    }

    private final class SizeHandler
    implements ConnectionManager.ISizeListener {
        private SizeHandler() {
        }

        public void sizeChanged() {
            Server.this.checkMaxSize();
        }
    }

    private static final class ShutdownHookHandler
    extends Thread {
        private Runtime runtime;
        private Server server;

        public ShutdownHookHandler(Server server) {
            this.server = server;
        }

        void register() {
            this.runtime = Runtime.getRuntime();
            this.runtime.addShutdownHook(this);
        }

        public void run() {
            if (this.server != null) {
                this.server.close();
            }
        }

        void deregister() {
            if (this.runtime != null) {
                block3: {
                    try {
                        this.runtime.removeShutdownHook(this);
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block3;
                        LOG.fine("error occured by derigistering shutdwon hook " + e.toString());
                    }
                }
                this.runtime = null;
                this.server = null;
            }
        }
    }
}

