/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.ExtendedClosedChannelException;
import org.xsocket.connection.IBlockingConnection;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.IUnsynchronized;
import org.xsocket.connection.IWriteCompletionHandler;
import org.xsocket.connection.NonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingConnection
implements IBlockingConnection {
    private static final Logger LOG = Logger.getLogger(BlockingConnection.class.getName());
    public static final String READ_TIMEOUT_KEY = "org.xsocket.connection.readtimeoutMillis";
    public static final int DEFAULT_TIMEOUT = Integer.parseInt(System.getProperty("org.xsocket.connection.readtimeoutMillis", Integer.toString(Integer.MAX_VALUE)));
    private final ReadNotificationHandler handler = new ReadNotificationHandler();
    private final Object readGuard = new Object();
    private final INonBlockingConnection delegate;
    private int readTimeout = DEFAULT_TIMEOUT;
    private AtomicBoolean disconnected = new AtomicBoolean(false);
    private AtomicBoolean idleTimeout = new AtomicBoolean(false);
    private AtomicBoolean connectionTimeout = new AtomicBoolean(false);

    public BlockingConnection(String hostname, int port) throws IOException {
        this(new InetSocketAddress(hostname, port), null, true, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false);
    }

    public BlockingConnection(String hostname, int port, Map<String, Object> options) throws IOException {
        this(new InetSocketAddress(hostname, port), null, true, Integer.MAX_VALUE, options, null, false);
    }

    public BlockingConnection(InetAddress address, int port) throws IOException {
        this(address, port, Integer.MAX_VALUE, new HashMap<String, Object>(), null, false);
    }

    public BlockingConnection(InetAddress address, int port, int connectTimeoutMillis) throws IOException {
        this(new InetSocketAddress(address, port), null, true, connectTimeoutMillis, new HashMap<String, Object>(), null, false);
    }

    public BlockingConnection(InetAddress address, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), null, true, Integer.MAX_VALUE, new HashMap<String, Object>(), sslContext, sslOn);
    }

    public BlockingConnection(InetAddress address, int port, int connectTimeoutMillis, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), null, true, connectTimeoutMillis, new HashMap<String, Object>(), sslContext, sslOn);
    }

    public BlockingConnection(InetAddress address, int port, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), null, true, Integer.MAX_VALUE, options, sslContext, sslOn);
    }

    public BlockingConnection(InetAddress address, int port, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(address, port), null, true, connectTimeoutMillis, options, sslContext, sslOn);
    }

    public BlockingConnection(String hostname, int port, SSLContext sslContext, boolean sslOn) throws IOException {
        this(new InetSocketAddress(hostname, port), null, true, Integer.MAX_VALUE, new HashMap<String, Object>(), sslContext, sslOn);
    }

    public BlockingConnection(InetSocketAddress remoteAddress, InetSocketAddress localAddress, boolean waitForConnect, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        this.delegate = new NonBlockingConnection(remoteAddress, localAddress, (IHandler)this.handler, waitForConnect, connectTimeoutMillis, options, sslContext, sslOn);
    }

    public BlockingConnection(INonBlockingConnection delegate) throws IOException {
        this.delegate = delegate;
        delegate.setHandler(this.handler);
    }

    final INonBlockingConnection getDelegate() {
        return this.delegate;
    }

    @Override
    public void setReadTimeoutMillis(int timeout) throws IOException {
        this.readTimeout = timeout;
        int soTimeout = (Integer)this.delegate.getOption("SOL_SOCKET.SO_TIMEOUT");
        if (timeout > soTimeout) {
            this.delegate.setOption("SOL_SOCKET.SO_TIMEOUT", timeout);
        }
    }

    public void setReceiveTimeoutMillis(int timeout) throws IOException {
        this.setReadTimeoutMillis(timeout);
    }

    public final int getReceiveTimeoutMillis() throws IOException {
        return this.getReadTimeoutMillis();
    }

    @Override
    public int getReadTimeoutMillis() throws IOException {
        return this.readTimeout;
    }

    @Override
    public int getMaxReadBufferThreshold() {
        return this.delegate.getMaxReadBufferThreshold();
    }

    @Override
    public void setMaxReadBufferThreshold(int size) {
        this.delegate.setMaxReadBufferThreshold(size);
    }

    @Override
    public final void setEncoding(String defaultEncoding) {
        this.delegate.setEncoding(defaultEncoding);
    }

    @Override
    public final String getEncoding() {
        return this.delegate.getEncoding();
    }

    @Override
    public final boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public boolean isServerSide() {
        return this.delegate.isServerSide();
    }

    @Override
    public final void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public final void flush() throws ClosedChannelException, IOException, SocketTimeoutException {
        this.delegate.flush();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public final InetAddress getRemoteAddress() {
        return this.delegate.getRemoteAddress();
    }

    @Override
    public final int getRemotePort() {
        return this.delegate.getRemotePort();
    }

    @Override
    public final InetAddress getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    @Override
    public final int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    @Override
    public final int getPendingWriteDataSize() {
        return this.delegate.getPendingWriteDataSize();
    }

    public final void suspendRead() throws IOException {
        this.delegate.suspendReceiving();
    }

    public boolean isReadSuspended() {
        return this.delegate.isReceivingSuspended();
    }

    public final void resumeRead() throws IOException {
        this.delegate.resumeReceiving();
    }

    @Override
    public boolean isReceivingSuspended() {
        return this.delegate.isReceivingSuspended();
    }

    @Override
    public void resumeReceiving() throws IOException {
        this.delegate.resumeReceiving();
    }

    @Override
    public void suspendReceiving() throws IOException {
        this.delegate.suspendReceiving();
    }

    @Override
    public void setFlushmode(IConnection.FlushMode flushMode) {
        this.delegate.setFlushmode(flushMode);
    }

    @Override
    public IConnection.FlushMode getFlushmode() {
        return this.delegate.getFlushmode();
    }

    @Override
    public final void setOption(String name, Object value) throws IOException {
        this.delegate.setOption(name, value);
    }

    @Override
    public final Object getOption(String name) throws IOException {
        return this.delegate.getOption(name);
    }

    @Override
    public final Map<String, Class> getOptions() {
        return this.delegate.getOptions();
    }

    @Override
    public final void setIdleTimeoutMillis(long timeoutInMillis) {
        this.delegate.setIdleTimeoutMillis(timeoutInMillis);
    }

    @Override
    public final long getIdleTimeoutMillis() {
        return this.delegate.getIdleTimeoutMillis();
    }

    @Override
    public final void setConnectionTimeoutMillis(long timeoutMillis) {
        this.delegate.setConnectionTimeoutMillis(timeoutMillis);
    }

    @Override
    public final long getConnectionTimeoutMillis() {
        return this.delegate.getConnectionTimeoutMillis();
    }

    @Override
    public long getRemainingMillisToConnectionTimeout() {
        return this.delegate.getRemainingMillisToConnectionTimeout();
    }

    @Override
    public long getRemainingMillisToIdleTimeout() {
        return this.delegate.getRemainingMillisToIdleTimeout();
    }

    @Override
    public final void setAttachment(Object obj) {
        this.delegate.setAttachment(obj);
    }

    @Override
    public final Object getAttachment() {
        return this.delegate.getAttachment();
    }

    @Override
    public final void setAutoflush(boolean autoflush) {
        this.delegate.setAutoflush(autoflush);
    }

    @Override
    public final boolean isAutoflush() {
        return this.delegate.isAutoflush();
    }

    @Override
    public final void activateSecuredMode() throws IOException {
        this.delegate.activateSecuredMode();
    }

    @Override
    public void deactivateSecuredMode() throws IOException {
        this.delegate.deactivateSecuredMode();
    }

    @Override
    public boolean isSecure() {
        return this.delegate.isSecure();
    }

    @Override
    public final void markReadPosition() {
        this.delegate.markReadPosition();
    }

    @Override
    public final void markWritePosition() {
        this.delegate.markWritePosition();
    }

    @Override
    public void unread(ByteBuffer[] buffers) throws IOException {
        this.delegate.unread(buffers);
    }

    @Override
    public void unread(byte[] bytes) throws IOException {
        this.delegate.unread(bytes);
    }

    @Override
    public void unread(ByteBuffer buffer) throws IOException {
        this.delegate.unread(buffer);
    }

    @Override
    public void unread(String text) throws IOException {
        this.delegate.unread(text);
    }

    @Override
    public final int read(ByteBuffer buffer) throws IOException, ClosedChannelException {
        int size = buffer.remaining();
        if (size < 1) {
            return 0;
        }
        return (Integer)new ByteBufferReadTask(buffer).read();
    }

    private Integer getSize() {
        try {
            return this.delegate.available();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public final byte readByte() throws IOException, SocketTimeoutException {
        return (Byte)new ByteReadTask().read();
    }

    @Override
    public final short readShort() throws IOException, SocketTimeoutException {
        return (Short)new ShortReadTask().read();
    }

    @Override
    public final int readInt() throws IOException, SocketTimeoutException {
        return (Integer)new IntegerReadTask().read();
    }

    @Override
    public final long readLong() throws IOException, SocketTimeoutException {
        return (Long)new LongReadTask().read();
    }

    @Override
    public final double readDouble() throws IOException, SocketTimeoutException {
        return (Double)new DoubleReadTask().read();
    }

    @Override
    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, SocketTimeoutException {
        return this.readByteBufferByDelimiter(delimiter, this.getEncoding());
    }

    @Override
    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, MaxReadSizeExceededException, SocketTimeoutException {
        return this.readByteBufferByDelimiter(delimiter, this.getEncoding(), maxLength);
    }

    @Override
    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding) throws IOException, SocketTimeoutException {
        return this.readByteBufferByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    @Override
    public final ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, MaxReadSizeExceededException, SocketTimeoutException {
        return (ByteBuffer[])new ByteBuffersByDelimiterReadTask(delimiter, encoding, maxLength).read();
    }

    @Override
    public final ByteBuffer[] readByteBufferByLength(int length) throws IOException, SocketTimeoutException {
        if (length <= 0) {
            return new ByteBuffer[0];
        }
        return (ByteBuffer[])new ByteBuffersByLengthReadTask(length).read();
    }

    @Override
    public final byte[] readBytesByDelimiter(String delimiter) throws IOException, SocketTimeoutException {
        return this.readBytesByDelimiter(delimiter, this.getEncoding());
    }

    @Override
    public final byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, MaxReadSizeExceededException, SocketTimeoutException {
        return this.readBytesByDelimiter(delimiter, this.getEncoding(), maxLength);
    }

    @Override
    public final byte[] readBytesByDelimiter(String delimiter, String encoding) throws IOException, SocketTimeoutException {
        return this.readBytesByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    @Override
    public final byte[] readBytesByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, MaxReadSizeExceededException, SocketTimeoutException {
        return DataConverter.toBytes(this.readByteBufferByDelimiter(delimiter, encoding, maxLength));
    }

    @Override
    public final byte[] readBytesByLength(int length) throws IOException, SocketTimeoutException {
        return DataConverter.toBytes(this.readByteBufferByLength(length));
    }

    @Override
    public final String readStringByDelimiter(String delimiter) throws IOException, UnsupportedEncodingException, SocketTimeoutException {
        return this.readStringByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    @Override
    public final String readStringByDelimiter(String delimiter, int maxLength) throws IOException, UnsupportedEncodingException, MaxReadSizeExceededException, SocketTimeoutException {
        return this.readStringByDelimiter(delimiter, this.getEncoding(), maxLength);
    }

    @Override
    public final String readStringByDelimiter(String delimiter, String encoding) throws IOException, UnsupportedEncodingException, MaxReadSizeExceededException, SocketTimeoutException {
        return this.readStringByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    @Override
    public final String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, UnsupportedEncodingException, MaxReadSizeExceededException, SocketTimeoutException {
        return DataConverter.toString(this.readByteBufferByDelimiter(delimiter, encoding, maxLength), encoding);
    }

    @Override
    public final String readStringByLength(int length) throws IOException, UnsupportedEncodingException, SocketTimeoutException {
        return this.readStringByLength(length, this.getEncoding());
    }

    @Override
    public final String readStringByLength(int length, String encoding) throws IOException, UnsupportedEncodingException, SocketTimeoutException {
        return DataConverter.toString(this.readByteBufferByLength(length), encoding);
    }

    @Override
    public final long transferTo(WritableByteChannel target, int length) throws IOException, SocketTimeoutException {
        ByteBuffer[] buffers;
        long written = 0L;
        for (ByteBuffer buffer : buffers = this.readByteBufferByLength(length)) {
            written += (long)target.write(buffer);
        }
        return written;
    }

    @Override
    public final boolean resetToWriteMark() {
        return this.delegate.resetToWriteMark();
    }

    @Override
    public final boolean resetToReadMark() {
        return this.delegate.resetToReadMark();
    }

    @Override
    public final void removeReadMark() {
        this.delegate.removeReadMark();
    }

    @Override
    public final void removeWriteMark() {
        this.delegate.removeWriteMark();
    }

    @Override
    public final int write(byte b) throws IOException, BufferOverflowException {
        return this.delegate.write(b);
    }

    @Override
    public final int write(byte ... bytes) throws IOException {
        return this.delegate.write(bytes);
    }

    @Override
    public void write(byte[] bytes, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.delegate.write(bytes, writeCompletionHandler);
    }

    @Override
    public final int write(byte[] bytes, int offset, int length) throws IOException {
        return this.delegate.write(bytes, offset, length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.delegate.write(bytes, offset, length, writeCompletionHandler);
    }

    @Override
    public final int write(short s) throws IOException {
        return this.delegate.write(s);
    }

    @Override
    public final int write(int i) throws IOException {
        return this.delegate.write(i);
    }

    @Override
    public final int write(long l) throws IOException {
        return this.delegate.write(l);
    }

    @Override
    public final int write(double d) throws IOException {
        return this.delegate.write(d);
    }

    @Override
    public final int write(String message) throws IOException {
        return this.delegate.write(message);
    }

    @Override
    public final int write(String message, String encoding) throws IOException {
        return this.delegate.write(message, encoding);
    }

    @Override
    public void write(String message, String encoding, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.delegate.write(message, encoding, writeCompletionHandler);
    }

    public final long write(ArrayList<ByteBuffer> buffers) throws IOException {
        return this.delegate.write(buffers);
    }

    @Override
    public final long write(List<ByteBuffer> buffers) throws IOException {
        return this.delegate.write(buffers);
    }

    @Override
    public final long write(ByteBuffer[] buffers) throws IOException {
        return this.delegate.write(buffers);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.delegate.write(srcs, offset, length);
    }

    @Override
    public final int write(ByteBuffer buffer) throws IOException {
        return this.delegate.write(buffer);
    }

    @Override
    public void write(ByteBuffer buffer, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.delegate.write(buffer, writeCompletionHandler);
    }

    @Override
    public void write(ByteBuffer[] buffers, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.delegate.write(buffers, writeCompletionHandler);
    }

    @Override
    public void write(ByteBuffer[] srcs, int offset, int length, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.delegate.write(srcs, offset, length, writeCompletionHandler);
    }

    @Override
    public final long transferFrom(ReadableByteChannel source) throws IOException {
        return this.delegate.transferFrom(source);
    }

    @Override
    public void write(List<ByteBuffer> buffers, IWriteCompletionHandler writeCompletionHandler) throws IOException {
        this.delegate.write(buffers, writeCompletionHandler);
    }

    @Override
    public final long transferFrom(ReadableByteChannel source, int chunkSize) throws IOException {
        return this.delegate.transferFrom(source, chunkSize);
    }

    @Override
    public long transferFrom(FileChannel source) throws IOException {
        return this.delegate.transferFrom(source);
    }

    public String toString() {
        return this.delegate.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReadDataInserted() {
        Object object = this.readGuard;
        synchronized (object) {
            this.readGuard.notifyAll();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ReadTask<T> {
        private ReadTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final T read() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            long start = System.currentTimeMillis();
            long remainingTime = BlockingConnection.this.readTimeout;
            while (true) {
                int revision = BlockingConnection.this.delegate.getReadBufferVersion();
                try {
                    return this.doRead();
                }
                catch (BufferUnderflowException bue) {
                    long elpased;
                    Object object = BlockingConnection.this.readGuard;
                    synchronized (object) {
                        if (revision == BlockingConnection.this.delegate.getReadBufferVersion()) {
                            if (BlockingConnection.this.disconnected.get()) {
                                throw new ExtendedClosedChannelException("channel " + BlockingConnection.this.getId() + " is closed (read buffer size=" + BlockingConnection.this.getSize() + ")");
                            }
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("waiting for more reveived data (guard: " + BlockingConnection.this.readGuard + ")");
                            }
                            try {
                                BlockingConnection.this.readGuard.wait(remainingTime);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        continue;
                    }
                    if ((remainingTime -= (elpased = System.currentTimeMillis() - start)) > 0L) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("receive timeout " + BlockingConnection.this.readTimeout + " sec reached. throwing timeout exception");
                    }
                    throw new SocketTimeoutException("timeout " + BlockingConnection.this.readTimeout + " millis reached");
                }
                break;
            }
        }

        abstract T doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException;
    }

    final class ReadNotificationHandler
    implements IDataHandler,
    IDisconnectHandler,
    IConnectionTimeoutHandler,
    IIdleTimeoutHandler,
    IUnsynchronized {
        ReadNotificationHandler() {
        }

        public boolean onData(INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
            BlockingConnection.this.onReadDataInserted();
            return true;
        }

        public boolean onDisconnect(INonBlockingConnection connection) throws IOException {
            BlockingConnection.this.disconnected.set(true);
            BlockingConnection.this.onReadDataInserted();
            return true;
        }

        public boolean onConnectionTimeout(INonBlockingConnection connection) throws IOException {
            BlockingConnection.this.connectionTimeout.set(true);
            BlockingConnection.this.onReadDataInserted();
            connection.close();
            return true;
        }

        public boolean onIdleTimeout(INonBlockingConnection connection) throws IOException {
            BlockingConnection.this.idleTimeout.set(true);
            BlockingConnection.this.onReadDataInserted();
            connection.close();
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ByteBuffersByLengthReadTask
    extends ReadTask<ByteBuffer[]> {
        private final int length;

        public ByteBuffersByLengthReadTask(int length) {
            this.length = length;
        }

        @Override
        ByteBuffer[] doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            return BlockingConnection.this.delegate.readByteBufferByLength(this.length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ByteBuffersByDelimiterReadTask
    extends ReadTask<ByteBuffer[]> {
        private final String delimiter;
        private final String encoding;
        private final int maxLength;

        public ByteBuffersByDelimiterReadTask(String delimiter, String encoding, int maxLength) {
            this.delimiter = delimiter;
            this.encoding = encoding;
            this.maxLength = maxLength;
        }

        @Override
        ByteBuffer[] doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            return BlockingConnection.this.delegate.readByteBufferByDelimiter(this.delimiter, this.encoding, this.maxLength);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DoubleReadTask
    extends ReadTask<Double> {
        private DoubleReadTask() {
        }

        @Override
        Double doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            return BlockingConnection.this.delegate.readDouble();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LongReadTask
    extends ReadTask<Long> {
        private LongReadTask() {
        }

        @Override
        Long doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            return BlockingConnection.this.delegate.readLong();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IntegerReadTask
    extends ReadTask<Integer> {
        private IntegerReadTask() {
        }

        @Override
        Integer doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            return BlockingConnection.this.delegate.readInt();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ShortReadTask
    extends ReadTask<Short> {
        private ShortReadTask() {
        }

        @Override
        Short doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            return BlockingConnection.this.delegate.readShort();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ByteReadTask
    extends ReadTask<Byte> {
        private ByteReadTask() {
        }

        @Override
        Byte doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            return BlockingConnection.this.delegate.readByte();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ByteBufferReadTask
    extends ReadTask<Integer> {
        private final ByteBuffer buffer;

        public ByteBufferReadTask(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        Integer doRead() throws IOException, SocketTimeoutException, MaxReadSizeExceededException {
            int read;
            int availableSize = BlockingConnection.this.delegate.available();
            if (availableSize > 0 && (read = BlockingConnection.this.delegate.read(this.buffer)) > 0) {
                return read;
            }
            if (availableSize == -1) {
                BlockingConnection.this.delegate.read(ByteBuffer.allocate(0));
            }
            if (!BlockingConnection.this.isOpen()) {
                return -1;
            }
            throw new BufferUnderflowException();
        }
    }
}

