/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.SocketTimeoutException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.connection.ExtendedClosedChannelException;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.ReadQueue;
import org.xsocket.connection.WriteQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNonBlockingStream
implements WritableByteChannel,
Closeable {
    private static final Logger LOG = Logger.getLogger(AbstractNonBlockingStream.class.getName());
    private final ReadQueue readQueue = new ReadQueue();
    private final WriteQueue writeQueue = new WriteQueue();
    static final int TRANSFER_BYTE_BUFFER_MAX_MAP_SIZE = IoProvider.getTransferByteBufferMaxSize();
    private final AtomicReference<String> defaultEncodingRef = new AtomicReference<String>("UTF-8");
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private final AtomicBoolean autoflush = new AtomicBoolean(true);
    private final AtomicReference<IConnection.FlushMode> flushmodeRef = new AtomicReference<IConnection.FlushMode>(IConnection.DEFAULT_FLUSH_MODE);
    private AtomicReference<Object> attachmentRef = new AtomicReference<Object>(null);
    private boolean isSuppressReuseBufferWarning = IoProvider.getSuppressReuseBufferWarning();
    private WeakReference<ByteBuffer> previousWriteByteBuffer;
    private WeakReference<ByteBuffer[]> previousWriteByteBuffers;
    private WeakReference<ByteBuffer[]> previousWriteByteBuffers2;

    @Override
    public void close() throws IOException {
        this.isOpen.set(false);
    }

    private void closeSilence() {
        block2: {
            try {
                this.close();
            }
            catch (IOException ioe) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by closing connection " + this + " " + ioe.toString());
            }
        }
    }

    public final void setAttachment(Object obj) {
        this.attachmentRef.set(obj);
    }

    public final Object getAttachment() {
        return this.attachmentRef.get();
    }

    public final void setEncoding(String defaultEncoding) {
        this.defaultEncodingRef.set(defaultEncoding);
    }

    public final String getEncoding() {
        return this.defaultEncodingRef.get();
    }

    public void setFlushmode(IConnection.FlushMode flushMode) {
        this.flushmodeRef.set(flushMode);
    }

    public final IConnection.FlushMode getFlushmode() {
        return this.flushmodeRef.get();
    }

    protected final void setSuppressReuseBufferWarning(boolean isSuppressReuseBufferWarning) {
        this.isSuppressReuseBufferWarning = isSuppressReuseBufferWarning;
    }

    protected final boolean isSuppressReuseBufferWarning() {
        return this.isSuppressReuseBufferWarning;
    }

    protected int getWriteTransferChunkeSize() {
        return 8196;
    }

    public final void setAutoflush(boolean autoflush) {
        this.autoflush.set(autoflush);
    }

    public final boolean isAutoflush() {
        return this.autoflush.get();
    }

    protected abstract boolean isMoreInputDataExpected();

    protected abstract boolean isDataWriteable();

    public int indexOf(String str) throws IOException, ClosedChannelException {
        return this.indexOf(str, this.getEncoding());
    }

    public int indexOf(String str, String encoding) throws IOException, ClosedChannelException {
        this.ensureStreamIsOpen();
        return this.readQueue.retrieveIndexOf(str.getBytes(encoding), Integer.MAX_VALUE);
    }

    public int available() {
        if (!this.isOpen.get()) {
            return -1;
        }
        int size = this.readQueue.getSize();
        if (size == 0) {
            if (this.isMoreInputDataExpected()) {
                return 0;
            }
            return -1;
        }
        return size;
    }

    protected int getReadQueueSize() {
        return this.readQueue.getSize();
    }

    public int getReadBufferVersion() {
        return this.readQueue.geVersion();
    }

    protected ByteBuffer[] onRead(ByteBuffer[] readBufs) throws IOException {
        return readBufs;
    }

    public void unread(ByteBuffer[] buffers) throws IOException {
        if (buffers == null || buffers.length == 0) {
            return;
        }
        this.readQueue.unread(buffers);
    }

    public void unread(ByteBuffer buffer) throws IOException {
        if (buffer == null) {
            return;
        }
        this.unread(new ByteBuffer[]{buffer});
    }

    public void unread(byte[] bytes) throws IOException {
        this.unread(ByteBuffer.wrap(bytes));
    }

    public void unread(String text) throws IOException {
        this.unread(DataConverter.toByteBuffer(text, this.getEncoding()));
    }

    public byte readByte() throws IOException, BufferUnderflowException, ClosedChannelException {
        return this.readSingleByteBuffer(1).get();
    }

    public short readShort() throws IOException, BufferUnderflowException, ClosedChannelException {
        return this.readSingleByteBuffer(2).getShort();
    }

    public int readInt() throws IOException, BufferUnderflowException, ClosedChannelException {
        return this.readSingleByteBuffer(4).getInt();
    }

    public long readLong() throws IOException, BufferUnderflowException, ClosedChannelException {
        return this.readSingleByteBuffer(8).getLong();
    }

    public double readDouble() throws IOException, BufferUnderflowException, ClosedChannelException {
        return this.readSingleByteBuffer(8).getDouble();
    }

    public int read(ByteBuffer buffer) throws IOException, ClosedChannelException {
        this.ensureStreamIsOpen();
        int size = buffer.remaining();
        int available = this.available();
        if (available == 0 && !this.isMoreInputDataExpected()) {
            this.closeSilence();
            return -1;
        }
        if (available < size) {
            size = available;
        }
        if (size > 0) {
            this.copyBuffers(this.readByteBufferByLength(size), buffer);
        }
        if (size == -1) {
            this.closeSilence();
        }
        return size;
    }

    private void copyBuffers(ByteBuffer[] source, ByteBuffer target) {
        for (ByteBuffer buf : source) {
            if (!buf.hasRemaining()) continue;
            target.put(buf);
        }
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, BufferUnderflowException, ClosedChannelException {
        return this.readByteBufferByDelimiter(delimiter, this.getEncoding());
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException, ClosedChannelException {
        return this.readByteBufferByDelimiter(delimiter, this.getEncoding(), maxLength);
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException, ClosedChannelException {
        return this.readByteBufferByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException, ClosedChannelException {
        this.ensureStreamIsOpen();
        int version = this.getReadBufferVersion();
        try {
            ByteBuffer[] buffers = this.readQueue.readByteBufferByDelimiter(delimiter.getBytes(encoding), maxLength);
            return this.onRead(buffers);
        }
        catch (MaxReadSizeExceededException mre) {
            if (this.isMoreInputDataExpected()) {
                throw mre;
            }
            this.closeSilence();
            throw new ClosedChannelException();
        }
        catch (BufferUnderflowException bue) {
            if (this.isMoreInputDataExpected() || version != this.getReadBufferVersion()) {
                throw bue;
            }
            this.closeSilence();
            throw new ExtendedClosedChannelException("channel is closed (read buffer size=" + this.readQueue.getSize() + ")");
        }
    }

    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, BufferUnderflowException, ClosedChannelException {
        this.ensureStreamIsOpen();
        if (length <= 0) {
            if (!this.isMoreInputDataExpected()) {
                this.closeSilence();
                throw new ClosedChannelException();
            }
            return this.onRead(new ByteBuffer[0]);
        }
        int version = this.getReadBufferVersion();
        try {
            ByteBuffer[] buffers = this.readQueue.readByteBufferByLength(length);
            return this.onRead(buffers);
        }
        catch (BufferUnderflowException bue) {
            if (this.isMoreInputDataExpected() || version != this.getReadBufferVersion()) {
                throw bue;
            }
            this.closeSilence();
            throw new ClosedChannelException();
        }
    }

    public byte[] readBytesByDelimiter(String delimiter) throws IOException, BufferUnderflowException, ClosedChannelException {
        return this.readBytesByDelimiter(delimiter, this.getEncoding());
    }

    public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException, ClosedChannelException {
        return this.readBytesByDelimiter(delimiter, this.getEncoding(), maxLength);
    }

    public byte[] readBytesByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException, ClosedChannelException {
        return this.readBytesByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    public byte[] readBytesByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException, ClosedChannelException {
        return DataConverter.toBytes(this.readByteBufferByDelimiter(delimiter, encoding, maxLength));
    }

    public byte[] readBytesByLength(int length) throws IOException, BufferUnderflowException, ClosedChannelException {
        return DataConverter.toBytes(this.readByteBufferByLength(length));
    }

    public String readStringByDelimiter(String delimiter) throws IOException, BufferUnderflowException, UnsupportedEncodingException, ClosedChannelException {
        return this.readStringByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException, ClosedChannelException {
        return this.readStringByDelimiter(delimiter, this.getEncoding(), maxLength);
    }

    public String readStringByDelimiter(String delimiter, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException, ClosedChannelException {
        return this.readStringByDelimiter(delimiter, encoding, Integer.MAX_VALUE);
    }

    public String readStringByDelimiter(String delimiter, String encoding, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException, ClosedChannelException {
        return DataConverter.toString(this.readByteBufferByDelimiter(delimiter, encoding, maxLength), encoding);
    }

    public String readStringByLength(int length) throws IOException, BufferUnderflowException, UnsupportedEncodingException, ClosedChannelException {
        return this.readStringByLength(length, this.getEncoding());
    }

    public String readStringByLength(int length, String encoding) throws IOException, BufferUnderflowException, UnsupportedEncodingException, ClosedChannelException {
        return DataConverter.toString(this.readByteBufferByLength(length), encoding);
    }

    public long transferTo(WritableByteChannel target, int length) throws IOException, ClosedChannelException, BufferUnderflowException, ClosedChannelException {
        if (length > 0) {
            ByteBuffer[] buffers;
            long written = 0L;
            int available = this.available();
            if (available < length) {
                length = available;
            }
            for (ByteBuffer buffer : buffers = this.readByteBufferByLength(length)) {
                while (buffer.hasRemaining()) {
                    written += (long)target.write(buffer);
                }
            }
            return written;
        }
        return 0L;
    }

    protected ByteBuffer readSingleByteBuffer(int length) throws IOException, ClosedChannelException, BufferUnderflowException, ClosedChannelException {
        this.ensureStreamIsOpen();
        int version = this.getReadBufferVersion();
        try {
            ByteBuffer buffer = this.readQueue.readSingleByteBuffer(length);
            return DataConverter.toByteBuffer(new ByteBuffer[]{buffer});
        }
        catch (BufferUnderflowException bue) {
            if (this.isMoreInputDataExpected() || version != this.getReadBufferVersion()) {
                throw bue;
            }
            this.closeSilence();
            throw new ClosedChannelException();
        }
    }

    public int write(byte b) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        this.writeQueue.append(DataConverter.toByteBuffer(b));
        this.onWriteDataInserted();
        return 1;
    }

    public int write(byte ... bytes) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        if (bytes.length > 0) {
            this.writeQueue.append(DataConverter.toByteBuffer(bytes));
            this.onWriteDataInserted();
            return bytes.length;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("warning length of byte array to send is 0");
        }
        return 0;
    }

    public int write(byte[] bytes, int offset, int length) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        if (bytes.length > 0) {
            ByteBuffer buffer = DataConverter.toByteBuffer(bytes, offset, length);
            int written = buffer.remaining();
            this.writeQueue.append(buffer);
            this.onWriteDataInserted();
            return written;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("warning length of buffer array to send is 0");
        }
        return 0;
    }

    public int write(short s) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        this.writeQueue.append(DataConverter.toByteBuffer(s));
        this.onWriteDataInserted();
        return 2;
    }

    public int write(int i) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        this.writeQueue.append(DataConverter.toByteBuffer(i));
        this.onWriteDataInserted();
        return 4;
    }

    public final int write(long l) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        this.writeQueue.append(DataConverter.toByteBuffer(l));
        this.onWriteDataInserted();
        return 8;
    }

    public int write(double d) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        this.writeQueue.append(DataConverter.toByteBuffer(d));
        this.onWriteDataInserted();
        return 8;
    }

    public int write(String message) throws IOException, BufferOverflowException, ClosedChannelException {
        return this.write(message, this.getEncoding());
    }

    public int write(String message, String encoding) throws IOException, BufferOverflowException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        ByteBuffer buffer = DataConverter.toByteBuffer(message, encoding);
        int written = buffer.remaining();
        this.writeQueue.append(buffer);
        this.onWriteDataInserted();
        return written;
    }

    public long write(List<ByteBuffer> buffers) throws IOException, BufferOverflowException, ClosedChannelException {
        if (buffers == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("warning buffer list to send is null");
            }
            return 0L;
        }
        return this.write(buffers.toArray(new ByteBuffer[buffers.size()]));
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException, ClosedChannelException {
        ByteBuffer[] previous;
        if (srcs == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("warning buffer array to send is null");
            }
            return 0L;
        }
        if (this.getFlushmode() == IConnection.FlushMode.ASYNC && this.previousWriteByteBuffers2 != null && (previous = (ByteBuffer[])this.previousWriteByteBuffers2.get()) != null && previous == srcs) {
            LOG.warning("reuse of the byte buffer by calling the write(ByteBuffer[], ...) method in FlushMode.ASYNC can lead to race conditions (Hint: use FlushMode.SYNC)");
        }
        long written = this.write(DataConverter.toByteBuffers(srcs, offset, length));
        if (this.flushmodeRef.get() == IConnection.FlushMode.ASYNC) {
            this.previousWriteByteBuffers2 = new WeakReference<ByteBuffer[]>(srcs);
        }
        return written;
    }

    public long write(ByteBuffer[] buffers) throws IOException, BufferOverflowException, ClosedChannelException {
        ByteBuffer[] previous;
        this.ensureStreamIsOpenAndWritable();
        if (!this.isSuppressReuseBufferWarning && this.getFlushmode() == IConnection.FlushMode.ASYNC && this.previousWriteByteBuffers != null && (previous = (ByteBuffer[])this.previousWriteByteBuffers.get()) != null && previous == buffers) {
            LOG.warning("reuse of the byte buffer by calling the write(ByteBuffer[]) method in FlushMode.ASYNC can lead to race conditions (Hint: use FlushMode.SYNC)");
        }
        if (buffers == null || buffers.length == 0) {
            return 0L;
        }
        long written = 0L;
        for (ByteBuffer buffer : buffers) {
            int size = buffer.remaining();
            if (size <= 0) continue;
            this.onPreWrite(size);
            this.writeQueue.append(buffer);
            written += (long)size;
            this.onWriteDataInserted();
        }
        if (this.flushmodeRef.get() == IConnection.FlushMode.ASYNC) {
            this.previousWriteByteBuffers = new WeakReference<ByteBuffer[]>(buffers);
        }
        return written;
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException, BufferOverflowException, ClosedChannelException {
        ByteBuffer previous;
        this.ensureStreamIsOpenAndWritable();
        if (!this.isSuppressReuseBufferWarning && this.getFlushmode() == IConnection.FlushMode.ASYNC && this.previousWriteByteBuffer != null && (previous = (ByteBuffer)this.previousWriteByteBuffer.get()) != null && previous == buffer) {
            LOG.warning("reuse of the byte buffer by calling the write(ByteBuffer) method in FlushMode.ASYNC can lead to race conditions (Hint: use FlushMode.SYNC or deactivate log out put by setting system property org.xsocket.connection.suppressReuseBufferWarning to true)");
        }
        if (buffer == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("warning buffer is null");
            }
            return 0;
        }
        int size = buffer.remaining();
        if (size > 0) {
            this.onPreWrite(size);
            this.writeQueue.append(buffer);
            this.onWriteDataInserted();
        }
        if (this.flushmodeRef.get() == IConnection.FlushMode.ASYNC) {
            this.previousWriteByteBuffer = new WeakReference<ByteBuffer>(buffer);
        }
        return size;
    }

    protected void onPreWrite(int size) throws BufferOverflowException {
    }

    public long transferFrom(FileChannel fileChannel) throws ClosedChannelException, IOException, SocketTimeoutException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        if (this.getFlushmode() == IConnection.FlushMode.SYNC) {
            long written;
            long size;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("tranfering file by using MappedByteBuffer (MAX_MAP_SIZE=" + TRANSFER_BYTE_BUFFER_MAX_MAP_SIZE + ")");
            }
            long remaining = size = fileChannel.size();
            long offset = 0L;
            long length = 0L;
            do {
                length = remaining > (long)TRANSFER_BYTE_BUFFER_MAX_MAP_SIZE ? (long)TRANSFER_BYTE_BUFFER_MAX_MAP_SIZE : remaining;
                MappedByteBuffer buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, offset, length);
                written = this.write(buffer);
                offset += written;
            } while ((remaining -= written) > 0L);
            return size;
        }
        return this.transferFrom((ReadableByteChannel)fileChannel);
    }

    public long transferFrom(ReadableByteChannel source) throws IOException, BufferOverflowException, ClosedChannelException {
        return this.transferFrom(source, TRANSFER_BYTE_BUFFER_MAX_MAP_SIZE);
    }

    public long transferFrom(ReadableByteChannel source, int chunkSize) throws IOException, BufferOverflowException, ClosedChannelException {
        return this.transfer(source, this, chunkSize);
    }

    private long transfer(ReadableByteChannel source, WritableByteChannel target, int chunkSize) throws IOException, ClosedChannelException {
        this.ensureStreamIsOpenAndWritable();
        long transfered = 0L;
        int read = 0;
        do {
            ByteBuffer transferBuffer;
            if ((read = source.read(transferBuffer = ByteBuffer.allocate(chunkSize))) <= 0) continue;
            if (transferBuffer.remaining() == 0) {
                transferBuffer.flip();
                target.write(transferBuffer);
            } else {
                transferBuffer.flip();
                target.write(transferBuffer.slice());
            }
            transfered += (long)read;
        } while (read > 0);
        return transfered;
    }

    public final void markReadPosition() {
        this.readQueue.markReadPosition();
    }

    public final void markWritePosition() {
        if (this.isAutoflush()) {
            throw new UnsupportedOperationException("write mark is only supported for mode autoflush off");
        }
        this.writeQueue.markWritePosition();
    }

    public final boolean resetToWriteMark() {
        return this.writeQueue.resetToWriteMark();
    }

    public final boolean resetToReadMark() {
        return this.readQueue.resetToReadMark();
    }

    public final void removeReadMark() {
        this.readQueue.removeReadMark();
    }

    public final void removeWriteMark() {
        this.writeQueue.removeWriteMark();
    }

    protected boolean reset() {
        this.readQueue.reset();
        this.writeQueue.reset();
        this.defaultEncodingRef.set("UTF-8");
        this.autoflush.set(true);
        this.flushmodeRef.set(IConnection.DEFAULT_FLUSH_MODE);
        this.attachmentRef.set(null);
        return true;
    }

    protected void onWriteDataInserted() throws IOException, ClosedChannelException {
    }

    protected final int getWriteBufferSize() {
        return this.writeQueue.getSize();
    }

    protected final boolean isWriteBufferEmpty() {
        return this.writeQueue.isEmpty();
    }

    protected ByteBuffer[] drainWriteQueue() {
        return this.writeQueue.drain();
    }

    protected ByteBuffer[] drainReadQueue() {
        return this.readQueue.readAvailable();
    }

    protected ByteBuffer[] copyReadQueue() {
        return this.readQueue.copyAvailable();
    }

    protected final boolean isReadBufferEmpty() {
        return this.readQueue.isEmpty();
    }

    protected final void appendDataToReadBuffer(ByteBuffer[] data, int size) {
        this.readQueue.append(data, size);
        this.onPostAppend();
    }

    protected void onPostAppend() {
    }

    protected final String printReadBuffer(String encoding) {
        return this.readQueue.toString(encoding);
    }

    protected final String printWriteBuffer(String encoding) {
        return this.writeQueue.toString(encoding);
    }

    private void ensureStreamIsOpen() throws ClosedChannelException {
        if (!this.isOpen.get()) {
            throw new ExtendedClosedChannelException("channel is closed (read buffer size=" + this.readQueue.getSize() + ")");
        }
    }

    private void ensureStreamIsOpenAndWritable() throws ClosedChannelException {
        if (!this.isOpen.get()) {
            throw new ExtendedClosedChannelException("could not write. Channel is closed (" + this.getInfo() + ")");
        }
        if (!this.isDataWriteable()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("is not writeable clsoing connection " + this.getInfo());
            }
            this.closeSilence();
            throw new ExtendedClosedChannelException("could not write. channel is close or not initialized (" + this.getInfo() + ")");
        }
    }

    protected String getInfo() {
        return "readBufferSize=" + this.readQueue.getSize();
    }

    public static interface ISource {
        public void reset();

        public int getVersion(boolean var1);

        public void setVersion(int var1);

        public int getSize();

        public void append(ByteBuffer[] var1, int var2);

        public void addFirst(ByteBuffer[] var1);

        public ByteBuffer[] drain();

        public ByteBuffer[] copy();

        public ByteBuffer readSingleByteBuffer(int var1) throws BufferUnderflowException;

        public ByteBuffer[] readByteBufferByLength(int var1) throws BufferUnderflowException;

        public ByteBuffer[] readByteBufferByDelimiter(byte[] var1, int var2) throws IOException, BufferUnderflowException, MaxReadSizeExceededException;

        public int retrieveIndexOf(byte[] var1, int var2) throws IOException, MaxReadSizeExceededException;

        public String toString(String var1);
    }

    public static interface ISink {
        public void reset();

        public boolean isEmpty();

        public int getSize();

        public void append(ByteBuffer var1);

        public void append(ByteBuffer[] var1);

        public ByteBuffer[] drain();

        public ByteBuffer[] copy();

        public String toString(String var1);
    }
}

