/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.SerializedTaskQueue;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IConnectExceptionHandler;
import org.xsocket.connection.IConnectHandler;
import org.xsocket.connection.IConnectionScoped;
import org.xsocket.connection.IConnectionTimeoutHandler;
import org.xsocket.connection.IDataHandler;
import org.xsocket.connection.IDisconnectHandler;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.IHandlerInfo;
import org.xsocket.connection.IIdleTimeoutHandler;
import org.xsocket.connection.INonBlockingConnection;

class HandlerAdapter {
    private static final Logger LOG = Logger.getLogger(HandlerAdapter.class.getName());
    private static final IHandler NULL_HANDLER = new NullHandler();
    private static final HandlerAdapter NULL_HANDLER_ADAPTER = new HandlerAdapter(NULL_HANDLER, ConnectionUtils.getHandlerInfo(NULL_HANDLER));
    private final IHandler handler;
    private final IHandlerInfo handlerInfo;

    HandlerAdapter(IHandler handler, IHandlerInfo handlerInfo) {
        this.handler = handler;
        this.handlerInfo = handlerInfo;
    }

    static HandlerAdapter newInstance(IHandler handler) {
        if (handler == null) {
            return NULL_HANDLER_ADAPTER;
        }
        IHandlerInfo handlerInfo = ConnectionUtils.getHandlerInfo(handler);
        return new HandlerAdapter(handler, handlerInfo);
    }

    final IHandler getHandler() {
        return this.handler;
    }

    final IHandlerInfo getHandlerInfo() {
        return this.handlerInfo;
    }

    private static String printHandler(Object handler) {
        return handler.getClass().getName() + "#" + handler.hashCode();
    }

    public boolean onConnect(INonBlockingConnection connection, SerializedTaskQueue taskQueue, Executor workerpool) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.handlerInfo.isConnectHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                HandlerAdapter.performOnConnect(connection, taskQueue, (IConnectHandler)this.handler);
            } else if (this.getHandlerInfo().isConnectHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnConnectTask(connection, taskQueue, (IConnectHandler)this.handler), workerpool);
            } else {
                taskQueue.performNonThreaded(new PerformOnConnectTask(connection, taskQueue, (IConnectHandler)this.handler), workerpool);
            }
        }
        return true;
    }

    private static boolean performOnConnect(INonBlockingConnection connection, SerializedTaskQueue taskQueue, IConnectHandler handler) {
        try {
            handler.onConnect(connection);
        }
        catch (MaxReadSizeExceededException mee) {
            LOG.warning("[" + connection.getId() + "] closing connection because max readsize is reached by handling onConnect by appHandler. " + HandlerAdapter.printHandler(handler) + " Reason: " + DataConverter.toString(mee));
            HandlerAdapter.closeSilence(connection);
        }
        catch (BufferUnderflowException bue) {
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnect by appHandler. " + HandlerAdapter.printHandler(handler) + " Reason: " + DataConverter.toString(ioe));
            }
            HandlerAdapter.closeSilence(connection);
        }
        catch (Throwable t) {
            LOG.warning("[" + connection.getId() + "] closing connection. Error occured by performing onConnect of " + HandlerAdapter.printHandler(handler) + " " + DataConverter.toString(t));
            HandlerAdapter.closeSilence(connection);
        }
        return false;
    }

    public boolean onData(INonBlockingConnection connection, SerializedTaskQueue taskQueue, Executor workerpool, boolean ignoreException, boolean isUnsynchronized) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        if (this.handlerInfo.isDataHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                HandlerAdapter.performOnData(connection, taskQueue, ignoreException, (IDataHandler)this.handler);
            } else if (this.getHandlerInfo().isDataHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnDataTask(connection, taskQueue, ignoreException, (IDataHandler)this.handler), workerpool);
            } else if (isUnsynchronized) {
                HandlerAdapter.performOnData(connection, taskQueue, ignoreException, (IDataHandler)this.handler);
            } else {
                taskQueue.performNonThreaded(new PerformOnDataTask(connection, taskQueue, ignoreException, (IDataHandler)this.handler), workerpool);
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + connection.getId() + "] assigned handler " + HandlerAdapter.printHandler(this.handler) + " is not a data handler");
        }
        return true;
    }

    private static void performOnData(INonBlockingConnection connection, SerializedTaskQueue taskQueue, boolean ignoreException, IDataHandler handler) {
        block12: {
            try {
                while (connection.available() != 0 && !connection.isReceivingSuspended()) {
                    if (connection.getHandler() != handler) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("[" + connection.getId() + "] handler " + " replaced by " + connection.getHandler() + ". stop handling data for old handler");
                        }
                        return;
                    }
                    int version = connection.getReadBufferVersion();
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + connection.getId() + "] calling onData method of handler " + HandlerAdapter.printHandler(handler));
                    }
                    handler.onData(connection);
                    if (version != connection.getReadBufferVersion()) continue;
                    return;
                }
            }
            catch (MaxReadSizeExceededException mee) {
                if (!ignoreException) {
                    LOG.warning("[" + connection.getId() + "] closing connection because max readsize is reached by handling onData by appHandler. " + HandlerAdapter.printHandler(handler) + " Reason: " + DataConverter.toString(mee));
                    HandlerAdapter.closeSilence(connection);
                }
            }
            catch (BufferUnderflowException bue) {
            }
            catch (IOException ioe) {
                if (!ignoreException) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling data by appHandler. " + HandlerAdapter.printHandler(handler) + " Reason: " + DataConverter.toString(ioe));
                    }
                    HandlerAdapter.closeSilence(connection);
                }
            }
            catch (Throwable t) {
                if (ignoreException) break block12;
                LOG.warning("[" + connection.getId() + "] closing connection. Error occured by performing onData of " + HandlerAdapter.printHandler(handler) + " " + DataConverter.toString(t));
                HandlerAdapter.closeSilence(connection);
            }
        }
    }

    public boolean onDisconnect(INonBlockingConnection connection, SerializedTaskQueue taskQueue, Executor workerpool, boolean isUnsynchronized) throws IOException {
        if (this.handlerInfo.isDisconnectHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                HandlerAdapter.performOnDisconnect(connection, taskQueue, (IDisconnectHandler)this.handler);
            } else if (this.getHandlerInfo().isDisconnectHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnDisconnectTask(connection, taskQueue, (IDisconnectHandler)this.handler), workerpool);
            } else if (isUnsynchronized) {
                HandlerAdapter.performOnDisconnect(connection, taskQueue, (IDisconnectHandler)this.handler);
            } else {
                taskQueue.performNonThreaded(new PerformOnDisconnectTask(connection, taskQueue, (IDisconnectHandler)this.handler), workerpool);
            }
        }
        return true;
    }

    private static void performOnDisconnect(INonBlockingConnection connection, SerializedTaskQueue taskQueue, IDisconnectHandler handler) {
        try {
            handler.onDisconnect(connection);
        }
        catch (MaxReadSizeExceededException mee) {
        }
        catch (BufferUnderflowException bue) {
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] io exception occured while performing onDisconnect multithreaded " + HandlerAdapter.printHandler(handler) + " " + DataConverter.toString(ioe));
            }
        }
        catch (Throwable t) {
            LOG.warning("[" + connection.getId() + "] Error occured by performing onDisconnect off " + HandlerAdapter.printHandler(handler) + " " + DataConverter.toString(t));
        }
    }

    public boolean onConnectException(INonBlockingConnection connection, SerializedTaskQueue taskQueue, Executor workerpool, IOException ioe) throws IOException {
        if (this.handlerInfo.isConnectExceptionHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                HandlerAdapter.performOnConnectException(connection, taskQueue, ioe, (IConnectExceptionHandler)this.handler);
            } else if (this.getHandlerInfo().isConnectExceptionHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnConnectExceptionTask(connection, taskQueue, ioe, (IConnectExceptionHandler)this.handler), workerpool);
            } else {
                taskQueue.performNonThreaded(new PerformOnConnectExceptionTask(connection, taskQueue, ioe, (IConnectExceptionHandler)this.handler), workerpool);
            }
        }
        return true;
    }

    private static boolean performOnConnectException(INonBlockingConnection connection, SerializedTaskQueue taskQueue, IOException ioe, IConnectExceptionHandler handler) throws IOException {
        try {
            return handler.onConnectException(connection, ioe);
        }
        catch (RuntimeException re) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onDisconnect by appHandler. " + HandlerAdapter.printHandler(handler) + " Reason: " + re.toString());
            }
            HandlerAdapter.closeSilence(connection);
            throw re;
        }
        catch (IOException e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection because an error has been occured by handling onDisconnect by appHandler. " + HandlerAdapter.printHandler(handler) + " Reason: " + ioe.toString());
            }
            HandlerAdapter.closeSilence(connection);
            throw ioe;
        }
    }

    public boolean onIdleTimeout(INonBlockingConnection connection, SerializedTaskQueue taskQueue, Executor workerpool) throws IOException {
        if (this.handlerInfo.isIdleTimeoutHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                HandlerAdapter.performOnIdleTimeout(connection, taskQueue, (IIdleTimeoutHandler)this.handler);
            } else if (this.getHandlerInfo().isIdleTimeoutHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnIdleTimeoutTask(connection, taskQueue, (IIdleTimeoutHandler)this.handler), workerpool);
            } else {
                taskQueue.performNonThreaded(new PerformOnIdleTimeoutTask(connection, taskQueue, (IIdleTimeoutHandler)this.handler), workerpool);
            }
        } else {
            HandlerAdapter.closeSilence(connection);
        }
        return true;
    }

    private static void performOnIdleTimeout(INonBlockingConnection connection, SerializedTaskQueue taskQueue, IIdleTimeoutHandler handler) {
        try {
            boolean isHandled = handler.onIdleTimeout(connection);
            if (!isHandled) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because idle timeout has been occured and timeout handler returns true)");
                }
                HandlerAdapter.closeSilence(connection);
            }
        }
        catch (MaxReadSizeExceededException mee) {
            LOG.warning("[" + connection.getId() + "] closing connection because max readsize is reached by handling onIdleTimeout by appHandler. " + HandlerAdapter.printHandler(handler) + " Reason: " + DataConverter.toString(mee));
            HandlerAdapter.closeSilence(connection);
        }
        catch (BufferUnderflowException bue) {
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + connection.getId() + "] closing connection. An IO exception occured while performing onIdleTimeout multithreaded " + HandlerAdapter.printHandler(handler) + " " + ioe.toString());
            }
            HandlerAdapter.closeSilence(connection);
        }
        catch (Throwable t) {
            LOG.warning("[" + connection.getId() + "] closing connection. Error occured by performing onIdleTimeout of " + HandlerAdapter.printHandler(handler) + " " + DataConverter.toString(t));
            HandlerAdapter.closeSilence(connection);
        }
    }

    public boolean onConnectionTimeout(INonBlockingConnection connection, SerializedTaskQueue taskQueue, Executor workerpool) throws IOException {
        if (this.handlerInfo.isConnectionTimeoutHandler()) {
            if (this.handlerInfo.isUnsynchronized()) {
                HandlerAdapter.performOnConnectionTimeout(connection, taskQueue, (IConnectionTimeoutHandler)this.handler);
            } else if (this.getHandlerInfo().isConnectionTimeoutHandlerMultithreaded()) {
                taskQueue.performMultiThreaded(new PerformOnConnectionTimeoutTask(connection, taskQueue, (IConnectionTimeoutHandler)this.handler), workerpool);
            } else {
                taskQueue.performNonThreaded(new PerformOnConnectionTimeoutTask(connection, taskQueue, (IConnectionTimeoutHandler)this.handler), workerpool);
            }
        } else {
            HandlerAdapter.closeSilence(connection);
        }
        return true;
    }

    private static void performOnConnectionTimeout(INonBlockingConnection connection, SerializedTaskQueue taskQueue, IConnectionTimeoutHandler handler) {
        try {
            boolean isHandled = handler.onConnectionTimeout(connection);
            if (!isHandled) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + connection.getId() + "] closing connection because connection timeout has been occured and timeout handler returns true)");
                }
                HandlerAdapter.closeSilence(connection);
            }
        }
        catch (MaxReadSizeExceededException mee) {
            LOG.warning("[" + connection.getId() + "] closing connection because max readsize hasbeen reached by handling onConnectionTimeout by appHandler. " + HandlerAdapter.printHandler(handler) + " Reason: " + DataConverter.toString(mee));
            HandlerAdapter.closeSilence(connection);
        }
        catch (BufferUnderflowException bue) {
        }
        catch (IOException ioe) {
            LOG.warning("[" + connection.getId() + "] closing connection because an error has been occured by handling onConnectionTimeout by appHandler. " + handler + " Reason: " + DataConverter.toString(ioe));
            HandlerAdapter.closeSilence(connection);
        }
        catch (Throwable t) {
            LOG.warning("[" + connection.getId() + "] closing connection. Error occured by performing onConnectionTimeout of " + HandlerAdapter.printHandler(handler) + " " + DataConverter.toString(t));
            HandlerAdapter.closeSilence(connection);
        }
    }

    public final void onInit() {
        if (this.handlerInfo.isLifeCycle()) {
            ((ILifeCycle)((Object)this.handler)).onInit();
        }
    }

    public final void onDestroy() {
        block3: {
            if (this.handlerInfo.isLifeCycle()) {
                try {
                    ((ILifeCycle)((Object)this.handler)).onDestroy();
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("exception occured by destroying " + HandlerAdapter.printHandler(this.handler) + " " + ioe.toString());
                }
            }
        }
    }

    HandlerAdapter getConnectionInstance() {
        if (this.handlerInfo.isConnectionScoped()) {
            try {
                IHandler hdlCopy = (IHandler)((IConnectionScoped)((Object)this.handler)).clone();
                return new HandlerAdapter(hdlCopy, this.handlerInfo);
            }
            catch (CloneNotSupportedException cnse) {
                throw new RuntimeException(cnse.toString());
            }
        }
        return this;
    }

    private static void closeSilence(INonBlockingConnection connection) {
        block2: {
            try {
                connection.close();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by closing connection " + connection + " " + e.toString());
            }
        }
    }

    @Execution(value=0)
    private static final class NullHandler
    implements IHandler {
        private NullHandler() {
        }
    }

    private static final class PerformOnConnectionTimeoutTask
    implements Runnable {
        private final IConnectionTimeoutHandler handler;
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;

        public PerformOnConnectionTimeoutTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue, IConnectionTimeoutHandler handler) {
            this.connection = connection;
            this.taskQueue = taskQueue;
            this.handler = handler;
        }

        public void run() {
            HandlerAdapter.performOnConnectionTimeout(this.connection, this.taskQueue, this.handler);
        }
    }

    private static final class PerformOnIdleTimeoutTask
    implements Runnable {
        private final IIdleTimeoutHandler handler;
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;

        public PerformOnIdleTimeoutTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue, IIdleTimeoutHandler handler) {
            this.connection = connection;
            this.taskQueue = taskQueue;
            this.handler = handler;
        }

        public void run() {
            HandlerAdapter.performOnIdleTimeout(this.connection, this.taskQueue, this.handler);
        }
    }

    private static final class PerformOnConnectExceptionTask
    implements Runnable {
        private final IConnectExceptionHandler handler;
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;
        private final IOException ioe;

        public PerformOnConnectExceptionTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue, IOException ioe, IConnectExceptionHandler handler) {
            this.connection = connection;
            this.taskQueue = taskQueue;
            this.ioe = ioe;
            this.handler = handler;
        }

        public void run() {
            try {
                HandlerAdapter.performOnConnectException(this.connection, this.taskQueue, this.ioe, this.handler);
            }
            catch (MaxReadSizeExceededException mee) {
                LOG.warning("[" + this.connection.getId() + "] closing connection because max readsize is reached by handling onConnectException by appHandler. " + HandlerAdapter.printHandler(this.handler) + " Reason: " + DataConverter.toString(mee));
                HandlerAdapter.closeSilence(this.connection);
            }
            catch (BufferUnderflowException bue) {
            }
            catch (IOException e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.connection.getId() + "] closing connection.  An io exception occured while performing onConnectException multithreaded " + HandlerAdapter.printHandler(this.handler) + " " + DataConverter.toString(e));
                }
                HandlerAdapter.closeSilence(this.connection);
            }
            catch (Throwable t) {
                LOG.warning("[" + this.connection.getId() + "] closing connection. Error occured by performing onConnectionException of " + HandlerAdapter.printHandler(this.handler) + " " + t.toString());
                HandlerAdapter.closeSilence(this.connection);
            }
        }
    }

    private static final class PerformOnDisconnectTask
    implements Runnable {
        private final IDisconnectHandler handler;
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;

        public PerformOnDisconnectTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue, IDisconnectHandler handler) {
            this.connection = connection;
            this.taskQueue = taskQueue;
            this.handler = handler;
        }

        public void run() {
            HandlerAdapter.performOnDisconnect(this.connection, this.taskQueue, this.handler);
        }

        public String toString() {
            return "PerformOnDisconnectTask#" + this.hashCode() + " " + this.connection.getId();
        }
    }

    private static final class PerformOnDataTask
    implements Runnable {
        private final IDataHandler handler;
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;
        private final boolean ignoreException;

        public PerformOnDataTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue, boolean ignoreException, IDataHandler handler) {
            this.connection = connection;
            this.taskQueue = taskQueue;
            this.ignoreException = ignoreException;
            this.handler = handler;
        }

        public void run() {
            HandlerAdapter.performOnData(this.connection, this.taskQueue, this.ignoreException, this.handler);
        }

        public String toString() {
            return "PerformOnDataTask#" + this.hashCode() + " " + this.connection.getId();
        }
    }

    private static final class PerformOnConnectTask
    implements Runnable {
        private final IConnectHandler handler;
        private final INonBlockingConnection connection;
        private final SerializedTaskQueue taskQueue;

        public PerformOnConnectTask(INonBlockingConnection connection, SerializedTaskQueue taskQueue, IConnectHandler handler) {
            this.connection = connection;
            this.taskQueue = taskQueue;
            this.handler = handler;
        }

        public void run() {
            HandlerAdapter.performOnConnect(this.connection, this.taskQueue, this.handler);
        }
    }
}

