/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.api;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.FileStructure;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.runtime.MainContainer;
import org.xvm.runtime.NativeContainer;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Runtime;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.text.xString;

public class Connector {
    protected final ModuleRepository f_repository;
    private final Runtime f_runtime;
    private final NativeContainer f_containerNative;
    private MainContainer m_containerMain;
    private boolean m_fStarted;

    public Connector(ModuleRepository repository) {
        this.f_repository = repository;
        this.f_runtime = new Runtime();
        this.f_containerNative = new NativeContainer(this.f_runtime, repository);
    }

    public void loadModule(String sAppName) {
        if (this.m_containerMain != null) {
            throw new IllegalStateException("Connector is already activated");
        }
        ModuleStructure moduleApp = this.f_repository.loadModule(sAppName);
        if (moduleApp == null) {
            throw new IllegalStateException("Unable to load module \"" + sAppName + "\"");
        }
        FileStructure structApp = this.f_containerNative.createFileStructure(moduleApp);
        ModuleConstant idMissing = structApp.linkModules(this.f_repository, true);
        if (idMissing != null) {
            throw new IllegalStateException("Unable to load module \"" + idMissing.getName() + "\"");
        }
        this.m_containerMain = new MainContainer(this.f_runtime, this.f_containerNative, structApp.getModuleId());
    }

    public ConstantPool getConstantPool() {
        return this.m_containerMain.getConstantPool();
    }

    public MainContainer getContainer() {
        return this.m_containerMain;
    }

    public void start(Map<String, String> mapInjections) {
        if (!this.m_fStarted) {
            this.f_runtime.start();
            this.m_fStarted = true;
        }
        this.m_containerMain.start(mapInjections);
    }

    public Set<MethodStructure> findMethods(String sMethodName) {
        return this.findMethods(this.m_containerMain.getModule(), sMethodName);
    }

    protected Set<MethodStructure> findMethods(ModuleConstant idModule, String sMethodName) {
        TypeInfo typeInfo = idModule.getType().ensureTypeInfo();
        Set<MethodConstant> setMethodId = typeInfo.findMethods(sMethodName, -1, TypeInfo.MethodKind.Any);
        HashSet<MethodStructure> setMethods = new HashSet<MethodStructure>();
        for (MethodConstant idMethod : setMethodId) {
            MethodInfo infoMethod = typeInfo.getMethodById(idMethod);
            setMethods.add(infoMethod.getHead().getMethodStructure());
        }
        return setMethods;
    }

    public void invoke0(MethodStructure method, String ... asArg) {
        if (!this.m_fStarted) {
            throw new IllegalStateException("The container has not been started");
        }
        ConstantPool pool = ConstantPool.getCurrentPool();
        TypeConstant typeStrings = pool.ensureArrayType(pool.typeString());
        ObjectHandle[] ahArg = Utils.OBJECTS_NONE;
        switch (method.getRequiredParamCount()) {
            case 0: {
                if (asArg == null) break;
                assert (method.getParamCount() > 0);
                TypeConstant typeArg = method.getParam(0).getType();
                assert (typeStrings.isA(typeArg));
                ahArg = new ObjectHandle[]{xString.makeArrayHandle(asArg)};
                break;
            }
            case 1: {
                TypeConstant typeArg = method.getParam(0).getType();
                assert (typeStrings.isA(typeArg));
                ahArg = new ObjectHandle[]{asArg == null ? xString.ensureEmptyArray() : xString.makeArrayHandle(asArg)};
                break;
            }
        }
        this.m_containerMain.invoke0(method.getName(), ahArg);
    }

    public int join() throws InterruptedException {
        do {
            Thread.sleep(500L);
        } while (!this.f_runtime.isIdle() || !this.m_containerMain.isIdle());
        int nResult = this.m_containerMain.getResult();
        this.m_containerMain = null;
        return nResult;
    }
}

