/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.constants.TypedefConstant;
import org.xvm.asm.constants.UnresolvedNameConstant;
import org.xvm.asm.constants.UnresolvedTypeConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;
import org.xvm.util.Severity;

public class Annotation
extends Constant {
    public static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private int m_iClass;
    private int[] m_aiParam;
    private Constant m_constClass;
    private Constant[] m_aParams;

    public Annotation(ConstantPool pool, Constant constClass, Constant[] aconstParam) {
        super(pool);
        if (constClass == null) {
            throw new IllegalArgumentException("annotation class required");
        }
        if (!(constClass instanceof ClassConstant) && !(constClass instanceof UnresolvedNameConstant)) {
            throw new IllegalArgumentException("annotation is not a class " + String.valueOf(constClass));
        }
        if (aconstParam != null) {
            Handy.checkElementsNonNull(aconstParam);
        }
        this.m_constClass = constClass;
        this.m_aParams = aconstParam == null ? Constant.NO_CONSTS : aconstParam;
    }

    public Annotation(ConstantPool pool, DataInput in) throws IOException {
        super(pool);
        this.m_iClass = Handy.readIndex(in);
        int cParams = Handy.readMagnitude(in);
        if (cParams > 0) {
            int[] aiParam = new int[cParams];
            for (int i = 0; i < cParams; ++i) {
                aiParam[i] = Handy.readIndex(in);
            }
            this.m_aiParam = aiParam;
        }
    }

    @Override
    protected void resolveConstants() {
        int cParams;
        ConstantPool pool = this.getConstantPool();
        this.m_constClass = pool.getConstant(this.m_iClass);
        assert (this.m_constClass instanceof ClassConstant);
        int n = cParams = this.m_aiParam == null ? 0 : this.m_aiParam.length;
        if (cParams == 0) {
            this.m_aParams = NO_CONSTS;
        } else {
            Constant[] aParams = new Constant[cParams];
            for (int i = 0; i < cParams; ++i) {
                aParams[i] = pool.getConstant(this.m_aiParam[i]);
            }
            this.m_aParams = aParams;
        }
    }

    public Constant getAnnotationClass() {
        Constant constClass;
        block4: {
            Constant resolved;
            block5: {
                constClass = this.m_constClass;
                resolved = constClass.resolve();
                if (resolved == constClass || resolved == null) break block4;
                if (!(resolved instanceof TypedefConstant)) break block5;
                TypedefConstant constTypedef = (TypedefConstant)resolved;
                TypeConstant typeRef = constTypedef.getReferredToType();
                if (!typeRef.isSingleUnderlyingClass(true)) break block4;
                resolved = typeRef.getSingleUnderlyingClass(true);
            }
            assert (constClass.getPosition() == -1);
            this.m_constClass = constClass = resolved;
        }
        return constClass;
    }

    public TypeConstant getAnnotationType() {
        Constant constAnno = this.getAnnotationClass();
        if (constAnno instanceof UnresolvedNameConstant) {
            UnresolvedNameConstant constUnresolved = (UnresolvedNameConstant)constAnno;
            UnresolvedTypeConstant typeUnresolved = new UnresolvedTypeConstant(this.getConstantPool(), constUnresolved);
            constUnresolved.addConsumer(constant -> typeUnresolved.resolve(constant.getType()));
            return typeUnresolved;
        }
        return constAnno.getType();
    }

    public TypeConstant getFormalType() {
        ClassConstant idAnno = (ClassConstant)this.getAnnotationClass();
        return ((ClassStructure)idAnno.getComponent()).getFormalType();
    }

    public Constant[] getParams() {
        return this.m_aParams;
    }

    public Annotation resolveParams(Constant[] aParams) {
        if (!Arrays.equals(aParams, this.m_aParams)) {
            if (this.isHashCached()) {
                return this.getConstantPool().ensureAnnotation(this.getAnnotationClass(), aParams);
            }
            this.m_aParams = aParams;
        }
        return this;
    }

    public boolean hasExplicitGetter() {
        ClassConstant clzAnno = (ClassConstant)this.getAnnotationClass();
        TypeInfo infoAnno = clzAnno.getType().ensureTypeInfo();
        Set<MethodConstant> setImpls = infoAnno.findMethods("get", 0, TypeInfo.MethodKind.Method);
        if (setImpls.isEmpty()) {
            return false;
        }
        MethodConstant idGet = setImpls.iterator().next();
        MethodInfo infoGet = infoAnno.getMethodById(idGet);
        return infoGet != null && !infoGet.getHead().isAbstract();
    }

    @Override
    public Constant.Format getFormat() {
        return Constant.Format.Annotation;
    }

    @Override
    public boolean containsUnresolved() {
        if (this.isHashCached()) {
            return false;
        }
        if (this.getAnnotationClass().containsUnresolved()) {
            return true;
        }
        for (Constant param : this.m_aParams) {
            if (!param.containsUnresolved()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachUnderlying(Consumer<Constant> visitor) {
        visitor.accept(this.getAnnotationClass());
        for (Constant param : this.m_aParams) {
            visitor.accept(param);
        }
    }

    @Override
    protected int compareDetails(Constant obj) {
        if (!(obj instanceof Annotation)) {
            return -1;
        }
        Annotation that = (Annotation)obj;
        int n = this.getAnnotationClass().compareTo(that.getAnnotationClass());
        if (n == 0) {
            Constant[] aThisParam = this.m_aParams;
            Constant[] aThatParam = that.m_aParams;
            int c = Math.min(aThisParam.length, aThatParam.length);
            for (int i = 0; i < c; ++i) {
                n = aThisParam[i].compareTo(aThatParam[i]);
                if (n == 0) continue;
                return n;
            }
            n = aThisParam.length - aThatParam.length;
        }
        return n;
    }

    @Override
    public String getValueString() {
        StringBuilder sb = new StringBuilder();
        sb.append('@').append(this.getAnnotationClass().getValueString());
        if (this.m_aParams.length > 0) {
            sb.append('(');
            boolean first = true;
            for (Constant param : this.m_aParams) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(param.getValueString());
            }
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    protected void markModified() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerConstants(ConstantPool pool) {
        this.m_constClass = pool.register(this.getAnnotationClass());
        assert (this.m_constClass instanceof ClassConstant);
        this.m_aParams = Annotation.registerConstants(pool, this.m_aParams);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
        Handy.writePackedLong(out, this.getAnnotationClass().getPosition());
        Handy.writePackedLong(out, this.m_aParams.length);
        for (Constant param : this.m_aParams) {
            Handy.writePackedLong(out, param.getPosition());
        }
    }

    @Override
    public boolean validate(ErrorListener errs) {
        boolean fHalt = super.validate(errs);
        if (this.getAnnotationType().getExplicitClassFormat() != Component.Format.ANNOTATION) {
            fHalt |= this.log(errs, Severity.ERROR, "VERIFY-27", this.getAnnotationClass().getValueString());
        }
        return fHalt;
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        int cParams = this.m_aParams.length;
        sb.append("class=").append(this.getAnnotationClass().getValueString()).append(", params=").append(cParams);
        if (cParams > 0) {
            sb.append(", values=(");
            for (int i = 0; i < cParams; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.m_aParams[i].getValueString());
            }
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public int computeHashCode() {
        return Hash.of(this.m_aParams, Hash.of(this.getAnnotationClass()));
    }
}

