/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.Register;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.ServiceContext;

public interface Argument {
    public TypeConstant getType();

    public boolean isStack();

    public boolean isEffectivelyFinal();

    public Argument registerConstants(Op.ConstantRegistry var1);

    public static String toIdString(Argument arg, int nArg) {
        if (arg instanceof Constant) {
            return ((Constant)arg).getValueString();
        }
        if (arg instanceof Register) {
            return ((Register)arg).getIdString();
        }
        try {
            ServiceContext context;
            if (nArg <= -16 && (context = ServiceContext.getCurrentContext()) != null) {
                return context.getCurrentFrame().localConstants()[Op.convertId(nArg)].getValueString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Register.getIdString(nArg);
    }
}

