/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.SimulatedLinkerContext;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.NamedCondition;
import org.xvm.asm.constants.PresentCondition;
import org.xvm.asm.constants.VersionConstant;
import org.xvm.asm.constants.VersionMatchesCondition;

public class AssemblerContext {
    private final ConstantPool m_pool;
    private final ArrayList<ConditionalConstant> m_listCondition = new ArrayList();
    private final ArrayList<Long> m_listIndicators = new ArrayList();
    private final ArrayList<SimulatedLinkerContext> m_listLinkerContexts = new ArrayList();
    private final Map<ConditionalConstant, SimulatedLinkerContext> m_mapContextCache = new HashMap<ConditionalConstant, SimulatedLinkerContext>();
    private long m_cMods;
    private long m_nIndicator;

    public AssemblerContext(ConstantPool pool) {
        assert (pool != null);
        this.m_pool = pool;
    }

    public void push(ConditionalConstant condition) {
        this.m_listCondition.add(condition);
        this.m_listLinkerContexts.add(null);
        if (this.m_listCondition.size() > this.m_listIndicators.size()) {
            this.m_listIndicators.add(this.m_nIndicator);
        }
        this.m_nIndicator = ++this.m_cMods;
    }

    public ConditionalConstant pop() {
        int cOldDepth = this.m_listCondition.size();
        if (cOldDepth == 0) {
            return null;
        }
        int cNewDepth = cOldDepth - 1;
        ConditionalConstant condition = this.m_listCondition.remove(cNewDepth);
        this.m_listLinkerContexts.remove(cNewDepth);
        int cIndicators = this.m_listIndicators.size();
        if (cOldDepth > cIndicators) {
            this.m_listIndicators.remove(--cIndicators);
        }
        this.m_nIndicator = this.m_listIndicators.get(cIndicators - 1);
        ++this.m_cMods;
        return condition;
    }

    public long getModificationCount() {
        return this.m_cMods;
    }

    public long getModificationIndicator() {
        return this.m_nIndicator;
    }

    public int getConditionCount() {
        return this.m_listCondition.size();
    }

    public ConditionalConstant getCondition(int i) {
        assert (i >= 0 && i < this.getConditionCount());
        return this.m_listCondition.get(i);
    }

    public ConditionalConstant getConditionSince(long nIndicator) {
        int iLast;
        if (nIndicator == this.m_nIndicator) {
            return null;
        }
        ArrayList<Long> listIndicators = this.m_listIndicators;
        for (int i = iLast = listIndicators.size() - 1; i >= 0; --i) {
            if (nIndicator != listIndicators.get(i)) continue;
            if (i == iLast) {
                return this.m_listCondition.get(iLast);
            }
            int cConditions = iLast - i + 1;
            ConditionalConstant[] acondition = new ConditionalConstant[cConditions];
            for (int iCondition = 0; iCondition < cConditions; ++iCondition) {
                acondition[iCondition] = this.m_listCondition.get(i + iCondition);
            }
            this.m_pool.ensureAllCondition(acondition);
        }
        throw new IllegalStateException("condition indicator " + nIndicator + " no longer exists");
    }

    public ConditionalConstant asCondition() {
        ArrayList<ConditionalConstant> list = this.m_listCondition;
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return this.m_pool.ensureAllCondition(list.toArray(new ConditionalConstant[0]));
    }

    public SimulatedLinkerContext getLinkerContext() {
        ArrayList<SimulatedLinkerContext> list = this.m_listLinkerContexts;
        if (list.isEmpty()) {
            return SimulatedLinkerContext.EMPTY;
        }
        SimulatedLinkerContext ctx = list.getLast();
        if (ctx == null) {
            ConditionalConstant cond = this.asCondition();
            ctx = this.m_mapContextCache.get(cond);
            if (ctx == null) {
                ctx = new SimulatedLinkerContext(cond);
                this.m_mapContextCache.put(cond, ctx);
            }
            list.set(list.size() - 1, ctx);
        }
        return ctx;
    }

    public void beginIfSpecified(String sName) {
        this.push(this.m_pool.ensureNamedCondition(sName));
    }

    public void endIfSpecified(String sName) {
        ConditionalConstant condition = this.pop();
        if (!(condition instanceof NamedCondition) || !sName.equals(((NamedCondition)condition).getName())) {
            throw new IllegalStateException("expected NamedCondition(\"" + sName + "\"); found: " + String.valueOf(condition));
        }
    }

    public void beginIfVisible(IdentityConstant constId) {
        this.push(this.m_pool.ensurePresentCondition(constId));
    }

    public void endIfVisible(Constant constId) {
        ConditionalConstant condition = this.pop();
        if (!(condition instanceof PresentCondition) || !constId.equals(((PresentCondition)condition).getPresentConstant())) {
            throw new IllegalStateException("expected PresentCondition(\"" + String.valueOf(constId) + "\"); found: " + String.valueOf(condition));
        }
    }

    public void beginIfVersion(ModuleConstant constModule, VersionConstant constVer) {
        this.push(this.m_pool.ensureImportVersionCondition(constModule, constVer));
    }

    public void endIfVersion(ModuleConstant constModule, VersionConstant constVer) {
        VersionMatchesCondition cond;
        ConditionalConstant condRaw = this.pop();
        boolean fMatch = false;
        if (condRaw instanceof VersionMatchesCondition && (cond = (VersionMatchesCondition)condRaw).getModuleConstant().equals(constModule) && cond.getVersionConstant().equals(constVer)) {
            fMatch = true;
        }
        if (!fMatch) {
            throw new IllegalStateException("expected VersionMatchesCondition(\"" + String.valueOf(constModule) + ", " + String.valueOf(constVer) + "\"); found: " + String.valueOf(condRaw));
        }
    }
}

