/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

public final class Assignment
extends Enum<Assignment> {
    public static final /* enum */ Assignment Unassigned = new Assignment(true, false, false);
    public static final /* enum */ Assignment UnknownOnce = new Assignment(false, false, true);
    public static final /* enum */ Assignment Unknown = new Assignment(false, false, false);
    public static final /* enum */ Assignment AssignedOnce = new Assignment(false, true, true);
    public static final /* enum */ Assignment Assigned = new Assignment(false, true, false);
    public static final /* enum */ Assignment Unassigned_Unknown1 = new Assignment(Unassigned, UnknownOnce);
    public static final /* enum */ Assignment Unassigned_Unknown = new Assignment(Unassigned, Unknown);
    public static final /* enum */ Assignment Unassigned_Assigned1 = new Assignment(Unassigned, AssignedOnce);
    public static final /* enum */ Assignment Unassigned_Assigned = new Assignment(Unassigned, Assigned);
    public static final /* enum */ Assignment Unknown1_Unassigned = new Assignment(UnknownOnce, Unassigned);
    public static final /* enum */ Assignment Unknown1_Unknown = new Assignment(UnknownOnce, Unknown);
    public static final /* enum */ Assignment Unknown1_Assigned1 = new Assignment(UnknownOnce, AssignedOnce);
    public static final /* enum */ Assignment Unknown1_Assigned = new Assignment(UnknownOnce, Assigned);
    public static final /* enum */ Assignment Unknown_Unassigned = new Assignment(Unknown, Unassigned);
    public static final /* enum */ Assignment Unknown_Unknown1 = new Assignment(Unknown, UnknownOnce);
    public static final /* enum */ Assignment Unknown_Assigned1 = new Assignment(Unknown, AssignedOnce);
    public static final /* enum */ Assignment Unknown_Assigned = new Assignment(Unknown, Assigned);
    public static final /* enum */ Assignment Assigned1_Unassigned = new Assignment(AssignedOnce, Unassigned);
    public static final /* enum */ Assignment Assigned1_Unknown1 = new Assignment(AssignedOnce, UnknownOnce);
    public static final /* enum */ Assignment Assigned1_Unknown = new Assignment(AssignedOnce, Unknown);
    public static final /* enum */ Assignment Assigned1_Assigned = new Assignment(AssignedOnce, Assigned);
    public static final /* enum */ Assignment Assigned_Unassigned = new Assignment(Assigned, Unassigned);
    public static final /* enum */ Assignment Assigned_Unknown1 = new Assignment(Assigned, UnknownOnce);
    public static final /* enum */ Assignment Assigned_Unknown = new Assignment(Assigned, Unknown);
    public static final /* enum */ Assignment Assigned_Assigned1 = new Assignment(Assigned, AssignedOnce);
    private static final Assignment[] ASSIGNMENTS;
    private static final Assignment[] BY_FLAGS;
    private final boolean fSplit;
    private final boolean fUnassignedWhenFalse;
    private final boolean fAssignedWhenFalse;
    private final boolean fExactlyOnceWhenFalse;
    private final boolean fUnassignedWhenTrue;
    private final boolean fAssignedWhenTrue;
    private final boolean fExactlyOnceWhenTrue;
    private static final /* synthetic */ Assignment[] $VALUES;

    public static Assignment[] values() {
        return (Assignment[])$VALUES.clone();
    }

    public static Assignment valueOf(String name) {
        return Enum.valueOf(Assignment.class, name);
    }

    private Assignment(boolean fUnassigned, boolean fAssigned, boolean fExactlyOnce) {
        assert (!(fAssigned & fUnassigned));
        this.fSplit = false;
        this.fUnassignedWhenFalse = this.fUnassignedWhenTrue = fUnassigned;
        this.fAssignedWhenFalse = this.fAssignedWhenTrue = fAssigned;
        this.fExactlyOnceWhenFalse = this.fExactlyOnceWhenTrue = fExactlyOnce;
    }

    private Assignment(Assignment whenFalse, Assignment whenTrue) {
        this.fSplit = true;
        this.fUnassignedWhenFalse = whenFalse.isDefinitelyUnassigned();
        this.fAssignedWhenFalse = whenFalse.isDefinitelyAssigned();
        this.fExactlyOnceWhenFalse = whenFalse.isEffectivelyFinal();
        this.fUnassignedWhenTrue = whenTrue.isDefinitelyUnassigned();
        this.fAssignedWhenTrue = whenTrue.isDefinitelyAssigned();
        this.fExactlyOnceWhenTrue = whenTrue.isEffectivelyFinal();
    }

    public boolean isDefinitelyUnassigned() {
        return this.fUnassignedWhenFalse & this.fUnassignedWhenTrue;
    }

    public boolean isDefinitelyAssigned() {
        return this.fAssignedWhenFalse & this.fAssignedWhenTrue;
    }

    public boolean isEffectivelyFinal() {
        return this.fExactlyOnceWhenFalse & this.fExactlyOnceWhenTrue | this.fExactlyOnceWhenFalse & this.fUnassignedWhenTrue | this.fUnassignedWhenFalse & this.fExactlyOnceWhenTrue;
    }

    public Assignment applyAssignment() {
        if (this.fSplit) {
            return Assignment.join(this.whenFalse().applyAssignment(), this.whenTrue().applyAssignment());
        }
        return this.isDefinitelyUnassigned() ? AssignedOnce : Assigned;
    }

    public Assignment applyAssignmentFromCapture() {
        if (this.fSplit) {
            return Assignment.join(this.whenFalse().applyAssignmentFromCapture(), this.whenTrue().applyAssignmentFromCapture());
        }
        return this.isDefinitelyAssigned() ? Assigned : Unknown;
    }

    public Assignment promoteFromNonCompleting(Assignment that) {
        if (this == that) {
            return this;
        }
        if (this.fSplit || that.fSplit) {
            return Assignment.join(this.whenFalse().promoteFromNonCompleting(that.whenFalse()), this.whenTrue().promoteFromNonCompleting(that.whenTrue()));
        }
        return this.isEffectivelyFinal() && !that.isEffectivelyFinal() ? Assignment.forFlags(this.getFlags() & 0x36) : this;
    }

    public Assignment whenFalse() {
        if (!this.fSplit) {
            return this;
        }
        return Assignment.forFlags((this.fUnassignedWhenFalse ? 36 : 0) | (this.fAssignedWhenFalse ? 18 : 0) | (this.fExactlyOnceWhenFalse ? 9 : 0));
    }

    public Assignment whenTrue() {
        if (!this.fSplit) {
            return this;
        }
        return Assignment.forFlags((this.fUnassignedWhenTrue ? 36 : 0) | (this.fAssignedWhenTrue ? 18 : 0) | (this.fExactlyOnceWhenTrue ? 9 : 0));
    }

    public Assignment negate() {
        return this.fSplit ? Assignment.join(this.whenTrue(), this.whenFalse()) : this;
    }

    public Assignment join(Assignment that) {
        return Assignment.forFlags((this.fUnassignedWhenFalse & that.fUnassignedWhenFalse ? 32 : 0) | (this.fAssignedWhenFalse & that.fAssignedWhenFalse ? 16 : 0) | (this.fExactlyOnceWhenFalse & that.fExactlyOnceWhenFalse ? 8 : 0) | (this.fUnassignedWhenTrue & that.fUnassignedWhenTrue ? 4 : 0) | (this.fAssignedWhenTrue & that.fAssignedWhenTrue ? 2 : 0) | (this.fExactlyOnceWhenTrue & that.fExactlyOnceWhenTrue ? 1 : 0));
    }

    public Assignment join(Assignment that, boolean fWhenTrue) {
        return fWhenTrue ? Assignment.forFlags((this.fUnassignedWhenFalse ? 32 : 0) | (this.fAssignedWhenFalse ? 16 : 0) | (this.fExactlyOnceWhenFalse ? 8 : 0) | (that.isDefinitelyUnassigned() ? 4 : 0) | (that.isDefinitelyAssigned() ? 2 : 0) | (that.isEffectivelyFinal() ? 1 : 0)) : Assignment.forFlags((that.isDefinitelyUnassigned() ? 32 : 0) | (that.isDefinitelyAssigned() ? 16 : 0) | (that.isEffectivelyFinal() ? 8 : 0) | (this.fUnassignedWhenTrue ? 4 : 0) | (this.fAssignedWhenTrue ? 2 : 0) | (this.fExactlyOnceWhenTrue ? 1 : 0));
    }

    public static Assignment join(Assignment whenFalse, Assignment whenTrue) {
        return Assignment.forFlags((whenFalse.isDefinitelyUnassigned() ? 32 : 0) | (whenFalse.isDefinitelyAssigned() ? 16 : 0) | (whenFalse.isEffectivelyFinal() ? 8 : 0) | (whenTrue.isDefinitelyUnassigned() ? 4 : 0) | (whenTrue.isDefinitelyAssigned() ? 2 : 0) | (whenTrue.isEffectivelyFinal() ? 1 : 0));
    }

    public Assignment joinLoop(Assignment that) {
        if (this == that) {
            return this;
        }
        if (this.fSplit || that.fSplit) {
            return Assignment.join(this.whenFalse().joinLoop(that.whenFalse()), this.whenTrue().joinLoop(that.whenTrue()));
        }
        return switch (that.ordinal()) {
            case 1 -> Unknown;
            case 3 -> Assigned;
            default -> that;
        };
    }

    public Assignment demux() {
        if (!this.fSplit) {
            return this;
        }
        return Assignment.forFlags((this.isDefinitelyUnassigned() ? 36 : 0) | (this.isDefinitelyAssigned() ? 18 : 0) | (this.isEffectivelyFinal() ? 9 : 0));
    }

    public static Assignment valueOf(int i) {
        return ASSIGNMENTS[i];
    }

    private int getFlags() {
        return (this.fUnassignedWhenFalse ? 32 : 0) | (this.fAssignedWhenFalse ? 16 : 0) | (this.fExactlyOnceWhenFalse ? 8 : 0) | (this.fUnassignedWhenTrue ? 4 : 0) | (this.fAssignedWhenTrue ? 2 : 0) | (this.fExactlyOnceWhenTrue ? 1 : 0);
    }

    private static Assignment forFlags(int nFlags) {
        Assignment assignment = BY_FLAGS[nFlags];
        assert (assignment != null);
        return assignment;
    }

    private static /* synthetic */ Assignment[] $values() {
        return new Assignment[]{Unassigned, UnknownOnce, Unknown, AssignedOnce, Assigned, Unassigned_Unknown1, Unassigned_Unknown, Unassigned_Assigned1, Unassigned_Assigned, Unknown1_Unassigned, Unknown1_Unknown, Unknown1_Assigned1, Unknown1_Assigned, Unknown_Unassigned, Unknown_Unknown1, Unknown_Assigned1, Unknown_Assigned, Assigned1_Unassigned, Assigned1_Unknown1, Assigned1_Unknown, Assigned1_Assigned, Assigned_Unassigned, Assigned_Unknown1, Assigned_Unknown, Assigned_Assigned1};
    }

    static {
        $VALUES = Assignment.$values();
        ASSIGNMENTS = Assignment.values();
        BY_FLAGS = new Assignment[64];
        for (Assignment assignment : ASSIGNMENTS) {
            int n = assignment.getFlags();
            assert (BY_FLAGS[n] == null);
            Assignment.BY_FLAGS[n] = assignment;
        }
    }
}

