/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class BuildInfo {
    private static final Properties BUILD_INFO = BuildInfo.loadBuildInfo();

    private static Properties loadBuildInfo() {
        InputStream is2;
        Properties props = new Properties();
        try {
            is2 = BuildInfo.class.getResourceAsStream("/build-info.properties");
            try {
                if (is2 != null) {
                    props.load(is2);
                }
            }
            finally {
                if (is2 != null) {
                    is2.close();
                }
            }
        }
        catch (IOException is2) {
            // empty catch block
        }
        if (props.isEmpty()) {
            try {
                is2 = BuildInfo.class.getResourceAsStream("/version.properties");
                try {
                    if (is2 != null) {
                        props.load(is2);
                    }
                }
                finally {
                    if (is2 != null) {
                        is2.close();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return props;
    }

    public static String getXdkVersion() {
        return BUILD_INFO.getProperty("xdk.version", "0.0.0-unknown");
    }

    public static int getXvmVersionMajor() {
        return Integer.parseInt(BUILD_INFO.getProperty("xvm.version.major"));
    }

    public static int getXvmVersionMinor() {
        return Integer.parseInt(BUILD_INFO.getProperty("xvm.version.minor"));
    }

    public static String getGitCommit() {
        return BUILD_INFO.getProperty("git.commit.id", BUILD_INFO.getProperty("git.commit", ""));
    }

    public static String getGitStatus() {
        return BUILD_INFO.getProperty("git.status", "");
    }
}

