/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.xvm.asm.Annotation;
import org.xvm.asm.Argument;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.MultiMethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.PackageStructure;
import org.xvm.asm.Parameter;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.Register;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.ast.BinaryAST;
import org.xvm.asm.ast.ConstantExprAST;
import org.xvm.asm.ast.ExprAST;
import org.xvm.asm.ast.InvokeExprAST;
import org.xvm.asm.ast.RegisterAST;
import org.xvm.asm.ast.ReturnStmtAST;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.FrameDependentConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.IntersectionTypeConstant;
import org.xvm.asm.constants.KeywordConstant;
import org.xvm.asm.constants.LiteralConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.NativeRebaseConstant;
import org.xvm.asm.constants.PropertyClassTypeConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.constants.TypeParameterConstant;
import org.xvm.asm.constants.TypedefConstant;
import org.xvm.asm.constants.UnionTypeConstant;
import org.xvm.asm.constants.UnresolvedNameConstant;
import org.xvm.asm.constants.UnresolvedTypeConstant;
import org.xvm.asm.op.Call_01;
import org.xvm.asm.op.Invoke_00;
import org.xvm.asm.op.Invoke_01;
import org.xvm.asm.op.Invoke_0N;
import org.xvm.asm.op.Invoke_10;
import org.xvm.asm.op.Invoke_11;
import org.xvm.asm.op.Invoke_1N;
import org.xvm.asm.op.Invoke_N0;
import org.xvm.asm.op.Invoke_N1;
import org.xvm.asm.op.Invoke_NN;
import org.xvm.asm.op.L_Get;
import org.xvm.asm.op.L_Set;
import org.xvm.asm.op.P_Get;
import org.xvm.asm.op.P_Set;
import org.xvm.asm.op.Return_0;
import org.xvm.asm.op.Return_1;
import org.xvm.asm.op.Return_N;
import org.xvm.asm.op.Var_D;
import org.xvm.asm.op.Var_I;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.util.Handy;
import org.xvm.util.LinkedIterator;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public class ClassStructure
extends Component {
    private ListMap<StringConstant, TypeConstant> m_mapParams;
    private LiteralConstant m_constPath;
    private transient TypeConstant m_typeFormal;
    private transient TypeConstant m_typeCanonical;
    private transient MethodStructure.ConcurrencySafety m_safety;
    private transient Annotation[] m_aAnnoClass;
    private transient Annotation[] m_aAnnoMixin;

    protected ClassStructure(XvmStructure xsParent, int nFlags, IdentityConstant constId, ConditionalConstant condition) {
        super(xsParent, nFlags, constId, condition);
    }

    public LiteralConstant getSourcePath() {
        if (this.m_constPath != null) {
            return this.m_constPath;
        }
        if (this.getFormat() == Component.Format.MODULE) {
            return null;
        }
        Component outer = this.getParent();
        while (!(outer instanceof ClassStructure)) {
            outer = outer.getParent();
        }
        return ((ClassStructure)outer).getSourcePath();
    }

    public void setSourcePath(LiteralConstant constPath) {
        this.m_constPath = constPath;
        this.markModified();
    }

    public String getSourceFileName() {
        LiteralConstant constPath = this.getSourcePath();
        if (constPath != null) {
            String sPath = constPath.getValue();
            int of = sPath.lastIndexOf(47);
            return of >= 0 ? sPath.substring(of + 1) : sPath;
        }
        ClassStructure clzTopLevel = this;
        while (!clzTopLevel.isTopLevel()) {
            clzTopLevel = clzTopLevel.getOuter();
        }
        return clzTopLevel.getSimpleName() + ".x";
    }

    public boolean isSingleton() {
        switch (this.getFormat()) {
            case MODULE: 
            case PACKAGE: 
            case ENUMVALUE: {
                return true;
            }
            case INTERFACE: 
            case CLASS: 
            case ENUM: 
            case ANNOTATION: 
            case MIXIN: {
                return false;
            }
            case CONST: 
            case SERVICE: {
                if (this.isStatic()) {
                    Component.Format format = this.getParent().getFormat();
                    return format == Component.Format.MODULE || format == Component.Format.PACKAGE;
                }
                return false;
            }
        }
        throw new IllegalStateException();
    }

    public boolean isExplicitlyAbstract() {
        return this.containsAnnotation(this.getConstantPool().clzAbstract());
    }

    public boolean isExplicitlyOverride() {
        return this.containsAnnotation(this.getConstantPool().clzOverride());
    }

    public boolean containsAnnotation(ClassConstant idAnno) {
        for (Component.Contribution contrib : this.getContributionsAsList()) {
            TypeConstant type;
            if (contrib.getComposition() != Component.Composition.Annotation || !(type = contrib.getTypeConstant()).isExplicitClassIdentity(false) || !type.getSingleUnderlyingClass(false).equals(idAnno)) continue;
            return true;
        }
        return false;
    }

    public Annotation[] collectAnnotations(boolean fIntoClass) {
        Annotation[] annos;
        Annotation[] annotationArray = annos = fIntoClass ? this.m_aAnnoClass : this.m_aAnnoMixin;
        if (annos == null) {
            ArrayList<Annotation> listAnnos = null;
            for (Component.Contribution contrib : this.getContributionsAsList()) {
                Annotation anno;
                if (contrib.getComposition() != Component.Composition.Annotation || fIntoClass != (anno = contrib.getAnnotation()).getAnnotationType().getExplicitClassInto().isIntoClassType()) continue;
                if (listAnnos == null) {
                    listAnnos = new ArrayList<Annotation>();
                }
                listAnnos.add(anno);
            }
            Annotation[] annotationArray2 = annos = listAnnos == null ? Annotation.NO_ANNOTATIONS : listAnnos.toArray(Annotation.NO_ANNOTATIONS);
            if (fIntoClass) {
                this.m_aAnnoClass = annos;
            } else {
                this.m_aAnnoMixin = annos;
            }
        }
        return annos;
    }

    public boolean isTopLevel() {
        switch (this.getFormat()) {
            case MODULE: 
            case PACKAGE: {
                return true;
            }
            case INTERFACE: 
            case CLASS: 
            case ENUM: 
            case ANNOTATION: 
            case MIXIN: 
            case CONST: 
            case SERVICE: {
                Component.Format format = this.getParent().getFormat();
                return format == Component.Format.MODULE || format == Component.Format.PACKAGE;
            }
            case ENUMVALUE: {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    public boolean isMemberClass() {
        return switch (this.getParent().getFormat()) {
            case Component.Format.METHOD, Component.Format.PROPERTY -> true;
            default -> false;
        };
    }

    public boolean isAnonInnerClass() {
        return this.isMemberClass() && this.isSynthetic() && this.getIdentityConstant().getParentConstant() instanceof MethodConstant;
    }

    public boolean isInnerChild() {
        return this.isMemberClass() && !this.isStatic();
    }

    public boolean isVirtualChild() {
        switch (this.getFormat()) {
            case MODULE: 
            case PACKAGE: 
            case ENUMVALUE: 
            case ENUM: {
                return false;
            }
            case INTERFACE: 
            case CLASS: 
            case ANNOTATION: 
            case MIXIN: 
            case CONST: 
            case SERVICE: {
                if (this.isSynthetic() || this.isStatic()) {
                    return false;
                }
                Component parent = this.getParent();
                Component.Format format = parent.getFormat();
                while (format == Component.Format.PROPERTY) {
                    parent = parent.getParent();
                    format = parent.getFormat();
                }
                return format != Component.Format.MODULE && format != Component.Format.PACKAGE && format != Component.Format.METHOD;
            }
        }
        throw new IllegalStateException();
    }

    public boolean isInstanceChild() {
        return this.isVirtualChild() || this.isInnerChild();
    }

    public boolean isVirtualChildClass() {
        if (!this.isVirtualChild()) {
            return false;
        }
        return switch (this.getFormat()) {
            case Component.Format.CLASS -> true;
            case Component.Format.CONST -> true;
            case Component.Format.SERVICE -> true;
            default -> false;
        };
    }

    public boolean isVirtualDescendant(IdentityConstant idParent) {
        return this.getIdentityConstant().equals(idParent) || this.isVirtualChild() && this.getOuter().isVirtualDescendant(idParent);
    }

    public boolean isDescendant(IdentityConstant idParent) {
        ClassStructure parent;
        Component component;
        return this.getIdentityConstant().equals(idParent) || (component = this.getParent()) instanceof ClassStructure && (parent = (ClassStructure)component).isDescendant(idParent);
    }

    public String checkGenericTypeVisibility(TypeConstant type) {
        final String[] asName = new String[1];
        Consumer<Constant> visitor = new Consumer<Constant>(this){
            final /* synthetic */ ClassStructure this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(Constant c) {
                if (c instanceof TypeConstant) {
                    TypeConstant t = (TypeConstant)c;
                    if (t.isGenericType()) {
                        Constant constId = t.getDefiningConstant();
                        if (constId.getFormat() == Constant.Format.Property) {
                            String sName = ((PropertyConstant)constId).getName();
                            if (!this.this$0.getFormalType().containsGenericParam(sName) && asName[0] == null) {
                                asName[0] = sName;
                            }
                        }
                    } else {
                        t.forEachUnderlying(this);
                    }
                }
            }
        };
        type.forEachUnderlying(visitor);
        return asName[0];
    }

    public ClassStructure getOuter() {
        assert (this.isInstanceChild());
        Component parent = this.getParent();
        block4: while (true) {
            switch (parent.getFormat()) {
                case METHOD: 
                case PROPERTY: 
                case MULTIMETHOD: {
                    parent = parent.getParent();
                    continue block4;
                }
                case MODULE: 
                case PACKAGE: 
                case ENUMVALUE: 
                case INTERFACE: 
                case CLASS: 
                case ENUM: 
                case ANNOTATION: 
                case MIXIN: 
                case CONST: 
                case SERVICE: {
                    return (ClassStructure)parent;
                }
            }
            break;
        }
        throw new IllegalStateException(String.valueOf(parent.getIdentityConstant()) + " format=" + String.valueOf((Object)parent.getFormat()));
    }

    public boolean isService() {
        return this.getFormat() == Component.Format.SERVICE || this.isVirtualChild() && this.getOuter().isService();
    }

    public boolean isConst() {
        return switch (this.getFormat()) {
            case Component.Format.MODULE, Component.Format.PACKAGE, Component.Format.ENUMVALUE, Component.Format.ENUM, Component.Format.CONST -> true;
            default -> false;
        };
    }

    public boolean isImmutable() {
        switch (this.getFormat()) {
            case MODULE: 
            case PACKAGE: 
            case ENUMVALUE: 
            case ENUM: 
            case CONST: {
                return true;
            }
            case ANNOTATION: 
            case MIXIN: {
                TypeConstant typeInto = this.getTypeInto();
                if (typeInto.containsUnresolved()) {
                    return false;
                }
                if (typeInto.isImmutable()) {
                    return true;
                }
            }
            case INTERFACE: 
            case CLASS: {
                for (Component.Contribution contrib : this.getContributionsAsList()) {
                    if (contrib.getComposition() != Component.Composition.Implements || contrib.containsUnresolved() || !contrib.getTypeConstant().isImmutable()) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public ClassStructure getVirtualChild(String sName) {
        ClassStructure clz;
        Component child = this.findChildDeep(sName, true);
        return child instanceof ClassStructure && (clz = (ClassStructure)child).isVirtualChild() ? clz : null;
    }

    public Component findChildDeep(String sName) {
        return this.findChildDeep(sName, true);
    }

    private Component findChildDeep(String sName, boolean fAllowInto) {
        Component child = this.getChild(sName);
        if (child != null) {
            return child;
        }
        for (Component.Contribution contrib : this.getContributionsAsList()) {
            ClassStructure clzContrib;
            boolean fCheck;
            TypeConstant typeContrib = contrib.getTypeConstant();
            if (typeContrib.containsUnresolved() || !typeContrib.isExplicitClassIdentity(true)) continue;
            switch (contrib.getComposition()) {
                case Annotation: {
                    fCheck = !this.isIntoClassAnnotation(typeContrib);
                    fAllowInto = false;
                    break;
                }
                case Into: {
                    fCheck = fAllowInto;
                    fAllowInto = false;
                    break;
                }
                case Incorporates: {
                    fAllowInto = false;
                }
                case Delegates: 
                case Implements: 
                case Extends: {
                    fCheck = true;
                    break;
                }
                default: {
                    fCheck = false;
                }
            }
            if (!fCheck || (child = (clzContrib = (ClassStructure)typeContrib.getSingleUnderlyingClass(true).getComponent()).findChildDeep(sName, fAllowInto)) == null) continue;
            return child;
        }
        return null;
    }

    public int getTypeParamCount() {
        ListMap<StringConstant, TypeConstant> mapThis = this.m_mapParams;
        return mapThis == null ? 0 : mapThis.size();
    }

    public ListMap<StringConstant, TypeConstant> getTypeParams() {
        ListMap<StringConstant, TypeConstant> mapThis = this.m_mapParams;
        return mapThis == null ? ListMap.EMPTY : mapThis;
    }

    public List<Map.Entry<StringConstant, TypeConstant>> getTypeParamsAsList() {
        ListMap<StringConstant, TypeConstant> mapThis = this.m_mapParams;
        return mapThis == null ? Collections.emptyList() : mapThis.asList();
    }

    public PropertyStructure addTypeParam(String sName, TypeConstant typeConstraint) {
        ListMap<StringConstant, TypeConstant> map = this.m_mapParams;
        if (map == null) {
            map = new ListMap();
            this.m_mapParams = map;
        }
        ConstantPool pool = this.getConstantPool();
        if (typeConstraint.getParamsCount() >= 1 && typeConstraint.isTuple() && typeConstraint.getParamType(0).getValueString().equals(sName)) {
            typeConstraint = pool.ensureTypeSequenceTypeConstant();
        }
        map.put(pool.ensureStringConstant(sName), typeConstraint);
        TypeConstant typeConstraintType = pool.ensureClassTypeConstant(pool.clzType(), null, typeConstraint);
        PropertyStructure prop = this.createProperty(false, Constants.Access.PUBLIC, Constants.Access.PUBLIC, typeConstraintType, sName);
        prop.markAsGenericTypeParameter();
        this.markModified();
        this.m_typeCanonical = null;
        this.m_typeFormal = null;
        return prop;
    }

    public TypeConstant getConstraint(String sName) {
        return this.m_mapParams.get(this.getConstantPool().ensureStringConstant(sName));
    }

    public void updateConstraint(String sName, TypeConstant typeConstraint) {
        ListMap<StringConstant, TypeConstant> map = this.m_mapParams;
        assert (map != null);
        ConstantPool pool = this.getConstantPool();
        TypeConstant typeConstraintType = pool.ensureClassTypeConstant(pool.clzType(), null, typeConstraint);
        map.put(pool.ensureStringConstant(sName), typeConstraint);
        PropertyStructure prop = (PropertyStructure)this.getChild(sName);
        prop.setType(typeConstraintType);
        this.markModified();
    }

    public boolean isParameterized() {
        return this.m_mapParams != null;
    }

    public boolean isParameterizedDeep() {
        return this.isParameterized() || this.isVirtualChild() && this.getOuter().isParameterized();
    }

    public TypeConstant getFormalType() {
        TypeConstant typeFormal = this.m_typeFormal;
        if (typeFormal == null) {
            ConstantPool pool = this.getConstantPool();
            IdentityConstant constantClz = this.getIdentityConstant();
            if (this.isAnonInnerClass()) {
                typeFormal = constantClz.getType();
                if (this.isParameterized()) {
                    typeFormal = pool.ensureParameterizedTypeConstant(typeFormal, this.m_mapParams.values().toArray(TypeConstant.NO_TYPES));
                }
            } else {
                if (this.isVirtualChild()) {
                    typeParent = ((ClassStructure)this.getParent()).getFormalType();
                    typeFormal = pool.ensureVirtualChildTypeConstant(typeParent, this.getName());
                } else if (this.isInnerChild()) {
                    typeParent = this.getOuter().getFormalType();
                    typeFormal = pool.ensureInnerChildTypeConstant(typeParent, (ClassConstant)this.getIdentityConstant());
                } else {
                    typeFormal = constantClz.getType();
                }
                if (this.isParameterized()) {
                    ListMap<StringConstant, TypeConstant> mapThis = this.m_mapParams;
                    TypeConstant[] aTypes = new TypeConstant[mapThis.size()];
                    int ix = 0;
                    for (StringConstant constName : mapThis.keySet()) {
                        PropertyStructure prop = (PropertyStructure)this.getChild(constName.getValue());
                        aTypes[ix++] = prop.getIdentityConstant().getFormalType();
                    }
                    typeFormal = pool.ensureParameterizedTypeConstant(typeFormal, aTypes);
                }
            }
            this.m_typeFormal = typeFormal;
        }
        return typeFormal;
    }

    public TypeConstant getAutoNarrowingFormalType() {
        if (this.isVirtualChild()) {
            ClassStructure clzParent = (ClassStructure)this.getParent();
            return this.getConstantPool().ensureThisVirtualChildTypeConstant(clzParent.getAutoNarrowingFormalType(), this.getName());
        }
        return this.getFormalType();
    }

    public TypeConstant getCanonicalType() {
        TypeConstant typeCanonical = this.m_typeCanonical;
        if (typeCanonical == null) {
            ConstantPool pool = this.getConstantPool();
            IdentityConstant constClz = this.getIdentityConstant();
            if (constClz.equals(pool.clzTuple())) {
                this.m_typeCanonical = pool.typeTuple0();
                return this.m_typeCanonical;
            }
            if (this.isVirtualChild()) {
                typeParent = ((ClassStructure)this.getParent()).getCanonicalType();
                typeCanonical = pool.ensureVirtualChildTypeConstant(typeParent, this.getName());
            } else if (this.isInnerChild()) {
                typeParent = this.getOuter().getCanonicalType();
                typeCanonical = pool.ensureInnerChildTypeConstant(typeParent, (ClassConstant)constClz);
            } else {
                typeCanonical = constClz.getType();
            }
            if (this.isParameterized()) {
                ListMap<StringConstant, TypeConstant> mapParams = this.getTypeParams();
                TypeConstant[] atypeParam = new TypeConstant[mapParams.size()];
                int ix = 0;
                SimpleTypeResolver resolver = new SimpleTypeResolver(pool, new ArrayList<TypeConstant>());
                for (TypeConstant typeParam : mapParams.values()) {
                    atypeParam[ix++] = typeParam.isFormalTypeSequence() ? pool.typeTuple0() : typeParam.resolveGenerics(pool, resolver);
                }
                typeCanonical = pool.ensureParameterizedTypeConstant(typeCanonical, atypeParam);
            }
            this.m_typeCanonical = typeCanonical;
        }
        return typeCanonical;
    }

    public TypeConstant resolveType(ConstantPool pool, List<TypeConstant> listActual) {
        return listActual.isEmpty() && !this.isParameterized() ? this.getCanonicalType() : this.getFormalType().resolveGenerics(pool, new SimpleTypeResolver(pool, listActual));
    }

    public List<TypeConstant> normalizeParameters(ConstantPool pool, List<TypeConstant> listActual) {
        int cFormal;
        int cActual = listActual.size();
        return cActual == (cFormal = this.getTypeParamCount()) ? listActual : this.resolveType(pool, listActual).getParamTypes();
    }

    public TypeConstant[] normalizeParameters(ConstantPool pool, TypeConstant[] atypeActual) {
        int cActual = atypeActual.length;
        int cFormal = this.getTypeParamCount();
        return cActual == cFormal ? atypeActual : this.resolveType(pool, Arrays.asList(atypeActual)).getParamTypesArray();
    }

    protected void collectDependencies(String sModulePath, Map<ModuleConstant, String> mapModulePaths) {
        for (Component component : this.children()) {
            if (!(component instanceof PackageStructure)) continue;
            PackageStructure pkg = (PackageStructure)component;
            if (pkg.isModuleImport()) {
                String sNewPath;
                ModuleStructure moduleDep = pkg.getImportedModule();
                ModuleConstant idDep = moduleDep.getIdentityConstant();
                String sOldPath = mapModulePaths.get(idDep);
                String sLocalPath = pkg.getIdentityConstant().getPathString();
                String string = sNewPath = sModulePath.isEmpty() ? sLocalPath : sModulePath + "." + sLocalPath;
                if (sOldPath == null) {
                    mapModulePaths.put(idDep, sNewPath);
                    moduleDep.collectDependencies(sNewPath, mapModulePaths);
                    continue;
                }
                if (sNewPath.length() >= sOldPath.length()) continue;
                mapModulePaths.put(idDep, sNewPath);
                mapModulePaths.entrySet().stream().filter(e -> ((String)e.getValue()).startsWith(sOldPath + ".")).forEach(e -> e.setValue(sNewPath + ((String)e.getValue()).substring(sOldPath.length())));
                continue;
            }
            pkg.collectDependencies(sModulePath, mapModulePaths);
        }
    }

    public List<Component.Contribution> collectConditionalIncorporates(TypeConstant type) {
        ConstantPool pool = this.getConstantPool();
        ArrayList<Component.Contribution> listIncorporates = null;
        for (Component.Contribution contrib : this.getContributionsAsList()) {
            if (contrib.getComposition() != Component.Composition.Incorporates || !contrib.isConditional() || contrib.resolveGenerics(pool, type) == null) continue;
            if (listIncorporates == null) {
                listIncorporates = new ArrayList<Component.Contribution>();
            }
            listIncorporates.add(contrib);
        }
        return listIncorporates;
    }

    public boolean isTuple() {
        if (this.getIdentityConstant().equals(this.getConstantPool().clzTuple())) {
            return true;
        }
        for (Component.Contribution contrib : this.getContributionsAsList()) {
            if (!(contrib.getComposition() == Component.Composition.Into ? contrib.getTypeConstant().isTuple() : this.getFormat() == Component.Format.INTERFACE && contrib.getComposition() == Component.Composition.Extends && contrib.getTypeConstant().isTuple())) continue;
            return true;
        }
        return false;
    }

    public List<TypeConstant> getTupleParamTypes(ConstantPool pool, List<TypeConstant> listParams) {
        if (this.getIdentityConstant().equals(pool.clzTuple())) {
            return listParams;
        }
        for (Component.Contribution contrib : this.getContributionsAsList()) {
            TypeConstant typeContrib;
            if (contrib.getComposition() != Component.Composition.Into || (typeContrib = contrib.resolveGenerics(pool, new SimpleTypeResolver(pool, listParams))) == null || !typeContrib.isTuple()) continue;
            return typeContrib.getTupleParamTypes();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isClassContainer() {
        return true;
    }

    @Override
    public boolean isMethodContainer() {
        return true;
    }

    @Override
    public MethodStructure.ConcurrencySafety getConcurrencySafety() {
        if (this.m_safety != null) {
            return this.m_safety;
        }
        this.m_safety = switch (this.getFormat()) {
            case Component.Format.MODULE, Component.Format.PACKAGE, Component.Format.ENUMVALUE, Component.Format.ENUM, Component.Format.CONST -> MethodStructure.ConcurrencySafety.Safe;
            case Component.Format.INTERFACE, Component.Format.CLASS, Component.Format.ANNOTATION, Component.Format.MIXIN, Component.Format.SERVICE -> {
                ConstantPool pool = this.getConstantPool();
                if (this.containsAnnotation(pool.clzSynchronized())) {
                    yield MethodStructure.ConcurrencySafety.Unsafe;
                }
                if (this.containsAnnotation(pool.clzConcurrent())) {
                    yield MethodStructure.ConcurrencySafety.Safe;
                }
                yield MethodStructure.ConcurrencySafety.Instance;
            }
            default -> throw new IllegalStateException();
        };
        return this.m_safety;
    }

    @Override
    public boolean isAutoNarrowingAllowed() {
        if (!this.getFormat().isAutoNarrowingAllowed()) {
            return false;
        }
        if (this.isSingleton()) {
            return false;
        }
        Component parent = this.getParent();
        if (parent instanceof MethodStructure) {
            return false;
        }
        return ((ClassConstant)this.getIdentityConstant()).getDepthFromOutermost() == 0 || parent.isAutoNarrowingAllowed();
    }

    @Override
    public ComponentResolver.ResolutionResult resolveName(String sName, Constants.Access access, ComponentResolver.ResolutionCollector collector) {
        Constant constant;
        Component.SimpleCollector collectorSvc;
        ClassStructure clzSvc;
        ComponentResolver.ResolutionResult resultSvc;
        ComponentResolver.ResolutionResult result = super.resolveName(sName, access, collector);
        if (result == ComponentResolver.ResolutionResult.UNKNOWN && this.getFormat() == Component.Format.SERVICE && (resultSvc = (clzSvc = (ClassStructure)this.getConstantPool().clzService().getComponent()).resolveName(sName, Constants.Access.PROTECTED, collectorSvc = new Component.SimpleCollector(ErrorListener.BLACKHOLE))) == ComponentResolver.ResolutionResult.RESOLVED && (constant = collectorSvc.getResolvedConstant()).getFormat() == Constant.Format.Class) {
            collector.resolvedConstant(constant);
            return ComponentResolver.ResolutionResult.RESOLVED;
        }
        return result;
    }

    @Override
    protected ClassStructure cloneBody() {
        ClassStructure that = (ClassStructure)super.cloneBody();
        if (this.m_mapParams != null) {
            ListMap<StringConstant, TypeConstant> mapThis = this.m_mapParams;
            ListMap<StringConstant, TypeConstant> mapThat = new ListMap<StringConstant, TypeConstant>();
            mapThat.putAll(mapThis);
            that.m_mapParams = mapThat;
        }
        return that;
    }

    public boolean extendsClass(IdentityConstant idClass) {
        if (this.getFormat() == Component.Format.INTERFACE) {
            return false;
        }
        if (idClass.equals(this.getIdentityConstant())) {
            return true;
        }
        ClassStructure structCur = this;
        block0: while (true) {
            for (Component.Contribution contrib : structCur.getContributionsAsList()) {
                if (contrib.getComposition() != Component.Composition.Extends) continue;
                ClassConstant constSuper = (ClassConstant)contrib.getTypeConstant().getSingleUnderlyingClass(false);
                if (idClass.equals(constSuper)) {
                    return true;
                }
                structCur = (ClassStructure)constSuper.getComponent();
                continue block0;
            }
            break;
        }
        return false;
    }

    public boolean isIntoClassAnnotation(TypeConstant typeAnno) {
        assert (typeAnno.isExplicitClassIdentity(true));
        if (typeAnno.getExplicitClassFormat() != Component.Format.ANNOTATION) {
            return false;
        }
        TypeConstant typeInto = typeAnno.getExplicitClassInto();
        return typeInto.isIntoClassType() && !typeInto.isComposedOfAny(Collections.singleton(this.getIdentityConstant()));
    }

    public Component.Contribution hasCyclicalContribution() {
        return this.findContributionImpl(this.getIdentityConstant(), false);
    }

    public boolean hasContribution(IdentityConstant idClass) {
        if (idClass.equals(this.getConstantPool().clzObject())) {
            return true;
        }
        if (idClass.equals(this.getIdentityConstant())) {
            return true;
        }
        return this.findContributionImpl(idClass, true) != null;
    }

    public Component.Contribution findContribution(IdentityConstant idContrib) {
        if (idContrib.equals(this.getIdentityConstant())) {
            return new Component.Contribution((Component)this, Component.Composition.Equal, this.getFormalType());
        }
        return this.findContributionImpl(idContrib, true);
    }

    private Component.Contribution findContributionImpl(IdentityConstant idContrib, boolean fAllowInto) {
        for (Component.Contribution contrib : this.getContributionsAsList()) {
            TypeConstant typeContrib = contrib.getTypeConstant();
            Component.Contribution contribMatch = null;
            if (typeContrib.isExplicitClassIdentity(true)) {
                boolean fCheck;
                switch (contrib.getComposition()) {
                    case Annotation: {
                        fCheck = !this.isIntoClassAnnotation(typeContrib);
                        fAllowInto = false;
                        break;
                    }
                    case Into: {
                        fCheck = fAllowInto;
                        fAllowInto = false;
                        break;
                    }
                    case Incorporates: {
                        fAllowInto = false;
                    }
                    case Delegates: 
                    case Implements: 
                    case Extends: {
                        fCheck = true;
                        break;
                    }
                    default: {
                        fCheck = false;
                    }
                }
                if (fCheck) {
                    contribMatch = this.checkContribution(contrib, typeContrib, idContrib);
                }
            } else if (typeContrib instanceof IntersectionTypeConstant) {
                IntersectionTypeConstant typeIntersection = (IntersectionTypeConstant)typeContrib;
                contribMatch = this.checkIntersectionContribution(contrib, typeIntersection, idContrib);
            }
            if (contribMatch == null) continue;
            return contribMatch;
        }
        return null;
    }

    private Component.Contribution checkContribution(Component.Contribution contrib, TypeConstant typeContrib, IdentityConstant idTest) {
        IdentityConstant idContrib = typeContrib.getSingleUnderlyingClass(true);
        if (idContrib.equals(idTest)) {
            return contrib;
        }
        ClassStructure clzContrib = (ClassStructure)idContrib.getComponent();
        return clzContrib.findContributionImpl(idTest, false);
    }

    private Component.Contribution checkIntersectionContribution(Component.Contribution contrib, IntersectionTypeConstant typeContrib, IdentityConstant idTest) {
        Component.Contribution contribution;
        Component.Contribution contrib1;
        TypeConstant type1 = typeContrib.getUnderlyingType();
        if (type1.isExplicitClassIdentity(true)) {
            v0 = this.checkContribution(contrib, type1, idTest);
        } else if (type1 instanceof IntersectionTypeConstant) {
            IntersectionTypeConstant typeIntersection1 = (IntersectionTypeConstant)type1;
            v0 = this.checkIntersectionContribution(contrib, typeIntersection1, idTest);
        } else {
            v0 = contrib1 = null;
        }
        if (contrib1 != null) {
            return contrib1;
        }
        TypeConstant type2 = typeContrib.getUnderlyingType2();
        if (type2.isExplicitClassIdentity(true)) {
            contribution = this.checkContribution(contrib, type2, idTest);
        } else if (type2 instanceof IntersectionTypeConstant) {
            IntersectionTypeConstant typeIntersection2 = (IntersectionTypeConstant)type2;
            contribution = this.checkIntersectionContribution(contrib, typeIntersection2, idTest);
        } else {
            contribution = null;
        }
        return contribution;
    }

    public boolean isException() {
        return this.extendsClass(this.getConstantPool().clzException());
    }

    public TypeConstant getRebaseType() {
        ConstantPool pool = this.getConstantPool();
        Component.Format format = this.getFormat();
        switch (format) {
            case MODULE: {
                return pool.typeModuleRB();
            }
            case PACKAGE: {
                return pool.typePackageRB();
            }
            case ENUM: {
                return pool.typeEnumRB();
            }
            case CONST: 
            case SERVICE: {
                ClassStructure clzSuper = this.getSuper();
                if (clzSuper != null && format == clzSuper.getFormat()) break;
                return format == Component.Format.CONST ? pool.typeConstRB() : pool.typeServiceRB();
            }
        }
        return null;
    }

    public ClassStructure getSuper() {
        TypeConstant typeExtends;
        Component.Contribution contribExtends = this.findContribution(Component.Composition.Extends);
        if (contribExtends != null && (typeExtends = contribExtends.getTypeConstant()).isExplicitClassIdentity(true) && typeExtends.isSingleUnderlyingClass(false)) {
            return (ClassStructure)typeExtends.getSingleUnderlyingClass(false).getComponent();
        }
        return null;
    }

    public boolean resolveVirtualSuper(Set<Component.Contribution> setContribs) {
        assert (this.isVirtualChild());
        HashSet<IdentityConstant> setVisited = new HashSet<IdentityConstant>();
        IdentityConstant idThis = this.getIdentityConstant();
        setVisited.add(idThis);
        Component parent = this.getParent();
        int cDepth = 1;
        while (true) {
            ClassStructure clz;
            if (setVisited.add(parent.getIdentityConstant())) {
                Iterator<IdentityConstant> iter = parent.potentialVirtualChildContributors();
                if (iter == null) {
                    return false;
                }
                while (iter.hasNext()) {
                    TypeConstant typeSuper;
                    ClassStructure clzSuper;
                    Object o;
                    IdentityConstant idContrib = iter.next();
                    if (idContrib.containsUnresolved()) {
                        return false;
                    }
                    Component component = idContrib.getComponent();
                    if (component == null || (o = component.findVirtualChildSuper(idThis, cDepth, setVisited)) == null) continue;
                    if (o instanceof Boolean) {
                        Boolean Flag = (Boolean)o;
                        assert (!Flag.booleanValue());
                        return false;
                    }
                    IdentityConstant idSuper = idThis.appendTrailingPathTo(idContrib, cDepth);
                    Component compSuper = idSuper.getComponent();
                    if (compSuper == null) {
                        ConstantPool pool = this.getConstantPool();
                        clzSuper = (ClassStructure)o;
                        assert (clzSuper.isVirtualChild());
                        typeSuper = pool.ensureVirtualChildTypeConstant(((ClassStructure)component).getFormalType(), idThis.getName());
                        if (clzSuper.isParameterized()) {
                            typeSuper = typeSuper.adoptParameters(pool, clzSuper.getFormalType());
                        }
                    } else if (compSuper instanceof ClassStructure) {
                        ClassStructure clz2;
                        clzSuper = clz2 = (ClassStructure)compSuper;
                        typeSuper = clzSuper.getFormalType();
                    } else {
                        return false;
                    }
                    Component.Composition composition = clzSuper.getFormat() == Component.Format.INTERFACE ? Component.Composition.Implements : Component.Composition.Extends;
                    setContribs.add(new Component.Contribution((Component)this, composition, typeSuper));
                }
            }
            if (parent instanceof ClassStructure && !(clz = (ClassStructure)parent).isVirtualChild()) break;
            parent = parent.getParent();
            ++cDepth;
        }
        return true;
    }

    @Override
    protected Object findVirtualChildSuper(IdentityConstant idVirtChild, int cDepth, Set<IdentityConstant> setVisited) {
        Object oResult = super.findVirtualChildSuper(idVirtChild, cDepth, setVisited);
        if (oResult == null && this.isVirtualChild()) {
            oResult = this.getParent().findVirtualChildSuper(idVirtChild, cDepth + 1, setVisited);
        }
        return oResult;
    }

    @Override
    protected Iterator<IdentityConstant> potentialVirtualChildContributors() {
        ArrayList<IdentityConstant> list = null;
        for (Component.Contribution contrib : this.getContributionsAsList()) {
            TypeConstant type = contrib.getTypeConstant();
            switch (contrib.getComposition()) {
                case Annotation: {
                    if (this.isIntoClassAnnotation(type)) break;
                }
                case Incorporates: 
                case Implements: 
                case Extends: {
                    if (type.containsUnresolved()) {
                        return null;
                    }
                    if (!type.isExplicitClassIdentity(true)) break;
                    if (list == null) {
                        list = new ArrayList<IdentityConstant>();
                    }
                    list.add(type.getSingleUnderlyingClass(true));
                }
            }
        }
        return list == null ? Collections.emptyIterator() : list.iterator();
    }

    public TypeConstant getTypeInto() {
        switch (this.getFormat()) {
            case ANNOTATION: 
            case MIXIN: {
                break;
            }
            default: {
                throw new IllegalStateException("not an annotation or mixin: " + String.valueOf(this.getIdentityConstant()));
            }
        }
        Component.Contribution contribInto = this.findContribution(Component.Composition.Into);
        if (contribInto != null) {
            return contribInto.getTypeConstant();
        }
        ClassStructure structSuper = this.getSuper();
        if (structSuper != null) {
            return structSuper.getTypeInto();
        }
        return this.getConstantPool().typeObject();
    }

    public int indexOfGenericParameter(String sParamName) {
        List<Map.Entry<StringConstant, TypeConstant>> listFormal = this.getTypeParamsAsList();
        int c = listFormal.size();
        for (int i = 0; i < c; ++i) {
            if (!listFormal.get(i).getKey().getValue().equals(sParamName)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsGenericParamType(String sName) {
        return this.containsGenericParamTypeImpl(sName, true);
    }

    protected boolean containsGenericParamTypeImpl(String sName, boolean fAllowInto) {
        int ix = this.indexOfGenericParameter(sName);
        if (ix >= 0) {
            return true;
        }
        block7: for (Component.Contribution contrib : this.getContributionsAsList()) {
            ClassStructure clzContrib;
            boolean fCheck;
            TypeConstant typeContrib = contrib.getTypeConstant();
            if (typeContrib.containsUnresolved() || !typeContrib.isSingleUnderlyingClass(true)) continue;
            switch (contrib.getComposition()) {
                case Annotation: {
                    fCheck = !this.isIntoClassAnnotation(typeContrib);
                    fAllowInto = false;
                    break;
                }
                case Into: {
                    fCheck = fAllowInto;
                    fAllowInto = false;
                    break;
                }
                case Incorporates: {
                    fAllowInto = false;
                }
                case Delegates: 
                case Implements: 
                case Extends: {
                    fCheck = true;
                    break;
                }
                case Import: {
                    continue block7;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (!fCheck || !(clzContrib = (ClassStructure)typeContrib.getSingleUnderlyingClass(true).getComponent()).containsGenericParamTypeImpl(sName, fAllowInto)) continue;
            return true;
        }
        return false;
    }

    public TypeConstant getGenericParamType(ConstantPool pool, String sName, TypeConstant typeActual) {
        return this.getGenericParamTypeImpl(pool, sName, typeActual, true);
    }

    protected TypeConstant getGenericParamTypeImpl(ConstantPool pool, String sName, TypeConstant typeActual, boolean fAllowInto) {
        int ix = this.indexOfGenericParameter(sName);
        if (ix >= 0) {
            return this.extractGenericType(pool, ix, typeActual.getParamTypes());
        }
        block7: for (Component.Contribution contrib : this.getContributionsAsList()) {
            boolean fCheck;
            TypeConstant typeResolved;
            TypeConstant typeContrib = contrib.getTypeConstant();
            if (typeContrib.containsUnresolved() || !typeContrib.isSingleUnderlyingClass(true) || (typeResolved = contrib.resolveType(pool, this, typeActual)) == null) continue;
            switch (contrib.getComposition()) {
                case Annotation: {
                    fCheck = !this.isIntoClassAnnotation(typeContrib);
                    fAllowInto = false;
                    break;
                }
                case Into: {
                    fCheck = fAllowInto;
                    fAllowInto = false;
                    break;
                }
                case Incorporates: {
                    fAllowInto = false;
                }
                case Delegates: 
                case Implements: 
                case Extends: {
                    fCheck = true;
                    break;
                }
                case Import: {
                    continue block7;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (!fCheck) continue;
            ClassStructure clzContrib = (ClassStructure)typeContrib.getSingleUnderlyingClass(true).getComponent();
            TypeConstant type = clzContrib.getGenericParamTypeImpl(pool, sName, typeResolved, fAllowInto);
            if (type != null) {
                return type;
            }
            if (!clzContrib.isVirtualChild() || !typeResolved.isVirtualChild() || (type = clzContrib.getOuter().getGenericParamTypeImpl(pool, sName, typeResolved.getParentType(), fAllowInto)) == null) continue;
            return type;
        }
        return null;
    }

    private TypeConstant extractGenericType(ConstantPool pool, String sName, List<TypeConstant> list) {
        int ix = this.indexOfGenericParameter(sName);
        return ix >= 0 ? this.extractGenericType(pool, ix, list) : null;
    }

    private TypeConstant extractGenericType(ConstantPool pool, int ix, List<TypeConstant> list) {
        if (this.isTuple()) {
            return pool.ensureTupleType(list.toArray(TypeConstant.NO_TYPES));
        }
        return ix < list.size() ? list.get(ix) : null;
    }

    @Override
    public void addAnnotation(Annotation annotation) {
        super.addAnnotation(annotation);
        this.m_aAnnoMixin = null;
        this.m_aAnnoClass = null;
    }

    public TypeConstant.Relation calculateAssignability(ConstantPool pool, List<TypeConstant> listLeft, Constants.Access accessLeft, List<TypeConstant> listRight) {
        List<TypeConstant> listRightNormalized;
        int cParamsLeft = listLeft.size();
        int cParamsRight = listRight.size();
        int cParamsMax = Math.max(cParamsRight, cParamsLeft);
        boolean fTuple = this.isTuple();
        boolean fWeak = false;
        List<Map.Entry<StringConstant, TypeConstant>> listFormal = this.getTypeParamsAsList();
        List<TypeConstant> list = listRightNormalized = cParamsRight < cParamsLeft ? this.normalizeParameters(pool, listRight) : listRight;
        if (!fTuple && cParamsMax > listFormal.size()) {
            System.err.println("Invalid number of arguments for " + this.getName() + ": required=" + listFormal.size() + ", provided " + cParamsMax);
            return TypeConstant.Relation.INCOMPATIBLE;
        }
        Iterator<Map.Entry<StringConstant, TypeConstant>> iterFormal = listFormal.iterator();
        for (int i = 0; i < cParamsMax; ++i) {
            boolean fLeftIsRight;
            boolean fProduces;
            TypeConstant typeRight;
            String sName;
            String string = sName = fTuple ? null : iterFormal.next().getKey().getValue();
            if (i >= cParamsLeft) {
                if (!fTuple && !this.consumesFormalType(pool, sName, accessLeft, listLeft)) break;
                fWeak = true;
                break;
            }
            TypeConstant typeLeft = listLeft.get(i);
            if (i < cParamsRight) {
                typeRight = listRight.get(i);
                if (typeLeft.equals(typeRight)) continue;
                fProduces = fTuple || this.producesFormalType(pool, sName, accessLeft, listLeft);
                fLeftIsRight = typeLeft.isA(typeRight);
                if (fLeftIsRight && !fProduces) {
                    continue;
                }
            } else {
                if (typeLeft.isDynamicType()) continue;
                typeRight = fTuple ? pool.typeObject() : listRightNormalized.get(i);
                fProduces = fTuple || this.producesFormalType(pool, sName, accessLeft, listLeft);
                fLeftIsRight = false;
            }
            if (typeRight.isA(typeLeft)) {
                boolean fConsumes;
                if (fLeftIsRight) continue;
                boolean bl = fConsumes = fTuple || this.consumesFormalType(pool, sName, accessLeft, listLeft);
                if (fProduces || !fConsumes) {
                    if (!fConsumes) continue;
                    fWeak = true;
                    continue;
                }
                if (typeLeft.isFormalType()) {
                    fWeak = true;
                    continue;
                }
            }
            return TypeConstant.Relation.INCOMPATIBLE;
        }
        return fWeak ? TypeConstant.Relation.IS_A_WEAK : TypeConstant.Relation.IS_A;
    }

    public MethodStructure findMethod(String sName, int cArgs, TypeConstant ... aType) {
        return this.findMethod(sName, method -> {
            int cParamsDefault;
            int cParamsAll = method.getParamCount();
            if (cArgs < cParamsAll - (cParamsDefault = method.getDefaultParamCount()) || cArgs > cParamsAll) {
                return false;
            }
            if (aType == null) {
                return true;
            }
            int c = Math.min(method.getParamCount(), aType.length);
            for (int i = 0; i < c; ++i) {
                TypeConstant typeParam = method.getParam(i).getType();
                TypeConstant typeTest = aType[i];
                if (typeTest == null || typeTest.isA(typeParam)) continue;
                return false;
            }
            return true;
        });
    }

    public MethodStructure findMethod(String sName, Predicate<MethodStructure> test) {
        MultiMethodStructure structMM = (MultiMethodStructure)this.getChild(sName);
        if (structMM != null) {
            for (MethodStructure method : structMM.methods()) {
                if (!test.test(method)) continue;
                return method;
            }
        }
        return null;
    }

    public MethodStructure findMethodDeep(String sName, Predicate<MethodStructure> test) {
        MethodStructure method = this.findMethod(sName, test);
        if (method == null) {
            for (Component.Contribution contrib : this.getContributionsAsList()) {
                TypeConstant typeContrib = contrib.getTypeConstant();
                switch (contrib.getComposition()) {
                    case Into: 
                    case Delegates: {
                        break;
                    }
                    case Annotation: {
                        if (this.isIntoClassAnnotation(typeContrib)) break;
                    }
                    case Incorporates: 
                    case Implements: 
                    case Extends: {
                        ClassStructure clzContrib;
                        if (!typeContrib.isExplicitClassIdentity(true) || (clzContrib = (ClassStructure)typeContrib.getSingleUnderlyingClass(true).getComponent()) == null || (method = clzContrib.findMethodDeep(sName, test)) == null) break;
                        return method;
                    }
                }
            }
        }
        return method;
    }

    public MethodStructure findConstructor(TypeConstant ... types) {
        MethodStructure method = this.findMethod("construct", types.length, types);
        if (method == null) {
            throw new IllegalStateException("no such constructor for " + types.length + " params on " + String.valueOf(this));
        }
        return method;
    }

    public MethodStructure findConstructor(Constant[] aconstArgs, TypeConstant typeTarget) {
        ConstantPool pool = typeTarget.getConstantPool();
        int cArgs = aconstArgs.length;
        return this.findMethod("construct", m -> {
            if (cArgs < m.getRequiredParamCount() || cArgs > m.getParamCount()) {
                return false;
            }
            TypeConstant[] atypeParam = m.getParamTypes();
            for (int i = 0; i < cArgs; ++i) {
                TypeConstant typeArg;
                Constant constArg = aconstArgs[i];
                if (constArg instanceof FrameDependentConstant) continue;
                if (constArg instanceof PropertyClassTypeConstant) {
                    PropertyClassTypeConstant constProp = (PropertyClassTypeConstant)constArg;
                    v0 = constProp.getProperty().getValueType(pool, null);
                } else {
                    v0 = typeArg = constArg.getType();
                }
                if (typeArg.isA(atypeParam[i].resolveGenerics(pool, typeTarget))) continue;
                return false;
            }
            return true;
        });
    }

    public PropertyStructure findPropertyDeep(String sName) {
        PropertyStructure prop;
        Component component = this.getChild(sName);
        if (component == null) {
            for (Component.Contribution contrib : this.getContributionsAsList()) {
                TypeConstant typeContrib = contrib.getTypeConstant();
                switch (contrib.getComposition()) {
                    case Into: 
                    case Delegates: {
                        break;
                    }
                    case Annotation: {
                        if (this.isIntoClassAnnotation(typeContrib)) break;
                    }
                    case Incorporates: 
                    case Implements: 
                    case Extends: {
                        PropertyStructure prop2;
                        ClassStructure clzContrib;
                        if (!typeContrib.isExplicitClassIdentity(true) || (clzContrib = (ClassStructure)typeContrib.getSingleUnderlyingClass(true).getComponent()) == null || (prop2 = clzContrib.findPropertyDeep(sName)) == null) break;
                        return prop2;
                    }
                }
            }
        }
        return component instanceof PropertyStructure ? (prop = (PropertyStructure)component) : null;
    }

    public TypeConstant.Relation calculateRelation(ConstantPool pool, TypeConstant typeLeft, TypeConstant typeRight) {
        return this.calculateRelationImpl(pool, typeLeft, typeRight, true);
    }

    protected TypeConstant.Relation calculateRelationImpl(ConstantPool pool, TypeConstant typeLeft, TypeConstant typeRight, boolean fAllowInto) {
        assert (typeLeft.isSingleDefiningConstant());
        Constant constIdLeft = typeLeft.getDefiningConstant();
        IdentityConstant idClzRight = this.getIdentityConstant();
        if (this.containsVirtualChild() && typeLeft.equals(pool.typeOuter()) || this.isVirtualChild() && typeLeft.equals(pool.typeInner())) {
            return TypeConstant.Relation.IS_A;
        }
        switch (constIdLeft.getFormat()) {
            case Module: 
            case Package: {
                return constIdLeft.equals(idClzRight) ? TypeConstant.Relation.IS_A : TypeConstant.Relation.INCOMPATIBLE;
            }
            case NativeClass: {
                constIdLeft = ((NativeRebaseConstant)constIdLeft).getClassConstant();
            }
            case Class: {
                ClassStructure clzRebase;
                if (constIdLeft.equals(pool.clzObject())) {
                    return TypeConstant.Relation.IS_A;
                }
                if (constIdLeft.equals(idClzRight)) {
                    TypeConstant.Relation relation = this.calculateAssignability(pool, typeLeft.getParamTypes(), typeLeft.getAccess(), typeRight.getParamTypes());
                    if (relation == TypeConstant.Relation.INCOMPATIBLE || !this.isVirtualChild()) {
                        return relation;
                    }
                    assert (typeLeft.isVirtualChild() && typeRight.isVirtualChild());
                    TypeConstant typeParentLeft = typeLeft.getParentType();
                    TypeConstant typeParentRight = typeRight.getParentType();
                    if (typeParentRight.isA(typeParentLeft) || typeRight.containsAutoNarrowing(true) && typeParentLeft.isA(typeParentRight)) {
                        return relation;
                    }
                    return TypeConstant.Relation.INCOMPATIBLE;
                }
                IdentityConstant idClzLeft = (IdentityConstant)constIdLeft;
                if (typeLeft.isVirtualChild() && typeRight.isVirtualChild() && idClzLeft.getName().equals(idClzRight.getName())) {
                    TypeConstant typeParentLeft = typeLeft.getParentType();
                    TypeConstant typeParentRight = typeRight.getParentType();
                    if (typeParentRight.isA(typeParentLeft)) {
                        return this.calculateAssignability(pool, typeLeft.getParamTypes(), typeLeft.getAccess(), typeRight.getParamTypes());
                    }
                    if (typeRight.containsAutoNarrowing(true) && typeParentLeft.isA(typeParentRight)) {
                        return ((ClassStructure)idClzLeft.getComponent()).calculateAssignability(pool, typeLeft.getParamTypes(), typeLeft.getAccess(), typeRight.getParamTypes());
                    }
                    return TypeConstant.Relation.INCOMPATIBLE;
                }
                TypeConstant typeRebase = this.getRebaseType();
                if (typeRebase == null || (clzRebase = (ClassStructure)typeRebase.getSingleUnderlyingClass(true).getComponent()).calculateRelationImpl(pool, typeLeft, clzRebase.getCanonicalType(), fAllowInto) != TypeConstant.Relation.IS_A) break;
                return TypeConstant.Relation.IS_A;
            }
            case Property: 
            case TypeParameter: 
            case FormalTypeChild: 
            case UnresolvedName: {
                return TypeConstant.Relation.INCOMPATIBLE;
            }
            case ThisClass: 
            case ParentClass: 
            case ChildClass: {
                assert (typeLeft.containsAutoNarrowing(false));
                TypeConstant.Relation relation = this.calculateRelationImpl(pool, typeLeft.removeAutoNarrowing(), typeRight, fAllowInto);
                if (relation == TypeConstant.Relation.INCOMPATIBLE) break;
                return relation;
            }
            case Typedef: {
                return this.calculateRelationImpl(pool, ((TypedefConstant)constIdLeft).getReferredToType(), typeRight, fAllowInto);
            }
            case IsConst: 
            case IsEnum: 
            case IsModule: 
            case IsPackage: 
            case IsClass: {
                return this.calculateRelationImpl(pool, ((KeywordConstant)constIdLeft).getBaseType(), typeRight, fAllowInto);
            }
            default: {
                throw new IllegalStateException("unexpected constant: " + String.valueOf(constIdLeft));
            }
        }
        TypeConstant.Relation relation = TypeConstant.Relation.INCOMPATIBLE;
        block17: for (Component.Contribution contrib : this.getContributionsAsList()) {
            TypeConstant typeContrib = contrib.getTypeConstant();
            Component.Composition composition = contrib.getComposition();
            switch (composition) {
                case Into: {
                    if (!fAllowInto) break;
                }
                case Delegates: 
                case Implements: {
                    if (typeContrib.equals(pool.typeObject())) continue block17;
                    typeContrib = typeContrib.resolveGenerics(pool, typeRight.normalizeParameters());
                    if (typeRight.isAutoNarrowing() && typeContrib.isSingleUnderlyingClass(true)) {
                        typeContrib = typeContrib.ensureAutoNarrowing();
                    }
                    if ((relation = relation.bestOf(typeContrib.calculateRelation(typeLeft))) != TypeConstant.Relation.IS_A) continue block17;
                    return TypeConstant.Relation.IS_A;
                }
                case Annotation: {
                    if (this.isIntoClassAnnotation(typeContrib)) break;
                }
                case Incorporates: {
                    fAllowInto = false;
                }
                case Extends: {
                    assert (typeContrib.isExplicitClassIdentity(true));
                    if (composition == Component.Composition.Incorporates && contrib.resolveType(pool, this, typeRight) == null) break;
                    typeContrib = typeContrib.resolveGenerics(pool, typeRight.normalizeParameters());
                    IdentityConstant idContrib = typeContrib.getSingleUnderlyingClass(true);
                    ClassStructure clzBase = (ClassStructure)idContrib.getComponent();
                    if (typeContrib.isVirtualChild()) {
                        if (!typeRight.isVirtualChild()) {
                            return TypeConstant.Relation.INCOMPATIBLE;
                        }
                        TypeConstant typeParent = typeRight.getOriginParentType();
                        if (typeParent.isA(typeContrib.getParentType())) {
                            typeContrib = typeContrib.ensureVirtualParent(typeParent, !this.getName().equals(clzBase.getName()));
                            clzBase = (ClassStructure)typeContrib.getSingleUnderlyingClass(true).getComponent();
                        }
                    }
                    if ((relation = relation.bestOf(clzBase.calculateRelationImpl(pool, typeLeft, typeContrib, fAllowInto))) != TypeConstant.Relation.IS_A) continue block17;
                    return TypeConstant.Relation.IS_A;
                }
                case Import: {
                    assert (typeContrib.isSingleUnderlyingClass(false));
                    IdentityConstant idContrib = typeContrib.getSingleUnderlyingClass(false);
                    ModuleStructure clzModule = (ModuleStructure)idContrib.getComponent();
                    if (clzModule.getContributionsAsList().isEmpty() || (relation = relation.bestOf(clzModule.calculateRelationImpl(pool, typeLeft, typeContrib, false))) != TypeConstant.Relation.IS_A) continue block17;
                    return TypeConstant.Relation.IS_A;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return relation;
    }

    public TypeConstant.Relation findUnionContribution(ConstantPool pool, UnionTypeConstant typeLeft, List<TypeConstant> listRight) {
        TypeConstant.Relation relation = TypeConstant.Relation.INCOMPATIBLE;
        block5: for (Component.Contribution contrib : this.getContributionsAsList()) {
            TypeConstant typeContrib = contrib.getTypeConstant();
            switch (contrib.getComposition()) {
                case Extends: {
                    assert (typeContrib.isExplicitClassIdentity(true));
                    ClassConstant constContrib = (ClassConstant)typeContrib.getSingleUnderlyingClass(true);
                    TypeConstant typeResolved = contrib.resolveType(pool, this, listRight);
                    if ((relation = relation.bestOf(((ClassStructure)constContrib.getComponent()).findUnionContribution(pool, typeLeft, typeResolved.getParamTypes()))) != TypeConstant.Relation.IS_A) continue block5;
                    return TypeConstant.Relation.IS_A;
                }
                case Into: 
                case Implements: {
                    if ((typeContrib = typeContrib.resolveGenerics(pool, new SimpleTypeResolver(pool, listRight))) == null) continue block5;
                    if (typeContrib.equals(pool.typeObject())) {
                        return TypeConstant.Relation.INCOMPATIBLE;
                    }
                    if ((relation = relation.bestOf(typeContrib.calculateRelation(typeLeft))) != TypeConstant.Relation.IS_A) continue block5;
                    return TypeConstant.Relation.IS_A;
                }
                case Annotation: 
                case Incorporates: 
                case Delegates: {
                    return TypeConstant.Relation.INCOMPATIBLE;
                }
            }
            throw new IllegalStateException();
        }
        return relation;
    }

    public boolean consumesFormalType(ConstantPool pool, String sName, Constants.Access access, List<TypeConstant> listActual) {
        return this.consumesFormalTypeImpl(pool, sName, access, listActual, true);
    }

    protected boolean consumesFormalTypeImpl(ConstantPool pool, String sName, Constants.Access access, List<TypeConstant> listActual, boolean fAllowInto) {
        assert (this.indexOfGenericParameter(sName) >= 0);
        for (Component component : this.children()) {
            PropertyStructure property;
            if (component instanceof MultiMethodStructure) {
                MultiMethodStructure mms = (MultiMethodStructure)component;
                for (MethodStructure method : mms.methods()) {
                    if (method.isStatic() || !method.isAccessible(access) || !method.consumesFormalType(sName)) continue;
                    return true;
                }
                continue;
            }
            if (!(component instanceof PropertyStructure) || (property = (PropertyStructure)component).isGenericTypeParameter()) continue;
            TypeConstant constType = property.getType();
            if (!listActual.isEmpty()) {
                constType = constType.resolveGenerics(pool, new SimpleTypeResolver(pool, listActual));
            }
            if (property.isRefAccessible(access) && constType.consumesFormalType(sName, Constants.Access.PUBLIC)) {
                return true;
            }
            if (property.isExplicitReadOnly() || !property.isVarAccessible(access) || !constType.producesFormalType(sName, Constants.Access.PUBLIC)) continue;
            return true;
        }
        block9: for (Component.Contribution contribution : this.getContributionsAsList()) {
            TypeConstant typeContrib = contribution.getTypeConstant();
            switch (contribution.getComposition()) {
                case Delegates: 
                case Implements: {
                    break;
                }
                case Into: {
                    if (fAllowInto) break;
                    continue block9;
                }
                case Annotation: {
                    if (this.isIntoClassAnnotation(typeContrib)) continue block9;
                }
                case Incorporates: {
                    fAllowInto = false;
                }
                case Extends: {
                    assert (typeContrib.isExplicitClassIdentity(true));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (typeContrib.isExplicitClassIdentity(true)) {
                TypeConstant typeResolved = contribution.resolveType(pool, this, listActual);
                if (typeResolved == null || !typeResolved.isParamsSpecified()) continue;
                ClassStructure clzContrib = (ClassStructure)typeContrib.getSingleUnderlyingClass(true).getComponent();
                ListMap<StringConstant, TypeConstant> mapFormal = clzContrib.getTypeParams();
                List<TypeConstant> listContribParams = clzContrib.normalizeParameters(pool, typeContrib.getParamTypes());
                List<TypeConstant> listContribActual = typeResolved.getParamTypes();
                Iterator<TypeConstant> iterParams = listContribParams.iterator();
                Iterator iterNames = mapFormal.keySet().iterator();
                while (iterParams.hasNext()) {
                    TypeConstant constParam = iterParams.next();
                    String sFormal = ((StringConstant)iterNames.next()).getValue();
                    if ((!constParam.producesFormalType(sName, access) || !clzContrib.consumesFormalTypeImpl(pool, sFormal, access, listContribActual, fAllowInto)) && (!constParam.consumesFormalType(sName, access) || !clzContrib.producesFormalTypeImpl(pool, sFormal, access, listContribActual, fAllowInto))) continue;
                    return true;
                }
                continue;
            }
            if (!typeContrib.consumesFormalType(sName, access)) continue;
            return true;
        }
        return false;
    }

    public boolean producesFormalType(ConstantPool pool, String sName, Constants.Access access, List<TypeConstant> listActual) {
        return this.producesFormalTypeImpl(pool, sName, access, listActual, true);
    }

    protected boolean producesFormalTypeImpl(ConstantPool pool, String sName, Constants.Access access, List<TypeConstant> listActual, boolean fAllowInto) {
        assert (this.indexOfGenericParameter(sName) >= 0);
        for (Component component : this.children()) {
            PropertyStructure property;
            if (component instanceof MultiMethodStructure) {
                MultiMethodStructure mms = (MultiMethodStructure)component;
                for (MethodStructure method : mms.methods()) {
                    if (method.isStatic() || !method.isAccessible(access) || !method.producesFormalType(sName)) continue;
                    return true;
                }
                continue;
            }
            if (!(component instanceof PropertyStructure) || (property = (PropertyStructure)component).isGenericTypeParameter()) continue;
            TypeConstant constType = property.getType();
            if (!listActual.isEmpty()) {
                constType = constType.resolveGenerics(pool, new SimpleTypeResolver(pool, listActual));
            }
            if (property.isRefAccessible(access) && constType.producesFormalType(sName, Constants.Access.PUBLIC)) {
                return true;
            }
            if (property.isExplicitReadOnly() || !property.isVarAccessible(access) || !constType.consumesFormalType(sName, Constants.Access.PUBLIC)) continue;
            return true;
        }
        block9: for (Component.Contribution contribution : this.getContributionsAsList()) {
            TypeConstant typeContrib = contribution.getTypeConstant();
            switch (contribution.getComposition()) {
                case Delegates: 
                case Implements: {
                    break;
                }
                case Into: {
                    if (fAllowInto) break;
                    continue block9;
                }
                case Annotation: {
                    if (this.isIntoClassAnnotation(typeContrib)) continue block9;
                }
                case Incorporates: {
                    fAllowInto = false;
                }
                case Extends: {
                    assert (typeContrib.isExplicitClassIdentity(true));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (typeContrib.isExplicitClassIdentity(true)) {
                TypeConstant typeResolved = contribution.resolveType(pool, this, listActual);
                if (typeResolved == null || !typeResolved.isParamsSpecified()) continue;
                ClassStructure clzContrib = (ClassStructure)typeContrib.getSingleUnderlyingClass(true).getComponent();
                ListMap<StringConstant, TypeConstant> mapFormal = clzContrib.getTypeParams();
                List<TypeConstant> listContribParams = clzContrib.normalizeParameters(pool, typeContrib.getParamTypes());
                List<TypeConstant> listContribActual = typeResolved.getParamTypes();
                Iterator<TypeConstant> iterParams = listContribParams.iterator();
                Iterator iterNames = mapFormal.keySet().iterator();
                while (iterParams.hasNext()) {
                    TypeConstant constParam = iterParams.next();
                    String sFormal = ((StringConstant)iterNames.next()).getValue();
                    if ((!constParam.producesFormalType(sName, access) || !clzContrib.producesFormalTypeImpl(pool, sFormal, access, listContribActual, fAllowInto)) && (!constParam.consumesFormalType(sName, access) || !clzContrib.consumesFormalTypeImpl(pool, sFormal, access, listContribActual, fAllowInto))) continue;
                    return true;
                }
                continue;
            }
            if (!typeContrib.producesFormalType(sName, access)) continue;
            return true;
        }
        return false;
    }

    public Set<SignatureConstant> isInterfaceAssignableFrom(TypeConstant typeRight, Constants.Access accessRight, List<TypeConstant> listLeft) {
        ConstantPool pool = typeRight.getConstantPool();
        HashSet<SignatureConstant> setMiss = new HashSet<SignatureConstant>();
        SimpleTypeResolver resolver = null;
        for (Component component : this.children()) {
            if (component instanceof PropertyStructure) {
                PropertyStructure prop = (PropertyStructure)component;
                if (prop.isGenericTypeParameter()) {
                    if (typeRight.containsGenericParam(prop.getName())) continue;
                    setMiss.add(prop.getIdentityConstant().getSignature());
                    continue;
                }
                if (!prop.isRefAccessible(accessRight) || prop.isStatic()) continue;
                SignatureConstant sig = prop.getIdentityConstant().getSignature();
                if (!listLeft.isEmpty()) {
                    if (resolver == null) {
                        resolver = new SimpleTypeResolver(pool, listLeft);
                    }
                    sig = sig.resolveGenericTypes(pool, resolver);
                }
                if (typeRight.containsSubstitutableMethod(sig, accessRight, false, Collections.emptyList())) continue;
                setMiss.add(sig);
                continue;
            }
            if (!(component instanceof MultiMethodStructure)) continue;
            MultiMethodStructure mms = (MultiMethodStructure)component;
            for (MethodStructure method : mms.methods()) {
                if (!method.isAccessible(accessRight)) continue;
                SignatureConstant sig = method.getIdentityConstant().getSignature();
                if (method.isVirtualConstructor()) {
                    setMiss.add(sig);
                    continue;
                }
                if (method.isFunction()) {
                    if (method.hasCode() || typeRight.containsSubstitutableMethod(sig, accessRight, true, Collections.emptyList())) continue;
                    setMiss.add(sig);
                    continue;
                }
                if (!listLeft.isEmpty()) {
                    if (resolver == null) {
                        resolver = new SimpleTypeResolver(pool, listLeft);
                    }
                    sig = sig.resolveGenericTypes(pool, resolver);
                }
                if (typeRight.containsSubstitutableMethod(sig, accessRight, false, Collections.emptyList())) continue;
                setMiss.add(sig);
            }
        }
        for (Component.Contribution contribution : this.getContributionsAsList()) {
            TypeConstant typeResolved;
            if (contribution.getComposition() != Component.Composition.Implements || (typeResolved = contribution.resolveType(pool, this, listLeft)).containsUnresolved()) continue;
            ClassStructure clzSuper = (ClassStructure)typeResolved.getSingleUnderlyingClass(true).getComponent();
            assert (clzSuper.getFormat() == Component.Format.INTERFACE);
            setMiss.addAll(clzSuper.isInterfaceAssignableFrom(typeRight, accessRight, typeResolved.getParamTypes()));
        }
        return setMiss;
    }

    public boolean containsSubstitutableMethod(ConstantPool pool, SignatureConstant signature, Constants.Access access, boolean fFunction, List<TypeConstant> listParams) {
        return this.containsSubstitutableMethodImpl(pool, signature, access, fFunction, listParams, this.getIdentityConstant(), true);
    }

    protected boolean containsSubstitutableMethodImpl(ConstantPool pool, SignatureConstant signature, Constants.Access access, boolean fFunction, List<TypeConstant> listParams, IdentityConstant idClass, boolean fAllowInto) {
        Component child = this.getChild(signature.getName());
        if (signature.isProperty()) {
            PropertyStructure prop;
            if (child instanceof PropertyStructure && !(prop = (PropertyStructure)child).isStatic() && prop.isRefAccessible(access) && prop.isSubstitutableFor(pool, signature, listParams)) {
                return true;
            }
        } else if (child instanceof MultiMethodStructure) {
            MultiMethodStructure mms = (MultiMethodStructure)child;
            SimpleTypeResolver resolver = listParams.isEmpty() ? null : new SimpleTypeResolver(pool, listParams);
            for (MethodStructure method : mms.methods()) {
                SignatureConstant sigMethod = method.getIdentityConstant().getSignature();
                if (!method.isAccessible(access) || method.isFunction() != fFunction) continue;
                if (!fFunction) {
                    sigMethod = sigMethod.resolveGenericTypes(pool, resolver);
                }
                if (!sigMethod.isSubstitutableFor(signature, idClass.getType())) continue;
                return true;
            }
        }
        block8: for (Component.Contribution contrib : this.getContributionsAsList()) {
            ClassStructure clzContrib;
            TypeConstant typeResolved;
            TypeConstant typeContrib = contrib.getTypeConstant();
            if (typeContrib.containsUnresolved()) continue;
            switch (contrib.getComposition()) {
                case Delegates: 
                case Implements: 
                case Import: {
                    break;
                }
                case Into: {
                    if (fAllowInto) break;
                    continue block8;
                }
                case Annotation: {
                    if (this.isIntoClassAnnotation(typeContrib)) continue block8;
                }
                case Incorporates: {
                    fAllowInto = false;
                }
                case Extends: {
                    assert (typeContrib.isExplicitClassIdentity(true));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (!(typeContrib.isExplicitClassIdentity(true) ? (typeResolved = contrib.resolveType(pool, this, listParams)) != null && (clzContrib = (ClassStructure)typeResolved.getSingleUnderlyingClass(true).getComponent()).containsSubstitutableMethodImpl(pool, signature, access, fFunction, typeResolved.getParamTypes(), idClass, fAllowInto) : (typeContrib = contrib.resolveGenerics(pool, new SimpleTypeResolver(pool, listParams))).containsSubstitutableMethod(signature, access, fFunction, Collections.emptyList()))) continue;
            return true;
        }
        ClassConstant idObject = pool.clzObject();
        return !idClass.equals(idObject) && ((ClassStructure)idObject.getComponent()).containsSubstitutableMethod(pool, signature, access, fFunction, Collections.emptyList());
    }

    public MethodStructure createInitializer(ConstantPool pool, TypeConstant typeStruct, Map<Object, ClassComposition.FieldInfo> mapFields) {
        int nFlags = Component.Format.METHOD.ordinal() | Constants.Access.PUBLIC.FLAGS | 0x800 | 0x1000;
        MethodConstant idMethod = pool.ensureMethodConstant((IdentityConstant)pool.register(this.getIdentityConstant()), "default", TypeConstant.NO_TYPES, TypeConstant.NO_TYPES);
        ModuleStructure module = pool.getFileStructure().getModule();
        MethodStructure method = new MethodStructure(module, nFlags, idMethod, null, Annotation.NO_ANNOTATIONS, Parameter.NO_PARAMS, Parameter.NO_PARAMS, true, false);
        MethodStructure.Code code = method.createCode();
        assert (typeStruct.getAccess() == Constants.Access.STRUCT);
        TypeInfo infoStruct = typeStruct.ensureTypeInfo();
        for (Map.Entry<Object, ClassComposition.FieldInfo> entry : mapFields.entrySet()) {
            PropertyInfo infoProp;
            PropertyInfo propertyInfo;
            Object nid = entry.getKey();
            if (nid instanceof PropertyConstant) {
                PropertyConstant idProp = (PropertyConstant)nid;
                propertyInfo = infoStruct.findProperty(idProp);
            } else {
                propertyInfo = infoStruct.findPropertyByNid(nid);
            }
            if ((infoProp = propertyInfo) == null || infoProp.isInjected()) continue;
            ClassComposition.FieldInfo field = entry.getValue();
            final PropertyConstant idField = infoProp.getFieldIdentity();
            MethodConstant idInit = null;
            Constant constInit = null;
            if (infoProp.isInitialized()) {
                constInit = infoProp.getInitialValue();
                if (constInit == null) {
                    idInit = infoProp.getInitializer();
                }
            } else if (!infoProp.isImplicitlyAssigned()) {
                constInit = infoProp.getType().getDefaultValue();
            }
            if (constInit != null) {
                code.add(new L_Set(idField, constInit));
                if (field.isTransient()) {
                    field.constInit = constInit;
                }
            } else if (idInit != null) {
                MethodStructure methodInit = (MethodStructure)idInit.getComponent();
                if (methodInit.isFunction()) {
                    code.add(new Call_01(idInit, idField));
                } else {
                    code.add(new Invoke_01(new Register(typeStruct, "this", -5), idInit, idField));
                }
            }
            if (!field.isInflated()) continue;
            code.add(new Op(this){

                @Override
                public int process(Frame frame, int iPC) {
                    ObjectHandle.GenericHandle hStruct = (ObjectHandle.GenericHandle)frame.getThis();
                    xRef.RefHandle hRef = (xRef.RefHandle)hStruct.getField(frame, idField);
                    hRef.setField(frame, "$outer", (ObjectHandle)hStruct);
                    return iPC + 1;
                }

                @Override
                public void write(DataOutput out, Op.ConstantRegistry registry) {
                }

                @Override
                public String toString() {
                    return "initRef: " + String.valueOf(idField);
                }
            });
        }
        if (code.hasOps()) {
            code.add(new Return_0());
            method.forceAssembly(pool);
        } else {
            method.setAbstract(true);
        }
        return method;
    }

    public MethodStructure ensurePropertyDelegation(PropertyStructure prop, PropertyStructure propTarget, SignatureConstant sigAccessor) {
        MethodStructure methodDelegate;
        PropertyStructure propHost = (PropertyStructure)this.getChild(prop.getName());
        if (propHost == null) {
            assert (!prop.isStatic());
            propHost = this.createProperty(false, prop.getAccess(), prop.getVarAccess(), prop.getType(), prop.getName());
            propHost.setSynthetic(true);
        }
        if ((methodDelegate = propHost.findMethod(sigAccessor)) == null) {
            Parameter[] aReturns;
            Parameter[] aParams;
            boolean fGet;
            ConstantPool pool = this.getConstantPool();
            TypeConstant typeProp = prop.getType();
            if ("get".equals(sigAccessor.getName())) {
                fGet = true;
                aParams = Parameter.NO_PARAMS;
                aReturns = new Parameter[]{new Parameter(pool, typeProp, null, null, true, 0, false)};
            } else {
                fGet = false;
                aParams = new Parameter[]{new Parameter(pool, typeProp, prop.getName(), null, false, 0, false)};
                aReturns = Parameter.NO_PARAMS;
            }
            methodDelegate = propHost.createMethod(false, prop.getAccess(), null, aReturns, sigAccessor.getName(), aParams, true, false);
            methodDelegate.setSynthetic(true);
            MethodStructure.Code code = methodDelegate.createCode();
            PropertyConstant idDelegate = prop.getIdentityConstant();
            Register regTarget = code.createRegister(propTarget.getType());
            code.add(new L_Get(propTarget.getIdentityConstant(), regTarget));
            if (fGet) {
                Register regReturn = new Register(typeProp, prop.getIdentityConstant().getName(), -1);
                code.add(new P_Get(idDelegate, regTarget, regReturn));
                code.add(new Return_1(regReturn));
            } else {
                Register regArg = new Register(typeProp, prop.getIdentityConstant().getName(), 0);
                code.add(new P_Set(idDelegate, regTarget, regArg));
                code.add(new Return_0());
            }
            methodDelegate.forceAssembly(pool);
        }
        return methodDelegate;
    }

    public MethodStructure ensureMethodDelegation(MethodStructure method, String sDelegate) {
        SignatureConstant sig = method.getIdentityConstant().getSignature();
        MethodStructure methodDelegate = this.findMethod(sig);
        if (methodDelegate == null) {
            Register regProp;
            ConstantPool pool = this.getConstantPool();
            TypeConstant typeFormal = this.getFormalType();
            TypeConstant typePrivate = typeFormal.ensureAccess(Constants.Access.PRIVATE);
            TypeInfo infoPrivate = typePrivate.ensureTypeInfo();
            PropertyInfo infoDelegate = infoPrivate.findProperty(sDelegate);
            TypeConstant typeDelegate = infoDelegate.getType();
            Annotation[] aAnnos = new Annotation[]{pool.ensureAnnotation(pool.clzOverride(), new Constant[0])};
            Parameter[] aParams = (Parameter[])method.getParamArray().clone();
            Parameter[] aReturns = (Parameter[])method.getReturnArray().clone();
            methodDelegate = this.createMethod(false, method.getAccess(), aAnnos, aReturns, method.getName(), aParams, true, false);
            methodDelegate.setSynthetic(true);
            MethodStructure.Code code = methodDelegate.createCode();
            MethodInfo infoMethod = typeDelegate.ensureTypeInfo().getMethodBySignature(sig);
            MethodConstant idMethod = infoMethod.getIdentity();
            int cParams = method.getParamCount();
            int cReturns = method.getReturnCount();
            Argument[] aregParam = cParams == 0 ? null : new Register[cParams];
            boolean fAtomic = infoDelegate.isAtomic();
            for (int i = 0; i < cParams; ++i) {
                aregParam[i] = new Register(aParams[i].getType(), aParams[i].getName(), i);
            }
            if (infoDelegate.isConstant()) {
                Constant constValue = infoDelegate.getInitialValue();
                regProp = code.createRegister(typeDelegate);
                code.add(new Var_I(regProp, constValue == null ? pool.ensureSingletonConstConstant(infoDelegate.getIdentity()) : constValue));
            } else {
                regProp = code.createRegister(typeDelegate);
                code.add(new L_Get(infoDelegate.getIdentity(), regProp));
            }
            switch (cReturns) {
                case 0: {
                    if (fAtomic) {
                        Register regReturn = code.createRegister(pool.ensureFuture(pool.typeTuple()));
                        code.add(new Var_D(regReturn));
                        switch (cParams) {
                            case 0: {
                                code.add(new Invoke_01(regProp, idMethod, regReturn));
                                break;
                            }
                            case 1: {
                                code.add(new Invoke_11(regProp, idMethod, aregParam[0], regReturn));
                                break;
                            }
                            default: {
                                code.add(new Invoke_N1(regProp, idMethod, aregParam, regReturn));
                            }
                        }
                        code.add(new Return_1(regReturn));
                        break;
                    }
                    switch (cParams) {
                        case 0: {
                            code.add(new Invoke_00(regProp, idMethod));
                            break;
                        }
                        case 1: {
                            code.add(new Invoke_10(regProp, idMethod, aregParam[0]));
                            break;
                        }
                        default: {
                            code.add(new Invoke_N0(regProp, idMethod, aregParam));
                        }
                    }
                    code.add(new Return_0());
                    break;
                }
                case 1: {
                    Register regReturn;
                    TypeConstant typeReturn = aReturns[0].getType();
                    if (fAtomic) {
                        regReturn = code.createRegister(pool.ensureFuture(typeReturn));
                        code.add(new Var_D(regReturn));
                    } else {
                        regReturn = new Register(typeReturn, "result", -1);
                    }
                    switch (cParams) {
                        case 0: {
                            code.add(new Invoke_01(regProp, idMethod, regReturn));
                            break;
                        }
                        case 1: {
                            code.add(new Invoke_11(regProp, idMethod, aregParam[0], regReturn));
                            break;
                        }
                        default: {
                            code.add(new Invoke_N1(regProp, idMethod, aregParam, regReturn));
                        }
                    }
                    code.add(new Return_1(regReturn));
                    break;
                }
                default: {
                    Argument[] aregReturn = new Register[cReturns];
                    for (int i = 0; i < cReturns; ++i) {
                        TypeConstant typeReturn = aReturns[i].getType();
                        if (fAtomic) {
                            Register regReturn = code.createRegister(pool.ensureFuture(typeReturn));
                            code.add(new Var_D(regReturn));
                            aregReturn[i] = regReturn;
                            continue;
                        }
                        aregReturn[i] = code.createRegister(typeReturn);
                    }
                    switch (cParams) {
                        case 0: {
                            code.add(new Invoke_0N(regProp, idMethod, aregReturn));
                            break;
                        }
                        case 1: {
                            code.add(new Invoke_1N(regProp, idMethod, aregParam[0], aregReturn));
                            break;
                        }
                        default: {
                            code.add(new Invoke_NN(regProp, idMethod, aregParam, aregReturn));
                        }
                    }
                    code.add(new Return_N(aregReturn));
                    break;
                }
            }
            methodDelegate.forceAssembly(pool);
        }
        return methodDelegate;
    }

    public void synthesizeConstInterface(boolean fRuntime) {
        assert (this.getFormat() == Component.Format.CONST);
        ConstantPool pool = this.getConstantPool();
        this.synthesizeConstFunction("equals", 2, pool.typeBoolean());
        this.synthesizeConstFunction("compare", 2, pool.typeOrdered());
        this.synthesizeConstFunction("hashCode", 1, pool.typeInt64());
        this.synthesizeAppendTo(fRuntime);
    }

    private void synthesizeConstFunction(String sName, int cParams, TypeConstant typeReturn) {
        Predicate<MethodStructure> test = method -> {
            if (method.getTypeParamCount() != 1 || method.getParamCount() != 1 + cParams || !method.getParam(0).isTypeParameter() || method.getReturnCount() != 1 || !method.getReturn(0).getType().equals(typeReturn)) {
                return false;
            }
            return method.hasCode() && !method.isTransient() && !method.getIdentityConstant().getNamespace().equals(this.getConstantPool().clzObject());
        };
        MethodStructure fnThis = this.findMethodDeep(sName, test);
        if (fnThis == null) {
            ConstantPool pool = this.getConstantPool();
            TypeConstant typeThis = pool.ensureThisTypeConstant(this.getIdentityConstant(), null);
            TypeConstant typeType = typeThis.getType();
            Parameter[] aParam = new Parameter[1 + cParams];
            aParam[0] = new Parameter(pool, typeType, "CompileType", null, false, 0, true);
            if (cParams == 1) {
                aParam[1] = new Parameter(pool, new UnresolvedTypeConstant(pool, new UnresolvedNameConstant(pool, "CompileType")), "value", null, false, 1, false);
            } else {
                for (int i = 1; i <= cParams; ++i) {
                    aParam[i] = new Parameter(pool, new UnresolvedTypeConstant(pool, new UnresolvedNameConstant(pool, "CompileType")), "value" + i, null, false, i, false);
                }
            }
            Parameter[] aReturn = new Parameter[]{new Parameter(pool, typeReturn, null, null, true, 0, false)};
            fnThis = this.createMethod(true, Constants.Access.PUBLIC, null, aReturn, sName, aParam, true, false);
            fnThis.markNative();
            fnThis.markTransient();
            MethodConstant idMethod = fnThis.getIdentityConstant();
            TypeConstant[] atypeParams = idMethod.getRawParams();
            TypeParameterConstant constParam = pool.ensureRegisterConstant(idMethod, 0, "CompileType");
            TypeConstant typeFormal = constParam.getType();
            int c = atypeParams.length;
            for (int i = 1; i < c; ++i) {
                ((UnresolvedTypeConstant)atypeParams[i]).resolve(typeFormal);
            }
            fnThis.resolveTypedefs();
        }
    }

    private void synthesizeAppendTo(boolean fGenerateCode) {
        ConstantPool pool;
        TypeConstant typeAppender;
        MethodStructure methAppendTo;
        MethodStructure methToString = this.findMethod("toString", 0, new TypeConstant[0]);
        if (methToString != null && !methToString.usesSuper() && (methAppendTo = this.findMethod("appendTo", 1, typeAppender = (pool = this.getConstantPool()).ensureParameterizedTypeConstant(pool.ensureEcstasyTypeConstant("Appender"), pool.typeChar()))) == null) {
            MethodStructure methEstimate;
            Parameter[] aRet = new Parameter[]{new Parameter(pool, typeAppender, null, null, true, 0, false)};
            Parameter[] aParam = new Parameter[]{new Parameter(pool, typeAppender, "appender", null, false, 0, false)};
            Annotation[] aAnno = new Annotation[]{pool.ensureAnnotation(pool.clzOverride(), new Constant[0])};
            methAppendTo = this.createMethod(false, Constants.Access.PUBLIC, aAnno, aRet, "appendTo", aParam, true, false);
            methAppendTo.markTransient();
            if (fGenerateCode) {
                MethodStructure.Code code = methAppendTo.ensureCode();
                Register regThis = new Register(typeAppender, "this", -5);
                Register regAppender = new Register(typeAppender, "appender", 0);
                Register regString = new Register(typeAppender, "toString", -1);
                Register regResult = new Register(typeAppender, "result", -1);
                MethodConstant idToString = methToString.getIdentityConstant();
                MethodConstant idAppendTo = methAppendTo.getIdentityConstant();
                code.add(new Invoke_01(regThis, idToString, regString));
                code.add(new Invoke_11(regString, idAppendTo, regAppender, regResult));
                code.add(new Return_1(regResult));
                ExprAST[] aAstReg = new RegisterAST[]{(RegisterAST)regAppender.getRegisterAST()};
                InvokeExprAST astToString = new InvokeExprAST(idToString, new TypeConstant[]{regString.getType()}, regThis.getRegisterAST(), ExprAST.NO_EXPRS, false);
                InvokeExprAST astAppend = new InvokeExprAST(idAppendTo, new TypeConstant[]{typeAppender}, astToString, aAstReg, false);
                methAppendTo.setAst(new ReturnStmtAST(astAppend), (RegisterAST[])aAstReg);
                methAppendTo.forceAssembly(pool);
            }
            if ((methEstimate = this.findMethod("estimateStringLength", 0, new TypeConstant[0])) == null) {
                Parameter[] aReturn = new Parameter[]{new Parameter(pool, pool.typeInt64(), null, null, true, 0, false)};
                methEstimate = this.createMethod(false, Constants.Access.PUBLIC, aAnno, aReturn, "estimateStringLength", Parameter.NO_PARAMS, true, false);
                methEstimate.markTransient();
                if (fGenerateCode) {
                    MethodStructure.Code code = methEstimate.ensureCode();
                    code.add(new Return_1(pool.val0()));
                    methEstimate.setAst(new ReturnStmtAST(new ConstantExprAST(pool.val0())), BinaryAST.NO_REGS);
                    methEstimate.forceAssembly(pool);
                }
            }
        }
    }

    @Override
    protected void disassemble(DataInput in) throws IOException {
        super.disassemble(in);
        this.m_mapParams = this.disassembleTypeParams(in);
        this.m_constPath = (LiteralConstant)this.getConstantPool().getConstant(Handy.readIndex(in));
    }

    @Override
    protected void synthesizeChildren() {
        if (this.getFormat() == Component.Format.CONST) {
            this.synthesizeConstInterface(true);
        }
        super.synthesizeChildren();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        super.registerConstants(pool);
        this.m_mapParams = this.registerTypeParams(this.m_mapParams);
        this.m_constPath = (LiteralConstant)pool.register(this.m_constPath);
        this.m_typeCanonical = null;
        this.m_typeFormal = null;
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        super.assemble(out);
        this.assembleTypeParams(this.m_mapParams, out);
        Handy.writePackedLong(out, Constant.indexOf(this.m_constPath));
    }

    @Override
    public Iterator<? extends XvmStructure> getContained() {
        ArrayList<Annotation> listAnno = null;
        for (Component.Contribution contrib : this.getContributionsAsList()) {
            if (contrib.getComposition() != Component.Composition.Annotation) continue;
            if (listAnno == null) {
                listAnno = new ArrayList<Annotation>();
            }
            listAnno.add(contrib.getAnnotation());
        }
        return listAnno == null ? super.getContained() : new LinkedIterator(super.getContained(), listAnno.iterator());
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getDescription()).append(", type-params=");
        ListMap<StringConstant, TypeConstant> map = this.m_mapParams;
        if (map == null || map.isEmpty()) {
            sb.append("none");
        } else {
            sb.append('<');
            boolean fFirst = true;
            for (Map.Entry<StringConstant, TypeConstant> entry : map.entrySet()) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(entry.getKey().getValue());
                TypeConstant constType = entry.getValue();
                if ("ecstasy:Object".equals(constType.getValueString())) continue;
                sb.append(" extends ").append(constType);
            }
            sb.append('>');
        }
        sb.append(", source-path=").append(this.m_constPath == null ? "none" : this.m_constPath.getValueString());
        return sb.toString();
    }

    protected ListMap<StringConstant, TypeConstant> disassembleTypeParams(DataInput in) throws IOException {
        int c = Handy.readMagnitude(in);
        if (c <= 0) {
            assert (c == 0);
            return null;
        }
        ListMap<StringConstant, TypeConstant> map = new ListMap<StringConstant, TypeConstant>();
        ConstantPool pool = this.getConstantPool();
        for (int i = 0; i < c; ++i) {
            StringConstant constName = (StringConstant)pool.getConstant(Handy.readIndex(in));
            TypeConstant constType = (TypeConstant)pool.getConstant(Handy.readIndex(in));
            assert (!map.containsKey(constName));
            map.put(constName, constType);
        }
        return map;
    }

    protected ListMap<StringConstant, TypeConstant> registerTypeParams(ListMap<StringConstant, TypeConstant> mapOld) {
        if (mapOld == null || mapOld.isEmpty()) {
            return mapOld;
        }
        ConstantPool pool = this.getConstantPool();
        ListMap<StringConstant, TypeConstant> mapNew = mapOld;
        for (Map.Entry<StringConstant, TypeConstant> entry : mapOld.entrySet()) {
            StringConstant constOldKey = entry.getKey();
            StringConstant constNewKey = (StringConstant)pool.register(constOldKey);
            TypeConstant constOldVal = entry.getValue();
            TypeConstant constNewVal = (TypeConstant)pool.register(constOldVal);
            if (mapNew != mapOld || constOldKey != constNewKey) {
                if (mapNew == mapOld) {
                    mapNew = new ListMap();
                    for (Map.Entry<StringConstant, TypeConstant> entryCopy : mapOld.entrySet()) {
                        if (entryCopy.getKey() == constOldKey) break;
                        mapNew.put(entryCopy.getKey(), entryCopy.getValue());
                    }
                }
                mapNew.put(constNewKey, constNewVal);
                continue;
            }
            if (constOldVal == constNewVal) continue;
            entry.setValue(constNewVal);
        }
        return mapNew;
    }

    protected void assembleTypeParams(ListMap<StringConstant, TypeConstant> map, DataOutput out) throws IOException {
        int c = map == null ? 0 : map.size();
        Handy.writePackedLong(out, c);
        if (c == 0) {
            return;
        }
        for (Map.Entry<StringConstant, TypeConstant> entry : map.entrySet()) {
            Handy.writePackedLong(out, entry.getKey().getPosition());
            Handy.writePackedLong(out, entry.getValue().getPosition());
        }
    }

    public Component getNestedChild(Object id) {
        Object object = id;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, SignatureConstant.class}, (Object)object, n)) {
            case -1 -> this;
            case 0 -> {
                String sName = (String)object;
                yield this.getChild(sName);
            }
            case 1 -> {
                SignatureConstant sig = (SignatureConstant)object;
                yield this.findMethod(sig);
            }
            default -> ((IdentityConstant.NestedIdentity)id).getIdentityConstant().relocateNestedIdentity(this);
        };
    }

    public MethodStructure ensureSyntheticMethod(SignatureConstant sig) {
        assert (this.isSynthetic());
        MethodStructure method = this.findMethod(sig);
        if (method == null) {
            ConstantPool pool = this.getConstantPool();
            TypeConstant[] atypeParam = sig.getRawParams();
            TypeConstant[] atypeReturn = sig.getRawReturns();
            int cParams = atypeParam.length;
            int cReturns = atypeReturn.length;
            Parameter[] aParam = new Parameter[cParams];
            for (int i = 0; i < cParams; ++i) {
                aParam[i] = new Parameter(pool, atypeParam[i], "p" + i, null, false, i, false);
            }
            Parameter[] aReturn = new Parameter[cReturns];
            for (int i = 0; i < cReturns; ++i) {
                aReturn[i] = new Parameter(pool, atypeReturn[i], null, null, true, i, false);
            }
            method = this.createMethod(false, Constants.Access.PUBLIC, null, aReturn, sig.getName(), aParam, false, false);
            method.setSynthetic(true);
        }
        return method;
    }

    public PropertyStructure ensureSyntheticProperty(String sName, TypeConstant type) {
        assert (this.isSynthetic());
        PropertyStructure prop = (PropertyStructure)this.getChild(sName);
        if (prop == null) {
            prop = this.createProperty(false, Constants.Access.PUBLIC, Constants.Access.PUBLIC, type, sName);
        }
        return prop;
    }

    @Override
    public boolean equals(Object obj) {
        ClassStructure that;
        block5: {
            block4: {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof ClassStructure)) break block4;
                that = (ClassStructure)obj;
                if (super.equals(obj)) break block5;
            }
            return false;
        }
        ListMap<StringConstant, TypeConstant> mapThisParams = this.m_mapParams;
        ListMap<StringConstant, TypeConstant> mapThatParams = that.m_mapParams;
        int cThisParams = mapThisParams == null ? 0 : mapThisParams.size();
        int cThatParams = mapThatParams == null ? 0 : mapThatParams.size();
        return cThisParams == cThatParams && (cThisParams == 0 || mapThisParams.equals(mapThatParams)) && Handy.equals(this.m_constPath, that.m_constPath);
    }

    public void addImplicitTypeParameters(ConstantPool pool, ErrorListener errs) {
        assert (this.getFormat() == Component.Format.MIXIN || this.getFormat() == Component.Format.ANNOTATION);
        ListMap<String, TypeConstant> mapTypeParams = null;
        block3: for (Component.Contribution contribution : this.getContributionsAsList()) {
            TypeConstant[] atypeGeneric;
            switch (contribution.getComposition()) {
                case Into: 
                case Incorporates: 
                case Implements: 
                case Extends: {
                    break;
                }
                default: {
                    continue block3;
                }
            }
            TypeConstant typeContrib = contribution.getTypeConstant();
            if (typeContrib.isParamsSpecified() || (atypeGeneric = typeContrib.collectGenericParameters()) == null) continue;
            if (atypeGeneric.length == 0) {
                if (!typeContrib.isSingleUnderlyingClass(false) || typeContrib.getExplicitClassFormat() != Component.Format.MIXIN) continue;
                ClassStructure clzContrib = (ClassStructure)typeContrib.getSingleUnderlyingClass(false).getComponent();
                clzContrib.addImplicitTypeParameters(pool, errs);
                atypeGeneric = typeContrib.collectGenericParameters();
                if (atypeGeneric.length == 0) continue;
            }
            if (mapTypeParams == null) {
                mapTypeParams = new ListMap<String, TypeConstant>();
            }
            for (TypeConstant typeParam : atypeGeneric) {
                assert (typeParam.isGenericType());
                PropertyConstant idParam = (PropertyConstant)typeParam.getDefiningConstant();
                String sName = idParam.getName();
                TypeConstant typeConstraint = idParam.getConstraintType();
                TypeConstant typeOld = (TypeConstant)mapTypeParams.get(sName);
                if (typeOld == null) {
                    mapTypeParams.put(sName, typeConstraint);
                    continue;
                }
                if (typeOld.equals(typeConstraint)) continue;
                this.log(errs, Severity.ERROR, "VERIFY-05", this.getName(), typeOld.getValueString(), typeConstraint.getValueString(), contribution.getTypeConstant().getValueString());
                return;
            }
            contribution.narrowType(typeContrib.adoptParameters(pool, atypeGeneric));
        }
        if (mapTypeParams != null) {
            for (Map.Entry entry : mapTypeParams.entrySet()) {
                this.addTypeParam((String)entry.getKey(), (TypeConstant)entry.getValue()).setSynthetic(true);
            }
        }
    }

    public class SimpleTypeResolver
    implements GenericTypeResolver {
        private final ConstantPool f_pool;
        private List<TypeConstant> m_listActual;

        public SimpleTypeResolver(ConstantPool pool, List<TypeConstant> listActual) {
            int cActual;
            int cFormal;
            this.f_pool = pool;
            this.m_listActual = listActual;
            IdentityConstant id = ClassStructure.this.getIdentityConstant();
            if (!id.equals(pool.clzTuple()) && !id.equals(pool.clzCondTuple()) && (cFormal = ClassStructure.this.getTypeParamCount()) > (cActual = listActual.size())) {
                int i;
                TypeConstant typePublic;
                listActual = new ArrayList<TypeConstant>(listActual);
                this.m_listActual = listActual;
                List<Map.Entry<StringConstant, TypeConstant>> entries = ClassStructure.this.getTypeParamsAsList();
                if (id.equals(pool.clzClass()) && cActual > 0 && (typePublic = listActual.get(0)).isSingleUnderlyingClass(false) && !typePublic.isFormalType()) {
                    for (int i2 = cActual; i2 < cFormal; ++i2) {
                        listActual.add(pool.ensureAccessTypeConstant(typePublic, switch (i2) {
                            case 1 -> Constants.Access.PROTECTED;
                            case 2 -> Constants.Access.PRIVATE;
                            case 3 -> Constants.Access.STRUCT;
                            default -> throw new IllegalStateException();
                        }));
                    }
                    return;
                }
                for (i = cActual; i < cFormal; ++i) {
                    listActual.add(pool.typeObject());
                }
                for (i = cActual; i < cFormal; ++i) {
                    TypeConstant typeConstraint = entries.get(i).getValue();
                    listActual.set(i, typeConstraint.containsUnresolved() || !typeConstraint.containsFormalType(true) ? typeConstraint : (typeConstraint.isFormalTypeSequence() ? pool.typeTuple0() : typeConstraint.resolveGenerics(pool, this)));
                }
            }
        }

        @Override
        public TypeConstant resolveGenericType(String sFormalName) {
            return ClassStructure.this.extractGenericType(this.f_pool, sFormalName, this.m_listActual);
        }
    }
}

