/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.xvm.asm.Annotation;
import org.xvm.asm.AssemblerContext;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.CompositeComponent;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.Documentable;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.FileStructure;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.InjectionKey;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.MultiMethodStructure;
import org.xvm.asm.PackageStructure;
import org.xvm.asm.Parameter;
import org.xvm.asm.PropertyStructure;
import org.xvm.asm.SimulatedLinkerContext;
import org.xvm.asm.TypedefStructure;
import org.xvm.asm.Version;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.MultiMethodConstant;
import org.xvm.asm.constants.NamedConstant;
import org.xvm.asm.constants.PackageConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypedefConstant;
import org.xvm.util.Handy;
import org.xvm.util.Hash;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public abstract class Component
extends XvmStructure
implements Documentable,
Cloneable,
ComponentResolver {
    public static final int CONDITIONAL_BIT = 128;
    public static final int FORMAT_MASK = 15;
    public static final int FORMAT_SHIFT = 0;
    public static final int ACCESS_MASK = 768;
    public static final int ACCESS_SHIFT = 8;
    public static final int ACCESS_PUBLIC = 256;
    public static final int ACCESS_PROTECTED = 512;
    public static final int ACCESS_PRIVATE = 768;
    public static final int ABSTRACT_BIT = 1024;
    public static final int ABSTRACT_SHIFT = 10;
    public static final int STATIC_BIT = 2048;
    public static final int STATIC_SHIFT = 11;
    public static final int SYNTHETIC_BIT = 4096;
    public static final int SYNTHETIC_SHIFT = 12;
    public static final int COND_RET_BIT = 8192;
    public static final int COND_RET_SHIFT = 13;
    public static final int AUXILIARY_BIT = 16384;
    public static final int AUXILIARY_SHIFT = 14;
    private Component m_sibling;
    private IdentityConstant m_constId;
    private ConditionalConstant m_cond;
    private short m_nFlags;
    private List<Contribution> m_listContribs;
    private String m_sDoc;
    private volatile byte[] m_abChildren;
    private Map<String, Component> m_childByName;
    private boolean m_fModified;
    private transient Boolean m_FVisited;

    protected Component(XvmStructure xsParent, Constants.Access access, boolean fAbstract, boolean fStatic, boolean fSynthetic, Format format, IdentityConstant constId, ConditionalConstant condition) {
        this(xsParent, format.ordinal() << 0 | access.ordinal() << 8 | (fAbstract ? 1024 : 0) | (fStatic ? 2048 : 0) | (fSynthetic ? 4096 : 0), constId, condition);
    }

    protected Component(XvmStructure xsParent, int nFlags, IdentityConstant constId, ConditionalConstant condition) {
        super(xsParent);
        assert (xsParent == null == this instanceof FileStructure);
        assert (constId == null == this instanceof FileStructure);
        assert (condition == null || !(this instanceof FileStructure));
        if (constId != null) {
            constId = (IdentityConstant)constId.resolveTypedefs();
            constId.resetCachedInfo();
        }
        this.m_nFlags = (short)nFlags;
        this.m_cond = condition;
        this.m_constId = constId;
    }

    Component(Component parent) {
        super(parent);
    }

    public Component getParent() {
        Component component;
        XvmStructure containing = this.getContaining();
        while (true) {
            if (containing == null) {
                assert (this.getFormat() == Format.FILE);
                return null;
            }
            if (containing instanceof Component) break;
            containing = containing.getContaining();
        }
        Component parent = component = (Component)containing;
        if (parent.getCondition() == null) {
            return parent;
        }
        assert (parent.getFormat() != Format.FILE);
        Component grandparent = parent.getParent();
        return parent instanceof MethodStructure ? grandparent.getChild(parent.getIdentityConstant()) : grandparent.getChild(parent.getName());
    }

    public ClassStructure getContainingClass() {
        return this.getContainingClass(true);
    }

    public ClassStructure getContainingClass(boolean fAllowAnonymous) {
        for (Component parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof ClassStructure)) continue;
            ClassStructure clzParent = (ClassStructure)parent;
            if (!fAllowAnonymous && clzParent.isAnonInnerClass()) continue;
            return clzParent;
        }
        return null;
    }

    @Override
    public IdentityConstant getIdentityConstant() {
        return this.m_constId;
    }

    protected void replaceThisIdentityConstant(IdentityConstant idNew) {
        IdentityConstant idOld = this.m_constId;
        Iterator<Component> iter = this.siblings();
        while (iter.hasNext()) {
            iter.next().m_constId = idNew;
        }
        Component parent = this.getParent();
        if (parent != null) {
            parent.replaceChildIdentityConstant(idOld, idNew);
        }
    }

    protected void replaceChildIdentityConstant(IdentityConstant idOld, IdentityConstant idNew) {
        assert (idOld.getName().equals(idNew.getName()));
    }

    public Format getFormat() {
        return Format.valueOf((this.m_nFlags & 0xF) >>> 0);
    }

    public Constants.Access getAccess() {
        return Constants.Access.valueOf((this.m_nFlags & 0x300) >>> 8);
    }

    public void setAccess(Constants.Access access) {
        short nFlagsOld = this.m_nFlags;
        int nFlagsNew = nFlagsOld & 0xFFFFFCFF | access.ordinal() << 8;
        if (nFlagsNew != nFlagsOld) {
            this.m_nFlags = (short)nFlagsNew;
            this.markModified();
        }
    }

    public boolean isAbstract() {
        return (this.m_nFlags & 0x400) != 0;
    }

    public void setAbstract(boolean fAbstract) {
        short nFlagsOld = this.m_nFlags;
        int nFlagsNew = nFlagsOld & 0xFFFFFBFF | (fAbstract ? 1024 : 0);
        if (nFlagsNew != nFlagsOld) {
            this.m_nFlags = (short)nFlagsNew;
            this.markModified();
        }
    }

    public boolean isStatic() {
        return (this.m_nFlags & 0x800) != 0;
    }

    public void setStatic(boolean fStatic) {
        short nFlagsOld = this.m_nFlags;
        int nFlagsNew = nFlagsOld & 0xFFFFF7FF | (fStatic ? 2048 : 0);
        if (nFlagsNew != nFlagsOld) {
            this.m_nFlags = (short)nFlagsNew;
            this.markModified();
        }
    }

    public boolean isSynthetic() {
        return (this.m_nFlags & 0x1000) != 0;
    }

    public void setSynthetic(boolean fSynthetic) {
        short nFlagsOld = this.m_nFlags;
        int nFlagsNew = nFlagsOld & 0xFFFFEFFF | (fSynthetic ? 4096 : 0);
        if (nFlagsNew != nFlagsOld) {
            this.m_nFlags = (short)nFlagsNew;
            this.markModified();
        }
    }

    protected boolean isConditionalReturn() {
        return (this.m_nFlags & 0x2000) != 0;
    }

    protected void setConditionalReturn(boolean fConditional) {
        short nFlagsOld = this.m_nFlags;
        int nFlagsNew = nFlagsOld & 0xFFFFDFFF | (fConditional ? 8192 : 0);
        if (nFlagsNew != nFlagsOld) {
            this.m_nFlags = (short)nFlagsNew;
            this.markModified();
        }
    }

    protected boolean isAuxiliary() {
        return (this.m_nFlags & 0x4000) != 0;
    }

    protected void markAuxiliary() {
        short nFlagsOld = this.m_nFlags;
        int nFlagsNew = nFlagsOld & 0xFFFFBFFF | 0x4000;
        if (nFlagsNew != nFlagsOld) {
            this.m_nFlags = (short)nFlagsNew;
            this.markModified();
        }
    }

    public String getName() {
        return this.getIdentityConstant().getName();
    }

    public String getSimpleName() {
        return this.getName();
    }

    public boolean isGloballyVisible() {
        Component parent = this.getParent();
        return parent.isGloballyVisible() && !parent.isChildLessVisible();
    }

    protected boolean isChildLessVisible() {
        return false;
    }

    public boolean isAutoNarrowingAllowed() {
        return false;
    }

    public List<Contribution> getContributionsAsList() {
        List<Contribution> list = this.m_listContribs;
        if (list == null) {
            return Collections.emptyList();
        }
        assert ((list = Collections.unmodifiableList(this.m_listContribs)) != null);
        return list;
    }

    public boolean containsUnresolvedContribution() {
        return this.m_listContribs != null && this.m_listContribs.stream().anyMatch(Contribution::containsUnresolved);
    }

    public Contribution findContribution(Composition composition) {
        List<Contribution> list = this.m_listContribs;
        if (list != null) {
            for (Contribution contrib : list) {
                if (contrib.getComposition() != composition) continue;
                return contrib;
            }
        }
        return null;
    }

    public Contribution addContribution(Composition composition, TypeConstant constType) {
        return this.addContribution(new Contribution(composition, constType));
    }

    public void addImport(ModuleConstant constModule) {
        assert (this instanceof PackageStructure);
        this.addContribution(new Contribution(constModule));
    }

    public void addAnnotation(IdentityConstant constAnno, Constant ... aconstParam) {
        this.addAnnotation(this.getConstantPool().ensureAnnotation(constAnno, aconstParam));
    }

    public void addAnnotation(Annotation annotation) {
        this.addContribution(new Contribution(annotation));
    }

    public Contribution addDelegation(TypeConstant constClass, PropertyConstant constProp) {
        return this.addContribution(new Contribution(constClass, constProp));
    }

    public Contribution addIncorporates(TypeConstant constClass, Map<String, TypeConstant> mapConstraints) {
        ListMap<StringConstant, TypeConstant> map = null;
        if (mapConstraints != null) {
            ConstantPool pool = this.getConstantPool();
            map = new ListMap<StringConstant, TypeConstant>();
            for (Map.Entry<String, TypeConstant> entry : mapConstraints.entrySet()) {
                map.put(pool.ensureStringConstant(entry.getKey()), entry.getValue());
            }
        }
        return this.addContribution(new Contribution(constClass, map));
    }

    protected Contribution addContribution(Contribution contrib) {
        List<Contribution> list = this.m_listContribs;
        if (list == null) {
            this.m_listContribs = list = new ArrayList<Contribution>();
        } else if (!(list.isEmpty() || contrib.getComposition() != Composition.Into && contrib.getComposition() != Composition.Extends)) {
            ListIterator<Contribution> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Contribution contribNext = listIterator.next();
                if (contribNext.getComposition() == Composition.Into) continue;
                listIterator.previous();
                listIterator.add(contrib);
                return contrib;
            }
        }
        list.add(contrib);
        this.markModified();
        return contrib;
    }

    protected void removeContribution(Contribution contrib) {
        List<Contribution> list = this.m_listContribs;
        if (list != null) {
            list.remove(contrib);
        }
    }

    protected boolean isSiblingAllowed() {
        return this.getParent().isSiblingAllowed();
    }

    protected Component getEldestSibling() {
        Component parent = this.getParent();
        if (parent == null) {
            return this;
        }
        Component sibling = parent.getChildByNameMap().get(this.getName());
        assert (sibling != null);
        return sibling;
    }

    protected Component getNextSibling() {
        return this.isSiblingAllowed() ? this.m_sibling : null;
    }

    private void setNextSibling(Component sibling) {
        assert (sibling == null || this.isSiblingAllowed());
        this.m_sibling = sibling;
    }

    protected Iterator<Component> siblings() {
        if (!this.isSiblingAllowed()) {
            return new Iterator<Component>(){
                private boolean first = true;

                @Override
                public boolean hasNext() {
                    return this.first;
                }

                @Override
                public Component next() {
                    if (this.first) {
                        this.first = false;
                        return Component.this;
                    }
                    throw new NoSuchElementException();
                }
            };
        }
        return new Iterator<Component>(){
            private Component nextSibling;
            {
                this.nextSibling = Component.this.getEldestSibling();
            }

            @Override
            public boolean hasNext() {
                return this.nextSibling != null;
            }

            @Override
            public Component next() {
                Component sibling = this.nextSibling;
                if (sibling == null) {
                    throw new NoSuchElementException();
                }
                this.nextSibling = sibling.getNextSibling();
                return sibling;
            }
        };
    }

    public Map<String, Component> getChildByNameMap() {
        this.ensureChildren();
        Map<String, Component> map = this.m_childByName;
        return map == null ? Collections.emptyMap() : map;
    }

    public synchronized Map<String, Component> ensureChildByNameMap() {
        this.ensureChildren();
        Map<String, Component> map = this.m_childByName;
        if (map == null) {
            map = new ListMap<String, Component>();
            Iterator<Component> siblings = this.siblings();
            while (siblings.hasNext()) {
                siblings.next().m_childByName = map;
            }
            assert (this.m_childByName == map);
        }
        return map;
    }

    protected void ensureChildren() {
        if (this.m_abChildren != null) {
            this.ensureChildrenComplex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensureChildrenComplex() {
        byte[] ab = this.m_abChildren;
        if (ab == null) return;
        byte[] byArray = ab;
        synchronized (ab) {
            byte[] empty;
            if (ab.length == 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.m_abChildren == null) return;
            assert (ab == this.m_abChildren);
            byte[] byArray2 = empty = new byte[0];
            synchronized (empty) {
                Iterator<Component> siblings;
                Iterator<Component> siblings2 = this.siblings();
                while (siblings2.hasNext()) {
                    siblings2.next().m_abChildren = empty;
                }
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(ab));
                try {
                    this.disassembleChildren(in, true);
                    siblings = this.siblings();
                }
                catch (IOException e) {
                    try {
                        throw new IllegalStateException("IOException occurred in " + String.valueOf(this.getIdentityConstant()) + " during deferred read of child components", e);
                    }
                    catch (Throwable throwable) {
                        Iterator<Component> siblings3 = this.siblings();
                        while (siblings3.hasNext()) {
                            siblings3.next().m_abChildren = null;
                        }
                        throw throwable;
                    }
                }
                while (siblings.hasNext()) {
                    siblings.next().m_abChildren = null;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }
    }

    public void visitChildren(Consumer<Component> visitor, boolean fSiblings, boolean fRecursive) {
        Iterator<? extends Component> iterator = this.children().iterator();
        while (iterator.hasNext()) {
            Component component;
            Component componentEldest = component = iterator.next();
            do {
                visitor.accept(component);
                component = component.getNextSibling();
            } while (fSiblings && component != null);
            if (!fRecursive) continue;
            componentEldest.visitChildren(visitor, fSiblings, fRecursive);
        }
    }

    protected boolean addChild(Component child) {
        String sName;
        assert (!(child instanceof MethodStructure));
        Map<String, Component> kids = this.ensureChildByNameMap();
        Component sibling = kids.get(sName = child.getName());
        if (sibling == null) {
            kids.put(sName, child);
        } else if (this.isSiblingAllowed()) {
            this.linkSibling(child, sibling);
        } else {
            return false;
        }
        this.markModified();
        return true;
    }

    protected void linkSibling(Component child, Component sibling) {
        assert (this.isSiblingAllowed());
        child.setContaining(this);
        Component lastSibling = sibling;
        Component nextSibling = lastSibling.getNextSibling();
        while (nextSibling != null) {
            lastSibling = nextSibling;
            nextSibling = lastSibling.getNextSibling();
        }
        lastSibling.setNextSibling(child);
        child.adoptChildren(sibling);
    }

    protected void adoptChildren(Component that) {
        assert (this.m_abChildren == null);
        assert (this.m_childByName == null);
        this.m_abChildren = that.m_abChildren;
        this.m_childByName = that.m_childByName;
    }

    public void removeChild(Component child) {
        assert (child.getParent() == this);
        Map<String, Component> kids = this.ensureChildByNameMap();
        String sName = child.getName();
        Component sibling = kids.remove(sName);
        child.getIdentityConstant().resetCachedInfo();
        this.unlinkSibling(kids, sName, child, sibling);
    }

    protected void replaceChild(Component childOld, Component childNew) {
        assert (childOld != null && childNew != null);
        assert (childOld.getParent() == this);
        assert (childNew.getParent() == this);
        assert (childOld.getIdentityConstant().equals(childNew.getIdentityConstant()));
        this.ensureChildByNameMap().put(childNew.getName(), childNew);
        childNew.getIdentityConstant().resetCachedInfo();
    }

    protected void unlinkSibling(Map kids, Object id, Component child, Component sibling) {
        if (sibling == child && child.getNextSibling() == null) {
            this.markModified();
            return;
        }
        if (sibling == null) {
            return;
        }
        if (sibling == child) {
            kids.put(id, child.getNextSibling());
        } else {
            kids.put(id, sibling);
            do {
                if (sibling.getNextSibling() != child) continue;
                sibling.setNextSibling(child.getNextSibling());
                break;
            } while ((sibling = sibling.getNextSibling()) != null);
        }
        this.markModified();
    }

    public boolean isPackageContainer() {
        return false;
    }

    public PackageStructure createPackage(Constants.Access access, String sName, ConditionalConstant cond) {
        PackageConstant constId;
        assert (sName != null);
        assert (access != null);
        if (!this.isPackageContainer()) {
            throw new IllegalStateException("this (" + String.valueOf(this) + ") cannot contain a package");
        }
        int nFlags = Format.PACKAGE.ordinal() | access.FLAGS;
        PackageStructure struct = new PackageStructure((XvmStructure)this, nFlags, constId = this.getConstantPool().ensurePackageConstant(this.getIdentityConstant(), sName), cond);
        return this.addChild(struct) ? struct : null;
    }

    public boolean isClassContainer() {
        return false;
    }

    public MethodStructure.ConcurrencySafety getConcurrencySafety() {
        return this.getParent().getConcurrencySafety();
    }

    public ClassStructure createClass(Constants.Access access, Format format, String sName, ConditionalConstant cond) {
        ClassConstant constId;
        assert (sName != null);
        assert (access != null);
        if (!this.isClassContainer()) {
            throw new IllegalStateException("this (" + String.valueOf(this) + ") cannot contain a class");
        }
        int nFlags = format.ordinal() | access.FLAGS;
        ClassStructure struct = new ClassStructure(this, nFlags, constId = this.getConstantPool().ensureClassConstant(this.getIdentityConstant(), sName), cond);
        return this.addChild(struct) ? struct : null;
    }

    public boolean containsVirtualChild() {
        for (Component child : this.getChildByNameMap().values()) {
            switch (child.getIdentityConstant().getFormat()) {
                case Class: {
                    if (!((ClassStructure)child).isVirtualChild()) break;
                    return true;
                }
                case Property: {
                    if (!child.containsVirtualChild()) break;
                    return true;
                }
            }
        }
        return false;
    }

    public PropertyStructure createProperty(boolean fStatic, Constants.Access accessRef, Constants.Access accessVar, TypeConstant constType, String sName) {
        assert (sName != null);
        assert (accessRef != null);
        assert (accessVar == null || accessRef.ordinal() <= accessVar.ordinal());
        assert (constType != null);
        if (!this.isClassContainer()) {
            throw new IllegalStateException("this (" + String.valueOf(this) + ") cannot contain a property");
        }
        int nFlags = Format.PROPERTY.ordinal() | accessRef.FLAGS | (fStatic ? 2048 : 0);
        PropertyConstant constId = this.getConstantPool().ensurePropertyConstant(this.getIdentityConstant(), sName);
        PropertyStructure struct = new PropertyStructure(this, nFlags, constId, null, accessVar, constType);
        return this.addChild(struct) ? struct : null;
    }

    public TypedefStructure createTypedef(Constants.Access access, TypeConstant constType, String sName) {
        assert (sName != null);
        assert (access != null);
        assert (constType != null);
        if (!this.isClassContainer()) {
            throw new IllegalStateException("this (" + String.valueOf(this) + ") cannot contain a typedef");
        }
        int nFlags = Format.TYPEDEF.ordinal() | access.FLAGS;
        TypedefConstant constId = this.getConstantPool().ensureTypedefConstant(this.getIdentityConstant(), sName);
        TypedefStructure struct = new TypedefStructure((XvmStructure)this, nFlags, constId, null);
        struct.setType(constType);
        return this.addChild(struct) ? struct : null;
    }

    public boolean isMethodContainer() {
        return false;
    }

    public MethodStructure createMethod(boolean fFunction, Constants.Access access, Annotation[] annotations, Parameter[] aReturns, String sName, Parameter[] aParams, boolean fHasCode, boolean fUsesSuper) {
        assert (sName != null);
        assert (access != null);
        MultiMethodStructure multimethod = this.ensureMultiMethodStructure(sName);
        return multimethod == null ? null : multimethod.createMethod(fFunction, access, annotations, aReturns, aParams, fHasCode, fUsesSuper);
    }

    public MultiMethodStructure ensureMultiMethodStructure(String sName) {
        for (Component sibling = this.getChildByNameMap().get(sName); sibling != null; sibling = sibling.getNextSibling()) {
            if (!(sibling instanceof MultiMethodStructure)) continue;
            MultiMethodStructure mms = (MultiMethodStructure)sibling;
            return mms;
        }
        MultiMethodConstant constId = this.getConstantPool().ensureMultiMethodConstant(this.getIdentityConstant(), sName);
        MultiMethodStructure struct = new MultiMethodStructure((XvmStructure)this, Format.MULTIMETHOD.ordinal(), constId, null);
        return this.addChild(struct) ? struct : null;
    }

    protected void addVersion(Version ver) {
        ConditionalConstant cond = this.getCondition();
        if (cond == null) {
            this.setCondition(this.getConstantPool().ensureVersionedCondition(ver));
        } else {
            this.setCondition(cond.addVersion(ver));
        }
    }

    protected void removeVersion(Version ver) {
        ConditionalConstant cond = this.getCondition();
        if (cond != null) {
            this.setCondition(cond.removeVersion(ver));
        }
    }

    protected void addAndCondition(ConditionalConstant cond) {
        if (cond != null) {
            ConditionalConstant condOld = this.m_cond;
            this.m_cond = condOld == null ? cond : condOld.addAnd(cond);
            this.markModified();
        }
    }

    protected void addOrCondition(ConditionalConstant cond) {
        if (cond != null) {
            ConditionalConstant condOld = this.m_cond;
            this.m_cond = condOld == null ? cond : condOld.addOr(cond);
            this.markModified();
        }
    }

    protected boolean isBodyIdentical(Component that) {
        return this.m_nFlags == that.m_nFlags && this.m_constId.equals(that.m_constId);
    }

    protected boolean areChildrenIdentical(Component that) {
        this.ensureChildren();
        return this.equalChildMaps(this.getChildByNameMap(), that.getChildByNameMap());
    }

    protected boolean equalChildMaps(Map<?, ? extends Component> mapThis, Map<?, ? extends Component> mapThat) {
        if (mapThis.size() != mapThat.size()) {
            return false;
        }
        if (mapThis.isEmpty()) {
            return true;
        }
        for (Object key : mapThis.keySet()) {
            Component childThis = mapThis.get(key);
            Component childThat = mapThat.get(key);
            Component eachThis = childThis;
            for (Component eachThat = childThat; eachThis != null || eachThat != null; eachThis = eachThis.getNextSibling(), eachThat = eachThat.getNextSibling()) {
                if (eachThis != null && eachThat != null) continue;
                return false;
            }
            if (childThat != null) continue;
            return false;
        }
        return true;
    }

    public Component getChild(Constant constId) {
        if (constId instanceof NamedConstant) {
            NamedConstant constNamed = (NamedConstant)constId;
            Component firstSibling = this.getChildByNameMap().get(constNamed.getName());
            return this.findLinkedChild(constId, firstSibling);
        }
        return null;
    }

    protected Component findLinkedChild(Constant constId, Component firstSibling) {
        if (firstSibling == null) {
            return null;
        }
        if (firstSibling.getNextSibling() == null && firstSibling.getIdentityConstant().equals(constId) && firstSibling.m_cond == null) {
            return firstSibling;
        }
        List<Component> matches = this.selectMatchingSiblings(firstSibling);
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return matches.get(0);
        }
        return new CompositeComponent(this, matches);
    }

    public Component getChildByPath(String sPath) {
        int ofStart = 0;
        int ofEnd = sPath.indexOf(46);
        Component parent = this;
        while (ofEnd >= 0) {
            PackageStructure pkg;
            String sName = sPath.substring(ofStart, ofEnd);
            if ((parent = parent.getChild(sName)) == null) {
                return null;
            }
            if (parent instanceof PackageStructure && (pkg = (PackageStructure)parent).isModuleImport()) {
                parent = pkg.getImportedModule();
            }
            ofStart = ofEnd + 1;
            ofEnd = sPath.indexOf(46, ofStart);
        }
        return parent.getChild(sPath.substring(ofStart));
    }

    protected Iterator<IdentityConstant> potentialVirtualChildContributors() {
        throw new IllegalStateException();
    }

    protected Object findVirtualChildSuper(IdentityConstant idVirtChild, int cDepth, Set<IdentityConstant> setVisited) {
        Object oResult;
        if (!setVisited.add(this.getIdentityConstant())) {
            return null;
        }
        if (cDepth == 0) {
            return this;
        }
        IdentityConstant idChild = idVirtChild;
        for (int i = 1; i < cDepth; ++i) {
            idChild = idChild.getParentConstant();
        }
        Component child = this.getChild(idChild.getName());
        if (child != null && (oResult = child.findVirtualChildSuper(idVirtChild, cDepth - 1, setVisited)) != null) {
            return oResult;
        }
        Iterator<IdentityConstant> iter = this.potentialVirtualChildContributors();
        if (iter == null) {
            return false;
        }
        Boolean oResult2 = null;
        while (iter.hasNext()) {
            Object o;
            IdentityConstant idContrib = iter.next();
            if (idContrib.containsUnresolved()) {
                oResult2 = false;
                continue;
            }
            Component component = idContrib.getComponent();
            if (component == null || (o = component.findVirtualChildSuper(idVirtChild, cDepth, setVisited)) == null) continue;
            return o;
        }
        return oResult2;
    }

    public MethodStructure findMethod(SignatureConstant sig) {
        Component child = this.getChild(sig.getName());
        return child instanceof MultiMethodStructure ? child.findMethod(sig) : null;
    }

    public PackageStructure getImportedPackage(ModuleConstant idMainModule) {
        ModuleConstant idModule = this.getIdentityConstant().getModuleConstant();
        return idModule.equals(idMainModule) ? null : idModule.getComponent().getImportedPackage(idMainModule);
    }

    public Component getChild(String sName) {
        Component firstSibling = this.getChildByNameMap().get(sName);
        if (firstSibling == null) {
            return null;
        }
        if (firstSibling.getNextSibling() == null && firstSibling.m_cond == null) {
            return firstSibling;
        }
        List<Component> matches = this.selectMatchingSiblings(firstSibling);
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return matches.get(0);
        }
        return new CompositeComponent(this, matches);
    }

    public int getChildrenCount() {
        return this.m_childByName == null ? 0 : this.m_childByName.size();
    }

    public boolean hasChildren() {
        this.ensureChildren();
        return this.m_childByName != null && !this.m_childByName.isEmpty();
    }

    public Collection<? extends Component> children() {
        Collection<Component> children = this.getChildByNameMap().values();
        assert ((children = Collections.unmodifiableCollection(children)) != null);
        return children;
    }

    public List<Component> safeChildren() {
        ArrayList<Component> list = new ArrayList<Component>();
        for (String sName : this.getChildByNameMap().keySet()) {
            Component child = this.getChild(sName);
            if (child == null) continue;
            list.add(child);
        }
        return list;
    }

    protected List<Component> selectMatchingSiblings(Component firstSibling) {
        AssemblerContext ctxAsm = this.getFileStructure().getContext();
        SimulatedLinkerContext ctxLink = ctxAsm == null ? null : ctxAsm.getLinkerContext();
        ArrayList<Component> matches = null;
        for (Component eachSibling = firstSibling; eachSibling != null; eachSibling = eachSibling.getNextSibling()) {
            if (ctxLink != null && !eachSibling.isPresent(ctxLink)) continue;
            if (matches == null) {
                matches = new ArrayList<Component>();
            }
            matches.add(eachSibling);
        }
        return matches == null ? Collections.emptyList() : matches;
    }

    protected boolean canBeSeen(Constants.Access access) {
        return access.canSee(this.getAccess());
    }

    protected void disassembleChildren(DataInput in, boolean fLazy) throws IOException {
        int cKids = Handy.readMagnitude(in);
        while (cKids-- > 0) {
            int cb;
            ConstantPool pool = this.getConstantPool();
            Component kid = null;
            int n = in.readUnsignedByte();
            if ((n & 0x80) == 0) {
                n = n << 8 | in.readUnsignedByte();
                kid = Format.fromFlags(n).instantiate(this, pool.getConstant(Handy.readMagnitude(in)), n, null);
                kid.disassemble(in);
            } else {
                Component prevSibling = null;
                int cSiblings = Handy.readMagnitude(in);
                assert (cSiblings > 0);
                for (int i = 0; i < cSiblings; ++i) {
                    ConditionalConstant condition = (ConditionalConstant)pool.getConstant(Handy.readIndex(in));
                    int nFlags = in.readUnsignedShort();
                    Component curSibling = Format.fromFlags(nFlags).instantiate(this, pool.getConstant(Handy.readMagnitude(in)), nFlags, condition);
                    curSibling.disassemble(in);
                    if (prevSibling == null) {
                        kid = curSibling;
                    } else {
                        prevSibling.setNextSibling(curSibling);
                    }
                    prevSibling = curSibling;
                }
            }
            boolean fModified = this.isBodyModified();
            this.addChild(kid);
            if (!fModified) {
                this.resetBodyModified();
            }
            if ((cb = Handy.readMagnitude(in)) <= 0) continue;
            if (fLazy) {
                byte[] ab = new byte[cb];
                in.readFully(ab);
                for (Component eachSibling = kid; eachSibling != null; eachSibling = eachSibling.getNextSibling()) {
                    eachSibling.m_abChildren = ab;
                }
                continue;
            }
            kid.disassembleChildren(in, fLazy);
        }
    }

    protected void registerChildrenConstants(ConstantPool pool) {
        for (Component component : this.children()) {
            this.registerChildConstants(pool, component);
        }
    }

    private void registerChildConstants(ConstantPool pool, Component child) {
        for (Component eachSibling = child; eachSibling != null; eachSibling = eachSibling.getNextSibling()) {
            eachSibling.registerConstants(pool);
        }
        child.registerChildrenConstants(pool);
    }

    protected void assembleChildren(DataOutput out) throws IOException {
        int cKids = this.getChildrenCount();
        Handy.writePackedLong(out, cKids);
        if (cKids > 0) {
            int cActual = 0;
            for (Component component : this.children()) {
                this.assembleChild(out, component);
                ++cActual;
            }
            assert (cActual == cKids);
        }
    }

    private void assembleChild(DataOutput out, Component child) throws IOException {
        if (child.getNextSibling() != null || child.m_cond != null) {
            Component eachSibling;
            out.writeByte(128);
            int cSiblings = 0;
            for (eachSibling = child; eachSibling != null; eachSibling = eachSibling.getNextSibling()) {
                ++cSiblings;
            }
            Handy.writePackedLong(out, cSiblings);
            for (eachSibling = child; eachSibling != null; eachSibling = eachSibling.getNextSibling()) {
                Handy.writePackedLong(out, Constant.indexOf(eachSibling.m_cond));
                eachSibling.assemble(out);
            }
        } else {
            child.assemble(out);
        }
        if (child.hasChildren()) {
            ByteArrayOutputStream outNestedRaw = new ByteArrayOutputStream();
            DataOutputStream outNestedData = new DataOutputStream(outNestedRaw);
            child.assembleChildren(outNestedData);
            byte[] abGrandChildren = outNestedRaw.toByteArray();
            Handy.writePackedLong(out, abGrandChildren.length);
            out.write(abGrandChildren);
        } else {
            Handy.writePackedLong(out, 0L);
        }
    }

    public Component replaceWithTemporary() {
        Component eldest = this.getEldestSibling();
        if (this != eldest) {
            Component next;
            Component tail = this.getNextSibling();
            Component cur = eldest;
            while ((next = cur.getNextSibling()) != this) {
                assert (next != null);
                cur = next;
            }
            cur.setNextSibling(tail);
            this.setNextSibling(eldest);
        }
        Component parent = (Component)this.getContaining();
        Component that = this.cloneBody();
        assert (that.getContaining() == parent);
        if (this.hasChildren()) {
            that.cloneChildren(this.children());
        }
        parent.replaceChild(this, that);
        return that;
    }

    public void replaceTemporaryWith(Component that) {
        Component parent = (Component)this.getContaining();
        parent.replaceChild(this, that);
        this.getIdentityConstant().resetCachedInfo();
    }

    protected ComponentResolver.ResolutionResult resolveContributedName(String sName, Constants.Access access, ComponentResolver.ResolutionCollector collector, boolean fAllowInto) {
        assert (access != Constants.Access.STRUCT);
        Component child = this.getChild(sName);
        if (child != null && child.canBeSeen(access)) {
            switch (child.getIdentityConstant().getFormat()) {
                case Class: 
                case Property: 
                case Module: 
                case Package: 
                case Typedef: 
                case MultiMethod: {
                    collector.resolvedComponent(child);
                    return ComponentResolver.ResolutionResult.RESOLVED;
                }
            }
            return ComponentResolver.ResolutionResult.UNKNOWN;
        }
        block9: for (Contribution contrib : this.getContributionsAsList()) {
            TypeConstant typeParent;
            TypeConstant typeFormal;
            TypeConstant typeContrib = contrib.getTypeConstant();
            if (typeContrib.containsUnresolved()) {
                return ComponentResolver.ResolutionResult.POSSIBLE;
            }
            switch (contrib.getComposition().ordinal()) {
                case 4: {
                    if (!fAllowInto) continue block9;
                    access = access.minOf(Constants.Access.PROTECTED);
                    break;
                }
                case 2: 
                case 3: {
                    access = Constants.Access.PUBLIC;
                    break;
                }
                case 1: {
                    access = access.minOf(Constants.Access.PROTECTED);
                    break;
                }
                case 0: 
                case 5: {
                    fAllowInto = false;
                    access = access.minOf(Constants.Access.PROTECTED);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (typeContrib.isVirtualChild() && (typeFormal = (typeParent = typeContrib.getParentType()).resolveGenericType(sName)) != null) {
                if (!typeFormal.isGenericType()) {
                    ClassStructure clzParent = (ClassStructure)typeParent.getSingleUnderlyingClass(true).getComponent();
                    typeFormal = clzParent.getFormalType().resolveGenericType(sName);
                }
                collector.resolvedConstant(typeFormal.getDefiningConstant());
                return ComponentResolver.ResolutionResult.RESOLVED;
            }
            if (typeContrib.isExplicitClassIdentity(true)) {
                ClassStructure clzContrib = (ClassStructure)typeContrib.getSingleUnderlyingClass(true).getComponent();
                if (clzContrib == null) {
                    return ComponentResolver.ResolutionResult.UNKNOWN;
                }
                if (this.m_FVisited != null && this.m_FVisited == fAllowInto) {
                    collector.getErrorListener().log(Severity.FATAL, "VERIFY-11", new Object[]{this.getName(), contrib.getComposition().toString().toLowerCase()}, this);
                    return ComponentResolver.ResolutionResult.ERROR;
                }
                this.m_FVisited = fAllowInto;
                ComponentResolver.ResolutionResult result = clzContrib.resolveContributedName(sName, access, collector, fAllowInto);
                this.m_FVisited = null;
                if (result == ComponentResolver.ResolutionResult.UNKNOWN) continue;
                return result;
            }
            return typeContrib.resolveContributedName(sName, access, null, collector);
        }
        return ComponentResolver.ResolutionResult.UNKNOWN;
    }

    protected Component cloneBody() {
        Component that;
        try {
            that = (Component)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        List<Contribution> listContribs = this.m_listContribs;
        if (listContribs != null) {
            ArrayList<Contribution> listClone = new ArrayList<Contribution>(listContribs.size());
            for (Contribution listContrib : listContribs) {
                listClone.add((Contribution)listContrib.clone());
            }
            that.m_listContribs = listClone;
        }
        that.m_sibling = null;
        that.m_childByName = null;
        that.m_abChildren = null;
        return that;
    }

    protected void cloneChildren(Collection<? extends Component> collThat) {
        for (Component component : collThat) {
            this.addChild(this.cloneChild(component));
        }
    }

    private Component cloneChild(Component childThat) {
        Component childThis = childThat.cloneBody();
        childThis.setContaining(this);
        Component childThisPrev = childThis;
        Component childThatPrev = childThat;
        Component childThatNext = childThatPrev.getNextSibling();
        while (childThatNext != null) {
            Component childThisNext = childThatNext.cloneBody();
            childThisNext.setContaining(this);
            childThisPrev.setNextSibling(childThisNext);
            childThisPrev = childThisNext;
            childThatPrev = childThatNext;
            childThatNext = childThatPrev.getNextSibling();
        }
        if (childThat.hasChildren()) {
            childThis.cloneChildren(childThat.children());
        }
        return childThis;
    }

    protected void synthesizeChildren() {
        for (Component component : this.children()) {
            component.synthesizeChildren();
        }
    }

    public void collectInjections(Set<InjectionKey> setInjections) {
    }

    @Override
    public ComponentResolver.ResolutionResult resolveName(String sName, Constants.Access access, ComponentResolver.ResolutionCollector collector) {
        return this.resolveContributedName(sName, access, collector, true);
    }

    @Override
    public String getDocumentation() {
        return this.m_sDoc;
    }

    @Override
    public void setDocumentation(String sDoc) {
        this.m_sDoc = sDoc;
        this.markModified();
    }

    @Override
    public Iterator<? extends XvmStructure> getContained() {
        return this.children().iterator();
    }

    @Override
    public boolean isModified() {
        for (Component eachSibling = this; eachSibling != null; eachSibling = eachSibling.getNextSibling()) {
            if (!eachSibling.isBodyModified()) continue;
            return true;
        }
        return super.isModified();
    }

    protected boolean isBodyModified() {
        return this.m_fModified;
    }

    protected void resetBodyModified() {
        this.m_fModified = false;
    }

    @Override
    protected void markModified() {
        this.m_fModified = true;
    }

    @Override
    protected void resetModified() {
        for (Component eachSibling = this; eachSibling != null; eachSibling = eachSibling.getNextSibling()) {
            eachSibling.m_fModified = false;
        }
        super.resetModified();
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=").append(this.getName()).append(", format=").append((Object)this.getFormat()).append(", access=").append((Object)this.getAccess());
        if (this.isAbstract()) {
            sb.append(", abstract");
        }
        if (this.isStatic()) {
            sb.append(", static");
        }
        if (this.isSynthetic()) {
            sb.append(", synthetic");
        }
        if (this.getNextSibling() != null) {
            sb.append(", next-sibling");
        }
        if (this.m_fModified) {
            sb.append(", modified");
        }
        return sb.toString();
    }

    @Override
    protected void disassemble(DataInput in) throws IOException {
        assert (this.getContaining() == null || this.getContaining() instanceof Component);
        int c = Handy.readMagnitude(in);
        if (c > 0) {
            ConstantPool pool = this.getConstantPool();
            ArrayList<Contribution> list = new ArrayList<Contribution>();
            for (int i = 0; i < c; ++i) {
                list.add(new Contribution(in, pool));
            }
            this.m_listContribs = list;
        }
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        assert (this.getContaining() == null || this.getContaining() instanceof Component);
        this.m_constId = (IdentityConstant)pool.register(this.m_constId);
        this.m_cond = (ConditionalConstant)pool.register(this.m_cond);
        List<Contribution> listContribs = this.m_listContribs;
        if (listContribs != null && !listContribs.isEmpty()) {
            for (Contribution contribution : listContribs) {
                contribution.registerConstants(pool);
            }
        }
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        assert (this.getContaining() == null || this.getContaining() instanceof Component);
        out.writeShort(this.m_nFlags);
        Handy.writePackedLong(out, this.m_constId.getPosition());
        List<Contribution> listContribs = this.m_listContribs;
        int cContribs = listContribs == null ? 0 : listContribs.size();
        Handy.writePackedLong(out, cContribs);
        if (cContribs > 0) {
            for (Contribution contribution : listContribs) {
                contribution.assemble(out);
            }
        }
    }

    @Override
    public ConditionalConstant getCondition() {
        return this.m_cond;
    }

    @Override
    public void setCondition(ConditionalConstant condition) {
        this.m_cond = condition;
        this.markModified();
    }

    @Override
    protected void dump(PrintWriter out, String sIndent) {
        int cContribs;
        out.print(sIndent);
        out.println(this);
        sIndent = this.nextIndent(sIndent);
        List<Contribution> listContribs = this.m_listContribs;
        int n = cContribs = listContribs == null ? 0 : listContribs.size();
        if (cContribs > 0) {
            for (int i = 0; i < cContribs; ++i) {
                out.println(sIndent + "[" + i + "]=" + String.valueOf(listContribs.get(i)));
            }
        }
    }

    protected void dumpChildren(PrintWriter out, String sIndent) {
        for (Component component : this.children()) {
            this.dumpChild(component, out, sIndent);
        }
    }

    private void dumpChild(Component child, PrintWriter out, String sIndent) {
        for (Component eachSibling = child; eachSibling != null; eachSibling = eachSibling.getNextSibling()) {
            eachSibling.dump(out, sIndent);
        }
        child.dumpChildren(out, this.nextIndent(sIndent));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Component) {
            Component that = (Component)obj;
            if (!this.isBodyIdentical(that) || !this.areChildrenIdentical(that)) {
                return false;
            }
            List<Contribution> listThisContribs = this.m_listContribs;
            List<Contribution> listThatContribs = that.m_listContribs;
            int cThisContribs = listThisContribs == null ? 0 : listThisContribs.size();
            int cThatContribs = listThatContribs == null ? 0 : listThatContribs.size();
            return cThisContribs == cThatContribs && (cThisContribs <= 0 || listThisContribs.equals(listThatContribs));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getIdentityConstant().hashCode();
    }

    public static enum Format {
        INTERFACE,
        CLASS,
        CONST,
        ENUM,
        ENUMVALUE,
        ANNOTATION,
        MIXIN,
        SERVICE,
        PACKAGE,
        MODULE,
        TYPEDEF,
        PROPERTY,
        METHOD,
        RSVD_D,
        MULTIMETHOD,
        FILE;

        private static final Format[] FORMATS;

        static Format fromFlags(int nFlags) {
            return Format.valueOf((nFlags & 0xF) >>> 0);
        }

        public boolean isExtendsLegal(Format fmtSuper) {
            return switch (this.ordinal()) {
                case 1 -> {
                    if (fmtSuper == CLASS) {
                        yield true;
                    }
                    yield false;
                }
                case 2, 3, 8, 9 -> {
                    if (fmtSuper == CONST || fmtSuper == CLASS) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> {
                    if (fmtSuper == ENUM) {
                        yield true;
                    }
                    yield false;
                }
                case 5 -> {
                    if (fmtSuper == ANNOTATION) {
                        yield true;
                    }
                    yield false;
                }
                case 6 -> {
                    if (fmtSuper == MIXIN) {
                        yield true;
                    }
                    yield false;
                }
                case 7 -> {
                    if (fmtSuper == SERVICE || fmtSuper == CLASS) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        Component instantiate(XvmStructure xsParent, Constant constId, int nFlags, ConditionalConstant condition) {
            if (xsParent == null) {
                throw new IllegalStateException("parent required");
            }
            return switch (this.ordinal()) {
                case 9 -> new ModuleStructure(xsParent, nFlags, (ModuleConstant)constId, condition);
                case 8 -> new PackageStructure(xsParent, nFlags, (PackageConstant)constId, condition);
                case 0, 1, 2, 3, 4, 5, 6, 7 -> new ClassStructure(xsParent, nFlags, (ClassConstant)constId, condition);
                case 10 -> new TypedefStructure(xsParent, nFlags, (TypedefConstant)constId, condition);
                case 11 -> new PropertyStructure(xsParent, nFlags, (PropertyConstant)constId, condition);
                case 14 -> new MultiMethodStructure(xsParent, nFlags, (MultiMethodConstant)constId, condition);
                case 12 -> new MethodStructure(xsParent, nFlags, (MethodConstant)constId, condition);
                default -> throw new IllegalStateException("uninstantiable format: " + String.valueOf((Object)this));
            };
        }

        public boolean isImplicitlyStatic() {
            return switch (this.ordinal()) {
                case 3, 4, 8, 9 -> true;
                case 0, 1, 2, 5, 6, 7 -> false;
                case 10, 11, 12, 14 -> false;
                default -> throw new IllegalStateException("unsupported format: " + String.valueOf((Object)this));
            };
        }

        public boolean isAutoNarrowingAllowed() {
            return switch (this.ordinal()) {
                case 3, 4, 8, 9 -> false;
                case 10, 11, 12, 14 -> false;
                case 0, 1, 2, 5, 6, 7 -> true;
                default -> throw new IllegalStateException("unsupported format: " + String.valueOf((Object)this));
            };
        }

        public boolean isDeadEnd() {
            return this.compareTo(PROPERTY) > 0;
        }

        public static Format valueOf(int i) {
            return FORMATS[i];
        }

        static {
            FORMATS = Format.values();
        }
    }

    public class Contribution
    implements Cloneable {
        private final Composition m_composition;
        private TypeConstant m_typeContrib;
        private PropertyConstant m_constProp;
        private Annotation m_annotation;
        private ListMap<StringConstant, TypeConstant> m_mapParams;
        private SingletonConstant m_constInjector;
        private List<Injection> m_listInject;

        protected Contribution(DataInput in, ConstantPool pool) throws IOException {
            this.m_composition = Composition.valueOf(in.readUnsignedByte());
            this.m_typeContrib = (TypeConstant)pool.getConstant(Handy.readIndex(in));
            assert (this.m_typeContrib != null);
            switch (this.m_composition.ordinal()) {
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    break;
                }
                case 0: {
                    this.m_annotation = (Annotation)pool.getConstant(Handy.readIndex(in));
                    break;
                }
                case 3: {
                    this.m_constProp = (PropertyConstant)pool.getConstant(Handy.readIndex(in));
                    break;
                }
                case 5: {
                    int cParams = Handy.readMagnitude(in);
                    if (cParams <= 0) break;
                    ListMap<StringConstant, TypeConstant> map = new ListMap<StringConstant, TypeConstant>();
                    for (int i = 0; i < cParams; ++i) {
                        int iName = Handy.readMagnitude(in);
                        int iType = Handy.readMagnitude(in);
                        map.put((StringConstant)pool.getConstant(iName), iType == 0 ? null : (TypeConstant)pool.getConstant(iType));
                    }
                    this.m_mapParams = map;
                    break;
                }
                case 7: {
                    int c;
                    this.m_constInjector = (SingletonConstant)pool.getConstant(Handy.readIndex(in));
                    if (this.m_constInjector == null || (c = Handy.readIndex(in)) < 0) break;
                    ArrayList<Injection> listInject = new ArrayList<Injection>(c);
                    for (int i = 0; i < c; ++i) {
                        TypeConstant type = (TypeConstant)pool.getConstant(Handy.readIndex(in));
                        StringConstant name = (StringConstant)pool.getConstant(Handy.readIndex(in));
                        listInject.add(new Injection(type, name));
                    }
                    this.m_listInject = listInject;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("composition=" + String.valueOf((Object)this.m_composition));
                }
            }
        }

        public Contribution(Composition composition, TypeConstant constType) {
            assert (composition != null);
            switch (composition.ordinal()) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    if (constType == null) {
                        throw new IllegalArgumentException("type is required");
                    }
                }
                case 8: {
                    break;
                }
                case 3: {
                    throw new IllegalArgumentException("delegates uses the constructor with a PropertyConstant");
                }
                case 7: {
                    throw new IllegalArgumentException("imports uses the constructor with a ModuleConstant");
                }
                default: {
                    throw new UnsupportedOperationException("composition=" + String.valueOf((Object)composition));
                }
            }
            this.m_composition = composition;
            this.m_typeContrib = constType;
        }

        protected Contribution(ModuleConstant constModule) {
            if (constModule == null) {
                throw new IllegalArgumentException("module is required");
            }
            this.m_composition = Composition.Import;
            this.m_typeContrib = constModule.getType();
        }

        public Contribution(TypeConstant constant, PropertyConstant delegate) {
            assert (constant != null && delegate != null);
            this.m_composition = Composition.Delegates;
            this.m_typeContrib = constant;
            this.m_constProp = delegate;
        }

        public Contribution(Annotation annotation) {
            this(annotation, annotation.getAnnotationType());
        }

        public Contribution(Annotation annotation, TypeConstant type) {
            assert (annotation != null);
            assert (type != null);
            this.m_composition = Composition.Annotation;
            this.m_typeContrib = type;
            this.m_annotation = annotation;
        }

        public Contribution(TypeConstant constType, ListMap<StringConstant, TypeConstant> mapConstraints) {
            this(Composition.Incorporates, constType);
            assert (mapConstraints == null || !mapConstraints.isEmpty());
            this.m_mapParams = mapConstraints;
        }

        public Composition getComposition() {
            return this.m_composition;
        }

        public Component getComponent() {
            return Component.this;
        }

        public ModuleConstant getModuleConstant() {
            assert (this.m_composition == Composition.Import);
            return (ModuleConstant)this.getTypeConstant().getDefiningConstant();
        }

        void addInjector(SingletonConstant constInjector, List<Injection> listInject) {
            if (this.m_composition != Composition.Import) {
                throw new IllegalStateException("the contribution must be a package that imports a module");
            }
            if (this.m_constInjector != null) {
                throw new IllegalStateException("injector already added");
            }
            if (constInjector == null) {
                throw new IllegalArgumentException("missing injector");
            }
            this.m_constInjector = constInjector;
            this.m_listInject = listInject;
        }

        public SingletonConstant getInjector() {
            return this.m_constInjector;
        }

        public List<Injection> getInjections() {
            return this.m_listInject;
        }

        public boolean containsUnresolved() {
            SingletonConstant constInjector;
            if (this.getTypeConstant().containsUnresolved()) {
                return true;
            }
            PropertyConstant constProp = this.m_constProp;
            if (constProp != null && constProp.containsUnresolved()) {
                return true;
            }
            Annotation anno = this.m_annotation;
            if (anno != null && anno.getAnnotationClass().containsUnresolved()) {
                return true;
            }
            ListMap<StringConstant, TypeConstant> mapParams = this.m_mapParams;
            if (mapParams != null) {
                for (TypeConstant typeParam : mapParams.values()) {
                    if (typeParam == null || !typeParam.containsUnresolved()) continue;
                    return true;
                }
            }
            if ((constInjector = this.m_constInjector) != null && constInjector.containsUnresolved()) {
                return true;
            }
            List<Injection> listInject = this.m_listInject;
            return listInject != null && listInject.stream().anyMatch(injection -> injection.getType().containsUnresolved());
        }

        public TypeConstant getTypeConstant() {
            return this.m_typeContrib;
        }

        public void narrowType(TypeConstant type) {
            assert (this.m_typeContrib != null && type.isA(this.m_typeContrib));
            this.m_typeContrib = type;
        }

        public PropertyConstant getDelegatePropertyConstant() {
            return this.m_constProp;
        }

        public Annotation getAnnotation() {
            return this.m_annotation;
        }

        public boolean isConditional() {
            return this.m_mapParams != null;
        }

        public Map<StringConstant, TypeConstant> getTypeParams() {
            Map<StringConstant, TypeConstant> map = this.m_mapParams;
            if (map == null) {
                return null;
            }
            assert ((map = Collections.unmodifiableMap(map)) != null);
            return map;
        }

        public TypeConstant resolveGenerics(ConstantPool pool, GenericTypeResolver resolver) {
            IdentityConstant id;
            ClassStructure clz;
            TypeConstant typeContrib = this.getTypeConstant();
            boolean fNormalize = true;
            if (typeContrib.isExplicitClassIdentity(true) && !typeContrib.isParamsSpecified() && (clz = (ClassStructure)(id = typeContrib.getSingleUnderlyingClass(true)).getComponent()).isParameterized()) {
                boolean fSynthetic = false;
                for (StringConstant constName : clz.getTypeParams().keySet()) {
                    if (!clz.getChild(constName.getValue()).isSynthetic()) continue;
                    fSynthetic = true;
                    break;
                }
                if (fSynthetic) {
                    TypeConstant typeContribNew = clz.getFormalType().resolveGenerics(pool, resolver);
                    if (typeContrib.isAccessSpecified()) {
                        typeContribNew = pool.ensureAccessTypeConstant(typeContribNew, typeContrib.getAccess());
                    }
                    if (typeContrib.isImmutabilitySpecified()) {
                        typeContribNew = typeContribNew.freeze();
                    }
                    typeContrib = typeContribNew;
                    fNormalize = false;
                }
            }
            if (fNormalize) {
                typeContrib = typeContrib.normalizeParameters().resolveGenerics(pool, resolver);
            }
            return this.getComposition() != Composition.Incorporates || this.checkConditionalIncorporate(typeContrib) ? typeContrib : null;
        }

        protected TypeConstant resolveType(ConstantPool pool, ClassStructure clzParent, List<TypeConstant> listActual) {
            TypeConstant typeContrib = this.getTypeConstant();
            assert (typeContrib.isSingleDefiningConstant());
            if (!(typeContrib = typeContrib.normalizeParameters()).isParameterizedDeep()) {
                return typeContrib;
            }
            ClassStructure classStructure = clzParent;
            Objects.requireNonNull(classStructure);
            ClassStructure.SimpleTypeResolver resolver = classStructure.new ClassStructure.SimpleTypeResolver(pool, listActual);
            typeContrib = typeContrib.resolveGenerics(pool, resolver);
            return this.getComposition() != Composition.Incorporates || this.checkConditionalIncorporate(typeContrib) ? typeContrib : null;
        }

        protected TypeConstant resolveType(ConstantPool pool, ClassStructure clzParent, TypeConstant typeActual) {
            GenericTypeResolver genericTypeResolver;
            TypeConstant typeContrib = this.getTypeConstant();
            assert (typeContrib.isSingleDefiningConstant());
            if (!(typeContrib = typeContrib.normalizeParameters()).isParameterizedDeep()) {
                return typeContrib;
            }
            if (typeActual.isVirtualChild()) {
                genericTypeResolver = typeActual;
            } else {
                ClassStructure classStructure = clzParent;
                Objects.requireNonNull(classStructure);
                genericTypeResolver = classStructure.new ClassStructure.SimpleTypeResolver(pool, typeActual.getParamTypes());
            }
            GenericTypeResolver resolver = genericTypeResolver;
            typeContrib = typeContrib.resolveGenerics(pool, resolver);
            return this.getComposition() != Composition.Incorporates || this.checkConditionalIncorporate(typeContrib) ? typeContrib : null;
        }

        protected boolean checkConditionalIncorporate(TypeConstant typeContrib) {
            assert (this.getComposition() == Composition.Incorporates);
            TypeConstant[] atypeParams = typeContrib.getParamTypesArray();
            Map<StringConstant, TypeConstant> mapConditional = this.getTypeParams();
            if (mapConditional != null) {
                assert (atypeParams.length == mapConditional.size());
                Iterator<TypeConstant> iterConstraint = mapConditional.values().iterator();
                for (TypeConstant typeParam : atypeParams) {
                    TypeConstant typeConstraint = iterConstraint.next();
                    if (typeConstraint == null || typeParam.isA(typeConstraint)) continue;
                    return false;
                }
            }
            return true;
        }

        protected void registerConstants(ConstantPool pool) {
            ListMap<StringConstant, TypeConstant> mapOld;
            this.m_typeContrib = (TypeConstant)pool.register(this.m_typeContrib);
            this.m_constProp = (PropertyConstant)pool.register(this.m_constProp);
            if (this.m_annotation != null) {
                assert (!this.m_annotation.containsUnresolved());
                this.m_annotation = (Annotation)pool.register(this.m_annotation);
            }
            if ((mapOld = this.m_mapParams) != null) {
                ListMap<StringConstant, TypeConstant> mapNew = new ListMap<StringConstant, TypeConstant>();
                for (Map.Entry<StringConstant, TypeConstant> entry : mapOld.asList()) {
                    StringConstant constName = entry.getKey();
                    TypeConstant type = entry.getValue();
                    mapNew.put((StringConstant)pool.register(constName), (TypeConstant)(type == null ? null : pool.register(type)));
                }
                this.m_mapParams = mapNew;
            }
            if (this.m_constInjector != null) {
                this.m_constInjector = (SingletonConstant)pool.register(this.m_constInjector);
                List<Injection> listInject = this.m_listInject;
                if (listInject != null) {
                    int c = listInject.size();
                    for (int i = 0; i < c; ++i) {
                        Injection oldInject = listInject.get(i);
                        TypeConstant oldType = oldInject.getType();
                        StringConstant oldName = oldInject.getNameConstant();
                        TypeConstant newType = (TypeConstant)pool.register(oldType);
                        StringConstant newName = (StringConstant)pool.register(oldName);
                        if (newType == oldType && newName == oldName) continue;
                        listInject.set(i, new Injection(newType, newName));
                    }
                }
            }
        }

        protected void assemble(DataOutput out) throws IOException {
            out.writeByte(this.m_composition.ordinal());
            Handy.writePackedLong(out, this.m_typeContrib.getPosition());
            switch (this.m_composition.ordinal()) {
                case 0: {
                    Handy.writePackedLong(out, Constant.indexOf(this.m_annotation));
                    break;
                }
                case 3: {
                    Handy.writePackedLong(out, Constant.indexOf(this.m_constProp));
                    break;
                }
                case 5: {
                    ListMap<StringConstant, TypeConstant> map = this.m_mapParams;
                    if (map == null) {
                        Handy.writePackedLong(out, 0L);
                        break;
                    }
                    Handy.writePackedLong(out, map.size());
                    for (Map.Entry<StringConstant, TypeConstant> entry : map.entrySet()) {
                        StringConstant constName = entry.getKey();
                        TypeConstant type = entry.getValue();
                        Handy.writePackedLong(out, constName.getPosition());
                        Handy.writePackedLong(out, type == null ? 0L : (long)type.getPosition());
                    }
                    break;
                }
                case 7: {
                    Handy.writePackedLong(out, Constant.indexOf(this.m_constInjector));
                    if (this.m_constInjector == null) break;
                    List<Injection> listInject = this.m_listInject;
                    int c = listInject == null ? -1 : listInject.size();
                    Handy.writePackedLong(out, c);
                    if (c <= 0) break;
                    for (Injection inject : listInject) {
                        Handy.writePackedLong(out, Constant.indexOf(inject.getType()));
                        Handy.writePackedLong(out, Constant.indexOf(inject.getNameConstant()));
                    }
                    break;
                }
            }
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException(e);
            }
        }

        public int hashCode() {
            return Hash.of((Object)this.m_composition);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Contribution)) {
                return false;
            }
            Contribution that = (Contribution)obj;
            if (this.m_composition == that.m_composition && Handy.equals(this.m_typeContrib, that.m_typeContrib) && Handy.equals(this.m_constProp, that.m_constProp) && Handy.equals(this.m_annotation, that.m_annotation) && Handy.equals(this.m_constInjector, that.m_constInjector) && Handy.equals(this.m_listInject, that.m_listInject)) {
                ListMap<StringConstant, TypeConstant> mapThis = this.m_mapParams;
                ListMap<StringConstant, TypeConstant> mapThat = that.m_mapParams;
                if (mapThis == null && mapThat == null) {
                    return true;
                }
                if (mapThis != null && mapThat != null) {
                    return Handy.equals(mapThis.keySet().toArray(), mapThat.keySet().toArray()) && Handy.equals(mapThis.values().toArray(), mapThat.values().toArray());
                }
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            switch (this.m_composition.ordinal()) {
                case 0: {
                    sb.append('@');
                    break;
                }
                case 8: {
                    sb.append((Object)this.m_composition).append(' ');
                    break;
                }
                default: {
                    sb.append(this.m_composition.toString().toLowerCase()).append(' ');
                }
            }
            if (this.m_composition == Composition.Incorporates && this.m_mapParams != null) {
                TypeConstant constMixin = this.m_typeContrib;
                sb.append("conditional ").append(constMixin.getDefiningConstant()).append('<');
                boolean fFirst = true;
                for (TypeConstant constParam : constMixin.getParamTypesArray()) {
                    PropertyConstant idProp;
                    StringConstant constName;
                    TypeConstant constConstraint;
                    Constant constant;
                    if (fFirst) {
                        fFirst = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(constParam.getValueString());
                    if (!constParam.isSingleDefiningConstant() || !((constant = constParam.getDefiningConstant()) instanceof PropertyConstant) || (constConstraint = this.m_mapParams.get(constName = (idProp = (PropertyConstant)constant).getNameConstant())) == null) continue;
                    sb.append(" extends ").append(constConstraint.getValueString());
                }
                sb.append('>');
            } else {
                if (this.m_typeContrib != null) {
                    sb.append(this.m_typeContrib.resolveTypedefs().getDescription());
                }
                if (this.m_composition == Composition.Annotation && this.m_annotation != null) {
                    Constant[] aconstArgs = this.m_annotation.getParams();
                    if (aconstArgs.length > 0) {
                        sb.append('(');
                        boolean fFirst = true;
                        for (Constant constParam : aconstArgs) {
                            if (fFirst) {
                                fFirst = false;
                            } else {
                                sb.append(", ");
                            }
                            sb.append(constParam.getValueString());
                        }
                        sb.append(')');
                    }
                } else if (this.m_composition == Composition.Delegates) {
                    sb.append('(').append(this.m_constProp.getDescription()).append(')');
                }
            }
            return sb.toString();
        }
    }

    public static enum Composition {
        Annotation,
        Extends,
        Implements,
        Delegates,
        Into,
        Incorporates,
        RebasesOnto,
        Import,
        Equal;

        private static final Composition[] COMPOSITIONS;

        public static Composition valueOf(int i) {
            return COMPOSITIONS[i];
        }

        static {
            COMPOSITIONS = Composition.values();
        }
    }

    public static class SimpleCollector
    implements ComponentResolver.ResolutionCollector {
        private Constant m_constant;
        private final ErrorListener m_errs;

        public SimpleCollector(ErrorListener errs) {
            this.m_errs = errs;
        }

        @Override
        public ComponentResolver.ResolutionResult resolvedComponent(Component component) {
            this.m_constant = component.getIdentityConstant();
            return ComponentResolver.ResolutionResult.RESOLVED;
        }

        @Override
        public ComponentResolver.ResolutionResult resolvedConstant(Constant constant) {
            this.m_constant = constant;
            return ComponentResolver.ResolutionResult.RESOLVED;
        }

        @Override
        public ErrorListener getErrorListener() {
            return this.m_errs;
        }

        public Constant getResolvedConstant() {
            return this.m_constant;
        }
    }

    public static class Injection {
        private final TypeConstant type;
        private final StringConstant name;

        public Injection(TypeConstant type, StringConstant name) {
            if (type == null) {
                throw new IllegalArgumentException("injection type is required");
            }
            this.type = type;
            this.name = name;
        }

        public TypeConstant getType() {
            return this.type;
        }

        public String getName() {
            StringConstant name = this.name;
            return name == null ? null : name.getValue();
        }

        public StringConstant getNameConstant() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o instanceof Injection) {
                Injection that = (Injection)o;
                return this == that || Handy.equals(this.type, that.type) && Handy.equals(this.name, that.name);
            }
            return false;
        }

        public int hashCode() {
            return Hash.of(this.type, Hash.of(this.name));
        }

        public String toString() {
            return String.valueOf(this.type) + " " + String.valueOf(this.name == null ? "_" : this.name);
        }
    }
}

