/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.util.ArrayList;
import java.util.List;
import org.xvm.asm.Component;
import org.xvm.asm.CompositeComponent;
import org.xvm.asm.constants.ConditionalConstant;

public class ComponentBifurcator {
    private final Component unsplit;
    private ConditionalConstant splitter;
    private ComponentBifurcator iftrue;
    private ComponentBifurcator iffalse;

    public ComponentBifurcator(Component component) {
        assert (!(component instanceof CompositeComponent));
        this.unsplit = component;
    }

    public Component getComponent(ConditionalConstant cond) {
        if (this.splitter == null) {
            return cond == null ? this.unsplit : this.split(cond);
        }
        ArrayList<Component> list = new ArrayList<Component>();
        this.collectMatchingComponents(cond, list);
        if (list.isEmpty()) {
            throw new IllegalStateException();
        }
        if (list.size() == 1) {
            return (Component)list.get(0);
        }
        return new CompositeComponent(this.unsplit.getParent(), list);
    }

    public void collectMatchingComponents(ConditionalConstant cond, List<Component> list) {
        if (this.splitter == null) {
            list.add(cond == null ? this.unsplit : this.split(cond));
        } else if (cond == null) {
            this.iftrue.collectMatchingComponents(null, list);
            this.iffalse.collectMatchingComponents(null, list);
        } else {
            ConditionalConstant.Bifurcation plan = this.splitter.bifurcate(cond);
            if (plan.isTruePossible()) {
                this.iftrue.collectMatchingComponents(plan.getTrueCondition(), list);
            }
            if (plan.isFalsePossible()) {
                this.iffalse.collectMatchingComponents(plan.getFalseCondition(), list);
            }
        }
    }

    private Component split(ConditionalConstant cond) {
        Component componentTrue = this.unsplit;
        Component componentFalse = this.unsplit.cloneBody();
        componentTrue.addAndCondition(cond);
        componentFalse.addAndCondition(cond.negate());
        this.splitter = cond;
        this.iftrue = new ComponentBifurcator(componentTrue);
        this.iffalse = new ComponentBifurcator(componentFalse);
        return componentTrue;
    }
}

