/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.util.IdentityArrayList;

public class CompositeComponent
extends Component {
    private final List<Component> f_siblings;

    protected CompositeComponent(Component parent, List<Component> siblings) {
        super(parent);
        this.f_siblings = siblings;
    }

    public List<Component> components() {
        List<Component> list = this.f_siblings;
        assert ((list = Collections.unmodifiableList(list)) != null);
        return list;
    }

    @Override
    public IdentityConstant getIdentityConstant() {
        IdentityConstant constId = null;
        for (Component sibling : this.f_siblings) {
            if (constId == null) {
                constId = sibling.getIdentityConstant();
                continue;
            }
            if (constId.equals(sibling.getIdentityConstant())) continue;
            throw new UnsupportedOperationException("can't ask identity constant of a composite with diff identity constants: " + String.valueOf(constId) + ", " + String.valueOf(sibling.getIdentityConstant()));
        }
        return constId;
    }

    public boolean isAmbiguous() {
        IdentityConstant constId = null;
        for (Component sibling : this.f_siblings) {
            if (constId == null) {
                constId = sibling.getIdentityConstant();
                continue;
            }
            if (constId.equals(sibling.getIdentityConstant())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Component.Format getFormat() {
        Component.Format format = null;
        for (Component sibling : this.f_siblings) {
            if (format == null) {
                format = sibling.getFormat();
                continue;
            }
            if (format == sibling.getFormat()) continue;
            throw new UnsupportedOperationException("can't ask format of a composite with diff formats: " + String.valueOf((Object)format) + ", " + String.valueOf((Object)sibling.getFormat()));
        }
        return format;
    }

    @Override
    public Constants.Access getAccess() {
        Constants.Access access = null;
        for (Component sibling : this.f_siblings) {
            if (access == null) {
                access = sibling.getAccess();
                continue;
            }
            if (access == sibling.getAccess()) continue;
            throw new UnsupportedOperationException("can't ask access of a composite with diff access: " + String.valueOf((Object)access) + ", " + String.valueOf((Object)sibling.getAccess()));
        }
        return access;
    }

    @Override
    public void setAccess(Constants.Access access) {
        for (Component sibling : this.f_siblings) {
            sibling.setAccess(access);
        }
    }

    @Override
    public boolean isAbstract() {
        boolean fAbstract = false;
        boolean fFirst = true;
        for (Component sibling : this.f_siblings) {
            if (fFirst) {
                fAbstract = sibling.isAbstract();
                fFirst = false;
                continue;
            }
            if (fAbstract == sibling.isAbstract()) continue;
            throw new UnsupportedOperationException("can't ask abstract of a composite with diff abstract settings");
        }
        return fAbstract;
    }

    @Override
    public void setAbstract(boolean fAbstract) {
        for (Component sibling : this.f_siblings) {
            sibling.setAbstract(fAbstract);
        }
    }

    @Override
    public boolean isStatic() {
        boolean fStatic = false;
        boolean fFirst = true;
        for (Component sibling : this.f_siblings) {
            if (fFirst) {
                fStatic = sibling.isStatic();
                fFirst = false;
                continue;
            }
            if (fStatic == sibling.isStatic()) continue;
            throw new UnsupportedOperationException("can't ask static of a composite with diff static settings");
        }
        return fStatic;
    }

    @Override
    public void setStatic(boolean fStatic) {
        for (Component sibling : this.f_siblings) {
            sibling.setStatic(fStatic);
        }
    }

    @Override
    public boolean isSynthetic() {
        boolean fSynthetic = false;
        boolean fFirst = true;
        for (Component sibling : this.f_siblings) {
            if (fFirst) {
                fSynthetic = sibling.isSynthetic();
                fFirst = false;
                continue;
            }
            if (fSynthetic == sibling.isSynthetic()) continue;
            throw new UnsupportedOperationException("can't ask synthetic of a composite with diff synthetic settings");
        }
        return fSynthetic;
    }

    @Override
    public void setSynthetic(boolean fSynthetic) {
        for (Component sibling : this.f_siblings) {
            sibling.setSynthetic(fSynthetic);
        }
    }

    @Override
    public String getName() {
        String sName = null;
        for (Component sibling : this.f_siblings) {
            if (sName == null) {
                sName = sibling.getName();
                continue;
            }
            if (sName.equals(sibling.getName())) continue;
            throw new UnsupportedOperationException("can't ask name of a composite with diff names: " + sName + ", " + sibling.getName());
        }
        return sName;
    }

    @Override
    public boolean isGloballyVisible() {
        boolean fVisible = true;
        for (Component sibling : this.f_siblings) {
            if (sibling.isGloballyVisible()) continue;
            fVisible = false;
            break;
        }
        return fVisible;
    }

    @Override
    protected boolean isChildLessVisible() {
        boolean fAsVisible = true;
        for (Component sibling : this.f_siblings) {
            if (sibling.isChildLessVisible()) continue;
            fAsVisible = false;
            break;
        }
        return !fAsVisible;
    }

    @Override
    protected Component getEldestSibling() {
        return this.f_siblings.get(0).getEldestSibling();
    }

    @Override
    public boolean isPackageContainer() {
        for (Component sibling : this.f_siblings) {
            if (sibling.isPackageContainer()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isClassContainer() {
        for (Component sibling : this.f_siblings) {
            if (sibling.isClassContainer()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMethodContainer() {
        for (Component sibling : this.f_siblings) {
            if (sibling.isMethodContainer()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Component> getChildByNameMap() {
        return this.f_siblings.get(0).getChildByNameMap();
    }

    @Override
    public Map<String, Component> ensureChildByNameMap() {
        return this.f_siblings.get(0).ensureChildByNameMap();
    }

    @Override
    protected boolean addChild(Component child) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void addAndCondition(ConditionalConstant cond) {
        for (Component sibling : this.f_siblings) {
            sibling.addAndCondition(cond);
        }
    }

    @Override
    protected void addOrCondition(ConditionalConstant cond) {
        for (Component sibling : this.f_siblings) {
            sibling.addOrCondition(cond);
        }
    }

    @Override
    protected boolean isBodyIdentical(Component component) {
        if (component instanceof CompositeComponent) {
            CompositeComponent that = (CompositeComponent)component;
            List<Component> listThis = this.f_siblings;
            List<Component> listThat = that.f_siblings;
            if (listThis.size() == listThat.size()) {
                int c = listThis.size();
                for (int i = 0; i < c; ++i) {
                    if (listThis.get(i).isBodyIdentical(listThat.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Component getChild(Constant constId) {
        IdentityArrayList<Component> listChild = new IdentityArrayList<Component>();
        for (Component sibling : this.f_siblings) {
            Component child = sibling.getChild(constId);
            if (child == null) continue;
            if (child instanceof CompositeComponent) {
                CompositeComponent composite = (CompositeComponent)child;
                for (Component eachChild : composite.f_siblings) {
                    listChild.addIfAbsent(eachChild);
                }
                continue;
            }
            listChild.addIfAbsent(child);
        }
        if (listChild.isEmpty()) {
            return null;
        }
        if (listChild.size() == 1) {
            return (Component)listChild.get(0);
        }
        return new CompositeComponent(this, listChild);
    }

    @Override
    public Component getChild(String sName) {
        IdentityArrayList<Component> listChild = new IdentityArrayList<Component>();
        for (Component sibling : this.f_siblings) {
            Component child = sibling.getChild(sName);
            if (child == null) continue;
            if (child instanceof CompositeComponent) {
                CompositeComponent composite = (CompositeComponent)child;
                for (Component eachChild : composite.f_siblings) {
                    listChild.addIfAbsent(eachChild);
                }
                continue;
            }
            listChild.addIfAbsent(child);
        }
        if (listChild.isEmpty()) {
            return null;
        }
        if (listChild.size() == 1) {
            return (Component)listChild.get(0);
        }
        return new CompositeComponent(this, listChild);
    }

    @Override
    protected void disassembleChildren(DataInput in, boolean fLazy) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void registerChildrenConstants(ConstantPool pool) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void assembleChildren(DataOutput out) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Component cloneBody() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<? extends XvmStructure> getContained() {
        return this.f_siblings.get(0).getContained();
    }

    @Override
    public boolean isModified() {
        for (Component sibling : this.f_siblings) {
            if (!sibling.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isBodyModified() {
        for (Component sibling : this.f_siblings) {
            if (!sibling.isBodyModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void markModified() {
        for (Component sibling : this.f_siblings) {
            sibling.markModified();
        }
    }

    @Override
    protected void resetModified() {
        for (Component sibling : this.f_siblings) {
            sibling.resetModified();
        }
    }

    @Override
    protected void disassemble(DataInput in) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void assemble(DataOutput out) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void dump(PrintWriter out, String sIndent) {
        out.print(sIndent);
        out.println(this);
        for (Component sibling : this.f_siblings) {
            sibling.dump(out, this.nextIndent(sIndent));
        }
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (Component sibling : this.f_siblings) {
            n ^= sibling.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CompositeComponent) {
            CompositeComponent that = (CompositeComponent)obj;
            return this.f_siblings.equals(that.f_siblings);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompositeComponent{");
        List<Component> list = this.f_siblings;
        int c = list.size();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('[').append(i).append("]=").append(list.get(i));
        }
        sb.append('}');
        return sb.toString();
    }
}

