/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.xvm.asm.Argument;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.LinkerContext;
import org.xvm.asm.Op;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.DeferredValueConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.Token;
import org.xvm.type.Decimal128;
import org.xvm.type.Decimal32;
import org.xvm.type.Decimal64;
import org.xvm.util.Hash;
import org.xvm.util.PackedInteger;

public abstract class Constant
extends XvmStructure
implements Comparable<Constant>,
Cloneable,
Argument {
    public static final Comparator<Constant> MFU_ORDER = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        assert (o1.getConstantPool() == o2.getConstantPool());
        int cDif = o1.m_cRefs - o2.m_cRefs;
        return -cDif;
    };
    public static final Constant[] NO_CONSTS = new Constant[0];
    private int m_iHash;
    private transient int m_iPos = -1;
    private transient int m_cRefs;
    private transient Object m_oValue;

    protected Constant(ConstantPool pool) {
        super(pool);
    }

    protected void resolveConstants() {
    }

    public abstract Format getFormat();

    public boolean isClass() {
        return false;
    }

    public boolean isAutoNarrowing() {
        return false;
    }

    public Constant resolve() {
        return this;
    }

    public boolean isProperty() {
        return false;
    }

    public boolean isValueCacheable() {
        return true;
    }

    public boolean containsUnresolved() {
        return false;
    }

    public boolean canResolve() {
        return !this.containsUnresolved();
    }

    public Constant resolveTypedefs() {
        return this;
    }

    public static Constant defaultValue(TypeConstant type) {
        ConstantPool pool = type.getConstantPool();
        switch (type.getEcstasyClassName()) {
            default: {
                return pool.valFalse();
            }
            case "Nullable": {
                return pool.valNull();
            }
            case "Ordered": {
                return pool.valOrd(0);
            }
            case "Boolean.True": {
                return pool.valTrue();
            }
            case "text.Char": {
                return pool.ensureCharConstant(63);
            }
            case "text.String": {
                return pool.ensureStringConstant("");
            }
            case "numbers.IntLiteral": {
                return pool.ensureLiteralConstant(Format.IntLiteral, "0");
            }
            case "numbers.FPLiteral": {
                return pool.ensureLiteralConstant(Format.FPLiteral, "0.0");
            }
            case "numbers.Bit": {
                return pool.ensureBitConstant(0);
            }
            case "numbers.Nibble": {
                return pool.ensureNibbleConstant(0);
            }
            case "numbers.Int8": {
                return pool.ensureByteConstant(Format.Int8, 0);
            }
            case "numbers.UInt8": {
                return pool.ensureByteConstant(Format.UInt8, 0);
            }
            case "numbers.Int16": 
            case "numbers.Int32": 
            case "numbers.Int64": 
            case "numbers.Int128": 
            case "numbers.IntN": 
            case "numbers.UInt16": 
            case "numbers.UInt32": 
            case "numbers.UInt64": 
            case "numbers.UInt128": 
            case "numbers.UIntN": {
                return pool.ensureIntConstant(PackedInteger.ZERO, Format.valueOf(type.getEcstasyClassName().substring(8)));
            }
            case "numbers.Dec": {
                return pool.ensureDecAConstant(Decimal64.POS_ZERO);
            }
            case "numbers.Dec32": {
                return pool.ensureDecConstant(Decimal32.POS_ZERO);
            }
            case "numbers.Dec64": {
                return pool.ensureDecConstant(Decimal64.POS_ZERO);
            }
            case "numbers.Dec128": {
                return pool.ensureDecConstant(Decimal128.POS_ZERO);
            }
            case "numbers.DecN": {
                throw new UnsupportedOperationException();
            }
            case "numbers.Float8e4": {
                return pool.ensureFloat8e4Constant(0.0f);
            }
            case "numbers.Float8e5": {
                return pool.ensureFloat8e5Constant(0.0f);
            }
            case "numbers.BFloat16": {
                return pool.ensureBFloat16Constant(0.0f);
            }
            case "numbers.Float16": {
                return pool.ensureFloat16Constant(0.0f);
            }
            case "numbers.Float32": {
                return pool.ensureFloat32Constant(0.0f);
            }
            case "numbers.Float64": {
                return pool.ensureFloat64Constant(0.0);
            }
            case "numbers.Float128": {
                return pool.ensureFloat128Constant(new byte[16]);
            }
            case "numbers.FloatN": 
        }
        throw new UnsupportedOperationException();
    }

    public PackedInteger getIntValue() {
        throw new IllegalStateException(this.getClass().getSimpleName());
    }

    public Constant apply(Token.Id op, Constant that) {
        if (that instanceof DeferredValueConstant) {
            return that;
        }
        throw new UnsupportedOperationException("this=" + this.getClass().getSimpleName() + ", op=" + op.TEXT + (String)(that == null ? "" : ", that=" + that.getClass().getSimpleName()));
    }

    public Constant convertTo(TypeConstant typeOut) {
        return this.getType().isA(typeOut) ? this : null;
    }

    protected Constant adoptedBy(ConstantPool pool) {
        Constant that;
        try {
            that = (Constant)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        that.setContaining(pool);
        that.resetRefs();
        return that;
    }

    public void forEachUnderlying(Consumer<Constant> visitor) {
    }

    public void checkValidPools(Set<ConstantPool> setValidPools, int[] anDepth) {
        if (!setValidPools.contains(this.getConstantPool())) {
            if (setValidPools.isEmpty()) {
                return;
            }
            throw new IllegalStateException("attempt to register a constant that refers to an unknown upstream constant pool: " + String.valueOf(this.getConstantPool()));
        }
        int n = anDepth[0];
        anDepth[0] = n + 1;
        if (n > 100) {
            throw new IllegalStateException("Suspected infinite loop in checkValidPools()");
        }
        this.forEachUnderlying(constant -> constant.checkValidPools(setValidPools, anDepth));
        anDepth[0] = anDepth[0] - 1;
    }

    public int getPosition() {
        return this.m_iPos;
    }

    protected void setPosition(int iPos) {
        assert (iPos >= -1);
        this.m_iPos = iPos;
    }

    protected Object getLocator() {
        return null;
    }

    protected abstract int compareDetails(Constant var1);

    void resetRefs() {
        this.m_cRefs = 0;
    }

    boolean addRef() {
        return this.m_cRefs++ == 0;
    }

    boolean hasRefs() {
        return this.m_cRefs > 0;
    }

    @Override
    public ConstantPool getConstantPool() {
        return (ConstantPool)this.getContaining();
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    protected void markModified() {
        throw new IllegalStateException();
    }

    @Override
    protected void resetModified() {
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public void purgeCondition(ConditionalConstant condition) {
    }

    @Override
    public boolean isPresent(LinkerContext ctx) {
        return true;
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    protected void disassemble(DataInput in) {
        throw new IllegalStateException();
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeByte(this.getFormat().ordinal());
    }

    @Override
    public TypeConstant getType() {
        throw new UnsupportedOperationException("constant-class=" + this.getClass().getSimpleName());
    }

    @Override
    public boolean isStack() {
        return false;
    }

    @Override
    public boolean isEffectivelyFinal() {
        return false;
    }

    @Override
    public Constant registerConstants(Op.ConstantRegistry registry) {
        return registry.register(this);
    }

    public abstract String getValueString();

    @Override
    protected void dump(PrintWriter out, String sIndent) {
        out.print(sIndent);
        out.println(this);
    }

    @Override
    public int hashCode() {
        int iHash = this.m_iHash;
        return iHash == 0 ? this.computeHashCodeInternal() : iHash;
    }

    protected abstract int computeHashCode();

    protected int computeHashCodeInternal() {
        if (this.containsUnresolved()) {
            return 0;
        }
        int iHash = Hash.of(this.getClass().getName(), this.computeHashCode());
        this.m_iHash = iHash == 0 ? 7654211 : iHash;
        return this.m_iHash;
    }

    protected boolean isHashCached() {
        return this.m_iHash != 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Constant)) {
            return false;
        }
        Constant that = (Constant)obj;
        Constant constThis = this.resolve();
        Constant constThat = that.resolve();
        return constThis == constThat || constThis.getFormat() == constThat.getFormat() && constThis.compareDetails(constThat) == 0;
    }

    @Override
    public String toString() {
        return this.getFormat().name() + "{" + this.getDescription() + "}";
    }

    @Override
    public int compareTo(Constant that) {
        Constant constThat;
        if (this == that) {
            return 0;
        }
        Constant constThis = this.resolve();
        if (constThis == (constThat = that.resolve())) {
            return 0;
        }
        int cDif = constThis.getFormat().compareTo(constThat.getFormat());
        if (cDif != 0) {
            return cDif;
        }
        return constThis.compareDetails(constThat);
    }

    protected static int indexOf(Constant constant) {
        return constant == null ? -1 : constant.getPosition();
    }

    protected Constant translateOrder(int nOrder, Token.Id op) {
        ConstantPool pool = this.getConstantPool();
        return switch (op) {
            case Token.Id.COMP_EQ -> pool.valOf(nOrder == 0);
            case Token.Id.COMP_NEQ -> pool.valOf(nOrder != 0);
            case Token.Id.COMP_LT -> pool.valOf(nOrder < 0);
            case Token.Id.COMP_LTEQ -> pool.valOf(nOrder <= 0);
            case Token.Id.COMP_GT -> pool.valOf(nOrder > 0);
            case Token.Id.COMP_GTEQ -> pool.valOf(nOrder >= 0);
            case Token.Id.COMP_ORD -> pool.valOrd(nOrder);
            default -> throw new IllegalStateException();
        };
    }

    protected void addDeferredTypeInfo(TypeConstant type) {
        this.getConstantPool().addDeferredTypeInfo(type);
    }

    protected boolean hasDeferredTypeInfo() {
        return this.getConstantPool().hasDeferredTypeInfo();
    }

    protected List<TypeConstant> takeDeferredTypeInfo() {
        return this.getConstantPool().takeDeferredTypeInfo();
    }

    protected static Constant[] registerConstants(ConstantPool pool, Constant[] aconst) {
        Constant[] aconstNew = null;
        int c = aconst.length;
        for (int i = 0; i < c; ++i) {
            Constant constOld = aconst[i];
            Constant constNew = pool.register(constOld);
            if (constOld == constNew) continue;
            if (aconstNew == null) {
                aconstNew = (Constant[])aconst.clone();
            }
            aconstNew[i] = constNew;
        }
        return aconstNew == null ? aconst : aconstNew;
    }

    public static enum Format {
        IntLiteral("numbers"),
        Bit("numbers"),
        Nibble("numbers"),
        Int8("numbers"),
        Int16("numbers"),
        Int32("numbers"),
        Int64("numbers"),
        Int128("numbers"),
        IntN("numbers"),
        UInt8("numbers"),
        UInt16("numbers"),
        UInt32("numbers"),
        UInt64("numbers"),
        UInt128("numbers"),
        UIntN("numbers"),
        FPLiteral("numbers"),
        Dec32("numbers"),
        Dec64("numbers"),
        Dec128("numbers"),
        DecN("numbers"),
        Float8e4("numbers"),
        Float8e5("numbers"),
        BFloat16("numbers"),
        Float16("numbers"),
        Float32("numbers"),
        Float64("numbers"),
        Float128("numbers"),
        FloatN("numbers"),
        Char("text"),
        String("text"),
        RegEx("text"),
        Date,
        TimeOfDay,
        TimeZone,
        Time,
        Duration,
        Version("reflect"),
        SingletonConst,
        EnumValueConst,
        SingletonService,
        Tuple("collections"),
        Array("collections"),
        UInt8Array,
        Set("collections"),
        MapEntry("maps"),
        Map("maps"),
        Range,
        RangeInclusive,
        RangeExclusive,
        Any,
        Path("fs"),
        FileStore("fs"),
        FSDir("fs"),
        FSFile("fs"),
        FSLink("fs"),
        ResponseSender("http"),
        Module,
        Package,
        Class,
        Typedef,
        Property,
        MultiMethod,
        Method,
        Annotation,
        Register,
        BindTarget,
        UnresolvedName,
        DeferredValue,
        ThisClass,
        ParentClass,
        ChildClass,
        TypeParameter,
        FormalTypeChild,
        DynamicFormal,
        Signature,
        DecoratedClass,
        NativeClass,
        IsConst,
        IsEnum,
        IsModule,
        IsPackage,
        IsClass,
        UnresolvedType,
        TerminalType,
        ImmutableType,
        ServiceType,
        AccessType,
        AnnotatedType,
        ParameterizedType,
        TurtleType,
        VirtualChildType,
        InnerChildType,
        AnonymousClassType,
        PropertyClassType,
        IntersectionType,
        CastType,
        UnionType,
        DifferenceType,
        RecursiveType,
        ConditionNot,
        ConditionAll,
        ConditionAny,
        ConditionNamed,
        ConditionPresent,
        ConditionVersionMatches,
        ConditionVersioned;

        private static final Format[] FORMATS;
        private final String f_sPackage;

        private Format() {
            this(null);
        }

        private Format(String sPackage) {
            this.f_sPackage = sPackage;
        }

        public Format next() {
            return Format.valueOf(this.ordinal() + 1);
        }

        public boolean isTypeable() {
            return switch (this.ordinal()) {
                case 56, 57, 58, 59, 60, 71, 72 -> true;
                case 68, 69, 70, 73, 75, 76 -> true;
                case 66, 77, 78, 79, 80, 81 -> true;
                default -> false;
            };
        }

        public String getEcstasyName() {
            return this.f_sPackage == null ? this.name() : this.f_sPackage + "." + this.name();
        }

        public TypeConstant getType(ConstantPool pool) {
            return switch (this.ordinal()) {
                case 3 -> pool.typeInt8();
                case 4 -> pool.typeInt16();
                case 5 -> pool.typeInt32();
                case 6 -> pool.typeInt64();
                case 7 -> pool.typeInt128();
                case 8 -> pool.typeIntN();
                case 9 -> pool.typeUInt8();
                case 10 -> pool.typeUInt16();
                case 11 -> pool.typeUInt32();
                case 12 -> pool.typeUInt64();
                case 13 -> pool.typeUInt128();
                case 14 -> pool.typeUIntN();
                case 17 -> pool.typeDec64();
                default -> pool.ensureEcstasyTypeConstant(this.getEcstasyName());
            };
        }

        public static Format valueOf(int i) {
            return FORMATS[i];
        }

        static {
            FORMATS = Format.values();
        }
    }
}

