/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.xvm.asm.Annotation;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorList;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.FileStructure;
import org.xvm.asm.GenericTypeResolver;
import org.xvm.asm.LinkerContext;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.Register;
import org.xvm.asm.Version;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.constants.AccessTypeConstant;
import org.xvm.asm.constants.AllCondition;
import org.xvm.asm.constants.AnnotatedTypeConstant;
import org.xvm.asm.constants.AnonymousClassTypeConstant;
import org.xvm.asm.constants.AnyCondition;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.BFloat16Constant;
import org.xvm.asm.constants.ByteConstant;
import org.xvm.asm.constants.CharConstant;
import org.xvm.asm.constants.ChildClassConstant;
import org.xvm.asm.constants.ClassConstant;
import org.xvm.asm.constants.ConditionalConstant;
import org.xvm.asm.constants.DecimalAutoConstant;
import org.xvm.asm.constants.DecimalConstant;
import org.xvm.asm.constants.DecoratedClassConstant;
import org.xvm.asm.constants.DifferenceTypeConstant;
import org.xvm.asm.constants.DynamicFormalConstant;
import org.xvm.asm.constants.EnumValueConstant;
import org.xvm.asm.constants.FPNConstant;
import org.xvm.asm.constants.FSNodeConstant;
import org.xvm.asm.constants.FileStoreConstant;
import org.xvm.asm.constants.Float128Constant;
import org.xvm.asm.constants.Float16Constant;
import org.xvm.asm.constants.Float32Constant;
import org.xvm.asm.constants.Float64Constant;
import org.xvm.asm.constants.Float8e4Constant;
import org.xvm.asm.constants.Float8e5Constant;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.FormalTypeChildConstant;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.ImmutableTypeConstant;
import org.xvm.asm.constants.InnerChildTypeConstant;
import org.xvm.asm.constants.IntConstant;
import org.xvm.asm.constants.IntersectionTypeConstant;
import org.xvm.asm.constants.KeywordConstant;
import org.xvm.asm.constants.LiteralConstant;
import org.xvm.asm.constants.MapConstant;
import org.xvm.asm.constants.MatchAnyConstant;
import org.xvm.asm.constants.MethodBindingConstant;
import org.xvm.asm.constants.MethodBody;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.MethodInfo;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.MultiMethodConstant;
import org.xvm.asm.constants.NamedCondition;
import org.xvm.asm.constants.NativeRebaseConstant;
import org.xvm.asm.constants.NotCondition;
import org.xvm.asm.constants.PackageConstant;
import org.xvm.asm.constants.ParamInfo;
import org.xvm.asm.constants.ParameterizedTypeConstant;
import org.xvm.asm.constants.ParentClassConstant;
import org.xvm.asm.constants.PresentCondition;
import org.xvm.asm.constants.PropertyClassTypeConstant;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.PseudoConstant;
import org.xvm.asm.constants.RangeConstant;
import org.xvm.asm.constants.RecursiveTypeConstant;
import org.xvm.asm.constants.RegExConstant;
import org.xvm.asm.constants.RegisterConstant;
import org.xvm.asm.constants.RelationalTypeConstant;
import org.xvm.asm.constants.ServiceTypeConstant;
import org.xvm.asm.constants.SignatureConstant;
import org.xvm.asm.constants.SingletonConstant;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TerminalTypeConstant;
import org.xvm.asm.constants.ThisClassConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.constants.TypeInfo;
import org.xvm.asm.constants.TypeParameterConstant;
import org.xvm.asm.constants.TypeSequenceTypeConstant;
import org.xvm.asm.constants.TypedefConstant;
import org.xvm.asm.constants.UInt8ArrayConstant;
import org.xvm.asm.constants.UnionTypeConstant;
import org.xvm.asm.constants.VersionConstant;
import org.xvm.asm.constants.VersionMatchesCondition;
import org.xvm.asm.constants.VersionedCondition;
import org.xvm.asm.constants.VirtualChildTypeConstant;
import org.xvm.compiler.Lexer;
import org.xvm.compiler.Parser;
import org.xvm.compiler.Source;
import org.xvm.type.Decimal;
import org.xvm.util.Auto;
import org.xvm.util.Handy;
import org.xvm.util.ListMap;
import org.xvm.util.PackedInteger;
import org.xvm.util.TransientThreadLocal;

public class ConstantPool
extends XvmStructure {
    private static final Map<String, String[]> s_implicits;
    private static final Map<String, String> s_implicitsByPath;
    public static final TypeConstant[] NO_TYPES;
    private final ArrayList<Constant> m_listConst = new ArrayList();
    private volatile EnumMap<Constant.Format, Map<Constant, Constant>> m_mapConstants = new EnumMap(Constant.Format.class);
    private volatile EnumMap<Constant.Format, Map<Object, Constant>> m_mapLocators = new EnumMap(Constant.Format.class);
    private final Set<ConstantPool> m_setValidPools = Collections.newSetFromMap(new IdentityHashMap());
    private transient boolean m_fRecurseReg;
    private final Map<String, IdentityConstant> f_implicits = new HashMap<String, IdentityConstant>();
    private final TransientThreadLocal<List<TypeConstant>> f_tlolistDeferred = new TransientThreadLocal();
    private final List<IdentityConstant> f_listInvalidated = new Vector<IdentityConstant>();
    private volatile int m_cInvalidated;
    private final Map<TypeConstant, TypeInfo> f_mapRefTypes = new ConcurrentHashMap<TypeConstant, TypeInfo>();
    private static final ThreadLocal<ConstantPool[]> s_tloPool;
    private transient TypeConstant m_typeNakedRef;
    private transient ModuleConstant m_valEcstasy;
    private transient ClassConstant m_clzObject;
    private transient ClassConstant m_clzInner;
    private transient ClassConstant m_clzOuter;
    private transient ClassConstant m_clzRef;
    private transient ClassConstant m_clzVar;
    private transient ClassConstant m_clzClass;
    private transient ClassConstant m_clzStruct;
    private transient ClassConstant m_clzType;
    private transient ClassConstant m_clzConst;
    private transient ClassConstant m_clzService;
    private transient ClassConstant m_clzModule;
    private transient ClassConstant m_clzPackage;
    private transient ClassConstant m_clzEnum;
    private transient ClassConstant m_clzEnumeration;
    private transient ClassConstant m_clzEnumValue;
    private transient ClassConstant m_clzException;
    private transient ClassConstant m_clzCloseable;
    private transient ClassConstant m_clzProperty;
    private transient ClassConstant m_clzMethod;
    private transient ClassConstant m_clzFunction;
    private transient ClassConstant m_clzNullable;
    private transient ClassConstant m_clzCollection;
    private transient ClassConstant m_clzSet;
    private transient ClassConstant m_clzList;
    private transient ClassConstant m_clzArray;
    private transient ClassConstant m_clzMatrix;
    private transient ClassConstant m_clzMap;
    private transient ClassConstant m_clzSliceable;
    private transient ClassConstant m_clzOrderable;
    private transient ClassConstant m_clzTuple;
    private transient ClassConstant m_clzCondTuple;
    private transient ClassConstant m_clzAuto;
    private transient ClassConstant m_clzOp;
    private transient ClassConstant m_clzRO;
    private transient ClassConstant m_clzFinal;
    private transient ClassConstant m_clzInject;
    private transient ClassConstant m_clzAbstract;
    private transient ClassConstant m_clzAtomic;
    private transient ClassConstant m_clzConcurrent;
    private transient ClassConstant m_clzSynchronized;
    private transient ClassConstant m_clzFuture;
    private transient ClassConstant m_clzOverride;
    private transient ClassConstant m_clzLazy;
    private transient ClassConstant m_clzTest;
    private transient ClassConstant m_clzTransient;
    private transient ClassConstant m_clzUnassigned;
    private transient ClassConstant m_clzVolatile;
    private transient TypeConstant m_typeObject;
    private transient TypeConstant m_typeInner;
    private transient TypeConstant m_typeOuter;
    private transient TypeConstant m_typeRef;
    private transient TypeConstant m_typeRefRB;
    private transient TypeConstant m_typeVar;
    private transient TypeConstant m_typeVarRB;
    private transient TypeConstant m_typeType;
    private transient TypeConstant m_typeStruct;
    private transient TypeConstant m_typeClass;
    private transient TypeConstant m_typeConst;
    private transient TypeConstant m_typeConstRB;
    private transient TypeConstant m_typeService;
    private transient TypeConstant m_typeServiceRB;
    private transient TypeConstant m_typeModule;
    private transient TypeConstant m_typeModuleRB;
    private transient TypeConstant m_typePackage;
    private transient TypeConstant m_typePackageRB;
    private transient TypeConstant m_typeEnumRB;
    private transient TypeConstant m_typeEnumeration;
    private transient TypeConstant m_typeEnumValue;
    private transient TypeConstant m_typeException;
    private transient TypeConstant m_typeCloseable;
    private transient TypeConstant m_typeException\u0967;
    private transient TypeConstant m_typeProperty;
    private transient TypeConstant m_typeMethod;
    private transient TypeConstant m_typeParameter;
    private transient TypeConstant m_typeFunction;
    private transient TypeConstant m_typeBoolean;
    private transient TypeConstant m_typeTrue;
    private transient TypeConstant m_typeFalse;
    private transient TypeConstant m_typeNullable;
    private transient TypeConstant m_typeOrdered;
    private transient TypeConstant m_typeNull;
    private transient TypeConstant m_typeChar;
    private transient TypeConstant m_typeIntLiteral;
    private transient TypeConstant m_typeFPLiteral;
    private transient TypeConstant m_typeRegEx;
    private transient TypeConstant m_typeString;
    private transient TypeConstant m_typeStringable;
    private transient TypeConstant m_typeStringBuffer;
    private transient TypeConstant m_typeString\u0967;
    private transient TypeConstant m_typeBit;
    private transient TypeConstant m_typeNibble;
    private transient TypeConstant m_typeBitArray;
    private transient TypeConstant m_typeByteArray;
    private transient TypeConstant m_typeBinary;
    private transient TypeConstant m_typeInt8;
    private transient TypeConstant m_typeInt16;
    private transient TypeConstant m_typeInt32;
    private transient TypeConstant m_typeInt64;
    private transient TypeConstant m_typeInt128;
    private transient TypeConstant m_typeIntN;
    private transient TypeConstant m_typeUInt8;
    private transient TypeConstant m_typeUInt16;
    private transient TypeConstant m_typeUInt32;
    private transient TypeConstant m_typeUInt64;
    private transient TypeConstant m_typeUInt128;
    private transient TypeConstant m_typeUIntN;
    private transient TypeConstant m_typeDec64;
    private transient TypeConstant m_typeFloat32;
    private transient TypeConstant m_typeFloat64;
    private transient TypeConstant m_typeIndexed;
    private transient TypeConstant m_typeArray;
    private transient TypeConstant m_typeMatrix;
    private transient TypeConstant m_typeCollection;
    private transient TypeConstant m_typeSet;
    private transient TypeConstant m_typeList;
    private transient TypeConstant m_typeMap;
    private transient TypeConstant m_typeSliceable;
    private transient TypeConstant m_typeOrderable;
    private transient TypeConstant m_typeSequential;
    private transient TypeConstant m_typeNumber;
    private transient TypeConstant m_typeFreezable;
    private transient TypeConstant m_typeAutoFreezable;
    private transient TypeConstant m_typeRange;
    private transient TypeConstant m_typeInterval;
    private transient TypeConstant m_typeIterable;
    private transient TypeConstant m_typeIterator;
    private transient TypeConstant m_typeTuple;
    private transient TypeConstant m_typeTuple0;
    private transient TypeConstant m_typeCondTuple;
    private transient TypeConstant m_typeDate;
    private transient TypeConstant m_typeTimeOfDay;
    private transient TypeConstant m_typeTime;
    private transient TypeConstant m_typeTimeZone;
    private transient TypeConstant m_typeDuration;
    private transient TypeConstant m_typeVersion;
    private transient TypeConstant m_typePath;
    private transient TypeConstant m_typeFileStore;
    private transient TypeConstant m_typeDirectory;
    private transient TypeConstant m_typeFile;
    private transient TypeConstant m_typeFileNode;
    private transient IntConstant m_val0;
    private transient SingletonConstant m_valFalse;
    private transient SingletonConstant m_valTrue;
    private transient SingletonConstant m_valLesser;
    private transient SingletonConstant m_valEqual;
    private transient SingletonConstant m_valGreater;
    private transient SingletonConstant m_valNull;
    private transient RegisterConstant m_valDefault;
    private transient SignatureConstant m_sigToString;
    private transient SignatureConstant m_sigEquals;
    private transient SignatureConstant m_sigCompare;
    private transient SignatureConstant m_sigClose;
    private transient SignatureConstant m_sigValidator;
    private transient TypeInfo m_infoPlaceholder;

    public ConstantPool(FileStructure fileStructure) {
        super(fileStructure);
    }

    public Constant getConstant(int i) {
        return i == -1 ? null : this.m_listConst.get(i);
    }

    public int size() {
        return this.m_listConst.size();
    }

    public Constant[] getConstants() {
        return this.m_listConst.toArray(Constant.NO_CONSTS);
    }

    public Constant getConstant(Constant constant) {
        return constant == null ? null : this.ensureConstantLookup(constant.getFormat()).get(constant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constant register(Constant constant) {
        if (constant == null) {
            return null;
        }
        constant = constant.resolveTypedefs();
        Map<Constant, Constant> mapConstants = this.ensureConstantLookup(constant.getFormat());
        Constant constantOld = mapConstants.get(constant);
        boolean fRegisterRecursively = false;
        if (constantOld == null) {
            TypeConstant type;
            if (constant.containsUnresolved()) {
                return constant;
            }
            if (constant instanceof TypeConstant && !(type = (TypeConstant)constant).isShared(this)) {
                return constant;
            }
            if (constant.getContaining() != this) {
                constant = constant.adoptedBy(this);
            }
            ConstantPool constantPool = this;
            synchronized (constantPool) {
                if (mapConstants.containsKey(constant)) {
                    return mapConstants.get(constant);
                }
                constant.setPosition(this.m_listConst.size());
                this.m_listConst.add(constant);
                mapConstants.put(constant, constant);
                Object oLocator = constant.getLocator();
                if (oLocator != null) {
                    Constant constOld;
                    Constant constLocator;
                    if (oLocator instanceof Constant && (constLocator = (Constant)oLocator).getContaining() != this) {
                        constLocator = constLocator.adoptedBy(this);
                        constLocator.registerConstants(this);
                        oLocator = constLocator;
                    }
                    if ((constOld = this.ensureLocatorLookup(constant.getFormat()).put(oLocator, constant)) != null && !constOld.equals(constant)) {
                        throw new IllegalStateException("locator collision: old=" + String.valueOf(constOld) + ", new=" + String.valueOf(constant));
                    }
                }
            }
            fRegisterRecursively = true;
        } else {
            constant = constantOld;
        }
        if (this.m_fRecurseReg) {
            fRegisterRecursively = constant.addRef();
        }
        if (fRegisterRecursively) {
            constant.registerConstants(this);
            constant.checkValidPools(this.m_setValidPools, new int[]{0});
        }
        return constant;
    }

    public void buildValidPoolSet() {
        Set<ConstantPool> set = this.m_setValidPools;
        if (set.isEmpty()) {
            this.contributeToValidPoolSet(set);
        }
    }

    private void contributeToValidPoolSet(Set<ConstantPool> set) {
        if (set.add(this)) {
            FileStructure file = this.getFileStructure();
            for (ModuleConstant idModule : file.moduleIds()) {
                ModuleStructure moduleUpstream;
                ModuleStructure moduleFingerprint = file.getModule(idModule);
                if (!moduleFingerprint.isFingerprint() || (moduleUpstream = moduleFingerprint.getFingerprintOrigin()) == null) continue;
                moduleUpstream.getConstantPool().contributeToValidPoolSet(set);
            }
        }
    }

    public UInt8ArrayConstant ensureByteStringConstant(byte[] ab) {
        UInt8ArrayConstant constant = new UInt8ArrayConstant(this, (byte[])ab.clone());
        return (UInt8ArrayConstant)this.register(constant);
    }

    public CharConstant ensureCharConstant(int ch) {
        CharConstant constant;
        if (ch <= 127 && (constant = (CharConstant)this.ensureLocatorLookup(Constant.Format.Char).get(Character.valueOf((char)ch))) != null) {
            return constant;
        }
        return (CharConstant)this.register(new CharConstant(this, ch));
    }

    public RegExConstant ensureRegExConstant(String expression, int nFlags) {
        RegExConstant constant;
        RegExConstant regExConstant = constant = nFlags == 0 ? (RegExConstant)this.ensureLocatorLookup(Constant.Format.RegEx).get(expression) : null;
        if (constant == null) {
            constant = (RegExConstant)this.register(new RegExConstant(this, expression, nFlags));
        }
        return constant;
    }

    public StringConstant ensureStringConstant(String s) {
        StringConstant constant = (StringConstant)this.ensureLocatorLookup(Constant.Format.String).get(s);
        if (constant == null) {
            constant = (StringConstant)this.register(new StringConstant(this, s));
        }
        return constant;
    }

    public LiteralConstant ensureLiteralConstant(Constant.Format format, String s) {
        return (LiteralConstant)this.ensureLiteralConstant(format, s, null);
    }

    public Constant ensureLiteralConstant(Constant.Format format, String s, Object oValue) {
        switch (format) {
            case IntLiteral: 
            case FPLiteral: 
            case Date: 
            case TimeOfDay: 
            case Time: 
            case Duration: 
            case Path: 
            case RegEx: {
                LiteralConstant constant = (LiteralConstant)this.ensureLocatorLookup(format).get(s);
                if (constant == null) {
                    constant = (LiteralConstant)this.register(new LiteralConstant(this, format, s, oValue));
                }
                return constant;
            }
            case Dec32: 
            case Dec64: 
            case Dec128: 
            case DecN: 
            case Float8e4: 
            case Float8e5: 
            case BFloat16: 
            case Float16: 
            case Float32: 
            case Float64: 
            case Float128: 
            case FloatN: {
                LiteralConstant constant = (LiteralConstant)this.ensureLocatorLookup(Constant.Format.FPLiteral).get(s);
                if (constant == null) {
                    constant = new LiteralConstant(this, Constant.Format.FPLiteral, s, oValue);
                }
                return switch (format) {
                    case Constant.Format.Dec32, Constant.Format.Dec64, Constant.Format.Dec128 -> constant.toDecimalConstant(format);
                    case Constant.Format.DecN -> constant.toDecNConstant();
                    case Constant.Format.Float8e4 -> constant.toFloat8e4Constant();
                    case Constant.Format.Float8e5 -> constant.toFloat8e5Constant();
                    case Constant.Format.BFloat16 -> constant.toBFloat16Constant();
                    case Constant.Format.Float16 -> constant.toFloat16Constant();
                    case Constant.Format.Float32 -> constant.toFloat32Constant();
                    case Constant.Format.Float64 -> constant.toFloat64Constant();
                    case Constant.Format.Float128 -> constant.toFloat128Constant();
                    case Constant.Format.FloatN -> constant.toFloatNConstant();
                    default -> throw new IllegalStateException();
                };
            }
            case Int16: 
            case Int32: 
            case Int64: 
            case Int128: 
            case UInt16: 
            case UInt32: 
            case UInt64: 
            case UInt128: {
                return this.ensureIntConstant((PackedInteger)oValue, format);
            }
            case Bit: 
            case Int8: 
            case Nibble: 
            case UInt8: {
                return this.ensureByteConstant(format, ((PackedInteger)oValue).getInt());
            }
        }
        throw new IllegalStateException("unsupported format: " + String.valueOf((Object)format));
    }

    public ByteConstant ensureBitConstant(int n) {
        return this.ensureByteConstant(Constant.Format.Bit, n);
    }

    public ByteConstant ensureNibbleConstant(int n) {
        return this.ensureByteConstant(Constant.Format.Nibble, n);
    }

    public ByteConstant ensureByteConstant(Constant.Format format, int n) {
        switch (format) {
            case Bit: 
            case Int8: 
            case Nibble: 
            case UInt8: {
                ByteConstant constant = (ByteConstant)this.ensureLocatorLookup(format).get(n);
                if (constant == null) {
                    constant = (ByteConstant)this.register(new ByteConstant(this, format, n));
                }
                return constant;
            }
        }
        throw new IllegalArgumentException("format=" + String.valueOf((Object)format));
    }

    public IntConstant ensureIntConstant(long n) {
        return this.ensureIntConstant(PackedInteger.valueOf(n));
    }

    public IntConstant ensureIntConstant(PackedInteger pint) {
        return this.ensureIntConstant(pint, Constant.Format.Int64);
    }

    public IntConstant ensureIntConstant(PackedInteger pint, Constant.Format format) {
        switch (format) {
            case Int16: 
            case Int32: 
            case Int64: 
            case Int128: 
            case UInt16: 
            case UInt32: 
            case UInt64: 
            case UInt128: 
            case IntN: 
            case UIntN: {
                IntConstant constant = (IntConstant)this.ensureLocatorLookup(format).get(pint);
                if (constant == null) {
                    constant = (IntConstant)this.register(new IntConstant(this, format, pint));
                }
                return constant;
            }
        }
        throw new IllegalStateException("unsupported format: " + String.valueOf((Object)format));
    }

    public DecimalConstant ensureDecConstant(Decimal dec) {
        Constant.Format format = switch (dec.getBitLength()) {
            case 32 -> Constant.Format.Dec32;
            case 64 -> Constant.Format.Dec64;
            case 128 -> Constant.Format.Dec128;
            default -> throw new IllegalArgumentException("unsupported decimal type: " + dec.getClass().getSimpleName());
        };
        DecimalConstant constant = (DecimalConstant)this.ensureLocatorLookup(format).get(dec);
        if (constant == null) {
            constant = (DecimalConstant)this.register(new DecimalConstant(this, dec));
        }
        return constant;
    }

    public DecimalAutoConstant ensureDecAConstant(Decimal dec) {
        DecimalAutoConstant constant = (DecimalAutoConstant)this.ensureLocatorLookup(Constant.Format.Dec64).get(dec);
        if (constant == null) {
            constant = (DecimalAutoConstant)this.register(new DecimalAutoConstant(this, dec));
        }
        return constant;
    }

    public FPNConstant ensureDecNConstant(byte[] abVal) {
        return (FPNConstant)this.register(new FPNConstant(this, Constant.Format.DecN, abVal));
    }

    public Float8e4Constant ensureFloat8e4Constant(float flVal) {
        Float8e4Constant constant = (Float8e4Constant)this.ensureLocatorLookup(Constant.Format.Float8e4).get(Float.valueOf(flVal));
        if (constant == null) {
            constant = (Float8e4Constant)this.register(new Float8e4Constant(this, flVal));
        }
        return constant;
    }

    public Float8e5Constant ensureFloat8e5Constant(float flVal) {
        Float8e5Constant constant = (Float8e5Constant)this.ensureLocatorLookup(Constant.Format.Float8e5).get(Float.valueOf(flVal));
        if (constant == null) {
            constant = (Float8e5Constant)this.register(new Float8e5Constant(this, flVal));
        }
        return constant;
    }

    public BFloat16Constant ensureBFloat16Constant(float flVal) {
        BFloat16Constant constant = (BFloat16Constant)this.ensureLocatorLookup(Constant.Format.BFloat16).get(Float.valueOf(flVal));
        if (constant == null) {
            constant = (BFloat16Constant)this.register(new BFloat16Constant(this, flVal));
        }
        return constant;
    }

    public Float16Constant ensureFloat16Constant(float flVal) {
        Float16Constant constant = (Float16Constant)this.ensureLocatorLookup(Constant.Format.Float16).get(Float.valueOf(flVal));
        if (constant == null) {
            constant = (Float16Constant)this.register(new Float16Constant(this, flVal));
        }
        return constant;
    }

    public Float32Constant ensureFloat32Constant(float flVal) {
        Float32Constant constant = (Float32Constant)this.ensureLocatorLookup(Constant.Format.Float32).get(Float.valueOf(flVal));
        if (constant == null) {
            constant = (Float32Constant)this.register(new Float32Constant(this, flVal));
        }
        return constant;
    }

    public Float64Constant ensureFloat64Constant(double flVal) {
        Float64Constant constant = (Float64Constant)this.ensureLocatorLookup(Constant.Format.Float64).get(flVal);
        if (constant == null) {
            constant = (Float64Constant)this.register(new Float64Constant(this, flVal));
        }
        return constant;
    }

    public Float128Constant ensureFloat128Constant(byte[] abVal) {
        return (Float128Constant)this.register(new Float128Constant(this, abVal));
    }

    public FPNConstant ensureFloatNConstant(byte[] abVal) {
        return (FPNConstant)this.register(new FPNConstant(this, Constant.Format.FloatN, abVal));
    }

    public LiteralConstant ensureTimeConstant(FileTime ft) {
        if (ft == null) {
            return this.defaultTimeConstant();
        }
        String sDT = ft.toInstant().atOffset(ZoneOffset.UTC).toString();
        return this.ensureLiteralConstant(Constant.Format.Time, sDT);
    }

    public LiteralConstant ensureTimeConstant(Instant instant) {
        return instant == null ? this.defaultTimeConstant() : this.ensureLiteralConstant(Constant.Format.Time, instant.toString());
    }

    public LiteralConstant defaultTimeConstant() {
        return this.ensureLiteralConstant(Constant.Format.Time, Instant.EPOCH.toString());
    }

    public VersionConstant ensureVersionConstant(Version ver) {
        VersionConstant constant = (VersionConstant)this.ensureLocatorLookup(Constant.Format.Version).get(ver.toString());
        if (constant == null) {
            constant = (VersionConstant)this.register(new VersionConstant(this, ver));
        }
        return constant;
    }

    public ArrayConstant ensureArrayConstant(TypeConstant constType, Constant[] aconst) {
        Handy.checkElementsNonNull(aconst);
        return (ArrayConstant)this.register(new ArrayConstant(this, Constant.Format.Array, constType, (Constant[])aconst.clone()));
    }

    public ArrayConstant ensureSetConstant(TypeConstant constType, Constant[] aconst) {
        Handy.checkElementsNonNull(aconst);
        return (ArrayConstant)this.register(new ArrayConstant(this, Constant.Format.Set, constType, (Constant[])aconst.clone()));
    }

    public ArrayConstant ensureTupleConstant(TypeConstant constType, Constant ... aconst) {
        Handy.checkElementsNonNull(aconst);
        return (ArrayConstant)this.register(new ArrayConstant(this, Constant.Format.Tuple, constType, (Constant[])aconst.clone()));
    }

    public MapConstant ensureMapConstant(TypeConstant constType, Map<? extends Constant, ? extends Constant> map) {
        return new MapConstant(this, constType, map);
    }

    public RangeConstant ensureRangeConstant(Constant const1, Constant const2) {
        return this.ensureRangeConstant(const1, false, const2, false);
    }

    public RangeConstant ensureRangeConstant(Constant const1, boolean fExclude1, Constant const2, boolean fExclude2) {
        assert (const1.getFormat() == const2.getFormat());
        return new RangeConstant(this, const1, fExclude1, const2, fExclude2);
    }

    public FileStoreConstant ensureFileStoreConstant(String sPath, FSNodeConstant constDir) {
        return new FileStoreConstant(this, sPath, constDir);
    }

    public FSNodeConstant ensureDirectoryConstant(String sName, FileTime ftCreated, FileTime ftModified, FSNodeConstant[] aFiles) {
        return new FSNodeConstant(this, sName, ftCreated, ftModified, aFiles);
    }

    public FSNodeConstant ensureFileConstant(String sName, FileTime ftCreated, FileTime ftModified, byte[] ab) {
        return new FSNodeConstant(this, sName, ftCreated, ftModified, ab);
    }

    public MatchAnyConstant ensureMatchAnyConstant(TypeConstant type) {
        MatchAnyConstant constant = (MatchAnyConstant)this.ensureLocatorLookup(Constant.Format.Any).get(type);
        if (constant == null) {
            constant = (MatchAnyConstant)this.register(new MatchAnyConstant(this, type));
        }
        return constant;
    }

    public NamedCondition ensureNamedCondition(String sName) {
        NamedCondition cond = (NamedCondition)this.ensureLocatorLookup(Constant.Format.ConditionNamed).get(sName);
        if (cond == null) {
            cond = (NamedCondition)this.register(new NamedCondition(this, this.ensureStringConstant(sName)));
        }
        return cond;
    }

    public PresentCondition ensurePresentCondition(Constant constId) {
        PresentCondition cond = (PresentCondition)this.ensureLocatorLookup(Constant.Format.ConditionPresent).get(constId);
        if (cond == null) {
            cond = (PresentCondition)this.register(new PresentCondition(this, constId));
        }
        return cond;
    }

    public VersionMatchesCondition ensureImportVersionCondition(ModuleConstant constModule, VersionConstant constVer) {
        return (VersionMatchesCondition)this.register(new VersionMatchesCondition(this, constModule, constVer));
    }

    public VersionedCondition ensureVersionedCondition(Version ver) {
        return this.ensureVersionedCondition(this.ensureVersionConstant(ver));
    }

    public VersionedCondition ensureVersionedCondition(VersionConstant constVer) {
        VersionedCondition cond = (VersionedCondition)this.ensureLocatorLookup(Constant.Format.ConditionVersioned).get(constVer);
        if (cond == null) {
            cond = (VersionedCondition)this.register(new VersionedCondition(this, constVer));
        }
        return cond;
    }

    public ConditionalConstant ensureNotCondition(ConditionalConstant cond) {
        if (cond instanceof NotCondition) {
            NotCondition condNot = (NotCondition)cond;
            return condNot.getUnderlyingCondition();
        }
        NotCondition condNot = (NotCondition)this.ensureLocatorLookup(Constant.Format.ConditionNot).get(cond);
        if (condNot == null) {
            condNot = (NotCondition)this.register(new NotCondition(this, cond));
        }
        return condNot;
    }

    public AnyCondition ensureAnyCondition(ConditionalConstant ... aCondition) {
        Handy.checkElementsNonNull(aCondition);
        if (aCondition.length < 2) {
            throw new IllegalArgumentException("at least 2 conditions required");
        }
        return (AnyCondition)this.register(new AnyCondition(this, aCondition));
    }

    public AllCondition ensureAllCondition(ConditionalConstant ... aCondition) {
        Handy.checkElementsNonNull(aCondition);
        if (aCondition.length < 2) {
            throw new IllegalArgumentException("at least 2 conditions required");
        }
        return (AllCondition)this.register(new AllCondition(this, aCondition));
    }

    public ModuleConstant ensureModuleConstant(String sName) {
        return this.ensureModuleConstant(sName, null);
    }

    public ModuleConstant ensureModuleConstant(String sName, Version version) {
        if (!Lexer.isValidQualifiedModule(sName)) {
            throw new IllegalArgumentException("illegal qualified module name: " + Handy.quotedString(sName));
        }
        return (ModuleConstant)this.register(new ModuleConstant(this, sName, version));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PackageConstant ensurePackageConstant(IdentityConstant constParent, String sPackage) {
        if (constParent == null) {
            throw new IllegalArgumentException("ModuleConstant or PackageConstant required");
        }
        if (!Lexer.isValidIdentifier(sPackage)) {
            throw new IllegalArgumentException("illegal package name: " + sPackage);
        }
        switch (constParent.getFormat()) {
            case Module: 
            case Package: {
                return (PackageConstant)this.register(new PackageConstant(this, constParent, sPackage));
            }
            default: {
                throw new IllegalArgumentException("constant " + String.valueOf((Object)constParent.getFormat()) + " is not a Module or Package");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClassConstant ensureClassConstant(IdentityConstant constParent, String sClass) {
        switch (constParent.getFormat()) {
            case Module: 
            case Package: 
            case Class: 
            case Method: 
            case Property: {
                return (ClassConstant)this.register(new ClassConstant(this, constParent, sClass));
            }
            default: {
                throw new IllegalArgumentException("constant " + String.valueOf((Object)constParent.getFormat()) + " is not a valid parent");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public IdentityConstant ensureClassConstant(TypeConstant type) {
        IdentityConstant identityConstant;
        Map<Object, Constant> mapLocator = this.ensureLocatorLookup(Constant.Format.DecoratedClass);
        IdentityConstant constant = (IdentityConstant)mapLocator.get(type);
        if (constant != null) {
            return constant;
        }
        if (!type.isSingleDefiningConstant()) {
            throw new IllegalArgumentException("type must a single defining constant: " + String.valueOf(type));
        }
        if ((type.isImmutabilitySpecified() || type.isAccessSpecified()) && (constant = (IdentityConstant)mapLocator.get(type = type.removeImmutable().removeAccess())) != null) {
            return constant;
        }
        boolean fUseType = false;
        TypeConstant typeCur = type;
        do {
            if (typeCur.getParamsCount() <= 0 && !typeCur.isAnnotated()) continue;
            fUseType = true;
            break;
        } while ((typeCur = typeCur.isVirtualChild() ? typeCur.getParentType() : null) != null);
        Constant constant2 = type.getDefiningConstant();
        if (constant2 instanceof ClassConstant) {
            ClassConstant idClz = (ClassConstant)constant2;
            if (!fUseType) {
                identityConstant = (IdentityConstant)this.register(idClz);
                return identityConstant;
            }
        }
        identityConstant = (DecoratedClassConstant)this.register(new DecoratedClassConstant(this, type));
        return identityConstant;
    }

    public DynamicFormalConstant ensureDynamicFormal(MethodConstant idMethod, Register reg, FormalConstant idFormal, String sVarName) {
        DynamicFormalConstant constDynamic = new DynamicFormalConstant(this, idMethod, sVarName, reg, idFormal);
        return (DynamicFormalConstant)this.register(constDynamic);
    }

    public SingletonConstant ensureSingletonConstConstant(IdentityConstant constClass) {
        return constClass.getComponent().getFormat() == Component.Format.ENUMVALUE ? (EnumValueConstant)this.register(new EnumValueConstant(this, (ClassConstant)constClass)) : (SingletonConstant)this.register(new SingletonConstant(this, Constant.Format.SingletonConst, constClass));
    }

    public TypeConstant ensureEcstasyTypeConstant(String sClass) {
        return this.ensureTerminalTypeConstant(this.ensureEcstasyClassConstant(sClass));
    }

    public ClassConstant ensureEcstasyClassConstant(String sClass) {
        IdentityConstant constParent = this.modEcstasy();
        int ofStart = 0;
        int ofEnd = sClass.indexOf(46);
        while (ofEnd >= 0) {
            String sName = sClass.substring(ofStart, ofEnd);
            constParent = constParent instanceof ClassConstant || sName.charAt(0) <= 'Z' ? this.ensureClassConstant(constParent, sName) : this.ensurePackageConstant(constParent, sName);
            ofStart = ofEnd + 1;
            ofEnd = sClass.indexOf(46, ofStart);
        }
        return this.ensureClassConstant(constParent, sClass.substring(ofStart));
    }

    public IdentityConstant getImplicitlyImportedIdentity(String sName) {
        IdentityConstant id = this.f_implicits.get(sName);
        if (id == null) {
            String sPkg;
            char ch;
            int iPart;
            String[] asParts = s_implicits.get(sName);
            if (asParts == null) {
                return null;
            }
            int cParts = asParts.length;
            assert (cParts >= 2);
            assert (asParts[0].equals("ecstasy"));
            id = this.modEcstasy();
            for (iPart = 1; iPart < cParts && ((ch = (sPkg = asParts[iPart]).charAt(0)) < 'A' || ch > 'Z'); ++iPart) {
                id = this.ensurePackageConstant(id, sPkg);
            }
            while (iPart < cParts) {
                String sClz = asParts[iPart++];
                id = this.ensureClassConstant(id, sClz);
            }
            this.f_implicits.put(sName, id);
        }
        return id;
    }

    public Component getImplicitlyImportedComponent(String sName) {
        IdentityConstant constId = this.getImplicitlyImportedIdentity(sName);
        if (constId == null) {
            return null;
        }
        return constId.getComponent();
    }

    public static String getImplicitImportName(String sPath) {
        return s_implicitsByPath.get(sPath);
    }

    public TypedefConstant ensureTypedefConstant(IdentityConstant constParent, String sName) {
        return (TypedefConstant)this.register(new TypedefConstant(this, constParent, sName));
    }

    public PropertyConstant ensurePropertyConstant(IdentityConstant constParent, String sName) {
        return (PropertyConstant)this.register(new PropertyConstant(this, constParent, sName));
    }

    public MultiMethodConstant ensureMultiMethodConstant(IdentityConstant constParent, String sName) {
        return (MultiMethodConstant)this.register(new MultiMethodConstant(this, constParent, sName));
    }

    public MethodConstant ensureMethodConstant(IdentityConstant constParent, String sName, TypeConstant[] aconstParams, TypeConstant[] aconstReturns) {
        assert (constParent != null);
        MultiMethodConstant constMultiMethod = switch (constParent.getFormat()) {
            case Constant.Format.MultiMethod -> (MultiMethodConstant)constParent;
            case Constant.Format.Module, Constant.Format.Package, Constant.Format.Class, Constant.Format.Method, Constant.Format.Property, Constant.Format.TypeParameter, Constant.Format.FormalTypeChild -> this.ensureMultiMethodConstant(constParent, sName);
            default -> throw new IllegalArgumentException("constant " + String.valueOf((Object)constParent.getFormat()) + " is not a Module, Package, Class, Method, or Property");
        };
        return (MethodConstant)this.register(new MethodConstant(this, constMultiMethod, aconstParams, aconstReturns));
    }

    public MethodConstant ensureMethodConstant(IdentityConstant constParent, SignatureConstant constSig) {
        assert (constParent != null);
        assert (constSig != null);
        MultiMethodConstant constMultiMethod = switch (constParent.getFormat()) {
            case Constant.Format.MultiMethod -> (MultiMethodConstant)constParent;
            case Constant.Format.Module, Constant.Format.Package, Constant.Format.Class, Constant.Format.Method, Constant.Format.Property, Constant.Format.TypeParameter, Constant.Format.FormalTypeChild, Constant.Format.NativeClass, Constant.Format.DynamicFormal -> this.ensureMultiMethodConstant(constParent, constSig.getName());
            default -> throw new IllegalArgumentException("constant " + String.valueOf((Object)constParent.getFormat()) + " is not a Module, Package, Class, Method, or Property");
        };
        return (MethodConstant)this.register(new MethodConstant(this, constMultiMethod, constSig));
    }

    public SignatureConstant ensureSignatureConstant(String sName, TypeConstant[] aconstParams, TypeConstant[] aconstReturns) {
        return (SignatureConstant)this.register(new SignatureConstant(this, sName, aconstParams, aconstReturns));
    }

    public TypeConstant ensureClassTypeConstant(Constant constClass, Constants.Access access, TypeConstant ... constTypes) {
        TypeConstant constType = (TypeConstant)this.ensureLocatorLookup(Constant.Format.TerminalType).get(constClass);
        if (constType == null) {
            constType = (TypeConstant)this.register(new TerminalTypeConstant(this, constClass));
        }
        if (constTypes != null) {
            constType = this.ensureParameterizedTypeConstant(constType, constTypes);
        }
        if (access != null && !access.equals((Object)Constants.Access.PUBLIC)) {
            constType = this.ensureAccessTypeConstant(constType, access);
        }
        return constType;
    }

    public TypeConstant ensureAccessTypeConstant(TypeConstant constType, Constants.Access access) {
        if (access == null) {
            access = Constants.Access.PUBLIC;
        }
        if (constType.isAccessSpecified()) {
            if (constType.getAccess() == access) {
                return constType;
            }
            if (constType instanceof AccessTypeConstant) {
                return this.ensureAccessTypeConstant(constType.getUnderlyingType(), access);
            }
            throw new IllegalArgumentException("type already has an access specified");
        }
        TypeConstant constAccess = null;
        if (access == Constants.Access.PUBLIC) {
            constAccess = (TypeConstant)this.ensureLocatorLookup(Constant.Format.AccessType).get(constType);
        }
        if (constAccess == null) {
            constAccess = (TypeConstant)this.register(new AccessTypeConstant(this, constType, access));
        }
        return constAccess;
    }

    public TypeConstant ensureParameterizedTypeConstant(TypeConstant constType, TypeConstant ... constTypes) {
        if (constType.isParamsSpecified()) {
            block4: {
                TypeConstant[] atypeParam = constType.getParamTypesArray();
                int c = atypeParam.length;
                if (c == constTypes.length) {
                    for (int i = 0; i < c; ++i) {
                        if (constTypes[i].equals(atypeParam[i])) {
                            continue;
                        }
                        break block4;
                    }
                    return constType;
                }
            }
            throw new IllegalArgumentException("type already has parameters specified");
        }
        Handy.checkElementsNonNull(constTypes);
        return (TypeConstant)this.register(new ParameterizedTypeConstant(this, constType, constTypes));
    }

    public TypeConstant ensureArrayType(TypeConstant typeElement) {
        return this.ensureParameterizedTypeConstant(this.typeArray(), typeElement);
    }

    public TypeConstant ensureIndexedType(TypeConstant typeElement) {
        return this.ensureParameterizedTypeConstant(this.typeIndexed(), this.typeInt64(), typeElement);
    }

    public TypeConstant ensureSetType(TypeConstant typeElement) {
        return this.ensureParameterizedTypeConstant(this.typeSet(), typeElement);
    }

    public TypeConstant ensureRangeType(TypeConstant typeElement) {
        return this.ensureParameterizedTypeConstant(this.typeRange(), typeElement);
    }

    public TypeConstant ensureMapType(TypeConstant typeKey, TypeConstant typeValue) {
        return this.ensureParameterizedTypeConstant(this.typeMap(), typeKey, typeValue);
    }

    public TypeConstant ensureTupleType(TypeConstant ... atypeParams) {
        return this.ensureParameterizedTypeConstant(this.typeTuple(), atypeParams);
    }

    public TypeConstant ensureImmutableTypeConstant(TypeConstant constType) {
        if (constType.isImmutabilitySpecified()) {
            throw new IllegalArgumentException("type already has the immutability specified");
        }
        TypeConstant constant = (TypeConstant)this.ensureLocatorLookup(Constant.Format.ImmutableType).get(constType);
        return constant == null ? (TypeConstant)this.register(new ImmutableTypeConstant(this, constType)) : constant;
    }

    public TypeConstant ensureServiceTypeConstant(TypeConstant constType) {
        TypeConstant constant = (TypeConstant)this.ensureLocatorLookup(Constant.Format.ServiceType).get(constType);
        return constant == null ? (TypeConstant)this.register(new ServiceTypeConstant(this, constType)) : constant;
    }

    public TypeConstant ensureVirtualChildTypeConstant(TypeConstant constParent, String sName) {
        return (TypeConstant)this.register(new VirtualChildTypeConstant(this, constParent, sName, false));
    }

    public TypeConstant ensureThisVirtualChildTypeConstant(TypeConstant constParent, String sName) {
        return (TypeConstant)this.register(new VirtualChildTypeConstant(this, constParent, sName, true));
    }

    public TypeConstant ensureVirtualTypeConstant(ClassStructure clzBase, ClassStructure clzChild, boolean fFormal, boolean fParameterize, Constant constTarget) {
        TypeConstant typeTarget;
        boolean fCheckAuto;
        TypeConstant typeParent;
        assert (clzChild.isVirtualChild());
        String sName = clzChild.getName();
        ClassStructure clzParent = (ClassStructure)clzChild.getParent();
        IdentityConstant idParent = clzParent.getIdentityConstant();
        assert (!clzBase.containsUnresolvedContribution());
        boolean fAutoNarrow = false;
        boolean fThisClass = false;
        Constant constOrig = constTarget;
        switch (constTarget.getFormat()) {
            case ThisClass: {
                fAutoNarrow = true;
                fThisClass = true;
                constTarget = ((ThisClassConstant)constTarget).getDeclarationLevelClass();
                break;
            }
            case ParentClass: {
                constTarget = ((ParentClassConstant)constTarget).getChildClass();
                break;
            }
            case ChildClass: {
                constTarget = ((ChildClassConstant)constTarget).getParent();
            }
        }
        if (clzBase.equals(clzParent) || clzBase.hasContribution(idParent)) {
            typeParent = fFormal ? clzBase.getFormalType() : clzBase.getCanonicalType();
            fCheckAuto = true;
        } else if (!clzParent.isVirtualChild()) {
            typeParent = fFormal ? clzParent.getFormalType() : clzParent.getCanonicalType();
            fCheckAuto = true;
        } else {
            typeParent = this.ensureVirtualTypeConstant(clzBase, clzParent, fFormal, true, fThisClass ? constOrig : constTarget);
            if (typeParent == null) {
                return null;
            }
            fCheckAuto = false;
        }
        if (fCheckAuto && constTarget instanceof ThisClassConstant) {
            ThisClassConstant constThis = (ThisClassConstant)constTarget;
            typeParent = constThis.getDeclarationLevelClass().getType().adoptParameters(this, typeParent);
            fAutoNarrow = true;
        }
        TypeConstant typeConstant = typeTarget = fAutoNarrow ? this.ensureThisVirtualChildTypeConstant(typeParent, sName) : this.ensureVirtualChildTypeConstant(typeParent, sName);
        if (fParameterize && clzChild.getTypeParamCount() > 0) {
            TypeConstant[] atypeParams = fFormal ? clzChild.getFormalType().getParamTypesArray() : clzChild.getCanonicalType().getParamTypesArray();
            typeTarget = this.ensureParameterizedTypeConstant(typeTarget, atypeParams);
        }
        return typeTarget;
    }

    public TypeConstant ensureAnonymousClassTypeConstant(TypeConstant constParent, ClassConstant idAnon) {
        return (TypeConstant)this.register(new AnonymousClassTypeConstant(this, constParent, idAnon));
    }

    public TypeConstant ensureInnerChildTypeConstant(TypeConstant constParent, ClassConstant idChild) {
        return (TypeConstant)this.register(new InnerChildTypeConstant(this, constParent, idChild));
    }

    public TypeConstant ensurePropertyClassTypeConstant(TypeConstant constParent, PropertyConstant idProp) {
        return (TypeConstant)this.register(new PropertyClassTypeConstant(this, constParent, idProp));
    }

    public ThisClassConstant ensureThisClassConstant(IdentityConstant constClass) {
        ThisClassConstant constant = (ThisClassConstant)this.ensureLocatorLookup(Constant.Format.ThisClass).get(constClass);
        if (constant != null) {
            return constant;
        }
        return (ThisClassConstant)this.register(new ThisClassConstant(this, constClass));
    }

    public PseudoConstant ensureParentClassConstant(PseudoConstant constClass) {
        if (constClass instanceof ChildClassConstant) {
            ChildClassConstant constChild = (ChildClassConstant)constClass;
            return constChild.getParent();
        }
        ParentClassConstant constant = (ParentClassConstant)this.ensureLocatorLookup(Constant.Format.ParentClass).get(constClass);
        if (constant != null) {
            return constant;
        }
        return (ParentClassConstant)this.register(new ParentClassConstant(this, constClass));
    }

    public PseudoConstant ensureChildClassConstant(PseudoConstant constClass, String sName) {
        return (ChildClassConstant)this.register(new ChildClassConstant(this, constClass, sName));
    }

    public TypeConstant ensureThisTypeConstant(Constant constClass, Constants.Access access) {
        AccessTypeConstant constAccess;
        ThisClassConstant constId;
        switch (constClass.getFormat()) {
            case ThisClass: {
                constId = (ThisClassConstant)constClass;
                break;
            }
            case NativeClass: {
                constClass = ((NativeRebaseConstant)constClass).getClassConstant();
            }
            case Module: 
            case Package: 
            case Class: {
                constId = this.ensureThisClassConstant((IdentityConstant)constClass);
                break;
            }
            default: {
                throw new IllegalStateException("constant=" + String.valueOf(constClass));
            }
        }
        TypeConstant constType = (TypeConstant)this.ensureLocatorLookup(Constant.Format.TerminalType).get(constId);
        if (constType == null) {
            constType = (TypeConstant)this.register(new TerminalTypeConstant(this, constId));
        }
        if (access == null) {
            return constType;
        }
        if (access == Constants.Access.PUBLIC && (constAccess = (AccessTypeConstant)this.ensureLocatorLookup(Constant.Format.AccessType).get(constType)) != null) {
            return constAccess;
        }
        return (TypeConstant)this.register(new AccessTypeConstant(this, constType, access));
    }

    public TypeConstant ensureParentTypeConstant(TypeConstant constChild) {
        if (constChild == null || !constChild.containsAutoNarrowing(false) || !constChild.isSingleDefiningConstant() || constChild.isParamsSpecified()) {
            throw new IllegalArgumentException("single, auto-narrowing, non-parameterized child required");
        }
        PseudoConstant constId = this.ensureParentClassConstant((PseudoConstant)constChild.getDefiningConstant());
        TypeConstant constParent = new TerminalTypeConstant(this, constId);
        if (constChild.isAccessSpecified()) {
            constParent = new AccessTypeConstant(this, constParent, constChild.getAccess());
        }
        if (constChild.isImmutabilitySpecified()) {
            constParent = new ImmutableTypeConstant(this, constParent);
        }
        return (TypeConstant)this.register(constParent);
    }

    public TypeConstant ensureChildTypeConstant(TypeConstant constParent, String sChild) {
        if (constParent == null || !constParent.containsAutoNarrowing(false) || !constParent.isSingleDefiningConstant() || constParent.isParamsSpecified()) {
            throw new IllegalArgumentException("single, auto-narrowing, non-parameterized parent required");
        }
        PseudoConstant constId = this.ensureChildClassConstant((PseudoConstant)constParent.getDefiningConstant(), sChild);
        TypeConstant constChild = new TerminalTypeConstant(this, constId);
        if (constParent.isAccessSpecified()) {
            constChild = new AccessTypeConstant(this, constChild, constParent.getAccess());
        }
        if (constParent.isImmutabilitySpecified()) {
            constChild = new ImmutableTypeConstant(this, constChild);
        }
        return constChild;
    }

    public TypeParameterConstant ensureRegisterConstant(MethodConstant constMethod, int iReg, String sName) {
        TypeParameterConstant constReg = null;
        if (iReg == 0) {
            constReg = (TypeParameterConstant)this.ensureLocatorLookup(Constant.Format.TypeParameter).get(constMethod);
        }
        if (constReg == null) {
            constReg = (TypeParameterConstant)this.register(new TypeParameterConstant(this, constMethod, sName, iReg));
        }
        return constReg;
    }

    public FormalTypeChildConstant ensureFormalTypeChildConstant(FormalConstant constFormal, String sName) {
        return (FormalTypeChildConstant)this.register(new FormalTypeChildConstant(this, constFormal, sName));
    }

    public TypeConstant ensureTerminalTypeConstant(Constant constId) {
        assert (constId != null && !(constId instanceof TypeConstant));
        TypeConstant constType = (TerminalTypeConstant)this.ensureLocatorLookup(Constant.Format.TerminalType).get(constId);
        if (constType == null) {
            constType = (TypeConstant)this.register(new TerminalTypeConstant(this, constId));
        }
        return constType;
    }

    public KeywordConstant ensureKeywordConstant(Constant.Format format) {
        KeywordConstant constKeyword = (KeywordConstant)this.ensureLocatorLookup(format).get((Object)format);
        if (constKeyword == null) {
            constKeyword = (KeywordConstant)this.register(new KeywordConstant(this, format));
        }
        return constKeyword;
    }

    public Annotation ensureAnnotation(Constant constClass, Constant ... aconstParam) {
        return (Annotation)this.register(new Annotation(this, constClass, aconstParam));
    }

    public AnnotatedTypeConstant ensureAnnotatedTypeConstant(Constant constClass, Constant[] aconstParam, TypeConstant constType) {
        return (AnnotatedTypeConstant)this.register(new AnnotatedTypeConstant(this, constClass, aconstParam, constType));
    }

    public AnnotatedTypeConstant ensureAnnotatedTypeConstant(TypeConstant constType, Annotation ... annotations) {
        if (annotations.length == 0) {
            throw new IllegalArgumentException("annotations are required");
        }
        TypeConstant type = constType;
        for (int i = annotations.length - 1; i >= 0; --i) {
            type = (TypeConstant)this.register(new AnnotatedTypeConstant(this, annotations[i], type));
        }
        return (AnnotatedTypeConstant)type;
    }

    public TypeConstant ensureFuture(TypeConstant typeReferent) {
        return this.ensureAnnotatedTypeConstant(this.ensureParameterizedTypeConstant(this.typeVar(), typeReferent), this.ensureAnnotation(this.clzFuture(), new Constant[0]));
    }

    public TypeSequenceTypeConstant ensureTypeSequenceTypeConstant() {
        return (TypeSequenceTypeConstant)this.register(new TypeSequenceTypeConstant(this));
    }

    public TypeConstant ensureNullableTypeConstant(TypeConstant constType) {
        return this.typeNull().isA(constType) ? constType : this.ensureUnionTypeConstant(this.typeNullable(), constType);
    }

    public UnionTypeConstant ensureUnionTypeConstant(TypeConstant constType1, TypeConstant constType2) {
        return (UnionTypeConstant)this.register(new UnionTypeConstant(this, constType1, constType2));
    }

    public IntersectionTypeConstant ensureIntersectionTypeConstant(TypeConstant constType1, TypeConstant constType2) {
        return (IntersectionTypeConstant)this.register(new IntersectionTypeConstant(this, constType1, constType2));
    }

    public DifferenceTypeConstant ensureDifferenceTypeConstant(TypeConstant constType1, TypeConstant constType2) {
        return (DifferenceTypeConstant)this.register(new DifferenceTypeConstant(this, constType1, constType2));
    }

    public ModuleConstant modEcstasy() {
        ModuleConstant c = this.m_valEcstasy;
        if (c == null) {
            this.m_valEcstasy = c = this.ensureModuleConstant("ecstasy.xtclang.org");
        }
        return c;
    }

    public ClassConstant clzObject() {
        ClassConstant c = this.m_clzObject;
        if (c == null) {
            this.m_clzObject = c = (ClassConstant)this.getImplicitlyImportedIdentity("Object");
        }
        return c;
    }

    public ClassConstant clzInner() {
        ClassConstant c = this.m_clzInner;
        if (c == null) {
            this.m_clzInner = c = (ClassConstant)this.getImplicitlyImportedIdentity("Inner");
        }
        return c;
    }

    public ClassConstant clzOuter() {
        ClassConstant c = this.m_clzOuter;
        if (c == null) {
            this.m_clzOuter = c = (ClassConstant)this.getImplicitlyImportedIdentity("Outer");
        }
        return c;
    }

    public ClassConstant clzRef() {
        ClassConstant c = this.m_clzRef;
        if (c == null) {
            this.m_clzRef = c = (ClassConstant)this.getImplicitlyImportedIdentity("Ref");
        }
        return c;
    }

    public ClassConstant clzVar() {
        ClassConstant c = this.m_clzVar;
        if (c == null) {
            this.m_clzVar = c = (ClassConstant)this.getImplicitlyImportedIdentity("Var");
        }
        return c;
    }

    public ClassConstant clzClass() {
        ClassConstant c = this.m_clzClass;
        if (c == null) {
            this.m_clzClass = c = (ClassConstant)this.getImplicitlyImportedIdentity("Class");
        }
        return c;
    }

    public ClassConstant clzStruct() {
        ClassConstant c = this.m_clzStruct;
        if (c == null) {
            this.m_clzStruct = c = (ClassConstant)this.getImplicitlyImportedIdentity("Struct");
        }
        return c;
    }

    public ClassConstant clzType() {
        ClassConstant c = this.m_clzType;
        if (c == null) {
            this.m_clzType = c = (ClassConstant)this.getImplicitlyImportedIdentity("Type");
        }
        return c;
    }

    public ClassConstant clzConst() {
        ClassConstant c = this.m_clzConst;
        if (c == null) {
            this.m_clzConst = c = (ClassConstant)this.getImplicitlyImportedIdentity("Const");
        }
        return c;
    }

    public ClassConstant clzService() {
        ClassConstant c = this.m_clzService;
        if (c == null) {
            this.m_clzService = c = (ClassConstant)this.getImplicitlyImportedIdentity("Service");
        }
        return c;
    }

    public ClassConstant clzModule() {
        ClassConstant c = this.m_clzModule;
        if (c == null) {
            this.m_clzModule = c = (ClassConstant)this.getImplicitlyImportedIdentity("Module");
        }
        return c;
    }

    public ClassConstant clzPackage() {
        ClassConstant c = this.m_clzPackage;
        if (c == null) {
            this.m_clzPackage = c = (ClassConstant)this.getImplicitlyImportedIdentity("Package");
        }
        return c;
    }

    public ClassConstant clzEnum() {
        ClassConstant c = this.m_clzEnum;
        if (c == null) {
            this.m_clzEnum = c = (ClassConstant)this.getImplicitlyImportedIdentity("Enum");
        }
        return c;
    }

    public ClassConstant clzEnumeration() {
        ClassConstant c = this.m_clzEnumeration;
        if (c == null) {
            this.m_clzEnumeration = c = (ClassConstant)this.getImplicitlyImportedIdentity("Enumeration");
        }
        return c;
    }

    public ClassConstant clzEnumValue() {
        ClassConstant c = this.m_clzEnumValue;
        if (c == null) {
            this.m_clzEnumValue = c = (ClassConstant)this.getImplicitlyImportedIdentity("EnumValue");
        }
        return c;
    }

    public ClassConstant clzCloseable() {
        ClassConstant c = this.m_clzCloseable;
        if (c == null) {
            this.m_clzCloseable = c = (ClassConstant)this.getImplicitlyImportedIdentity("Closeable");
        }
        return c;
    }

    public ClassConstant clzException() {
        ClassConstant c = this.m_clzException;
        if (c == null) {
            this.m_clzException = c = (ClassConstant)this.getImplicitlyImportedIdentity("Exception");
        }
        return c;
    }

    public ClassConstant clzProperty() {
        ClassConstant c = this.m_clzProperty;
        if (c == null) {
            this.m_clzProperty = c = (ClassConstant)this.getImplicitlyImportedIdentity("Property");
        }
        return c;
    }

    public ClassConstant clzMethod() {
        ClassConstant c = this.m_clzMethod;
        if (c == null) {
            this.m_clzMethod = c = (ClassConstant)this.getImplicitlyImportedIdentity("Method");
        }
        return c;
    }

    public ClassConstant clzFunction() {
        ClassConstant c = this.m_clzFunction;
        if (c == null) {
            this.m_clzFunction = c = (ClassConstant)this.getImplicitlyImportedIdentity("Function");
        }
        return c;
    }

    public ClassConstant clzNullable() {
        ClassConstant c = this.m_clzNullable;
        if (c == null) {
            this.m_clzNullable = c = (ClassConstant)this.getImplicitlyImportedIdentity("Nullable");
        }
        return c;
    }

    public ClassConstant clzCollection() {
        ClassConstant c = this.m_clzCollection;
        if (c == null) {
            this.m_clzCollection = c = (ClassConstant)this.getImplicitlyImportedIdentity("Collection");
        }
        return c;
    }

    public ClassConstant clzSet() {
        ClassConstant c = this.m_clzSet;
        if (c == null) {
            this.m_clzSet = c = (ClassConstant)this.getImplicitlyImportedIdentity("Set");
        }
        return c;
    }

    public ClassConstant clzList() {
        ClassConstant c = this.m_clzList;
        if (c == null) {
            this.m_clzList = c = (ClassConstant)this.getImplicitlyImportedIdentity("List");
        }
        return c;
    }

    public ClassConstant clzArray() {
        ClassConstant c = this.m_clzArray;
        if (c == null) {
            this.m_clzArray = c = (ClassConstant)this.getImplicitlyImportedIdentity("Array");
        }
        return c;
    }

    public ClassConstant clzMatrix() {
        ClassConstant c = this.m_clzMatrix;
        if (c == null) {
            this.m_clzMatrix = c = (ClassConstant)this.getImplicitlyImportedIdentity("Matrix");
        }
        return c;
    }

    public ClassConstant clzMap() {
        ClassConstant c = this.m_clzMap;
        if (c == null) {
            this.m_clzMap = c = (ClassConstant)this.getImplicitlyImportedIdentity("Map");
        }
        return c;
    }

    public ClassConstant clzSliceable() {
        ClassConstant c = this.m_clzSliceable;
        if (c == null) {
            this.m_clzSliceable = c = (ClassConstant)this.getImplicitlyImportedIdentity("Sliceable");
        }
        return c;
    }

    public ClassConstant clzOrderable() {
        ClassConstant c = this.m_clzOrderable;
        if (c == null) {
            this.m_clzOrderable = c = (ClassConstant)this.getImplicitlyImportedIdentity("Orderable");
        }
        return c;
    }

    public ClassConstant clzTuple() {
        ClassConstant c = this.m_clzTuple;
        if (c == null) {
            this.m_clzTuple = c = (ClassConstant)this.getImplicitlyImportedIdentity("Tuple");
        }
        return c;
    }

    public ClassConstant clzCondTuple() {
        ClassConstant c = this.m_clzCondTuple;
        if (c == null) {
            this.m_clzCondTuple = c = (ClassConstant)this.getImplicitlyImportedIdentity("ConditionalTuple");
        }
        return c;
    }

    public ClassConstant clzAuto() {
        ClassConstant c = this.m_clzAuto;
        if (c == null) {
            this.m_clzAuto = c = (ClassConstant)this.getImplicitlyImportedIdentity("Auto");
        }
        return c;
    }

    public ClassConstant clzOp() {
        ClassConstant c = this.m_clzOp;
        if (c == null) {
            this.m_clzOp = c = (ClassConstant)this.getImplicitlyImportedIdentity("Op");
        }
        return c;
    }

    public ClassConstant clzRO() {
        ClassConstant c = this.m_clzRO;
        if (c == null) {
            this.m_clzRO = c = (ClassConstant)this.getImplicitlyImportedIdentity("RO");
        }
        return c;
    }

    public ClassConstant clzFinal() {
        ClassConstant c = this.m_clzFinal;
        if (c == null) {
            this.m_clzFinal = c = (ClassConstant)this.getImplicitlyImportedIdentity("Final");
        }
        return c;
    }

    public ClassConstant clzInject() {
        ClassConstant c = this.m_clzInject;
        if (c == null) {
            this.m_clzInject = c = (ClassConstant)this.getImplicitlyImportedIdentity("Inject");
        }
        return c;
    }

    public ClassConstant clzAbstract() {
        ClassConstant c = this.m_clzAbstract;
        if (c == null) {
            this.m_clzAbstract = c = (ClassConstant)this.getImplicitlyImportedIdentity("Abstract");
        }
        return c;
    }

    public ClassConstant clzAtomic() {
        ClassConstant c = this.m_clzAtomic;
        if (c == null) {
            this.m_clzAtomic = c = (ClassConstant)this.getImplicitlyImportedIdentity("Atomic");
        }
        return c;
    }

    public ClassConstant clzConcurrent() {
        ClassConstant c = this.m_clzConcurrent;
        if (c == null) {
            this.m_clzConcurrent = c = (ClassConstant)this.getImplicitlyImportedIdentity("Concurrent");
        }
        return c;
    }

    public ClassConstant clzSynchronized() {
        ClassConstant c = this.m_clzSynchronized;
        if (c == null) {
            this.m_clzSynchronized = c = (ClassConstant)this.getImplicitlyImportedIdentity("Synchronized");
        }
        return c;
    }

    public ClassConstant clzFuture() {
        ClassConstant c = this.m_clzFuture;
        if (c == null) {
            this.m_clzFuture = c = (ClassConstant)this.getImplicitlyImportedIdentity("Future");
        }
        return c;
    }

    public ClassConstant clzOverride() {
        ClassConstant c = this.m_clzOverride;
        if (c == null) {
            this.m_clzOverride = c = (ClassConstant)this.getImplicitlyImportedIdentity("Override");
        }
        return c;
    }

    public ClassConstant clzLazy() {
        ClassConstant c = this.m_clzLazy;
        if (c == null) {
            this.m_clzLazy = c = (ClassConstant)this.getImplicitlyImportedIdentity("Lazy");
        }
        return c;
    }

    public ClassConstant clzTest() {
        ClassConstant c = this.m_clzTest;
        if (c == null) {
            this.m_clzTest = c = (ClassConstant)this.getImplicitlyImportedIdentity("Test");
        }
        return c;
    }

    public ClassConstant clzTransient() {
        ClassConstant c = this.m_clzTransient;
        if (c == null) {
            this.m_clzTransient = c = (ClassConstant)this.getImplicitlyImportedIdentity("Transient");
        }
        return c;
    }

    public ClassConstant clzUnassigned() {
        ClassConstant c = this.m_clzUnassigned;
        if (c == null) {
            this.m_clzUnassigned = c = (ClassConstant)this.getImplicitlyImportedIdentity("Unassigned");
        }
        return c;
    }

    public ClassConstant clzVolatile() {
        ClassConstant c = this.m_clzVolatile;
        if (c == null) {
            this.m_clzVolatile = c = (ClassConstant)this.getImplicitlyImportedIdentity("Volatile");
        }
        return c;
    }

    public TypeConstant typeObject() {
        TypeConstant c = this.m_typeObject;
        if (c == null) {
            this.m_typeObject = c = this.ensureTerminalTypeConstant(this.clzObject());
        }
        return c;
    }

    public TypeConstant typeInner() {
        TypeConstant c = this.m_typeInner;
        if (c == null) {
            this.m_typeInner = c = this.ensureVirtualChildTypeConstant(this.typeOuter(), "Inner");
        }
        return c;
    }

    public TypeConstant typeOuter() {
        TypeConstant c = this.m_typeOuter;
        if (c == null) {
            this.m_typeOuter = c = this.ensureTerminalTypeConstant(this.clzOuter());
        }
        return c;
    }

    public TypeConstant typeRef() {
        TypeConstant c = this.m_typeRef;
        if (c == null) {
            this.m_typeRef = c = this.ensureTerminalTypeConstant(this.clzRef());
        }
        return c;
    }

    public TypeConstant typeRefRB() {
        TypeConstant c = this.m_typeRefRB;
        if (c == null) {
            this.m_typeRefRB = c = this.makeNativeRebase(this.clzRef());
        }
        return c;
    }

    public TypeConstant typeVar() {
        TypeConstant c = this.m_typeVar;
        if (c == null) {
            this.m_typeVar = c = this.ensureTerminalTypeConstant(this.clzVar());
        }
        return c;
    }

    public TypeConstant typeVarRB() {
        TypeConstant c = this.m_typeVarRB;
        if (c == null) {
            this.m_typeVarRB = c = this.makeNativeRebase(this.clzVar());
        }
        return c;
    }

    public TypeConstant typeStruct() {
        TypeConstant c = this.m_typeStruct;
        if (c == null) {
            this.m_typeStruct = c = this.ensureTerminalTypeConstant(this.clzStruct());
        }
        return c;
    }

    public TypeConstant typeType() {
        TypeConstant c = this.m_typeType;
        if (c == null) {
            this.m_typeType = c = this.ensureTerminalTypeConstant(this.clzType());
        }
        return c;
    }

    public TypeConstant typeClass() {
        TypeConstant c = this.m_typeClass;
        if (c == null) {
            this.m_typeClass = c = this.ensureTerminalTypeConstant(this.clzClass());
        }
        return c;
    }

    public TypeConstant typeConst() {
        TypeConstant c = this.m_typeConst;
        if (c == null) {
            this.m_typeConst = c = this.ensureTerminalTypeConstant(this.clzConst());
        }
        return c;
    }

    public TypeConstant typeConstRB() {
        TypeConstant c = this.m_typeConstRB;
        if (c == null) {
            this.m_typeConstRB = c = this.makeNativeRebase(this.clzConst());
        }
        return c;
    }

    public TypeConstant typeService() {
        TypeConstant c = this.m_typeService;
        if (c == null) {
            this.m_typeService = c = this.ensureTerminalTypeConstant(this.clzService());
        }
        return c;
    }

    public TypeConstant typeServiceRB() {
        TypeConstant c = this.m_typeServiceRB;
        if (c == null) {
            this.m_typeServiceRB = c = this.makeNativeRebase(this.clzService());
        }
        return c;
    }

    public TypeConstant typeModule() {
        TypeConstant c = this.m_typeModule;
        if (c == null) {
            this.m_typeModule = c = this.ensureTerminalTypeConstant(this.clzModule());
        }
        return c;
    }

    public TypeConstant typeModuleRB() {
        TypeConstant c = this.m_typeModuleRB;
        if (c == null) {
            this.m_typeModuleRB = c = this.makeNativeRebase(this.clzModule());
        }
        return c;
    }

    public TypeConstant typePackage() {
        TypeConstant c = this.m_typePackage;
        if (c == null) {
            this.m_typePackage = c = this.ensureTerminalTypeConstant(this.clzPackage());
        }
        return c;
    }

    public TypeConstant typePackageRB() {
        TypeConstant c = this.m_typePackageRB;
        if (c == null) {
            this.m_typePackageRB = c = this.makeNativeRebase(this.clzPackage());
        }
        return c;
    }

    public TypeConstant typeEnumRB() {
        TypeConstant c = this.m_typeEnumRB;
        if (c == null) {
            this.m_typeEnumRB = c = this.makeNativeRebase(this.clzEnum());
        }
        return c;
    }

    public TypeConstant typeEnumeration() {
        TypeConstant c = this.m_typeEnumeration;
        if (c == null) {
            this.m_typeEnumeration = c = this.ensureTerminalTypeConstant(this.clzEnumeration());
        }
        return c;
    }

    public TypeConstant typeEnumValue() {
        TypeConstant c = this.m_typeEnumValue;
        if (c == null) {
            this.m_typeEnumValue = c = this.ensureTerminalTypeConstant(this.clzEnumValue());
        }
        return c;
    }

    public TypeConstant typeException() {
        TypeConstant c = this.m_typeException;
        if (c == null) {
            this.m_typeException = c = this.ensureTerminalTypeConstant(this.clzException());
        }
        return c;
    }

    public TypeConstant typeCloseable() {
        TypeConstant c = this.m_typeCloseable;
        if (c == null) {
            this.m_typeCloseable = c = this.ensureTerminalTypeConstant(this.clzCloseable());
        }
        return c;
    }

    public TypeConstant typeProperty() {
        TypeConstant c = this.m_typeProperty;
        if (c == null) {
            this.m_typeProperty = c = this.ensureTerminalTypeConstant(this.clzProperty());
        }
        return c;
    }

    public TypeConstant typeMethod() {
        TypeConstant c = this.m_typeMethod;
        if (c == null) {
            this.m_typeMethod = c = this.ensureTerminalTypeConstant(this.clzMethod());
        }
        return c;
    }

    public TypeConstant typeParameter() {
        TypeConstant c = this.m_typeParameter;
        if (c == null) {
            this.m_typeParameter = c = this.ensureTerminalTypeConstant(this.clzParameter());
        }
        return c;
    }

    public TypeConstant typeFunction() {
        TypeConstant c = this.m_typeFunction;
        if (c == null) {
            this.m_typeFunction = c = this.ensureTerminalTypeConstant(this.clzFunction());
        }
        return c;
    }

    public TypeConstant typeBoolean() {
        TypeConstant c = this.m_typeBoolean;
        if (c == null) {
            this.m_typeBoolean = c = this.ensureTerminalTypeConstant(this.clzBoolean());
        }
        return c;
    }

    public TypeConstant typeTrue() {
        TypeConstant c = this.m_typeTrue;
        if (c == null) {
            this.m_typeTrue = c = this.ensureTerminalTypeConstant(this.clzTrue());
        }
        return c;
    }

    public TypeConstant typeFalse() {
        TypeConstant c = this.m_typeFalse;
        if (c == null) {
            this.m_typeFalse = c = this.ensureTerminalTypeConstant(this.clzFalse());
        }
        return c;
    }

    public TypeConstant typeNullable() {
        TypeConstant c = this.m_typeNullable;
        if (c == null) {
            this.m_typeNullable = c = this.ensureTerminalTypeConstant(this.clzNullable());
        }
        return c;
    }

    public TypeConstant typeOrdered() {
        TypeConstant c = this.m_typeOrdered;
        if (c == null) {
            this.m_typeOrdered = c = this.ensureTerminalTypeConstant(this.clzOrdered());
        }
        return c;
    }

    public TypeConstant typeNull() {
        TypeConstant c = this.m_typeNull;
        if (c == null) {
            this.m_typeNull = c = this.ensureTerminalTypeConstant(this.clzNull());
        }
        return c;
    }

    public TypeConstant typeChar() {
        TypeConstant c = this.m_typeChar;
        if (c == null) {
            this.m_typeChar = c = this.ensureTerminalTypeConstant(this.clzChar());
        }
        return c;
    }

    public TypeConstant typeIntLiteral() {
        TypeConstant c = this.m_typeIntLiteral;
        if (c == null) {
            this.m_typeIntLiteral = c = this.ensureTerminalTypeConstant(this.clzIntLiteral());
        }
        return c;
    }

    public TypeConstant typeFPLiteral() {
        TypeConstant c = this.m_typeFPLiteral;
        if (c == null) {
            this.m_typeFPLiteral = c = this.ensureTerminalTypeConstant(this.clzFPLiteral());
        }
        return c;
    }

    public TypeConstant typeRegEx() {
        TypeConstant c = this.m_typeRegEx;
        if (c == null) {
            this.m_typeRegEx = c = this.ensureTerminalTypeConstant(this.clzRegEx());
        }
        return c;
    }

    public TypeConstant typeString() {
        TypeConstant c = this.m_typeString;
        if (c == null) {
            this.m_typeString = c = this.ensureTerminalTypeConstant(this.clzString());
        }
        return c;
    }

    public TypeConstant typeStringable() {
        TypeConstant c = this.m_typeStringable;
        if (c == null) {
            this.m_typeStringable = c = this.ensureTerminalTypeConstant(this.clzStringable());
        }
        return c;
    }

    public TypeConstant typeStringBuffer() {
        TypeConstant c = this.m_typeStringBuffer;
        if (c == null) {
            this.m_typeStringBuffer = c = this.ensureTerminalTypeConstant(this.clzStringBuffer());
        }
        return c;
    }

    public TypeConstant typeBit() {
        TypeConstant c = this.m_typeBit;
        if (c == null) {
            this.m_typeBit = c = this.ensureTerminalTypeConstant(this.clzBit());
        }
        return c;
    }

    public TypeConstant typeNibble() {
        TypeConstant c = this.m_typeNibble;
        if (c == null) {
            this.m_typeNibble = c = this.ensureTerminalTypeConstant(this.clzNibble());
        }
        return c;
    }

    public TypeConstant typeInt8() {
        TypeConstant c = this.m_typeInt8;
        if (c == null) {
            this.m_typeInt8 = c = this.ensureTerminalTypeConstant(this.clzInt8());
        }
        return c;
    }

    public TypeConstant typeInt16() {
        TypeConstant c = this.m_typeInt16;
        if (c == null) {
            this.m_typeInt16 = c = this.ensureTerminalTypeConstant(this.clzInt16());
        }
        return c;
    }

    public TypeConstant typeInt32() {
        TypeConstant c = this.m_typeInt32;
        if (c == null) {
            this.m_typeInt32 = c = this.ensureTerminalTypeConstant(this.clzInt32());
        }
        return c;
    }

    public TypeConstant typeInt64() {
        TypeConstant c = this.m_typeInt64;
        if (c == null) {
            this.m_typeInt64 = c = this.ensureTerminalTypeConstant(this.clzInt64());
        }
        return c;
    }

    public TypeConstant typeInt128() {
        TypeConstant c = this.m_typeInt128;
        if (c == null) {
            this.m_typeInt128 = c = this.ensureTerminalTypeConstant(this.clzInt128());
        }
        return c;
    }

    public TypeConstant typeIntN() {
        TypeConstant c = this.m_typeIntN;
        if (c == null) {
            this.m_typeIntN = c = this.ensureTerminalTypeConstant(this.clzIntN());
        }
        return c;
    }

    public TypeConstant typeByte() {
        return this.typeUInt8();
    }

    public TypeConstant typeUInt8() {
        TypeConstant c = this.m_typeUInt8;
        if (c == null) {
            this.m_typeUInt8 = c = this.ensureTerminalTypeConstant(this.clzUInt8());
        }
        return c;
    }

    public TypeConstant typeUInt16() {
        TypeConstant c = this.m_typeUInt16;
        if (c == null) {
            this.m_typeUInt16 = c = this.ensureTerminalTypeConstant(this.clzUInt16());
        }
        return c;
    }

    public TypeConstant typeUInt32() {
        TypeConstant c = this.m_typeUInt32;
        if (c == null) {
            this.m_typeUInt32 = c = this.ensureTerminalTypeConstant(this.clzUInt32());
        }
        return c;
    }

    public TypeConstant typeUInt64() {
        TypeConstant c = this.m_typeUInt64;
        if (c == null) {
            this.m_typeUInt64 = c = this.ensureTerminalTypeConstant(this.clzUInt64());
        }
        return c;
    }

    public TypeConstant typeUInt128() {
        TypeConstant c = this.m_typeUInt128;
        if (c == null) {
            this.m_typeUInt128 = c = this.ensureTerminalTypeConstant(this.clzUInt128());
        }
        return c;
    }

    public TypeConstant typeUIntN() {
        TypeConstant c = this.m_typeUIntN;
        if (c == null) {
            this.m_typeUIntN = c = this.ensureTerminalTypeConstant(this.clzUIntN());
        }
        return c;
    }

    public TypeConstant typeDec64() {
        TypeConstant c = this.m_typeDec64;
        if (c == null) {
            this.m_typeDec64 = c = this.ensureTerminalTypeConstant(this.clzDec64());
        }
        return c;
    }

    public TypeConstant typeFloat32() {
        TypeConstant c = this.m_typeFloat32;
        if (c == null) {
            this.m_typeFloat32 = c = this.ensureTerminalTypeConstant(this.clzFloat32());
        }
        return c;
    }

    public TypeConstant typeFloat64() {
        TypeConstant c = this.m_typeFloat64;
        if (c == null) {
            this.m_typeFloat64 = c = this.ensureTerminalTypeConstant(this.clzFloat64());
        }
        return c;
    }

    public TypeConstant typeIndexed() {
        TypeConstant c = this.m_typeIndexed;
        if (c == null) {
            this.m_typeIndexed = c = this.ensureTerminalTypeConstant(this.clzIndexed());
        }
        return c;
    }

    public TypeConstant typeArray() {
        TypeConstant c = this.m_typeArray;
        if (c == null) {
            this.m_typeArray = c = this.ensureTerminalTypeConstant(this.clzArray());
        }
        return c;
    }

    public TypeConstant typeMatrix() {
        TypeConstant c = this.m_typeMatrix;
        if (c == null) {
            this.m_typeMatrix = c = this.ensureTerminalTypeConstant(this.clzMatrix());
        }
        return c;
    }

    public TypeConstant typeCollection() {
        TypeConstant c = this.m_typeCollection;
        if (c == null) {
            this.m_typeCollection = c = this.ensureTerminalTypeConstant(this.clzCollection());
        }
        return c;
    }

    public TypeConstant typeSet() {
        TypeConstant c = this.m_typeSet;
        if (c == null) {
            this.m_typeSet = c = this.ensureTerminalTypeConstant(this.clzSet());
        }
        return c;
    }

    public TypeConstant typeList() {
        TypeConstant c = this.m_typeList;
        if (c == null) {
            this.m_typeList = c = this.ensureTerminalTypeConstant(this.clzList());
        }
        return c;
    }

    public TypeConstant typeMap() {
        TypeConstant c = this.m_typeMap;
        if (c == null) {
            this.m_typeMap = c = this.ensureTerminalTypeConstant(this.clzMap());
        }
        return c;
    }

    public TypeConstant typeSliceable() {
        TypeConstant c = this.m_typeSliceable;
        if (c == null) {
            this.m_typeSliceable = c = this.ensureTerminalTypeConstant(this.clzSliceable());
        }
        return c;
    }

    public TypeConstant typeOrderable() {
        TypeConstant c = this.m_typeOrderable;
        if (c == null) {
            this.m_typeOrderable = c = this.ensureTerminalTypeConstant(this.clzOrderable());
        }
        return c;
    }

    public TypeConstant typeSequential() {
        TypeConstant c = this.m_typeSequential;
        if (c == null) {
            this.m_typeSequential = c = this.ensureTerminalTypeConstant(this.clzSequential());
        }
        return c;
    }

    public TypeConstant typeNumber() {
        TypeConstant c = this.m_typeNumber;
        if (c == null) {
            this.m_typeNumber = c = this.ensureTerminalTypeConstant(this.clzNumber());
        }
        return c;
    }

    public TypeConstant typeRange() {
        TypeConstant c = this.m_typeRange;
        if (c == null) {
            this.m_typeRange = c = this.ensureTerminalTypeConstant(this.clzRange());
        }
        return c;
    }

    public TypeConstant typeInterval() {
        TypeConstant c = this.m_typeInterval;
        if (c == null) {
            this.m_typeInterval = c = this.ensureTerminalTypeConstant(this.clzInterval());
        }
        return c;
    }

    public TypeConstant typeFreezable() {
        TypeConstant c = this.m_typeFreezable;
        if (c == null) {
            this.m_typeFreezable = c = this.ensureTerminalTypeConstant(this.clzFreezable());
        }
        return c;
    }

    public TypeConstant typeAutoFreezable() {
        TypeConstant c = this.m_typeAutoFreezable;
        if (c == null) {
            this.m_typeAutoFreezable = c = this.ensureTerminalTypeConstant(this.clzAutoFreezable());
        }
        return c;
    }

    public TypeConstant typeIterable() {
        TypeConstant c = this.m_typeIterable;
        if (c == null) {
            this.m_typeIterable = c = this.ensureTerminalTypeConstant(this.clzIterable());
        }
        return c;
    }

    public TypeConstant typeIterator() {
        TypeConstant c = this.m_typeIterator;
        if (c == null) {
            this.m_typeIterator = c = this.ensureTerminalTypeConstant(this.clzIterator());
        }
        return c;
    }

    public TypeConstant typeTuple() {
        TypeConstant c = this.m_typeTuple;
        if (c == null) {
            this.m_typeTuple = c = this.ensureTerminalTypeConstant(this.clzTuple());
        }
        return c;
    }

    public TypeConstant typeTuple0() {
        TypeConstant c = this.m_typeTuple0;
        if (c == null) {
            this.m_typeTuple0 = c = this.ensureParameterizedTypeConstant(this.typeTuple(), new TypeConstant[0]);
        }
        return c;
    }

    public TypeConstant typeCondTuple() {
        TypeConstant c = this.m_typeCondTuple;
        if (c == null) {
            this.m_typeCondTuple = c = this.ensureTerminalTypeConstant(this.clzCondTuple());
        }
        return c;
    }

    public TypeConstant typeDate() {
        TypeConstant c = this.m_typeDate;
        if (c == null) {
            this.m_typeDate = c = this.ensureTerminalTypeConstant(this.clzDate());
        }
        return c;
    }

    public TypeConstant typeTimeOfDay() {
        TypeConstant c = this.m_typeTimeOfDay;
        if (c == null) {
            this.m_typeTimeOfDay = c = this.ensureTerminalTypeConstant(this.clzTimeOfDay());
        }
        return c;
    }

    public TypeConstant typeTime() {
        TypeConstant c = this.m_typeTime;
        if (c == null) {
            this.m_typeTime = c = this.ensureTerminalTypeConstant(this.clzTime());
        }
        return c;
    }

    public TypeConstant typeTimeZone() {
        TypeConstant c = this.m_typeTimeZone;
        if (c == null) {
            this.m_typeTimeZone = c = this.ensureTerminalTypeConstant(this.clzTimeZone());
        }
        return c;
    }

    public TypeConstant typeDuration() {
        TypeConstant c = this.m_typeDuration;
        if (c == null) {
            this.m_typeDuration = c = this.ensureTerminalTypeConstant(this.clzDuration());
        }
        return c;
    }

    public TypeConstant typeVersion() {
        TypeConstant c = this.m_typeVersion;
        if (c == null) {
            this.m_typeVersion = c = this.ensureTerminalTypeConstant(this.clzVersion());
        }
        return c;
    }

    public TypeConstant typePath() {
        TypeConstant c = this.m_typePath;
        if (c == null) {
            this.m_typePath = c = this.ensureTerminalTypeConstant(this.clzPath());
        }
        return c;
    }

    public TypeConstant typeFileStore() {
        TypeConstant c = this.m_typeFileStore;
        if (c == null) {
            this.m_typeFileStore = c = this.ensureTerminalTypeConstant(this.clzFileStore());
        }
        return c;
    }

    public TypeConstant typeDirectory() {
        TypeConstant c = this.m_typeDirectory;
        if (c == null) {
            this.m_typeDirectory = c = this.ensureTerminalTypeConstant(this.clzDirectory());
        }
        return c;
    }

    public TypeConstant typeFile() {
        TypeConstant c = this.m_typeFile;
        if (c == null) {
            this.m_typeFile = c = this.ensureTerminalTypeConstant(this.clzFile());
        }
        return c;
    }

    public TypeConstant typeFileNode() {
        TypeConstant c = this.m_typeFileNode;
        if (c == null) {
            this.m_typeFileNode = c = this.ensureTerminalTypeConstant(this.clzFileNode());
        }
        return c;
    }

    public TypeConstant typeBitArray() {
        TypeConstant c = this.m_typeBitArray;
        if (c == null) {
            this.m_typeBitArray = c = this.ensureClassTypeConstant(this.clzArray(), null, this.typeBit());
        }
        return c;
    }

    public TypeConstant typeByteArray() {
        TypeConstant c = this.m_typeByteArray;
        if (c == null) {
            this.m_typeByteArray = c = this.ensureClassTypeConstant(this.clzArray(), null, this.typeByte());
        }
        return c;
    }

    public TypeConstant typeBinary() {
        TypeConstant c = this.m_typeBinary;
        if (c == null) {
            this.m_typeBinary = c = this.ensureImmutableTypeConstant(this.typeByteArray());
        }
        return c;
    }

    public TypeConstant typeException\u0967() {
        TypeConstant c = this.m_typeException\u0967;
        if (c == null) {
            this.m_typeException\u0967 = c = this.ensureNullableTypeConstant(this.typeException());
        }
        return c;
    }

    public TypeConstant typeString\u0967() {
        TypeConstant c = this.m_typeString\u0967;
        if (c == null) {
            this.m_typeString\u0967 = c = this.ensureNullableTypeConstant(this.typeString());
        }
        return c;
    }

    public IntConstant val0() {
        IntConstant c = this.m_val0;
        if (c == null) {
            this.m_val0 = c = this.ensureIntConstant(0L);
        }
        return c;
    }

    public SingletonConstant valFalse() {
        SingletonConstant c = this.m_valFalse;
        if (c == null) {
            this.m_valFalse = c = this.ensureSingletonConstConstant(this.clzFalse());
        }
        return c;
    }

    public SingletonConstant valTrue() {
        SingletonConstant c = this.m_valTrue;
        if (c == null) {
            this.m_valTrue = c = this.ensureSingletonConstConstant(this.clzTrue());
        }
        return c;
    }

    public SingletonConstant valLesser() {
        SingletonConstant c = this.m_valLesser;
        if (c == null) {
            this.m_valLesser = c = this.ensureSingletonConstConstant(this.clzLesser());
        }
        return c;
    }

    public SingletonConstant valEqual() {
        SingletonConstant c = this.m_valEqual;
        if (c == null) {
            this.m_valEqual = c = this.ensureSingletonConstConstant(this.clzEqual());
        }
        return c;
    }

    public SingletonConstant valGreater() {
        SingletonConstant c = this.m_valGreater;
        if (c == null) {
            this.m_valGreater = c = this.ensureSingletonConstConstant(this.clzGreater());
        }
        return c;
    }

    public RegisterConstant valDefault() {
        RegisterConstant c = this.m_valDefault;
        if (c == null) {
            this.m_valDefault = c = new RegisterConstant(this, Register.DEFAULT);
        }
        return c;
    }

    public SignatureConstant sigToString() {
        SignatureConstant c = this.m_sigToString;
        if (c == null) {
            this.m_sigToString = c = this.getSignature("Object", "toString", 0);
        }
        return c;
    }

    public SignatureConstant sigEquals() {
        SignatureConstant c = this.m_sigEquals;
        if (c == null) {
            this.m_sigEquals = c = this.getSignature("Object", "equals", 3);
        }
        return c;
    }

    public SignatureConstant sigCompare() {
        SignatureConstant c = this.m_sigCompare;
        if (c == null) {
            this.m_sigCompare = c = this.getSignature("Orderable", "compare", 3);
        }
        return c;
    }

    public SignatureConstant sigClose() {
        SignatureConstant c = this.m_sigClose;
        if (c == null) {
            this.m_sigClose = c = this.getSignature("Closeable", "close", 1);
        }
        return c;
    }

    public SignatureConstant sigValidator() {
        SignatureConstant c = this.m_sigValidator;
        if (c == null) {
            this.m_sigValidator = c = this.ensureSignatureConstant("assert", NO_TYPES, NO_TYPES);
        }
        return c;
    }

    protected ClassConstant clzParameter() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Parameter");
    }

    protected ClassConstant clzBoolean() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Boolean");
    }

    protected ClassConstant clzFalse() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("False");
    }

    protected ClassConstant clzTrue() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("True");
    }

    protected ClassConstant clzOrdered() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Ordered");
    }

    protected ClassConstant clzLesser() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Lesser");
    }

    protected ClassConstant clzEqual() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Equal");
    }

    protected ClassConstant clzGreater() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Greater");
    }

    protected ClassConstant clzNull() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Null");
    }

    protected ClassConstant clzChar() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Char");
    }

    protected ClassConstant clzRegEx() {
        return this.ensureEcstasyClassConstant("text.RegEx");
    }

    protected ClassConstant clzString() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("String");
    }

    protected ClassConstant clzStringable() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Stringable");
    }

    protected ClassConstant clzStringBuffer() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("StringBuffer");
    }

    protected ClassConstant clzIntLiteral() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("IntLiteral");
    }

    protected ClassConstant clzFPLiteral() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("FPLiteral");
    }

    protected ClassConstant clzBit() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Bit");
    }

    protected ClassConstant clzNibble() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Nibble");
    }

    protected ClassConstant clzInt8() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Int8");
    }

    protected ClassConstant clzInt16() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Int16");
    }

    protected ClassConstant clzInt32() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Int32");
    }

    protected ClassConstant clzInt64() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Int64");
    }

    protected ClassConstant clzInt128() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Int128");
    }

    protected ClassConstant clzIntN() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("IntN");
    }

    protected ClassConstant clzUInt8() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("UInt8");
    }

    protected ClassConstant clzUInt16() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("UInt16");
    }

    protected ClassConstant clzUInt32() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("UInt32");
    }

    protected ClassConstant clzUInt64() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("UInt64");
    }

    protected ClassConstant clzUInt128() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("UInt128");
    }

    protected ClassConstant clzUIntN() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("UIntN");
    }

    protected ClassConstant clzDec64() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Dec64");
    }

    protected ClassConstant clzFloat32() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Float32");
    }

    protected ClassConstant clzFloat64() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Float64");
    }

    protected ClassConstant clzIndexed() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("UniformIndexed");
    }

    protected ClassConstant clzInterval() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Interval");
    }

    protected ClassConstant clzIterable() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Iterable");
    }

    protected ClassConstant clzIterator() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Iterator");
    }

    protected ClassConstant clzNumber() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Number");
    }

    protected ClassConstant clzRange() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Range");
    }

    protected ClassConstant clzSequential() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Sequential");
    }

    protected ClassConstant clzFreezable() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Freezable");
    }

    protected ClassConstant clzAutoFreezable() {
        return this.ensureEcstasyClassConstant("annotations.AutoFreezable");
    }

    protected ClassConstant clzDate() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Date");
    }

    protected ClassConstant clzTime() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Time");
    }

    protected ClassConstant clzDuration() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Duration");
    }

    protected ClassConstant clzTimeOfDay() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("TimeOfDay");
    }

    protected ClassConstant clzTimeZone() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("TimeZone");
    }

    protected ClassConstant clzPath() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Path");
    }

    protected ClassConstant clzVersion() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Version");
    }

    protected ClassConstant clzDirectory() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("Directory");
    }

    protected ClassConstant clzFile() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("File");
    }

    protected ClassConstant clzFileNode() {
        return this.ensureEcstasyClassConstant("fs.FileNode");
    }

    protected ClassConstant clzFileStore() {
        return (ClassConstant)this.getImplicitlyImportedIdentity("FileStore");
    }

    public TypeInfo infoPlaceholder() {
        TypeInfo info = this.m_infoPlaceholder;
        if (info == null) {
            this.m_infoPlaceholder = info = new TypeInfo(this, this.typeObject(), 0, null, 0, true, Collections.emptyMap(), Annotation.NO_ANNOTATIONS, Annotation.NO_ANNOTATIONS, this.typeObject(), null, this.typeObject(), Collections.emptyList(), new ListMap(), new ListMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), ListMap.EMPTY, null, TypeInfo.Progress.Building){

                @Override
                public String toString() {
                    return "Placeholder";
                }
            };
        }
        return info;
    }

    public SingletonConstant valOf(boolean f) {
        return f ? this.valTrue() : this.valFalse();
    }

    public SingletonConstant valOrd(int n) {
        if (n < 0) {
            return this.valLesser();
        }
        if (n == 0) {
            return this.valEqual();
        }
        return this.valGreater();
    }

    private TypeConstant makeNativeRebase(ClassConstant constClass) {
        return new NativeRebaseConstant(constClass).getType();
    }

    private SignatureConstant getSignature(String sClass, String sMethod, int cParams) {
        return (SignatureConstant)this.register(((ClassStructure)this.getImplicitlyImportedComponent(sClass)).findMethod(sMethod, cParams, new TypeConstant[0]).getIdentityConstant().getSignature());
    }

    void replaceModule(ModuleConstant idOld, ModuleConstant idNew) {
        for (Constant constant : this.m_listConst) {
            IdentityConstant id;
            if (!(constant instanceof IdentityConstant) || (id = (IdentityConstant)constant).getParentConstant() != idOld) continue;
            int nPos = id.getPosition();
            id = id.replaceParentConstant(idNew);
            id.setPosition(nPos);
            this.m_listConst.set(nPos, id);
        }
    }

    @Override
    public ConstantPool getConstantPool() {
        return this;
    }

    @Override
    public Iterator<? extends XvmStructure> getContained() {
        return new Iterator<XvmStructure>(){
            private final ArrayList<Constant> listConst;
            private int iNext;
            {
                this.listConst = ConstantPool.this.m_listConst;
                this.iNext = 0;
            }

            @Override
            public boolean hasNext() {
                return this.iNext < this.listConst.size();
            }

            @Override
            public XvmStructure next() {
                if (this.iNext >= this.listConst.size()) {
                    throw new NoSuchElementException();
                }
                return this.listConst.get(this.iNext++);
            }
        };
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    protected void markModified() {
    }

    @Override
    protected void resetModified() {
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public void purgeCondition(ConditionalConstant condition) {
    }

    @Override
    public boolean isPresent(LinkerContext ctx) {
        return true;
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public void resolve(LinkerContext ctx) {
    }

    @Override
    protected void disassemble(DataInput in) throws IOException {
        this.m_listConst.clear();
        this.m_mapConstants.clear();
        this.m_mapLocators.clear();
        int cConst = Handy.readMagnitude(in);
        this.m_listConst.ensureCapacity(cConst);
        for (int i = 0; i < cConst; ++i) {
            int nFmt = in.readUnsignedByte();
            Constant.Format format = Constant.Format.valueOf(nFmt);
            Constant constant = switch (format) {
                case Constant.Format.IntLiteral, Constant.Format.FPLiteral, Constant.Format.Date, Constant.Format.TimeOfDay, Constant.Format.Time, Constant.Format.Duration, Constant.Format.Path -> new LiteralConstant(this, format, in);
                case Constant.Format.Bit, Constant.Format.Int8, Constant.Format.Nibble, Constant.Format.UInt8 -> new ByteConstant(this, format, in);
                case Constant.Format.Int16, Constant.Format.Int32, Constant.Format.Int64, Constant.Format.Int128, Constant.Format.UInt16, Constant.Format.UInt32, Constant.Format.UInt64, Constant.Format.UInt128, Constant.Format.IntN, Constant.Format.UIntN -> new IntConstant(this, format, in);
                case Constant.Format.Dec32, Constant.Format.Dec64, Constant.Format.Dec128 -> new DecimalConstant(this, format, in);
                case Constant.Format.DecN, Constant.Format.FloatN -> new FPNConstant(this, format, in);
                case Constant.Format.Float8e4 -> new Float8e4Constant(this, format, in);
                case Constant.Format.Float8e5 -> new Float8e5Constant(this, format, in);
                case Constant.Format.BFloat16 -> new BFloat16Constant(this, format, in);
                case Constant.Format.Float16 -> new Float16Constant(this, format, in);
                case Constant.Format.Float32 -> new Float32Constant(this, format, in);
                case Constant.Format.Float64 -> new Float64Constant(this, format, in);
                case Constant.Format.Float128 -> new Float128Constant(this, format, in);
                case Constant.Format.Char -> new CharConstant(this, format, in);
                case Constant.Format.RegEx -> new RegExConstant(this, format, in);
                case Constant.Format.String -> new StringConstant(this, format, in);
                case Constant.Format.Version -> new VersionConstant(this, format, in);
                case Constant.Format.SingletonConst, Constant.Format.SingletonService -> new SingletonConstant(this, format, in);
                case Constant.Format.EnumValueConst -> new EnumValueConstant(this, format, in);
                case Constant.Format.Array, Constant.Format.Tuple, Constant.Format.Set -> new ArrayConstant(this, format, in);
                case Constant.Format.UInt8Array -> new UInt8ArrayConstant(this, format, in);
                case Constant.Format.MapEntry, Constant.Format.Map -> new MapConstant(this, format, in);
                case Constant.Format.Range, Constant.Format.RangeInclusive, Constant.Format.RangeExclusive -> new RangeConstant(this, format, in);
                case Constant.Format.Any -> new MatchAnyConstant(this, format, in);
                case Constant.Format.FileStore -> new FileStoreConstant(this, format, in);
                case Constant.Format.FSDir, Constant.Format.FSFile, Constant.Format.FSLink -> new FSNodeConstant(this, format, in);
                case Constant.Format.Module -> new ModuleConstant(this, format, in);
                case Constant.Format.Package -> new PackageConstant(this, format, in);
                case Constant.Format.Class -> new ClassConstant(this, format, in);
                case Constant.Format.Typedef -> new TypedefConstant(this, format, in);
                case Constant.Format.Property -> new PropertyConstant(this, format, in);
                case Constant.Format.MultiMethod -> new MultiMethodConstant(this, format, in);
                case Constant.Format.Method -> new MethodConstant(this, format, in);
                case Constant.Format.Annotation -> new Annotation(this, in);
                case Constant.Format.Register -> new RegisterConstant(this, in);
                case Constant.Format.BindTarget -> new MethodBindingConstant(this, in);
                case Constant.Format.UnresolvedName -> throw new IOException("UnresolvedName not supported persistently");
                case Constant.Format.ThisClass -> new ThisClassConstant(this, format, in);
                case Constant.Format.ParentClass -> new ParentClassConstant(this, format, in);
                case Constant.Format.ChildClass -> new ChildClassConstant(this, format, in);
                case Constant.Format.TypeParameter -> new TypeParameterConstant(this, format, in);
                case Constant.Format.FormalTypeChild -> new FormalTypeChildConstant(this, format, in);
                case Constant.Format.DynamicFormal -> new DynamicFormalConstant(this, format, in);
                case Constant.Format.Signature -> new SignatureConstant(this, format, in);
                case Constant.Format.DecoratedClass -> new DecoratedClassConstant(this, format, in);
                case Constant.Format.NativeClass -> throw new IllegalStateException();
                case Constant.Format.IsConst, Constant.Format.IsEnum, Constant.Format.IsModule, Constant.Format.IsPackage, Constant.Format.IsClass -> new KeywordConstant(this, format, in);
                case Constant.Format.UnresolvedType -> throw new IOException("UnresolvedType not supported persistently");
                case Constant.Format.TerminalType -> new TerminalTypeConstant(this, format, in);
                case Constant.Format.ImmutableType -> new ImmutableTypeConstant(this, format, in);
                case Constant.Format.ServiceType -> new ServiceTypeConstant(this, format, in);
                case Constant.Format.AccessType -> new AccessTypeConstant(this, format, in);
                case Constant.Format.AnnotatedType -> new AnnotatedTypeConstant(this, format, in);
                case Constant.Format.ParameterizedType -> new ParameterizedTypeConstant(this, format, in);
                case Constant.Format.TurtleType -> new TypeSequenceTypeConstant(this);
                case Constant.Format.VirtualChildType -> new VirtualChildTypeConstant(this, format, in);
                case Constant.Format.InnerChildType -> new InnerChildTypeConstant(this, format, in);
                case Constant.Format.AnonymousClassType -> new AnonymousClassTypeConstant(this, format, in);
                case Constant.Format.PropertyClassType -> new PropertyClassTypeConstant(this, format, in);
                case Constant.Format.IntersectionType -> new IntersectionTypeConstant(this, format, in);
                case Constant.Format.UnionType -> new UnionTypeConstant(this, format, in);
                case Constant.Format.DifferenceType -> new DifferenceTypeConstant(this, format, in);
                case Constant.Format.RecursiveType -> new RecursiveTypeConstant(this, format, in);
                case Constant.Format.ConditionNot -> new NotCondition(this, format, in);
                case Constant.Format.ConditionAll -> new AllCondition(this, format, in);
                case Constant.Format.ConditionAny -> new AnyCondition(this, format, in);
                case Constant.Format.ConditionNamed -> new NamedCondition(this, format, in);
                case Constant.Format.ConditionPresent -> new PresentCondition(this, format, in);
                case Constant.Format.ConditionVersionMatches -> new VersionMatchesCondition(this, format, in);
                case Constant.Format.ConditionVersioned -> new VersionedCondition(this, format, in);
                default -> throw new IOException("Unsupported constant format: " + nFmt);
            };
            constant.setPosition(i);
            this.m_listConst.add(constant);
        }
        for (Constant constant : this.m_listConst) {
            constant.resolveConstants();
        }
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        Handy.writePackedLong(out, this.m_listConst.size());
        for (Constant constant : this.m_listConst) {
            constant.assemble(out);
        }
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("module=").append(this.getFileStructure().getModuleId().getName()).append(", size=").append(this.m_listConst.size());
        if (this.m_fRecurseReg) {
            sb.append(", recursive registration on");
        }
        return sb.toString();
    }

    @Override
    protected void dump(PrintWriter out, String sIndent) {
        this.dumpStructureCollection(out, sIndent, "Constants", this.m_listConst);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConstantPool)) {
            return false;
        }
        ConstantPool that = (ConstantPool)obj;
        return this.m_listConst.equals(that.m_listConst);
    }

    protected void preRegisterAll() {
        assert (!this.m_fRecurseReg);
        this.m_fRecurseReg = true;
        this.m_listConst.forEach(Constant::resetRefs);
    }

    protected void postRegisterAll(boolean fOptimize) {
        assert (this.m_fRecurseReg);
        this.m_fRecurseReg = false;
        if (fOptimize) {
            this.optimize();
        }
    }

    private Map<Constant, Constant> ensureConstantLookup(Constant.Format format) {
        Map<Constant, Constant> map = this.m_mapConstants.get((Object)format);
        return map == null ? this.ensureConstantLookupComplex().get((Object)format) : map;
    }

    private synchronized EnumMap<Constant.Format, Map<Constant, Constant>> ensureConstantLookupComplex() {
        EnumMap<Constant.Format, Map<Constant, Constant>> mapConstants = this.m_mapConstants;
        if (mapConstants.isEmpty()) {
            EnumMap<Constant.Format, Map<Constant, Constant>> mapConstNew = new EnumMap<Constant.Format, Map<Constant, Constant>>(mapConstants);
            for (Constant.Format format : Constant.Format.values()) {
                mapConstNew.put(format, new ConcurrentHashMap());
            }
            for (Constant constant : this.m_listConst) {
                Constant constantOld = mapConstNew.get((Object)constant.getFormat()).put(constant, constant);
                if (constantOld != null && constantOld != constant) {
                    throw new IllegalStateException("constant collision: old=" + String.valueOf(constantOld) + ", new=" + String.valueOf(constant));
                }
                Object oLocator = constant.getLocator();
                if (oLocator == null || (constantOld = this.ensureLocatorLookup(constant.getFormat()).put(oLocator, constant)) == null || constantOld == constant) continue;
                throw new IllegalStateException("locator collision: old=" + String.valueOf(constantOld) + ", new=" + String.valueOf(constant));
            }
            this.m_mapConstants = mapConstants = mapConstNew;
        }
        return mapConstants;
    }

    private Map<Object, Constant> ensureLocatorLookup(Constant.Format format) {
        Map<Object, Constant> map = this.m_mapLocators.get((Object)format);
        return map == null ? this.ensureLocatorLookupComplex(format) : map;
    }

    private synchronized Map<Object, Constant> ensureLocatorLookupComplex(Constant.Format format) {
        Map<Object, Constant> map = this.m_mapLocators.get((Object)format);
        if (map == null) {
            EnumMap<Constant.Format, Map<Object, Constant>> mapLocNew = new EnumMap<Constant.Format, Map<Object, Constant>>(this.m_mapLocators);
            map = new ConcurrentHashMap<Object, Constant>();
            mapLocNew.put(format, map);
            this.m_mapLocators = mapLocNew;
        }
        return map;
    }

    void addDeferredTypeInfo(TypeConstant type) {
        assert (type != null);
        List list = this.f_tlolistDeferred.computeIfAbsent(ArrayList::new);
        if (!list.contains(type)) {
            list.add(type);
        }
    }

    boolean hasDeferredTypeInfo() {
        return this.f_tlolistDeferred.get() != null;
    }

    List<TypeConstant> takeDeferredTypeInfo() {
        List<TypeConstant> list = this.f_tlolistDeferred.get();
        if (list == null) {
            list = Collections.emptyList();
        } else {
            this.f_tlolistDeferred.remove();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateTypeInfos(IdentityConstant id) {
        assert (id.isClass());
        List<IdentityConstant> list = this.f_listInvalidated;
        synchronized (list) {
            this.f_listInvalidated.add((IdentityConstant)this.register(id));
            this.m_cInvalidated = this.f_listInvalidated.size();
        }
    }

    public int getInvalidationCount() {
        return this.m_cInvalidated;
    }

    public Set<IdentityConstant> invalidationsSince(int cOld) {
        int cNew = this.getInvalidationCount();
        if (cOld == cNew) {
            return Collections.emptySet();
        }
        assert (cNew > cOld);
        HashSet<IdentityConstant> set = new HashSet<IdentityConstant>();
        for (int i = cOld; i < cNew; ++i) {
            set.add(this.f_listInvalidated.get(i));
        }
        return set;
    }

    public TypeConstant.Relation checkTupleCompatibility(TypeConstant tupleLeft, TypeConstant tupleRight) {
        IdentityConstant idLeft = tupleLeft.getSingleUnderlyingClass(true);
        IdentityConstant idRight = tupleRight.getSingleUnderlyingClass(true);
        if (idLeft.getFormat() == Constant.Format.NativeClass) {
            idLeft = ((NativeRebaseConstant)idLeft).getClassConstant();
        }
        if (idRight.getFormat() == Constant.Format.NativeClass) {
            idRight = ((NativeRebaseConstant)idRight).getClassConstant();
        }
        ClassStructure clzTuple = (ClassStructure)idLeft.getComponent();
        if (idLeft.equals(idRight)) {
            return clzTuple.calculateAssignability(this, tupleLeft.getParamTypes(), Constants.Access.PUBLIC, tupleRight.getParamTypes());
        }
        if (idLeft.equals(this.clzCondTuple())) {
            return TypeConstant.Relation.INCOMPATIBLE;
        }
        if (idRight.equals(this.clzCondTuple())) {
            List<TypeConstant> listRight = tupleRight.getParamsCount() > 0 ? tupleRight.getParamTypes() : Collections.singletonList(this.typeBoolean());
            return clzTuple.calculateAssignability(this, tupleLeft.getParamTypes(), Constants.Access.PUBLIC, listRight);
        }
        System.err.println("Unsupported tuple type: " + idLeft.getValueString());
        return TypeConstant.Relation.INCOMPATIBLE;
    }

    public TypeConstant.Relation checkFunctionCompatibility(TypeConstant typeLeft, TypeConstant typeRight) {
        ClassStructure clzRight;
        IdentityConstant idRight = typeRight.getSingleUnderlyingClass(true);
        if (!idRight.equals(this.clzFunction()) && (clzRight = (ClassStructure)idRight.getComponent()).calculateRelation(this, this.typeFunction(), idRight.getType()) != TypeConstant.Relation.IS_A) {
            return TypeConstant.Relation.INCOMPATIBLE;
        }
        return this.checkFunctionOrMethodCompatibility(typeLeft, typeRight, false);
    }

    public TypeConstant.Relation checkMethodCompatibility(TypeConstant typeLeft, TypeConstant typeRight) {
        IdentityConstant idRight = typeRight.getSingleUnderlyingClass(true);
        return idRight.equals(this.clzMethod()) ? this.checkFunctionOrMethodCompatibility(typeLeft, typeRight, true) : null;
    }

    private TypeConstant.Relation checkFunctionOrMethodCompatibility(TypeConstant typeLeft, TypeConstant typeRight, boolean fMethod) {
        TypeConstant typeR;
        TypeConstant typeL;
        int i;
        int cMaxParams;
        int cMinParams;
        int ixReturns;
        int ixParams;
        if (typeLeft.isSingleDefiningConstant() && typeRight.isSingleDefiningConstant()) {
            Constant constIdLeft = typeLeft.getDefiningConstant();
            Constant constIdRight = typeRight.getDefiningConstant();
            if (constIdLeft.getFormat() == Constant.Format.ThisClass && constIdRight.getFormat() == Constant.Format.ThisClass) {
                typeRight = typeRight.removeAutoNarrowing();
                typeLeft = typeLeft.removeAutoNarrowing();
                if (typeRight.equals(this.typeObject())) {
                    return TypeConstant.Relation.IS_A;
                }
            }
        }
        if (fMethod) {
            TypeConstant typeTargetL = typeLeft.getParamType(0);
            TypeConstant typeTargetR = typeRight.getParamType(0);
            if (!typeTargetR.isA(typeTargetL)) {
                return TypeConstant.Relation.INCOMPATIBLE;
            }
            ixParams = 1;
            ixReturns = 2;
            cMinParams = 1;
            cMaxParams = 3;
        } else {
            ixParams = 0;
            ixReturns = 1;
            cMinParams = 0;
            cMaxParams = 2;
        }
        int cL = typeLeft.getParamsCount();
        int cR = typeRight.getParamsCount();
        if (cL <= cMinParams) {
            return TypeConstant.Relation.IS_A;
        }
        if (cL != cMaxParams || cR != cMaxParams) {
            if (cL == cMaxParams && cR == cMinParams) {
                TypeConstant typeLP = typeLeft.getParamType(ixParams);
                TypeConstant typeLR = typeLeft.getParamType(ixReturns);
                if (typeLP.isTuple() && typeLR.isTuple() && typeLP.getParamsCount() == 0 && typeLR.getParamsCount() == 0) {
                    return TypeConstant.Relation.IS_A;
                }
            }
            return TypeConstant.Relation.INCOMPATIBLE;
        }
        TypeConstant typeLP = typeLeft.getParamType(ixParams);
        TypeConstant typeLR = typeLeft.getParamType(ixReturns);
        TypeConstant typeRP = typeRight.getParamType(ixParams);
        TypeConstant typeRR = typeRight.getParamType(ixReturns);
        if (!(typeLP.isTuple() && typeLR.isTuple() && typeRP.isTuple() && typeRR.isTuple())) {
            return TypeConstant.Relation.INCOMPATIBLE;
        }
        int cLP = typeLP.getParamsCount();
        int cLR = typeLR.getParamsCount();
        int cRP = typeRP.getParamsCount();
        int cRR = typeRR.getParamsCount();
        if (cLP != cRP && cLP > 0) {
            return TypeConstant.Relation.INCOMPATIBLE;
        }
        if (cLR > cRR) {
            return cRR == 0 && cLR == 1 && typeLR.getParamType(0).equals(ConstantPool.getCurrentPool().typeTuple0()) ? TypeConstant.Relation.IS_A : TypeConstant.Relation.INCOMPATIBLE;
        }
        for (i = 0; i < cLP; ++i) {
            typeL = typeLP.getParamType(i);
            if (typeL.isA(typeR = typeRP.getParamType(i))) continue;
            return TypeConstant.Relation.INCOMPATIBLE;
        }
        for (i = 0; i < cLR; ++i) {
            typeL = typeLR.getParamType(i);
            typeR = typeRR.getParamType(i);
            if (typeR.isA(typeL)) continue;
            return TypeConstant.Relation.INCOMPATIBLE;
        }
        return TypeConstant.Relation.IS_A;
    }

    public TypeConstant buildFunctionType(TypeConstant[] atypeParams, TypeConstant ... atypeReturns) {
        return this.ensureParameterizedTypeConstant(this.typeFunction(), this.ensureTupleType(atypeParams), this.ensureTupleType(atypeReturns));
    }

    public TypeConstant buildConditionalFunctionType(TypeConstant[] atypeParams, TypeConstant ... atypeReturns) {
        assert (atypeReturns.length >= 1 && atypeReturns[0].equals(this.typeBoolean()));
        return this.ensureParameterizedTypeConstant(this.typeFunction(), this.ensureTupleType(atypeParams), this.ensureParameterizedTypeConstant(this.typeCondTuple(), atypeReturns));
    }

    public TypeConstant[] extractFunctionParams(TypeConstant typeFunction) {
        if (typeFunction != null) {
            if (typeFunction.isA(this.typeFunction())) {
                TypeConstant typeParams;
                if (typeFunction.getParamsCount() > 0 && (typeParams = typeFunction.getParamType(0)).isTuple()) {
                    return typeParams.getParamTypesArray();
                }
                return TypeConstant.NO_TYPES;
            }
            if (typeFunction.isA(this.typeMethod())) {
                TypeConstant typeParams;
                if (typeFunction.getParamsCount() > 1 && (typeParams = typeFunction.getParamType(1)).isTuple()) {
                    return typeParams.getParamTypesArray();
                }
                return TypeConstant.NO_TYPES;
            }
            if (typeFunction instanceof RelationalTypeConstant) {
                RelationalTypeConstant typeRel = (RelationalTypeConstant)typeFunction;
                TypeConstant[] atype1 = this.extractFunctionParams(typeRel.getUnderlyingType());
                TypeConstant[] atype2 = this.extractFunctionParams(typeRel.getUnderlyingType2());
                return atype2 == null ? atype1 : (atype1 == null ? atype2 : null);
            }
        }
        return null;
    }

    public TypeConstant[] extractFunctionReturns(TypeConstant typeFunction) {
        if (typeFunction != null) {
            if (typeFunction.isA(this.typeFunction())) {
                TypeConstant typeParams;
                if (typeFunction.getParamsCount() > 1 && (typeParams = typeFunction.getParamType(1)).isTuple()) {
                    return typeParams.getParamTypesArray();
                }
                return TypeConstant.NO_TYPES;
            }
            if (typeFunction.isA(this.typeMethod())) {
                TypeConstant typeParams;
                if (typeFunction.getParamsCount() > 2 && (typeParams = typeFunction.getParamType(2)).isTuple()) {
                    return typeParams.getParamTypesArray();
                }
                return TypeConstant.NO_TYPES;
            }
            if (typeFunction instanceof RelationalTypeConstant) {
                RelationalTypeConstant typeRel = (RelationalTypeConstant)typeFunction;
                TypeConstant[] atype1 = this.extractFunctionReturns(typeRel.getUnderlyingType());
                TypeConstant[] atype2 = this.extractFunctionReturns(typeRel.getUnderlyingType2());
                return atype2 == null ? atype1 : (atype1 == null ? atype2 : null);
            }
        }
        return null;
    }

    public boolean isConditionalReturn(TypeConstant typeFunction) {
        if (typeFunction != null && typeFunction.isA(this.typeFunction()) && typeFunction.getParamsCount() > 1) {
            return typeFunction.getParamType(1).isA(this.typeCondTuple());
        }
        return false;
    }

    public TypeConstant bindFunctionParam(TypeConstant typeFn, int iParam) {
        assert (typeFn.isA(this.typeFunction()) && typeFn.getParamsCount() > 0);
        TypeConstant typeP = typeFn.getParamType(0);
        TypeConstant typeR = typeFn.getParamType(1);
        int cParamsNew = typeP.getParamsCount() - 1;
        assert (typeP.isTuple() && iParam <= cParamsNew);
        TypeConstant[] atypeParams = typeP.getParamTypesArray();
        if (cParamsNew == 0) {
            typeP = this.typeTuple0();
        } else {
            TypeConstant[] atypeNew = new TypeConstant[cParamsNew];
            if (iParam > 0) {
                System.arraycopy(atypeParams, 0, atypeNew, 0, iParam);
            }
            if (iParam < cParamsNew) {
                System.arraycopy(atypeParams, iParam + 1, atypeNew, iParam, cParamsNew - iParam);
            }
            typeP = this.ensureTupleType(atypeNew);
        }
        return this.ensureParameterizedTypeConstant(this.typeFunction(), typeP, typeR);
    }

    public TypeConstant getNakedRefType() {
        return this.m_typeNakedRef;
    }

    public void setNakedRefType(TypeConstant typeNakedRef) {
        this.m_typeNakedRef = typeNakedRef;
    }

    public TypeInfo getNakedRefInfo(TypeConstant typeReferent) {
        return this.f_mapRefTypes.computeIfAbsent(typeReferent, this::computeNakedRefInfo);
    }

    private TypeInfo computeNakedRefInfo(TypeConstant typeReferent) {
        GenericTypeResolver resolver = sFormalName -> "Referent".equals(sFormalName) ? typeReferent : null;
        if (this.m_typeNakedRef == null) {
            throw new IllegalStateException("Mack module (javatools_turtle) is missing");
        }
        TypeInfo info = this.m_typeNakedRef.ensureTypeInfo();
        HashMap<Object, ParamInfo> mapTypeParams = new HashMap<Object, ParamInfo>();
        mapTypeParams.put("Referent", new ParamInfo("Referent", typeReferent, this.typeObject()));
        MethodConstant id = info.findMethods("get", 0, TypeInfo.MethodKind.Method).iterator().next();
        SignatureConstant sig = id.getSignature();
        MethodInfo method = info.getMethodById(id);
        MethodBody body = method.getHead();
        MethodConstant idNew = this.ensureMethodConstant(info.getIdentity(), sig.resolveGenericTypes(this, resolver));
        SignatureConstant sigNew = idNew.getSignature();
        MethodBody bodyNew = new MethodBody(idNew, sigNew, body.getImplementation(), null);
        MethodInfo methodNew = new MethodInfo(bodyNew, method.getRank());
        bodyNew.setMethodStructure(body.getMethodStructure());
        HashMap<MethodConstant, MethodInfo> mapMethods = new HashMap<MethodConstant, MethodInfo>(info.getMethods());
        mapMethods.remove(id);
        mapMethods.put(methodNew.getIdentity(), methodNew);
        HashMap<Object, MethodInfo> mapVirtMethods = new HashMap<Object, MethodInfo>(info.getVirtMethods());
        mapVirtMethods.remove(sig);
        mapVirtMethods.put(sigNew, methodNew);
        return new TypeInfo(info.getType(), 0, null, 0, true, mapTypeParams, Annotation.NO_ANNOTATIONS, Annotation.NO_ANNOTATIONS, null, null, null, Collections.emptyList(), ListMap.EMPTY, ListMap.EMPTY, Collections.emptyMap(), mapMethods, Collections.emptyMap(), mapVirtMethods, ListMap.EMPTY, null, TypeInfo.Progress.Complete);
    }

    public SingletonConstant valNull() {
        SingletonConstant c = this.m_valNull;
        if (c == null) {
            this.m_valNull = c = this.ensureSingletonConstConstant(this.clzNull());
        }
        return c;
    }

    public static ConstantPool getCurrentPool() {
        return s_tloPool.get()[0];
    }

    public static void setCurrentPool(ConstantPool pool) {
        ConstantPool.s_tloPool.get()[0] = pool;
    }

    public static Auto withPool(ConstantPool pool) {
        ConstantPool[] poolHolder = s_tloPool.get();
        ConstantPool pollPrior = poolHolder[0];
        poolHolder[0] = pool;
        return () -> {
            poolHolder[0] = pollPrior;
        };
    }

    private void optimize() {
        ArrayList<Constant> list = this.m_listConst;
        int cBefore = list.size();
        Constant[] aconst = new Constant[cBefore];
        int cAfter = 0;
        for (Constant constant : list) {
            if (constant.hasRefs()) {
                aconst[cAfter++] = constant;
                continue;
            }
            constant.setPosition(-1);
        }
        this.m_valEcstasy = null;
        this.m_clzObject = null;
        this.m_clzInner = null;
        this.m_clzOuter = null;
        this.m_clzRef = null;
        this.m_clzVar = null;
        this.m_clzClass = null;
        this.m_clzStruct = null;
        this.m_clzType = null;
        this.m_clzCloseable = null;
        this.m_clzConst = null;
        this.m_clzService = null;
        this.m_clzModule = null;
        this.m_clzPackage = null;
        this.m_clzEnum = null;
        this.m_clzEnumeration = null;
        this.m_clzEnumValue = null;
        this.m_clzException = null;
        this.m_clzProperty = null;
        this.m_clzMethod = null;
        this.m_clzFunction = null;
        this.m_clzNullable = null;
        this.m_clzCollection = null;
        this.m_clzSet = null;
        this.m_clzList = null;
        this.m_clzArray = null;
        this.m_clzMatrix = null;
        this.m_clzMap = null;
        this.m_clzOrderable = null;
        this.m_clzTuple = null;
        this.m_clzCondTuple = null;
        this.m_clzAuto = null;
        this.m_clzOp = null;
        this.m_clzRO = null;
        this.m_clzFinal = null;
        this.m_clzInject = null;
        this.m_clzAbstract = null;
        this.m_clzAtomic = null;
        this.m_clzConcurrent = null;
        this.m_clzSynchronized = null;
        this.m_clzFuture = null;
        this.m_clzOverride = null;
        this.m_clzLazy = null;
        this.m_clzTest = null;
        this.m_clzTransient = null;
        this.m_clzUnassigned = null;
        this.m_clzVolatile = null;
        this.m_typeObject = null;
        this.m_typeInner = null;
        this.m_typeOuter = null;
        this.m_typeRef = null;
        this.m_typeRefRB = null;
        this.m_typeVar = null;
        this.m_typeVarRB = null;
        this.m_typeStruct = null;
        this.m_typeType = null;
        this.m_typeClass = null;
        this.m_typeConst = null;
        this.m_typeConstRB = null;
        this.m_typeService = null;
        this.m_typeServiceRB = null;
        this.m_typeModule = null;
        this.m_typeModuleRB = null;
        this.m_typePackage = null;
        this.m_typePackageRB = null;
        this.m_typeEnumRB = null;
        this.m_typeEnumeration = null;
        this.m_typeEnumValue = null;
        this.m_typeException = null;
        this.m_typeException\u0967 = null;
        this.m_typeProperty = null;
        this.m_typeMethod = null;
        this.m_typeParameter = null;
        this.m_typeFunction = null;
        this.m_typeBoolean = null;
        this.m_typeTrue = null;
        this.m_typeFalse = null;
        this.m_typeCloseable = null;
        this.m_typeNullable = null;
        this.m_typeOrdered = null;
        this.m_typeNull = null;
        this.m_typeChar = null;
        this.m_typeIntLiteral = null;
        this.m_typeFPLiteral = null;
        this.m_typeRegEx = null;
        this.m_typeString = null;
        this.m_typeStringable = null;
        this.m_typeStringBuffer = null;
        this.m_typeString\u0967 = null;
        this.m_typeBit = null;
        this.m_typeNibble = null;
        this.m_typeBitArray = null;
        this.m_typeByteArray = null;
        this.m_typeBinary = null;
        this.m_typeInt8 = null;
        this.m_typeInt16 = null;
        this.m_typeInt32 = null;
        this.m_typeInt64 = null;
        this.m_typeInt128 = null;
        this.m_typeIntN = null;
        this.m_typeUInt8 = null;
        this.m_typeUInt16 = null;
        this.m_typeUInt32 = null;
        this.m_typeUInt64 = null;
        this.m_typeUInt128 = null;
        this.m_typeUIntN = null;
        this.m_typeDec64 = null;
        this.m_typeFloat32 = null;
        this.m_typeFloat64 = null;
        this.m_typeIndexed = null;
        this.m_typeArray = null;
        this.m_typeMatrix = null;
        this.m_typeCollection = null;
        this.m_typeSet = null;
        this.m_typeList = null;
        this.m_typeMap = null;
        this.m_typeSliceable = null;
        this.m_typeOrderable = null;
        this.m_typeSequential = null;
        this.m_typeNumber = null;
        this.m_typeFreezable = null;
        this.m_typeAutoFreezable = null;
        this.m_typeRange = null;
        this.m_typeInterval = null;
        this.m_typeIterable = null;
        this.m_typeIterator = null;
        this.m_typeTuple = null;
        this.m_typeTuple0 = null;
        this.m_typeCondTuple = null;
        this.m_typeDate = null;
        this.m_typeTimeOfDay = null;
        this.m_typeTime = null;
        this.m_typeTimeZone = null;
        this.m_typeDuration = null;
        this.m_typeVersion = null;
        this.m_typePath = null;
        this.m_typeFileStore = null;
        this.m_typeDirectory = null;
        this.m_typeFile = null;
        this.m_typeFileNode = null;
        this.m_val0 = null;
        this.m_valFalse = null;
        this.m_valTrue = null;
        this.m_valLesser = null;
        this.m_valEqual = null;
        this.m_valGreater = null;
        this.m_valNull = null;
        this.m_valDefault = null;
        this.m_sigToString = null;
        this.m_sigEquals = null;
        this.m_sigCompare = null;
        this.m_sigClose = null;
        this.m_sigValidator = null;
        this.m_infoPlaceholder = null;
        Arrays.sort(aconst, 0, cAfter, DEBUG ? Comparator.naturalOrder() : Constant.MFU_ORDER);
        list.clear();
        for (int i = 0; i < cAfter; ++i) {
            Constant constant;
            constant = aconst[i];
            constant.setPosition(i);
            list.add(constant);
        }
        this.m_mapConstants.clear();
        this.m_mapLocators.clear();
        this.f_implicits.clear();
    }

    static {
        try {
            ClassLoader loader = ConstantPool.class.getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            Source src = new Source(loader.getResourceAsStream("implicit.x"));
            ErrorList errs = new ErrorList(1);
            Parser parser = new Parser(src, errs);
            Map<String, String[]> mapImplicits = parser.parseImplicits();
            s_implicits = new HashMap<String, String[]>(mapImplicits);
            s_implicitsByPath = new HashMap<String, String>();
            for (Map.Entry<String, String[]> entry : mapImplicits.entrySet()) {
                StringBuilder sb = new StringBuilder();
                boolean fFirst = true;
                for (String sPart : entry.getValue()) {
                    if (fFirst) {
                        fFirst = false;
                    } else {
                        sb.append('.');
                    }
                    sb.append(sPart);
                }
                s_implicitsByPath.putIfAbsent(sb.toString(), entry.getKey());
            }
            for (ErrorListener.ErrorInfo err : errs.getErrors()) {
                System.err.println(err);
            }
            if (errs.hasSeriousErrors()) {
                throw new IllegalStateException();
            }
        }
        catch (Exception e) {
            RuntimeException ex;
            throw e instanceof RuntimeException ? (ex = (RuntimeException)e) : new RuntimeException(e);
        }
        NO_TYPES = TypeConstant.NO_TYPES;
        s_tloPool = ThreadLocal.withInitial(() -> new ConstantPool[1]);
    }
}

