/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.xvm.asm.FileStructure;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.VersionTree;

public class DirRepository
implements ModuleRepository {
    public static final FileFilter ModulesOnly = file -> file.getName().length() > 4 && file.getName().endsWith(".xtc") && file.exists() && file.isFile() && file.canRead() && file.length() > 0L;
    private final File m_dir;
    private final boolean m_fRO;
    private Map<File, ModuleInfo> modulesByFile = new HashMap<File, ModuleInfo>();
    private final Map<String, ModuleInfo> modulesByName = new TreeMap<String, ModuleInfo>();
    private long lastScan;

    public DirRepository(File dir, boolean fReadOnly) {
        assert (dir != null && dir.isDirectory());
        this.m_dir = dir;
        this.m_fRO = fReadOnly;
    }

    public File getDir() {
        return this.m_dir;
    }

    public boolean isReadOnly() {
        return this.m_fRO;
    }

    @Override
    public Set<String> getModuleNames() {
        this.ensureCache();
        return Collections.unmodifiableSet(this.modulesByName.keySet());
    }

    @Override
    public ModuleStructure loadModule(String sModule) {
        this.ensureCache();
        ModuleInfo info = this.modulesByName.get(sModule);
        return info == null ? null : info.ensureModule();
    }

    @Override
    public void storeModule(ModuleStructure module) throws IOException {
        File file;
        if (this.m_fRO) {
            throw new IOException("repository is read-only: " + String.valueOf(this));
        }
        String name = module.getIdentityConstant().getName();
        ModuleInfo info = this.modulesByName.get(name);
        File file2 = file = info == null ? new File(this.m_dir, module.getIdentityConstant().getUnqualifiedName() + ".xtc") : info.file;
        if (file.exists() && !file.delete()) {
            throw new IOException("unable to delete " + String.valueOf(file));
        }
        module.getFileStructure().writeTo(file);
        if (file.exists()) {
            info = new ModuleInfo(file);
            this.modulesByName.put(name, info);
            this.modulesByFile.put(file, info);
        } else {
            this.modulesByName.remove(name);
            this.modulesByFile.remove(file);
        }
    }

    public int hashCode() {
        return this.m_dir.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this || !(obj instanceof DirRepository)) {
            return obj == this;
        }
        DirRepository that = (DirRepository)obj;
        return this.m_dir.equals(that.m_dir) && this.m_fRO == that.m_fRO;
    }

    public String toString() {
        return "DirRepository(Path=" + this.m_dir.toString() + ", RO=" + this.m_fRO + ")";
    }

    protected void ensureCache() {
        File[] files;
        if (this.isCacheValid()) {
            return;
        }
        Map<File, ModuleInfo> oldModulesByFile = this.modulesByFile;
        HashMap<File, ModuleInfo> newModulesByFile = new HashMap<File, ModuleInfo>();
        this.modulesByFile = newModulesByFile;
        this.modulesByName.clear();
        for (File file : files = this.m_dir.listFiles(ModulesOnly)) {
            ModuleInfo info = oldModulesByFile.get(file);
            if (info == null || info.timestamp != file.lastModified() || info.size != file.length()) {
                info = new ModuleInfo(file);
            }
            newModulesByFile.put(file, info);
            if (info.err) continue;
            this.modulesByName.put(info.name, info);
        }
        this.lastScan = System.currentTimeMillis();
    }

    private boolean isCacheValid() {
        if (System.currentTimeMillis() < this.lastScan + 1000L) {
            return true;
        }
        File[] files = this.m_dir.listFiles(ModulesOnly);
        if (files == null || files.length != this.modulesByFile.size()) {
            return false;
        }
        for (File file : files) {
            ModuleInfo info = this.modulesByFile.get(file);
            if (info != null && info.timestamp == file.lastModified() && info.size == file.length()) continue;
            return false;
        }
        return true;
    }

    protected static class ModuleInfo {
        public final String name;
        public final File file;
        public final VersionTree<Boolean> versions;
        public final long timestamp;
        public final long size;
        public final boolean err;
        private transient ModuleStructure module;

        public ModuleInfo(File file) {
            this.file = file;
            this.timestamp = file.lastModified();
            this.size = file.length();
            ModuleStructure module = this.tryLoad();
            if (module == null) {
                this.name = null;
                this.versions = null;
                this.err = true;
            } else {
                this.name = module.getIdentityConstant().getName();
                this.versions = module.getVersions();
                this.err = false;
            }
        }

        ModuleStructure tryLoad() {
            try {
                FileStructure struct = new FileStructure(this.file);
                return struct.getModule();
            }
            catch (Exception e) {
                System.out.println("Error loading module from file: " + String.valueOf(this.file) + "; " + e.getMessage());
                return null;
            }
        }

        ModuleStructure ensureModule() {
            if (this.err) {
                return null;
            }
            if (this.module == null || this.module.isModified()) {
                this.module = this.tryLoad();
            }
            return this.module;
        }
    }
}

