/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.XvmStructure;
import org.xvm.compiler.ast.AstNode;
import org.xvm.util.Severity;

public class ErrorList
implements ErrorListener {
    private final int f_cMaxErrors;
    private int m_cErrors;
    private Severity m_severity = Severity.NONE;
    private final ArrayList<ErrorListener.ErrorInfo> f_list = new ArrayList();
    private final HashSet<String> f_setUID = new HashSet();

    public ErrorList(int cMaxErrors) {
        this.f_cMaxErrors = cMaxErrors;
    }

    @Override
    public ErrorListener branch(AstNode node) {
        return new BranchedErrorListener(this, this.f_cMaxErrors, node);
    }

    @Override
    public boolean log(ErrorListener.ErrorInfo err) {
        String uid = err.genUID();
        if (this.f_setUID.add(uid)) {
            Severity severity = err.getSeverity();
            if (severity.ordinal() > this.m_severity.ordinal()) {
                this.m_severity = severity;
            }
            this.f_list.add(err);
            if (severity.compareTo(Severity.ERROR) >= 0) {
                ++this.m_cErrors;
            }
        }
        return this.isAbortDesired();
    }

    @Override
    public boolean isAbortDesired() {
        return this.m_severity == Severity.FATAL || this.f_cMaxErrors > 0 && this.m_severity.compareTo(Severity.ERROR) >= 0 && this.m_cErrors >= this.f_cMaxErrors;
    }

    @Override
    public boolean hasSeriousErrors() {
        return this.hasEncountered(Severity.ERROR);
    }

    @Override
    public boolean hasError(String sCode) {
        return this.f_list.stream().anyMatch(info -> info.getCode().equals(sCode));
    }

    public Severity getSeverity() {
        return this.m_severity;
    }

    public int getSeriousErrorCount() {
        return this.m_cErrors;
    }

    public int getSeriousErrorMax() {
        return this.f_cMaxErrors;
    }

    public boolean hasErrors() {
        return !this.f_list.isEmpty();
    }

    public boolean hasEncountered(Severity sev) {
        return this.m_severity != null && this.m_severity.compareTo(sev) >= 0;
    }

    public List<ErrorListener.ErrorInfo> getErrors() {
        return this.f_list;
    }

    public void clear() {
        this.f_list.clear();
        this.m_cErrors = 0;
        this.m_severity = Severity.NONE;
    }

    public void logTo(ErrorListener errs) {
        for (ErrorListener.ErrorInfo err : this.getErrors()) {
            errs.log(err);
        }
    }

    public String toString() {
        if (this.m_cErrors == 0) {
            return "Empty";
        }
        return "Count=" + this.m_cErrors + ", Severity=" + this.m_severity.name() + ", Last=" + String.valueOf(this.f_list.get(this.f_list.size() - 1));
    }

    public static class BranchedErrorListener
    extends ErrorList {
        private final ErrorListener f_listener;
        private final AstNode f_node;

        public BranchedErrorListener(ErrorListener listener, int cMaxErrors, AstNode node) {
            super(cMaxErrors);
            this.f_listener = listener;
            this.f_node = node;
        }

        @Override
        public ErrorListener branch(AstNode node) {
            return new BranchedErrorListener(this, this.getSeriousErrorMax(), node == null ? this.f_node : node);
        }

        @Override
        public boolean log(Severity severity, String sCode, Object[] aoParam, XvmStructure xs) {
            return this.f_node == null ? super.log(severity, sCode, aoParam, xs) : this.log(severity, sCode, aoParam, this.f_node.getSource(), this.f_node.getStartPosition(), this.f_node.getEndPosition());
        }

        @Override
        public ErrorListener merge() {
            if (this.hasErrors()) {
                this.logTo(this.f_listener);
            }
            return this.f_listener;
        }

        @Override
        public boolean isSilent() {
            return this.f_listener.isSilent();
        }

        @Override
        public String toString() {
            return "Branched: " + super.toString();
        }
    }
}

