/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.lang.management.ManagementFactory;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.xvm.asm.ErrorList;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.compiler.Source;
import org.xvm.compiler.ast.AstNode;
import org.xvm.util.Handy;
import org.xvm.util.Severity;

@FunctionalInterface
public interface ErrorListener {
    public static final ResourceBundle RESOURCES = ResourceBundle.getBundle("errors");
    public static final ErrorListener BLACKHOLE = new BlackholeErrorListener();
    public static final ErrorListener RUNTIME = new RuntimeErrorListener();
    public static final boolean INTELLIJ_IDEA = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("IntelliJ");

    public boolean log(ErrorInfo var1);

    default public boolean log(Severity severity, String sCode, Object[] aoParam, Source source, long lPosStart, long lPosEnd) {
        return this.log(new ErrorInfo(severity, sCode, aoParam, source, lPosStart, lPosEnd));
    }

    default public boolean log(Severity severity, String sCode, Object[] aoParam, XvmStructure xs) {
        return this.log(new ErrorInfo(severity, sCode, aoParam, xs));
    }

    default public ErrorListener branch(AstNode node) {
        return new ErrorList.BranchedErrorListener(this, 1, node);
    }

    default public ErrorListener merge() {
        throw new UnsupportedOperationException("nothing to merge");
    }

    default public boolean isAbortDesired() {
        return false;
    }

    default public boolean hasSeriousErrors() {
        return false;
    }

    default public boolean hasError(String sCode) {
        return false;
    }

    default public boolean isSilent() {
        return false;
    }

    public static class ErrorInfo {
        private final Severity m_severity;
        private final String m_sCode;
        private final Object[] m_aoParam;
        private Source m_source;
        private long m_lPosStart;
        private long m_lPosEnd;
        private XvmStructure m_xs;

        public ErrorInfo(Severity severity, String sCode, Object[] aoParam, Source source, long lPosStart, long lPosEnd) {
            this.m_severity = severity;
            this.m_sCode = sCode;
            this.m_aoParam = aoParam;
            this.m_source = source;
            this.m_lPosStart = lPosStart;
            this.m_lPosEnd = lPosEnd;
        }

        public ErrorInfo(Severity severity, String sCode, Object[] aoParam, XvmStructure xs) {
            this.m_severity = severity;
            this.m_sCode = sCode;
            this.m_aoParam = aoParam;
            this.m_xs = xs;
        }

        public Severity getSeverity() {
            return this.m_severity;
        }

        public String getCode() {
            return this.m_sCode;
        }

        public Object[] getParams() {
            return this.m_aoParam;
        }

        public String getMessage() {
            return this.getCode() + ": " + this.getMessageText();
        }

        public String getMessageText() {
            return MessageFormat.format(RESOURCES.getString(this.getCode()), this.getParams());
        }

        public Source getSource() {
            return this.m_source;
        }

        public int getLine() {
            return Source.calculateLine(this.m_lPosStart);
        }

        public int getOffset() {
            return Source.calculateOffset(this.m_lPosStart);
        }

        public int getEndLine() {
            return Source.calculateLine(this.m_lPosEnd);
        }

        public int getEndOffset() {
            return Source.calculateOffset(this.m_lPosEnd);
        }

        public XvmStructure getXvmStructure() {
            return this.m_xs;
        }

        public String genUID() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.m_severity.ordinal()).append(':').append(this.m_sCode);
            if (this.m_aoParam != null) {
                sb.append('#').append(Arrays.hashCode(this.m_aoParam));
            }
            if (!this.m_sCode.startsWith("VERIFY")) {
                if (this.m_source != null) {
                    sb.append(':').append(this.m_source.getFileName()).append(':').append(this.m_lPosStart).append(':').append(this.m_lPosStart);
                }
                if (this.m_xs != null) {
                    sb.append(':').append(this.m_xs.getDescription());
                }
            }
            return sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.m_source != null) {
                String sFile = this.m_source.getFileName();
                if (sFile != null) {
                    if (INTELLIJ_IDEA) {
                        sb.append(sFile).append(" (").append(sFile.substring(sFile.lastIndexOf(47) + 1)).append(':').append(this.getLine() + 1).append(") ");
                    } else {
                        sb.append(sFile).append(':').append(this.getLine() + 1).append(' ');
                    }
                }
                sb.append("[").append(this.getLine() + 1).append(':').append(this.getOffset() + 1);
                if (this.getEndLine() != this.getLine() || this.getEndOffset() != this.getOffset()) {
                    sb.append("..").append(this.getEndLine() + 1).append(':').append(this.getEndOffset() + 1);
                }
                sb.append("] ");
            }
            for (XvmStructure xs = this.getXvmStructure(); xs != null; xs = xs.getContaining()) {
                IdentityConstant constId = xs.getIdentityConstant();
                if (constId == null) {
                    continue;
                }
                sb.append("[").append(constId).append("] ");
                break;
            }
            sb.append(this.getMessage());
            if (this.m_source != null && this.m_lPosStart != this.m_lPosEnd) {
                Object sSource = this.m_source.toString(this.m_lPosStart, this.m_lPosEnd);
                if (((String)sSource).length() > 80) {
                    sSource = ((String)sSource).substring(0, 77) + "...";
                }
                sb.append(" (").append(Handy.quotedString((String)sSource)).append(')');
            }
            return sb.toString();
        }
    }

    public static class BlackholeErrorListener
    implements ErrorListener {
        @Override
        public boolean log(ErrorInfo err) {
            return false;
        }

        @Override
        public ErrorListener merge() {
            return this;
        }

        @Override
        public boolean isSilent() {
            return true;
        }

        public String toString() {
            return "(Blackhole)";
        }
    }

    public static class RuntimeErrorListener
    implements ErrorListener {
        @Override
        public boolean log(ErrorInfo err) {
            String s = err.toString();
            if (err.getSeverity().ordinal() >= Severity.ERROR.ordinal()) {
                throw new IllegalStateException(s);
            }
            System.out.println(String.valueOf((Object)err.getSeverity()) + ": " + s);
            return false;
        }

        public String toString() {
            return "(Runtime error listener)";
        }
    }
}

