/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.xvm.asm.FileStructure;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.VersionTree;

public class FileRepository
implements ModuleRepository {
    private final File file;
    private final boolean fRO;
    private String name;
    private VersionTree<Boolean> versions;
    private long timestamp;
    private long size;
    private ModuleStructure module;
    private long lastScan;
    private boolean err;

    public FileRepository(File file, boolean fReadOnly) {
        assert (file != null && !file.isDirectory());
        String sName = file.getName();
        if (!sName.endsWith(".xtc")) {
            file = sName.endsWith(".x") ? new File(file.getParentFile(), sName.substring(0, sName.lastIndexOf(46)) + ".xtc") : new File(file.getParentFile(), sName + ".xtc");
        }
        this.file = file;
        this.fRO = fReadOnly;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isReadOnly() {
        return this.fRO;
    }

    @Override
    public Set<String> getModuleNames() {
        this.checkCache();
        return this.file.exists() && this.name != null ? Collections.singleton(this.name) : Collections.emptySet();
    }

    @Override
    public VersionTree<Boolean> getAvailableVersions(String sModule) {
        this.checkCache();
        return !this.err && this.name.equals(sModule) ? this.versions : null;
    }

    @Override
    public ModuleStructure loadModule(String sModule) {
        ModuleStructure module = this.checkCache();
        if (sModule.equals(this.name)) {
            return module == null ? this.ensureModule() : module;
        }
        return null;
    }

    @Override
    public void storeModule(ModuleStructure module) throws IOException {
        if (this.fRO) {
            throw new IOException("repository is read-only: " + String.valueOf(this));
        }
        if (this.file.exists() && !this.file.delete()) {
            this.err = true;
            throw new IOException("unable to delete " + String.valueOf(this.file));
        }
        try {
            module.getFileStructure().writeTo(this.file);
            this.err = false;
        }
        catch (IOException e) {
            this.err = true;
            throw new IOException("Error writing module to file: " + String.valueOf(this.file));
        }
        this.name = module.getIdentityConstant().getName();
        this.versions = module.getVersions();
        this.timestamp = this.file.lastModified();
        this.size = this.file.length();
        this.module = module;
        this.lastScan = System.currentTimeMillis();
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this || !(obj instanceof FileRepository)) {
            return obj == this;
        }
        FileRepository that = (FileRepository)obj;
        return this.file.equals(that.file) && this.fRO == that.fRO;
    }

    public String toString() {
        return "FileRepository(Path=" + this.file.toString() + ", RO=" + this.fRO + ")";
    }

    ModuleStructure checkCache() {
        if (this.isCacheValid()) {
            return this.module;
        }
        this.timestamp = this.file.lastModified();
        this.size = this.file.length();
        this.err = false;
        ModuleStructure module = this.tryLoad();
        if (module == null) {
            this.name = null;
            this.versions = null;
            this.err = true;
        } else {
            this.name = module.getIdentityConstant().getName();
            this.versions = module.getVersions();
        }
        this.module = null;
        this.lastScan = System.currentTimeMillis();
        return module;
    }

    private boolean isCacheValid() {
        if (System.currentTimeMillis() < this.lastScan + 1000L) {
            return true;
        }
        if (!this.file.exists()) {
            this.name = null;
            this.module = null;
            return true;
        }
        return this.name != null && this.timestamp == this.file.lastModified() && this.size == this.file.length();
    }

    private ModuleStructure ensureModule() {
        if (this.err) {
            return null;
        }
        if (this.module == null || this.module.isModified()) {
            this.module = this.tryLoad();
        }
        return this.module;
    }

    private ModuleStructure tryLoad() {
        try {
            FileStructure struct = new FileStructure(this.file);
            return struct.getModule();
        }
        catch (Exception e) {
            System.out.println("Error loading module from file: " + String.valueOf(this.file) + "; " + e.getMessage());
            this.err = true;
            return null;
        }
    }
}

