/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.xvm.asm.AssemblerContext;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.LinkerContext;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.XvmStructure;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.util.Auto;
import org.xvm.util.Handy;
import org.xvm.util.LinkedIterator;

public class FileStructure
extends Component {
    private File m_file;
    private boolean m_fLazyDeser;
    private boolean m_fLinked;
    private ModuleConstant m_idModule;
    private final Map<ModuleConstant, ModuleStructure> f_moduleById = new HashMap<ModuleConstant, ModuleStructure>();
    private ConstantPool m_pool;
    private AssemblerContext m_ctx;
    private int m_nMajorVer;
    private int m_nMinorVer;
    private transient ErrorListener m_errs;

    public FileStructure(String sModule) {
        super(null, Constants.Access.PUBLIC, true, true, true, Component.Format.FILE, null, null);
        if (sModule == null) {
            throw new IllegalArgumentException("module name required");
        }
        ConstantPool pool = new ConstantPool(this);
        ModuleConstant idModule = pool.ensureModuleConstant(sModule);
        ModuleStructure module = new ModuleStructure(this, idModule);
        module.setTimestamp(pool.ensureTimeConstant(Instant.now()));
        if (!this.addChild(module)) {
            throw new IllegalStateException("module already exists");
        }
        this.m_pool = pool;
        this.m_idModule = idModule;
        this.m_nMajorVer = VERSION_MAJOR_CUR;
        this.m_nMinorVer = VERSION_MINOR_CUR;
    }

    public FileStructure(File file) throws IOException {
        this(file, true);
    }

    public FileStructure(File file, boolean fLazy) throws IOException {
        this(Handy.toInputStream(file), true, fLazy);
        this.m_file = file;
    }

    public FileStructure(InputStream in) throws IOException {
        this(in, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStructure(InputStream in, boolean fAutoClose, boolean fLazy) throws IOException {
        super(null, Constants.Access.PUBLIC, true, true, true, Component.Format.FILE, null, null);
        this.m_fLazyDeser = fLazy;
        try {
            this.disassemble(new DataInputStream(in));
        }
        finally {
            if (fAutoClose) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public FileStructure(ModuleStructure module, boolean fSynthesize) {
        super(null, Constants.Access.PUBLIC, true, true, true, Component.Format.FILE, null, null);
        FileStructure fileStructure = module.getFileStructure();
        this.m_nMajorVer = fileStructure.m_nMajorVer;
        this.m_nMinorVer = fileStructure.m_nMinorVer;
        this.m_pool = new ConstantPool(this);
        this.merge(module, fSynthesize, true);
    }

    public void merge(ModuleStructure module, boolean fSynthesize, boolean fTakeFile) {
        ModuleStructure moduleClone = module.cloneBody();
        moduleClone.setContaining(this);
        this.addChild(moduleClone);
        moduleClone.cloneChildren(module.children());
        ConstantPool pool = this.m_pool;
        try (Auto ignore = ConstantPool.withPool(pool);){
            TypeConstant typeNakedRef;
            for (ModuleStructure moduleStructure : module.getFileStructure().children()) {
                if (!moduleStructure.isFingerprint() || this.getModule(moduleStructure.getIdentityConstant()) != null) continue;
                ModuleStructure moduleChildClone = moduleStructure.cloneBody();
                moduleChildClone.setContaining(this);
                this.addChild(moduleChildClone);
                moduleChildClone.registerConstants(pool);
            }
            moduleClone.registerConstants(pool);
            moduleClone.registerChildrenConstants(pool);
            if (fSynthesize) {
                moduleClone.synthesizeChildren();
            }
            if ((typeNakedRef = module.getConstantPool().getNakedRefType()) != null) {
                pool.setNakedRefType(typeNakedRef);
            }
        }
        if (fTakeFile) {
            this.m_idModule = moduleClone.getIdentityConstant();
            this.m_file = module.getFileStructure().m_file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            try {
                this.writeTo(bos);
            }
            finally {
                bos.flush();
                bos.close();
            }
        }
        finally {
            fos.flush();
            fos.close();
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        this.writeTo(new DataOutputStream(out));
    }

    public void writeTo(DataOutput out) throws IOException {
        this.reregisterConstants(true);
        this.assemble(out);
        this.resetModified();
    }

    public ModuleStructure getModule() {
        return (ModuleStructure)this.getChild(this.m_idModule);
    }

    public ModuleConstant getModuleId() {
        return this.m_idModule;
    }

    public Set<ModuleConstant> moduleIds() {
        Set<ModuleConstant> setIds = this.f_moduleById.keySet();
        assert ((setIds = Collections.unmodifiableSet(setIds)) != null);
        return setIds;
    }

    public ModuleStructure getModule(ModuleConstant id) {
        return this.f_moduleById.get(id);
    }

    public ModuleStructure ensureModule(String sName) {
        return this.ensureModule(this.m_pool.ensureModuleConstant(sName));
    }

    public ModuleStructure ensureModule(ModuleConstant id) {
        ModuleStructure module = this.getModule(id);
        if (module == null) {
            module = new ModuleStructure(this, id);
            this.addChild(module);
        }
        return module;
    }

    public ModuleStructure findModule(String sName) {
        for (ModuleStructure module : this.f_moduleById.values()) {
            if (!module.getName().equals(sName)) continue;
            return module;
        }
        return null;
    }

    public ModuleConstant linkModules(ModuleRepository repository, boolean fRuntime) {
        if (fRuntime && this.m_fLinked) {
            return null;
        }
        ModuleConstant idMissing = this.findMissing(repository, new HashSet<String>(), fRuntime);
        if (idMissing == null && (idMissing = this.linkModules(repository, this, new HashSet<ModuleConstant>(), fRuntime)) == null) {
            this.markLinked();
        }
        return idMissing;
    }

    private ModuleConstant findMissing(ModuleRepository repository, Set<String> setFilesChecked, boolean fRuntime) {
        if (!setFilesChecked.add(this.getModuleId().getName())) {
            return null;
        }
        ArrayList<FileStructure> listFilesTodo = new ArrayList<FileStructure>();
        ArrayList<ModuleConstant> listModulesTodo = new ArrayList<ModuleConstant>(this.moduleIds());
        HashSet<ModuleConstant> setModulesDone = new HashSet<ModuleConstant>();
        setModulesDone.add(this.getModuleId());
        for (ModuleConstant idModule : listModulesTodo) {
            if (!setModulesDone.add(idModule)) continue;
            ModuleStructure moduleFingerprint = this.getModule(idModule);
            assert (moduleFingerprint != null);
            if (moduleFingerprint.isLinked()) continue;
            String sModule = idModule.getName();
            if (repository.getModuleNames().contains(sModule)) {
                if (fRuntime) continue;
                ModuleStructure moduleUnlinked = repository.loadModule(sModule, idModule.getVersion(), !fRuntime);
                assert (moduleUnlinked != null);
                FileStructure fileUnlinked = moduleUnlinked.getFileStructure();
                if (setFilesChecked.contains(sModule)) continue;
                listFilesTodo.add(fileUnlinked);
                continue;
            }
            return idModule;
        }
        for (FileStructure fileDownstream : listFilesTodo) {
            assert (!fRuntime);
            ModuleConstant idMissing = fileDownstream.findMissing(repository, setFilesChecked, false);
            if (idMissing == null) continue;
            return idMissing;
        }
        return null;
    }

    private ModuleConstant linkModules(ModuleRepository repository, FileStructure fileTop, Set<ModuleConstant> setFilesDone, boolean fRuntime) {
        if (!setFilesDone.add(this.getModuleId())) {
            return null;
        }
        ArrayList<FileStructure> listFilesTodo = new ArrayList<FileStructure>();
        ArrayList<ModuleStructure> listReplace = new ArrayList<ModuleStructure>();
        ArrayList<ModuleConstant> listModulesTodo = new ArrayList<ModuleConstant>(this.moduleIds());
        HashSet<ModuleConstant> setModulesDone = new HashSet<ModuleConstant>();
        setModulesDone.add(this.getModuleId());
        for (int iNextTodo = 0; iNextTodo < listModulesTodo.size(); ++iNextTodo) {
            ModuleConstant idModule = (ModuleConstant)listModulesTodo.get(iNextTodo);
            if (!setModulesDone.add(idModule)) continue;
            ModuleStructure moduleFingerprint = this.getModule(idModule);
            if (moduleFingerprint == null) {
                return idModule;
            }
            ModuleStructure moduleUnlinked = repository.loadModule(idModule.getName(), idModule.getVersion(), !fRuntime);
            if (moduleUnlinked == null) {
                return idModule;
            }
            FileStructure fileUnlinked = moduleUnlinked.getFileStructure();
            if (idModule.getVersion() != null) {
                moduleUnlinked.registerConstants(fileTop.m_pool);
                moduleUnlinked.registerChildrenConstants(fileTop.m_pool);
            }
            if (fRuntime) {
                if (!moduleFingerprint.isFingerprint()) continue;
                listReplace.add(moduleUnlinked);
                listModulesTodo.addAll(fileUnlinked.moduleIds());
                continue;
            }
            if (!moduleFingerprint.isLinked()) {
                moduleFingerprint.setFingerprintOrigin(moduleUnlinked);
            }
            if (fileTop.getModule(idModule) == null) {
                fileTop.addChild(moduleFingerprint);
            }
            if (setFilesDone.contains(idModule)) continue;
            listFilesTodo.add(fileUnlinked);
        }
        if (!listReplace.isEmpty()) {
            assert (fRuntime);
            this.replace(listReplace);
        }
        for (FileStructure fileDownstream : listFilesTodo) {
            assert (!fRuntime);
            ModuleConstant idMissing = fileDownstream.linkModules(repository, fileTop, setFilesDone, false);
            if (idMissing == null) continue;
            return idMissing;
        }
        return null;
    }

    public void replace(List<ModuleStructure> listUnlinked) {
        ArrayList<ModuleStructure> listLinked = new ArrayList<ModuleStructure>();
        for (ModuleStructure moduleUnlinked : listUnlinked) {
            ModuleStructure moduleLinked = moduleUnlinked.cloneBody();
            moduleLinked.setContaining(this);
            moduleLinked.cloneChildren(moduleUnlinked.children());
            this.replaceChild(this.getModule(moduleLinked.getIdentityConstant()), moduleLinked);
            listLinked.add(moduleLinked);
        }
        ConstantPool pool = this.m_pool;
        for (ModuleStructure moduleLinked : listLinked) {
            moduleLinked.registerConstants(pool);
            moduleLinked.registerChildrenConstants(pool);
        }
        for (ModuleStructure moduleLinked : listLinked) {
            moduleLinked.synthesizeChildren();
        }
    }

    public boolean isLinked() {
        return this.m_fLinked;
    }

    public void markLinked() {
        this.m_fLinked = true;
    }

    public AssemblerContext getContext() {
        return this.m_ctx;
    }

    protected AssemblerContext ensureContext() {
        AssemblerContext ctx = this.m_ctx;
        if (ctx == null) {
            this.m_ctx = ctx = new AssemblerContext(this.m_pool);
        }
        return ctx;
    }

    public int getFileMajorVersion() {
        return this.m_nMajorVer;
    }

    public int getFileMinorVersion() {
        return this.m_nMinorVer;
    }

    public File getOSFile() {
        return this.m_file;
    }

    public static int getToolMajorVersion() {
        return VERSION_MAJOR_CUR;
    }

    public static int getToolMinorVersion() {
        return VERSION_MINOR_CUR;
    }

    public static boolean isFileVersionSupported(int nVerMajor, int nVerMinor) {
        if (nVerMajor == VERSION_MAJOR_CUR && nVerMinor == VERSION_MINOR_CUR) {
            return true;
        }
        if (nVerMajor > VERSION_MAJOR_CUR) {
            return false;
        }
        return false;
    }

    public ModuleStructure replaceModuleId(ModuleConstant idNew) {
        ModuleStructure module = this.getModule();
        ModuleConstant idOld = module.getIdentityConstant();
        idNew = (ModuleConstant)this.m_pool.register(idNew);
        module.replaceThisIdentityConstant(idNew);
        this.f_moduleById.put(idNew, module);
        this.m_pool.replaceModule(idOld, idNew);
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        try {
            this.assemble(new DataOutputStream(outBytes));
            FileStructure fileStructure = new FileStructure(new DataInputStream(new ByteArrayInputStream(outBytes.toByteArray())));
            return fileStructure.getModule();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return this.m_file == null ? this.getModuleId().getUnqualifiedName() + ".xtc" : this.m_file.getName();
    }

    @Override
    public boolean isGloballyVisible() {
        return false;
    }

    @Override
    protected boolean isSiblingAllowed() {
        return false;
    }

    @Override
    protected void replaceChildIdentityConstant(IdentityConstant idOld, IdentityConstant idNew) {
        assert (idOld instanceof ModuleConstant);
        assert (idNew instanceof ModuleConstant);
        Map<ModuleConstant, ModuleStructure> map = this.f_moduleById;
        ModuleStructure child = map.remove(idOld);
        if (child != null) {
            map.put((ModuleConstant)idNew, child);
        }
        if (this.m_idModule.equals(idOld)) {
            this.m_idModule = (ModuleConstant)idNew;
        }
    }

    @Override
    public Map<String, Component> getChildByNameMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Component> ensureChildByNameMap() {
        return this.getChildByNameMap();
    }

    @Override
    public boolean addChild(Component child) {
        assert (child instanceof ModuleStructure);
        Map<ModuleConstant, ModuleStructure> kids = this.f_moduleById;
        ModuleStructure module = (ModuleStructure)child;
        ModuleConstant id = module.getIdentityConstant();
        ModuleStructure sibling = kids.get(id);
        if (sibling == null) {
            kids.put(id, module);
        } else if (this.isSiblingAllowed()) {
            this.linkSibling(module, sibling);
        } else {
            return false;
        }
        this.markModified();
        return true;
    }

    @Override
    public void removeChild(Component child) {
        assert (child instanceof ModuleStructure);
        assert (child.getParent() == this);
        Map<ModuleConstant, ModuleStructure> kids = this.f_moduleById;
        ModuleStructure module = (ModuleStructure)child;
        ModuleConstant id = module.getIdentityConstant();
        ModuleStructure sibling = kids.remove(id);
        this.unlinkSibling(kids, id, module, sibling);
    }

    @Override
    protected void replaceChild(Component childOld, Component childNew) {
        assert (childOld instanceof ModuleStructure);
        assert (childNew instanceof ModuleStructure);
        assert (childNew.getParent() == this);
        assert (childOld.getIdentityConstant().equals(childNew.getIdentityConstant()));
        ModuleStructure module = (ModuleStructure)childNew;
        this.f_moduleById.put(module.getIdentityConstant(), module);
    }

    @Override
    public Component getChild(Constant constId) {
        Component component;
        if (constId instanceof ModuleConstant) {
            ModuleConstant idModule = (ModuleConstant)constId;
            component = this.f_moduleById.get(idModule);
        } else {
            component = null;
        }
        return component;
    }

    @Override
    public ModuleStructure getChild(String sName) {
        return this.f_moduleById.get(new ModuleConstant(this.m_pool, sName));
    }

    @Override
    public int getChildrenCount() {
        this.ensureChildren();
        return this.f_moduleById.size();
    }

    @Override
    public boolean hasChildren() {
        return this.getChildrenCount() > 0;
    }

    public Collection<? extends ModuleStructure> children() {
        return this.f_moduleById.values();
    }

    @Override
    public FileStructure getFileStructure() {
        return this;
    }

    @Override
    public ConstantPool getConstantPool() {
        return this.m_pool;
    }

    @Override
    public Iterator<? extends XvmStructure> getContained() {
        return new LinkedIterator(Collections.singleton(this.m_pool).iterator(), this.children().iterator());
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public boolean isPresent(LinkerContext ctx) {
        return true;
    }

    @Override
    protected void disassemble(DataInput in) throws IOException {
        ConstantPool pool;
        int nMagic = in.readInt();
        if (nMagic != -329800210) {
            throw new IOException("not an .xtc format file; invalid magic header: " + Handy.intToHexString(nMagic));
        }
        this.m_nMajorVer = in.readInt();
        this.m_nMinorVer = in.readInt();
        if (!FileStructure.isFileVersionSupported(this.m_nMajorVer, this.m_nMinorVer)) {
            throw new IOException("unsupported version: " + this.m_nMajorVer + "." + this.m_nMinorVer);
        }
        this.m_pool = pool = new ConstantPool(this);
        pool.disassemble(in);
        this.m_idModule = (ModuleConstant)pool.getConstant(Handy.readIndex(in));
        this.disassembleChildren(in, this.m_fLazyDeser);
        if (this.getModule() == null) {
            throw new IOException("the file does not contain a primary module");
        }
    }

    public void reregisterConstants(boolean fOptimize) {
        ConstantPool pool = this.m_pool;
        pool.preRegisterAll();
        this.registerConstants(pool);
        pool.postRegisterAll(fOptimize);
    }

    @Override
    protected void registerConstants(ConstantPool pool) {
        pool.registerConstants(pool);
        this.registerChildrenConstants(pool);
    }

    @Override
    protected void assemble(DataOutput out) throws IOException {
        out.writeInt(-329800210);
        out.writeInt(VERSION_MAJOR_CUR);
        out.writeInt(VERSION_MINOR_CUR);
        this.m_pool.assemble(out);
        Handy.writePackedLong(out, this.getModuleId().getPosition());
        this.assembleChildren(out);
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        String sName = this.getModuleId().getName();
        sb.append("main-module=").append(sName);
        boolean first = true;
        for (ModuleConstant id : this.moduleIds()) {
            if (id.getName().equals(sName)) continue;
            if (first) {
                sb.append(", other-modules={");
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(id.getName());
        }
        if (!first) {
            sb.append('}');
        }
        sb.append(", xvm-version=").append(this.getFileMajorVersion()).append('.').append(this.getFileMinorVersion()).append(", ").append(super.getDescription());
        return sb.toString();
    }

    @Override
    protected void dump(PrintWriter out, String sIndent) {
        out.print(sIndent);
        out.println(this);
        ConstantPool pool = this.m_pool;
        if (pool != null) {
            pool.dump(out, this.nextIndent(sIndent));
        }
        this.dumpChildren(out, sIndent);
    }

    public boolean validateConstants() {
        assert (this.m_pool.getNakedRefType() != null);
        Consumer<Component> visitor = component -> {
            MethodStructure method;
            Constant[] aconst;
            if (component instanceof ClassStructure) {
                component.getContributionsAsList().forEach(contrib -> {
                    assert (contrib.getTypeConstant().getConstantPool() == this.m_pool);
                });
            } else if (component instanceof MethodStructure && (aconst = (method = (MethodStructure)component).getLocalConstants()) != null) {
                for (Constant constant : aconst) {
                    assert (constant.getConstantPool() == this.m_pool);
                }
            }
        };
        this.visitChildren(visitor, false, true);
        return true;
    }

    @Override
    public ErrorListener getErrorListener() {
        ConstantPool poolCurrent;
        ErrorListener errs = this.m_errs;
        if (errs == null && (poolCurrent = ConstantPool.getCurrentPool()) != this.m_pool) {
            errs = poolCurrent.getErrorListener();
        }
        return errs == null ? ErrorListener.RUNTIME : errs;
    }

    @Override
    public void setErrorListener(ErrorListener errs) {
        this.m_errs = errs;
    }

    @Override
    public int hashCode() {
        return this.getModule().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileStructure) {
            FileStructure that = (FileStructure)obj;
            return this.m_nMajorVer == that.m_nMajorVer && this.m_nMinorVer == that.m_nMinorVer && this.m_idModule.equals(that.m_idModule) && this.f_moduleById.equals(that.f_moduleById);
        }
        return false;
    }
}

