/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.util.Map;
import org.xvm.asm.constants.FormalConstant;
import org.xvm.asm.constants.TypeConstant;

@FunctionalInterface
public interface GenericTypeResolver {
    public TypeConstant resolveGenericType(String var1);

    default public TypeConstant resolveFormalType(FormalConstant constFormal) {
        return this.resolveGenericType(constFormal.getName());
    }

    public static GenericTypeResolver of(Map<FormalConstant, TypeConstant> mapResolve) {
        return new TypeParameterResolver(mapResolve);
    }

    public static class TypeParameterResolver
    implements GenericTypeResolver {
        Map<FormalConstant, TypeConstant> mapResolve;

        public TypeParameterResolver(Map<FormalConstant, TypeConstant> mapResolve) {
            this.mapResolve = mapResolve;
        }

        @Override
        public TypeConstant resolveGenericType(String sFormalName) {
            return null;
        }

        @Override
        public TypeConstant resolveFormalType(FormalConstant constFormal) {
            return this.mapResolve.get(constFormal);
        }
    }
}

