/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.xvm.asm.FileStructure;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.Version;
import org.xvm.asm.VersionTree;

public class LinkedRepository
implements ModuleRepository {
    private final ModuleRepository[] repos;
    private final boolean readThrough;

    public LinkedRepository(ModuleRepository ... repos) {
        this(false, repos);
    }

    public LinkedRepository(boolean fReadThrough, ModuleRepository ... repos) {
        assert (repos != null && repos.length > 0);
        for (ModuleRepository repo : repos) {
            assert (repo != null);
        }
        this.repos = (ModuleRepository[])repos.clone();
        this.readThrough = fReadThrough;
    }

    public List<ModuleRepository> asList() {
        return List.of(this.repos);
    }

    @Override
    public Set<String> getDomainNames() {
        TreeSet<String> names = new TreeSet<String>();
        for (ModuleRepository repo : this.repos) {
            names.addAll(repo.getDomainNames());
        }
        return names;
    }

    @Override
    public Set<String> getModuleNames(String sDomain) {
        TreeSet<String> names = new TreeSet<String>();
        for (ModuleRepository repo : this.repos) {
            names.addAll(repo.getModuleNames(sDomain));
        }
        return names;
    }

    @Override
    public Set<String> getModuleNames() {
        TreeSet<String> names = new TreeSet<String>();
        for (ModuleRepository repo : this.repos) {
            names.addAll(repo.getModuleNames());
        }
        return names;
    }

    @Override
    public VersionTree<Boolean> getAvailableVersions(String sModule) {
        VersionTree<Boolean> vers = new VersionTree<Boolean>();
        for (ModuleRepository repo : this.repos) {
            for (Version ver : repo.getAvailableVersions(sModule)) {
                vers.put(ver, true);
            }
        }
        return vers;
    }

    @Override
    public ModuleStructure loadModule(String sModule) {
        int c = this.repos.length;
        for (int i = 0; i < c; ++i) {
            ModuleRepository repo = this.repos[i];
            ModuleStructure module = repo.loadModule(sModule);
            if (module == null) continue;
            if (i > 0 && this.readThrough) {
                try {
                    FileStructure fileClone = new FileStructure(module, false);
                    module = fileClone.getModule();
                    this.repos[0].storeModule(module);
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                    break;
                }
            }
            return module;
        }
        return null;
    }

    @Override
    public ModuleStructure loadModule(String sModule, Version version, boolean fExact) {
        int c = this.repos.length;
        for (int i = 0; i < c; ++i) {
            ModuleRepository repo = this.repos[i];
            ModuleStructure module = repo.loadModule(sModule, version, fExact);
            if (module == null) continue;
            if (i > 0 && this.readThrough) {
                try {
                    this.repos[0].storeModule(module);
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                    break;
                }
            }
            return module;
        }
        return null;
    }

    @Override
    public void storeModule(ModuleStructure module) throws IOException {
        this.repos[0].storeModule(module);
    }
}

